/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import java.nio.charset.StandardCharsets;
import org.noear.snack.ONode;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitTransactionListener;
import org.noear.solon.cloud.model.Event;

public class RabbitProducer {
    private RabbitConfig config;
    private Channel channelDefault;
    private AMQP.BasicProperties eventPropsDefault;

    public RabbitProducer(RabbitConfig config, Channel channel) {
        this.config = config;
        this.channelDefault = channel;
        this.eventPropsDefault = this.newEventProps().build();
    }

    public AMQP.BasicProperties.Builder newEventProps() {
        return new AMQP.BasicProperties().builder().deliveryMode(Integer.valueOf(2)).contentEncoding("UTF-8").contentType("application/json");
    }

    public boolean publish(Event event, String topic, long delay) throws Exception {
        byte[] event_data = ONode.stringify((Object)event).getBytes(StandardCharsets.UTF_8);
        AMQP.BasicProperties props = delay > 0L ? this.newEventProps().expiration(String.valueOf(delay)).build() : this.eventPropsDefault;
        Channel channel = null;
        channel = event.tran() == null ? this.channelDefault : ((RabbitTransactionListener)event.tran().getListener(RabbitTransactionListener.class)).getTransaction();
        String string = this.config.exchangeName;
        this.config.getClass();
        channel.basicPublish(string, topic, false, props, event_data);
        if (this.config.publishTimeout > 0L && event.tran() == null) {
            return channel.waitForConfirms(this.config.publishTimeout);
        }
        return true;
    }

    public boolean publish(Event event, String topic) throws Exception {
        long delay = 0L;
        if (event.scheduled() != null) {
            delay = event.scheduled().getTime() - System.currentTimeMillis();
        }
        if (delay > 0L) {
            return this.publish(event, this.config.queue_ready, delay);
        }
        if (this.config.exchangeType == BuiltinExchangeType.FANOUT) {
            return this.publish(event, "", 0L);
        }
        return this.publish(event, topic, 0L);
    }
}

