/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.BuiltinExchangeType;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitConfig {
    static final Logger log = LoggerFactory.getLogger(RabbitConfig.class);
    public final String virtualHost;
    public final String exchangeName;
    public final BuiltinExchangeType exchangeType = BuiltinExchangeType.DIRECT;
    public final boolean durable = true;
    public final boolean autoDelete = false;
    public final boolean internal = false;
    public final boolean mandatory = false;
    public final boolean immediate = false;
    public final boolean exclusive = false;
    public final String server;
    public final String username;
    public final String password;
    public final String queue_normal;
    public final String queue_ready;
    public final String queue_retry;
    public final long publishTimeout;
    public final int prefetchCount;
    private final CloudProps cloudProps;

    public RabbitConfig(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        this.publishTimeout = cloudProps.getEventPublishTimeout();
        this.prefetchCount = this.getPrefetchCountInternal();
        this.server = cloudProps.getEventServer();
        this.username = cloudProps.getEventUsername();
        this.password = cloudProps.getEventPassword();
        this.virtualHost = this.getVirtualHostInternal();
        this.exchangeName = this.getEventExchangeInternal();
        String queueName = this.getEventQueueInternal();
        if (Utils.isEmpty((String)queueName)) {
            queueName = this.exchangeName + "_" + Solon.cfg().appName();
        }
        this.queue_normal = queueName + "@normal";
        this.queue_ready = queueName + "@ready";
        this.queue_retry = queueName + "@retry";
        log.trace("queue_normal=" + this.queue_normal);
        log.trace("queue_ready=" + this.queue_ready);
        log.trace("queue_retry=" + this.queue_retry);
    }

    public String getEventChannel() {
        return this.cloudProps.getEventChannel();
    }

    private int getPrefetchCountInternal() {
        int tmp = this.cloudProps.getEventPrefetchCount();
        if (tmp < 1) {
            tmp = 10;
        }
        return tmp;
    }

    private String getVirtualHostInternal() {
        String tmp = this.cloudProps.getValue("event.virtualHost");
        if (Utils.isEmpty((String)tmp)) {
            return this.cloudProps.getNamespace();
        }
        return tmp;
    }

    private String getEventExchangeInternal() {
        String tmp = this.cloudProps.getValue("event.exchange");
        if (Utils.isEmpty((String)tmp)) {
            return Solon.cfg().appGroup();
        }
        return tmp;
    }

    private String getEventQueueInternal() {
        return this.cloudProps.getValue("event.queue");
    }
}

