/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.noear.redisx.RedisClient;
import org.noear.redisx.utils.AssertUtil;

public class RedisBucket {
    private final RedisClient client;

    public RedisBucket(RedisClient client) {
        this.client = client;
    }

    public void store(String key, String val, int inSeconds) {
        this.client.open(s -> s.key(key).expire(inSeconds).set(val));
    }

    public void store(String key, String val) {
        this.client.open(s -> s.key(key).persist().set(val));
    }

    public void storeAndSerialize(String key, Object obj, int inSeconds) {
        AssertUtil.notNull(obj, "redis value cannot be null");
        String val = this.client.serializer().encode(obj);
        this.client.open(s -> s.key(key).expire(inSeconds).set(val));
    }

    public void storeAndSerialize(String key, Object obj) {
        AssertUtil.notNull(obj, "redis value cannot be null");
        String val = this.client.serializer().encode(obj);
        this.client.open(s -> s.key(key).persist().set(val));
    }

    public String get(String key) {
        return this.client.openAndGet(s -> s.key(key).get());
    }

    public List<String> getByKeys(String ... keys) {
        return this.client.openAndGet(s -> s.getMore(keys));
    }

    public <T> T getAndDeserialize(String key) {
        String val = this.get(key);
        if (val == null) {
            return null;
        }
        return (T)this.client.serializer().decode(val);
    }

    public <T> List<T> getAndDeserializeByKeys(String ... keys) {
        List<String> vals = this.getByKeys(keys);
        if (vals == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (String val : vals) {
            list.add(this.client.serializer().decode(val));
        }
        return list;
    }

    public String getOrStore(String key, int inSeconds, Supplier<String> supplier) {
        String val = this.get(key);
        if (val == null) {
            val = supplier.get();
            this.store(key, val, inSeconds);
        }
        return val;
    }

    public <T> T getOrStoreAndSerialize(String key, int inSeconds, Supplier<T> supplier) {
        T val = this.getAndDeserialize(key);
        if (val == null) {
            val = supplier.get();
            this.storeAndSerialize(key, val, inSeconds);
        }
        return val;
    }

    public Boolean exists(String key) {
        return this.client.openAndGet(s -> s.key(key).exists());
    }

    public Long existsByKeys(Collection<String> keys) {
        return this.client.openAndGet(s -> s.existsKeys(keys));
    }

    public Long existsByPattern(String pattern) {
        return this.client.openAndGet(s -> {
            Set<String> keys = s.keys(pattern);
            return s.existsKeys(keys);
        });
    }

    public Boolean remove(String key) {
        return this.client.openAndGet(s -> s.key(key).delete());
    }

    public Long removeByKeys(Collection<String> keys) {
        return this.client.openAndGet(s -> s.deleteKeys(keys));
    }

    public Long removeByPattern(String pattern) {
        return this.client.openAndGet(s -> {
            Set<String> keys = s.keys(pattern);
            return s.deleteKeys(keys);
        });
    }

    public void delay(String key, int inSeconds) {
        this.client.open(s -> s.key(key).delay(inSeconds));
    }

    public long ttl(String key) {
        return this.client.openAndGet(s -> s.key(key).ttl());
    }

    public Set<String> keys(String pattern) {
        return this.client.openAndGet(s -> s.keys(pattern));
    }
}

