/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import org.noear.redisx.RedisClient;

public class RedisAtomic {
    private final RedisClient client;
    private final String atomicName;
    private final int inSeconds;

    public RedisAtomic(RedisClient client, String atomicName) {
        this(client, atomicName, -1);
    }

    public RedisAtomic(RedisClient client, String atomicName, int inSeconds) {
        this.client = client;
        this.atomicName = atomicName;
        this.inSeconds = inSeconds;
    }

    public long get() {
        return this.client.openAndGet(s -> s.key(this.atomicName).getAsLong());
    }

    public long increment() {
        return this.client.openAndGet(s -> s.key(this.atomicName).expire(this.inSeconds).incr());
    }

    public long incrementBy(long num) {
        return this.client.openAndGet(s -> s.key(this.atomicName).expire(this.inSeconds).incr(num));
    }

    public long decrement() {
        return this.client.openAndGet(s -> s.key(this.atomicName).expire(this.inSeconds).decr());
    }

    public long decrementBy(long num) {
        return this.client.openAndGet(s -> s.key(this.atomicName).expire(this.inSeconds).incr(-num));
    }
}

