/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.List;
import org.smartboot.http.common.HeaderValue;

public class Part {
    private String contentType;
    private String contentDisposition;
    private String fileName;
    private String name;
    private boolean isFile = false;
    private transient File tempFile;
    private FileOutputStream fos;
    private int sizeThreshold = 8192;
    private byte[] cachedContent = new byte[this.sizeThreshold];
    private int cachedContentLength;
    private List<HeaderValue> headers;

    public InputStream getInputStream() throws IOException {
        if (this.isFile) {
            return Files.newInputStream(this.tempFile.toPath(), new OpenOption[0]);
        }
        return new ByteArrayInputStream(this.cachedContent, 0, this.cachedContentLength);
    }

    public boolean delete() {
        if (this.isFile && Files.exists(this.tempFile.toPath(), new LinkOption[0])) {
            return this.tempFile.delete();
        }
        this.cachedContent = null;
        return true;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void setIsFile(boolean file) {
        this.isFile = file;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public byte[] getCachedContent() {
        return this.cachedContent;
    }

    public void setCachedContent(byte[] cachedContent) {
        this.cachedContent = cachedContent;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public FileOutputStream getFos() {
        return this.fos;
    }

    public void setFos(FileOutputStream fos) {
        this.fos = fos;
    }

    public List<HeaderValue> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<HeaderValue> headers) {
        this.headers = headers;
    }

    public int getCachedContentLength() {
        return this.cachedContentLength;
    }

    public void setCachedContentLength(int cachedContentLength) {
        this.cachedContentLength = cachedContentLength;
    }
}

