/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.http.common.codec.h2.codec.Http2Frame;
import org.smartboot.socket.transport.WriteBuffer;

public class PushPromiseFrame
extends Http2Frame {
    private int padLength;
    private int promisedStream;
    private ByteBuffer fragment = EMPTY_BUFFER;
    private byte[] padding = EMPTY_PADDING;

    public PushPromiseFrame(int streamId, int flags, int remaining) {
        super(streamId, flags, remaining);
    }

    @Override
    public boolean decode(ByteBuffer buffer) {
        if (this.finishDecode()) {
            return true;
        }
        switch (this.state) {
            case 0: {
                if (this.getFlag(8)) {
                    if (!buffer.hasRemaining()) {
                        return false;
                    }
                    this.padLength = buffer.get();
                    if (this.padLength < 0) {
                        throw new IllegalStateException();
                    }
                    --this.remaining;
                }
                this.state = 1;
            }
            case 1: {
                if (buffer.remaining() < 4) {
                    return false;
                }
                this.promisedStream = buffer.getInt();
                this.remaining -= 4;
                this.state = 2;
                this.fragment = ByteBuffer.allocate(this.remaining - this.padLength);
            }
            case 2: {
                int min = Math.min(buffer.remaining(), this.fragment.remaining());
                int limit = buffer.limit();
                buffer.limit(buffer.position() + min);
                this.fragment.put(buffer);
                buffer.limit(limit);
                this.remaining -= min;
                if (this.fragment.hasRemaining()) {
                    return false;
                }
                this.fragment.flip();
                this.state = 3;
            }
            case 3: {
                if (buffer.remaining() < this.padLength) {
                    return false;
                }
                if (this.padLength <= 0) break;
                this.padding = new byte[this.padLength];
                buffer.get(this.padding);
                this.remaining -= this.padLength;
            }
        }
        this.checkEndRemaining();
        return true;
    }

    @Override
    public void writeTo(WriteBuffer writeBuffer) throws IOException {
        boolean padded;
        int payloadLength = 0;
        byte flags = (byte)this.flags;
        boolean bl = padded = this.padding != null && this.padding.length > 0;
        if (padded) {
            payloadLength += 1 + this.padding.length;
            flags = (byte)(flags | 8);
        }
        writeBuffer.writeInt((payloadLength += 4 + this.fragment.remaining()) << 8 | 5);
        writeBuffer.writeByte(flags);
        System.out.println("write push promise header ,streamId:" + this.streamId);
        writeBuffer.writeInt(this.streamId);
        if (padded) {
            writeBuffer.writeByte((byte)this.padding.length);
        }
        writeBuffer.writeInt(this.promisedStream);
        writeBuffer.write(this.fragment.array(), 0, this.fragment.remaining());
        if (padded) {
            writeBuffer.write(this.padding);
        }
    }

    @Override
    public int type() {
        return 5;
    }

    public int getPadLength() {
        return this.padLength;
    }

    public int getPromisedStream() {
        return this.promisedStream;
    }

    public ByteBuffer getFragment() {
        return this.fragment;
    }

    public void setFragment(ByteBuffer fragment) {
        this.fragment = fragment;
    }

    public void setPromisedStream(int promisedStream) {
        this.promisedStream = promisedStream;
    }
}

