/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.websocket;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.smartboot.http.common.codec.websocket.Decoder;
import org.smartboot.http.common.codec.websocket.WebSocket;
import org.smartboot.http.common.utils.FixedLengthFrameDecoder;
import org.smartboot.http.common.utils.SmartDecoder;

class PayloadDecoder
implements Decoder {
    PayloadDecoder() {
    }

    @Override
    public Decoder decode(ByteBuffer byteBuffer, WebSocket request) {
        SmartDecoder smartDecoder = request.getPayloadDecoder();
        if (smartDecoder != null) {
            if (smartDecoder.decode(byteBuffer)) {
                this.finishPayloadDecoder(smartDecoder.getBuffer(), request);
                request.setPayloadDecoder(null);
                return WebSocket.PAYLOAD_FINISH;
            }
            return this;
        }
        if (request.getPayloadLength() > (long)byteBuffer.capacity()) {
            request.setPayloadDecoder(new FixedLengthFrameDecoder((int)request.getPayloadLength()));
            return this.decode(byteBuffer, request);
        }
        if ((long)byteBuffer.remaining() < request.getPayloadLength()) {
            return this;
        }
        this.finishPayloadDecoder(byteBuffer, request);
        return WebSocket.PAYLOAD_FINISH;
    }

    private void finishPayloadDecoder(ByteBuffer byteBuffer, WebSocket request) {
        byte[] bytes = new byte[(int)request.getPayloadLength()];
        if (request.isFrameMasked()) {
            this.unmask(byteBuffer, request.getMaskingKey(), bytes.length);
        }
        byteBuffer.get(bytes);
        request.setPayload(bytes);
    }

    private void unmask(ByteBuffer frame, byte[] maskingKey, int length) {
        int i = frame.position();
        int end = i + length;
        ByteOrder order = frame.order();
        int intMask = (maskingKey[0] & 0xFF) << 24 | (maskingKey[1] & 0xFF) << 16 | (maskingKey[2] & 0xFF) << 8 | maskingKey[3] & 0xFF;
        if (order == ByteOrder.LITTLE_ENDIAN) {
            intMask = Integer.reverseBytes(intMask);
        }
        while (i + 3 < end) {
            int unmasked = frame.getInt(i) ^ intMask;
            frame.putInt(i, unmasked);
            i += 4;
        }
        int j = i;
        while (i < end) {
            frame.put(i, (byte)(frame.get(i) ^ maskingKey[(i - j) % 4]));
            ++i;
        }
    }
}

