/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.multipart;

import java.nio.file.Paths;
import org.smartboot.http.common.utils.StringUtils;

public class MultipartConfig {
    private String location;
    private long maxFileSize;
    private long maxRequestSize;
    private int fileSizeThreshold;

    public MultipartConfig() {
    }

    public MultipartConfig(String location, long maxFileSize, long maxRequestSize, int fileSizeThreshold) {
        this.location = location == null ? "" : location;
        if (StringUtils.isNotBlank(this.location) && !Paths.get(this.location, new String[0]).isAbsolute()) {
            throw new IllegalStateException("location must be absolute");
        }
        this.maxFileSize = maxFileSize;
        this.maxRequestSize = maxRequestSize;
        this.fileSizeThreshold = fileSizeThreshold;
    }

    public String getLocation() {
        return this.location;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public int getFileSizeThreshold() {
        return this.fileSizeThreshold;
    }
}

