/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.waf.WafConfiguration;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.extension.plugins.StreamMonitorPlugin;

public class HttpServerConfiguration {
    public static final String VERSION = "2.5.12";
    private final ByteTree<Object> byteCache = new ByteTree();
    private final ByteTree<ServerHandler<?, ?>> uriByteTree = new ByteTree();
    private final ByteTree<HeaderNameEnum> headerNameByteTree = new ByteTree();
    private final List<Plugin<Request>> plugins = new ArrayList<Plugin<Request>>();
    private boolean bannerEnabled = true;
    private int readBufferSize = 1024;
    private int writeBufferSize = 1024;
    private int threadNum = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    private String host;
    private int headerLimiter = 100;
    private long httpIdleTimeout = 60000L;
    private long wsIdleTimeout = 120000L;
    private boolean secure;
    private long maxRequestSize = Integer.MAX_VALUE;
    private boolean lowMemory = false;
    private BufferPagePool readBufferPool;
    private BufferPagePool writeBufferPool;
    private AsynchronousChannelGroup group;
    private HttpServerHandler httpServerHandler = new HttpServerHandler(){

        @Override
        public void handle(HttpRequest request, HttpResponse response) throws IOException {
            response.write("Hello smart-http".getBytes(StandardCharsets.UTF_8));
        }
    };
    private WebSocketHandler webSocketHandler;
    private final WafConfiguration wafConfiguration = new WafConfiguration();

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    public HttpServerConfiguration readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    int getThreadNum() {
        return this.threadNum;
    }

    public HttpServerConfiguration threadNum(int threadNum) {
        this.threadNum = threadNum;
        return this;
    }

    int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public HttpServerConfiguration writeBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    String getHost() {
        return this.host;
    }

    public HttpServerConfiguration host(String host) {
        this.host = host;
        return this;
    }

    boolean isBannerEnabled() {
        return this.bannerEnabled;
    }

    public HttpServerConfiguration bannerEnabled(boolean bannerEnabled) {
        this.bannerEnabled = bannerEnabled;
        return this;
    }

    public int getHeaderLimiter() {
        return this.headerLimiter;
    }

    public HttpServerConfiguration headerLimiter(int headerLimiter) {
        this.headerLimiter = headerLimiter;
        return this;
    }

    public HttpServerConfiguration debug(boolean debug) {
        this.plugins.removeIf(plugin -> plugin instanceof StreamMonitorPlugin);
        if (debug) {
            this.addPlugin((Plugin<Request>)new StreamMonitorPlugin(StreamMonitorPlugin.BLUE_TEXT_INPUT_STREAM, StreamMonitorPlugin.RED_TEXT_OUTPUT_STREAM));
        }
        return this;
    }

    public ByteTree<ServerHandler<?, ?>> getUriByteTree() {
        return this.uriByteTree;
    }

    public HttpServerHandler getHttpServerHandler() {
        return this.httpServerHandler;
    }

    public void setHttpServerHandler(HttpServerHandler httpServerHandler) {
        this.httpServerHandler = httpServerHandler;
    }

    public WebSocketHandler getWebSocketHandler() {
        return this.webSocketHandler;
    }

    public void setWebSocketHandler(WebSocketHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
    }

    public ByteTree<Object> getByteCache() {
        return this.byteCache;
    }

    public ByteTree<HeaderNameEnum> getHeaderNameByteTree() {
        return this.headerNameByteTree;
    }

    public HttpServerConfiguration addPlugin(Plugin<Request> plugin) {
        this.plugins.add(plugin);
        if (plugin instanceof SslPlugin) {
            this.secure = true;
        }
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public HttpServerConfiguration addPlugin(List<Plugin<Request>> plugins) {
        this.plugins.addAll(plugins);
        return this;
    }

    public List<Plugin<Request>> getPlugins() {
        return this.plugins;
    }

    public AsynchronousChannelGroup group() {
        return this.group;
    }

    public HttpServerConfiguration group(AsynchronousChannelGroup group) {
        this.group = group;
        return this;
    }

    public WafConfiguration getWafConfiguration() {
        return this.wafConfiguration;
    }

    public long getHttpIdleTimeout() {
        return this.httpIdleTimeout;
    }

    public HttpServerConfiguration setHttpIdleTimeout(long httpIdleTimeout) {
        this.httpIdleTimeout = httpIdleTimeout;
        return this;
    }

    public long getWsIdleTimeout() {
        return this.wsIdleTimeout;
    }

    public HttpServerConfiguration setWsIdleTimeout(long wsIdleTimeout) {
        this.wsIdleTimeout = wsIdleTimeout;
        return this;
    }

    boolean isLowMemory() {
        return this.lowMemory;
    }

    public BufferPagePool getReadBufferPool() {
        return this.readBufferPool;
    }

    public HttpServerConfiguration setReadBufferPool(BufferPagePool readBufferPool) {
        this.readBufferPool = readBufferPool;
        return this;
    }

    public BufferPagePool getWriteBufferPool() {
        return this.writeBufferPool;
    }

    public HttpServerConfiguration setWriteBufferPool(BufferPagePool writeBufferPool) {
        this.writeBufferPool = writeBufferPool;
        return this;
    }

    public HttpServerConfiguration setLowMemory(boolean lowMemory) {
        this.lowMemory = lowMemory;
        return this;
    }
}

