/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Semaphore;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.utils.Constant;
import org.smartboot.http.common.utils.TimerUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.impl.AbstractOutputStream;
import org.smartboot.http.server.impl.HttpRequestImpl;
import org.smartboot.http.server.impl.HttpResponseImpl;
import org.smartboot.http.server.impl.Request;

final class HttpOutputStream
extends AbstractOutputStream {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final byte[] Content_Type_Bytes = "\r\nContent-Type:".getBytes();
    private static final byte[] Content_Length_Bytes = "\r\nContent-Length:".getBytes();
    private static final Date currentDate = new Date(0L);
    private static final Semaphore flushDateSemaphore = new Semaphore(1);
    private static final byte[] CHUNKED = "\r\nTransfer-Encoding: chunked\r\n".getBytes();
    private static final byte[] CHUNKED_2 = "\r\nTransfer-Encoding: chunked\r\n\r\n".getBytes();
    private static byte[] SERVER_LINE = null;
    private static long expireTime;
    private static byte[] HEAD_PART_BYTES;
    private final Request request;
    private final HttpServerConfiguration configuration;

    public HttpOutputStream(HttpRequestImpl httpRequest, HttpResponseImpl response) {
        super(httpRequest.request, response);
        this.request = httpRequest.request;
        this.configuration = this.request.getConfiguration();
        if (SERVER_LINE == null) {
            String serverLine = HeaderNameEnum.SERVER.getName() + ':' + this.configuration.serverName() + "\r\n";
            SERVER_LINE = serverLine.getBytes();
            HEAD_PART_BYTES = (HttpProtocolEnum.HTTP_11.getProtocol() + " 200 OK\r\n" + serverLine + "Date:Sun, 24 Nov 2024 15:50:27 CST").getBytes();
            this.flushDate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDate() {
        long currentTime = TimerUtils.currentTimeMillis();
        if (currentTime > expireTime && flushDateSemaphore.tryAcquire()) {
            try {
                expireTime = currentTime + 1000L;
                currentDate.setTime(currentTime);
                sdf.setTimeZone(GMT_ZONE);
                String date = sdf.format(currentDate);
                byte[] bytes = date.getBytes();
                System.arraycopy(bytes, 0, HEAD_PART_BYTES, HEAD_PART_BYTES.length - 29, bytes.length);
            }
            finally {
                flushDateSemaphore.release();
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (this.configuration.getWsIdleTimeout() > 0L || this.configuration.getHttpIdleTimeout() > 0L) {
            this.request.setLatestIo(System.currentTimeMillis());
        }
    }

    @Override
    protected void writeHeadPart(boolean hasHeader) throws IOException {
        boolean fastWrite;
        this.checkChunked();
        long contentLength = this.response.getContentLength();
        String contentType = this.response.getContentType();
        if (contentLength > 0L) {
            this.remaining = contentLength;
        }
        this.flushDate();
        HttpStatus httpStatus = this.response.getHttpStatus();
        boolean bl = fastWrite = this.request.getProtocol() == HttpProtocolEnum.HTTP_11 && httpStatus == HttpStatus.OK && this.configuration.serverName() != null && this.response.getHeader(HeaderNameEnum.SERVER.getName()) == null;
        if (fastWrite) {
            this.writeBuffer.write(HEAD_PART_BYTES);
        } else {
            this.writeString(this.request.getProtocol().getProtocol());
            this.writeBuffer.writeByte((byte)32);
            httpStatus.write(this.writeBuffer);
            if (this.configuration.serverName() != null && this.response.getHeader(HeaderNameEnum.SERVER.getName()) == null) {
                this.writeBuffer.write(SERVER_LINE);
            }
            this.writeBuffer.write(HEAD_PART_BYTES, HEAD_PART_BYTES.length - 34, 34);
        }
        if (contentType != null) {
            this.writeBuffer.write(Content_Type_Bytes);
            this.writeString(contentType);
        }
        if (contentLength >= 0L) {
            this.writeBuffer.write(Content_Length_Bytes);
            this.writeLongString(contentLength);
            if (hasHeader) {
                this.writeBuffer.write(Constant.CRLF_BYTES);
            } else {
                this.writeBuffer.write(Constant.CRLF_CRLF_BYTES);
            }
        } else if (this.chunkedSupport) {
            if (hasHeader) {
                this.writeBuffer.write(CHUNKED);
            } else {
                this.writeBuffer.write(CHUNKED_2);
            }
        } else if (hasHeader) {
            this.writeBuffer.write(Constant.CRLF_BYTES);
        } else {
            this.writeBuffer.write(Constant.CRLF_CRLF_BYTES);
        }
    }

    private void checkChunked() {
        if (!this.chunkedSupport) {
            return;
        }
        if (this.response.getContentLength() >= 0L) {
            this.disableChunked();
        } else if (this.response.getHttpStatus().value() == HttpStatus.CONTINUE.value() || this.response.getHttpStatus().value() == HttpStatus.SWITCHING_PROTOCOLS.value()) {
            this.disableChunked();
        } else if (HttpMethodEnum.HEAD.name().equals(this.request.getMethod())) {
            this.disableChunked();
        } else if (HttpProtocolEnum.HTTP_11 != this.request.getProtocol()) {
            this.disableChunked();
        }
    }
}

