/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.smartboot.http.common.codec.h2.codec.ContinuationFrame;
import org.smartboot.http.common.codec.h2.codec.PushPromiseFrame;
import org.smartboot.http.common.codec.h2.hpack.Encoder;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.utils.HttpUtils;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.PushBuilder;
import org.smartboot.http.server.impl.Http2RequestImpl;
import org.smartboot.http.server.impl.Http2ResponseImpl;
import org.smartboot.http.server.impl.Http2Session;

public class PushBuilderImpl
implements PushBuilder {
    public static final List<String> IGNORE_HEADERS = Arrays.asList("if-match", "if-none-match", "if-modified-since", "if-unmodified-since", "if-range", "range", "proxy-authorization", "from", "user-agent", "range", "expect", "max-forwards", "proxy-authenticate", "proxy-authorization", "age", "cache-control", "clear-site-data");
    private static final Set<String> UNSUPPORTED_METHODS = new HashSet<String>(Arrays.asList("", "POST", "PUT", "DELETE", "CONNECT", "OPTIONS", "TRACE"));
    private final Http2RequestImpl pushRequest;
    private final int streamId;
    private String path;
    private String queryString;

    public PushBuilderImpl(int streamId, Http2ResponseImpl response, Http2Session session) {
        this.streamId = streamId;
        this.pushRequest = new Http2RequestImpl(session.getPushStreamId().addAndGet(2), session, true);
        response.getCookies().forEach(cookie -> this.pushRequest.addHeader(HeaderNameEnum.COOKIE.getLowCaseName(), HeaderNameEnum.COOKIE.getName(), cookie.getName() + "=" + cookie.getValue()));
        this.method(HttpMethodEnum.GET.getMethod());
    }

    @Override
    public PushBuilder method(String method) {
        if (method == null) {
            throw new NullPointerException();
        }
        if (UNSUPPORTED_METHODS.contains(method)) {
            throw new IllegalArgumentException("Unsupported method: " + method);
        }
        this.pushRequest.setMethod(method);
        return this;
    }

    @Override
    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @Override
    public PushBuilder setHeader(String name, String value) {
        this.pushRequest.setHeader(name, value);
        return this;
    }

    @Override
    public PushBuilder addHeader(String name, String value) {
        this.pushRequest.addHeader(name.toLowerCase(), name, value);
        return this;
    }

    @Override
    public PushBuilder removeHeader(String name) {
        this.pushRequest.setHeader(name, null);
        return null;
    }

    @Override
    public PushBuilder path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public void push() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            throw new IllegalStateException();
        }
        String path = this.path;
        if (this.queryString != null && !this.queryString.isEmpty()) {
            path = path.contains("?") ? path + "&" + this.queryString : path + "?" + this.queryString;
        }
        try {
            this.pushRequest.setHeader(":method", this.pushRequest.getMethod());
            this.pushRequest.setHeader(":scheme", this.pushRequest.getScheme());
            this.pushRequest.setHeader(":path", path);
            this.pushRequest.setHeader(":authority", this.pushRequest.getSession().getRequest().getHost());
            this.pushRequest.setUri(path);
            this.pushRequest.setRequestURI(path);
            List buffers = HttpUtils.HPackEncoder((Encoder)this.pushRequest.getSession().getHpackEncoder(), this.pushRequest.getHeaders());
            PushPromiseFrame frame = new PushPromiseFrame(this.streamId, buffers.size() > 1 ? 0 : 4, 0);
            frame.setPromisedStream(this.pushRequest.getStreamId());
            if (!buffers.isEmpty()) {
                frame.setFragment((ByteBuffer)buffers.get(0));
            }
            frame.writeTo(this.pushRequest.getSession().getRequest().aioSession.writeBuffer());
            for (int i = 1; i < buffers.size() - 1; ++i) {
                ContinuationFrame continuationFrame = new ContinuationFrame(this.streamId, 0, 0);
                continuationFrame.setFragment((ByteBuffer)buffers.get(i));
                continuationFrame.writeTo(this.pushRequest.getSession().getRequest().aioSession.writeBuffer());
            }
            if (buffers.size() > 1) {
                ContinuationFrame continuationFrame = new ContinuationFrame(this.streamId, 4, 0);
                continuationFrame.setFragment((ByteBuffer)buffers.get(buffers.size() - 1));
                continuationFrame.writeTo(this.pushRequest.getSession().getRequest().aioSession.writeBuffer());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.pushRequest.getSession().getRequest().getConfiguration().getHttp2ServerHandler().handleHttpRequest(this.pushRequest);
        this.pushRequest.reset();
        this.path = null;
        this.queryString = null;
    }

    @Override
    public String getMethod() {
        return this.pushRequest.getMethod();
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Set<String> getHeaderNames() {
        return new HashSet<String>(this.pushRequest.getHeaderNames());
    }

    @Override
    public String getHeader(String name) {
        return this.pushRequest.getHeader(name);
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

