/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.smartboot.http.common.codec.websocket.CloseReason;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.common.utils.WebSocketUtil;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.WebSocketOutputStream;
import org.smartboot.http.server.impl.WebSocketRequestImpl;

public class WebSocketResponseImpl
extends AbstractResponse
implements WebSocketResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketResponseImpl.class);
    private boolean closed;

    public WebSocketResponseImpl(WebSocketRequestImpl webSocketRequest) {
        this.init(webSocketRequest.getRequest().aioSession, new WebSocketOutputStream(webSocketRequest, this));
    }

    @Override
    public void sendTextMessage(String text) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u53d1\u9001\u5b57\u7b26\u4e32\u6d88\u606f: " + text);
        }
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        try {
            WebSocketUtil.send((OutputStream)this.getOutputStream(), (byte)1, (byte[])bytes, (int)0, (int)bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendBinaryMessage(byte[] bytes) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u53d1\u9001\u4e8c\u8fdb\u5236\u6d88\u606f: " + Arrays.toString(bytes));
        }
        try {
            WebSocketUtil.send((OutputStream)this.getOutputStream(), (byte)2, (byte[])bytes, (int)0, (int)bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendBinaryMessage(byte[] bytes, int offset, int length) {
        try {
            WebSocketUtil.send((OutputStream)this.getOutputStream(), (byte)2, (byte[])bytes, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void pong(byte[] bytes) {
        try {
            WebSocketUtil.send((OutputStream)this.getOutputStream(), (byte)10, (byte[])bytes, (int)0, (int)bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.close(1000, "");
    }

    @Override
    public void close(int code, String reason) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            WebSocketUtil.send((OutputStream)this.getOutputStream(), (byte)8, (byte[])new CloseReason(code, reason).toBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            super.close();
        }
    }

    @Override
    public void ping(byte[] bytes) {
        try {
            WebSocketUtil.send((OutputStream)this.getOutputStream(), (byte)9, (byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

