/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.exts;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.noear.snack.core.exts.FieldWrap;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> cached = new ConcurrentHashMap();
    private final Class<?> _clz;
    private final Map<String, FieldWrap> _fieldAllWraps;
    private final Map<String, Method> _propertyAll;
    private boolean _recordable;
    private Constructor _recordConstructor;
    private Parameter[] _recordParams;
    private boolean _isMemberClass;

    public static ClassWrap get(Class<?> clz) {
        ClassWrap l;
        ClassWrap cw = cached.get(clz);
        if (cw == null && (l = cached.putIfAbsent(clz, cw = new ClassWrap(clz))) != null) {
            cw = l;
        }
        return cw;
    }

    protected ClassWrap(Class<?> clz) {
        Constructor<?>[] constructors;
        this._clz = clz;
        this._recordable = true;
        this._isMemberClass = clz.isMemberClass();
        this._fieldAllWraps = new LinkedHashMap<String, FieldWrap>();
        this._propertyAll = new LinkedHashMap<String, Method>();
        this.scanAllFields(clz, this._fieldAllWraps::containsKey, this._fieldAllWraps::put);
        for (Method m : clz.getMethods()) {
            if (!m.getName().startsWith("set") || m.getName().length() <= 3 || m.getParameterCount() != 1) continue;
            String name = m.getName().substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            this._propertyAll.put(name, m);
        }
        if (this._fieldAllWraps.size() == 0) {
            this._recordable = false;
        }
        if ((constructors = clz.getConstructors()).length > 0) {
            if (this._recordable) {
                this._recordConstructor = constructors[constructors.length - 1];
                this._recordParams = this._recordConstructor.getParameters();
                if (this._recordParams.length == 0) {
                    this._recordable = false;
                }
            } else if (constructors.length == 1 && constructors[0].getParameterCount() > 0) {
                this._recordConstructor = constructors[0];
                this._recordParams = this._recordConstructor.getParameters();
            }
        } else {
            this._recordable = false;
        }
    }

    public Class<?> clz() {
        return this._clz;
    }

    public Collection<FieldWrap> fieldAllWraps() {
        return this._fieldAllWraps.values();
    }

    public FieldWrap getFieldWrap(String fieldName) {
        return this._fieldAllWraps.get(fieldName);
    }

    public Method getProperty(String name) {
        return this._propertyAll.get(name);
    }

    public boolean recordable() {
        return this._recordable;
    }

    public Constructor recordConstructor() {
        return this._recordConstructor;
    }

    public Parameter[] recordParams() {
        return this._recordParams;
    }

    private void scanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isTransient(mod) || this._isMemberClass && f.getName().equals("this$0") || checker.test(f.getName())) continue;
            this._recordable &= Modifier.isFinal(mod);
            consumer.accept(f.getName(), new FieldWrap(clz, f, Modifier.isFinal(mod)));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            this.scanAllFields(sup, checker, consumer);
        }
    }
}

