/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.to;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import org.noear.snack.ONode;
import org.noear.snack.ONodeData;
import org.noear.snack.OValue;
import org.noear.snack.core.Context;
import org.noear.snack.core.Feature;
import org.noear.snack.core.exts.ThData;
import org.noear.snack.core.utils.DateUtil;
import org.noear.snack.core.utils.IOUtil;
import org.noear.snack.core.utils.TypeUtil;
import org.noear.snack.to.Toer;

public class JsonToer
implements Toer {
    private static final ThData<StringBuilder> tlBuilder = new ThData<Object>(() -> new StringBuilder(5120));

    @Override
    public void handle(Context ctx) {
        ONode o = (ONode)ctx.source;
        if (null != o) {
            StringBuilder sb = null;
            if (ctx.options.hasFeature(Feature.DisThreadLocal)) {
                sb = new StringBuilder(5120);
            } else {
                sb = (StringBuilder)tlBuilder.get();
                sb.setLength(0);
            }
            ctx.pretty = ctx.options.hasFeature(Feature.PrettyFormat);
            this.analyse(ctx, o, sb);
            ctx.target = sb.toString();
        }
    }

    public void analyse(Context ctx, ONode o, StringBuilder sb) {
        if (o == null) {
            return;
        }
        switch (o.nodeType()) {
            case Value: {
                this.writeValue(ctx, sb, o.nodeData());
                break;
            }
            case Array: {
                this.writeArray(ctx, sb, o.nodeData());
                break;
            }
            case Object: {
                this.writeObject(ctx, sb, o.nodeData());
                break;
            }
            default: {
                sb.append("null");
            }
        }
    }

    private void writeArray(Context ctx, StringBuilder sBuf, ONodeData d) {
        sBuf.append("[");
        if (d.array.size() > 0) {
            if (ctx.pretty) {
                ++ctx.depth;
            }
            Iterator<ONode> iterator = d.array.iterator();
            while (iterator.hasNext()) {
                if (ctx.pretty) {
                    sBuf.append("\n");
                    this.printDepth(ctx, sBuf);
                }
                ONode sub = iterator.next();
                this.analyse(ctx, sub, sBuf);
                if (!iterator.hasNext()) continue;
                sBuf.append(",");
            }
            if (ctx.pretty) {
                sBuf.append("\n");
                --ctx.depth;
                this.printDepth(ctx, sBuf);
            }
        }
        sBuf.append("]");
    }

    private void writeObject(Context ctx, StringBuilder sBuf, ONodeData d) {
        sBuf.append("{");
        if (d.object.size() > 0) {
            if (ctx.pretty) {
                ++ctx.depth;
            }
            Iterator<String> itr = d.object.keySet().iterator();
            while (itr.hasNext()) {
                String k = itr.next();
                if (ctx.pretty) {
                    sBuf.append("\n");
                    this.printDepth(ctx, sBuf);
                }
                this.writeName(ctx, sBuf, k);
                sBuf.append(":");
                if (ctx.pretty) {
                    sBuf.append(" ");
                }
                this.analyse(ctx, d.object.get(k), sBuf);
                if (!itr.hasNext()) continue;
                sBuf.append(",");
            }
            if (ctx.pretty) {
                sBuf.append("\n");
                --ctx.depth;
                this.printDepth(ctx, sBuf);
            }
        }
        sBuf.append("}");
    }

    private void printDepth(Context ctx, StringBuilder sBuf) {
        if (ctx.depth > 0) {
            for (int i = 0; i < ctx.depth; ++i) {
                sBuf.append("  ");
            }
        }
    }

    private void writeValue(Context ctx, StringBuilder sBuf, ONodeData d) {
        OValue v = d.value;
        switch (v.type()) {
            case Null: {
                sBuf.append("null");
                break;
            }
            case String: {
                this.writeValString(ctx, sBuf, v.getRawString(), true);
                break;
            }
            case DateTime: {
                this.writeValDate(ctx, sBuf, v.getRawDate());
                break;
            }
            case Boolean: {
                this.writeValBool(ctx, sBuf, v.getRawBoolean());
                break;
            }
            case Number: {
                this.writeValNumber(ctx, sBuf, v.getRawNumber());
                break;
            }
            default: {
                sBuf.append(v.getString());
            }
        }
    }

    private void writeName(Context ctx, StringBuilder sBuf, String val) {
        if (ctx.options.hasFeature(Feature.QuoteFieldNames)) {
            if (ctx.options.hasFeature(Feature.UseSingleQuotes)) {
                sBuf.append("'");
                this.writeString(ctx, sBuf, val, '\'');
                sBuf.append("'");
            } else {
                sBuf.append("\"");
                this.writeString(ctx, sBuf, val, '\"');
                sBuf.append("\"");
            }
        } else {
            this.writeString(ctx, sBuf, val, '\"');
        }
    }

    private void writeValDate(Context ctx, StringBuilder sBuf, Date val) {
        if (ctx.options.hasFeature(Feature.WriteDateUseTicks)) {
            sBuf.append(val.getTime());
        } else if (ctx.options.hasFeature(Feature.WriteDateUseFormat)) {
            String valStr = DateUtil.format(val, ctx.options.getDateFormat(), ctx.options.getTimeZone());
            this.writeValString(ctx, sBuf, valStr, false);
        } else {
            sBuf.append("new Date(").append(val.getTime()).append(")");
        }
    }

    private void writeValBool(Context ctx, StringBuilder sBuf, Boolean val) {
        if (ctx.options.hasFeature(Feature.WriteBoolUse01)) {
            sBuf.append(val != false ? 1 : 0);
        } else {
            sBuf.append(val != false ? "true" : "false");
        }
    }

    private void writeValNumber(Context ctx, StringBuilder sBuf, Number val) {
        if (val instanceof BigInteger) {
            BigInteger v = (BigInteger)val;
            String sVal = v.toString();
            if (ctx.options.hasFeature(Feature.WriteNumberUseString)) {
                this.writeValString(ctx, sBuf, sVal, false);
            } else if (sVal.length() > 16 && (v.compareTo(TypeUtil.INT_LOW) < 0 || v.compareTo(TypeUtil.INT_HIGH) > 0) && ctx.options.hasFeature(Feature.BrowserCompatible)) {
                this.writeValString(ctx, sBuf, sVal, false);
            } else {
                sBuf.append(sVal);
            }
            return;
        }
        if (val instanceof BigDecimal) {
            BigDecimal v = (BigDecimal)val;
            String sVal = v.toPlainString();
            if (ctx.options.hasFeature(Feature.WriteNumberUseString)) {
                this.writeValString(ctx, sBuf, sVal, false);
            } else if (sVal.length() > 16 && (v.compareTo(TypeUtil.DEC_LOW) < 0 || v.compareTo(TypeUtil.DEC_HIGH) > 0) && ctx.options.hasFeature(Feature.BrowserCompatible)) {
                this.writeValString(ctx, sBuf, sVal, false);
            } else {
                sBuf.append(sVal);
            }
            return;
        }
        if (ctx.options.hasFeature(Feature.WriteNumberUseString)) {
            this.writeValString(ctx, sBuf, val.toString(), false);
        } else {
            sBuf.append(val.toString());
        }
    }

    private void writeValString(Context ctx, StringBuilder sBuf, String val, boolean isStr) {
        boolean useSingleQuotes = ctx.options.hasFeature(Feature.UseSingleQuotes);
        char quote = useSingleQuotes ? (char)'\'' : '\"';
        sBuf.append(quote);
        if (isStr) {
            this.writeString(ctx, sBuf, val, quote);
        } else {
            sBuf.append(val);
        }
        sBuf.append(quote);
    }

    private void writeString(Context ctx, StringBuilder sBuf, String val, char quote) {
        boolean isCompatible = ctx.options.hasFeature(Feature.BrowserCompatible);
        boolean isSecure = ctx.options.hasFeature(Feature.BrowserSecure);
        boolean isTransfer = ctx.options.hasFeature(Feature.TransferCompatible);
        int len = val.length();
        for (int i = 0; i < len; ++i) {
            char c = val.charAt(i);
            if (c == quote || c == '\n' || c == '\r' || c == '\t' || c == '\f' || c == '\b' || c >= '\u0000' && c <= '\u0007') {
                sBuf.append("\\");
                sBuf.append(IOUtil.CHARS_MARK[c]);
                continue;
            }
            if (isSecure && (c == '(' || c == ')' || c == '<' || c == '>')) {
                sBuf.append('\\');
                sBuf.append('u');
                sBuf.append(IOUtil.DIGITS[c >>> 12 & 0xF]);
                sBuf.append(IOUtil.DIGITS[c >>> 8 & 0xF]);
                sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                sBuf.append(IOUtil.DIGITS[c & 0xF]);
                continue;
            }
            if (isTransfer && c == '\\') {
                sBuf.append("\\");
                sBuf.append(IOUtil.CHARS_MARK[c]);
                continue;
            }
            if (isCompatible) {
                if (c == '\\') {
                    sBuf.append("\\");
                    sBuf.append(IOUtil.CHARS_MARK[c]);
                    continue;
                }
                if (c < ' ') {
                    sBuf.append('\\');
                    sBuf.append('u');
                    sBuf.append('0');
                    sBuf.append('0');
                    sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c & 0xF]);
                    continue;
                }
                if (c >= '\u007f') {
                    sBuf.append('\\');
                    sBuf.append('u');
                    sBuf.append(IOUtil.DIGITS[c >>> 12 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c >>> 8 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c & 0xF]);
                    continue;
                }
            }
            sBuf.append(c);
        }
    }
}

