/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.snack.ONodeType;
import org.noear.snack.OValue;
import org.noear.snack.core.Feature;

public class ONodeData {
    public OValue value = null;
    public Map<String, ONode> object = null;
    public List<ONode> array = null;
    public ONodeType nodeType = ONodeType.Null;
    protected ONode _n;
    public Map<String, String> attrs = null;

    public ONodeData(ONode n) {
        this._n = n;
    }

    public Map<String, ONode> object() {
        this.tryInitObject();
        return this.object;
    }

    public List<ONode> array() {
        this.tryInitArray();
        return this.array;
    }

    public OValue value() {
        this.tryInitValue();
        return this.value;
    }

    protected void tryInitNull() {
        if (this.nodeType != ONodeType.Null) {
            this.nodeType = ONodeType.Null;
            if (this.object != null) {
                this.object.clear();
                this.object = null;
            }
            if (this.array != null) {
                this.array.clear();
                this.array = null;
            }
            this.value = null;
        }
    }

    protected void tryInitValue() {
        if (this.nodeType != ONodeType.Value) {
            this.nodeType = ONodeType.Value;
            if (this.value == null) {
                this.value = new OValue(this._n);
            }
        }
    }

    protected void tryInitObject() {
        if (this.nodeType != ONodeType.Object) {
            this.nodeType = ONodeType.Object;
            if (this.object == null) {
                this.object = this._n._o.hasFeature(Feature.OrderedField) ? new ONodeLinkedObject() : new ONodeObject();
            }
        }
    }

    protected void tryInitArray() {
        if (this.nodeType != ONodeType.Array) {
            this.nodeType = ONodeType.Array;
            if (this.array == null) {
                this.array = new ONodeArray();
            }
        }
    }

    protected void shiftToArray() {
        this.tryInitArray();
        if (this.object != null) {
            for (ONode n1 : this.object.values()) {
                this.array.add(n1);
            }
            this.object.clear();
            this.object = null;
        }
    }

    public String attrGet(String key) {
        if (this.attrs != null) {
            return this.attrs.get(key);
        }
        return null;
    }

    public void attrSet(String key, String val) {
        if (this.attrs == null) {
            this.attrs = new LinkedHashMap<String, String>();
        }
        this.attrs.put(key, val);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        if (this.nodeType == ONodeType.Object) {
            return this.object.hashCode();
        }
        if (this.nodeType == ONodeType.Array) {
            return this.array.hashCode();
        }
        if (this.nodeType == ONodeType.Value) {
            return this.value.hashCode();
        }
        return 0;
    }

    class ONodeLinkedObject
    extends LinkedHashMap<String, ONode> {
        ONodeLinkedObject() {
        }

        @Override
        public boolean containsValue(Object value) {
            for (ONode n : this.values()) {
                if (!n.equals(value)) continue;
                return true;
            }
            return false;
        }
    }

    class ONodeObject
    extends HashMap<String, ONode> {
        ONodeObject() {
        }

        @Override
        public boolean containsValue(Object value) {
            for (ONode n : this.values()) {
                if (!n.equals(value)) continue;
                return true;
            }
            return false;
        }
    }

    class ONodeArray
    extends ArrayList<ONode> {
        ONodeArray() {
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < this.size(); ++i) {
                if (!((ONode)this.get(i)).equals(o)) continue;
                return i;
            }
            return -1;
        }
    }
}

