/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.exts;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.util.TimeZone;
import org.noear.snack.annotation.NodeName;
import org.noear.snack.annotation.ONodeAttr;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.exception.SnackException;

public class FieldWrap {
    public final Field field;
    public final Class<?> type;
    public final Type genericType;
    public final boolean readonly;
    private String name;
    private String format;
    private TimeZone timeZone;
    private boolean serialize = true;
    private boolean deserialize = true;
    private boolean incNull = true;
    private Method _setter;

    public FieldWrap(Class<?> clz, Field f, boolean isFinal) {
        ONodeAttr attr;
        this.field = f;
        this.type = f.getType();
        this.genericType = f.getGenericType();
        this.readonly = isFinal;
        NodeName anno = f.getAnnotation(NodeName.class);
        if (anno != null) {
            this.name = anno.value();
        }
        if ((attr = f.getAnnotation(ONodeAttr.class)) != null) {
            this.name = attr.name();
            this.format = attr.format();
            this.incNull = attr.incNull();
            if (!StringUtil.isEmpty(attr.timezone())) {
                this.timeZone = TimeZone.getTimeZone(ZoneId.of(attr.timezone()));
            }
            if (attr.ignore()) {
                this.serialize = false;
                this.deserialize = false;
            } else {
                this.serialize = attr.serialize();
                this.deserialize = attr.deserialize();
            }
        }
        if (StringUtil.isEmpty(this.name)) {
            this.name = this.field.getName();
        }
        this._setter = FieldWrap.doFindSetter(clz, f);
    }

    @Deprecated
    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isDeserialize() {
        return this.deserialize;
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public boolean isIncNull() {
        return this.incNull;
    }

    public void setValue(Object tObj, Object val) {
        this.setValue(tObj, val, true);
    }

    public void setValue(Object tObj, Object val, boolean disFun) {
        if (this.readonly) {
            return;
        }
        try {
            if (this._setter == null || disFun) {
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                this.field.set(tObj, val);
            } else {
                this._setter.invoke(tObj, val);
            }
        }
        catch (IllegalArgumentException ex) {
            if (val == null) {
                throw new IllegalArgumentException(this.field.getName() + "(" + this.field.getType().getSimpleName() + ") Type receive failur!", ex);
            }
            throw new IllegalArgumentException(this.field.getName() + "(" + this.field.getType().getSimpleName() + ") Type receive failure \uff1aval(" + val.getClass().getSimpleName() + ")", ex);
        }
        catch (IllegalAccessException e) {
            throw new SnackException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Object getValue(Object tObj) {
        try {
            if (!this.field.isAccessible()) {
                this.field.setAccessible(true);
            }
            return this.field.get(tObj);
        }
        catch (IllegalAccessException ex) {
            throw new SnackException(ex);
        }
    }

    private static Method doFindSetter(Class<?> tCls, Field field) {
        String fieldName = field.getName();
        String firstLetter = fieldName.substring(0, 1).toUpperCase();
        String setMethodName = "set" + firstLetter + fieldName.substring(1);
        try {
            Method setFun = tCls.getMethod(setMethodName, field.getType());
            if (setFun != null) {
                return setFun;
            }
        }
        catch (NoSuchMethodException setFun) {
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

