/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketDConnectionException;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_tcp.TcpBioChannelAssistant;
import org.noear.socketd.transport.java_tcp.TcpBioClient;
import org.noear.socketd.utils.RunUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpBioClientConnector
extends ClientConnectorBase<TcpBioClient> {
    private static final Logger log = LoggerFactory.getLogger(TcpBioClientConnector.class);
    private Socket real;
    private Thread clientThread;

    public TcpBioClientConnector(TcpBioClient client) {
        super((ClientInternal)client);
    }

    public ChannelInternal connect() throws IOException {
        this.close();
        CompletableFuture handshakeFuture = new CompletableFuture();
        RunUtils.async(() -> {
            try {
                this.connectDo(handshakeFuture);
            }
            catch (Throwable e) {
                handshakeFuture.complete(new ClientHandshakeResult(null, e));
            }
        });
        try {
            ClientHandshakeResult handshakeResult = (ClientHandshakeResult)handshakeFuture.get(((TcpBioClient)this.client).getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketDConnectionException("Connection timeout: " + ((TcpBioClient)this.client).getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketDConnectionException("Connection failed: " + ((TcpBioClient)this.client).getConfig().getLinkUrl(), e);
        }
    }

    private void connectDo(CompletableFuture<ClientHandshakeResult> handshakeFuture) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(((TcpBioClient)this.client).getConfig().getHost(), ((TcpBioClient)this.client).getConfig().getPort());
        this.real = ((TcpBioClient)this.client).getConfig().getSslContext() == null ? new Socket() : ((TcpBioClient)this.client).getConfig().getSslContext().getSocketFactory().createSocket();
        if (((TcpBioClient)this.client).getConfig().getIdleTimeout() > 0L) {
            this.real.setSoTimeout((int)((TcpBioClient)this.client).getConfig().getIdleTimeout());
        }
        if (((TcpBioClient)this.client).getConfig().getReadBufferSize() > 0) {
            this.real.setReceiveBufferSize(((TcpBioClient)this.client).getConfig().getReadBufferSize());
        }
        if (((TcpBioClient)this.client).getConfig().getWriteBufferSize() > 0) {
            this.real.setSendBufferSize(((TcpBioClient)this.client).getConfig().getWriteBufferSize());
        }
        if (((TcpBioClient)this.client).getConfig().getConnectTimeout() > 0L) {
            this.real.connect(socketAddress, (int)((TcpBioClient)this.client).getConfig().getConnectTimeout());
        } else {
            this.real.connect(socketAddress);
        }
        ChannelDefault channel = new ChannelDefault((Object)this.real, (ChannelSupporter)this.client);
        this.clientThread = new Thread(() -> this.lambda$connectDo$1((ChannelInternal)channel, handshakeFuture));
        this.clientThread.start();
        channel.sendConnect(((TcpBioClient)this.client).getConfig().getUrl(), ((TcpBioClient)this.client).getConfig().getMetaMap());
    }

    private void receive(ChannelInternal channel, Socket socket, CompletableFuture<ClientHandshakeResult> handshakeFuture) {
        while (!this.clientThread.isInterrupted()) {
            try {
                if (socket.isClosed()) {
                    ((TcpBioClient)this.client).getProcessor().onClose(channel);
                    break;
                }
                Frame frame = ((TcpBioChannelAssistant)((TcpBioClient)this.client).getAssistant()).read(socket);
                if (frame != null) {
                    if (frame.flag() == 11) {
                        channel.onOpenFuture((r, e) -> handshakeFuture.complete(new ClientHandshakeResult(channel, e)));
                    }
                    ((TcpBioClient)this.client).getProcessor().onReceive(channel, frame);
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (Exception e2) {
                if (e2 instanceof SocketDConnectionException) {
                    handshakeFuture.complete(new ClientHandshakeResult(channel, (Throwable)e2));
                    break;
                }
                ((TcpBioClient)this.client).getProcessor().onError(channel, (Throwable)e2);
                if (!(e2 instanceof SocketException)) continue;
                break;
            }
        }
    }

    public void close() {
        block4: {
            try {
                if (this.real != null) {
                    this.real.close();
                }
                if (this.clientThread != null) {
                    this.clientThread.interrupt();
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Client connector close error", e);
            }
        }
    }

    private /* synthetic */ void lambda$connectDo$1(ChannelInternal channel, CompletableFuture handshakeFuture) {
        this.receive(channel, this.real, handshakeFuture);
    }
}

