/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_tcp_nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.codec.ByteBufferCodecReader;
import org.noear.socketd.transport.core.codec.ByteBufferCodecWriter;
import org.noear.socketd.transport.java_tcp_nio.impl.NioAttachment;
import org.noear.socketd.transport.java_tcp_nio.impl.NioFixedLengthFrameDecoder;

public class TcpNioChannelAssistant
implements ChannelAssistant<SocketChannel> {
    private Config config;
    private static final ByteBuffer emptyBuffer = ByteBuffer.allocate(0);

    public Config getConfig() {
        return this.config;
    }

    public TcpNioChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(SocketChannel target, Frame frame) throws IOException {
        ByteBuffer buffer = ((ByteBufferCodecWriter)this.getConfig().getCodec().write(frame, i -> new ByteBufferCodecWriter(ByteBuffer.allocate(i)))).getBuffer();
        target.write(buffer);
    }

    public Frame read(SocketChannel target, NioAttachment attachment, ByteBuffer buffer) {
        NioFixedLengthFrameDecoder decoder = attachment.decoder;
        if (decoder == null) {
            if (buffer.remaining() < 4) {
                return null;
            }
            buffer.mark();
            decoder = new NioFixedLengthFrameDecoder(buffer.getInt());
            buffer.reset();
            attachment.decoder = decoder;
        }
        if (!decoder.decode(buffer)) {
            return null;
        }
        attachment.decoder = null;
        buffer = decoder.getBuffer();
        return this.getConfig().getCodec().read((CodecReader)new ByteBufferCodecReader(buffer));
    }

    public boolean isValid(SocketChannel target) {
        return target.isConnected();
    }

    public void close(SocketChannel target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(SocketChannel target) throws IOException {
        return (InetSocketAddress)target.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress(SocketChannel target) throws IOException {
        return (InetSocketAddress)target.getLocalAddress();
    }
}

