/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_tcp_nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_tcp_nio.TcpNioChannelAssistant;
import org.noear.socketd.transport.java_tcp_nio.impl.NioAttachment;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.utils.RunUtils;
import org.noear.socketd.utils.StrUtils;

public class TcpNioServer
extends ServerBase<TcpNioChannelAssistant>
implements ChannelSupporter<SocketChannel> {
    private Selector selector;
    private Thread selectThread;
    private ServerSocketChannel serverSocketChannel;
    private ExecutorService serverExecutor;

    public TcpNioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new TcpNioChannelAssistant((Config)config));
    }

    public String getTitle() {
        return "tcp/nio/java-tcp/" + SocketD.version();
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        this.selector = Selector.open();
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        if (StrUtils.isEmpty((String)this.getConfig().getHost())) {
            this.serverSocketChannel.socket().bind(new InetSocketAddress(this.getConfig().getPort()));
        } else {
            this.serverSocketChannel.socket().bind(new InetSocketAddress(this.getConfig().getHost(), this.getConfig().getPort()));
        }
        this.serverSocketChannel.register(this.selector, 16);
        this.selectThread = new Thread(this::select0);
        this.selectThread.start();
        this.serverExecutor = Executors.newFixedThreadPool(this.getConfig().getCodecThreads());
        return this;
    }

    private void select0() {
        while (!this.selectThread.isInterrupted()) {
            try {
                if (this.selector.select() <= 0) continue;
                Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = selectionKeys.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    try {
                        this.onSelect(selectionKey);
                    }
                    catch (IOException e) {
                        this.onError((NioAttachment)selectionKey.attachment(), e);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClosedSelectorException e) {
                this.stop();
                return;
            }
        }
    }

    private void onSelect(SelectionKey selectionKey) throws IOException {
        if (selectionKey.isAcceptable()) {
            ServerSocketChannel serverChannel = (ServerSocketChannel)selectionKey.channel();
            SocketChannel socketChannel = serverChannel.accept();
            if (this.getConfig().getIdleTimeout() > 0L) {
                socketChannel.socket().setSoTimeout((int)this.getConfig().getIdleTimeout());
            }
            if (this.getConfig().getReadBufferSize() > 0) {
                socketChannel.socket().setReceiveBufferSize(this.getConfig().getReadBufferSize());
            }
            if (this.getConfig().getWriteBufferSize() > 0) {
                socketChannel.socket().setSendBufferSize(this.getConfig().getWriteBufferSize());
            }
            socketChannel.configureBlocking(false);
            NioAttachment attachment = new NioAttachment((Config)this.getConfig());
            socketChannel.register(this.selector, 1, attachment);
            this.onConnect(socketChannel, attachment);
        } else if (selectionKey.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            NioAttachment socketAttachment = (NioAttachment)selectionKey.attachment();
            this.onRead(socketChannel, socketAttachment);
        } else if (selectionKey.isWritable()) {
            // empty if block
        }
        if (!selectionKey.isValid()) {
            this.onClose((NioAttachment)selectionKey.attachment());
        }
    }

    private void onConnect(SocketChannel socket, NioAttachment attachment) throws IOException {
        ChannelDefault channel = new ChannelDefault((Object)socket, (ChannelSupporter)this);
        attachment.channelInternal = channel;
    }

    private void onRead(SocketChannel socket, NioAttachment attachment) {
        ByteBuffer buffer = attachment.buffer;
        try {
            int len = -1;
            while ((len = socket.read(buffer)) > 0) {
                buffer.flip();
                this.onRead0(socket, attachment, buffer);
                if (buffer.hasRemaining()) continue;
                buffer.clear();
            }
        }
        catch (IOException e) {
            this.onClose(attachment);
            this.onError(attachment, e);
        }
    }

    private void onRead0(SocketChannel socket, NioAttachment attachment, ByteBuffer buffer) {
        Frame frame = ((TcpNioChannelAssistant)this.getAssistant()).read(socket, attachment, buffer);
        if (frame != null) {
            if (buffer.hasRemaining()) {
                buffer.compact();
            }
            this.getProcessor().reveFrame(attachment.channelInternal, frame);
        }
    }

    private void onClose(NioAttachment attachment) {
        if (attachment != null && attachment.channelInternal != null) {
            this.getProcessor().onClose(attachment.channelInternal);
        }
    }

    private void onError(NioAttachment attachment, Throwable err) {
        if (attachment != null && attachment.channelInternal != null) {
            this.getProcessor().onError(attachment.channelInternal, err);
        }
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        super.stop();
        if (this.selector != null) {
            RunUtils.runAndTry(this.selector::close);
        }
        if (this.serverSocketChannel != null) {
            RunUtils.runAndTry(this.serverSocketChannel::close);
        }
        this.selectThread.interrupt();
    }
}

