/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.noear.socketd.exception.SocketDSizeLimitException;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.codec.ByteBufferCodecReader;
import org.noear.socketd.transport.core.codec.ByteBufferCodecWriter;
import org.noear.socketd.utils.IoCompletionHandler;

public class TcpBioChannelAssistant
implements ChannelAssistant<Socket> {
    private final Config config;

    public TcpBioChannelAssistant(Config config) {
        this.config = config;
    }

    public boolean isValid(Socket target) {
        return target.isConnected();
    }

    public void close(Socket target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(Socket target) {
        return (InetSocketAddress)target.getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress(Socket target) {
        return (InetSocketAddress)target.getLocalSocketAddress();
    }

    public void write(Socket source, Frame frame, ChannelInternal channel, IoCompletionHandler completionHandler) {
        try {
            OutputStream output = source.getOutputStream();
            ByteBuffer buffer = ((ByteBufferCodecWriter)this.config.getCodec().write(frame, i -> new ByteBufferCodecWriter(ByteBuffer.allocate(i)))).getBuffer();
            output.write(buffer.array());
            output.flush();
            completionHandler.completed(true, null);
        }
        catch (Throwable e) {
            completionHandler.completed(false, e);
        }
    }

    public Frame read(Socket source) throws IOException {
        InputStream input = source.getInputStream();
        if (input == null) {
            return null;
        }
        byte[] lenBts = new byte[4];
        if (input.read(lenBts) == -1) {
            return null;
        }
        int frameLength = TcpBioChannelAssistant.bytesToInt32(lenBts);
        if (frameLength == 0) {
            return null;
        }
        if (frameLength > 0x1100000) {
            throw new SocketDSizeLimitException("Adjusted frame length exceeds 17825792: " + frameLength + " - discarded");
        }
        ByteBuffer buffer = ByteBuffer.allocate(frameLength);
        buffer.putInt(frameLength);
        int bufSize = this.config.getReadBufferSize();
        byte[] buf = new byte[bufSize];
        int readSize = 0;
        while (true) {
            readSize = buffer.remaining() > bufSize ? bufSize : buffer.remaining();
            if ((readSize = input.read(buf, 0, readSize)) <= 0) break;
            buffer.put(buf, 0, readSize);
        }
        buffer.flip();
        return this.config.getCodec().read((CodecReader)new ByteBufferCodecReader(buffer));
    }

    private static int bytesToInt32(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
        }
        return value;
    }
}

