/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_tcp_nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketDConnectionException;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_tcp_nio.TcpNioChannelAssistant;
import org.noear.socketd.transport.java_tcp_nio.TcpNioClient;
import org.noear.socketd.transport.java_tcp_nio.impl.NioAttachment;
import org.noear.socketd.utils.RunUtils;
import org.noear.socketd.utils.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpNioClientConnector
extends ClientConnectorBase<TcpNioClient> {
    private static final Logger log = LoggerFactory.getLogger(TcpNioClientConnector.class);
    private Selector selector;
    private Thread selectThread;
    private SocketChannel real;
    private CompletableFuture<ClientHandshakeResult> handshakeFuture = new CompletableFuture();

    public TcpNioClientConnector(TcpNioClient client) {
        super((ClientInternal)client);
    }

    public ChannelInternal connect() throws IOException {
        this.selector = Selector.open();
        this.real = SocketChannel.open();
        try {
            this.real.configureBlocking(false);
            if (StrUtils.isEmpty((String)this.getConfig().getHost())) {
                this.real.connect(new InetSocketAddress(this.getConfig().getPort()));
            } else {
                this.real.connect(new InetSocketAddress(this.getConfig().getHost(), this.getConfig().getPort()));
            }
            this.real.register(this.selector, 8);
            this.selectThread = new Thread(this::select0);
            this.selectThread.start();
            ClientHandshakeResult handshakeResult = this.handshakeFuture.get(((TcpNioClient)this.client).getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketDConnectionException("Connection timeout: " + ((TcpNioClient)this.client).getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketDConnectionException("Connection failed: " + ((TcpNioClient)this.client).getConfig().getLinkUrl(), e);
        }
    }

    private void select0() {
        while (!this.selectThread.isInterrupted()) {
            try {
                if (this.selector.select() <= 0) continue;
                Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = selectionKeys.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    try {
                        this.onSelect(selectionKey);
                    }
                    catch (IOException e) {
                        this.onError((NioAttachment)selectionKey.attachment(), e);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClosedSelectorException e) {
                this.close();
                return;
            }
        }
    }

    private void onSelect(SelectionKey selectionKey) throws IOException {
        if (selectionKey.isConnectable()) {
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            if (socketChannel.finishConnect()) {
                if (this.getConfig().getIdleTimeout() > 0L) {
                    socketChannel.socket().setSoTimeout((int)this.getConfig().getIdleTimeout());
                }
                if (this.getConfig().getReadBufferSize() > 0) {
                    socketChannel.socket().setReceiveBufferSize(this.getConfig().getReadBufferSize());
                }
                if (this.getConfig().getWriteBufferSize() > 0) {
                    socketChannel.socket().setSendBufferSize(this.getConfig().getWriteBufferSize());
                }
                socketChannel.configureBlocking(false);
                NioAttachment attachment = new NioAttachment((Config)this.getConfig());
                socketChannel.register(this.selector, 1, attachment);
                this.onConnect(socketChannel, attachment);
            }
        } else if (selectionKey.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            NioAttachment socketAttachment = (NioAttachment)selectionKey.attachment();
            ByteBuffer buffer = socketAttachment.buffer;
            while (socketChannel.read(buffer) > 0) {
                buffer.flip();
                this.onRead(socketChannel, socketAttachment, buffer);
                if (buffer.hasRemaining()) continue;
                buffer.clear();
            }
        } else if (selectionKey.isWritable()) {
            // empty if block
        }
        if (!selectionKey.isValid()) {
            this.onClose((NioAttachment)selectionKey.attachment());
        }
    }

    private void onConnect(SocketChannel socket, NioAttachment attachment) throws IOException {
        ChannelDefault channel = new ChannelDefault((Object)socket, (ChannelSupporter)this.client);
        attachment.channelInternal = channel;
        channel.sendConnect(((TcpNioClient)this.client).getConfig().getUrl(), ((TcpNioClient)this.client).getConfig().getMetaMap());
    }

    private void onRead(SocketChannel socket, NioAttachment attachment, ByteBuffer buffer) {
        Frame frame = ((TcpNioChannelAssistant)((TcpNioClient)this.client).getAssistant()).read(socket, attachment, buffer);
        if (frame != null) {
            if (buffer.hasRemaining()) {
                buffer.compact();
            }
            if (frame.flag() == 11) {
                attachment.channelInternal.onOpenFuture((r, e) -> this.handshakeFuture.complete(new ClientHandshakeResult(attachment.channelInternal, e)));
            }
            ((TcpNioClient)this.client).getProcessor().reveFrame(attachment.channelInternal, frame);
        }
    }

    private void onClose(NioAttachment attachment) {
        if (attachment != null && attachment.channelInternal != null) {
            ((TcpNioClient)this.client).getProcessor().onClose(attachment.channelInternal);
        }
    }

    private void onError(NioAttachment attachment, Throwable err) {
        if (attachment != null && attachment.channelInternal != null) {
            ((TcpNioClient)this.client).getProcessor().onError(attachment.channelInternal, err);
        }
    }

    public void close() {
        if (this.selector != null) {
            RunUtils.runAndTry(this.selector::close);
        }
        if (this.real != null) {
            RunUtils.runAndTry(this.real::close);
        }
        this.selectThread.interrupt();
    }
}

