/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_udp.UdpBioChannelAssistant;
import org.noear.socketd.transport.java_udp.impl.DatagramFrame;
import org.noear.socketd.transport.java_udp.impl.DatagramTagert;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpBioServer
extends ServerBase<UdpBioChannelAssistant>
implements ChannelSupporter<DatagramTagert> {
    private static final Logger log = LoggerFactory.getLogger(UdpBioServer.class);
    private Map<String, ChannelInternal> channelMap = new HashMap<String, ChannelInternal>();
    private DatagramSocket server;
    private ExecutorService serverExecutor;

    public UdpBioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new UdpBioChannelAssistant((Config)config));
    }

    private DatagramSocket createServer() throws IOException {
        return new DatagramSocket(this.getConfig().getPort());
    }

    public String getTitle() {
        return "udp/bio/java-udp/" + SocketD.version();
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        this.serverExecutor = Executors.newFixedThreadPool(this.getConfig().getWorkThreads());
        this.server = this.createServer();
        this.serverExecutor.submit(this::accept);
        log.info("Socket.D server started: {server=" + this.getConfig().getLocalUrl() + "}");
        return this;
    }

    private void accept() {
        block5: while (true) {
            try {
                while (true) {
                    DatagramFrame datagramFrame;
                    if ((datagramFrame = ((UdpBioChannelAssistant)this.getAssistant()).read(this.server)) == null) {
                        continue;
                    }
                    boolean isNewConnect = datagramFrame.getFrame().flag() == 10;
                    ChannelInternal channel = this.getChannel(datagramFrame, isNewConnect);
                    try {
                        this.serverExecutor.submit(() -> {
                            block2: {
                                try {
                                    this.getProcessor().reveFrame(channel, datagramFrame.getFrame());
                                }
                                catch (Throwable e) {
                                    if (!log.isWarnEnabled()) break block2;
                                    log.warn("Server receive error", e);
                                }
                            }
                        });
                        continue block5;
                    }
                    catch (RejectedExecutionException e) {
                        log.warn("Server thread pool is full", (Throwable)e);
                        continue;
                    }
                    catch (Throwable e) {
                        log.warn("Server thread pool error", e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                if (this.server.isClosed()) {
                    return;
                }
                log.warn("Server accept error", e);
                continue;
            }
            break;
        }
    }

    private ChannelInternal getChannel(DatagramFrame datagramFrame, boolean isNewConnect) {
        String addressAndPort = datagramFrame.getPacketAddress();
        ChannelInternal channel0 = this.channelMap.get(addressAndPort);
        if (isNewConnect && channel0 != null) {
            try {
                this.getProcessor().onClose(channel0);
            }
            catch (Throwable e) {
                this.getProcessor().onError(channel0, e);
            }
            channel0 = null;
        }
        if (channel0 == null) {
            DatagramTagert tagert = new DatagramTagert(this.server, datagramFrame.getPacket(), false);
            channel0 = new ChannelDefault((Object)tagert, (ChannelSupporter)this);
            this.channelMap.put(addressAndPort, channel0);
        }
        return channel0;
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        super.stop();
        try {
            if (this.server != null) {
                this.server.close();
            }
            if (this.serverExecutor != null) {
                this.serverExecutor.shutdown();
            }
        }
        catch (Exception e) {
            log.debug("Server stop error", (Throwable)e);
        }
    }
}

