/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_udp.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;

public class DatagramTagert
implements Closeable {
    private final boolean isClient;
    private final DatagramSocket socket;
    private final DatagramPacket packet;

    public DatagramTagert(DatagramSocket socket, DatagramPacket packet, boolean isClient) {
        this.socket = socket;
        this.packet = packet;
        this.isClient = isClient;
    }

    public void send(byte[] bytes) throws IOException {
        if (this.isClient) {
            this.socket.send(new DatagramPacket(bytes, bytes.length, this.socket.getRemoteSocketAddress()));
        } else {
            this.socket.send(new DatagramPacket(bytes, bytes.length, this.packet.getSocketAddress()));
        }
    }

    public InetSocketAddress getRemoteAddress() throws IOException {
        if (this.isClient) {
            return (InetSocketAddress)this.socket.getRemoteSocketAddress();
        }
        return (InetSocketAddress)this.packet.getSocketAddress();
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    public void close() throws IOException {
        if (this.isClient) {
            this.socket.close();
        }
    }
}

