/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.tcp;

import java.io.IOException;
import java.io.NotActiveException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.tcp.TcpAioBufferWriter;
import org.smartboot.socket.transport.AioSession;

public class TcpAioChannelAssistant
implements ChannelAssistant<AioSession> {
    private final Config config;

    public TcpAioChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(AioSession source, Frame frame) throws IOException {
        if (source.isInvalid()) {
            throw new NotActiveException();
        }
        this.config.getCodec().write(frame, i -> new TcpAioBufferWriter(source.writeBuffer()));
    }

    public boolean isValid(AioSession target) {
        return !target.isInvalid();
    }

    public void close(AioSession target) throws IOException {
        block3: {
            if (!target.isInvalid()) {
                try {
                    target.close();
                }
                catch (Throwable e) {
                    if (e instanceof ClosedChannelException) break block3;
                    throw e;
                }
            }
        }
    }

    public InetSocketAddress getRemoteAddress(AioSession target) throws IOException {
        return target.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress(AioSession target) throws IOException {
        return target.getLocalAddress();
    }
}

