/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.tcp.impl;

import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.tcp.TcpAioServer;
import org.noear.socketd.transport.smartsocket.tcp.impl.ChannelDefaultEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.transport.AioSession;

public class ServerMessageProcessor
extends AbstractMessageProcessor<Frame> {
    private static final Logger log = LoggerFactory.getLogger(ServerMessageProcessor.class);
    private TcpAioServer server;

    public ServerMessageProcessor(TcpAioServer server) {
        this.server = server;
    }

    public void process0(AioSession s, Frame frame) {
        ChannelInternal channel = (ChannelInternal)s.getAttachment();
        try {
            this.server.getProcessor().reveFrame(channel, frame);
        }
        catch (Throwable e) {
            if (channel == null) {
                log.warn("Server process0 error", e);
            }
            this.server.getProcessor().onError(channel, e);
        }
    }

    public void stateEvent0(AioSession s, StateMachineEnum state, Throwable e) {
        switch (state) {
            case NEW_SESSION: {
                s.setAttachment(new ChannelDefaultEx<AioSession>(s, this.server));
                break;
            }
            case SESSION_CLOSED: {
                ChannelDefaultEx c = (ChannelDefaultEx)((Object)s.getAttachment());
                this.server.getProcessor().onClose((ChannelInternal)c);
                break;
            }
            case PROCESS_EXCEPTION: 
            case DECODE_EXCEPTION: 
            case INPUT_EXCEPTION: 
            case ACCEPT_EXCEPTION: 
            case OUTPUT_EXCEPTION: {
                ChannelDefaultEx c = (ChannelDefaultEx)((Object)s.getAttachment());
                if (c == null) break;
                this.server.getProcessor().onError((ChannelInternal)c, e);
                break;
            }
        }
    }
}

