/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Codec;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.FragmentHandler;
import org.noear.socketd.transport.core.IdGenerator;
import org.noear.socketd.transport.core.codec.CodecDefault;
import org.noear.socketd.transport.core.fragment.FragmentHandlerDefault;
import org.noear.socketd.transport.core.identifier.GuidGenerator;
import org.noear.socketd.transport.stream.StreamManger;
import org.noear.socketd.transport.stream.impl.StreamMangerDefault;
import org.noear.socketd.utils.NamedThreadFactory;

public abstract class ConfigBase<T extends Config>
implements Config {
    private final boolean clientMode;
    private boolean serialSend;
    private boolean nolockSend;
    private final StreamManger streamManger;
    private final Codec codec;
    private IdGenerator idGenerator;
    private FragmentHandler fragmentHandler;
    private int fragmentSize;
    private SSLContext sslContext;
    protected Charset charset;
    protected int ioThreads;
    protected int codecThreads;
    protected int exchangeThreads;
    private volatile ExecutorService exchangeExecutor;
    private volatile ExecutorService exchangeExecutorSelfNew;
    protected int readBufferSize;
    protected int writeBufferSize;
    protected long idleTimeout;
    protected long requestTimeout;
    protected long streamTimeout;
    protected int maxUdpSize;
    private ReentrantLock EXECUTOR_LOCK = new ReentrantLock();

    public ConfigBase(boolean clientMode) {
        this.clientMode = clientMode;
        this.serialSend = false;
        this.nolockSend = false;
        this.streamManger = new StreamMangerDefault(this);
        this.codec = new CodecDefault(this);
        this.charset = StandardCharsets.UTF_8;
        this.idGenerator = new GuidGenerator();
        this.fragmentHandler = new FragmentHandlerDefault();
        this.fragmentSize = 0x1000000;
        this.ioThreads = 1;
        this.codecThreads = Runtime.getRuntime().availableProcessors();
        this.exchangeThreads = Runtime.getRuntime().availableProcessors() * 4;
        this.readBufferSize = 4096;
        this.writeBufferSize = 4096;
        this.idleTimeout = 60000L;
        this.requestTimeout = 10000L;
        this.streamTimeout = 0x6DDD00L;
        this.maxUdpSize = 2048;
    }

    @Override
    public boolean clientMode() {
        return this.clientMode;
    }

    @Override
    public boolean isSerialSend() {
        return this.serialSend;
    }

    public T serialSend(boolean serialSend) {
        this.serialSend = serialSend;
        return (T)this;
    }

    @Override
    public boolean isNolockSend() {
        return this.nolockSend;
    }

    public T nolockSend(boolean nolockSend) {
        this.nolockSend = nolockSend;
        return (T)this;
    }

    @Override
    public StreamManger getStreamManger() {
        return this.streamManger;
    }

    @Override
    public String getRoleName() {
        return this.clientMode() ? "Client" : "Server";
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    public T charset(Charset charset) {
        this.charset = charset;
        return (T)this;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    @Override
    public FragmentHandler getFragmentHandler() {
        return this.fragmentHandler;
    }

    public T fragmentHandler(FragmentHandler fragmentHandler) {
        Asserts.assertNull("fragmentHandler", fragmentHandler);
        this.fragmentHandler = fragmentHandler;
        return (T)this;
    }

    @Override
    public int getFragmentSize() {
        return this.fragmentSize;
    }

    public T fragmentSize(int fragmentSize) {
        if (fragmentSize > 0x1000000) {
            throw new IllegalArgumentException("The parameter fragmentSize cannot > 16m");
        }
        if (fragmentSize < 1024) {
            throw new IllegalArgumentException("The parameter fragmentSize cannot < 1k");
        }
        this.fragmentSize = fragmentSize;
        return (T)this;
    }

    @Override
    public String genId() {
        return this.idGenerator.generate();
    }

    public T idGenerator(IdGenerator idGenerator) {
        Asserts.assertNull("idGenerator", idGenerator);
        this.idGenerator = idGenerator;
        return (T)this;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public T sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return (T)this;
    }

    @Override
    public ExecutorService getExchangeExecutor() {
        if (this.exchangeExecutor == null) {
            this.EXECUTOR_LOCK.lock();
            try {
                if (this.exchangeExecutor == null) {
                    int nThreads = this.getExchangeThreads();
                    this.exchangeExecutor = this.exchangeExecutorSelfNew = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Socketd-channelExecutor-"));
                }
            }
            finally {
                this.EXECUTOR_LOCK.unlock();
            }
        }
        return this.exchangeExecutor;
    }

    public T exchangeExecutor(ExecutorService exchangeExecutor) {
        this.exchangeExecutor = exchangeExecutor;
        if (this.exchangeExecutorSelfNew != null) {
            this.exchangeExecutorSelfNew.shutdown();
        }
        return (T)this;
    }

    @Override
    public int getIoThreads() {
        return this.ioThreads;
    }

    public T ioThreads(int ioThreads) {
        this.ioThreads = ioThreads;
        return (T)this;
    }

    @Override
    public int getCodecThreads() {
        return this.codecThreads;
    }

    public T codecThreads(int codecThreads) {
        this.codecThreads = codecThreads;
        return (T)this;
    }

    @Override
    public int getExchangeThreads() {
        return this.exchangeThreads;
    }

    public T exchangeThreads(int exchangeThreads) {
        this.exchangeThreads = exchangeThreads;
        return (T)this;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public T readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return (T)this;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public T writeBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return (T)this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public T idleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return (T)this;
    }

    @Override
    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public T requestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (T)this;
    }

    @Override
    public long getStreamTimeout() {
        return this.streamTimeout;
    }

    public T streamTimeout(long streamTimeout) {
        this.streamTimeout = streamTimeout;
        return (T)this;
    }

    @Override
    public int getMaxUdpSize() {
        return this.maxUdpSize;
    }

    public T maxUdpSize(int maxUdpSize) {
        this.maxUdpSize = maxUdpSize;
        return (T)this;
    }
}

