/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.server;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.impl.ProcessorDefault;
import org.noear.socketd.transport.core.listener.SimpleListener;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.server.ServerConfigHandler;
import org.noear.socketd.utils.RunUtils;

public abstract class ServerBase<T extends ChannelAssistant>
implements Server,
Listener {
    protected final Processor processor = new ProcessorDefault();
    protected final Collection<Session> sessions = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Listener listener = new SimpleListener();
    protected final ServerConfig config;
    protected final T assistant;
    protected boolean isStarted;

    public ServerBase(ServerConfig config, T assistant) {
        this.config = config;
        this.assistant = assistant;
        this.processor.setListener(this);
    }

    public T getAssistant() {
        return this.assistant;
    }

    @Override
    public ServerConfig getConfig() {
        return this.config;
    }

    @Override
    public Server config(ServerConfigHandler configHandler) {
        if (configHandler != null) {
            configHandler.serverConfig(this.config);
        }
        return this;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public Server listen(Listener listener) {
        if (listener != null) {
            this.listener = listener;
        }
        return this;
    }

    @Override
    public void prestop() {
        this.prestopDo();
    }

    @Override
    public void stop() {
        this.stopDo();
    }

    @Override
    public void onOpen(Session s) throws IOException {
        this.sessions.add(s);
        this.listener.onOpen(s);
    }

    @Override
    public void onMessage(Session s, Message m) throws IOException {
        this.listener.onMessage(s, m);
    }

    @Override
    public void onClose(Session s) {
        this.sessions.remove(s);
        this.listener.onClose(s);
    }

    @Override
    public void onError(Session s, Throwable e) {
        this.listener.onError(s, e);
    }

    protected void prestopDo() {
        for (Session s1 : this.sessions) {
            if (!s1.isValid()) continue;
            RunUtils.runAndTry(s1::preclose);
        }
    }

    protected void stopDo() {
        for (Session s1 : this.sessions) {
            if (!s1.isValid()) continue;
            RunUtils.runAndTry(s1::close);
        }
        this.sessions.clear();
    }
}

