/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.server;

import org.noear.socketd.transport.core.impl.ConfigBase;
import org.noear.socketd.utils.StrUtils;

public class ServerConfig
extends ConfigBase<ServerConfig> {
    private final String schema;
    private final String schemaCleaned;
    private String host;
    private int port;

    public ServerConfig(String schema) {
        super(false);
        this.schema = schema;
        if (schema.startsWith("sd:")) {
            schema = schema.substring(3);
        }
        this.schemaCleaned = schema;
        this.host = "";
        this.port = 8602;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHost() {
        return this.host;
    }

    public ServerConfig host(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ServerConfig port(int port) {
        this.port = port;
        return this;
    }

    public String getLocalUrl() {
        if (StrUtils.isEmpty(this.host)) {
            return "sd:" + this.schemaCleaned + "://127.0.0.1:" + this.port;
        }
        return "sd:" + this.schemaCleaned + "://" + this.host + ":" + this.port;
    }

    public String toString() {
        return "ServerConfig{schema='" + this.schemaCleaned + '\'' + ", charset=" + this.charset + ", host='" + this.host + '\'' + ", port=" + this.port + ", ioThreads=" + this.ioThreads + ", codecThreads=" + this.codecThreads + ", exchangeThreads=" + this.exchangeThreads + ", idleTimeout=" + this.idleTimeout + ", requestTimeout=" + this.requestTimeout + ", streamTimeout=" + this.streamTimeout + ", readBufferSize=" + this.readBufferSize + ", writeBufferSize=" + this.writeBufferSize + ", maxUdpSize=" + this.maxUdpSize + '}';
    }
}

