/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.fragment;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.noear.socketd.exception.SocketDCodecException;
import org.noear.socketd.transport.core.FragmentAggregator;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.entity.MessageBuilder;
import org.noear.socketd.transport.core.entity.TempfileEntity;
import org.noear.socketd.utils.StrUtils;

public class FragmentAggregatorTempfile
implements FragmentAggregator {
    private MessageInternal main;
    private int dataStreamSize;
    private int dataLength;
    private File tmpfile;
    private FileChannel tmpfileChannel;

    public FragmentAggregatorTempfile(MessageInternal main) throws IOException {
        this.main = main;
        String dataLengthStr = main.meta("Data-Length");
        if (StrUtils.isEmpty(dataLengthStr)) {
            throw new SocketDCodecException("Missing 'Data-Length' meta, event=" + main.event());
        }
        this.dataLength = Integer.parseInt(dataLengthStr);
        this.tmpfile = File.createTempFile(main.sid(), ".tmp");
        this.tmpfileChannel = new RandomAccessFile(this.tmpfile, "rw").getChannel();
    }

    @Override
    public String getSid() {
        return this.main.sid();
    }

    @Override
    public int getDataStreamSize() {
        return this.dataStreamSize;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public void add(int index, MessageInternal message) throws IOException {
        this.tmpfileChannel.write(message.data());
        this.dataStreamSize += message.dataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame get() throws IOException {
        try {
            MappedByteBuffer dataBuffer = this.tmpfileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.dataLength);
            TempfileEntity entity = new TempfileEntity(this.tmpfile, this.tmpfileChannel, dataBuffer, this.main.metaMap());
            entity.metaMap().remove("Data-Fragment-Idx");
            Frame frame = new Frame(this.main.flag(), new MessageBuilder().flag(this.main.flag()).sid(this.main.sid()).event(this.main.event()).entity(entity).build());
            return frame;
        }
        finally {
            this.tmpfileChannel.close();
        }
    }
}

