/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.listener;

import java.io.IOException;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.listener.EventListener;
import org.noear.socketd.transport.core.listener.RouteSelector;
import org.noear.socketd.transport.core.listener.RouteSelectorDefault;

public class PathListener
implements Listener {
    protected final RouteSelector<Listener> pathRouteSelector;

    public PathListener() {
        this.pathRouteSelector = new RouteSelectorDefault<Listener>();
    }

    public PathListener(RouteSelector<Listener> routeSelector) {
        this.pathRouteSelector = routeSelector;
    }

    public PathListener doOf(String path, Listener listener) {
        this.pathRouteSelector.put(path, listener);
        return this;
    }

    public EventListener of(String path) {
        EventListener listener = new EventListener();
        this.pathRouteSelector.put(path, listener);
        return listener;
    }

    public int size() {
        return this.pathRouteSelector.size();
    }

    @Override
    public void onOpen(Session session) throws IOException {
        Listener l1 = this.pathRouteSelector.select(session.path());
        if (l1 != null) {
            l1.onOpen(session);
        }
    }

    @Override
    public void onMessage(Session session, Message message) throws IOException {
        Listener l1 = this.pathRouteSelector.select(session.path());
        if (l1 != null) {
            l1.onMessage(session, message);
        }
    }

    @Override
    public void onReply(Session session, Message message) {
        Listener l1 = this.pathRouteSelector.select(session.path());
        if (l1 != null) {
            l1.onReply(session, message);
        }
    }

    @Override
    public void onSend(Session session, Message message) {
        Listener l1 = this.pathRouteSelector.select(session.path());
        if (l1 != null) {
            l1.onSend(session, message);
        }
    }

    @Override
    public void onClose(Session session) {
        Listener l1 = this.pathRouteSelector.select(session.path());
        if (l1 != null) {
            l1.onClose(session);
        }
    }

    @Override
    public void onError(Session session, Throwable error) {
        Listener l1 = this.pathRouteSelector.select(session.path());
        if (l1 != null) {
            l1.onError(session, error);
        }
    }
}

