/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.socketd.exception.SocketDChannelException;
import org.noear.socketd.exception.SocketDException;
import org.noear.socketd.transport.client.ClientConnector;
import org.noear.socketd.transport.client.ClientHeartbeatHandler;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.client.impl.ClientHeartbeatHandlerDefault;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.impl.ChannelBase;
import org.noear.socketd.transport.core.impl.SessionDefault;
import org.noear.socketd.transport.stream.StreamInternal;
import org.noear.socketd.utils.RunUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannel
extends ChannelBase
implements Channel {
    private static final Logger log = LoggerFactory.getLogger(ClientChannel.class);
    private final ClientInternal client;
    private final ClientConnector connector;
    private final Session sessionShell;
    private ChannelInternal real;
    private ClientHeartbeatHandler heartbeatHandler;
    private ScheduledFuture<?> heartbeatScheduledFuture;
    private AtomicBoolean isConnecting = new AtomicBoolean(false);

    public ClientChannel(ClientInternal client, ClientConnector connector) {
        super(connector.getConfig());
        this.client = client;
        this.connector = connector;
        this.sessionShell = new SessionDefault(this);
        this.heartbeatHandler = client.getHeartbeatHandler() == null ? new ClientHeartbeatHandlerDefault() : client.getHeartbeatHandler();
        this.initHeartbeat();
    }

    private void initHeartbeat() {
        if (this.heartbeatScheduledFuture != null) {
            this.heartbeatScheduledFuture.cancel(false);
        }
        if (this.connector.autoReconnect()) {
            this.heartbeatScheduledFuture = RunUtils.scheduleWithFixedDelay(() -> {
                block2: {
                    try {
                        this.heartbeatHandle();
                    }
                    catch (Throwable e) {
                        if (!log.isDebugEnabled()) break block2;
                        log.debug("Client channel heartbeat failed: {link={}}", (Object)this.connector.getConfig().getLinkUrl());
                    }
                }
            }, this.client.getHeartbeatInterval(), this.client.getHeartbeatInterval());
        }
    }

    private void heartbeatHandle() throws Throwable {
        if (this.real != null) {
            if (this.real.getHandshake() == null) {
                return;
            }
            if (Asserts.isClosedAndEnd(this.real)) {
                if (log.isDebugEnabled()) {
                    log.debug("Client channel is closed (pause heartbeat), sessionId={}", (Object)this.getSession().sessionId());
                }
                this.close(this.real.closeCode());
                return;
            }
            if (this.real.isClosing()) {
                return;
            }
        }
        try {
            this.internalCheck();
            this.heartbeatHandler.clientHeartbeat(this.getSession());
        }
        catch (SocketDException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.connector.autoReconnect()) {
                this.internalCloseIfError();
            }
            throw e;
        }
    }

    @Override
    public boolean isValid() {
        if (this.real == null) {
            return false;
        }
        return this.real.isValid();
    }

    @Override
    public boolean isClosing() {
        if (this.real == null) {
            return false;
        }
        return this.real.isClosing();
    }

    @Override
    public int closeCode() {
        if (this.real == null) {
            return 0;
        }
        return this.real.closeCode();
    }

    @Override
    public long getLiveTime() {
        if (this.real == null) {
            return 0L;
        }
        return this.real.getLiveTime();
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        if (this.real == null) {
            return null;
        }
        return this.real.getRemoteAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        if (this.real == null) {
            return null;
        }
        return this.real.getLocalAddress();
    }

    @Override
    public void send(Frame frame, StreamInternal stream) throws IOException {
        Asserts.assertClosedAndEnd(this.real);
        try {
            this.internalCheck();
            if (this.real == null) {
                throw new SocketDChannelException("Client channel is not connected");
            }
            this.real.send(frame, stream);
        }
        catch (SocketDException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.connector.autoReconnect()) {
                this.internalCloseIfError();
            }
            throw new SocketDChannelException("Client channel send failed", e);
        }
    }

    @Override
    public void onError(Throwable error) {
        this.real.onError(error);
    }

    @Override
    public void close(int code) {
        RunUtils.runAndTry(() -> this.heartbeatScheduledFuture.cancel(true));
        RunUtils.runAndTry(() -> this.connector.close());
        RunUtils.runAndTry(() -> this.real.close(code));
        super.close(code);
    }

    @Override
    public Session getSession() {
        return this.sessionShell;
    }

    @Override
    public void reconnect() throws IOException {
        this.initHeartbeat();
        this.internalCheck();
    }

    public void connect() throws IOException {
        if (!this.isConnecting.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.real != null) {
                this.real.close(2002);
            }
            this.real = this.client.getConnectHandler().clientConnect(this.connector);
            this.real.setSession(this.sessionShell);
            this.setHandshake(this.real.getHandshake());
        }
        finally {
            this.isConnecting.set(false);
        }
    }

    private void internalCloseIfError() {
        if (this.real != null) {
            this.real.close(2001);
            this.real = null;
        }
    }

    private boolean internalCheck() throws IOException {
        if (this.real == null || !this.real.isValid()) {
            this.connect();
            return true;
        }
        return false;
    }
}

