/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.noear.socketd.exception.SocketDSizeLimitException;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Codec;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.CodecWriter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Flags;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.MessageBuilder;

public class CodecDefault
implements Codec {
    private final Config config;

    public CodecDefault(Config config) {
        this.config = config;
    }

    @Override
    public <T extends CodecWriter> T write(Frame frame, Function<Integer, T> writerFactory) throws IOException {
        if (frame.message() == null) {
            int frameSize = 8;
            CodecWriter writer = (CodecWriter)writerFactory.apply(frameSize);
            writer.putInt(frameSize);
            writer.putInt(frame.flag());
            writer.flush();
            return (T)writer;
        }
        byte[] sidB = frame.message().sid().getBytes(this.config.getCharset());
        byte[] eventB = frame.message().event().getBytes(this.config.getCharset());
        byte[] metaStringB = frame.message().metaString().getBytes(this.config.getCharset());
        int frameSize = 8 + sidB.length + eventB.length + metaStringB.length + frame.message().dataSize() + 6;
        Asserts.assertSize("sid", sidB.length, 64);
        Asserts.assertSize("event", eventB.length, 512);
        Asserts.assertSize("metaString", metaStringB.length, 4096);
        Asserts.assertSize("data", frame.message().dataSize(), 0x1000000);
        CodecWriter writer = (CodecWriter)writerFactory.apply(frameSize);
        writer.putInt(frameSize);
        writer.putInt(frame.flag());
        writer.putBytes(sidB);
        writer.putChar(10);
        writer.putBytes(eventB);
        writer.putChar(10);
        writer.putBytes(metaStringB);
        writer.putChar(10);
        writer.putBytes(frame.message().dataAsBytes());
        writer.flush();
        return (T)writer;
    }

    @Override
    public Frame read(CodecReader reader) {
        byte[] data;
        int frameSize = reader.getInt();
        if (frameSize > reader.remaining() + 4) {
            return null;
        }
        if (frameSize > 0x1100000) {
            throw new SocketDSizeLimitException("Adjusted frame length exceeds 17825792: " + frameSize + " - discarded");
        }
        int flag = reader.getInt();
        if (frameSize == 8) {
            return new Frame(Flags.of(flag), null);
        }
        int metaBufSize = Math.min(4096, reader.remaining());
        ByteBuffer buf = ByteBuffer.allocate(metaBufSize);
        String sid = this.decodeString(reader, buf, 64);
        String event = this.decodeString(reader, buf, 512);
        String metaString = this.decodeString(reader, buf, 4096);
        int dataRealSize = frameSize - reader.position();
        if (dataRealSize > 0x1000000) {
            data = new byte[0x1000000];
            reader.getBytes(data, 0, 0x1000000);
            for (int i = dataRealSize - 0x1000000; i > 0; --i) {
                reader.getByte();
            }
        } else {
            data = new byte[dataRealSize];
            if (dataRealSize > 0) {
                reader.getBytes(data, 0, dataRealSize);
            }
        }
        MessageInternal message = new MessageBuilder().flag(Flags.of(flag)).sid(sid).event(event).entity(new EntityDefault().dataSet(data).metaStringSet(metaString)).build();
        return new Frame(message.flag(), message);
    }

    protected String decodeString(CodecReader reader, ByteBuffer buf, int maxLen) {
        buf.clear();
        while (true) {
            byte c;
            if ((c = reader.getByte()) == 0 && reader.peekByte() == 10) break;
            if (maxLen > 0 && maxLen <= buf.position()) continue;
            buf.put(c);
        }
        reader.skipBytes(1);
        buf.flip();
        if (buf.limit() < 1) {
            return "";
        }
        return new String(buf.array(), 0, buf.limit(), this.config.getCharset());
    }
}

