var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
(function polyfill() {
  const relList = document.createElement("link").relList;
  if (relList && relList.supports && relList.supports("modulepreload")) {
    return;
  }
  for (const link of document.querySelectorAll('link[rel="modulepreload"]')) {
    processPreload(link);
  }
  new MutationObserver((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type !== "childList") {
        continue;
      }
      for (const node of mutation.addedNodes) {
        if (node.tagName === "LINK" && node.rel === "modulepreload")
          processPreload(node);
      }
    }
  }).observe(document, { childList: true, subtree: true });
  function getFetchOpts(link) {
    const fetchOpts = {};
    if (link.integrity)
      fetchOpts.integrity = link.integrity;
    if (link.referrerPolicy)
      fetchOpts.referrerPolicy = link.referrerPolicy;
    if (link.crossOrigin === "use-credentials")
      fetchOpts.credentials = "include";
    else if (link.crossOrigin === "anonymous")
      fetchOpts.credentials = "omit";
    else
      fetchOpts.credentials = "same-origin";
    return fetchOpts;
  }
  function processPreload(link) {
    if (link.ep)
      return;
    link.ep = true;
    const fetchOpts = getFetchOpts(link);
    fetch(link.href, fetchOpts);
  }
})();
const index$v = "";
const index$u = "";
function makeMap(str, expectsLowerCase) {
  const map2 = /* @__PURE__ */ Object.create(null);
  const list = str.split(",");
  for (let i2 = 0; i2 < list.length; i2++) {
    map2[list[i2]] = true;
  }
  return expectsLowerCase ? (val) => !!map2[val.toLowerCase()] : (val) => !!map2[val];
}
const EMPTY_OBJ$1 = {};
const EMPTY_ARR = [];
const NOOP$1 = () => {
};
const NO = () => false;
const onRE = /^on[^a-z]/;
const isOn = (key) => onRE.test(key);
const isModelListener = (key) => key.startsWith("onUpdate:");
const extend$1 = Object.assign;
const remove = (arr, el) => {
  const i2 = arr.indexOf(el);
  if (i2 > -1) {
    arr.splice(i2, 1);
  }
};
const hasOwnProperty$2 = Object.prototype.hasOwnProperty;
const hasOwn$2 = (val, key) => hasOwnProperty$2.call(val, key);
const isArray$5 = Array.isArray;
const isMap = (val) => toTypeString$1(val) === "[object Map]";
const isSet = (val) => toTypeString$1(val) === "[object Set]";
const isFunction$4 = (val) => typeof val === "function";
const isString$4 = (val) => typeof val === "string";
const isSymbol = (val) => typeof val === "symbol";
const isObject$6 = (val) => val !== null && typeof val === "object";
const isPromise$1 = (val) => {
  return isObject$6(val) && isFunction$4(val.then) && isFunction$4(val.catch);
};
const objectToString$1 = Object.prototype.toString;
const toTypeString$1 = (value) => objectToString$1.call(value);
const toRawType = (value) => {
  return toTypeString$1(value).slice(8, -1);
};
const isPlainObject$1 = (val) => toTypeString$1(val) === "[object Object]";
const isIntegerKey = (key) => isString$4(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
const isReservedProp = /* @__PURE__ */ makeMap(
  // the leading comma is intentional so empty string "" is also included
  ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
);
const cacheStringFunction = (fn) => {
  const cache2 = /* @__PURE__ */ Object.create(null);
  return (str) => {
    const hit = cache2[str];
    return hit || (cache2[str] = fn(str));
  };
};
const camelizeRE = /-(\w)/g;
const camelize = cacheStringFunction((str) => {
  return str.replace(camelizeRE, (_2, c) => c ? c.toUpperCase() : "");
});
const hyphenateRE = /\B([A-Z])/g;
const hyphenate = cacheStringFunction((str) => str.replace(hyphenateRE, "-$1").toLowerCase());
const capitalize$1 = cacheStringFunction((str) => str.charAt(0).toUpperCase() + str.slice(1));
const toHandlerKey = cacheStringFunction((str) => str ? `on${capitalize$1(str)}` : ``);
const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
const invokeArrayFns = (fns, arg) => {
  for (let i2 = 0; i2 < fns.length; i2++) {
    fns[i2](arg);
  }
};
const def = (obj, key, value) => {
  Object.defineProperty(obj, key, {
    configurable: true,
    enumerable: false,
    value
  });
};
const looseToNumber = (val) => {
  const n2 = parseFloat(val);
  return isNaN(n2) ? val : n2;
};
const toNumber = (val) => {
  const n2 = isString$4(val) ? Number(val) : NaN;
  return isNaN(n2) ? val : n2;
};
let _globalThis;
const getGlobalThis = () => {
  return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
function normalizeStyle$1(value) {
  if (isArray$5(value)) {
    const res = {};
    for (let i2 = 0; i2 < value.length; i2++) {
      const item = value[i2];
      const normalized = isString$4(item) ? parseStringStyle(item) : normalizeStyle$1(item);
      if (normalized) {
        for (const key in normalized) {
          res[key] = normalized[key];
        }
      }
    }
    return res;
  } else if (isString$4(value)) {
    return value;
  } else if (isObject$6(value)) {
    return value;
  }
}
const listDelimiterRE = /;(?![^(]*\))/g;
const propertyDelimiterRE = /:([^]+)/;
const styleCommentRE = /\/\*[^]*?\*\//g;
function parseStringStyle(cssText) {
  const ret = {};
  cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item) => {
    if (item) {
      const tmp = item.split(propertyDelimiterRE);
      tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
    }
  });
  return ret;
}
function normalizeClass(value) {
  let res = "";
  if (isString$4(value)) {
    res = value;
  } else if (isArray$5(value)) {
    for (let i2 = 0; i2 < value.length; i2++) {
      const normalized = normalizeClass(value[i2]);
      if (normalized) {
        res += normalized + " ";
      }
    }
  } else if (isObject$6(value)) {
    for (const name in value) {
      if (value[name]) {
        res += name + " ";
      }
    }
  }
  return res.trim();
}
const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
const isSpecialBooleanAttr = /* @__PURE__ */ makeMap(specialBooleanAttrs);
function includeBooleanAttr(value) {
  return !!value || value === "";
}
const toDisplayString$1 = (val) => {
  return isString$4(val) ? val : val == null ? "" : isArray$5(val) || isObject$6(val) && (val.toString === objectToString$1 || !isFunction$4(val.toString)) ? JSON.stringify(val, replacer, 2) : String(val);
};
const replacer = (_key, val) => {
  if (val && val.__v_isRef) {
    return replacer(_key, val.value);
  } else if (isMap(val)) {
    return {
      [`Map(${val.size})`]: [...val.entries()].reduce((entries, [key, val2]) => {
        entries[`${key} =>`] = val2;
        return entries;
      }, {})
    };
  } else if (isSet(val)) {
    return {
      [`Set(${val.size})`]: [...val.values()]
    };
  } else if (isObject$6(val) && !isArray$5(val) && !isPlainObject$1(val)) {
    return String(val);
  }
  return val;
};
let activeEffectScope;
class EffectScope {
  constructor(detached = false) {
    this.detached = detached;
    this._active = true;
    this.effects = [];
    this.cleanups = [];
    this.parent = activeEffectScope;
    if (!detached && activeEffectScope) {
      this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(this) - 1;
    }
  }
  get active() {
    return this._active;
  }
  run(fn) {
    if (this._active) {
      const currentEffectScope = activeEffectScope;
      try {
        activeEffectScope = this;
        return fn();
      } finally {
        activeEffectScope = currentEffectScope;
      }
    }
  }
  /**
   * This should only be called on non-detached scopes
   * @internal
   */
  on() {
    activeEffectScope = this;
  }
  /**
   * This should only be called on non-detached scopes
   * @internal
   */
  off() {
    activeEffectScope = this.parent;
  }
  stop(fromParent) {
    if (this._active) {
      let i2, l;
      for (i2 = 0, l = this.effects.length; i2 < l; i2++) {
        this.effects[i2].stop();
      }
      for (i2 = 0, l = this.cleanups.length; i2 < l; i2++) {
        this.cleanups[i2]();
      }
      if (this.scopes) {
        for (i2 = 0, l = this.scopes.length; i2 < l; i2++) {
          this.scopes[i2].stop(true);
        }
      }
      if (!this.detached && this.parent && !fromParent) {
        const last = this.parent.scopes.pop();
        if (last && last !== this) {
          this.parent.scopes[this.index] = last;
          last.index = this.index;
        }
      }
      this.parent = void 0;
      this._active = false;
    }
  }
}
function effectScope(detached) {
  return new EffectScope(detached);
}
function recordEffectScope(effect, scope = activeEffectScope) {
  if (scope && scope.active) {
    scope.effects.push(effect);
  }
}
function getCurrentScope() {
  return activeEffectScope;
}
const createDep = (effects) => {
  const dep = new Set(effects);
  dep.w = 0;
  dep.n = 0;
  return dep;
};
const wasTracked = (dep) => (dep.w & trackOpBit) > 0;
const newTracked = (dep) => (dep.n & trackOpBit) > 0;
const initDepMarkers = ({
  deps
}) => {
  if (deps.length) {
    for (let i2 = 0; i2 < deps.length; i2++) {
      deps[i2].w |= trackOpBit;
    }
  }
};
const finalizeDepMarkers = (effect) => {
  const {
    deps
  } = effect;
  if (deps.length) {
    let ptr = 0;
    for (let i2 = 0; i2 < deps.length; i2++) {
      const dep = deps[i2];
      if (wasTracked(dep) && !newTracked(dep)) {
        dep.delete(effect);
      } else {
        deps[ptr++] = dep;
      }
      dep.w &= ~trackOpBit;
      dep.n &= ~trackOpBit;
    }
    deps.length = ptr;
  }
};
const targetMap = /* @__PURE__ */ new WeakMap();
let effectTrackDepth = 0;
let trackOpBit = 1;
const maxMarkerBits = 30;
let activeEffect;
const ITERATE_KEY = Symbol("");
const MAP_KEY_ITERATE_KEY = Symbol("");
class ReactiveEffect {
  constructor(fn, scheduler = null, scope) {
    this.fn = fn;
    this.scheduler = scheduler;
    this.active = true;
    this.deps = [];
    this.parent = void 0;
    recordEffectScope(this, scope);
  }
  run() {
    if (!this.active) {
      return this.fn();
    }
    let parent = activeEffect;
    let lastShouldTrack = shouldTrack;
    while (parent) {
      if (parent === this) {
        return;
      }
      parent = parent.parent;
    }
    try {
      this.parent = activeEffect;
      activeEffect = this;
      shouldTrack = true;
      trackOpBit = 1 << ++effectTrackDepth;
      if (effectTrackDepth <= maxMarkerBits) {
        initDepMarkers(this);
      } else {
        cleanupEffect(this);
      }
      return this.fn();
    } finally {
      if (effectTrackDepth <= maxMarkerBits) {
        finalizeDepMarkers(this);
      }
      trackOpBit = 1 << --effectTrackDepth;
      activeEffect = this.parent;
      shouldTrack = lastShouldTrack;
      this.parent = void 0;
      if (this.deferStop) {
        this.stop();
      }
    }
  }
  stop() {
    if (activeEffect === this) {
      this.deferStop = true;
    } else if (this.active) {
      cleanupEffect(this);
      if (this.onStop) {
        this.onStop();
      }
      this.active = false;
    }
  }
}
function cleanupEffect(effect2) {
  const {
    deps
  } = effect2;
  if (deps.length) {
    for (let i2 = 0; i2 < deps.length; i2++) {
      deps[i2].delete(effect2);
    }
    deps.length = 0;
  }
}
let shouldTrack = true;
const trackStack = [];
function pauseTracking() {
  trackStack.push(shouldTrack);
  shouldTrack = false;
}
function resetTracking() {
  const last = trackStack.pop();
  shouldTrack = last === void 0 ? true : last;
}
function track(target2, type, key) {
  if (shouldTrack && activeEffect) {
    let depsMap = targetMap.get(target2);
    if (!depsMap) {
      targetMap.set(target2, depsMap = /* @__PURE__ */ new Map());
    }
    let dep = depsMap.get(key);
    if (!dep) {
      depsMap.set(key, dep = createDep());
    }
    trackEffects(dep);
  }
}
function trackEffects(dep, debuggerEventExtraInfo) {
  let shouldTrack2 = false;
  if (effectTrackDepth <= maxMarkerBits) {
    if (!newTracked(dep)) {
      dep.n |= trackOpBit;
      shouldTrack2 = !wasTracked(dep);
    }
  } else {
    shouldTrack2 = !dep.has(activeEffect);
  }
  if (shouldTrack2) {
    dep.add(activeEffect);
    activeEffect.deps.push(dep);
  }
}
function trigger(target2, type, key, newValue, oldValue, oldTarget) {
  const depsMap = targetMap.get(target2);
  if (!depsMap) {
    return;
  }
  let deps = [];
  if (type === "clear") {
    deps = [...depsMap.values()];
  } else if (key === "length" && isArray$5(target2)) {
    const newLength = Number(newValue);
    depsMap.forEach((dep, key2) => {
      if (key2 === "length" || key2 >= newLength) {
        deps.push(dep);
      }
    });
  } else {
    if (key !== void 0) {
      deps.push(depsMap.get(key));
    }
    switch (type) {
      case "add":
        if (!isArray$5(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
          if (isMap(target2)) {
            deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
          }
        } else if (isIntegerKey(key)) {
          deps.push(depsMap.get("length"));
        }
        break;
      case "delete":
        if (!isArray$5(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
          if (isMap(target2)) {
            deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
          }
        }
        break;
      case "set":
        if (isMap(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
        }
        break;
    }
  }
  if (deps.length === 1) {
    if (deps[0]) {
      {
        triggerEffects(deps[0]);
      }
    }
  } else {
    const effects = [];
    for (const dep of deps) {
      if (dep) {
        effects.push(...dep);
      }
    }
    {
      triggerEffects(createDep(effects));
    }
  }
}
function triggerEffects(dep, debuggerEventExtraInfo) {
  const effects = isArray$5(dep) ? dep : [...dep];
  for (const effect2 of effects) {
    if (effect2.computed) {
      triggerEffect(effect2);
    }
  }
  for (const effect2 of effects) {
    if (!effect2.computed) {
      triggerEffect(effect2);
    }
  }
}
function triggerEffect(effect2, debuggerEventExtraInfo) {
  if (effect2 !== activeEffect || effect2.allowRecurse) {
    if (effect2.scheduler) {
      effect2.scheduler();
    } else {
      effect2.run();
    }
  }
}
function getDepFromReactive(object, key) {
  var _a2;
  return (_a2 = targetMap.get(object)) == null ? void 0 : _a2.get(key);
}
const isNonTrackableKeys = /* @__PURE__ */ makeMap(`__proto__,__v_isRef,__isVue`);
const builtInSymbols = new Set(/* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((key) => key !== "arguments" && key !== "caller").map((key) => Symbol[key]).filter(isSymbol));
const get$1 = /* @__PURE__ */ createGetter();
const shallowGet = /* @__PURE__ */ createGetter(false, true);
const readonlyGet = /* @__PURE__ */ createGetter(true);
const arrayInstrumentations = /* @__PURE__ */ createArrayInstrumentations();
function createArrayInstrumentations() {
  const instrumentations = {};
  ["includes", "indexOf", "lastIndexOf"].forEach((key) => {
    instrumentations[key] = function(...args) {
      const arr = toRaw(this);
      for (let i2 = 0, l = this.length; i2 < l; i2++) {
        track(arr, "get", i2 + "");
      }
      const res = arr[key](...args);
      if (res === -1 || res === false) {
        return arr[key](...args.map(toRaw));
      } else {
        return res;
      }
    };
  });
  ["push", "pop", "shift", "unshift", "splice"].forEach((key) => {
    instrumentations[key] = function(...args) {
      pauseTracking();
      const res = toRaw(this)[key].apply(this, args);
      resetTracking();
      return res;
    };
  });
  return instrumentations;
}
function hasOwnProperty$1(key) {
  const obj = toRaw(this);
  track(obj, "has", key);
  return obj.hasOwnProperty(key);
}
function createGetter(isReadonly2 = false, shallow = false) {
  return function get2(target2, key, receiver) {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_isShallow") {
      return shallow;
    } else if (key === "__v_raw" && receiver === (isReadonly2 ? shallow ? shallowReadonlyMap : readonlyMap : shallow ? shallowReactiveMap : reactiveMap).get(target2)) {
      return target2;
    }
    const targetIsArray = isArray$5(target2);
    if (!isReadonly2) {
      if (targetIsArray && hasOwn$2(arrayInstrumentations, key)) {
        return Reflect.get(arrayInstrumentations, key, receiver);
      }
      if (key === "hasOwnProperty") {
        return hasOwnProperty$1;
      }
    }
    const res = Reflect.get(target2, key, receiver);
    if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
      return res;
    }
    if (!isReadonly2) {
      track(target2, "get", key);
    }
    if (shallow) {
      return res;
    }
    if (isRef(res)) {
      return targetIsArray && isIntegerKey(key) ? res : res.value;
    }
    if (isObject$6(res)) {
      return isReadonly2 ? readonly(res) : reactive(res);
    }
    return res;
  };
}
const set$1 = /* @__PURE__ */ createSetter();
const shallowSet = /* @__PURE__ */ createSetter(true);
function createSetter(shallow = false) {
  return function set2(target2, key, value, receiver) {
    let oldValue = target2[key];
    if (isReadonly(oldValue) && isRef(oldValue) && !isRef(value)) {
      return false;
    }
    if (!shallow) {
      if (!isShallow(value) && !isReadonly(value)) {
        oldValue = toRaw(oldValue);
        value = toRaw(value);
      }
      if (!isArray$5(target2) && isRef(oldValue) && !isRef(value)) {
        oldValue.value = value;
        return true;
      }
    }
    const hadKey = isArray$5(target2) && isIntegerKey(key) ? Number(key) < target2.length : hasOwn$2(target2, key);
    const result = Reflect.set(target2, key, value, receiver);
    if (target2 === toRaw(receiver)) {
      if (!hadKey) {
        trigger(target2, "add", key, value);
      } else if (hasChanged(value, oldValue)) {
        trigger(target2, "set", key, value);
      }
    }
    return result;
  };
}
function deleteProperty(target2, key) {
  const hadKey = hasOwn$2(target2, key);
  target2[key];
  const result = Reflect.deleteProperty(target2, key);
  if (result && hadKey) {
    trigger(target2, "delete", key, void 0);
  }
  return result;
}
function has$1(target2, key) {
  const result = Reflect.has(target2, key);
  if (!isSymbol(key) || !builtInSymbols.has(key)) {
    track(target2, "has", key);
  }
  return result;
}
function ownKeys(target2) {
  track(target2, "iterate", isArray$5(target2) ? "length" : ITERATE_KEY);
  return Reflect.ownKeys(target2);
}
const mutableHandlers = {
  get: get$1,
  set: set$1,
  deleteProperty,
  has: has$1,
  ownKeys
};
const readonlyHandlers = {
  get: readonlyGet,
  set(target2, key) {
    return true;
  },
  deleteProperty(target2, key) {
    return true;
  }
};
const shallowReactiveHandlers = /* @__PURE__ */ extend$1({}, mutableHandlers, {
  get: shallowGet,
  set: shallowSet
});
const toShallow = (value) => value;
const getProto = (v) => Reflect.getPrototypeOf(v);
function get$2(target2, key, isReadonly2 = false, isShallow2 = false) {
  target2 = target2["__v_raw"];
  const rawTarget = toRaw(target2);
  const rawKey = toRaw(key);
  if (!isReadonly2) {
    if (key !== rawKey) {
      track(rawTarget, "get", key);
    }
    track(rawTarget, "get", rawKey);
  }
  const {
    has: has2
  } = getProto(rawTarget);
  const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
  if (has2.call(rawTarget, key)) {
    return wrap(target2.get(key));
  } else if (has2.call(rawTarget, rawKey)) {
    return wrap(target2.get(rawKey));
  } else if (target2 !== rawTarget) {
    target2.get(key);
  }
}
function has(key, isReadonly2 = false) {
  const target2 = this["__v_raw"];
  const rawTarget = toRaw(target2);
  const rawKey = toRaw(key);
  if (!isReadonly2) {
    if (key !== rawKey) {
      track(rawTarget, "has", key);
    }
    track(rawTarget, "has", rawKey);
  }
  return key === rawKey ? target2.has(key) : target2.has(key) || target2.has(rawKey);
}
function size(target2, isReadonly2 = false) {
  target2 = target2["__v_raw"];
  !isReadonly2 && track(toRaw(target2), "iterate", ITERATE_KEY);
  return Reflect.get(target2, "size", target2);
}
function add$1(value) {
  value = toRaw(value);
  const target2 = toRaw(this);
  const proto2 = getProto(target2);
  const hadKey = proto2.has.call(target2, value);
  if (!hadKey) {
    target2.add(value);
    trigger(target2, "add", value, value);
  }
  return this;
}
function set$2(key, value) {
  value = toRaw(value);
  const target2 = toRaw(this);
  const {
    has: has2,
    get: get2
  } = getProto(target2);
  let hadKey = has2.call(target2, key);
  if (!hadKey) {
    key = toRaw(key);
    hadKey = has2.call(target2, key);
  }
  const oldValue = get2.call(target2, key);
  target2.set(key, value);
  if (!hadKey) {
    trigger(target2, "add", key, value);
  } else if (hasChanged(value, oldValue)) {
    trigger(target2, "set", key, value);
  }
  return this;
}
function deleteEntry(key) {
  const target2 = toRaw(this);
  const {
    has: has2,
    get: get2
  } = getProto(target2);
  let hadKey = has2.call(target2, key);
  if (!hadKey) {
    key = toRaw(key);
    hadKey = has2.call(target2, key);
  }
  get2 ? get2.call(target2, key) : void 0;
  const result = target2.delete(key);
  if (hadKey) {
    trigger(target2, "delete", key, void 0);
  }
  return result;
}
function clear$1() {
  const target2 = toRaw(this);
  const hadItems = target2.size !== 0;
  const result = target2.clear();
  if (hadItems) {
    trigger(target2, "clear", void 0, void 0);
  }
  return result;
}
function createForEach(isReadonly2, isShallow2) {
  return function forEach(callback, thisArg) {
    const observed = this;
    const target2 = observed["__v_raw"];
    const rawTarget = toRaw(target2);
    const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(rawTarget, "iterate", ITERATE_KEY);
    return target2.forEach((value, key) => {
      return callback.call(thisArg, wrap(value), wrap(key), observed);
    });
  };
}
function createIterableMethod(method, isReadonly2, isShallow2) {
  return function(...args) {
    const target2 = this["__v_raw"];
    const rawTarget = toRaw(target2);
    const targetIsMap = isMap(rawTarget);
    const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
    const isKeyOnly = method === "keys" && targetIsMap;
    const innerIterator = target2[method](...args);
    const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(rawTarget, "iterate", isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY);
    return {
      // iterator protocol
      next() {
        const {
          value,
          done
        } = innerIterator.next();
        return done ? {
          value,
          done
        } : {
          value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
          done
        };
      },
      // iterable protocol
      [Symbol.iterator]() {
        return this;
      }
    };
  };
}
function createReadonlyMethod(type) {
  return function(...args) {
    return type === "delete" ? false : this;
  };
}
function createInstrumentations() {
  const mutableInstrumentations2 = {
    get(key) {
      return get$2(this, key);
    },
    get size() {
      return size(this);
    },
    has,
    add: add$1,
    set: set$2,
    delete: deleteEntry,
    clear: clear$1,
    forEach: createForEach(false, false)
  };
  const shallowInstrumentations2 = {
    get(key) {
      return get$2(this, key, false, true);
    },
    get size() {
      return size(this);
    },
    has,
    add: add$1,
    set: set$2,
    delete: deleteEntry,
    clear: clear$1,
    forEach: createForEach(false, true)
  };
  const readonlyInstrumentations2 = {
    get(key) {
      return get$2(this, key, true);
    },
    get size() {
      return size(this, true);
    },
    has(key) {
      return has.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, false)
  };
  const shallowReadonlyInstrumentations2 = {
    get(key) {
      return get$2(this, key, true, true);
    },
    get size() {
      return size(this, true);
    },
    has(key) {
      return has.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, true)
  };
  const iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
  iteratorMethods.forEach((method) => {
    mutableInstrumentations2[method] = createIterableMethod(method, false, false);
    readonlyInstrumentations2[method] = createIterableMethod(method, true, false);
    shallowInstrumentations2[method] = createIterableMethod(method, false, true);
    shallowReadonlyInstrumentations2[method] = createIterableMethod(method, true, true);
  });
  return [mutableInstrumentations2, readonlyInstrumentations2, shallowInstrumentations2, shallowReadonlyInstrumentations2];
}
const [mutableInstrumentations, readonlyInstrumentations, shallowInstrumentations, shallowReadonlyInstrumentations] = /* @__PURE__ */ createInstrumentations();
function createInstrumentationGetter(isReadonly2, shallow) {
  const instrumentations = shallow ? isReadonly2 ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly2 ? readonlyInstrumentations : mutableInstrumentations;
  return (target2, key, receiver) => {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_raw") {
      return target2;
    }
    return Reflect.get(hasOwn$2(instrumentations, key) && key in target2 ? instrumentations : target2, key, receiver);
  };
}
const mutableCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, false)
};
const shallowCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, true)
};
const readonlyCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(true, false)
};
const reactiveMap = /* @__PURE__ */ new WeakMap();
const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
const readonlyMap = /* @__PURE__ */ new WeakMap();
const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
function targetTypeMap(rawType) {
  switch (rawType) {
    case "Object":
    case "Array":
      return 1;
    case "Map":
    case "Set":
    case "WeakMap":
    case "WeakSet":
      return 2;
    default:
      return 0;
  }
}
function getTargetType(value) {
  return value["__v_skip"] || !Object.isExtensible(value) ? 0 : targetTypeMap(toRawType(value));
}
function reactive(target2) {
  if (isReadonly(target2)) {
    return target2;
  }
  return createReactiveObject(target2, false, mutableHandlers, mutableCollectionHandlers, reactiveMap);
}
function shallowReactive(target2) {
  return createReactiveObject(target2, false, shallowReactiveHandlers, shallowCollectionHandlers, shallowReactiveMap);
}
function readonly(target2) {
  return createReactiveObject(target2, true, readonlyHandlers, readonlyCollectionHandlers, readonlyMap);
}
function createReactiveObject(target2, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
  if (!isObject$6(target2)) {
    return target2;
  }
  if (target2["__v_raw"] && !(isReadonly2 && target2["__v_isReactive"])) {
    return target2;
  }
  const existingProxy = proxyMap.get(target2);
  if (existingProxy) {
    return existingProxy;
  }
  const targetType = getTargetType(target2);
  if (targetType === 0) {
    return target2;
  }
  const proxy = new Proxy(target2, targetType === 2 ? collectionHandlers : baseHandlers);
  proxyMap.set(target2, proxy);
  return proxy;
}
function isReactive(value) {
  if (isReadonly(value)) {
    return isReactive(value["__v_raw"]);
  }
  return !!(value && value["__v_isReactive"]);
}
function isReadonly(value) {
  return !!(value && value["__v_isReadonly"]);
}
function isShallow(value) {
  return !!(value && value["__v_isShallow"]);
}
function isProxy(value) {
  return isReactive(value) || isReadonly(value);
}
function toRaw(observed) {
  const raw = observed && observed["__v_raw"];
  return raw ? toRaw(raw) : observed;
}
function markRaw(value) {
  def(value, "__v_skip", true);
  return value;
}
const toReactive = (value) => isObject$6(value) ? reactive(value) : value;
const toReadonly = (value) => isObject$6(value) ? readonly(value) : value;
function trackRefValue(ref2) {
  if (shouldTrack && activeEffect) {
    ref2 = toRaw(ref2);
    {
      trackEffects(ref2.dep || (ref2.dep = createDep()));
    }
  }
}
function triggerRefValue(ref2, newVal) {
  ref2 = toRaw(ref2);
  const dep = ref2.dep;
  if (dep) {
    {
      triggerEffects(dep);
    }
  }
}
function isRef(r2) {
  return !!(r2 && r2.__v_isRef === true);
}
function ref(value) {
  return createRef(value, false);
}
function shallowRef(value) {
  return createRef(value, true);
}
function createRef(rawValue, shallow) {
  if (isRef(rawValue)) {
    return rawValue;
  }
  return new RefImpl(rawValue, shallow);
}
class RefImpl {
  constructor(value, __v_isShallow) {
    this.__v_isShallow = __v_isShallow;
    this.dep = void 0;
    this.__v_isRef = true;
    this._rawValue = __v_isShallow ? value : toRaw(value);
    this._value = __v_isShallow ? value : toReactive(value);
  }
  get value() {
    trackRefValue(this);
    return this._value;
  }
  set value(newVal) {
    const useDirectValue = this.__v_isShallow || isShallow(newVal) || isReadonly(newVal);
    newVal = useDirectValue ? newVal : toRaw(newVal);
    if (hasChanged(newVal, this._rawValue)) {
      this._rawValue = newVal;
      this._value = useDirectValue ? newVal : toReactive(newVal);
      triggerRefValue(this);
    }
  }
}
function unref(ref2) {
  return isRef(ref2) ? ref2.value : ref2;
}
const shallowUnwrapHandlers = {
  get: (target2, key, receiver) => unref(Reflect.get(target2, key, receiver)),
  set: (target2, key, value, receiver) => {
    const oldValue = target2[key];
    if (isRef(oldValue) && !isRef(value)) {
      oldValue.value = value;
      return true;
    } else {
      return Reflect.set(target2, key, value, receiver);
    }
  }
};
function proxyRefs(objectWithRefs) {
  return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
}
function toRefs(object) {
  const ret = isArray$5(object) ? new Array(object.length) : {};
  for (const key in object) {
    ret[key] = propertyToRef(object, key);
  }
  return ret;
}
class ObjectRefImpl {
  constructor(_object, _key, _defaultValue) {
    this._object = _object;
    this._key = _key;
    this._defaultValue = _defaultValue;
    this.__v_isRef = true;
  }
  get value() {
    const val = this._object[this._key];
    return val === void 0 ? this._defaultValue : val;
  }
  set value(newVal) {
    this._object[this._key] = newVal;
  }
  get dep() {
    return getDepFromReactive(toRaw(this._object), this._key);
  }
}
class GetterRefImpl {
  constructor(_getter) {
    this._getter = _getter;
    this.__v_isRef = true;
    this.__v_isReadonly = true;
  }
  get value() {
    return this._getter();
  }
}
function toRef(source, key, defaultValue) {
  if (isRef(source)) {
    return source;
  } else if (isFunction$4(source)) {
    return new GetterRefImpl(source);
  } else if (isObject$6(source) && arguments.length > 1) {
    return propertyToRef(source, key, defaultValue);
  } else {
    return ref(source);
  }
}
function propertyToRef(source, key, defaultValue) {
  const val = source[key];
  return isRef(val) ? val : new ObjectRefImpl(source, key, defaultValue);
}
class ComputedRefImpl {
  constructor(getter, _setter, isReadonly2, isSSR) {
    this._setter = _setter;
    this.dep = void 0;
    this.__v_isRef = true;
    this["__v_isReadonly"] = false;
    this._dirty = true;
    this.effect = new ReactiveEffect(getter, () => {
      if (!this._dirty) {
        this._dirty = true;
        triggerRefValue(this);
      }
    });
    this.effect.computed = this;
    this.effect.active = this._cacheable = !isSSR;
    this["__v_isReadonly"] = isReadonly2;
  }
  get value() {
    const self2 = toRaw(this);
    trackRefValue(self2);
    if (self2._dirty || !self2._cacheable) {
      self2._dirty = false;
      self2._value = self2.effect.run();
    }
    return self2._value;
  }
  set value(newValue) {
    this._setter(newValue);
  }
}
function computed$1(getterOrOptions, debugOptions, isSSR = false) {
  let getter;
  let setter;
  const onlyGetter = isFunction$4(getterOrOptions);
  if (onlyGetter) {
    getter = getterOrOptions;
    setter = NOOP$1;
  } else {
    getter = getterOrOptions.get;
    setter = getterOrOptions.set;
  }
  const cRef = new ComputedRefImpl(getter, setter, onlyGetter || !setter, isSSR);
  return cRef;
}
function warn$1(msg, ...args) {
  return;
}
function callWithErrorHandling(fn, instance, type, args) {
  let res;
  try {
    res = args ? fn(...args) : fn();
  } catch (err) {
    handleError(err, instance, type);
  }
  return res;
}
function callWithAsyncErrorHandling(fn, instance, type, args) {
  if (isFunction$4(fn)) {
    const res = callWithErrorHandling(fn, instance, type, args);
    if (res && isPromise$1(res)) {
      res.catch((err) => {
        handleError(err, instance, type);
      });
    }
    return res;
  }
  const values = [];
  for (let i2 = 0; i2 < fn.length; i2++) {
    values.push(callWithAsyncErrorHandling(fn[i2], instance, type, args));
  }
  return values;
}
function handleError(err, instance, type, throwInDev = true) {
  const contextVNode = instance ? instance.vnode : null;
  if (instance) {
    let cur = instance.parent;
    const exposedInstance = instance.proxy;
    const errorInfo = type;
    while (cur) {
      const errorCapturedHooks = cur.ec;
      if (errorCapturedHooks) {
        for (let i2 = 0; i2 < errorCapturedHooks.length; i2++) {
          if (errorCapturedHooks[i2](err, exposedInstance, errorInfo) === false) {
            return;
          }
        }
      }
      cur = cur.parent;
    }
    const appErrorHandler = instance.appContext.config.errorHandler;
    if (appErrorHandler) {
      callWithErrorHandling(appErrorHandler, null, 10, [err, exposedInstance, errorInfo]);
      return;
    }
  }
  logError$1(err, type, contextVNode, throwInDev);
}
function logError$1(err, type, contextVNode, throwInDev = true) {
  {
    console.error(err);
  }
}
let isFlushing = false;
let isFlushPending = false;
const queue = [];
let flushIndex = 0;
const pendingPostFlushCbs = [];
let activePostFlushCbs = null;
let postFlushIndex = 0;
const resolvedPromise = /* @__PURE__ */ Promise.resolve();
let currentFlushPromise = null;
function nextTick(fn) {
  const p2 = currentFlushPromise || resolvedPromise;
  return fn ? p2.then(this ? fn.bind(this) : fn) : p2;
}
function findInsertionIndex(id) {
  let start2 = flushIndex + 1;
  let end2 = queue.length;
  while (start2 < end2) {
    const middle = start2 + end2 >>> 1;
    const middleJobId = getId$1(queue[middle]);
    middleJobId < id ? start2 = middle + 1 : end2 = middle;
  }
  return start2;
}
function queueJob(job) {
  if (!queue.length || !queue.includes(job, isFlushing && job.allowRecurse ? flushIndex + 1 : flushIndex)) {
    if (job.id == null) {
      queue.push(job);
    } else {
      queue.splice(findInsertionIndex(job.id), 0, job);
    }
    queueFlush();
  }
}
function queueFlush() {
  if (!isFlushing && !isFlushPending) {
    isFlushPending = true;
    currentFlushPromise = resolvedPromise.then(flushJobs);
  }
}
function invalidateJob(job) {
  const i2 = queue.indexOf(job);
  if (i2 > flushIndex) {
    queue.splice(i2, 1);
  }
}
function queuePostFlushCb(cb) {
  if (!isArray$5(cb)) {
    if (!activePostFlushCbs || !activePostFlushCbs.includes(cb, cb.allowRecurse ? postFlushIndex + 1 : postFlushIndex)) {
      pendingPostFlushCbs.push(cb);
    }
  } else {
    pendingPostFlushCbs.push(...cb);
  }
  queueFlush();
}
function flushPreFlushCbs(seen, i2 = isFlushing ? flushIndex + 1 : 0) {
  for (; i2 < queue.length; i2++) {
    const cb = queue[i2];
    if (cb && cb.pre) {
      queue.splice(i2, 1);
      i2--;
      cb();
    }
  }
}
function flushPostFlushCbs(seen) {
  if (pendingPostFlushCbs.length) {
    const deduped = [...new Set(pendingPostFlushCbs)];
    pendingPostFlushCbs.length = 0;
    if (activePostFlushCbs) {
      activePostFlushCbs.push(...deduped);
      return;
    }
    activePostFlushCbs = deduped;
    activePostFlushCbs.sort((a, b2) => getId$1(a) - getId$1(b2));
    for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {
      activePostFlushCbs[postFlushIndex]();
    }
    activePostFlushCbs = null;
    postFlushIndex = 0;
  }
}
const getId$1 = (job) => job.id == null ? Infinity : job.id;
const comparator = (a, b2) => {
  const diff = getId$1(a) - getId$1(b2);
  if (diff === 0) {
    if (a.pre && !b2.pre)
      return -1;
    if (b2.pre && !a.pre)
      return 1;
  }
  return diff;
};
function flushJobs(seen) {
  isFlushPending = false;
  isFlushing = true;
  queue.sort(comparator);
  const check = NOOP$1;
  try {
    for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {
      const job = queue[flushIndex];
      if (job && job.active !== false) {
        if (false)
          ;
        callWithErrorHandling(job, null, 14);
      }
    }
  } finally {
    flushIndex = 0;
    queue.length = 0;
    flushPostFlushCbs();
    isFlushing = false;
    currentFlushPromise = null;
    if (queue.length || pendingPostFlushCbs.length) {
      flushJobs();
    }
  }
}
function emit(instance, event, ...rawArgs) {
  if (instance.isUnmounted)
    return;
  const props = instance.vnode.props || EMPTY_OBJ$1;
  let args = rawArgs;
  const isModelListener2 = event.startsWith("update:");
  const modelArg = isModelListener2 && event.slice(7);
  if (modelArg && modelArg in props) {
    const modifiersKey = `${modelArg === "modelValue" ? "model" : modelArg}Modifiers`;
    const {
      number: number2,
      trim: trim2
    } = props[modifiersKey] || EMPTY_OBJ$1;
    if (trim2) {
      args = rawArgs.map((a) => isString$4(a) ? a.trim() : a);
    }
    if (number2) {
      args = rawArgs.map(looseToNumber);
    }
  }
  let handlerName;
  let handler = props[handlerName = toHandlerKey(event)] || // also try camelCase event handler (#2249)
  props[handlerName = toHandlerKey(camelize(event))];
  if (!handler && isModelListener2) {
    handler = props[handlerName = toHandlerKey(hyphenate(event))];
  }
  if (handler) {
    callWithAsyncErrorHandling(handler, instance, 6, args);
  }
  const onceHandler = props[handlerName + `Once`];
  if (onceHandler) {
    if (!instance.emitted) {
      instance.emitted = {};
    } else if (instance.emitted[handlerName]) {
      return;
    }
    instance.emitted[handlerName] = true;
    callWithAsyncErrorHandling(onceHandler, instance, 6, args);
  }
}
function normalizeEmitsOptions(comp, appContext, asMixin = false) {
  const cache2 = appContext.emitsCache;
  const cached = cache2.get(comp);
  if (cached !== void 0) {
    return cached;
  }
  const raw = comp.emits;
  let normalized = {};
  let hasExtends = false;
  if (!isFunction$4(comp)) {
    const extendEmits = (raw2) => {
      const normalizedFromExtend = normalizeEmitsOptions(raw2, appContext, true);
      if (normalizedFromExtend) {
        hasExtends = true;
        extend$1(normalized, normalizedFromExtend);
      }
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendEmits);
    }
    if (comp.extends) {
      extendEmits(comp.extends);
    }
    if (comp.mixins) {
      comp.mixins.forEach(extendEmits);
    }
  }
  if (!raw && !hasExtends) {
    if (isObject$6(comp)) {
      cache2.set(comp, null);
    }
    return null;
  }
  if (isArray$5(raw)) {
    raw.forEach((key) => normalized[key] = null);
  } else {
    extend$1(normalized, raw);
  }
  if (isObject$6(comp)) {
    cache2.set(comp, normalized);
  }
  return normalized;
}
function isEmitListener(options, key) {
  if (!options || !isOn(key)) {
    return false;
  }
  key = key.slice(2).replace(/Once$/, "");
  return hasOwn$2(options, key[0].toLowerCase() + key.slice(1)) || hasOwn$2(options, hyphenate(key)) || hasOwn$2(options, key);
}
let currentRenderingInstance = null;
let currentScopeId = null;
function setCurrentRenderingInstance(instance) {
  const prev = currentRenderingInstance;
  currentRenderingInstance = instance;
  currentScopeId = instance && instance.type.__scopeId || null;
  return prev;
}
function withCtx(fn, ctx = currentRenderingInstance, isNonScopedSlot) {
  if (!ctx)
    return fn;
  if (fn._n) {
    return fn;
  }
  const renderFnWithContext = (...args) => {
    if (renderFnWithContext._d) {
      setBlockTracking(-1);
    }
    const prevInstance = setCurrentRenderingInstance(ctx);
    let res;
    try {
      res = fn(...args);
    } finally {
      setCurrentRenderingInstance(prevInstance);
      if (renderFnWithContext._d) {
        setBlockTracking(1);
      }
    }
    return res;
  };
  renderFnWithContext._n = true;
  renderFnWithContext._c = true;
  renderFnWithContext._d = true;
  return renderFnWithContext;
}
function markAttrsAccessed() {
}
function renderComponentRoot(instance) {
  const {
    type: Component,
    vnode,
    proxy,
    withProxy,
    props,
    propsOptions: [propsOptions],
    slots,
    attrs,
    emit: emit2,
    render: render2,
    renderCache,
    data,
    setupState,
    ctx,
    inheritAttrs
  } = instance;
  let result;
  let fallthroughAttrs;
  const prev = setCurrentRenderingInstance(instance);
  try {
    if (vnode.shapeFlag & 4) {
      const proxyToUse = withProxy || proxy;
      result = normalizeVNode(render2.call(proxyToUse, proxyToUse, renderCache, props, setupState, data, ctx));
      fallthroughAttrs = attrs;
    } else {
      const render22 = Component;
      if (false)
        ;
      result = normalizeVNode(render22.length > 1 ? render22(props, false ? {
        get attrs() {
          markAttrsAccessed();
          return attrs;
        },
        slots,
        emit: emit2
      } : {
        attrs,
        slots,
        emit: emit2
      }) : render22(
        props,
        null
        /* we know it doesn't need it */
      ));
      fallthroughAttrs = Component.props ? attrs : getFunctionalFallthrough(attrs);
    }
  } catch (err) {
    blockStack.length = 0;
    handleError(err, instance, 1);
    result = createVNode(Comment);
  }
  let root = result;
  if (fallthroughAttrs && inheritAttrs !== false) {
    const keys2 = Object.keys(fallthroughAttrs);
    const {
      shapeFlag
    } = root;
    if (keys2.length) {
      if (shapeFlag & (1 | 6)) {
        if (propsOptions && keys2.some(isModelListener)) {
          fallthroughAttrs = filterModelListeners(fallthroughAttrs, propsOptions);
        }
        root = cloneVNode(root, fallthroughAttrs);
      }
    }
  }
  if (vnode.dirs) {
    root = cloneVNode(root);
    root.dirs = root.dirs ? root.dirs.concat(vnode.dirs) : vnode.dirs;
  }
  if (vnode.transition) {
    root.transition = vnode.transition;
  }
  {
    result = root;
  }
  setCurrentRenderingInstance(prev);
  return result;
}
const getFunctionalFallthrough = (attrs) => {
  let res;
  for (const key in attrs) {
    if (key === "class" || key === "style" || isOn(key)) {
      (res || (res = {}))[key] = attrs[key];
    }
  }
  return res;
};
const filterModelListeners = (attrs, props) => {
  const res = {};
  for (const key in attrs) {
    if (!isModelListener(key) || !(key.slice(9) in props)) {
      res[key] = attrs[key];
    }
  }
  return res;
};
function shouldUpdateComponent(prevVNode, nextVNode, optimized) {
  const {
    props: prevProps,
    children: prevChildren,
    component
  } = prevVNode;
  const {
    props: nextProps,
    children: nextChildren,
    patchFlag
  } = nextVNode;
  const emits = component.emitsOptions;
  if (nextVNode.dirs || nextVNode.transition) {
    return true;
  }
  if (optimized && patchFlag >= 0) {
    if (patchFlag & 1024) {
      return true;
    }
    if (patchFlag & 16) {
      if (!prevProps) {
        return !!nextProps;
      }
      return hasPropsChanged(prevProps, nextProps, emits);
    } else if (patchFlag & 8) {
      const dynamicProps = nextVNode.dynamicProps;
      for (let i2 = 0; i2 < dynamicProps.length; i2++) {
        const key = dynamicProps[i2];
        if (nextProps[key] !== prevProps[key] && !isEmitListener(emits, key)) {
          return true;
        }
      }
    }
  } else {
    if (prevChildren || nextChildren) {
      if (!nextChildren || !nextChildren.$stable) {
        return true;
      }
    }
    if (prevProps === nextProps) {
      return false;
    }
    if (!prevProps) {
      return !!nextProps;
    }
    if (!nextProps) {
      return true;
    }
    return hasPropsChanged(prevProps, nextProps, emits);
  }
  return false;
}
function hasPropsChanged(prevProps, nextProps, emitsOptions) {
  const nextKeys = Object.keys(nextProps);
  if (nextKeys.length !== Object.keys(prevProps).length) {
    return true;
  }
  for (let i2 = 0; i2 < nextKeys.length; i2++) {
    const key = nextKeys[i2];
    if (nextProps[key] !== prevProps[key] && !isEmitListener(emitsOptions, key)) {
      return true;
    }
  }
  return false;
}
function updateHOCHostEl({
  vnode,
  parent
}, el) {
  while (parent && parent.subTree === vnode) {
    (vnode = parent.vnode).el = el;
    parent = parent.parent;
  }
}
const isSuspense = (type) => type.__isSuspense;
function queueEffectWithSuspense(fn, suspense) {
  if (suspense && suspense.pendingBranch) {
    if (isArray$5(fn)) {
      suspense.effects.push(...fn);
    } else {
      suspense.effects.push(fn);
    }
  } else {
    queuePostFlushCb(fn);
  }
}
function watchEffect(effect, options) {
  return doWatch(effect, null, options);
}
const INITIAL_WATCHER_VALUE = {};
function watch(source, cb, options) {
  return doWatch(source, cb, options);
}
function doWatch(source, cb, {
  immediate,
  deep,
  flush,
  onTrack,
  onTrigger
} = EMPTY_OBJ$1) {
  var _a2;
  const instance = getCurrentScope() === ((_a2 = currentInstance) == null ? void 0 : _a2.scope) ? currentInstance : null;
  let getter;
  let forceTrigger = false;
  let isMultiSource = false;
  if (isRef(source)) {
    getter = () => source.value;
    forceTrigger = isShallow(source);
  } else if (isReactive(source)) {
    getter = () => source;
    deep = true;
  } else if (isArray$5(source)) {
    isMultiSource = true;
    forceTrigger = source.some((s) => isReactive(s) || isShallow(s));
    getter = () => source.map((s) => {
      if (isRef(s)) {
        return s.value;
      } else if (isReactive(s)) {
        return traverse(s);
      } else if (isFunction$4(s)) {
        return callWithErrorHandling(s, instance, 2);
      } else
        ;
    });
  } else if (isFunction$4(source)) {
    if (cb) {
      getter = () => callWithErrorHandling(source, instance, 2);
    } else {
      getter = () => {
        if (instance && instance.isUnmounted) {
          return;
        }
        if (cleanup) {
          cleanup();
        }
        return callWithAsyncErrorHandling(source, instance, 3, [onCleanup]);
      };
    }
  } else {
    getter = NOOP$1;
  }
  if (cb && deep) {
    const baseGetter = getter;
    getter = () => traverse(baseGetter());
  }
  let cleanup;
  let onCleanup = (fn) => {
    cleanup = effect.onStop = () => {
      callWithErrorHandling(fn, instance, 4);
    };
  };
  let ssrCleanup;
  if (isInSSRComponentSetup) {
    onCleanup = NOOP$1;
    if (!cb) {
      getter();
    } else if (immediate) {
      callWithAsyncErrorHandling(cb, instance, 3, [getter(), isMultiSource ? [] : void 0, onCleanup]);
    }
    if (flush === "sync") {
      const ctx = useSSRContext();
      ssrCleanup = ctx.__watcherHandles || (ctx.__watcherHandles = []);
    } else {
      return NOOP$1;
    }
  }
  let oldValue = isMultiSource ? new Array(source.length).fill(INITIAL_WATCHER_VALUE) : INITIAL_WATCHER_VALUE;
  const job = () => {
    if (!effect.active) {
      return;
    }
    if (cb) {
      const newValue = effect.run();
      if (deep || forceTrigger || (isMultiSource ? newValue.some((v, i2) => hasChanged(v, oldValue[i2])) : hasChanged(newValue, oldValue)) || false) {
        if (cleanup) {
          cleanup();
        }
        callWithAsyncErrorHandling(cb, instance, 3, [
          newValue,
          // pass undefined as the old value when it's changed for the first time
          oldValue === INITIAL_WATCHER_VALUE ? void 0 : isMultiSource && oldValue[0] === INITIAL_WATCHER_VALUE ? [] : oldValue,
          onCleanup
        ]);
        oldValue = newValue;
      }
    } else {
      effect.run();
    }
  };
  job.allowRecurse = !!cb;
  let scheduler;
  if (flush === "sync") {
    scheduler = job;
  } else if (flush === "post") {
    scheduler = () => queuePostRenderEffect(job, instance && instance.suspense);
  } else {
    job.pre = true;
    if (instance)
      job.id = instance.uid;
    scheduler = () => queueJob(job);
  }
  const effect = new ReactiveEffect(getter, scheduler);
  if (cb) {
    if (immediate) {
      job();
    } else {
      oldValue = effect.run();
    }
  } else if (flush === "post") {
    queuePostRenderEffect(effect.run.bind(effect), instance && instance.suspense);
  } else {
    effect.run();
  }
  const unwatch = () => {
    effect.stop();
    if (instance && instance.scope) {
      remove(instance.scope.effects, effect);
    }
  };
  if (ssrCleanup)
    ssrCleanup.push(unwatch);
  return unwatch;
}
function instanceWatch(source, value, options) {
  const publicThis = this.proxy;
  const getter = isString$4(source) ? source.includes(".") ? createPathGetter(publicThis, source) : () => publicThis[source] : source.bind(publicThis, publicThis);
  let cb;
  if (isFunction$4(value)) {
    cb = value;
  } else {
    cb = value.handler;
    options = value;
  }
  const cur = currentInstance;
  setCurrentInstance(this);
  const res = doWatch(getter, cb.bind(publicThis), options);
  if (cur) {
    setCurrentInstance(cur);
  } else {
    unsetCurrentInstance();
  }
  return res;
}
function createPathGetter(ctx, path) {
  const segments = path.split(".");
  return () => {
    let cur = ctx;
    for (let i2 = 0; i2 < segments.length && cur; i2++) {
      cur = cur[segments[i2]];
    }
    return cur;
  };
}
function traverse(value, seen) {
  if (!isObject$6(value) || value["__v_skip"]) {
    return value;
  }
  seen = seen || /* @__PURE__ */ new Set();
  if (seen.has(value)) {
    return value;
  }
  seen.add(value);
  if (isRef(value)) {
    traverse(value.value, seen);
  } else if (isArray$5(value)) {
    for (let i2 = 0; i2 < value.length; i2++) {
      traverse(value[i2], seen);
    }
  } else if (isSet(value) || isMap(value)) {
    value.forEach((v) => {
      traverse(v, seen);
    });
  } else if (isPlainObject$1(value)) {
    for (const key in value) {
      traverse(value[key], seen);
    }
  }
  return value;
}
function withDirectives(vnode, directives) {
  const internalInstance = currentRenderingInstance;
  if (internalInstance === null) {
    return vnode;
  }
  const instance = getExposeProxy(internalInstance) || internalInstance.proxy;
  const bindings = vnode.dirs || (vnode.dirs = []);
  for (let i2 = 0; i2 < directives.length; i2++) {
    let [dir, value, arg, modifiers = EMPTY_OBJ$1] = directives[i2];
    if (dir) {
      if (isFunction$4(dir)) {
        dir = {
          mounted: dir,
          updated: dir
        };
      }
      if (dir.deep) {
        traverse(value);
      }
      bindings.push({
        dir,
        instance,
        value,
        oldValue: void 0,
        arg,
        modifiers
      });
    }
  }
  return vnode;
}
function invokeDirectiveHook(vnode, prevVNode, instance, name) {
  const bindings = vnode.dirs;
  const oldBindings = prevVNode && prevVNode.dirs;
  for (let i2 = 0; i2 < bindings.length; i2++) {
    const binding = bindings[i2];
    if (oldBindings) {
      binding.oldValue = oldBindings[i2].value;
    }
    let hook = binding.dir[name];
    if (hook) {
      pauseTracking();
      callWithAsyncErrorHandling(hook, instance, 8, [vnode.el, binding, vnode, prevVNode]);
      resetTracking();
    }
  }
}
function useTransitionState() {
  const state = {
    isMounted: false,
    isLeaving: false,
    isUnmounting: false,
    leavingVNodes: /* @__PURE__ */ new Map()
  };
  onMounted(() => {
    state.isMounted = true;
  });
  onBeforeUnmount(() => {
    state.isUnmounting = true;
  });
  return state;
}
const TransitionHookValidator = [Function, Array];
const BaseTransitionPropsValidators = {
  mode: String,
  appear: Boolean,
  persisted: Boolean,
  // enter
  onBeforeEnter: TransitionHookValidator,
  onEnter: TransitionHookValidator,
  onAfterEnter: TransitionHookValidator,
  onEnterCancelled: TransitionHookValidator,
  // leave
  onBeforeLeave: TransitionHookValidator,
  onLeave: TransitionHookValidator,
  onAfterLeave: TransitionHookValidator,
  onLeaveCancelled: TransitionHookValidator,
  // appear
  onBeforeAppear: TransitionHookValidator,
  onAppear: TransitionHookValidator,
  onAfterAppear: TransitionHookValidator,
  onAppearCancelled: TransitionHookValidator
};
const BaseTransitionImpl = {
  name: `BaseTransition`,
  props: BaseTransitionPropsValidators,
  setup(props, {
    slots
  }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    let prevTransitionKey;
    return () => {
      const children = slots.default && getTransitionRawChildren(slots.default(), true);
      if (!children || !children.length) {
        return;
      }
      let child = children[0];
      if (children.length > 1) {
        for (const c of children) {
          if (c.type !== Comment) {
            child = c;
            break;
          }
        }
      }
      const rawProps = toRaw(props);
      const {
        mode
      } = rawProps;
      if (state.isLeaving) {
        return emptyPlaceholder(child);
      }
      const innerChild = getKeepAliveChild(child);
      if (!innerChild) {
        return emptyPlaceholder(child);
      }
      const enterHooks = resolveTransitionHooks(innerChild, rawProps, state, instance);
      setTransitionHooks(innerChild, enterHooks);
      const oldChild = instance.subTree;
      const oldInnerChild = oldChild && getKeepAliveChild(oldChild);
      let transitionKeyChanged = false;
      const {
        getTransitionKey
      } = innerChild.type;
      if (getTransitionKey) {
        const key = getTransitionKey();
        if (prevTransitionKey === void 0) {
          prevTransitionKey = key;
        } else if (key !== prevTransitionKey) {
          prevTransitionKey = key;
          transitionKeyChanged = true;
        }
      }
      if (oldInnerChild && oldInnerChild.type !== Comment && (!isSameVNodeType(innerChild, oldInnerChild) || transitionKeyChanged)) {
        const leavingHooks = resolveTransitionHooks(oldInnerChild, rawProps, state, instance);
        setTransitionHooks(oldInnerChild, leavingHooks);
        if (mode === "out-in") {
          state.isLeaving = true;
          leavingHooks.afterLeave = () => {
            state.isLeaving = false;
            if (instance.update.active !== false) {
              instance.update();
            }
          };
          return emptyPlaceholder(child);
        } else if (mode === "in-out" && innerChild.type !== Comment) {
          leavingHooks.delayLeave = (el, earlyRemove, delayedLeave) => {
            const leavingVNodesCache = getLeavingNodesForType(state, oldInnerChild);
            leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;
            el._leaveCb = () => {
              earlyRemove();
              el._leaveCb = void 0;
              delete enterHooks.delayedLeave;
            };
            enterHooks.delayedLeave = delayedLeave;
          };
        }
      }
      return child;
    };
  }
};
const BaseTransition = BaseTransitionImpl;
function getLeavingNodesForType(state, vnode) {
  const {
    leavingVNodes
  } = state;
  let leavingVNodesCache = leavingVNodes.get(vnode.type);
  if (!leavingVNodesCache) {
    leavingVNodesCache = /* @__PURE__ */ Object.create(null);
    leavingVNodes.set(vnode.type, leavingVNodesCache);
  }
  return leavingVNodesCache;
}
function resolveTransitionHooks(vnode, props, state, instance) {
  const {
    appear,
    mode,
    persisted = false,
    onBeforeEnter,
    onEnter,
    onAfterEnter,
    onEnterCancelled,
    onBeforeLeave,
    onLeave: onLeave2,
    onAfterLeave,
    onLeaveCancelled,
    onBeforeAppear,
    onAppear,
    onAfterAppear,
    onAppearCancelled
  } = props;
  const key = String(vnode.key);
  const leavingVNodesCache = getLeavingNodesForType(state, vnode);
  const callHook2 = (hook, args) => {
    hook && callWithAsyncErrorHandling(hook, instance, 9, args);
  };
  const callAsyncHook = (hook, args) => {
    const done = args[1];
    callHook2(hook, args);
    if (isArray$5(hook)) {
      if (hook.every((hook2) => hook2.length <= 1))
        done();
    } else if (hook.length <= 1) {
      done();
    }
  };
  const hooks = {
    mode,
    persisted,
    beforeEnter(el) {
      let hook = onBeforeEnter;
      if (!state.isMounted) {
        if (appear) {
          hook = onBeforeAppear || onBeforeEnter;
        } else {
          return;
        }
      }
      if (el._leaveCb) {
        el._leaveCb(
          true
          /* cancelled */
        );
      }
      const leavingVNode = leavingVNodesCache[key];
      if (leavingVNode && isSameVNodeType(vnode, leavingVNode) && leavingVNode.el._leaveCb) {
        leavingVNode.el._leaveCb();
      }
      callHook2(hook, [el]);
    },
    enter(el) {
      let hook = onEnter;
      let afterHook = onAfterEnter;
      let cancelHook = onEnterCancelled;
      if (!state.isMounted) {
        if (appear) {
          hook = onAppear || onEnter;
          afterHook = onAfterAppear || onAfterEnter;
          cancelHook = onAppearCancelled || onEnterCancelled;
        } else {
          return;
        }
      }
      let called = false;
      const done = el._enterCb = (cancelled) => {
        if (called)
          return;
        called = true;
        if (cancelled) {
          callHook2(cancelHook, [el]);
        } else {
          callHook2(afterHook, [el]);
        }
        if (hooks.delayedLeave) {
          hooks.delayedLeave();
        }
        el._enterCb = void 0;
      };
      if (hook) {
        callAsyncHook(hook, [el, done]);
      } else {
        done();
      }
    },
    leave(el, remove2) {
      const key2 = String(vnode.key);
      if (el._enterCb) {
        el._enterCb(
          true
          /* cancelled */
        );
      }
      if (state.isUnmounting) {
        return remove2();
      }
      callHook2(onBeforeLeave, [el]);
      let called = false;
      const done = el._leaveCb = (cancelled) => {
        if (called)
          return;
        called = true;
        remove2();
        if (cancelled) {
          callHook2(onLeaveCancelled, [el]);
        } else {
          callHook2(onAfterLeave, [el]);
        }
        el._leaveCb = void 0;
        if (leavingVNodesCache[key2] === vnode) {
          delete leavingVNodesCache[key2];
        }
      };
      leavingVNodesCache[key2] = vnode;
      if (onLeave2) {
        callAsyncHook(onLeave2, [el, done]);
      } else {
        done();
      }
    },
    clone(vnode2) {
      return resolveTransitionHooks(vnode2, props, state, instance);
    }
  };
  return hooks;
}
function emptyPlaceholder(vnode) {
  if (isKeepAlive(vnode)) {
    vnode = cloneVNode(vnode);
    vnode.children = null;
    return vnode;
  }
}
function getKeepAliveChild(vnode) {
  return isKeepAlive(vnode) ? vnode.children ? vnode.children[0] : void 0 : vnode;
}
function setTransitionHooks(vnode, hooks) {
  if (vnode.shapeFlag & 6 && vnode.component) {
    setTransitionHooks(vnode.component.subTree, hooks);
  } else if (vnode.shapeFlag & 128) {
    vnode.ssContent.transition = hooks.clone(vnode.ssContent);
    vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);
  } else {
    vnode.transition = hooks;
  }
}
function getTransitionRawChildren(children, keepComment = false, parentKey) {
  let ret = [];
  let keyedFragmentCount = 0;
  for (let i2 = 0; i2 < children.length; i2++) {
    let child = children[i2];
    const key = parentKey == null ? child.key : String(parentKey) + String(child.key != null ? child.key : i2);
    if (child.type === Fragment) {
      if (child.patchFlag & 128)
        keyedFragmentCount++;
      ret = ret.concat(getTransitionRawChildren(child.children, keepComment, key));
    } else if (keepComment || child.type !== Comment) {
      ret.push(key != null ? cloneVNode(child, {
        key
      }) : child);
    }
  }
  if (keyedFragmentCount > 1) {
    for (let i2 = 0; i2 < ret.length; i2++) {
      ret[i2].patchFlag = -2;
    }
  }
  return ret;
}
function defineComponent(options, extraOptions) {
  return isFunction$4(options) ? (
    // #8326: extend call and options.name access are considered side-effects
    // by Rollup, so we have to wrap it in a pure-annotated IIFE.
    /* @__PURE__ */ (() => extend$1({
      name: options.name
    }, extraOptions, {
      setup: options
    }))()
  ) : options;
}
const isAsyncWrapper = (i2) => !!i2.type.__asyncLoader;
const isKeepAlive = (vnode) => vnode.type.__isKeepAlive;
function onActivated(hook, target2) {
  registerKeepAliveHook(hook, "a", target2);
}
function onDeactivated(hook, target2) {
  registerKeepAliveHook(hook, "da", target2);
}
function registerKeepAliveHook(hook, type, target2 = currentInstance) {
  const wrappedHook = hook.__wdc || (hook.__wdc = () => {
    let current = target2;
    while (current) {
      if (current.isDeactivated) {
        return;
      }
      current = current.parent;
    }
    return hook();
  });
  injectHook(type, wrappedHook, target2);
  if (target2) {
    let current = target2.parent;
    while (current && current.parent) {
      if (isKeepAlive(current.parent.vnode)) {
        injectToKeepAliveRoot(wrappedHook, type, target2, current);
      }
      current = current.parent;
    }
  }
}
function injectToKeepAliveRoot(hook, type, target2, keepAliveRoot) {
  const injected = injectHook(
    type,
    hook,
    keepAliveRoot,
    true
    /* prepend */
  );
  onUnmounted(() => {
    remove(keepAliveRoot[type], injected);
  }, target2);
}
function injectHook(type, hook, target2 = currentInstance, prepend = false) {
  if (target2) {
    const hooks = target2[type] || (target2[type] = []);
    const wrappedHook = hook.__weh || (hook.__weh = (...args) => {
      if (target2.isUnmounted) {
        return;
      }
      pauseTracking();
      setCurrentInstance(target2);
      const res = callWithAsyncErrorHandling(hook, target2, type, args);
      unsetCurrentInstance();
      resetTracking();
      return res;
    });
    if (prepend) {
      hooks.unshift(wrappedHook);
    } else {
      hooks.push(wrappedHook);
    }
    return wrappedHook;
  }
}
const createHook = (lifecycle2) => (hook, target2 = currentInstance) => (
  // post-create lifecycle registrations are noops during SSR (except for serverPrefetch)
  (!isInSSRComponentSetup || lifecycle2 === "sp") && injectHook(lifecycle2, (...args) => hook(...args), target2)
);
const onBeforeMount = createHook("bm");
const onMounted = createHook("m");
const onBeforeUpdate = createHook("bu");
const onUpdated = createHook("u");
const onBeforeUnmount = createHook("bum");
const onUnmounted = createHook("um");
const onServerPrefetch = createHook("sp");
const onRenderTriggered = createHook("rtg");
const onRenderTracked = createHook("rtc");
function onErrorCaptured(hook, target2 = currentInstance) {
  injectHook("ec", hook, target2);
}
const COMPONENTS = "components";
function resolveComponent(name, maybeSelfReference) {
  return resolveAsset(COMPONENTS, name, true, maybeSelfReference) || name;
}
const NULL_DYNAMIC_COMPONENT = Symbol.for("v-ndc");
function resolveDynamicComponent(component) {
  if (isString$4(component)) {
    return resolveAsset(COMPONENTS, component, false) || component;
  } else {
    return component || NULL_DYNAMIC_COMPONENT;
  }
}
function resolveAsset(type, name, warnMissing = true, maybeSelfReference = false) {
  const instance = currentRenderingInstance || currentInstance;
  if (instance) {
    const Component = instance.type;
    if (type === COMPONENTS) {
      const selfName = getComponentName(
        Component,
        false
        /* do not include inferred name to avoid breaking existing code */
      );
      if (selfName && (selfName === name || selfName === camelize(name) || selfName === capitalize$1(camelize(name)))) {
        return Component;
      }
    }
    const res = (
      // local registration
      // check instance[type] first which is resolved for options API
      resolve(instance[type] || Component[type], name) || // global registration
      resolve(instance.appContext[type], name)
    );
    if (!res && maybeSelfReference) {
      return Component;
    }
    return res;
  }
}
function resolve(registry, name) {
  return registry && (registry[name] || registry[camelize(name)] || registry[capitalize$1(camelize(name))]);
}
function renderList(source, renderItem, cache2, index2) {
  let ret;
  const cached = cache2 && cache2[index2];
  if (isArray$5(source) || isString$4(source)) {
    ret = new Array(source.length);
    for (let i2 = 0, l = source.length; i2 < l; i2++) {
      ret[i2] = renderItem(source[i2], i2, void 0, cached && cached[i2]);
    }
  } else if (typeof source === "number") {
    ret = new Array(source);
    for (let i2 = 0; i2 < source; i2++) {
      ret[i2] = renderItem(i2 + 1, i2, void 0, cached && cached[i2]);
    }
  } else if (isObject$6(source)) {
    if (source[Symbol.iterator]) {
      ret = Array.from(source, (item, i2) => renderItem(item, i2, void 0, cached && cached[i2]));
    } else {
      const keys2 = Object.keys(source);
      ret = new Array(keys2.length);
      for (let i2 = 0, l = keys2.length; i2 < l; i2++) {
        const key = keys2[i2];
        ret[i2] = renderItem(source[key], key, i2, cached && cached[i2]);
      }
    }
  } else {
    ret = [];
  }
  if (cache2) {
    cache2[index2] = ret;
  }
  return ret;
}
function createSlots(slots, dynamicSlots) {
  for (let i2 = 0; i2 < dynamicSlots.length; i2++) {
    const slot = dynamicSlots[i2];
    if (isArray$5(slot)) {
      for (let j2 = 0; j2 < slot.length; j2++) {
        slots[slot[j2].name] = slot[j2].fn;
      }
    } else if (slot) {
      slots[slot.name] = slot.key ? (...args) => {
        const res = slot.fn(...args);
        if (res)
          res.key = slot.key;
        return res;
      } : slot.fn;
    }
  }
  return slots;
}
function renderSlot(slots, name, props = {}, fallback, noSlotted) {
  if (currentRenderingInstance.isCE || currentRenderingInstance.parent && isAsyncWrapper(currentRenderingInstance.parent) && currentRenderingInstance.parent.isCE) {
    if (name !== "default")
      props.name = name;
    return createVNode("slot", props, fallback && fallback());
  }
  let slot = slots[name];
  if (slot && slot._c) {
    slot._d = false;
  }
  openBlock();
  const validSlotContent = slot && ensureValidVNode(slot(props));
  const rendered = createBlock(Fragment, {
    key: props.key || // slot content array of a dynamic conditional slot may have a branch
    // key attached in the `createSlots` helper, respect that
    validSlotContent && validSlotContent.key || `_${name}`
  }, validSlotContent || (fallback ? fallback() : []), validSlotContent && slots._ === 1 ? 64 : -2);
  if (!noSlotted && rendered.scopeId) {
    rendered.slotScopeIds = [rendered.scopeId + "-s"];
  }
  if (slot && slot._c) {
    slot._d = true;
  }
  return rendered;
}
function ensureValidVNode(vnodes) {
  return vnodes.some((child) => {
    if (!isVNode$1(child))
      return true;
    if (child.type === Comment)
      return false;
    if (child.type === Fragment && !ensureValidVNode(child.children))
      return false;
    return true;
  }) ? vnodes : null;
}
const getPublicInstance = (i2) => {
  if (!i2)
    return null;
  if (isStatefulComponent(i2))
    return getExposeProxy(i2) || i2.proxy;
  return getPublicInstance(i2.parent);
};
const publicPropertiesMap = (
  // Move PURE marker to new line to workaround compiler discarding it
  // due to type annotation
  /* @__PURE__ */ extend$1(/* @__PURE__ */ Object.create(null), {
    $: (i2) => i2,
    $el: (i2) => i2.vnode.el,
    $data: (i2) => i2.data,
    $props: (i2) => i2.props,
    $attrs: (i2) => i2.attrs,
    $slots: (i2) => i2.slots,
    $refs: (i2) => i2.refs,
    $parent: (i2) => getPublicInstance(i2.parent),
    $root: (i2) => getPublicInstance(i2.root),
    $emit: (i2) => i2.emit,
    $options: (i2) => resolveMergedOptions(i2),
    $forceUpdate: (i2) => i2.f || (i2.f = () => queueJob(i2.update)),
    $nextTick: (i2) => i2.n || (i2.n = nextTick.bind(i2.proxy)),
    $watch: (i2) => instanceWatch.bind(i2)
  })
);
const hasSetupBinding = (state, key) => state !== EMPTY_OBJ$1 && !state.__isScriptSetup && hasOwn$2(state, key);
const PublicInstanceProxyHandlers = {
  get({
    _: instance
  }, key) {
    const {
      ctx,
      setupState,
      data,
      props,
      accessCache,
      type,
      appContext
    } = instance;
    let normalizedProps;
    if (key[0] !== "$") {
      const n2 = accessCache[key];
      if (n2 !== void 0) {
        switch (n2) {
          case 1:
            return setupState[key];
          case 2:
            return data[key];
          case 4:
            return ctx[key];
          case 3:
            return props[key];
        }
      } else if (hasSetupBinding(setupState, key)) {
        accessCache[key] = 1;
        return setupState[key];
      } else if (data !== EMPTY_OBJ$1 && hasOwn$2(data, key)) {
        accessCache[key] = 2;
        return data[key];
      } else if (
        // only cache other properties when instance has declared (thus stable)
        // props
        (normalizedProps = instance.propsOptions[0]) && hasOwn$2(normalizedProps, key)
      ) {
        accessCache[key] = 3;
        return props[key];
      } else if (ctx !== EMPTY_OBJ$1 && hasOwn$2(ctx, key)) {
        accessCache[key] = 4;
        return ctx[key];
      } else if (shouldCacheAccess) {
        accessCache[key] = 0;
      }
    }
    const publicGetter = publicPropertiesMap[key];
    let cssModule, globalProperties;
    if (publicGetter) {
      if (key === "$attrs") {
        track(instance, "get", key);
      }
      return publicGetter(instance);
    } else if (
      // css module (injected by vue-loader)
      (cssModule = type.__cssModules) && (cssModule = cssModule[key])
    ) {
      return cssModule;
    } else if (ctx !== EMPTY_OBJ$1 && hasOwn$2(ctx, key)) {
      accessCache[key] = 4;
      return ctx[key];
    } else if (
      // global properties
      globalProperties = appContext.config.globalProperties, hasOwn$2(globalProperties, key)
    ) {
      {
        return globalProperties[key];
      }
    } else
      ;
  },
  set({
    _: instance
  }, key, value) {
    const {
      data,
      setupState,
      ctx
    } = instance;
    if (hasSetupBinding(setupState, key)) {
      setupState[key] = value;
      return true;
    } else if (data !== EMPTY_OBJ$1 && hasOwn$2(data, key)) {
      data[key] = value;
      return true;
    } else if (hasOwn$2(instance.props, key)) {
      return false;
    }
    if (key[0] === "$" && key.slice(1) in instance) {
      return false;
    } else {
      {
        ctx[key] = value;
      }
    }
    return true;
  },
  has({
    _: {
      data,
      setupState,
      accessCache,
      ctx,
      appContext,
      propsOptions
    }
  }, key) {
    let normalizedProps;
    return !!accessCache[key] || data !== EMPTY_OBJ$1 && hasOwn$2(data, key) || hasSetupBinding(setupState, key) || (normalizedProps = propsOptions[0]) && hasOwn$2(normalizedProps, key) || hasOwn$2(ctx, key) || hasOwn$2(publicPropertiesMap, key) || hasOwn$2(appContext.config.globalProperties, key);
  },
  defineProperty(target2, key, descriptor) {
    if (descriptor.get != null) {
      target2._.accessCache[key] = 0;
    } else if (hasOwn$2(descriptor, "value")) {
      this.set(target2, key, descriptor.value, null);
    }
    return Reflect.defineProperty(target2, key, descriptor);
  }
};
function useSlots() {
  return getContext().slots;
}
function getContext() {
  const i2 = getCurrentInstance();
  return i2.setupContext || (i2.setupContext = createSetupContext(i2));
}
function normalizePropsOrEmits(props) {
  return isArray$5(props) ? props.reduce((normalized, p2) => (normalized[p2] = null, normalized), {}) : props;
}
let shouldCacheAccess = true;
function applyOptions(instance) {
  const options = resolveMergedOptions(instance);
  const publicThis = instance.proxy;
  const ctx = instance.ctx;
  shouldCacheAccess = false;
  if (options.beforeCreate) {
    callHook$1(options.beforeCreate, instance, "bc");
  }
  const {
    // state
    data: dataOptions,
    computed: computedOptions,
    methods,
    watch: watchOptions,
    provide: provideOptions,
    inject: injectOptions,
    // lifecycle
    created,
    beforeMount,
    mounted,
    beforeUpdate,
    updated,
    activated,
    deactivated,
    beforeDestroy,
    beforeUnmount,
    destroyed,
    unmounted,
    render: render2,
    renderTracked,
    renderTriggered,
    errorCaptured,
    serverPrefetch,
    // public API
    expose,
    inheritAttrs,
    // assets
    components,
    directives,
    filters
  } = options;
  const checkDuplicateProperties = null;
  if (injectOptions) {
    resolveInjections(injectOptions, ctx, checkDuplicateProperties);
  }
  if (methods) {
    for (const key in methods) {
      const methodHandler = methods[key];
      if (isFunction$4(methodHandler)) {
        {
          ctx[key] = methodHandler.bind(publicThis);
        }
      }
    }
  }
  if (dataOptions) {
    const data = dataOptions.call(publicThis, publicThis);
    if (!isObject$6(data))
      ;
    else {
      instance.data = reactive(data);
    }
  }
  shouldCacheAccess = true;
  if (computedOptions) {
    for (const key in computedOptions) {
      const opt2 = computedOptions[key];
      const get2 = isFunction$4(opt2) ? opt2.bind(publicThis, publicThis) : isFunction$4(opt2.get) ? opt2.get.bind(publicThis, publicThis) : NOOP$1;
      const set2 = !isFunction$4(opt2) && isFunction$4(opt2.set) ? opt2.set.bind(publicThis) : NOOP$1;
      const c = computed({
        get: get2,
        set: set2
      });
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => c.value,
        set: (v) => c.value = v
      });
    }
  }
  if (watchOptions) {
    for (const key in watchOptions) {
      createWatcher(watchOptions[key], ctx, publicThis, key);
    }
  }
  if (provideOptions) {
    const provides = isFunction$4(provideOptions) ? provideOptions.call(publicThis) : provideOptions;
    Reflect.ownKeys(provides).forEach((key) => {
      provide(key, provides[key]);
    });
  }
  if (created) {
    callHook$1(created, instance, "c");
  }
  function registerLifecycleHook(register2, hook) {
    if (isArray$5(hook)) {
      hook.forEach((_hook) => register2(_hook.bind(publicThis)));
    } else if (hook) {
      register2(hook.bind(publicThis));
    }
  }
  registerLifecycleHook(onBeforeMount, beforeMount);
  registerLifecycleHook(onMounted, mounted);
  registerLifecycleHook(onBeforeUpdate, beforeUpdate);
  registerLifecycleHook(onUpdated, updated);
  registerLifecycleHook(onActivated, activated);
  registerLifecycleHook(onDeactivated, deactivated);
  registerLifecycleHook(onErrorCaptured, errorCaptured);
  registerLifecycleHook(onRenderTracked, renderTracked);
  registerLifecycleHook(onRenderTriggered, renderTriggered);
  registerLifecycleHook(onBeforeUnmount, beforeUnmount);
  registerLifecycleHook(onUnmounted, unmounted);
  registerLifecycleHook(onServerPrefetch, serverPrefetch);
  if (isArray$5(expose)) {
    if (expose.length) {
      const exposed = instance.exposed || (instance.exposed = {});
      expose.forEach((key) => {
        Object.defineProperty(exposed, key, {
          get: () => publicThis[key],
          set: (val) => publicThis[key] = val
        });
      });
    } else if (!instance.exposed) {
      instance.exposed = {};
    }
  }
  if (render2 && instance.render === NOOP$1) {
    instance.render = render2;
  }
  if (inheritAttrs != null) {
    instance.inheritAttrs = inheritAttrs;
  }
  if (components)
    instance.components = components;
  if (directives)
    instance.directives = directives;
}
function resolveInjections(injectOptions, ctx, checkDuplicateProperties = NOOP$1) {
  if (isArray$5(injectOptions)) {
    injectOptions = normalizeInject(injectOptions);
  }
  for (const key in injectOptions) {
    const opt2 = injectOptions[key];
    let injected;
    if (isObject$6(opt2)) {
      if ("default" in opt2) {
        injected = inject(
          opt2.from || key,
          opt2.default,
          true
          /* treat default function as factory */
        );
      } else {
        injected = inject(opt2.from || key);
      }
    } else {
      injected = inject(opt2);
    }
    if (isRef(injected)) {
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => injected.value,
        set: (v) => injected.value = v
      });
    } else {
      ctx[key] = injected;
    }
  }
}
function callHook$1(hook, instance, type) {
  callWithAsyncErrorHandling(isArray$5(hook) ? hook.map((h2) => h2.bind(instance.proxy)) : hook.bind(instance.proxy), instance, type);
}
function createWatcher(raw, ctx, publicThis, key) {
  const getter = key.includes(".") ? createPathGetter(publicThis, key) : () => publicThis[key];
  if (isString$4(raw)) {
    const handler = ctx[raw];
    if (isFunction$4(handler)) {
      watch(getter, handler);
    }
  } else if (isFunction$4(raw)) {
    watch(getter, raw.bind(publicThis));
  } else if (isObject$6(raw)) {
    if (isArray$5(raw)) {
      raw.forEach((r2) => createWatcher(r2, ctx, publicThis, key));
    } else {
      const handler = isFunction$4(raw.handler) ? raw.handler.bind(publicThis) : ctx[raw.handler];
      if (isFunction$4(handler)) {
        watch(getter, handler, raw);
      }
    }
  } else
    ;
}
function resolveMergedOptions(instance) {
  const base2 = instance.type;
  const {
    mixins,
    extends: extendsOptions
  } = base2;
  const {
    mixins: globalMixins,
    optionsCache: cache2,
    config: {
      optionMergeStrategies
    }
  } = instance.appContext;
  const cached = cache2.get(base2);
  let resolved;
  if (cached) {
    resolved = cached;
  } else if (!globalMixins.length && !mixins && !extendsOptions) {
    {
      resolved = base2;
    }
  } else {
    resolved = {};
    if (globalMixins.length) {
      globalMixins.forEach((m2) => mergeOptions$1(resolved, m2, optionMergeStrategies, true));
    }
    mergeOptions$1(resolved, base2, optionMergeStrategies);
  }
  if (isObject$6(base2)) {
    cache2.set(base2, resolved);
  }
  return resolved;
}
function mergeOptions$1(to, from, strats, asMixin = false) {
  const {
    mixins,
    extends: extendsOptions
  } = from;
  if (extendsOptions) {
    mergeOptions$1(to, extendsOptions, strats, true);
  }
  if (mixins) {
    mixins.forEach((m2) => mergeOptions$1(to, m2, strats, true));
  }
  for (const key in from) {
    if (asMixin && key === "expose")
      ;
    else {
      const strat = internalOptionMergeStrats[key] || strats && strats[key];
      to[key] = strat ? strat(to[key], from[key]) : from[key];
    }
  }
  return to;
}
const internalOptionMergeStrats = {
  data: mergeDataFn,
  props: mergeEmitsOrPropsOptions,
  emits: mergeEmitsOrPropsOptions,
  // objects
  methods: mergeObjectOptions,
  computed: mergeObjectOptions,
  // lifecycle
  beforeCreate: mergeAsArray,
  created: mergeAsArray,
  beforeMount: mergeAsArray,
  mounted: mergeAsArray,
  beforeUpdate: mergeAsArray,
  updated: mergeAsArray,
  beforeDestroy: mergeAsArray,
  beforeUnmount: mergeAsArray,
  destroyed: mergeAsArray,
  unmounted: mergeAsArray,
  activated: mergeAsArray,
  deactivated: mergeAsArray,
  errorCaptured: mergeAsArray,
  serverPrefetch: mergeAsArray,
  // assets
  components: mergeObjectOptions,
  directives: mergeObjectOptions,
  // watch
  watch: mergeWatchOptions,
  // provide / inject
  provide: mergeDataFn,
  inject: mergeInject
};
function mergeDataFn(to, from) {
  if (!from) {
    return to;
  }
  if (!to) {
    return from;
  }
  return function mergedDataFn() {
    return extend$1(isFunction$4(to) ? to.call(this, this) : to, isFunction$4(from) ? from.call(this, this) : from);
  };
}
function mergeInject(to, from) {
  return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
}
function normalizeInject(raw) {
  if (isArray$5(raw)) {
    const res = {};
    for (let i2 = 0; i2 < raw.length; i2++) {
      res[raw[i2]] = raw[i2];
    }
    return res;
  }
  return raw;
}
function mergeAsArray(to, from) {
  return to ? [...new Set([].concat(to, from))] : from;
}
function mergeObjectOptions(to, from) {
  return to ? extend$1(/* @__PURE__ */ Object.create(null), to, from) : from;
}
function mergeEmitsOrPropsOptions(to, from) {
  if (to) {
    if (isArray$5(to) && isArray$5(from)) {
      return [.../* @__PURE__ */ new Set([...to, ...from])];
    }
    return extend$1(/* @__PURE__ */ Object.create(null), normalizePropsOrEmits(to), normalizePropsOrEmits(from != null ? from : {}));
  } else {
    return from;
  }
}
function mergeWatchOptions(to, from) {
  if (!to)
    return from;
  if (!from)
    return to;
  const merged = extend$1(/* @__PURE__ */ Object.create(null), to);
  for (const key in from) {
    merged[key] = mergeAsArray(to[key], from[key]);
  }
  return merged;
}
function createAppContext() {
  return {
    app: null,
    config: {
      isNativeTag: NO,
      performance: false,
      globalProperties: {},
      optionMergeStrategies: {},
      errorHandler: void 0,
      warnHandler: void 0,
      compilerOptions: {}
    },
    mixins: [],
    components: {},
    directives: {},
    provides: /* @__PURE__ */ Object.create(null),
    optionsCache: /* @__PURE__ */ new WeakMap(),
    propsCache: /* @__PURE__ */ new WeakMap(),
    emitsCache: /* @__PURE__ */ new WeakMap()
  };
}
let uid$1 = 0;
function createAppAPI(render2, hydrate) {
  return function createApp2(rootComponent, rootProps = null) {
    if (!isFunction$4(rootComponent)) {
      rootComponent = extend$1({}, rootComponent);
    }
    if (rootProps != null && !isObject$6(rootProps)) {
      rootProps = null;
    }
    const context = createAppContext();
    const installedPlugins = /* @__PURE__ */ new Set();
    let isMounted = false;
    const app = context.app = {
      _uid: uid$1++,
      _component: rootComponent,
      _props: rootProps,
      _container: null,
      _context: context,
      _instance: null,
      version,
      get config() {
        return context.config;
      },
      set config(v) {
      },
      use(plugin, ...options) {
        if (installedPlugins.has(plugin))
          ;
        else if (plugin && isFunction$4(plugin.install)) {
          installedPlugins.add(plugin);
          plugin.install(app, ...options);
        } else if (isFunction$4(plugin)) {
          installedPlugins.add(plugin);
          plugin(app, ...options);
        } else
          ;
        return app;
      },
      mixin(mixin2) {
        {
          if (!context.mixins.includes(mixin2)) {
            context.mixins.push(mixin2);
          }
        }
        return app;
      },
      component(name, component) {
        if (!component) {
          return context.components[name];
        }
        context.components[name] = component;
        return app;
      },
      directive(name, directive) {
        if (!directive) {
          return context.directives[name];
        }
        context.directives[name] = directive;
        return app;
      },
      mount(rootContainer, isHydrate, isSVG) {
        if (!isMounted) {
          const vnode = createVNode(rootComponent, rootProps);
          vnode.appContext = context;
          if (isHydrate && hydrate) {
            hydrate(vnode, rootContainer);
          } else {
            render2(vnode, rootContainer, isSVG);
          }
          isMounted = true;
          app._container = rootContainer;
          rootContainer.__vue_app__ = app;
          return getExposeProxy(vnode.component) || vnode.component.proxy;
        }
      },
      unmount() {
        if (isMounted) {
          render2(null, app._container);
          delete app._container.__vue_app__;
        }
      },
      provide(key, value) {
        context.provides[key] = value;
        return app;
      },
      runWithContext(fn) {
        currentApp = app;
        try {
          return fn();
        } finally {
          currentApp = null;
        }
      }
    };
    return app;
  };
}
let currentApp = null;
function provide(key, value) {
  if (!currentInstance)
    ;
  else {
    let provides = currentInstance.provides;
    const parentProvides = currentInstance.parent && currentInstance.parent.provides;
    if (parentProvides === provides) {
      provides = currentInstance.provides = Object.create(parentProvides);
    }
    provides[key] = value;
  }
}
function inject(key, defaultValue, treatDefaultAsFactory = false) {
  const instance = currentInstance || currentRenderingInstance;
  if (instance || currentApp) {
    const provides = instance ? instance.parent == null ? instance.vnode.appContext && instance.vnode.appContext.provides : instance.parent.provides : currentApp._context.provides;
    if (provides && key in provides) {
      return provides[key];
    } else if (arguments.length > 1) {
      return treatDefaultAsFactory && isFunction$4(defaultValue) ? defaultValue.call(instance && instance.proxy) : defaultValue;
    } else
      ;
  }
}
function initProps$1(instance, rawProps, isStateful, isSSR = false) {
  const props = {};
  const attrs = {};
  def(attrs, InternalObjectKey, 1);
  instance.propsDefaults = /* @__PURE__ */ Object.create(null);
  setFullProps(instance, rawProps, props, attrs);
  for (const key in instance.propsOptions[0]) {
    if (!(key in props)) {
      props[key] = void 0;
    }
  }
  if (isStateful) {
    instance.props = isSSR ? props : shallowReactive(props);
  } else {
    if (!instance.type.props) {
      instance.props = attrs;
    } else {
      instance.props = props;
    }
  }
  instance.attrs = attrs;
}
function updateProps$2(instance, rawProps, rawPrevProps, optimized) {
  const {
    props,
    attrs,
    vnode: {
      patchFlag
    }
  } = instance;
  const rawCurrentProps = toRaw(props);
  const [options] = instance.propsOptions;
  let hasAttrsChanged = false;
  if (
    // always force full diff in dev
    // - #1942 if hmr is enabled with sfc component
    // - vite#872 non-sfc component used by sfc component
    (optimized || patchFlag > 0) && !(patchFlag & 16)
  ) {
    if (patchFlag & 8) {
      const propsToUpdate = instance.vnode.dynamicProps;
      for (let i2 = 0; i2 < propsToUpdate.length; i2++) {
        let key = propsToUpdate[i2];
        if (isEmitListener(instance.emitsOptions, key)) {
          continue;
        }
        const value = rawProps[key];
        if (options) {
          if (hasOwn$2(attrs, key)) {
            if (value !== attrs[key]) {
              attrs[key] = value;
              hasAttrsChanged = true;
            }
          } else {
            const camelizedKey = camelize(key);
            props[camelizedKey] = resolvePropValue(
              options,
              rawCurrentProps,
              camelizedKey,
              value,
              instance,
              false
              /* isAbsent */
            );
          }
        } else {
          if (value !== attrs[key]) {
            attrs[key] = value;
            hasAttrsChanged = true;
          }
        }
      }
    }
  } else {
    if (setFullProps(instance, rawProps, props, attrs)) {
      hasAttrsChanged = true;
    }
    let kebabKey;
    for (const key in rawCurrentProps) {
      if (!rawProps || // for camelCase
      !hasOwn$2(rawProps, key) && // it's possible the original props was passed in as kebab-case
      // and converted to camelCase (#955)
      ((kebabKey = hyphenate(key)) === key || !hasOwn$2(rawProps, kebabKey))) {
        if (options) {
          if (rawPrevProps && // for camelCase
          (rawPrevProps[key] !== void 0 || // for kebab-case
          rawPrevProps[kebabKey] !== void 0)) {
            props[key] = resolvePropValue(
              options,
              rawCurrentProps,
              key,
              void 0,
              instance,
              true
              /* isAbsent */
            );
          }
        } else {
          delete props[key];
        }
      }
    }
    if (attrs !== rawCurrentProps) {
      for (const key in attrs) {
        if (!rawProps || !hasOwn$2(rawProps, key) && true) {
          delete attrs[key];
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (hasAttrsChanged) {
    trigger(instance, "set", "$attrs");
  }
}
function setFullProps(instance, rawProps, props, attrs) {
  const [options, needCastKeys] = instance.propsOptions;
  let hasAttrsChanged = false;
  let rawCastValues;
  if (rawProps) {
    for (let key in rawProps) {
      if (isReservedProp(key)) {
        continue;
      }
      const value = rawProps[key];
      let camelKey;
      if (options && hasOwn$2(options, camelKey = camelize(key))) {
        if (!needCastKeys || !needCastKeys.includes(camelKey)) {
          props[camelKey] = value;
        } else {
          (rawCastValues || (rawCastValues = {}))[camelKey] = value;
        }
      } else if (!isEmitListener(instance.emitsOptions, key)) {
        if (!(key in attrs) || value !== attrs[key]) {
          attrs[key] = value;
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (needCastKeys) {
    const rawCurrentProps = toRaw(props);
    const castValues = rawCastValues || EMPTY_OBJ$1;
    for (let i2 = 0; i2 < needCastKeys.length; i2++) {
      const key = needCastKeys[i2];
      props[key] = resolvePropValue(options, rawCurrentProps, key, castValues[key], instance, !hasOwn$2(castValues, key));
    }
  }
  return hasAttrsChanged;
}
function resolvePropValue(options, props, key, value, instance, isAbsent) {
  const opt2 = options[key];
  if (opt2 != null) {
    const hasDefault = hasOwn$2(opt2, "default");
    if (hasDefault && value === void 0) {
      const defaultValue = opt2.default;
      if (opt2.type !== Function && !opt2.skipFactory && isFunction$4(defaultValue)) {
        const {
          propsDefaults
        } = instance;
        if (key in propsDefaults) {
          value = propsDefaults[key];
        } else {
          setCurrentInstance(instance);
          value = propsDefaults[key] = defaultValue.call(null, props);
          unsetCurrentInstance();
        }
      } else {
        value = defaultValue;
      }
    }
    if (opt2[
      0
      /* shouldCast */
    ]) {
      if (isAbsent && !hasDefault) {
        value = false;
      } else if (opt2[
        1
        /* shouldCastTrue */
      ] && (value === "" || value === hyphenate(key))) {
        value = true;
      }
    }
  }
  return value;
}
function normalizePropsOptions(comp, appContext, asMixin = false) {
  const cache2 = appContext.propsCache;
  const cached = cache2.get(comp);
  if (cached) {
    return cached;
  }
  const raw = comp.props;
  const normalized = {};
  const needCastKeys = [];
  let hasExtends = false;
  if (!isFunction$4(comp)) {
    const extendProps = (raw2) => {
      hasExtends = true;
      const [props, keys2] = normalizePropsOptions(raw2, appContext, true);
      extend$1(normalized, props);
      if (keys2)
        needCastKeys.push(...keys2);
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendProps);
    }
    if (comp.extends) {
      extendProps(comp.extends);
    }
    if (comp.mixins) {
      comp.mixins.forEach(extendProps);
    }
  }
  if (!raw && !hasExtends) {
    if (isObject$6(comp)) {
      cache2.set(comp, EMPTY_ARR);
    }
    return EMPTY_ARR;
  }
  if (isArray$5(raw)) {
    for (let i2 = 0; i2 < raw.length; i2++) {
      const normalizedKey = camelize(raw[i2]);
      if (validatePropName(normalizedKey)) {
        normalized[normalizedKey] = EMPTY_OBJ$1;
      }
    }
  } else if (raw) {
    for (const key in raw) {
      const normalizedKey = camelize(key);
      if (validatePropName(normalizedKey)) {
        const opt2 = raw[key];
        const prop = normalized[normalizedKey] = isArray$5(opt2) || isFunction$4(opt2) ? {
          type: opt2
        } : extend$1({}, opt2);
        if (prop) {
          const booleanIndex = getTypeIndex(Boolean, prop.type);
          const stringIndex = getTypeIndex(String, prop.type);
          prop[
            0
            /* shouldCast */
          ] = booleanIndex > -1;
          prop[
            1
            /* shouldCastTrue */
          ] = stringIndex < 0 || booleanIndex < stringIndex;
          if (booleanIndex > -1 || hasOwn$2(prop, "default")) {
            needCastKeys.push(normalizedKey);
          }
        }
      }
    }
  }
  const res = [normalized, needCastKeys];
  if (isObject$6(comp)) {
    cache2.set(comp, res);
  }
  return res;
}
function validatePropName(key) {
  if (key[0] !== "$") {
    return true;
  }
  return false;
}
function getType(ctor) {
  const match = ctor && ctor.toString().match(/^\s*(function|class) (\w+)/);
  return match ? match[2] : ctor === null ? "null" : "";
}
function isSameType(a, b2) {
  return getType(a) === getType(b2);
}
function getTypeIndex(type, expectedTypes) {
  if (isArray$5(expectedTypes)) {
    return expectedTypes.findIndex((t2) => isSameType(t2, type));
  } else if (isFunction$4(expectedTypes)) {
    return isSameType(expectedTypes, type) ? 0 : -1;
  }
  return -1;
}
const isInternalKey = (key) => key[0] === "_" || key === "$stable";
const normalizeSlotValue = (value) => isArray$5(value) ? value.map(normalizeVNode) : [normalizeVNode(value)];
const normalizeSlot$1 = (key, rawSlot, ctx) => {
  if (rawSlot._n) {
    return rawSlot;
  }
  const normalized = withCtx((...args) => {
    if (false)
      ;
    return normalizeSlotValue(rawSlot(...args));
  }, ctx);
  normalized._c = false;
  return normalized;
};
const normalizeObjectSlots = (rawSlots, slots, instance) => {
  const ctx = rawSlots._ctx;
  for (const key in rawSlots) {
    if (isInternalKey(key))
      continue;
    const value = rawSlots[key];
    if (isFunction$4(value)) {
      slots[key] = normalizeSlot$1(key, value, ctx);
    } else if (value != null) {
      const normalized = normalizeSlotValue(value);
      slots[key] = () => normalized;
    }
  }
};
const normalizeVNodeSlots = (instance, children) => {
  const normalized = normalizeSlotValue(children);
  instance.slots.default = () => normalized;
};
const initSlots = (instance, children) => {
  if (instance.vnode.shapeFlag & 32) {
    const type = children._;
    if (type) {
      instance.slots = toRaw(children);
      def(children, "_", type);
    } else {
      normalizeObjectSlots(children, instance.slots = {});
    }
  } else {
    instance.slots = {};
    if (children) {
      normalizeVNodeSlots(instance, children);
    }
  }
  def(instance.slots, InternalObjectKey, 1);
};
const updateSlots = (instance, children, optimized) => {
  const {
    vnode,
    slots
  } = instance;
  let needDeletionCheck = true;
  let deletionComparisonTarget = EMPTY_OBJ$1;
  if (vnode.shapeFlag & 32) {
    const type = children._;
    if (type) {
      if (optimized && type === 1) {
        needDeletionCheck = false;
      } else {
        extend$1(slots, children);
        if (!optimized && type === 1) {
          delete slots._;
        }
      }
    } else {
      needDeletionCheck = !children.$stable;
      normalizeObjectSlots(children, slots);
    }
    deletionComparisonTarget = children;
  } else if (children) {
    normalizeVNodeSlots(instance, children);
    deletionComparisonTarget = {
      default: 1
    };
  }
  if (needDeletionCheck) {
    for (const key in slots) {
      if (!isInternalKey(key) && !(key in deletionComparisonTarget)) {
        delete slots[key];
      }
    }
  }
};
function setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {
  if (isArray$5(rawRef)) {
    rawRef.forEach((r2, i2) => setRef(r2, oldRawRef && (isArray$5(oldRawRef) ? oldRawRef[i2] : oldRawRef), parentSuspense, vnode, isUnmount));
    return;
  }
  if (isAsyncWrapper(vnode) && !isUnmount) {
    return;
  }
  const refValue = vnode.shapeFlag & 4 ? getExposeProxy(vnode.component) || vnode.component.proxy : vnode.el;
  const value = isUnmount ? null : refValue;
  const {
    i: owner,
    r: ref2
  } = rawRef;
  const oldRef = oldRawRef && oldRawRef.r;
  const refs = owner.refs === EMPTY_OBJ$1 ? owner.refs = {} : owner.refs;
  const setupState = owner.setupState;
  if (oldRef != null && oldRef !== ref2) {
    if (isString$4(oldRef)) {
      refs[oldRef] = null;
      if (hasOwn$2(setupState, oldRef)) {
        setupState[oldRef] = null;
      }
    } else if (isRef(oldRef)) {
      oldRef.value = null;
    }
  }
  if (isFunction$4(ref2)) {
    callWithErrorHandling(ref2, owner, 12, [value, refs]);
  } else {
    const _isString = isString$4(ref2);
    const _isRef = isRef(ref2);
    if (_isString || _isRef) {
      const doSet = () => {
        if (rawRef.f) {
          const existing = _isString ? hasOwn$2(setupState, ref2) ? setupState[ref2] : refs[ref2] : ref2.value;
          if (isUnmount) {
            isArray$5(existing) && remove(existing, refValue);
          } else {
            if (!isArray$5(existing)) {
              if (_isString) {
                refs[ref2] = [refValue];
                if (hasOwn$2(setupState, ref2)) {
                  setupState[ref2] = refs[ref2];
                }
              } else {
                ref2.value = [refValue];
                if (rawRef.k)
                  refs[rawRef.k] = ref2.value;
              }
            } else if (!existing.includes(refValue)) {
              existing.push(refValue);
            }
          }
        } else if (_isString) {
          refs[ref2] = value;
          if (hasOwn$2(setupState, ref2)) {
            setupState[ref2] = value;
          }
        } else if (_isRef) {
          ref2.value = value;
          if (rawRef.k)
            refs[rawRef.k] = value;
        } else
          ;
      };
      if (value) {
        doSet.id = -1;
        queuePostRenderEffect(doSet, parentSuspense);
      } else {
        doSet();
      }
    }
  }
}
const queuePostRenderEffect = queueEffectWithSuspense;
function createRenderer(options) {
  return baseCreateRenderer(options);
}
function baseCreateRenderer(options, createHydrationFns) {
  const target2 = getGlobalThis();
  target2.__VUE__ = true;
  const {
    insert: hostInsert,
    remove: hostRemove,
    patchProp: hostPatchProp,
    createElement: hostCreateElement,
    createText: hostCreateText,
    createComment: hostCreateComment,
    setText: hostSetText,
    setElementText: hostSetElementText,
    parentNode: hostParentNode,
    nextSibling: hostNextSibling,
    setScopeId: hostSetScopeId = NOOP$1,
    insertStaticContent: hostInsertStaticContent
  } = options;
  const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, isSVG = false, slotScopeIds = null, optimized = !!n2.dynamicChildren) => {
    if (n1 === n2) {
      return;
    }
    if (n1 && !isSameVNodeType(n1, n2)) {
      anchor = getNextHostNode(n1);
      unmount(n1, parentComponent, parentSuspense, true);
      n1 = null;
    }
    if (n2.patchFlag === -2) {
      optimized = false;
      n2.dynamicChildren = null;
    }
    const {
      type,
      ref: ref2,
      shapeFlag
    } = n2;
    switch (type) {
      case Text:
        processText(n1, n2, container, anchor);
        break;
      case Comment:
        processCommentNode(n1, n2, container, anchor);
        break;
      case Static:
        if (n1 == null) {
          mountStaticNode(n2, container, anchor, isSVG);
        }
        break;
      case Fragment:
        processFragment(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        break;
      default:
        if (shapeFlag & 1) {
          processElement(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (shapeFlag & 6) {
          processComponent(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (shapeFlag & 64) {
          type.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
        } else if (shapeFlag & 128) {
          type.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
        } else
          ;
    }
    if (ref2 != null && parentComponent) {
      setRef(ref2, n1 && n1.ref, parentSuspense, n2 || n1, !n2);
    }
  };
  const processText = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(n2.el = hostCreateText(n2.children), container, anchor);
    } else {
      const el = n2.el = n1.el;
      if (n2.children !== n1.children) {
        hostSetText(el, n2.children);
      }
    }
  };
  const processCommentNode = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(n2.el = hostCreateComment(n2.children || ""), container, anchor);
    } else {
      n2.el = n1.el;
    }
  };
  const mountStaticNode = (n2, container, anchor, isSVG) => {
    [n2.el, n2.anchor] = hostInsertStaticContent(n2.children, container, anchor, isSVG, n2.el, n2.anchor);
  };
  const moveStaticNode = ({
    el,
    anchor
  }, container, nextSibling) => {
    let next;
    while (el && el !== anchor) {
      next = hostNextSibling(el);
      hostInsert(el, container, nextSibling);
      el = next;
    }
    hostInsert(anchor, container, nextSibling);
  };
  const removeStaticNode = ({
    el,
    anchor
  }) => {
    let next;
    while (el && el !== anchor) {
      next = hostNextSibling(el);
      hostRemove(el);
      el = next;
    }
    hostRemove(anchor);
  };
  const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    isSVG = isSVG || n2.type === "svg";
    if (n1 == null) {
      mountElement(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    } else {
      patchElement(n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
  };
  const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    let el;
    let vnodeHook;
    const {
      type,
      props,
      shapeFlag,
      transition,
      dirs
    } = vnode;
    el = vnode.el = hostCreateElement(vnode.type, isSVG, props && props.is, props);
    if (shapeFlag & 8) {
      hostSetElementText(el, vnode.children);
    } else if (shapeFlag & 16) {
      mountChildren(vnode.children, el, null, parentComponent, parentSuspense, isSVG && type !== "foreignObject", slotScopeIds, optimized);
    }
    if (dirs) {
      invokeDirectiveHook(vnode, null, parentComponent, "created");
    }
    setScopeId(el, vnode, vnode.scopeId, slotScopeIds, parentComponent);
    if (props) {
      for (const key in props) {
        if (key !== "value" && !isReservedProp(key)) {
          hostPatchProp(el, key, null, props[key], isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
        }
      }
      if ("value" in props) {
        hostPatchProp(el, "value", null, props.value);
      }
      if (vnodeHook = props.onVnodeBeforeMount) {
        invokeVNodeHook(vnodeHook, parentComponent, vnode);
      }
    }
    if (dirs) {
      invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
    }
    const needCallTransitionHooks = (!parentSuspense || parentSuspense && !parentSuspense.pendingBranch) && transition && !transition.persisted;
    if (needCallTransitionHooks) {
      transition.beforeEnter(el);
    }
    hostInsert(el, container, anchor);
    if ((vnodeHook = props && props.onVnodeMounted) || needCallTransitionHooks || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        needCallTransitionHooks && transition.enter(el);
        dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
      }, parentSuspense);
    }
  };
  const setScopeId = (el, vnode, scopeId, slotScopeIds, parentComponent) => {
    if (scopeId) {
      hostSetScopeId(el, scopeId);
    }
    if (slotScopeIds) {
      for (let i2 = 0; i2 < slotScopeIds.length; i2++) {
        hostSetScopeId(el, slotScopeIds[i2]);
      }
    }
    if (parentComponent) {
      let subTree = parentComponent.subTree;
      if (vnode === subTree) {
        const parentVNode = parentComponent.vnode;
        setScopeId(el, parentVNode, parentVNode.scopeId, parentVNode.slotScopeIds, parentComponent.parent);
      }
    }
  };
  const mountChildren = (children, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, start2 = 0) => {
    for (let i2 = start2; i2 < children.length; i2++) {
      const child = children[i2] = optimized ? cloneIfMounted(children[i2]) : normalizeVNode(children[i2]);
      patch(null, child, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
  };
  const patchElement = (n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    const el = n2.el = n1.el;
    let {
      patchFlag,
      dynamicChildren,
      dirs
    } = n2;
    patchFlag |= n1.patchFlag & 16;
    const oldProps = n1.props || EMPTY_OBJ$1;
    const newProps = n2.props || EMPTY_OBJ$1;
    let vnodeHook;
    parentComponent && toggleRecurse(parentComponent, false);
    if (vnodeHook = newProps.onVnodeBeforeUpdate) {
      invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
    }
    if (dirs) {
      invokeDirectiveHook(n2, n1, parentComponent, "beforeUpdate");
    }
    parentComponent && toggleRecurse(parentComponent, true);
    const areChildrenSVG = isSVG && n2.type !== "foreignObject";
    if (dynamicChildren) {
      patchBlockChildren(n1.dynamicChildren, dynamicChildren, el, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds);
    } else if (!optimized) {
      patchChildren(n1, n2, el, null, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds, false);
    }
    if (patchFlag > 0) {
      if (patchFlag & 16) {
        patchProps(el, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
      } else {
        if (patchFlag & 2) {
          if (oldProps.class !== newProps.class) {
            hostPatchProp(el, "class", null, newProps.class, isSVG);
          }
        }
        if (patchFlag & 4) {
          hostPatchProp(el, "style", oldProps.style, newProps.style, isSVG);
        }
        if (patchFlag & 8) {
          const propsToUpdate = n2.dynamicProps;
          for (let i2 = 0; i2 < propsToUpdate.length; i2++) {
            const key = propsToUpdate[i2];
            const prev = oldProps[key];
            const next = newProps[key];
            if (next !== prev || key === "value") {
              hostPatchProp(el, key, prev, next, isSVG, n1.children, parentComponent, parentSuspense, unmountChildren);
            }
          }
        }
      }
      if (patchFlag & 1) {
        if (n1.children !== n2.children) {
          hostSetElementText(el, n2.children);
        }
      }
    } else if (!optimized && dynamicChildren == null) {
      patchProps(el, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
    }
    if ((vnodeHook = newProps.onVnodeUpdated) || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
        dirs && invokeDirectiveHook(n2, n1, parentComponent, "updated");
      }, parentSuspense);
    }
  };
  const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, isSVG, slotScopeIds) => {
    for (let i2 = 0; i2 < newChildren.length; i2++) {
      const oldVNode = oldChildren[i2];
      const newVNode = newChildren[i2];
      const container = (
        // oldVNode may be an errored async setup() component inside Suspense
        // which will not have a mounted element
        oldVNode.el && // - In the case of a Fragment, we need to provide the actual parent
        // of the Fragment itself so it can move its children.
        (oldVNode.type === Fragment || // - In the case of different nodes, there is going to be a replacement
        // which also requires the correct parent container
        !isSameVNodeType(oldVNode, newVNode) || // - In the case of a component, it could contain anything.
        oldVNode.shapeFlag & (6 | 64)) ? hostParentNode(oldVNode.el) : (
          // In other cases, the parent container is not actually used so we
          // just pass the block element here to avoid a DOM parentNode call.
          fallbackContainer
        )
      );
      patch(oldVNode, newVNode, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, true);
    }
  };
  const patchProps = (el, vnode, oldProps, newProps, parentComponent, parentSuspense, isSVG) => {
    if (oldProps !== newProps) {
      if (oldProps !== EMPTY_OBJ$1) {
        for (const key in oldProps) {
          if (!isReservedProp(key) && !(key in newProps)) {
            hostPatchProp(el, key, oldProps[key], null, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
          }
        }
      }
      for (const key in newProps) {
        if (isReservedProp(key))
          continue;
        const next = newProps[key];
        const prev = oldProps[key];
        if (next !== prev && key !== "value") {
          hostPatchProp(el, key, prev, next, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
        }
      }
      if ("value" in newProps) {
        hostPatchProp(el, "value", oldProps.value, newProps.value);
      }
    }
  };
  const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    const fragmentStartAnchor = n2.el = n1 ? n1.el : hostCreateText("");
    const fragmentEndAnchor = n2.anchor = n1 ? n1.anchor : hostCreateText("");
    let {
      patchFlag,
      dynamicChildren,
      slotScopeIds: fragmentSlotScopeIds
    } = n2;
    if (fragmentSlotScopeIds) {
      slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
    }
    if (n1 == null) {
      hostInsert(fragmentStartAnchor, container, anchor);
      hostInsert(fragmentEndAnchor, container, anchor);
      mountChildren(n2.children, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    } else {
      if (patchFlag > 0 && patchFlag & 64 && dynamicChildren && // #2715 the previous fragment could've been a BAILed one as a result
      // of renderSlot() with no valid children
      n1.dynamicChildren) {
        patchBlockChildren(n1.dynamicChildren, dynamicChildren, container, parentComponent, parentSuspense, isSVG, slotScopeIds);
        if (
          // #2080 if the stable fragment has a key, it's a <template v-for> that may
          //  get moved around. Make sure all root level vnodes inherit el.
          // #2134 or if it's a component root, it may also get moved around
          // as the component is being moved.
          n2.key != null || parentComponent && n2 === parentComponent.subTree
        ) {
          traverseStaticChildren(
            n1,
            n2,
            true
            /* shallow */
          );
        }
      } else {
        patchChildren(n1, n2, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      }
    }
  };
  const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    n2.slotScopeIds = slotScopeIds;
    if (n1 == null) {
      if (n2.shapeFlag & 512) {
        parentComponent.ctx.activate(n2, container, anchor, isSVG, optimized);
      } else {
        mountComponent(n2, container, anchor, parentComponent, parentSuspense, isSVG, optimized);
      }
    } else {
      updateComponent(n1, n2, optimized);
    }
  };
  const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, isSVG, optimized) => {
    const instance = initialVNode.component = createComponentInstance(initialVNode, parentComponent, parentSuspense);
    if (isKeepAlive(initialVNode)) {
      instance.ctx.renderer = internals;
    }
    {
      setupComponent(instance);
    }
    if (instance.asyncDep) {
      parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect);
      if (!initialVNode.el) {
        const placeholder = instance.subTree = createVNode(Comment);
        processCommentNode(null, placeholder, container, anchor);
      }
      return;
    }
    setupRenderEffect(instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized);
  };
  const updateComponent = (n1, n2, optimized) => {
    const instance = n2.component = n1.component;
    if (shouldUpdateComponent(n1, n2, optimized)) {
      if (instance.asyncDep && !instance.asyncResolved) {
        updateComponentPreRender(instance, n2, optimized);
        return;
      } else {
        instance.next = n2;
        invalidateJob(instance.update);
        instance.update();
      }
    } else {
      n2.el = n1.el;
      instance.vnode = n2;
    }
  };
  const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized) => {
    const componentUpdateFn = () => {
      if (!instance.isMounted) {
        let vnodeHook;
        const {
          el,
          props
        } = initialVNode;
        const {
          bm,
          m: m2,
          parent
        } = instance;
        const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);
        toggleRecurse(instance, false);
        if (bm) {
          invokeArrayFns(bm);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeBeforeMount)) {
          invokeVNodeHook(vnodeHook, parent, initialVNode);
        }
        toggleRecurse(instance, true);
        if (el && hydrateNode) {
          const hydrateSubTree = () => {
            instance.subTree = renderComponentRoot(instance);
            hydrateNode(el, instance.subTree, instance, parentSuspense, null);
          };
          if (isAsyncWrapperVNode) {
            initialVNode.type.__asyncLoader().then(
              // note: we are moving the render call into an async callback,
              // which means it won't track dependencies - but it's ok because
              // a server-rendered async wrapper is already in resolved state
              // and it will never need to change.
              () => !instance.isUnmounted && hydrateSubTree()
            );
          } else {
            hydrateSubTree();
          }
        } else {
          const subTree = instance.subTree = renderComponentRoot(instance);
          patch(null, subTree, container, anchor, instance, parentSuspense, isSVG);
          initialVNode.el = subTree.el;
        }
        if (m2) {
          queuePostRenderEffect(m2, parentSuspense);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeMounted)) {
          const scopedInitialVNode = initialVNode;
          queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, scopedInitialVNode), parentSuspense);
        }
        if (initialVNode.shapeFlag & 256 || parent && isAsyncWrapper(parent.vnode) && parent.vnode.shapeFlag & 256) {
          instance.a && queuePostRenderEffect(instance.a, parentSuspense);
        }
        instance.isMounted = true;
        initialVNode = container = anchor = null;
      } else {
        let {
          next,
          bu,
          u,
          parent,
          vnode
        } = instance;
        let originNext = next;
        let vnodeHook;
        toggleRecurse(instance, false);
        if (next) {
          next.el = vnode.el;
          updateComponentPreRender(instance, next, optimized);
        } else {
          next = vnode;
        }
        if (bu) {
          invokeArrayFns(bu);
        }
        if (vnodeHook = next.props && next.props.onVnodeBeforeUpdate) {
          invokeVNodeHook(vnodeHook, parent, next, vnode);
        }
        toggleRecurse(instance, true);
        const nextTree = renderComponentRoot(instance);
        const prevTree = instance.subTree;
        instance.subTree = nextTree;
        patch(
          prevTree,
          nextTree,
          // parent may have changed if it's in a teleport
          hostParentNode(prevTree.el),
          // anchor may have changed if it's in a fragment
          getNextHostNode(prevTree),
          instance,
          parentSuspense,
          isSVG
        );
        next.el = nextTree.el;
        if (originNext === null) {
          updateHOCHostEl(instance, nextTree.el);
        }
        if (u) {
          queuePostRenderEffect(u, parentSuspense);
        }
        if (vnodeHook = next.props && next.props.onVnodeUpdated) {
          queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, next, vnode), parentSuspense);
        }
      }
    };
    const effect = instance.effect = new ReactiveEffect(
      componentUpdateFn,
      () => queueJob(update),
      instance.scope
      // track it in component's effect scope
    );
    const update = instance.update = () => effect.run();
    update.id = instance.uid;
    toggleRecurse(instance, true);
    update();
  };
  const updateComponentPreRender = (instance, nextVNode, optimized) => {
    nextVNode.component = instance;
    const prevProps = instance.vnode.props;
    instance.vnode = nextVNode;
    instance.next = null;
    updateProps$2(instance, nextVNode.props, prevProps, optimized);
    updateSlots(instance, nextVNode.children, optimized);
    pauseTracking();
    flushPreFlushCbs();
    resetTracking();
  };
  const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized = false) => {
    const c1 = n1 && n1.children;
    const prevShapeFlag = n1 ? n1.shapeFlag : 0;
    const c2 = n2.children;
    const {
      patchFlag,
      shapeFlag
    } = n2;
    if (patchFlag > 0) {
      if (patchFlag & 128) {
        patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        return;
      } else if (patchFlag & 256) {
        patchUnkeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        return;
      }
    }
    if (shapeFlag & 8) {
      if (prevShapeFlag & 16) {
        unmountChildren(c1, parentComponent, parentSuspense);
      }
      if (c2 !== c1) {
        hostSetElementText(container, c2);
      }
    } else {
      if (prevShapeFlag & 16) {
        if (shapeFlag & 16) {
          patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else {
          unmountChildren(c1, parentComponent, parentSuspense, true);
        }
      } else {
        if (prevShapeFlag & 8) {
          hostSetElementText(container, "");
        }
        if (shapeFlag & 16) {
          mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
      }
    }
  };
  const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    c1 = c1 || EMPTY_ARR;
    c2 = c2 || EMPTY_ARR;
    const oldLength = c1.length;
    const newLength = c2.length;
    const commonLength = Math.min(oldLength, newLength);
    let i2;
    for (i2 = 0; i2 < commonLength; i2++) {
      const nextChild = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
      patch(c1[i2], nextChild, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
    if (oldLength > newLength) {
      unmountChildren(c1, parentComponent, parentSuspense, true, false, commonLength);
    } else {
      mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, commonLength);
    }
  };
  const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    let i2 = 0;
    const l2 = c2.length;
    let e1 = c1.length - 1;
    let e2 = l2 - 1;
    while (i2 <= e1 && i2 <= e2) {
      const n1 = c1[i2];
      const n2 = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
      if (isSameVNodeType(n1, n2)) {
        patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      } else {
        break;
      }
      i2++;
    }
    while (i2 <= e1 && i2 <= e2) {
      const n1 = c1[e1];
      const n2 = c2[e2] = optimized ? cloneIfMounted(c2[e2]) : normalizeVNode(c2[e2]);
      if (isSameVNodeType(n1, n2)) {
        patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      } else {
        break;
      }
      e1--;
      e2--;
    }
    if (i2 > e1) {
      if (i2 <= e2) {
        const nextPos = e2 + 1;
        const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;
        while (i2 <= e2) {
          patch(null, c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]), container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
          i2++;
        }
      }
    } else if (i2 > e2) {
      while (i2 <= e1) {
        unmount(c1[i2], parentComponent, parentSuspense, true);
        i2++;
      }
    } else {
      const s1 = i2;
      const s2 = i2;
      const keyToNewIndexMap = /* @__PURE__ */ new Map();
      for (i2 = s2; i2 <= e2; i2++) {
        const nextChild = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
        if (nextChild.key != null) {
          keyToNewIndexMap.set(nextChild.key, i2);
        }
      }
      let j2;
      let patched = 0;
      const toBePatched = e2 - s2 + 1;
      let moved = false;
      let maxNewIndexSoFar = 0;
      const newIndexToOldIndexMap = new Array(toBePatched);
      for (i2 = 0; i2 < toBePatched; i2++)
        newIndexToOldIndexMap[i2] = 0;
      for (i2 = s1; i2 <= e1; i2++) {
        const prevChild = c1[i2];
        if (patched >= toBePatched) {
          unmount(prevChild, parentComponent, parentSuspense, true);
          continue;
        }
        let newIndex;
        if (prevChild.key != null) {
          newIndex = keyToNewIndexMap.get(prevChild.key);
        } else {
          for (j2 = s2; j2 <= e2; j2++) {
            if (newIndexToOldIndexMap[j2 - s2] === 0 && isSameVNodeType(prevChild, c2[j2])) {
              newIndex = j2;
              break;
            }
          }
        }
        if (newIndex === void 0) {
          unmount(prevChild, parentComponent, parentSuspense, true);
        } else {
          newIndexToOldIndexMap[newIndex - s2] = i2 + 1;
          if (newIndex >= maxNewIndexSoFar) {
            maxNewIndexSoFar = newIndex;
          } else {
            moved = true;
          }
          patch(prevChild, c2[newIndex], container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
          patched++;
        }
      }
      const increasingNewIndexSequence = moved ? getSequence(newIndexToOldIndexMap) : EMPTY_ARR;
      j2 = increasingNewIndexSequence.length - 1;
      for (i2 = toBePatched - 1; i2 >= 0; i2--) {
        const nextIndex = s2 + i2;
        const nextChild = c2[nextIndex];
        const anchor = nextIndex + 1 < l2 ? c2[nextIndex + 1].el : parentAnchor;
        if (newIndexToOldIndexMap[i2] === 0) {
          patch(null, nextChild, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (moved) {
          if (j2 < 0 || i2 !== increasingNewIndexSequence[j2]) {
            move(nextChild, container, anchor, 2);
          } else {
            j2--;
          }
        }
      }
    }
  };
  const move = (vnode, container, anchor, moveType, parentSuspense = null) => {
    const {
      el,
      type,
      transition,
      children,
      shapeFlag
    } = vnode;
    if (shapeFlag & 6) {
      move(vnode.component.subTree, container, anchor, moveType);
      return;
    }
    if (shapeFlag & 128) {
      vnode.suspense.move(container, anchor, moveType);
      return;
    }
    if (shapeFlag & 64) {
      type.move(vnode, container, anchor, internals);
      return;
    }
    if (type === Fragment) {
      hostInsert(el, container, anchor);
      for (let i2 = 0; i2 < children.length; i2++) {
        move(children[i2], container, anchor, moveType);
      }
      hostInsert(vnode.anchor, container, anchor);
      return;
    }
    if (type === Static) {
      moveStaticNode(vnode, container, anchor);
      return;
    }
    const needTransition = moveType !== 2 && shapeFlag & 1 && transition;
    if (needTransition) {
      if (moveType === 0) {
        transition.beforeEnter(el);
        hostInsert(el, container, anchor);
        queuePostRenderEffect(() => transition.enter(el), parentSuspense);
      } else {
        const {
          leave,
          delayLeave,
          afterLeave
        } = transition;
        const remove22 = () => hostInsert(el, container, anchor);
        const performLeave = () => {
          leave(el, () => {
            remove22();
            afterLeave && afterLeave();
          });
        };
        if (delayLeave) {
          delayLeave(el, remove22, performLeave);
        } else {
          performLeave();
        }
      }
    } else {
      hostInsert(el, container, anchor);
    }
  };
  const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false) => {
    const {
      type,
      props,
      ref: ref2,
      children,
      dynamicChildren,
      shapeFlag,
      patchFlag,
      dirs
    } = vnode;
    if (ref2 != null) {
      setRef(ref2, null, parentSuspense, vnode, true);
    }
    if (shapeFlag & 256) {
      parentComponent.ctx.deactivate(vnode);
      return;
    }
    const shouldInvokeDirs = shapeFlag & 1 && dirs;
    const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);
    let vnodeHook;
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeBeforeUnmount)) {
      invokeVNodeHook(vnodeHook, parentComponent, vnode);
    }
    if (shapeFlag & 6) {
      unmountComponent(vnode.component, parentSuspense, doRemove);
    } else {
      if (shapeFlag & 128) {
        vnode.suspense.unmount(parentSuspense, doRemove);
        return;
      }
      if (shouldInvokeDirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeUnmount");
      }
      if (shapeFlag & 64) {
        vnode.type.remove(vnode, parentComponent, parentSuspense, optimized, internals, doRemove);
      } else if (dynamicChildren && // #1153: fast path should not be taken for non-stable (v-for) fragments
      (type !== Fragment || patchFlag > 0 && patchFlag & 64)) {
        unmountChildren(dynamicChildren, parentComponent, parentSuspense, false, true);
      } else if (type === Fragment && patchFlag & (128 | 256) || !optimized && shapeFlag & 16) {
        unmountChildren(children, parentComponent, parentSuspense);
      }
      if (doRemove) {
        remove2(vnode);
      }
    }
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeUnmounted) || shouldInvokeDirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        shouldInvokeDirs && invokeDirectiveHook(vnode, null, parentComponent, "unmounted");
      }, parentSuspense);
    }
  };
  const remove2 = (vnode) => {
    const {
      type,
      el,
      anchor,
      transition
    } = vnode;
    if (type === Fragment) {
      {
        removeFragment(el, anchor);
      }
      return;
    }
    if (type === Static) {
      removeStaticNode(vnode);
      return;
    }
    const performRemove = () => {
      hostRemove(el);
      if (transition && !transition.persisted && transition.afterLeave) {
        transition.afterLeave();
      }
    };
    if (vnode.shapeFlag & 1 && transition && !transition.persisted) {
      const {
        leave,
        delayLeave
      } = transition;
      const performLeave = () => leave(el, performRemove);
      if (delayLeave) {
        delayLeave(vnode.el, performRemove, performLeave);
      } else {
        performLeave();
      }
    } else {
      performRemove();
    }
  };
  const removeFragment = (cur, end2) => {
    let next;
    while (cur !== end2) {
      next = hostNextSibling(cur);
      hostRemove(cur);
      cur = next;
    }
    hostRemove(end2);
  };
  const unmountComponent = (instance, parentSuspense, doRemove) => {
    const {
      bum,
      scope,
      update,
      subTree,
      um
    } = instance;
    if (bum) {
      invokeArrayFns(bum);
    }
    scope.stop();
    if (update) {
      update.active = false;
      unmount(subTree, instance, parentSuspense, doRemove);
    }
    if (um) {
      queuePostRenderEffect(um, parentSuspense);
    }
    queuePostRenderEffect(() => {
      instance.isUnmounted = true;
    }, parentSuspense);
    if (parentSuspense && parentSuspense.pendingBranch && !parentSuspense.isUnmounted && instance.asyncDep && !instance.asyncResolved && instance.suspenseId === parentSuspense.pendingId) {
      parentSuspense.deps--;
      if (parentSuspense.deps === 0) {
        parentSuspense.resolve();
      }
    }
  };
  const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start2 = 0) => {
    for (let i2 = start2; i2 < children.length; i2++) {
      unmount(children[i2], parentComponent, parentSuspense, doRemove, optimized);
    }
  };
  const getNextHostNode = (vnode) => {
    if (vnode.shapeFlag & 6) {
      return getNextHostNode(vnode.component.subTree);
    }
    if (vnode.shapeFlag & 128) {
      return vnode.suspense.next();
    }
    return hostNextSibling(vnode.anchor || vnode.el);
  };
  const render2 = (vnode, container, isSVG) => {
    if (vnode == null) {
      if (container._vnode) {
        unmount(container._vnode, null, null, true);
      }
    } else {
      patch(container._vnode || null, vnode, container, null, null, null, isSVG);
    }
    flushPreFlushCbs();
    flushPostFlushCbs();
    container._vnode = vnode;
  };
  const internals = {
    p: patch,
    um: unmount,
    m: move,
    r: remove2,
    mt: mountComponent,
    mc: mountChildren,
    pc: patchChildren,
    pbc: patchBlockChildren,
    n: getNextHostNode,
    o: options
  };
  let hydrate;
  let hydrateNode;
  if (createHydrationFns) {
    [hydrate, hydrateNode] = createHydrationFns(internals);
  }
  return {
    render: render2,
    hydrate,
    createApp: createAppAPI(render2, hydrate)
  };
}
function toggleRecurse({
  effect,
  update
}, allowed) {
  effect.allowRecurse = update.allowRecurse = allowed;
}
function traverseStaticChildren(n1, n2, shallow = false) {
  const ch1 = n1.children;
  const ch2 = n2.children;
  if (isArray$5(ch1) && isArray$5(ch2)) {
    for (let i2 = 0; i2 < ch1.length; i2++) {
      const c1 = ch1[i2];
      let c2 = ch2[i2];
      if (c2.shapeFlag & 1 && !c2.dynamicChildren) {
        if (c2.patchFlag <= 0 || c2.patchFlag === 32) {
          c2 = ch2[i2] = cloneIfMounted(ch2[i2]);
          c2.el = c1.el;
        }
        if (!shallow)
          traverseStaticChildren(c1, c2);
      }
      if (c2.type === Text) {
        c2.el = c1.el;
      }
    }
  }
}
function getSequence(arr) {
  const p2 = arr.slice();
  const result = [0];
  let i2, j2, u, v, c;
  const len2 = arr.length;
  for (i2 = 0; i2 < len2; i2++) {
    const arrI = arr[i2];
    if (arrI !== 0) {
      j2 = result[result.length - 1];
      if (arr[j2] < arrI) {
        p2[i2] = j2;
        result.push(i2);
        continue;
      }
      u = 0;
      v = result.length - 1;
      while (u < v) {
        c = u + v >> 1;
        if (arr[result[c]] < arrI) {
          u = c + 1;
        } else {
          v = c;
        }
      }
      if (arrI < arr[result[u]]) {
        if (u > 0) {
          p2[i2] = result[u - 1];
        }
        result[u] = i2;
      }
    }
  }
  u = result.length;
  v = result[u - 1];
  while (u-- > 0) {
    result[u] = v;
    v = p2[v];
  }
  return result;
}
const isTeleport = (type) => type.__isTeleport;
const isTeleportDisabled = (props) => props && (props.disabled || props.disabled === "");
const isTargetSVG = (target2) => typeof SVGElement !== "undefined" && target2 instanceof SVGElement;
const resolveTarget = (props, select) => {
  const targetSelector = props && props.to;
  if (isString$4(targetSelector)) {
    if (!select) {
      return null;
    } else {
      const target2 = select(targetSelector);
      return target2;
    }
  } else {
    return targetSelector;
  }
};
const TeleportImpl = {
  __isTeleport: true,
  process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals) {
    const {
      mc: mountChildren,
      pc: patchChildren,
      pbc: patchBlockChildren,
      o: {
        insert,
        querySelector: querySelector2,
        createText,
        createComment
      }
    } = internals;
    const disabled = isTeleportDisabled(n2.props);
    let {
      shapeFlag,
      children,
      dynamicChildren
    } = n2;
    if (n1 == null) {
      const placeholder = n2.el = createText("");
      const mainAnchor = n2.anchor = createText("");
      insert(placeholder, container, anchor);
      insert(mainAnchor, container, anchor);
      const target2 = n2.target = resolveTarget(n2.props, querySelector2);
      const targetAnchor = n2.targetAnchor = createText("");
      if (target2) {
        insert(targetAnchor, target2);
        isSVG = isSVG || isTargetSVG(target2);
      }
      const mount = (container2, anchor2) => {
        if (shapeFlag & 16) {
          mountChildren(children, container2, anchor2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
      };
      if (disabled) {
        mount(container, mainAnchor);
      } else if (target2) {
        mount(target2, targetAnchor);
      }
    } else {
      n2.el = n1.el;
      const mainAnchor = n2.anchor = n1.anchor;
      const target2 = n2.target = n1.target;
      const targetAnchor = n2.targetAnchor = n1.targetAnchor;
      const wasDisabled = isTeleportDisabled(n1.props);
      const currentContainer = wasDisabled ? container : target2;
      const currentAnchor = wasDisabled ? mainAnchor : targetAnchor;
      isSVG = isSVG || isTargetSVG(target2);
      if (dynamicChildren) {
        patchBlockChildren(n1.dynamicChildren, dynamicChildren, currentContainer, parentComponent, parentSuspense, isSVG, slotScopeIds);
        traverseStaticChildren(n1, n2, true);
      } else if (!optimized) {
        patchChildren(n1, n2, currentContainer, currentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, false);
      }
      if (disabled) {
        if (!wasDisabled) {
          moveTeleport(n2, container, mainAnchor, internals, 1);
        }
      } else {
        if ((n2.props && n2.props.to) !== (n1.props && n1.props.to)) {
          const nextTarget = n2.target = resolveTarget(n2.props, querySelector2);
          if (nextTarget) {
            moveTeleport(n2, nextTarget, null, internals, 0);
          }
        } else if (wasDisabled) {
          moveTeleport(n2, target2, targetAnchor, internals, 1);
        }
      }
    }
    updateCssVars(n2);
  },
  remove(vnode, parentComponent, parentSuspense, optimized, {
    um: unmount,
    o: {
      remove: hostRemove
    }
  }, doRemove) {
    const {
      shapeFlag,
      children,
      anchor,
      targetAnchor,
      target: target2,
      props
    } = vnode;
    if (target2) {
      hostRemove(targetAnchor);
    }
    if (doRemove || !isTeleportDisabled(props)) {
      hostRemove(anchor);
      if (shapeFlag & 16) {
        for (let i2 = 0; i2 < children.length; i2++) {
          const child = children[i2];
          unmount(child, parentComponent, parentSuspense, true, !!child.dynamicChildren);
        }
      }
    }
  },
  move: moveTeleport,
  hydrate: hydrateTeleport
};
function moveTeleport(vnode, container, parentAnchor, {
  o: {
    insert
  },
  m: move
}, moveType = 2) {
  if (moveType === 0) {
    insert(vnode.targetAnchor, container, parentAnchor);
  }
  const {
    el,
    anchor,
    shapeFlag,
    children,
    props
  } = vnode;
  const isReorder = moveType === 2;
  if (isReorder) {
    insert(el, container, parentAnchor);
  }
  if (!isReorder || isTeleportDisabled(props)) {
    if (shapeFlag & 16) {
      for (let i2 = 0; i2 < children.length; i2++) {
        move(children[i2], container, parentAnchor, 2);
      }
    }
  }
  if (isReorder) {
    insert(anchor, container, parentAnchor);
  }
}
function hydrateTeleport(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, {
  o: {
    nextSibling,
    parentNode,
    querySelector: querySelector2
  }
}, hydrateChildren) {
  const target2 = vnode.target = resolveTarget(vnode.props, querySelector2);
  if (target2) {
    const targetNode = target2._lpa || target2.firstChild;
    if (vnode.shapeFlag & 16) {
      if (isTeleportDisabled(vnode.props)) {
        vnode.anchor = hydrateChildren(nextSibling(node), vnode, parentNode(node), parentComponent, parentSuspense, slotScopeIds, optimized);
        vnode.targetAnchor = targetNode;
      } else {
        vnode.anchor = nextSibling(node);
        let targetAnchor = targetNode;
        while (targetAnchor) {
          targetAnchor = nextSibling(targetAnchor);
          if (targetAnchor && targetAnchor.nodeType === 8 && targetAnchor.data === "teleport anchor") {
            vnode.targetAnchor = targetAnchor;
            target2._lpa = vnode.targetAnchor && nextSibling(vnode.targetAnchor);
            break;
          }
        }
        hydrateChildren(targetNode, vnode, target2, parentComponent, parentSuspense, slotScopeIds, optimized);
      }
    }
    updateCssVars(vnode);
  }
  return vnode.anchor && nextSibling(vnode.anchor);
}
const Teleport = TeleportImpl;
function updateCssVars(vnode) {
  const ctx = vnode.ctx;
  if (ctx && ctx.ut) {
    let node = vnode.children[0].el;
    while (node !== vnode.targetAnchor) {
      if (node.nodeType === 1)
        node.setAttribute("data-v-owner", ctx.uid);
      node = node.nextSibling;
    }
    ctx.ut();
  }
}
const Fragment = Symbol.for("v-fgt");
const Text = Symbol.for("v-txt");
const Comment = Symbol.for("v-cmt");
const Static = Symbol.for("v-stc");
const blockStack = [];
let currentBlock = null;
function openBlock(disableTracking = false) {
  blockStack.push(currentBlock = disableTracking ? null : []);
}
function closeBlock() {
  blockStack.pop();
  currentBlock = blockStack[blockStack.length - 1] || null;
}
let isBlockTreeEnabled = 1;
function setBlockTracking(value) {
  isBlockTreeEnabled += value;
}
function setupBlock(vnode) {
  vnode.dynamicChildren = isBlockTreeEnabled > 0 ? currentBlock || EMPTY_ARR : null;
  closeBlock();
  if (isBlockTreeEnabled > 0 && currentBlock) {
    currentBlock.push(vnode);
  }
  return vnode;
}
function createElementBlock(type, props, children, patchFlag, dynamicProps, shapeFlag) {
  return setupBlock(createBaseVNode(
    type,
    props,
    children,
    patchFlag,
    dynamicProps,
    shapeFlag,
    true
    /* isBlock */
  ));
}
function createBlock(type, props, children, patchFlag, dynamicProps) {
  return setupBlock(createVNode(
    type,
    props,
    children,
    patchFlag,
    dynamicProps,
    true
    /* isBlock: prevent a block from tracking itself */
  ));
}
function isVNode$1(value) {
  return value ? value.__v_isVNode === true : false;
}
function isSameVNodeType(n1, n2) {
  return n1.type === n2.type && n1.key === n2.key;
}
const InternalObjectKey = `__vInternal`;
const normalizeKey = ({
  key
}) => key != null ? key : null;
const normalizeRef = ({
  ref: ref2,
  ref_key,
  ref_for
}) => {
  if (typeof ref2 === "number") {
    ref2 = "" + ref2;
  }
  return ref2 != null ? isString$4(ref2) || isRef(ref2) || isFunction$4(ref2) ? {
    i: currentRenderingInstance,
    r: ref2,
    k: ref_key,
    f: !!ref_for
  } : ref2 : null;
};
function createBaseVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type === Fragment ? 0 : 1, isBlockNode = false, needFullChildrenNormalization = false) {
  const vnode = {
    __v_isVNode: true,
    __v_skip: true,
    type,
    props,
    key: props && normalizeKey(props),
    ref: props && normalizeRef(props),
    scopeId: currentScopeId,
    slotScopeIds: null,
    children,
    component: null,
    suspense: null,
    ssContent: null,
    ssFallback: null,
    dirs: null,
    transition: null,
    el: null,
    anchor: null,
    target: null,
    targetAnchor: null,
    staticCount: 0,
    shapeFlag,
    patchFlag,
    dynamicProps,
    dynamicChildren: null,
    appContext: null,
    ctx: currentRenderingInstance
  };
  if (needFullChildrenNormalization) {
    normalizeChildren(vnode, children);
    if (shapeFlag & 128) {
      type.normalize(vnode);
    }
  } else if (children) {
    vnode.shapeFlag |= isString$4(children) ? 8 : 16;
  }
  if (isBlockTreeEnabled > 0 && // avoid a block node from tracking itself
  !isBlockNode && // has current parent block
  currentBlock && // presence of a patch flag indicates this node needs patching on updates.
  // component nodes also should always be patched, because even if the
  // component doesn't need to update, it needs to persist the instance on to
  // the next vnode so that it can be properly unmounted later.
  (vnode.patchFlag > 0 || shapeFlag & 6) && // the EVENTS flag is only for hydration and if it is the only flag, the
  // vnode should not be considered dynamic due to handler caching.
  vnode.patchFlag !== 32) {
    currentBlock.push(vnode);
  }
  return vnode;
}
const createVNode = _createVNode;
function _createVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
  if (!type || type === NULL_DYNAMIC_COMPONENT) {
    type = Comment;
  }
  if (isVNode$1(type)) {
    const cloned = cloneVNode(
      type,
      props,
      true
      /* mergeRef: true */
    );
    if (children) {
      normalizeChildren(cloned, children);
    }
    if (isBlockTreeEnabled > 0 && !isBlockNode && currentBlock) {
      if (cloned.shapeFlag & 6) {
        currentBlock[currentBlock.indexOf(type)] = cloned;
      } else {
        currentBlock.push(cloned);
      }
    }
    cloned.patchFlag |= -2;
    return cloned;
  }
  if (isClassComponent(type)) {
    type = type.__vccOpts;
  }
  if (props) {
    props = guardReactiveProps(props);
    let {
      class: klass,
      style: style2
    } = props;
    if (klass && !isString$4(klass)) {
      props.class = normalizeClass(klass);
    }
    if (isObject$6(style2)) {
      if (isProxy(style2) && !isArray$5(style2)) {
        style2 = extend$1({}, style2);
      }
      props.style = normalizeStyle$1(style2);
    }
  }
  const shapeFlag = isString$4(type) ? 1 : isSuspense(type) ? 128 : isTeleport(type) ? 64 : isObject$6(type) ? 4 : isFunction$4(type) ? 2 : 0;
  return createBaseVNode(type, props, children, patchFlag, dynamicProps, shapeFlag, isBlockNode, true);
}
function guardReactiveProps(props) {
  if (!props)
    return null;
  return isProxy(props) || InternalObjectKey in props ? extend$1({}, props) : props;
}
function cloneVNode(vnode, extraProps, mergeRef = false) {
  const {
    props,
    ref: ref2,
    patchFlag,
    children
  } = vnode;
  const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
  const cloned = {
    __v_isVNode: true,
    __v_skip: true,
    type: vnode.type,
    props: mergedProps,
    key: mergedProps && normalizeKey(mergedProps),
    ref: extraProps && extraProps.ref ? (
      // #2078 in the case of <component :is="vnode" ref="extra"/>
      // if the vnode itself already has a ref, cloneVNode will need to merge
      // the refs so the single vnode can be set on multiple refs
      mergeRef && ref2 ? isArray$5(ref2) ? ref2.concat(normalizeRef(extraProps)) : [ref2, normalizeRef(extraProps)] : normalizeRef(extraProps)
    ) : ref2,
    scopeId: vnode.scopeId,
    slotScopeIds: vnode.slotScopeIds,
    children,
    target: vnode.target,
    targetAnchor: vnode.targetAnchor,
    staticCount: vnode.staticCount,
    shapeFlag: vnode.shapeFlag,
    // if the vnode is cloned with extra props, we can no longer assume its
    // existing patch flag to be reliable and need to add the FULL_PROPS flag.
    // note: preserve flag for fragments since they use the flag for children
    // fast paths only.
    patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 ? 16 : patchFlag | 16 : patchFlag,
    dynamicProps: vnode.dynamicProps,
    dynamicChildren: vnode.dynamicChildren,
    appContext: vnode.appContext,
    dirs: vnode.dirs,
    transition: vnode.transition,
    // These should technically only be non-null on mounted VNodes. However,
    // they *should* be copied for kept-alive vnodes. So we just always copy
    // them since them being non-null during a mount doesn't affect the logic as
    // they will simply be overwritten.
    component: vnode.component,
    suspense: vnode.suspense,
    ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
    ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
    el: vnode.el,
    anchor: vnode.anchor,
    ctx: vnode.ctx,
    ce: vnode.ce
  };
  return cloned;
}
function createTextVNode(text = " ", flag = 0) {
  return createVNode(Text, null, text, flag);
}
function createCommentVNode(text = "", asBlock = false) {
  return asBlock ? (openBlock(), createBlock(Comment, null, text)) : createVNode(Comment, null, text);
}
function normalizeVNode(child) {
  if (child == null || typeof child === "boolean") {
    return createVNode(Comment);
  } else if (isArray$5(child)) {
    return createVNode(
      Fragment,
      null,
      // #3666, avoid reference pollution when reusing vnode
      child.slice()
    );
  } else if (typeof child === "object") {
    return cloneIfMounted(child);
  } else {
    return createVNode(Text, null, String(child));
  }
}
function cloneIfMounted(child) {
  return child.el === null && child.patchFlag !== -1 || child.memo ? child : cloneVNode(child);
}
function normalizeChildren(vnode, children) {
  let type = 0;
  const {
    shapeFlag
  } = vnode;
  if (children == null) {
    children = null;
  } else if (isArray$5(children)) {
    type = 16;
  } else if (typeof children === "object") {
    if (shapeFlag & (1 | 64)) {
      const slot = children.default;
      if (slot) {
        slot._c && (slot._d = false);
        normalizeChildren(vnode, slot());
        slot._c && (slot._d = true);
      }
      return;
    } else {
      type = 32;
      const slotFlag = children._;
      if (!slotFlag && !(InternalObjectKey in children)) {
        children._ctx = currentRenderingInstance;
      } else if (slotFlag === 3 && currentRenderingInstance) {
        if (currentRenderingInstance.slots._ === 1) {
          children._ = 1;
        } else {
          children._ = 2;
          vnode.patchFlag |= 1024;
        }
      }
    }
  } else if (isFunction$4(children)) {
    children = {
      default: children,
      _ctx: currentRenderingInstance
    };
    type = 32;
  } else {
    children = String(children);
    if (shapeFlag & 64) {
      type = 16;
      children = [createTextVNode(children)];
    } else {
      type = 8;
    }
  }
  vnode.children = children;
  vnode.shapeFlag |= type;
}
function mergeProps(...args) {
  const ret = {};
  for (let i2 = 0; i2 < args.length; i2++) {
    const toMerge = args[i2];
    for (const key in toMerge) {
      if (key === "class") {
        if (ret.class !== toMerge.class) {
          ret.class = normalizeClass([ret.class, toMerge.class]);
        }
      } else if (key === "style") {
        ret.style = normalizeStyle$1([ret.style, toMerge.style]);
      } else if (isOn(key)) {
        const existing = ret[key];
        const incoming = toMerge[key];
        if (incoming && existing !== incoming && !(isArray$5(existing) && existing.includes(incoming))) {
          ret[key] = existing ? [].concat(existing, incoming) : incoming;
        }
      } else if (key !== "") {
        ret[key] = toMerge[key];
      }
    }
  }
  return ret;
}
function invokeVNodeHook(hook, instance, vnode, prevVNode = null) {
  callWithAsyncErrorHandling(hook, instance, 7, [vnode, prevVNode]);
}
const emptyAppContext = createAppContext();
let uid = 0;
function createComponentInstance(vnode, parent, suspense) {
  const type = vnode.type;
  const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;
  const instance = {
    uid: uid++,
    vnode,
    type,
    parent,
    appContext,
    root: null,
    // to be immediately set
    next: null,
    subTree: null,
    // will be set synchronously right after creation
    effect: null,
    update: null,
    // will be set synchronously right after creation
    scope: new EffectScope(
      true
      /* detached */
    ),
    render: null,
    proxy: null,
    exposed: null,
    exposeProxy: null,
    withProxy: null,
    provides: parent ? parent.provides : Object.create(appContext.provides),
    accessCache: null,
    renderCache: [],
    // local resolved assets
    components: null,
    directives: null,
    // resolved props and emits options
    propsOptions: normalizePropsOptions(type, appContext),
    emitsOptions: normalizeEmitsOptions(type, appContext),
    // emit
    emit: null,
    // to be set immediately
    emitted: null,
    // props default value
    propsDefaults: EMPTY_OBJ$1,
    // inheritAttrs
    inheritAttrs: type.inheritAttrs,
    // state
    ctx: EMPTY_OBJ$1,
    data: EMPTY_OBJ$1,
    props: EMPTY_OBJ$1,
    attrs: EMPTY_OBJ$1,
    slots: EMPTY_OBJ$1,
    refs: EMPTY_OBJ$1,
    setupState: EMPTY_OBJ$1,
    setupContext: null,
    attrsProxy: null,
    slotsProxy: null,
    // suspense related
    suspense,
    suspenseId: suspense ? suspense.pendingId : 0,
    asyncDep: null,
    asyncResolved: false,
    // lifecycle hooks
    // not using enums here because it results in computed properties
    isMounted: false,
    isUnmounted: false,
    isDeactivated: false,
    bc: null,
    c: null,
    bm: null,
    m: null,
    bu: null,
    u: null,
    um: null,
    bum: null,
    da: null,
    a: null,
    rtg: null,
    rtc: null,
    ec: null,
    sp: null
  };
  {
    instance.ctx = {
      _: instance
    };
  }
  instance.root = parent ? parent.root : instance;
  instance.emit = emit.bind(null, instance);
  if (vnode.ce) {
    vnode.ce(instance);
  }
  return instance;
}
let currentInstance = null;
const getCurrentInstance = () => currentInstance || currentRenderingInstance;
let internalSetCurrentInstance;
let globalCurrentInstanceSetters;
let settersKey = "__VUE_INSTANCE_SETTERS__";
{
  if (!(globalCurrentInstanceSetters = getGlobalThis()[settersKey])) {
    globalCurrentInstanceSetters = getGlobalThis()[settersKey] = [];
  }
  globalCurrentInstanceSetters.push((i2) => currentInstance = i2);
  internalSetCurrentInstance = (instance) => {
    if (globalCurrentInstanceSetters.length > 1) {
      globalCurrentInstanceSetters.forEach((s) => s(instance));
    } else {
      globalCurrentInstanceSetters[0](instance);
    }
  };
}
const setCurrentInstance = (instance) => {
  internalSetCurrentInstance(instance);
  instance.scope.on();
};
const unsetCurrentInstance = () => {
  currentInstance && currentInstance.scope.off();
  internalSetCurrentInstance(null);
};
function isStatefulComponent(instance) {
  return instance.vnode.shapeFlag & 4;
}
let isInSSRComponentSetup = false;
function setupComponent(instance, isSSR = false) {
  isInSSRComponentSetup = isSSR;
  const {
    props,
    children
  } = instance.vnode;
  const isStateful = isStatefulComponent(instance);
  initProps$1(instance, props, isStateful, isSSR);
  initSlots(instance, children);
  const setupResult = isStateful ? setupStatefulComponent(instance, isSSR) : void 0;
  isInSSRComponentSetup = false;
  return setupResult;
}
function setupStatefulComponent(instance, isSSR) {
  const Component = instance.type;
  instance.accessCache = /* @__PURE__ */ Object.create(null);
  instance.proxy = markRaw(new Proxy(instance.ctx, PublicInstanceProxyHandlers));
  const {
    setup
  } = Component;
  if (setup) {
    const setupContext = instance.setupContext = setup.length > 1 ? createSetupContext(instance) : null;
    setCurrentInstance(instance);
    pauseTracking();
    const setupResult = callWithErrorHandling(setup, instance, 0, [instance.props, setupContext]);
    resetTracking();
    unsetCurrentInstance();
    if (isPromise$1(setupResult)) {
      setupResult.then(unsetCurrentInstance, unsetCurrentInstance);
      if (isSSR) {
        return setupResult.then((resolvedResult) => {
          handleSetupResult(instance, resolvedResult, isSSR);
        }).catch((e2) => {
          handleError(e2, instance, 0);
        });
      } else {
        instance.asyncDep = setupResult;
      }
    } else {
      handleSetupResult(instance, setupResult, isSSR);
    }
  } else {
    finishComponentSetup(instance, isSSR);
  }
}
function handleSetupResult(instance, setupResult, isSSR) {
  if (isFunction$4(setupResult)) {
    if (instance.type.__ssrInlineRender) {
      instance.ssrRender = setupResult;
    } else {
      instance.render = setupResult;
    }
  } else if (isObject$6(setupResult)) {
    instance.setupState = proxyRefs(setupResult);
  } else
    ;
  finishComponentSetup(instance, isSSR);
}
let compile;
function finishComponentSetup(instance, isSSR, skipOptions) {
  const Component = instance.type;
  if (!instance.render) {
    if (!isSSR && compile && !Component.render) {
      const template = Component.template || resolveMergedOptions(instance).template;
      if (template) {
        const {
          isCustomElement,
          compilerOptions
        } = instance.appContext.config;
        const {
          delimiters,
          compilerOptions: componentCompilerOptions
        } = Component;
        const finalCompilerOptions = extend$1(extend$1({
          isCustomElement,
          delimiters
        }, compilerOptions), componentCompilerOptions);
        Component.render = compile(template, finalCompilerOptions);
      }
    }
    instance.render = Component.render || NOOP$1;
  }
  {
    setCurrentInstance(instance);
    pauseTracking();
    applyOptions(instance);
    resetTracking();
    unsetCurrentInstance();
  }
}
function getAttrsProxy(instance) {
  return instance.attrsProxy || (instance.attrsProxy = new Proxy(instance.attrs, {
    get(target2, key) {
      track(instance, "get", "$attrs");
      return target2[key];
    }
  }));
}
function createSetupContext(instance) {
  const expose = (exposed) => {
    instance.exposed = exposed || {};
  };
  {
    return {
      get attrs() {
        return getAttrsProxy(instance);
      },
      slots: instance.slots,
      emit: instance.emit,
      expose
    };
  }
}
function getExposeProxy(instance) {
  if (instance.exposed) {
    return instance.exposeProxy || (instance.exposeProxy = new Proxy(proxyRefs(markRaw(instance.exposed)), {
      get(target2, key) {
        if (key in target2) {
          return target2[key];
        } else if (key in publicPropertiesMap) {
          return publicPropertiesMap[key](instance);
        }
      },
      has(target2, key) {
        return key in target2 || key in publicPropertiesMap;
      }
    }));
  }
}
function getComponentName(Component, includeInferred = true) {
  return isFunction$4(Component) ? Component.displayName || Component.name : Component.name || includeInferred && Component.__name;
}
function isClassComponent(value) {
  return isFunction$4(value) && "__vccOpts" in value;
}
const computed = (getterOrOptions, debugOptions) => {
  return computed$1(getterOrOptions, debugOptions, isInSSRComponentSetup);
};
function h(type, propsOrChildren, children) {
  const l = arguments.length;
  if (l === 2) {
    if (isObject$6(propsOrChildren) && !isArray$5(propsOrChildren)) {
      if (isVNode$1(propsOrChildren)) {
        return createVNode(type, null, [propsOrChildren]);
      }
      return createVNode(type, propsOrChildren);
    } else {
      return createVNode(type, null, propsOrChildren);
    }
  } else {
    if (l > 3) {
      children = Array.prototype.slice.call(arguments, 2);
    } else if (l === 3 && isVNode$1(children)) {
      children = [children];
    }
    return createVNode(type, propsOrChildren, children);
  }
}
const ssrContextKey = Symbol.for("v-scx");
const useSSRContext = () => {
  {
    const ctx = inject(ssrContextKey);
    return ctx;
  }
};
const version = "3.3.4";
const svgNS = "http://www.w3.org/2000/svg";
const doc = typeof document !== "undefined" ? document : null;
const templateContainer = doc && /* @__PURE__ */ doc.createElement("template");
const nodeOps = {
  insert: (child, parent, anchor) => {
    parent.insertBefore(child, anchor || null);
  },
  remove: (child) => {
    const parent = child.parentNode;
    if (parent) {
      parent.removeChild(child);
    }
  },
  createElement: (tag, isSVG, is, props) => {
    const el = isSVG ? doc.createElementNS(svgNS, tag) : doc.createElement(tag, is ? {
      is
    } : void 0);
    if (tag === "select" && props && props.multiple != null) {
      el.setAttribute("multiple", props.multiple);
    }
    return el;
  },
  createText: (text) => doc.createTextNode(text),
  createComment: (text) => doc.createComment(text),
  setText: (node, text) => {
    node.nodeValue = text;
  },
  setElementText: (el, text) => {
    el.textContent = text;
  },
  parentNode: (node) => node.parentNode,
  nextSibling: (node) => node.nextSibling,
  querySelector: (selector) => doc.querySelector(selector),
  setScopeId(el, id) {
    el.setAttribute(id, "");
  },
  // __UNSAFE__
  // Reason: innerHTML.
  // Static content here can only come from compiled templates.
  // As long as the user only uses trusted templates, this is safe.
  insertStaticContent(content, parent, anchor, isSVG, start2, end2) {
    const before = anchor ? anchor.previousSibling : parent.lastChild;
    if (start2 && (start2 === end2 || start2.nextSibling)) {
      while (true) {
        parent.insertBefore(start2.cloneNode(true), anchor);
        if (start2 === end2 || !(start2 = start2.nextSibling))
          break;
      }
    } else {
      templateContainer.innerHTML = isSVG ? `<svg>${content}</svg>` : content;
      const template = templateContainer.content;
      if (isSVG) {
        const wrapper = template.firstChild;
        while (wrapper.firstChild) {
          template.appendChild(wrapper.firstChild);
        }
        template.removeChild(wrapper);
      }
      parent.insertBefore(template, anchor);
    }
    return [
      // first
      before ? before.nextSibling : parent.firstChild,
      // last
      anchor ? anchor.previousSibling : parent.lastChild
    ];
  }
};
function patchClass(el, value, isSVG) {
  const transitionClasses = el._vtc;
  if (transitionClasses) {
    value = (value ? [value, ...transitionClasses] : [...transitionClasses]).join(" ");
  }
  if (value == null) {
    el.removeAttribute("class");
  } else if (isSVG) {
    el.setAttribute("class", value);
  } else {
    el.className = value;
  }
}
function patchStyle(el, prev, next) {
  const style2 = el.style;
  const isCssString = isString$4(next);
  if (next && !isCssString) {
    if (prev && !isString$4(prev)) {
      for (const key in prev) {
        if (next[key] == null) {
          setStyle(style2, key, "");
        }
      }
    }
    for (const key in next) {
      setStyle(style2, key, next[key]);
    }
  } else {
    const currentDisplay = style2.display;
    if (isCssString) {
      if (prev !== next) {
        style2.cssText = next;
      }
    } else if (prev) {
      el.removeAttribute("style");
    }
    if ("_vod" in el) {
      style2.display = currentDisplay;
    }
  }
}
const importantRE = /\s*!important$/;
function setStyle(style2, name, val) {
  if (isArray$5(val)) {
    val.forEach((v) => setStyle(style2, name, v));
  } else {
    if (val == null)
      val = "";
    if (name.startsWith("--")) {
      style2.setProperty(name, val);
    } else {
      const prefixed = autoPrefix(style2, name);
      if (importantRE.test(val)) {
        style2.setProperty(hyphenate(prefixed), val.replace(importantRE, ""), "important");
      } else {
        style2[prefixed] = val;
      }
    }
  }
}
const prefixes = ["Webkit", "Moz", "ms"];
const prefixCache = {};
function autoPrefix(style2, rawName) {
  const cached = prefixCache[rawName];
  if (cached) {
    return cached;
  }
  let name = camelize(rawName);
  if (name !== "filter" && name in style2) {
    return prefixCache[rawName] = name;
  }
  name = capitalize$1(name);
  for (let i2 = 0; i2 < prefixes.length; i2++) {
    const prefixed = prefixes[i2] + name;
    if (prefixed in style2) {
      return prefixCache[rawName] = prefixed;
    }
  }
  return rawName;
}
const xlinkNS = "http://www.w3.org/1999/xlink";
function patchAttr(el, key, value, isSVG, instance) {
  if (isSVG && key.startsWith("xlink:")) {
    if (value == null) {
      el.removeAttributeNS(xlinkNS, key.slice(6, key.length));
    } else {
      el.setAttributeNS(xlinkNS, key, value);
    }
  } else {
    const isBoolean2 = isSpecialBooleanAttr(key);
    if (value == null || isBoolean2 && !includeBooleanAttr(value)) {
      el.removeAttribute(key);
    } else {
      el.setAttribute(key, isBoolean2 ? "" : value);
    }
  }
}
function patchDOMProp(el, key, value, prevChildren, parentComponent, parentSuspense, unmountChildren) {
  if (key === "innerHTML" || key === "textContent") {
    if (prevChildren) {
      unmountChildren(prevChildren, parentComponent, parentSuspense);
    }
    el[key] = value == null ? "" : value;
    return;
  }
  const tag = el.tagName;
  if (key === "value" && tag !== "PROGRESS" && // custom elements may use _value internally
  !tag.includes("-")) {
    el._value = value;
    const oldValue = tag === "OPTION" ? el.getAttribute("value") : el.value;
    const newValue = value == null ? "" : value;
    if (oldValue !== newValue) {
      el.value = newValue;
    }
    if (value == null) {
      el.removeAttribute(key);
    }
    return;
  }
  let needRemove = false;
  if (value === "" || value == null) {
    const type = typeof el[key];
    if (type === "boolean") {
      value = includeBooleanAttr(value);
    } else if (value == null && type === "string") {
      value = "";
      needRemove = true;
    } else if (type === "number") {
      value = 0;
      needRemove = true;
    }
  }
  try {
    el[key] = value;
  } catch (e2) {
  }
  needRemove && el.removeAttribute(key);
}
function addEventListener$1(el, event, handler, options) {
  el.addEventListener(event, handler, options);
}
function removeEventListener$1(el, event, handler, options) {
  el.removeEventListener(event, handler, options);
}
function patchEvent(el, rawName, prevValue, nextValue, instance = null) {
  const invokers = el._vei || (el._vei = {});
  const existingInvoker = invokers[rawName];
  if (nextValue && existingInvoker) {
    existingInvoker.value = nextValue;
  } else {
    const [name, options] = parseName(rawName);
    if (nextValue) {
      const invoker = invokers[rawName] = createInvoker(nextValue, instance);
      addEventListener$1(el, name, invoker, options);
    } else if (existingInvoker) {
      removeEventListener$1(el, name, existingInvoker, options);
      invokers[rawName] = void 0;
    }
  }
}
const optionsModifierRE = /(?:Once|Passive|Capture)$/;
function parseName(name) {
  let options;
  if (optionsModifierRE.test(name)) {
    options = {};
    let m2;
    while (m2 = name.match(optionsModifierRE)) {
      name = name.slice(0, name.length - m2[0].length);
      options[m2[0].toLowerCase()] = true;
    }
  }
  const event = name[2] === ":" ? name.slice(3) : hyphenate(name.slice(2));
  return [event, options];
}
let cachedNow = 0;
const p = /* @__PURE__ */ Promise.resolve();
const getNow = () => cachedNow || (p.then(() => cachedNow = 0), cachedNow = Date.now());
function createInvoker(initialValue, instance) {
  const invoker = (e2) => {
    if (!e2._vts) {
      e2._vts = Date.now();
    } else if (e2._vts <= invoker.attached) {
      return;
    }
    callWithAsyncErrorHandling(patchStopImmediatePropagation(e2, invoker.value), instance, 5, [e2]);
  };
  invoker.value = initialValue;
  invoker.attached = getNow();
  return invoker;
}
function patchStopImmediatePropagation(e2, value) {
  if (isArray$5(value)) {
    const originalStop = e2.stopImmediatePropagation;
    e2.stopImmediatePropagation = () => {
      originalStop.call(e2);
      e2._stopped = true;
    };
    return value.map((fn) => (e22) => !e22._stopped && fn && fn(e22));
  } else {
    return value;
  }
}
const nativeOnRE = /^on[a-z]/;
const patchProp = (el, key, prevValue, nextValue, isSVG = false, prevChildren, parentComponent, parentSuspense, unmountChildren) => {
  if (key === "class") {
    patchClass(el, nextValue, isSVG);
  } else if (key === "style") {
    patchStyle(el, prevValue, nextValue);
  } else if (isOn(key)) {
    if (!isModelListener(key)) {
      patchEvent(el, key, prevValue, nextValue, parentComponent);
    }
  } else if (key[0] === "." ? (key = key.slice(1), true) : key[0] === "^" ? (key = key.slice(1), false) : shouldSetAsProp(el, key, nextValue, isSVG)) {
    patchDOMProp(el, key, nextValue, prevChildren, parentComponent, parentSuspense, unmountChildren);
  } else {
    if (key === "true-value") {
      el._trueValue = nextValue;
    } else if (key === "false-value") {
      el._falseValue = nextValue;
    }
    patchAttr(el, key, nextValue, isSVG);
  }
};
function shouldSetAsProp(el, key, value, isSVG) {
  if (isSVG) {
    if (key === "innerHTML" || key === "textContent") {
      return true;
    }
    if (key in el && nativeOnRE.test(key) && isFunction$4(value)) {
      return true;
    }
    return false;
  }
  if (key === "spellcheck" || key === "draggable" || key === "translate") {
    return false;
  }
  if (key === "form") {
    return false;
  }
  if (key === "list" && el.tagName === "INPUT") {
    return false;
  }
  if (key === "type" && el.tagName === "TEXTAREA") {
    return false;
  }
  if (nativeOnRE.test(key) && isString$4(value)) {
    return false;
  }
  return key in el;
}
const TRANSITION = "transition";
const ANIMATION = "animation";
const Transition = (props, {
  slots
}) => h(BaseTransition, resolveTransitionProps(props), slots);
Transition.displayName = "Transition";
const DOMTransitionPropsValidators = {
  name: String,
  type: String,
  css: {
    type: Boolean,
    default: true
  },
  duration: [String, Number, Object],
  enterFromClass: String,
  enterActiveClass: String,
  enterToClass: String,
  appearFromClass: String,
  appearActiveClass: String,
  appearToClass: String,
  leaveFromClass: String,
  leaveActiveClass: String,
  leaveToClass: String
};
const TransitionPropsValidators = Transition.props = /* @__PURE__ */ extend$1({}, BaseTransitionPropsValidators, DOMTransitionPropsValidators);
const callHook = (hook, args = []) => {
  if (isArray$5(hook)) {
    hook.forEach((h2) => h2(...args));
  } else if (hook) {
    hook(...args);
  }
};
const hasExplicitCallback = (hook) => {
  return hook ? isArray$5(hook) ? hook.some((h2) => h2.length > 1) : hook.length > 1 : false;
};
function resolveTransitionProps(rawProps) {
  const baseProps = {};
  for (const key in rawProps) {
    if (!(key in DOMTransitionPropsValidators)) {
      baseProps[key] = rawProps[key];
    }
  }
  if (rawProps.css === false) {
    return baseProps;
  }
  const {
    name = "v",
    type,
    duration,
    enterFromClass = `${name}-enter-from`,
    enterActiveClass = `${name}-enter-active`,
    enterToClass = `${name}-enter-to`,
    appearFromClass = enterFromClass,
    appearActiveClass = enterActiveClass,
    appearToClass = enterToClass,
    leaveFromClass = `${name}-leave-from`,
    leaveActiveClass = `${name}-leave-active`,
    leaveToClass = `${name}-leave-to`
  } = rawProps;
  const durations = normalizeDuration(duration);
  const enterDuration = durations && durations[0];
  const leaveDuration = durations && durations[1];
  const {
    onBeforeEnter,
    onEnter,
    onEnterCancelled,
    onLeave: onLeave2,
    onLeaveCancelled,
    onBeforeAppear = onBeforeEnter,
    onAppear = onEnter,
    onAppearCancelled = onEnterCancelled
  } = baseProps;
  const finishEnter = (el, isAppear, done) => {
    removeTransitionClass(el, isAppear ? appearToClass : enterToClass);
    removeTransitionClass(el, isAppear ? appearActiveClass : enterActiveClass);
    done && done();
  };
  const finishLeave = (el, done) => {
    el._isLeaving = false;
    removeTransitionClass(el, leaveFromClass);
    removeTransitionClass(el, leaveToClass);
    removeTransitionClass(el, leaveActiveClass);
    done && done();
  };
  const makeEnterHook = (isAppear) => {
    return (el, done) => {
      const hook = isAppear ? onAppear : onEnter;
      const resolve2 = () => finishEnter(el, isAppear, done);
      callHook(hook, [el, resolve2]);
      nextFrame(() => {
        removeTransitionClass(el, isAppear ? appearFromClass : enterFromClass);
        addTransitionClass(el, isAppear ? appearToClass : enterToClass);
        if (!hasExplicitCallback(hook)) {
          whenTransitionEnds(el, type, enterDuration, resolve2);
        }
      });
    };
  };
  return extend$1(baseProps, {
    onBeforeEnter(el) {
      callHook(onBeforeEnter, [el]);
      addTransitionClass(el, enterFromClass);
      addTransitionClass(el, enterActiveClass);
    },
    onBeforeAppear(el) {
      callHook(onBeforeAppear, [el]);
      addTransitionClass(el, appearFromClass);
      addTransitionClass(el, appearActiveClass);
    },
    onEnter: makeEnterHook(false),
    onAppear: makeEnterHook(true),
    onLeave(el, done) {
      el._isLeaving = true;
      const resolve2 = () => finishLeave(el, done);
      addTransitionClass(el, leaveFromClass);
      forceReflow();
      addTransitionClass(el, leaveActiveClass);
      nextFrame(() => {
        if (!el._isLeaving) {
          return;
        }
        removeTransitionClass(el, leaveFromClass);
        addTransitionClass(el, leaveToClass);
        if (!hasExplicitCallback(onLeave2)) {
          whenTransitionEnds(el, type, leaveDuration, resolve2);
        }
      });
      callHook(onLeave2, [el, resolve2]);
    },
    onEnterCancelled(el) {
      finishEnter(el, false);
      callHook(onEnterCancelled, [el]);
    },
    onAppearCancelled(el) {
      finishEnter(el, true);
      callHook(onAppearCancelled, [el]);
    },
    onLeaveCancelled(el) {
      finishLeave(el);
      callHook(onLeaveCancelled, [el]);
    }
  });
}
function normalizeDuration(duration) {
  if (duration == null) {
    return null;
  } else if (isObject$6(duration)) {
    return [NumberOf(duration.enter), NumberOf(duration.leave)];
  } else {
    const n2 = NumberOf(duration);
    return [n2, n2];
  }
}
function NumberOf(val) {
  const res = toNumber(val);
  return res;
}
function addTransitionClass(el, cls) {
  cls.split(/\s+/).forEach((c) => c && el.classList.add(c));
  (el._vtc || (el._vtc = /* @__PURE__ */ new Set())).add(cls);
}
function removeTransitionClass(el, cls) {
  cls.split(/\s+/).forEach((c) => c && el.classList.remove(c));
  const {
    _vtc
  } = el;
  if (_vtc) {
    _vtc.delete(cls);
    if (!_vtc.size) {
      el._vtc = void 0;
    }
  }
}
function nextFrame(cb) {
  requestAnimationFrame(() => {
    requestAnimationFrame(cb);
  });
}
let endId = 0;
function whenTransitionEnds(el, expectedType, explicitTimeout, resolve2) {
  const id = el._endId = ++endId;
  const resolveIfNotStale = () => {
    if (id === el._endId) {
      resolve2();
    }
  };
  if (explicitTimeout) {
    return setTimeout(resolveIfNotStale, explicitTimeout);
  }
  const {
    type,
    timeout,
    propCount
  } = getTransitionInfo(el, expectedType);
  if (!type) {
    return resolve2();
  }
  const endEvent = type + "end";
  let ended = 0;
  const end2 = () => {
    el.removeEventListener(endEvent, onEnd);
    resolveIfNotStale();
  };
  const onEnd = (e2) => {
    if (e2.target === el && ++ended >= propCount) {
      end2();
    }
  };
  setTimeout(() => {
    if (ended < propCount) {
      end2();
    }
  }, timeout + 1);
  el.addEventListener(endEvent, onEnd);
}
function getTransitionInfo(el, expectedType) {
  const styles = window.getComputedStyle(el);
  const getStyleProperties = (key) => (styles[key] || "").split(", ");
  const transitionDelays = getStyleProperties(`${TRANSITION}Delay`);
  const transitionDurations = getStyleProperties(`${TRANSITION}Duration`);
  const transitionTimeout = getTimeout(transitionDelays, transitionDurations);
  const animationDelays = getStyleProperties(`${ANIMATION}Delay`);
  const animationDurations = getStyleProperties(`${ANIMATION}Duration`);
  const animationTimeout = getTimeout(animationDelays, animationDurations);
  let type = null;
  let timeout = 0;
  let propCount = 0;
  if (expectedType === TRANSITION) {
    if (transitionTimeout > 0) {
      type = TRANSITION;
      timeout = transitionTimeout;
      propCount = transitionDurations.length;
    }
  } else if (expectedType === ANIMATION) {
    if (animationTimeout > 0) {
      type = ANIMATION;
      timeout = animationTimeout;
      propCount = animationDurations.length;
    }
  } else {
    timeout = Math.max(transitionTimeout, animationTimeout);
    type = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION : ANIMATION : null;
    propCount = type ? type === TRANSITION ? transitionDurations.length : animationDurations.length : 0;
  }
  const hasTransform = type === TRANSITION && /\b(transform|all)(,|$)/.test(getStyleProperties(`${TRANSITION}Property`).toString());
  return {
    type,
    timeout,
    propCount,
    hasTransform
  };
}
function getTimeout(delays, durations) {
  while (delays.length < durations.length) {
    delays = delays.concat(delays);
  }
  return Math.max(...durations.map((d, i2) => toMs(d) + toMs(delays[i2])));
}
function toMs(s) {
  return Number(s.slice(0, -1).replace(",", ".")) * 1e3;
}
function forceReflow() {
  return document.body.offsetHeight;
}
const positionMap = /* @__PURE__ */ new WeakMap();
const newPositionMap = /* @__PURE__ */ new WeakMap();
const TransitionGroupImpl = {
  name: "TransitionGroup",
  props: /* @__PURE__ */ extend$1({}, TransitionPropsValidators, {
    tag: String,
    moveClass: String
  }),
  setup(props, {
    slots
  }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    let prevChildren;
    let children;
    onUpdated(() => {
      if (!prevChildren.length) {
        return;
      }
      const moveClass = props.moveClass || `${props.name || "v"}-move`;
      if (!hasCSSTransform(prevChildren[0].el, instance.vnode.el, moveClass)) {
        return;
      }
      prevChildren.forEach(callPendingCbs);
      prevChildren.forEach(recordPosition);
      const movedChildren = prevChildren.filter(applyTranslation);
      forceReflow();
      movedChildren.forEach((c) => {
        const el = c.el;
        const style2 = el.style;
        addTransitionClass(el, moveClass);
        style2.transform = style2.webkitTransform = style2.transitionDuration = "";
        const cb = el._moveCb = (e2) => {
          if (e2 && e2.target !== el) {
            return;
          }
          if (!e2 || /transform$/.test(e2.propertyName)) {
            el.removeEventListener("transitionend", cb);
            el._moveCb = null;
            removeTransitionClass(el, moveClass);
          }
        };
        el.addEventListener("transitionend", cb);
      });
    });
    return () => {
      const rawProps = toRaw(props);
      const cssTransitionProps = resolveTransitionProps(rawProps);
      let tag = rawProps.tag || Fragment;
      prevChildren = children;
      children = slots.default ? getTransitionRawChildren(slots.default()) : [];
      for (let i2 = 0; i2 < children.length; i2++) {
        const child = children[i2];
        if (child.key != null) {
          setTransitionHooks(child, resolveTransitionHooks(child, cssTransitionProps, state, instance));
        }
      }
      if (prevChildren) {
        for (let i2 = 0; i2 < prevChildren.length; i2++) {
          const child = prevChildren[i2];
          setTransitionHooks(child, resolveTransitionHooks(child, cssTransitionProps, state, instance));
          positionMap.set(child, child.el.getBoundingClientRect());
        }
      }
      return createVNode(tag, null, children);
    };
  }
};
const removeMode = (props) => delete props.mode;
/* @__PURE__ */ removeMode(TransitionGroupImpl.props);
const TransitionGroup = TransitionGroupImpl;
function callPendingCbs(c) {
  const el = c.el;
  if (el._moveCb) {
    el._moveCb();
  }
  if (el._enterCb) {
    el._enterCb();
  }
}
function recordPosition(c) {
  newPositionMap.set(c, c.el.getBoundingClientRect());
}
function applyTranslation(c) {
  const oldPos = positionMap.get(c);
  const newPos = newPositionMap.get(c);
  const dx = oldPos.left - newPos.left;
  const dy = oldPos.top - newPos.top;
  if (dx || dy) {
    const s = c.el.style;
    s.transform = s.webkitTransform = `translate(${dx}px,${dy}px)`;
    s.transitionDuration = "0s";
    return c;
  }
}
function hasCSSTransform(el, root, moveClass) {
  const clone2 = el.cloneNode();
  if (el._vtc) {
    el._vtc.forEach((cls) => {
      cls.split(/\s+/).forEach((c) => c && clone2.classList.remove(c));
    });
  }
  moveClass.split(/\s+/).forEach((c) => c && clone2.classList.add(c));
  clone2.style.display = "none";
  const container = root.nodeType === 1 ? root : root.parentNode;
  container.appendChild(clone2);
  const {
    hasTransform
  } = getTransitionInfo(clone2);
  container.removeChild(clone2);
  return hasTransform;
}
const systemModifiers = ["ctrl", "shift", "alt", "meta"];
const modifierGuards = {
  stop: (e2) => e2.stopPropagation(),
  prevent: (e2) => e2.preventDefault(),
  self: (e2) => e2.target !== e2.currentTarget,
  ctrl: (e2) => !e2.ctrlKey,
  shift: (e2) => !e2.shiftKey,
  alt: (e2) => !e2.altKey,
  meta: (e2) => !e2.metaKey,
  left: (e2) => "button" in e2 && e2.button !== 0,
  middle: (e2) => "button" in e2 && e2.button !== 1,
  right: (e2) => "button" in e2 && e2.button !== 2,
  exact: (e2, modifiers) => systemModifiers.some((m2) => e2[`${m2}Key`] && !modifiers.includes(m2))
};
const withModifiers = (fn, modifiers) => {
  return (event, ...args) => {
    for (let i2 = 0; i2 < modifiers.length; i2++) {
      const guard = modifierGuards[modifiers[i2]];
      if (guard && guard(event, modifiers))
        return;
    }
    return fn(event, ...args);
  };
};
const vShow = {
  beforeMount(el, {
    value
  }, {
    transition
  }) {
    el._vod = el.style.display === "none" ? "" : el.style.display;
    if (transition && value) {
      transition.beforeEnter(el);
    } else {
      setDisplay(el, value);
    }
  },
  mounted(el, {
    value
  }, {
    transition
  }) {
    if (transition && value) {
      transition.enter(el);
    }
  },
  updated(el, {
    value,
    oldValue
  }, {
    transition
  }) {
    if (!value === !oldValue)
      return;
    if (transition) {
      if (value) {
        transition.beforeEnter(el);
        setDisplay(el, true);
        transition.enter(el);
      } else {
        transition.leave(el, () => {
          setDisplay(el, false);
        });
      }
    } else {
      setDisplay(el, value);
    }
  },
  beforeUnmount(el, {
    value
  }) {
    setDisplay(el, value);
  }
};
function setDisplay(el, value) {
  el.style.display = value ? el._vod : "none";
}
const rendererOptions = /* @__PURE__ */ extend$1({
  patchProp
}, nodeOps);
let renderer;
function ensureRenderer() {
  return renderer || (renderer = createRenderer(rendererOptions));
}
const render$1 = (...args) => {
  ensureRenderer().render(...args);
};
const createApp = (...args) => {
  const app = ensureRenderer().createApp(...args);
  const {
    mount
  } = app;
  app.mount = (containerOrSelector) => {
    const container = normalizeContainer(containerOrSelector);
    if (!container)
      return;
    const component = app._component;
    if (!isFunction$4(component) && !component.render && !component.template) {
      component.template = container.innerHTML;
    }
    container.innerHTML = "";
    const proxy = mount(container, false, container instanceof SVGElement);
    if (container instanceof Element) {
      container.removeAttribute("v-cloak");
      container.setAttribute("data-v-app", "");
    }
    return proxy;
  };
  return app;
};
function normalizeContainer(container) {
  if (isString$4(container)) {
    const res = document.querySelector(container);
    return res;
  }
  return container;
}
const style$1 = "";
const opt$1 = Object.prototype.toString;
function isArray$4(obj) {
  return opt$1.call(obj) === "[object Array]";
}
function isNull(obj) {
  return opt$1.call(obj) === "[object Null]";
}
function isBoolean$1(obj) {
  return opt$1.call(obj) === "[object Boolean]";
}
function isObject$5(obj) {
  return opt$1.call(obj) === "[object Object]";
}
const isPromise = (obj) => {
  return opt$1.call(obj) === "[object Promise]";
};
function isString$3(obj) {
  return opt$1.call(obj) === "[object String]";
}
function isNumber$2(obj) {
  return opt$1.call(obj) === "[object Number]" && obj === obj;
}
function isUndefined(obj) {
  return obj === void 0;
}
function isFunction$3(obj) {
  return typeof obj === "function";
}
function isEmptyObject$1(obj) {
  return isObject$5(obj) && Object.keys(obj).length === 0;
}
const isComponentInstance = (value) => {
  return (value == null ? void 0 : value.$) !== void 0;
};
const configProviderInjectionKey = Symbol("ArcoConfigProvider");
const calendarLang$1 = {
  formatYear: "YYYY 年",
  formatMonth: "YYYY 年 MM 月",
  today: "今天",
  view: {
    month: "月",
    year: "年",
    week: "周",
    day: "日"
  },
  month: {
    long: {
      January: "一月",
      February: "二月",
      March: "三月",
      April: "四月",
      May: "五月",
      June: "六月",
      July: "七月",
      August: "八月",
      September: "九月",
      October: "十月",
      November: "十一月",
      December: "十二月"
    },
    short: {
      January: "一月",
      February: "二月",
      March: "三月",
      April: "四月",
      May: "五月",
      June: "六月",
      July: "七月",
      August: "八月",
      September: "九月",
      October: "十月",
      November: "十一月",
      December: "十二月"
    }
  },
  week: {
    long: {
      self: "周",
      monday: "周一",
      tuesday: "周二",
      wednesday: "周三",
      thursday: "周四",
      friday: "周五",
      saturday: "周六",
      sunday: "周日"
    },
    short: {
      self: "周",
      monday: "一",
      tuesday: "二",
      wednesday: "三",
      thursday: "四",
      friday: "五",
      saturday: "六",
      sunday: "日"
    }
  }
};
const lang$1 = {
  locale: "zh-CN",
  empty: {
    description: "暂无数据"
  },
  drawer: {
    okText: "确定",
    cancelText: "取消"
  },
  popconfirm: {
    okText: "确定",
    cancelText: "取消"
  },
  modal: {
    okText: "确定",
    cancelText: "取消"
  },
  pagination: {
    goto: "前往",
    page: "页",
    countPerPage: "条/页",
    total: "共 {0} 条"
  },
  table: {
    okText: "确定",
    resetText: "重置"
  },
  upload: {
    start: "开始",
    cancel: "取消",
    delete: "删除",
    retry: "点击重试",
    buttonText: "点击上传",
    preview: "预览",
    drag: "点击或拖拽文件到此处上传",
    dragHover: "释放文件并开始上传",
    error: "上传失败"
  },
  calendar: calendarLang$1,
  datePicker: {
    view: calendarLang$1.view,
    month: calendarLang$1.month,
    week: calendarLang$1.week,
    placeholder: {
      date: "请选择日期",
      week: "请选择周",
      month: "请选择月份",
      year: "请选择年份",
      quarter: "请选择季度",
      time: "请选择时间"
    },
    rangePlaceholder: {
      date: ["开始日期", "结束日期"],
      week: ["开始周", "结束周"],
      month: ["开始月份", "结束月份"],
      year: ["开始年份", "结束年份"],
      quarter: ["开始季度", "结束季度"],
      time: ["开始时间", "结束时间"]
    },
    selectTime: "选择时间",
    today: "今天",
    now: "此刻",
    ok: "确定"
  },
  image: {
    loading: "加载中"
  },
  imagePreview: {
    fullScreen: "全屏",
    rotateRight: "向右旋转",
    rotateLeft: "向左旋转",
    zoomIn: "放大",
    zoomOut: "缩小",
    originalSize: "原始尺寸"
  },
  typography: {
    copied: "已复制",
    copy: "复制",
    expand: "展开",
    collapse: "折叠",
    edit: "编辑"
  },
  form: {
    validateMessages: {
      required: "#{field} 是必填项",
      type: {
        string: "#{field} 不是合法的文本类型",
        number: "#{field} 不是合法的数字类型",
        boolean: "#{field} 不是合法的布尔类型",
        array: "#{field} 不是合法的数组类型",
        object: "#{field} 不是合法的对象类型",
        url: "#{field} 不是合法的 url 地址",
        email: "#{field} 不是合法的邮箱地址",
        ip: "#{field} 不是合法的 IP 地址"
      },
      number: {
        min: "`#{value}` 小于最小值 `#{min}`",
        max: "`#{value}` 大于最大值 `#{max}`",
        equal: "`#{value}` 不等于 `#{equal}`",
        range: "`#{value}` 不在 `#{min} ~ #{max}` 范围内",
        positive: "`#{value}` 不是正数",
        negative: "`#{value}` 不是负数"
      },
      array: {
        length: "`#{field}` 个数不等于 #{length}",
        minLength: "`#{field}` 个数最少为 #{minLength}",
        maxLength: "`#{field}` 个数最多为 #{maxLength}",
        includes: "#{field} 不包含 #{includes}",
        deepEqual: "#{field} 不等于 #{deepEqual}",
        empty: "`#{field}` 不是空数组"
      },
      string: {
        minLength: "字符数最少为 #{minLength}",
        maxLength: "字符数最多为 #{maxLength}",
        length: "字符数必须是 #{length}",
        match: "`#{value}` 不符合模式 #{pattern}",
        uppercase: "`#{value}` 必须全大写",
        lowercase: "`#{value}` 必须全小写"
      },
      object: {
        deepEqual: "`#{field}` 不等于期望值",
        hasKeys: "`#{field}` 不包含必须字段",
        empty: "`#{field}` 不是对象"
      },
      boolean: {
        true: "期望是 `true`",
        false: "期望是 `false`"
      }
    }
  }
};
const LOCALE = ref("zh-CN");
const I18N_MESSAGES = reactive({
  "zh-CN": lang$1
});
const useI18n$1 = () => {
  const configProvider = inject(configProviderInjectionKey, void 0);
  const i18nMessage = computed(() => {
    var _a2;
    return (_a2 = configProvider == null ? void 0 : configProvider.locale) != null ? _a2 : I18N_MESSAGES[LOCALE.value];
  });
  const locale2 = computed(() => i18nMessage.value.locale);
  const transform2 = (key, ...args) => {
    const keyArray = key.split(".");
    let temp = i18nMessage.value;
    for (const keyItem of keyArray) {
      if (!temp[keyItem]) {
        return key;
      }
      temp = temp[keyItem];
    }
    if (isString$3(temp)) {
      if (args.length > 0) {
        return temp.replace(/{(\d+)}/g, (sub2, index2) => {
          var _a2;
          return (_a2 = args[index2]) != null ? _a2 : sub2;
        });
      }
      return temp;
    }
    return temp;
  };
  return {
    i18nMessage,
    locale: locale2,
    t: transform2
  };
};
var __defProp$m = Object.defineProperty;
var __defProps$a = Object.defineProperties;
var __getOwnPropDescs$a = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$m = Object.getOwnPropertySymbols;
var __hasOwnProp$m = Object.prototype.hasOwnProperty;
var __propIsEnum$m = Object.prototype.propertyIsEnumerable;
var __defNormalProp$m = (obj, key, value) => key in obj ? __defProp$m(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$m = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$m.call(b2, prop))
      __defNormalProp$m(a, prop, b2[prop]);
  if (__getOwnPropSymbols$m)
    for (var prop of __getOwnPropSymbols$m(b2)) {
      if (__propIsEnum$m.call(b2, prop))
        __defNormalProp$m(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$a = (a, b2) => __defProps$a(a, __getOwnPropDescs$a(b2));
const COMPONENT_PREFIX = "A";
const CLASS_PREFIX = "arco";
const GLOBAL_CONFIG_NAME = "$arco";
const getComponentPrefix = (options) => {
  var _a2;
  return (_a2 = options == null ? void 0 : options.componentPrefix) != null ? _a2 : COMPONENT_PREFIX;
};
const setGlobalConfig = (app, options) => {
  var _a2;
  if (options && options.classPrefix) {
    app.config.globalProperties[GLOBAL_CONFIG_NAME] = __spreadProps$a(__spreadValues$m({}, (_a2 = app.config.globalProperties[GLOBAL_CONFIG_NAME]) != null ? _a2 : {}), {
      classPrefix: options.classPrefix
    });
  }
};
const getPrefixCls = (componentName) => {
  var _a2, _b2, _c2;
  const instance = getCurrentInstance();
  const configProvider = inject(configProviderInjectionKey, void 0);
  const prefix = (_c2 = (_b2 = configProvider == null ? void 0 : configProvider.prefixCls) != null ? _b2 : (_a2 = instance == null ? void 0 : instance.appContext.config.globalProperties[GLOBAL_CONFIG_NAME]) == null ? void 0 : _a2.classPrefix) != null ? _c2 : CLASS_PREFIX;
  if (componentName) {
    return `${prefix}-${componentName}`;
  }
  return prefix;
};
var MapShim = function() {
  if (typeof Map !== "undefined") {
    return Map;
  }
  function getIndex(arr, key) {
    var result = -1;
    arr.some(function(entry, index2) {
      if (entry[0] === key) {
        result = index2;
        return true;
      }
      return false;
    });
    return result;
  }
  return (
    /** @class */
    function() {
      function class_1() {
        this.__entries__ = [];
      }
      Object.defineProperty(class_1.prototype, "size", {
        /**
         * @returns {boolean}
         */
        get: function() {
          return this.__entries__.length;
        },
        enumerable: true,
        configurable: true
      });
      class_1.prototype.get = function(key) {
        var index2 = getIndex(this.__entries__, key);
        var entry = this.__entries__[index2];
        return entry && entry[1];
      };
      class_1.prototype.set = function(key, value) {
        var index2 = getIndex(this.__entries__, key);
        if (~index2) {
          this.__entries__[index2][1] = value;
        } else {
          this.__entries__.push([key, value]);
        }
      };
      class_1.prototype.delete = function(key) {
        var entries = this.__entries__;
        var index2 = getIndex(entries, key);
        if (~index2) {
          entries.splice(index2, 1);
        }
      };
      class_1.prototype.has = function(key) {
        return !!~getIndex(this.__entries__, key);
      };
      class_1.prototype.clear = function() {
        this.__entries__.splice(0);
      };
      class_1.prototype.forEach = function(callback, ctx) {
        if (ctx === void 0) {
          ctx = null;
        }
        for (var _i = 0, _a2 = this.__entries__; _i < _a2.length; _i++) {
          var entry = _a2[_i];
          callback.call(ctx, entry[1], entry[0]);
        }
      };
      return class_1;
    }()
  );
}();
var isBrowser$1 = typeof window !== "undefined" && typeof document !== "undefined" && window.document === document;
var global$1 = function() {
  if (typeof global !== "undefined" && global.Math === Math) {
    return global;
  }
  if (typeof self !== "undefined" && self.Math === Math) {
    return self;
  }
  if (typeof window !== "undefined" && window.Math === Math) {
    return window;
  }
  return Function("return this")();
}();
var requestAnimationFrame$1$1 = function() {
  if (typeof requestAnimationFrame === "function") {
    return requestAnimationFrame.bind(global$1);
  }
  return function(callback) {
    return setTimeout(function() {
      return callback(Date.now());
    }, 1e3 / 60);
  };
}();
var trailingTimeout = 2;
function throttle$1(callback, delay) {
  var leadingCall = false, trailingCall = false, lastCallTime = 0;
  function resolvePending() {
    if (leadingCall) {
      leadingCall = false;
      callback();
    }
    if (trailingCall) {
      proxy();
    }
  }
  function timeoutCallback() {
    requestAnimationFrame$1$1(resolvePending);
  }
  function proxy() {
    var timeStamp = Date.now();
    if (leadingCall) {
      if (timeStamp - lastCallTime < trailingTimeout) {
        return;
      }
      trailingCall = true;
    } else {
      leadingCall = true;
      trailingCall = false;
      setTimeout(timeoutCallback, delay);
    }
    lastCallTime = timeStamp;
  }
  return proxy;
}
var REFRESH_DELAY = 20;
var transitionKeys = ["top", "right", "bottom", "left", "width", "height", "size", "weight"];
var mutationObserverSupported = typeof MutationObserver !== "undefined";
var ResizeObserverController = (
  /** @class */
  function() {
    function ResizeObserverController2() {
      this.connected_ = false;
      this.mutationEventsAdded_ = false;
      this.mutationsObserver_ = null;
      this.observers_ = [];
      this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
      this.refresh = throttle$1(this.refresh.bind(this), REFRESH_DELAY);
    }
    ResizeObserverController2.prototype.addObserver = function(observer) {
      if (!~this.observers_.indexOf(observer)) {
        this.observers_.push(observer);
      }
      if (!this.connected_) {
        this.connect_();
      }
    };
    ResizeObserverController2.prototype.removeObserver = function(observer) {
      var observers2 = this.observers_;
      var index2 = observers2.indexOf(observer);
      if (~index2) {
        observers2.splice(index2, 1);
      }
      if (!observers2.length && this.connected_) {
        this.disconnect_();
      }
    };
    ResizeObserverController2.prototype.refresh = function() {
      var changesDetected = this.updateObservers_();
      if (changesDetected) {
        this.refresh();
      }
    };
    ResizeObserverController2.prototype.updateObservers_ = function() {
      var activeObservers = this.observers_.filter(function(observer) {
        return observer.gatherActive(), observer.hasActive();
      });
      activeObservers.forEach(function(observer) {
        return observer.broadcastActive();
      });
      return activeObservers.length > 0;
    };
    ResizeObserverController2.prototype.connect_ = function() {
      if (!isBrowser$1 || this.connected_) {
        return;
      }
      document.addEventListener("transitionend", this.onTransitionEnd_);
      window.addEventListener("resize", this.refresh);
      if (mutationObserverSupported) {
        this.mutationsObserver_ = new MutationObserver(this.refresh);
        this.mutationsObserver_.observe(document, {
          attributes: true,
          childList: true,
          characterData: true,
          subtree: true
        });
      } else {
        document.addEventListener("DOMSubtreeModified", this.refresh);
        this.mutationEventsAdded_ = true;
      }
      this.connected_ = true;
    };
    ResizeObserverController2.prototype.disconnect_ = function() {
      if (!isBrowser$1 || !this.connected_) {
        return;
      }
      document.removeEventListener("transitionend", this.onTransitionEnd_);
      window.removeEventListener("resize", this.refresh);
      if (this.mutationsObserver_) {
        this.mutationsObserver_.disconnect();
      }
      if (this.mutationEventsAdded_) {
        document.removeEventListener("DOMSubtreeModified", this.refresh);
      }
      this.mutationsObserver_ = null;
      this.mutationEventsAdded_ = false;
      this.connected_ = false;
    };
    ResizeObserverController2.prototype.onTransitionEnd_ = function(_a2) {
      var _b2 = _a2.propertyName, propertyName = _b2 === void 0 ? "" : _b2;
      var isReflowProperty = transitionKeys.some(function(key) {
        return !!~propertyName.indexOf(key);
      });
      if (isReflowProperty) {
        this.refresh();
      }
    };
    ResizeObserverController2.getInstance = function() {
      if (!this.instance_) {
        this.instance_ = new ResizeObserverController2();
      }
      return this.instance_;
    };
    ResizeObserverController2.instance_ = null;
    return ResizeObserverController2;
  }()
);
var defineConfigurable = function(target2, props) {
  for (var _i = 0, _a2 = Object.keys(props); _i < _a2.length; _i++) {
    var key = _a2[_i];
    Object.defineProperty(target2, key, {
      value: props[key],
      enumerable: false,
      writable: false,
      configurable: true
    });
  }
  return target2;
};
var getWindowOf = function(target2) {
  var ownerGlobal = target2 && target2.ownerDocument && target2.ownerDocument.defaultView;
  return ownerGlobal || global$1;
};
var emptyRect = createRectInit(0, 0, 0, 0);
function toFloat(value) {
  return parseFloat(value) || 0;
}
function getBordersSize(styles) {
  var positions = [];
  for (var _i = 1; _i < arguments.length; _i++) {
    positions[_i - 1] = arguments[_i];
  }
  return positions.reduce(function(size2, position) {
    var value = styles["border-" + position + "-width"];
    return size2 + toFloat(value);
  }, 0);
}
function getPaddings(styles) {
  var positions = ["top", "right", "bottom", "left"];
  var paddings = {};
  for (var _i = 0, positions_1 = positions; _i < positions_1.length; _i++) {
    var position = positions_1[_i];
    var value = styles["padding-" + position];
    paddings[position] = toFloat(value);
  }
  return paddings;
}
function getSVGContentRect(target2) {
  var bbox = target2.getBBox();
  return createRectInit(0, 0, bbox.width, bbox.height);
}
function getHTMLElementContentRect(target2) {
  var clientWidth = target2.clientWidth, clientHeight = target2.clientHeight;
  if (!clientWidth && !clientHeight) {
    return emptyRect;
  }
  var styles = getWindowOf(target2).getComputedStyle(target2);
  var paddings = getPaddings(styles);
  var horizPad = paddings.left + paddings.right;
  var vertPad = paddings.top + paddings.bottom;
  var width = toFloat(styles.width), height = toFloat(styles.height);
  if (styles.boxSizing === "border-box") {
    if (Math.round(width + horizPad) !== clientWidth) {
      width -= getBordersSize(styles, "left", "right") + horizPad;
    }
    if (Math.round(height + vertPad) !== clientHeight) {
      height -= getBordersSize(styles, "top", "bottom") + vertPad;
    }
  }
  if (!isDocumentElement(target2)) {
    var vertScrollbar = Math.round(width + horizPad) - clientWidth;
    var horizScrollbar = Math.round(height + vertPad) - clientHeight;
    if (Math.abs(vertScrollbar) !== 1) {
      width -= vertScrollbar;
    }
    if (Math.abs(horizScrollbar) !== 1) {
      height -= horizScrollbar;
    }
  }
  return createRectInit(paddings.left, paddings.top, width, height);
}
var isSVGGraphicsElement = function() {
  if (typeof SVGGraphicsElement !== "undefined") {
    return function(target2) {
      return target2 instanceof getWindowOf(target2).SVGGraphicsElement;
    };
  }
  return function(target2) {
    return target2 instanceof getWindowOf(target2).SVGElement && typeof target2.getBBox === "function";
  };
}();
function isDocumentElement(target2) {
  return target2 === getWindowOf(target2).document.documentElement;
}
function getContentRect(target2) {
  if (!isBrowser$1) {
    return emptyRect;
  }
  if (isSVGGraphicsElement(target2)) {
    return getSVGContentRect(target2);
  }
  return getHTMLElementContentRect(target2);
}
function createReadOnlyRect(_a2) {
  var x2 = _a2.x, y2 = _a2.y, width = _a2.width, height = _a2.height;
  var Constr = typeof DOMRectReadOnly !== "undefined" ? DOMRectReadOnly : Object;
  var rect = Object.create(Constr.prototype);
  defineConfigurable(rect, {
    x: x2,
    y: y2,
    width,
    height,
    top: y2,
    right: x2 + width,
    bottom: height + y2,
    left: x2
  });
  return rect;
}
function createRectInit(x2, y2, width, height) {
  return {
    x: x2,
    y: y2,
    width,
    height
  };
}
var ResizeObservation = (
  /** @class */
  function() {
    function ResizeObservation2(target2) {
      this.broadcastWidth = 0;
      this.broadcastHeight = 0;
      this.contentRect_ = createRectInit(0, 0, 0, 0);
      this.target = target2;
    }
    ResizeObservation2.prototype.isActive = function() {
      var rect = getContentRect(this.target);
      this.contentRect_ = rect;
      return rect.width !== this.broadcastWidth || rect.height !== this.broadcastHeight;
    };
    ResizeObservation2.prototype.broadcastRect = function() {
      var rect = this.contentRect_;
      this.broadcastWidth = rect.width;
      this.broadcastHeight = rect.height;
      return rect;
    };
    return ResizeObservation2;
  }()
);
var ResizeObserverEntry = (
  /** @class */
  function() {
    function ResizeObserverEntry2(target2, rectInit) {
      var contentRect = createReadOnlyRect(rectInit);
      defineConfigurable(this, {
        target: target2,
        contentRect
      });
    }
    return ResizeObserverEntry2;
  }()
);
var ResizeObserverSPI = (
  /** @class */
  function() {
    function ResizeObserverSPI2(callback, controller, callbackCtx) {
      this.activeObservations_ = [];
      this.observations_ = new MapShim();
      if (typeof callback !== "function") {
        throw new TypeError("The callback provided as parameter 1 is not a function.");
      }
      this.callback_ = callback;
      this.controller_ = controller;
      this.callbackCtx_ = callbackCtx;
    }
    ResizeObserverSPI2.prototype.observe = function(target2) {
      if (!arguments.length) {
        throw new TypeError("1 argument required, but only 0 present.");
      }
      if (typeof Element === "undefined" || !(Element instanceof Object)) {
        return;
      }
      if (!(target2 instanceof getWindowOf(target2).Element)) {
        throw new TypeError('parameter 1 is not of type "Element".');
      }
      var observations = this.observations_;
      if (observations.has(target2)) {
        return;
      }
      observations.set(target2, new ResizeObservation(target2));
      this.controller_.addObserver(this);
      this.controller_.refresh();
    };
    ResizeObserverSPI2.prototype.unobserve = function(target2) {
      if (!arguments.length) {
        throw new TypeError("1 argument required, but only 0 present.");
      }
      if (typeof Element === "undefined" || !(Element instanceof Object)) {
        return;
      }
      if (!(target2 instanceof getWindowOf(target2).Element)) {
        throw new TypeError('parameter 1 is not of type "Element".');
      }
      var observations = this.observations_;
      if (!observations.has(target2)) {
        return;
      }
      observations.delete(target2);
      if (!observations.size) {
        this.controller_.removeObserver(this);
      }
    };
    ResizeObserverSPI2.prototype.disconnect = function() {
      this.clearActive();
      this.observations_.clear();
      this.controller_.removeObserver(this);
    };
    ResizeObserverSPI2.prototype.gatherActive = function() {
      var _this = this;
      this.clearActive();
      this.observations_.forEach(function(observation) {
        if (observation.isActive()) {
          _this.activeObservations_.push(observation);
        }
      });
    };
    ResizeObserverSPI2.prototype.broadcastActive = function() {
      if (!this.hasActive()) {
        return;
      }
      var ctx = this.callbackCtx_;
      var entries = this.activeObservations_.map(function(observation) {
        return new ResizeObserverEntry(observation.target, observation.broadcastRect());
      });
      this.callback_.call(ctx, entries, ctx);
      this.clearActive();
    };
    ResizeObserverSPI2.prototype.clearActive = function() {
      this.activeObservations_.splice(0);
    };
    ResizeObserverSPI2.prototype.hasActive = function() {
      return this.activeObservations_.length > 0;
    };
    return ResizeObserverSPI2;
  }()
);
var observers = typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : new MapShim();
var ResizeObserver$3 = (
  /** @class */
  function() {
    function ResizeObserver2(callback) {
      if (!(this instanceof ResizeObserver2)) {
        throw new TypeError("Cannot call a class as a function.");
      }
      if (!arguments.length) {
        throw new TypeError("1 argument required, but only 0 present.");
      }
      var controller = ResizeObserverController.getInstance();
      var observer = new ResizeObserverSPI(callback, controller, this);
      observers.set(this, observer);
    }
    return ResizeObserver2;
  }()
);
["observe", "unobserve", "disconnect"].forEach(function(method) {
  ResizeObserver$3.prototype[method] = function() {
    var _a2;
    return (_a2 = observers.get(this))[method].apply(_a2, arguments);
  };
});
var index$t = function() {
  if (typeof global$1.ResizeObserver !== "undefined") {
    return global$1.ResizeObserver;
  }
  return ResizeObserver$3;
}();
var ShapeFlags;
(function(ShapeFlags2) {
  ShapeFlags2[ShapeFlags2["ELEMENT"] = 1] = "ELEMENT";
  ShapeFlags2[ShapeFlags2["FUNCTIONAL_COMPONENT"] = 2] = "FUNCTIONAL_COMPONENT";
  ShapeFlags2[ShapeFlags2["STATEFUL_COMPONENT"] = 4] = "STATEFUL_COMPONENT";
  ShapeFlags2[ShapeFlags2["COMPONENT"] = 6] = "COMPONENT";
  ShapeFlags2[ShapeFlags2["TEXT_CHILDREN"] = 8] = "TEXT_CHILDREN";
  ShapeFlags2[ShapeFlags2["ARRAY_CHILDREN"] = 16] = "ARRAY_CHILDREN";
  ShapeFlags2[ShapeFlags2["SLOTS_CHILDREN"] = 32] = "SLOTS_CHILDREN";
  ShapeFlags2[ShapeFlags2["TELEPORT"] = 64] = "TELEPORT";
  ShapeFlags2[ShapeFlags2["SUSPENSE"] = 128] = "SUSPENSE";
  ShapeFlags2[ShapeFlags2["COMPONENT_SHOULD_KEEP_ALIVE"] = 256] = "COMPONENT_SHOULD_KEEP_ALIVE";
  ShapeFlags2[ShapeFlags2["COMPONENT_KEPT_ALIVE"] = 512] = "COMPONENT_KEPT_ALIVE";
})(ShapeFlags || (ShapeFlags = {}));
var PatchFlags;
(function(PatchFlags2) {
  PatchFlags2[PatchFlags2["TEXT"] = 1] = "TEXT";
  PatchFlags2[PatchFlags2["CLASS"] = 2] = "CLASS";
  PatchFlags2[PatchFlags2["STYLE"] = 4] = "STYLE";
  PatchFlags2[PatchFlags2["PROPS"] = 8] = "PROPS";
  PatchFlags2[PatchFlags2["FULL_PROPS"] = 16] = "FULL_PROPS";
  PatchFlags2[PatchFlags2["HYDRATE_EVENTS"] = 32] = "HYDRATE_EVENTS";
  PatchFlags2[PatchFlags2["STABLE_FRAGMENT"] = 64] = "STABLE_FRAGMENT";
  PatchFlags2[PatchFlags2["KEYED_FRAGMENT"] = 128] = "KEYED_FRAGMENT";
  PatchFlags2[PatchFlags2["UNKEYED_FRAGMENT"] = 256] = "UNKEYED_FRAGMENT";
  PatchFlags2[PatchFlags2["NEED_PATCH"] = 512] = "NEED_PATCH";
  PatchFlags2[PatchFlags2["DYNAMIC_SLOTS"] = 1024] = "DYNAMIC_SLOTS";
  PatchFlags2[PatchFlags2["DEV_ROOT_FRAGMENT"] = 2048] = "DEV_ROOT_FRAGMENT";
  PatchFlags2[PatchFlags2["HOISTED"] = -1] = "HOISTED";
  PatchFlags2[PatchFlags2["BAIL"] = -2] = "BAIL";
})(PatchFlags || (PatchFlags = {}));
const isElement = (vn) => {
  return Boolean(vn && vn.shapeFlag & 1);
};
const isComponent = (vn, type) => {
  return Boolean(vn && vn.shapeFlag & 6);
};
const isTextChildren = (child, children) => {
  return Boolean(child && child.shapeFlag & 8);
};
const isArrayChildren = (vn, children) => {
  return Boolean(vn && vn.shapeFlag & 16);
};
const isSlotsChildren = (vn, children) => {
  return Boolean(vn && vn.shapeFlag & 32);
};
const getFirstComponent = (children) => {
  var _a2, _b2;
  if (!children) {
    return void 0;
  }
  for (const child of children) {
    if (isElement(child) || isComponent(child)) {
      return child;
    }
    if (isArrayChildren(child, child.children)) {
      const result = getFirstComponent(child.children);
      if (result)
        return result;
    } else if (isSlotsChildren(child, child.children)) {
      const children2 = (_b2 = (_a2 = child.children).default) == null ? void 0 : _b2.call(_a2);
      if (children2) {
        const result = getFirstComponent(children2);
        if (result)
          return result;
      }
    } else if (isArray$4(child)) {
      const result = getFirstComponent(child);
      if (result)
        return result;
    }
  }
  return void 0;
};
const isEmptyChildren = (children) => {
  if (!children) {
    return true;
  }
  for (const item of children) {
    if (item.children) {
      return false;
    }
  }
  return true;
};
const mergeFirstChild = (children, extraProps) => {
  if (children && children.length > 0) {
    for (let i2 = 0; i2 < children.length; i2++) {
      const child = children[i2];
      if (isElement(child) || isComponent(child)) {
        const props = isFunction$3(extraProps) ? extraProps(child) : extraProps;
        children[i2] = cloneVNode(child, props, true);
        return true;
      }
      const _children = getChildrenArray(child);
      if (_children && _children.length > 0) {
        const result = mergeFirstChild(_children, extraProps);
        if (result)
          return true;
      }
    }
  }
  return false;
};
const getChildrenArray = (vn) => {
  if (isArrayChildren(vn, vn.children)) {
    return vn.children;
  }
  if (isArray$4(vn)) {
    return vn;
  }
  return void 0;
};
const getFirstElementFromVNode = (vn) => {
  var _a2, _b2;
  if (isElement(vn)) {
    return vn.el;
  }
  if (isComponent(vn)) {
    if (((_a2 = vn.el) == null ? void 0 : _a2.nodeType) === 1) {
      return vn.el;
    }
    if ((_b2 = vn.component) == null ? void 0 : _b2.subTree) {
      const ele = getFirstElementFromVNode(vn.component.subTree);
      if (ele)
        return ele;
    }
  } else {
    const children = getChildrenArray(vn);
    return getFirstElementFromChildren(children);
  }
  return void 0;
};
const getFirstElementFromChildren = (children) => {
  if (children && children.length > 0) {
    for (const child of children) {
      const element = getFirstElementFromVNode(child);
      if (element)
        return element;
    }
  }
  return void 0;
};
const getAllElements = (children, includeText = false) => {
  var _a2, _b2;
  const results = [];
  for (const item of children != null ? children : []) {
    if (isElement(item) || isComponent(item) || includeText && isTextChildren(item, item.children)) {
      results.push(item);
    } else if (isArrayChildren(item, item.children)) {
      results.push(...getAllElements(item.children, includeText));
    } else if (isSlotsChildren(item, item.children)) {
      results.push(...getAllElements((_b2 = (_a2 = item.children).default) == null ? void 0 : _b2.call(_a2), includeText));
    } else if (isArray$4(item)) {
      results.push(...getAllElements(item, includeText));
    }
  }
  return results;
};
function unFragment(nodeList) {
  function loop(nodes) {
    const unFragmentNodeList = [];
    nodes.forEach((node) => {
      var _a2, _b2;
      if (isVNode$1(node) && node.type === Fragment) {
        if (isSlotsChildren(node, node.children)) {
          unFragmentNodeList.push(...loop(((_b2 = (_a2 = node.children).default) == null ? void 0 : _b2.call(_a2)) || []));
        } else if (isArrayChildren(node, node.children)) {
          unFragmentNodeList.push(...loop(node.children));
        } else if (isString$3(node.children)) {
          unFragmentNodeList.push(node.children);
        }
      } else {
        unFragmentNodeList.push(node);
      }
    });
    return unFragmentNodeList;
  }
  return loop(nodeList);
}
const getSlotFunction = (param) => {
  if (param) {
    if (isFunction$3(param))
      return param;
    return () => param;
  }
  return void 0;
};
var ResizeObserver$2 = defineComponent({
  name: "ResizeObserver",
  emits: ["resize"],
  setup(props, {
    emit: emit2,
    slots
  }) {
    let resizeObserver;
    const componentRef = ref();
    const element = computed(() => isComponentInstance(componentRef.value) ? componentRef.value.$el : componentRef.value);
    const createResizeObserver = (target2) => {
      if (!target2)
        return;
      resizeObserver = new index$t((entries) => {
        const entry = entries[0];
        emit2("resize", entry);
      });
      resizeObserver.observe(target2);
    };
    const destroyResizeObserver = () => {
      if (resizeObserver) {
        resizeObserver.disconnect();
        resizeObserver = null;
      }
    };
    watch(element, (_element) => {
      if (resizeObserver)
        destroyResizeObserver();
      if (_element)
        createResizeObserver(_element);
    });
    onMounted(() => {
      if (element.value) {
        createResizeObserver(element.value);
      }
    });
    onUnmounted(() => {
      destroyResizeObserver();
    });
    return () => {
      var _a2, _b2;
      const firstChild = getFirstComponent((_b2 = (_a2 = slots.default) == null ? void 0 : _a2.call(slots)) != null ? _b2 : []);
      if (firstChild) {
        return cloneVNode(firstChild, {
          ref: componentRef
        }, true);
      }
      return null;
    };
  }
});
const target$1 = typeof window === "undefined" ? global : window;
const raf$1 = target$1.requestAnimationFrame;
const caf$1 = target$1.cancelAnimationFrame;
function throttleByRaf(cb) {
  let timer = 0;
  const throttle2 = (...args) => {
    if (timer) {
      caf$1(timer);
    }
    timer = raf$1(() => {
      cb(...args);
      timer = 0;
    });
  };
  throttle2.cancel = () => {
    caf$1(timer);
    timer = 0;
  };
  return throttle2;
}
const NOOP = () => {
  return void 0;
};
const isServerRendering = (() => {
  try {
    return !(typeof window !== "undefined" && document !== void 0);
  } catch (e2) {
    return true;
  }
})();
const on = (() => {
  if (isServerRendering) {
    return NOOP;
  }
  return (element, event, handler, options = false) => {
    element.addEventListener(event, handler, options);
  };
})();
const off = (() => {
  if (isServerRendering) {
    return NOOP;
  }
  return (element, type, handler, options = false) => {
    element.removeEventListener(type, handler, options);
  };
})();
const getOverlay = (type) => {
  const popper = document.createElement("div");
  popper.setAttribute("class", `arco-overlay arco-overlay-${type}`);
  return popper;
};
const querySelector = (selectors, container) => {
  var _a2;
  if (isServerRendering) {
    return NOOP();
  }
  return (_a2 = (container != null ? container : document).querySelector(selectors)) != null ? _a2 : void 0;
};
const getElement = (target2, container) => {
  if (isString$3(target2)) {
    const selector = target2[0] === "#" ? `[id='${target2.slice(1)}']` : target2;
    return querySelector(selector, container);
  }
  return target2;
};
const getRelativeRect = (target2, relative) => {
  const targetRect = target2.getBoundingClientRect();
  const relativeRect = relative.getBoundingClientRect();
  return {
    top: targetRect.top - relativeRect.top,
    bottom: relativeRect.bottom - targetRect.bottom,
    left: targetRect.left - relativeRect.left,
    right: relativeRect.right - targetRect.right,
    width: targetRect.width,
    height: targetRect.height
  };
};
var _export_sfc$1 = (sfc, props) => {
  for (const [key, val] of props) {
    sfc[key] = val;
  }
  return sfc;
};
const _sfc_main$1l = defineComponent({
  name: "IconHover",
  props: {
    prefix: {
      type: String
    },
    size: {
      type: String,
      default: "medium"
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  setup() {
    const prefixCls = getPrefixCls("icon-hover");
    return {
      prefixCls
    };
  }
});
function _sfc_render$1d(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", {
    class: normalizeClass([_ctx.prefixCls, {
      [`${_ctx.prefix}-icon-hover`]: _ctx.prefix,
      [`${_ctx.prefixCls}-size-${_ctx.size}`]: _ctx.size !== "medium",
      [`${_ctx.prefixCls}-disabled`]: _ctx.disabled
    }])
  }, [renderSlot(_ctx.$slots, "default")], 2);
}
var IconHover = /* @__PURE__ */ _export_sfc$1(_sfc_main$1l, [["render", _sfc_render$1d]]);
const _sfc_main$1k = defineComponent({
  name: "IconClose",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-close`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$z = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$x = /* @__PURE__ */ createBaseVNode("path", {
  d: "M9.857 9.858 24 24m0 0 14.142 14.142M24 24 38.142 9.858M24 24 9.857 38.142"
}, null, -1);
const _hoisted_3$u = [_hoisted_2$x];
function _sfc_render$1c(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$u, 14, _hoisted_1$z);
}
var _IconClose = /* @__PURE__ */ _export_sfc$1(_sfc_main$1k, [["render", _sfc_render$1c]]);
const IconClose = Object.assign(_IconClose, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconClose.name, _IconClose);
  }
});
const _sfc_main$1j = defineComponent({
  name: "IconInfoCircleFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-info-circle-fill`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$y = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$w = /* @__PURE__ */ createBaseVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm2-30a1 1 0 0 0-1-1h-2a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2Zm0 17h1a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-6a1 1 0 0 1-1-1v-2a1 1 0 0 1 1-1h1v-8a1 1 0 0 1-1-1v-2a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v11Z",
  fill: "currentColor",
  stroke: "none"
}, null, -1);
const _hoisted_3$t = [_hoisted_2$w];
function _sfc_render$1b(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$t, 14, _hoisted_1$y);
}
var _IconInfoCircleFill = /* @__PURE__ */ _export_sfc$1(_sfc_main$1j, [["render", _sfc_render$1b]]);
const IconInfoCircleFill = Object.assign(_IconInfoCircleFill, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconInfoCircleFill.name, _IconInfoCircleFill);
  }
});
const _sfc_main$1i = defineComponent({
  name: "IconCheckCircleFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-check-circle-fill`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$x = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$v = /* @__PURE__ */ createBaseVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm10.207-24.379a1 1 0 0 0 0-1.414l-1.414-1.414a1 1 0 0 0-1.414 0L22 26.172l-4.878-4.88a1 1 0 0 0-1.415 0l-1.414 1.415a1 1 0 0 0 0 1.414l7 7a1 1 0 0 0 1.414 0l11.5-11.5Z",
  fill: "currentColor",
  stroke: "none"
}, null, -1);
const _hoisted_3$s = [_hoisted_2$v];
function _sfc_render$1a(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$s, 14, _hoisted_1$x);
}
var _IconCheckCircleFill = /* @__PURE__ */ _export_sfc$1(_sfc_main$1i, [["render", _sfc_render$1a]]);
const IconCheckCircleFill = Object.assign(_IconCheckCircleFill, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconCheckCircleFill.name, _IconCheckCircleFill);
  }
});
const _sfc_main$1h = defineComponent({
  name: "IconExclamationCircleFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-exclamation-circle-fill`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$w = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$u = /* @__PURE__ */ createBaseVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm-2-11a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-2a1 1 0 0 0-1 1v2Zm4-18a1 1 0 0 0-1-1h-2a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V15Z",
  fill: "currentColor",
  stroke: "none"
}, null, -1);
const _hoisted_3$r = [_hoisted_2$u];
function _sfc_render$19(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$r, 14, _hoisted_1$w);
}
var _IconExclamationCircleFill = /* @__PURE__ */ _export_sfc$1(_sfc_main$1h, [["render", _sfc_render$19]]);
const IconExclamationCircleFill = Object.assign(_IconExclamationCircleFill, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconExclamationCircleFill.name, _IconExclamationCircleFill);
  }
});
const _sfc_main$1g = defineComponent({
  name: "IconCloseCircleFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-close-circle-fill`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$v = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$t = /* @__PURE__ */ createBaseVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm4.955-27.771-4.95 4.95-4.95-4.95a1 1 0 0 0-1.414 0l-1.414 1.414a1 1 0 0 0 0 1.414l4.95 4.95-4.95 4.95a1 1 0 0 0 0 1.414l1.414 1.414a1 1 0 0 0 1.414 0l4.95-4.95 4.95 4.95a1 1 0 0 0 1.414 0l1.414-1.414a1 1 0 0 0 0-1.414l-4.95-4.95 4.95-4.95a1 1 0 0 0 0-1.414l-1.414-1.414a1 1 0 0 0-1.414 0Z",
  fill: "currentColor",
  stroke: "none"
}, null, -1);
const _hoisted_3$q = [_hoisted_2$t];
function _sfc_render$18(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$q, 14, _hoisted_1$v);
}
var _IconCloseCircleFill = /* @__PURE__ */ _export_sfc$1(_sfc_main$1g, [["render", _sfc_render$18]]);
const IconCloseCircleFill = Object.assign(_IconCloseCircleFill, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconCloseCircleFill.name, _IconCloseCircleFill);
  }
});
const _sfc_main$1f = defineComponent({
  name: "Alert",
  components: {
    IconHover,
    IconClose,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill
  },
  props: {
    type: {
      type: String,
      default: "info"
    },
    showIcon: {
      type: Boolean,
      default: true
    },
    closable: {
      type: Boolean,
      default: false
    },
    title: String,
    banner: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    close: (ev) => true,
    afterClose: () => true
  },
  setup(props, {
    slots,
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("alert");
    const visible = ref(true);
    const handleClose = (ev) => {
      visible.value = false;
      emit2("close", ev);
    };
    const handleAfterLeave = () => {
      emit2("afterClose");
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-${props.type}`, {
      [`${prefixCls}-with-title`]: Boolean(props.title || slots.title),
      [`${prefixCls}-banner`]: props.banner
    }]);
    return {
      prefixCls,
      cls,
      visible,
      handleClose,
      handleAfterLeave
    };
  }
});
function _sfc_render$17(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_icon_hover = resolveComponent("icon-hover");
  return openBlock(), createBlock(Transition, {
    name: "zoom-in-top",
    onAfterLeave: _ctx.handleAfterLeave
  }, {
    default: withCtx(() => [_ctx.visible ? (openBlock(), createElementBlock("div", {
      key: 0,
      role: "alert",
      class: normalizeClass(_ctx.cls)
    }, [_ctx.showIcon && !(_ctx.type === "normal" && !_ctx.$slots.icon) ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [renderSlot(_ctx.$slots, "icon", {}, () => [_ctx.type === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, {
      key: 0
    })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, {
      key: 1
    })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, {
      key: 2
    })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, {
      key: 3
    })) : createCommentVNode("v-if", true)])], 2)) : createCommentVNode("v-if", true), createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-body`)
    }, [_ctx.title || _ctx.$slots.title ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-title`)
    }, [renderSlot(_ctx.$slots, "title", {}, () => [createTextVNode(toDisplayString$1(_ctx.title), 1)])], 2)) : createCommentVNode("v-if", true), createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-content`)
    }, [renderSlot(_ctx.$slots, "default")], 2)], 2), _ctx.$slots.action ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-action`)
    }, [renderSlot(_ctx.$slots, "action")], 2)) : createCommentVNode("v-if", true), _ctx.closable ? (openBlock(), createElementBlock("div", {
      key: 2,
      tabindex: "-1",
      role: "button",
      "aria-label": "Close",
      class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClose && _ctx.handleClose(...args))
    }, [renderSlot(_ctx.$slots, "close-element", {}, () => [createVNode(_component_icon_hover, null, {
      default: withCtx(() => [createVNode(_component_icon_close)]),
      _: 1
    })])], 2)) : createCommentVNode("v-if", true)], 2)) : createCommentVNode("v-if", true)]),
    _: 3
  }, 8, ["onAfterLeave"]);
}
var _Alert = /* @__PURE__ */ _export_sfc$1(_sfc_main$1f, [["render", _sfc_render$17]]);
const Alert = Object.assign(_Alert, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Alert.name, _Alert);
  }
});
function t(t2) {
  return "object" == typeof t2 && null != t2 && 1 === t2.nodeType;
}
function e$1(t2, e2) {
  return (!e2 || "hidden" !== t2) && "visible" !== t2 && "clip" !== t2;
}
function n(t2, n2) {
  if (t2.clientHeight < t2.scrollHeight || t2.clientWidth < t2.scrollWidth) {
    var r2 = getComputedStyle(t2, null);
    return e$1(r2.overflowY, n2) || e$1(r2.overflowX, n2) || function(t3) {
      var e2 = function(t4) {
        if (!t4.ownerDocument || !t4.ownerDocument.defaultView)
          return null;
        try {
          return t4.ownerDocument.defaultView.frameElement;
        } catch (t5) {
          return null;
        }
      }(t3);
      return !!e2 && (e2.clientHeight < t3.scrollHeight || e2.clientWidth < t3.scrollWidth);
    }(t2);
  }
  return false;
}
function r(t2, e2, n2, r2, i2, o, l, d) {
  return o < t2 && l > e2 || o > t2 && l < e2 ? 0 : o <= t2 && d <= n2 || l >= e2 && d >= n2 ? o - t2 - r2 : l > e2 && d < n2 || o < t2 && d > n2 ? l - e2 + i2 : 0;
}
var i = function(e2, i2) {
  var o = window, l = i2.scrollMode, d = i2.block, f = i2.inline, h2 = i2.boundary, u = i2.skipOverflowHiddenElements, s = "function" == typeof h2 ? h2 : function(t2) {
    return t2 !== h2;
  };
  if (!t(e2))
    throw new TypeError("Invalid target");
  for (var a, c, g = document.scrollingElement || document.documentElement, p2 = [], m2 = e2; t(m2) && s(m2); ) {
    if ((m2 = null == (c = (a = m2).parentElement) ? a.getRootNode().host || null : c) === g) {
      p2.push(m2);
      break;
    }
    null != m2 && m2 === document.body && n(m2) && !n(document.documentElement) || null != m2 && n(m2, u) && p2.push(m2);
  }
  for (var w2 = o.visualViewport ? o.visualViewport.width : innerWidth, v = o.visualViewport ? o.visualViewport.height : innerHeight, W = window.scrollX || pageXOffset, H = window.scrollY || pageYOffset, b2 = e2.getBoundingClientRect(), y2 = b2.height, E2 = b2.width, M = b2.top, V = b2.right, x2 = b2.bottom, I = b2.left, C2 = "start" === d || "nearest" === d ? M : "end" === d ? x2 : M + y2 / 2, R = "center" === f ? I + E2 / 2 : "end" === f ? V : I, T2 = [], k = 0; k < p2.length; k++) {
    var B = p2[k], D = B.getBoundingClientRect(), O2 = D.height, X = D.width, Y = D.top, L2 = D.right, S2 = D.bottom, j2 = D.left;
    if ("if-needed" === l && M >= 0 && I >= 0 && x2 <= v && V <= w2 && M >= Y && x2 <= S2 && I >= j2 && V <= L2)
      return T2;
    var N = getComputedStyle(B), q = parseInt(N.borderLeftWidth, 10), z2 = parseInt(N.borderTopWidth, 10), A = parseInt(N.borderRightWidth, 10), F = parseInt(N.borderBottomWidth, 10), G = 0, J = 0, K = "offsetWidth" in B ? B.offsetWidth - B.clientWidth - q - A : 0, P = "offsetHeight" in B ? B.offsetHeight - B.clientHeight - z2 - F : 0, Q = "offsetWidth" in B ? 0 === B.offsetWidth ? 0 : X / B.offsetWidth : 0, U = "offsetHeight" in B ? 0 === B.offsetHeight ? 0 : O2 / B.offsetHeight : 0;
    if (g === B)
      G = "start" === d ? C2 : "end" === d ? C2 - v : "nearest" === d ? r(H, H + v, v, z2, F, H + C2, H + C2 + y2, y2) : C2 - v / 2, J = "start" === f ? R : "center" === f ? R - w2 / 2 : "end" === f ? R - w2 : r(W, W + w2, w2, q, A, W + R, W + R + E2, E2), G = Math.max(0, G + H), J = Math.max(0, J + W);
    else {
      G = "start" === d ? C2 - Y - z2 : "end" === d ? C2 - S2 + F + P : "nearest" === d ? r(Y, S2, O2, z2, F + P, C2, C2 + y2, y2) : C2 - (Y + O2 / 2) + P / 2, J = "start" === f ? R - j2 - q : "center" === f ? R - (j2 + X / 2) + K / 2 : "end" === f ? R - L2 + A + K : r(j2, L2, X, q, A + K, R, R + E2, E2);
      var Z = B.scrollLeft, $ = B.scrollTop;
      C2 += $ - (G = Math.max(0, Math.min($ + G / U, B.scrollHeight - O2 / U + P))), R += Z - (J = Math.max(0, Math.min(Z + J / Q, B.scrollWidth - X / Q + K)));
    }
    T2.push({ el: B, top: G, left: J });
  }
  return T2;
};
const MESSAGE_TYPES = ["info", "success", "warning", "error"];
const INPUT_EVENTS = ["onFocus", "onFocusin", "onFocusout", "onBlur", "onChange", "onBeforeinput", "onInput", "onReset", "onSubmit", "onInvalid", "onKeydown", "onKeypress", "onKeyup", "onCopy", "onCut", "onPaste", "onCompositionstart", "onCompositionupdate", "onCompositionend", "onSelect", "autocomplete", "autofocus", "maxlength", "minlength", "name", "pattern", "readonly", "required"];
const _sfc_main$1e = defineComponent({
  name: "IconLoading",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-loading`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$u = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$s = /* @__PURE__ */ createBaseVNode("path", {
  d: "M42 24c0 9.941-8.059 18-18 18S6 33.941 6 24 14.059 6 24 6"
}, null, -1);
const _hoisted_3$p = [_hoisted_2$s];
function _sfc_render$16(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$p, 14, _hoisted_1$u);
}
var _IconLoading = /* @__PURE__ */ _export_sfc$1(_sfc_main$1e, [["render", _sfc_render$16]]);
const IconLoading = Object.assign(_IconLoading, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconLoading.name, _IconLoading);
  }
});
const _sfc_main$1d = defineComponent({
  name: "FeedbackIcon",
  components: {
    IconLoading,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill
  },
  props: {
    type: {
      type: String
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("feedback-icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-status-${props.type}`]);
    return {
      cls
    };
  }
});
function _sfc_render$15(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_loading = resolveComponent("icon-loading");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  return openBlock(), createElementBlock("span", {
    class: normalizeClass(_ctx.cls)
  }, [_ctx.type === "validating" ? (openBlock(), createBlock(_component_icon_loading, {
    key: 0
  })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, {
    key: 1
  })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, {
    key: 2
  })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, {
    key: 3
  })) : createCommentVNode("v-if", true)], 2);
}
var FeedbackIcon = /* @__PURE__ */ _export_sfc$1(_sfc_main$1d, [["render", _sfc_render$15]]);
const Enter = {
  key: "Enter",
  code: "Enter"
};
const Backspace = {
  key: "Backspace",
  code: "Backspace"
};
var __defProp$l = Object.defineProperty;
var __getOwnPropSymbols$l = Object.getOwnPropertySymbols;
var __hasOwnProp$l = Object.prototype.hasOwnProperty;
var __propIsEnum$l = Object.prototype.propertyIsEnumerable;
var __defNormalProp$l = (obj, key, value) => key in obj ? __defProp$l(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$l = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$l.call(b2, prop))
      __defNormalProp$l(a, prop, b2[prop]);
  if (__getOwnPropSymbols$l)
    for (var prop of __getOwnPropSymbols$l(b2)) {
      if (__propIsEnum$l.call(b2, prop))
        __defNormalProp$l(a, prop, b2[prop]);
    }
  return a;
};
const omit = (object, path) => {
  const result = __spreadValues$l({}, object);
  for (const item of path) {
    if (item in result) {
      delete result[item];
    }
  }
  return result;
};
function pick(obj, keys2) {
  const clone2 = {};
  keys2.forEach((key) => {
    const k = key;
    if (key in obj) {
      clone2[k] = obj[k];
    }
  });
  return clone2;
}
const formItemInjectionKey = Symbol("ArcoFormItemContext");
const useFormItem = ({
  size: size2,
  disabled,
  error,
  uninject
} = {}) => {
  const formItemCtx = !uninject ? inject(formItemInjectionKey, {}) : {};
  const mergedSize = computed(() => {
    var _a2;
    return (_a2 = size2 == null ? void 0 : size2.value) != null ? _a2 : formItemCtx.size;
  });
  const mergedDisabled = computed(() => (disabled == null ? void 0 : disabled.value) || formItemCtx.disabled);
  const mergedError = computed(() => (error == null ? void 0 : error.value) || formItemCtx.error);
  const feedback = toRef(formItemCtx, "feedback");
  const eventHandlers = toRef(formItemCtx, "eventHandlers");
  return {
    formItemCtx,
    mergedSize,
    mergedDisabled,
    mergedError,
    feedback,
    eventHandlers
  };
};
const useSize$1 = (size2, {
  defaultValue = "medium"
} = {}) => {
  const configProviderCtx = inject(configProviderInjectionKey, void 0);
  const mergedSize = computed(() => {
    var _a2, _b2;
    return (_b2 = (_a2 = size2 == null ? void 0 : size2.value) != null ? _a2 : configProviderCtx == null ? void 0 : configProviderCtx.size) != null ? _b2 : defaultValue;
  });
  return {
    mergedSize
  };
};
function useCursor(input) {
  const selectionRef = ref();
  function recordCursor() {
    if (!input.value)
      return;
    const {
      selectionStart,
      selectionEnd,
      value
    } = input.value;
    if (selectionStart == null || selectionEnd == null)
      return;
    const beforeTxt = value.slice(0, Math.max(0, selectionStart));
    const afterTxt = value.slice(Math.max(0, selectionEnd));
    selectionRef.value = {
      selectionStart,
      selectionEnd,
      value,
      beforeTxt,
      afterTxt
    };
  }
  function setCursor() {
    if (!input.value || !selectionRef.value)
      return;
    const {
      value
    } = input.value;
    const {
      beforeTxt,
      afterTxt,
      selectionStart
    } = selectionRef.value;
    if (!beforeTxt || !afterTxt || !selectionStart)
      return;
    let startPos = value.length;
    if (value.endsWith(afterTxt)) {
      startPos = value.length - afterTxt.length;
    } else if (value.startsWith(beforeTxt)) {
      startPos = beforeTxt.length;
    } else {
      const beforeLastChar = beforeTxt[selectionStart - 1];
      const newIndex = value.indexOf(beforeLastChar, selectionStart - 1);
      if (newIndex !== -1) {
        startPos = newIndex + 1;
      }
    }
    input.value.setSelectionRange(startPos, startPos);
  }
  return [recordCursor, setCursor];
}
var __defProp$k = Object.defineProperty;
var __getOwnPropSymbols$k = Object.getOwnPropertySymbols;
var __hasOwnProp$k = Object.prototype.hasOwnProperty;
var __propIsEnum$k = Object.prototype.propertyIsEnumerable;
var __defNormalProp$k = (obj, key, value) => key in obj ? __defProp$k(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$k = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$k.call(b2, prop))
      __defNormalProp$k(a, prop, b2[prop]);
  if (__getOwnPropSymbols$k)
    for (var prop of __getOwnPropSymbols$k(b2)) {
      if (__propIsEnum$k.call(b2, prop))
        __defNormalProp$k(a, prop, b2[prop]);
    }
  return a;
};
var _Input = defineComponent({
  name: "Input",
  inheritAttrs: false,
  props: {
    modelValue: String,
    defaultValue: {
      type: String,
      default: ""
    },
    size: {
      type: String
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    placeholder: String,
    maxLength: {
      type: [Number, Object],
      default: 0
    },
    showWordLimit: {
      type: Boolean,
      default: false
    },
    wordLength: {
      type: Function
    },
    wordSlice: {
      type: Function
    },
    inputAttrs: {
      type: Object
    },
    type: {
      type: String,
      default: "text"
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "input": (value, ev) => true,
    "change": (value, ev) => true,
    "pressEnter": (ev) => true,
    "clear": (ev) => true,
    "focus": (ev) => true,
    "blur": (ev) => true
  },
  setup(props, {
    emit: emit2,
    slots,
    attrs
  }) {
    const {
      size: size2,
      disabled,
      error,
      modelValue
    } = toRefs(props);
    const prefixCls = getPrefixCls("input");
    const inputRef = ref();
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      mergedError: _mergedError,
      feedback,
      eventHandlers
    } = useFormItem({
      size: size2,
      disabled,
      error
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const [recordCursor, setCursor] = useCursor(inputRef);
    const _value = ref(props.defaultValue);
    const computedValue = computed(() => {
      var _a2;
      return (_a2 = props.modelValue) != null ? _a2 : _value.value;
    });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = "";
      }
    });
    let preValue = computedValue.value;
    const focused = ref(false);
    const showClearBtn = computed(() => props.allowClear && !mergedDisabled.value && Boolean(computedValue.value));
    const isComposition = ref(false);
    const compositionValue = ref("");
    const getValueLength = (value) => {
      var _a2;
      if (isFunction$3(props.wordLength)) {
        return props.wordLength(value);
      }
      return (_a2 = value.length) != null ? _a2 : 0;
    };
    const valueLength = computed(() => getValueLength(computedValue.value));
    const mergedError = computed(() => _mergedError.value || Boolean(isObject$5(props.maxLength) && props.maxLength.errorOnly && valueLength.value > maxLength.value));
    const maxLengthErrorOnly = computed(() => isObject$5(props.maxLength) && Boolean(props.maxLength.errorOnly));
    const maxLength = computed(() => {
      if (isObject$5(props.maxLength)) {
        return props.maxLength.length;
      }
      return props.maxLength;
    });
    const defaultMaxLength = computed(() => {
      const bytePerChar = getValueLength("a");
      return Math.floor(maxLength.value / bytePerChar);
    });
    const updateValue = (value) => {
      var _a2, _b2;
      if (maxLength.value && !maxLengthErrorOnly.value && getValueLength(value) > maxLength.value) {
        value = (_b2 = (_a2 = props.wordSlice) == null ? void 0 : _a2.call(props, value, maxLength.value)) != null ? _b2 : value.slice(0, defaultMaxLength.value);
      }
      _value.value = value;
      emit2("update:modelValue", value);
    };
    const handleMousedown = (e2) => {
      if (inputRef.value && e2.target !== inputRef.value) {
        e2.preventDefault();
        inputRef.value.focus();
      }
    };
    const emitChange = (value, ev) => {
      var _a2, _b2;
      if (value !== preValue) {
        preValue = value;
        emit2("change", value, ev);
        (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onChange) == null ? void 0 : _b2.call(_a2, ev);
      }
    };
    const handleFocus = (ev) => {
      var _a2, _b2;
      focused.value = true;
      preValue = computedValue.value;
      emit2("focus", ev);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onFocus) == null ? void 0 : _b2.call(_a2, ev);
    };
    const handleBlur = (ev) => {
      var _a2, _b2;
      focused.value = false;
      emitChange(computedValue.value, ev);
      emit2("blur", ev);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onBlur) == null ? void 0 : _b2.call(_a2, ev);
    };
    const handleComposition = (e2) => {
      var _a2, _b2, _c2;
      const {
        value,
        selectionStart,
        selectionEnd
      } = e2.target;
      if (e2.type === "compositionend") {
        isComposition.value = false;
        compositionValue.value = "";
        if (maxLength.value && !maxLengthErrorOnly.value && valueLength.value >= maxLength.value && getValueLength(value) > maxLength.value && selectionStart === selectionEnd) {
          keepControl();
          return;
        }
        updateValue(value);
        emit2("input", value, e2);
        (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onInput) == null ? void 0 : _b2.call(_a2, e2);
        keepControl();
      } else {
        isComposition.value = true;
        compositionValue.value = computedValue.value + ((_c2 = e2.data) != null ? _c2 : "");
      }
    };
    const keepControl = () => {
      recordCursor();
      nextTick(() => {
        if (inputRef.value && computedValue.value !== inputRef.value.value) {
          inputRef.value.value = computedValue.value;
          setCursor();
        }
      });
    };
    const handleInput = (e2) => {
      var _a2, _b2;
      const {
        value
      } = e2.target;
      if (!isComposition.value) {
        if (maxLength.value && !maxLengthErrorOnly.value && valueLength.value >= maxLength.value && getValueLength(value) > maxLength.value && e2.inputType === "insertText") {
          keepControl();
          return;
        }
        updateValue(value);
        emit2("input", value, e2);
        (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onInput) == null ? void 0 : _b2.call(_a2, e2);
        keepControl();
      }
    };
    const handleClear = (ev) => {
      updateValue("");
      emitChange("", ev);
      emit2("clear", ev);
    };
    const handleKeyDown = (e2) => {
      const keyCode = e2.key || e2.code;
      if (!isComposition.value && keyCode === Enter.key) {
        emitChange(computedValue.value, e2);
        emit2("pressEnter", e2);
      }
    };
    const outerCls = computed(() => [`${prefixCls}-outer`, `${prefixCls}-outer-size-${mergedSize.value}`, {
      [`${prefixCls}-outer-has-suffix`]: Boolean(slots.suffix),
      [`${prefixCls}-outer-disabled`]: mergedDisabled.value
    }]);
    const wrapperCls = computed(() => [`${prefixCls}-wrapper`, {
      [`${prefixCls}-error`]: mergedError.value,
      [`${prefixCls}-disabled`]: mergedDisabled.value,
      [`${prefixCls}-focus`]: focused.value
    }]);
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`]);
    const wrapperAttrs = computed(() => omit(attrs, INPUT_EVENTS));
    const inputAttrs = computed(() => pick(attrs, INPUT_EVENTS));
    const mergeInputAttrs = computed(() => {
      const attrs2 = __spreadValues$k(__spreadValues$k({}, inputAttrs.value), props.inputAttrs);
      if (mergedError.value) {
        attrs2["aria-invalid"] = true;
      }
      return attrs2;
    });
    const renderInput = (hasOuter) => {
      var _a2;
      return createVNode("span", mergeProps({
        "class": wrapperCls.value,
        "onMousedown": handleMousedown
      }, !hasOuter ? wrapperAttrs.value : void 0), [slots.prefix && createVNode("span", {
        "class": `${prefixCls}-prefix`
      }, [slots.prefix()]), createVNode("input", mergeProps(mergeInputAttrs.value, {
        "ref": inputRef,
        "class": cls.value,
        "value": computedValue.value,
        "type": props.type,
        "placeholder": props.placeholder,
        "readonly": props.readonly,
        "disabled": mergedDisabled.value,
        "onInput": handleInput,
        "onKeydown": handleKeyDown,
        "onFocus": handleFocus,
        "onBlur": handleBlur,
        "onCompositionstart": handleComposition,
        "onCompositionupdate": handleComposition,
        "onCompositionend": handleComposition
      }), null), showClearBtn.value && createVNode(IconHover, {
        "prefix": prefixCls,
        "class": `${prefixCls}-clear-btn`,
        "onClick": handleClear
      }, {
        default: () => [createVNode(IconClose, null, null)]
      }), (slots.suffix || Boolean(props.maxLength) && props.showWordLimit || Boolean(feedback.value)) && createVNode("span", {
        "class": [`${prefixCls}-suffix`, {
          [`${prefixCls}-suffix-has-feedback`]: feedback.value
        }]
      }, [Boolean(props.maxLength) && props.showWordLimit && createVNode("span", {
        "class": `${prefixCls}-word-limit`
      }, [valueLength.value, createTextVNode("/"), maxLength.value]), (_a2 = slots.suffix) == null ? void 0 : _a2.call(slots), Boolean(feedback.value) && createVNode(FeedbackIcon, {
        "type": feedback.value
      }, null)])]);
    };
    const render2 = () => {
      if (slots.prepend || slots.append) {
        return createVNode("span", mergeProps({
          "class": outerCls.value
        }, wrapperAttrs.value), [slots.prepend && createVNode("span", {
          "class": `${prefixCls}-prepend`
        }, [slots.prepend()]), renderInput(true), slots.append && createVNode("span", {
          "class": `${prefixCls}-append`
        }, [slots.append()])]);
      }
      return renderInput();
    };
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.focus();
    },
    blur() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.blur();
    }
  },
  render() {
    return this.render();
  }
});
const _sfc_main$1c = defineComponent({
  name: "IconSearch",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-search`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$t = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$r = /* @__PURE__ */ createBaseVNode("path", {
  d: "M33.072 33.071c6.248-6.248 6.248-16.379 0-22.627-6.249-6.249-16.38-6.249-22.628 0-6.248 6.248-6.248 16.379 0 22.627 6.248 6.248 16.38 6.248 22.628 0Zm0 0 8.485 8.485"
}, null, -1);
const _hoisted_3$o = [_hoisted_2$r];
function _sfc_render$14(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$o, 14, _hoisted_1$t);
}
var _IconSearch = /* @__PURE__ */ _export_sfc$1(_sfc_main$1c, [["render", _sfc_render$14]]);
const IconSearch = Object.assign(_IconSearch, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconSearch.name, _IconSearch);
  }
});
const buttonGroupInjectionKey = Symbol("ArcoButtonGroup");
const _sfc_main$1b = defineComponent({
  name: "Button",
  components: {
    IconLoading
  },
  props: {
    type: {
      type: String
    },
    shape: {
      type: String
    },
    status: {
      type: String
    },
    size: {
      type: String
    },
    long: {
      type: Boolean,
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean
    },
    htmlType: {
      type: String,
      default: "button"
    },
    href: String
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const {
      size: size2,
      disabled
    } = toRefs(props);
    const prefixCls = getPrefixCls("btn");
    const groupContext = inject(buttonGroupInjectionKey, void 0);
    const _size = computed(() => {
      var _a2;
      return (_a2 = size2.value) != null ? _a2 : groupContext == null ? void 0 : groupContext.size;
    });
    const _disabled = computed(() => Boolean(disabled.value || (groupContext == null ? void 0 : groupContext.disabled)));
    const {
      mergedSize: _mergedSize,
      mergedDisabled
    } = useFormItem({
      size: _size,
      disabled: _disabled
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const cls = computed(() => {
      var _a2, _b2, _c2, _d, _e, _f;
      return [prefixCls, `${prefixCls}-${(_b2 = (_a2 = props.type) != null ? _a2 : groupContext == null ? void 0 : groupContext.type) != null ? _b2 : "secondary"}`, `${prefixCls}-shape-${(_d = (_c2 = props.shape) != null ? _c2 : groupContext == null ? void 0 : groupContext.shape) != null ? _d : "square"}`, `${prefixCls}-size-${mergedSize.value}`, `${prefixCls}-status-${(_f = (_e = props.status) != null ? _e : groupContext == null ? void 0 : groupContext.status) != null ? _f : "normal"}`, {
        [`${prefixCls}-long`]: props.long,
        [`${prefixCls}-loading`]: props.loading,
        [`${prefixCls}-disabled`]: mergedDisabled.value,
        [`${prefixCls}-link`]: isString$3(props.href)
      }];
    });
    const handleClick = (ev) => {
      if (props.disabled || props.loading) {
        ev.preventDefault();
        return;
      }
      emit2("click", ev);
    };
    return {
      prefixCls,
      cls,
      mergedDisabled,
      handleClick
    };
  }
});
const _hoisted_1$s = ["href"];
const _hoisted_2$q = ["type", "disabled"];
function _sfc_render$13(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_loading = resolveComponent("icon-loading");
  return _ctx.href ? (openBlock(), createElementBlock("a", {
    key: 0,
    class: normalizeClass([_ctx.cls, {
      [`${_ctx.prefixCls}-only-icon`]: _ctx.$slots.icon && !_ctx.$slots.default
    }]),
    href: _ctx.mergedDisabled || _ctx.loading ? void 0 : _ctx.href,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [_ctx.loading || _ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-icon`)
  }, [_ctx.loading ? (openBlock(), createBlock(_component_icon_loading, {
    key: 0,
    spin: "true"
  })) : renderSlot(_ctx.$slots, "icon", {
    key: 1
  })], 2)) : createCommentVNode("v-if", true), renderSlot(_ctx.$slots, "default")], 10, _hoisted_1$s)) : (openBlock(), createElementBlock("button", {
    key: 1,
    class: normalizeClass([_ctx.cls, {
      [`${_ctx.prefixCls}-only-icon`]: _ctx.$slots.icon && !_ctx.$slots.default
    }]),
    type: _ctx.htmlType,
    disabled: _ctx.mergedDisabled,
    onClick: _cache[1] || (_cache[1] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [_ctx.loading || _ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-icon`)
  }, [_ctx.loading ? (openBlock(), createBlock(_component_icon_loading, {
    key: 0,
    spin: true
  })) : renderSlot(_ctx.$slots, "icon", {
    key: 1
  })], 2)) : createCommentVNode("v-if", true), renderSlot(_ctx.$slots, "default")], 10, _hoisted_2$q));
}
var _Button = /* @__PURE__ */ _export_sfc$1(_sfc_main$1b, [["render", _sfc_render$13]]);
const _sfc_main$1a = defineComponent({
  name: "ButtonGroup",
  props: {
    type: {
      type: String
    },
    status: {
      type: String
    },
    shape: {
      type: String
    },
    size: {
      type: String
    },
    disabled: {
      type: Boolean
    }
  },
  setup(props) {
    const {
      type,
      size: size2,
      status,
      disabled,
      shape
    } = toRefs(props);
    const prefixCls = getPrefixCls("btn-group");
    provide(buttonGroupInjectionKey, reactive({
      type,
      size: size2,
      shape,
      status,
      disabled
    }));
    return {
      prefixCls
    };
  }
});
function _sfc_render$12(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [renderSlot(_ctx.$slots, "default")], 2);
}
var ButtonGroup = /* @__PURE__ */ _export_sfc$1(_sfc_main$1a, [["render", _sfc_render$12]]);
const Button = Object.assign(_Button, {
  Group: ButtonGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Button.name, _Button);
    app.component(componentPrefix + ButtonGroup.name, ButtonGroup);
  }
});
var InputSearch = defineComponent({
  name: "InputSearch",
  props: {
    searchButton: {
      type: Boolean,
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    buttonText: {
      type: String
    },
    buttonProps: {
      type: Object
    }
  },
  emits: {
    search: (value, ev) => true
  },
  setup(props, {
    emit: emit2,
    slots
  }) {
    const {
      size: size2
    } = toRefs(props);
    const prefixCls = getPrefixCls("input-search");
    const {
      mergedSize
    } = useSize$1(size2);
    const inputRef = ref();
    const handleClick = (e2) => {
      if (inputRef.value.inputRef) {
        emit2("search", inputRef.value.inputRef.value, e2);
      }
    };
    const renderSuffix = () => {
      var _a2;
      return createVNode(Fragment, null, [props.loading ? createVNode(IconLoading, null, null) : createVNode(IconHover, {
        "onClick": handleClick
      }, {
        default: () => [createVNode(IconSearch, null, null)]
      }), (_a2 = slots.suffix) == null ? void 0 : _a2.call(slots)]);
    };
    const renderButton = () => {
      var _a2;
      let _slots = {};
      if (props.buttonText || slots["button-default"] || slots["button-icon"]) {
        _slots = {
          default: (_a2 = slots["button-default"]) != null ? _a2 : props.buttonText ? () => props.buttonText : void 0,
          icon: slots["button-icon"]
        };
      } else {
        _slots = {
          icon: () => createVNode(IconSearch, null, null)
        };
      }
      return createVNode(Button, mergeProps({
        "type": "primary",
        "class": `${prefixCls}-btn`,
        "disabled": props.disabled,
        "size": mergedSize.value,
        "loading": props.loading
      }, props.buttonProps, {
        "onClick": handleClick
      }), _slots);
    };
    const render2 = () => createVNode(_Input, {
      "ref": inputRef,
      "class": prefixCls,
      "size": mergedSize.value,
      "disabled": props.disabled
    }, {
      prepend: slots.prepend,
      prefix: slots.prefix,
      suffix: props.searchButton ? slots.suffix : renderSuffix,
      append: props.searchButton ? renderButton : slots.append
    });
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.focus();
    },
    blur() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.blur();
    }
  },
  render() {
    return this.render();
  }
});
const _sfc_main$19 = defineComponent({
  name: "IconEye",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-eye`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$r = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$p = /* @__PURE__ */ createBaseVNode("path", {
  "clip-rule": "evenodd",
  d: "M24 37c6.627 0 12.627-4.333 18-13-5.373-8.667-11.373-13-18-13-6.627 0-12.627 4.333-18 13 5.373 8.667 11.373 13 18 13Z"
}, null, -1);
const _hoisted_3$n = /* @__PURE__ */ createBaseVNode("path", {
  d: "M29 24a5 5 0 1 1-10 0 5 5 0 0 1 10 0Z"
}, null, -1);
const _hoisted_4$9 = [_hoisted_2$p, _hoisted_3$n];
function _sfc_render$11(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_4$9, 14, _hoisted_1$r);
}
var _IconEye = /* @__PURE__ */ _export_sfc$1(_sfc_main$19, [["render", _sfc_render$11]]);
const IconEye = Object.assign(_IconEye, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconEye.name, _IconEye);
  }
});
const _sfc_main$18 = defineComponent({
  name: "IconEyeInvisible",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-eye-invisible`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$q = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$o = /* @__PURE__ */ createBaseVNode("path", {
  d: "M14 14.5c-2.69 2-5.415 5.33-8 9.5 5.373 8.667 11.373 13 18 13 3.325 0 6.491-1.09 9.5-3.271M17.463 12.5C19 11 21.75 11 24 11c6.627 0 12.627 4.333 18 13-1.766 2.848-3.599 5.228-5.5 7.14"
}, null, -1);
const _hoisted_3$m = /* @__PURE__ */ createBaseVNode("path", {
  d: "M29 24a5 5 0 1 1-10 0 5 5 0 0 1 10 0ZM6.852 7.103l34.294 34.294"
}, null, -1);
const _hoisted_4$8 = [_hoisted_2$o, _hoisted_3$m];
function _sfc_render$10(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_4$8, 14, _hoisted_1$q);
}
var _IconEyeInvisible = /* @__PURE__ */ _export_sfc$1(_sfc_main$18, [["render", _sfc_render$10]]);
const IconEyeInvisible = Object.assign(_IconEyeInvisible, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconEyeInvisible.name, _IconEyeInvisible);
  }
});
const _sfc_main$17 = defineComponent({
  name: "InputPassword",
  components: {
    IconEye,
    IconEyeInvisible,
    AIconHover: IconHover,
    AInput: _Input
  },
  props: {
    invisibleButton: {
      type: Boolean,
      default: true
    }
  },
  setup() {
    const inputRef = ref();
    const invisible = ref(true);
    const handleInvisible = () => {
      invisible.value = !invisible.value;
    };
    return {
      inputRef,
      invisible,
      handleInvisible
    };
  },
  methods: {
    focus() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.focus();
    },
    blur() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.blur();
    }
  }
});
function _sfc_render$$(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_eye = resolveComponent("icon-eye");
  const _component_icon_eye_invisible = resolveComponent("icon-eye-invisible");
  const _component_a_icon_hover = resolveComponent("a-icon-hover");
  const _component_a_input = resolveComponent("a-input");
  return openBlock(), createBlock(_component_a_input, {
    ref: "inputRef",
    type: _ctx.invisible ? "password" : "text"
  }, createSlots({
    _: 2
  }, [_ctx.$slots.prepend ? {
    name: "prepend",
    fn: withCtx(() => [renderSlot(_ctx.$slots, "prepend")])
  } : void 0, _ctx.$slots.prefix ? {
    name: "prefix",
    fn: withCtx(() => [renderSlot(_ctx.$slots, "prefix")])
  } : void 0, _ctx.invisibleButton || _ctx.$slots.suffix ? {
    name: "suffix",
    fn: withCtx(() => [_ctx.invisibleButton ? (openBlock(), createBlock(_component_a_icon_hover, {
      key: 0,
      onClick: _ctx.handleInvisible,
      onMousedown: _cache[0] || (_cache[0] = withModifiers(() => {
      }, ["prevent"])),
      onMouseup: _cache[1] || (_cache[1] = withModifiers(() => {
      }, ["prevent"]))
    }, {
      default: withCtx(() => [!_ctx.invisible ? (openBlock(), createBlock(_component_icon_eye, {
        key: 0
      })) : (openBlock(), createBlock(_component_icon_eye_invisible, {
        key: 1
      }))]),
      _: 1
    }, 8, ["onClick"])) : createCommentVNode("v-if", true), renderSlot(_ctx.$slots, "suffix")])
  } : void 0, _ctx.$slots.append ? {
    name: "append",
    fn: withCtx(() => [renderSlot(_ctx.$slots, "append")])
  } : void 0]), 1032, ["type"]);
}
var InputPassword = /* @__PURE__ */ _export_sfc$1(_sfc_main$17, [["render", _sfc_render$$]]);
const _sfc_main$16 = defineComponent({
  name: "InputGroup",
  setup() {
    const prefixCls = getPrefixCls("input-group");
    return {
      prefixCls
    };
  }
});
function _sfc_render$_(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [renderSlot(_ctx.$slots, "default")], 2);
}
var InputGroup = /* @__PURE__ */ _export_sfc$1(_sfc_main$16, [["render", _sfc_render$_]]);
const Input = Object.assign(_Input, {
  Search: InputSearch,
  Password: InputPassword,
  Group: InputGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Input.name, _Input);
    app.component(componentPrefix + InputGroup.name, InputGroup);
    app.component(componentPrefix + InputSearch.name, InputSearch);
    app.component(componentPrefix + InputPassword.name, InputPassword);
  }
});
var __defProp$j = Object.defineProperty;
var __getOwnPropSymbols$j = Object.getOwnPropertySymbols;
var __hasOwnProp$j = Object.prototype.hasOwnProperty;
var __propIsEnum$j = Object.prototype.propertyIsEnumerable;
var __defNormalProp$j = (obj, key, value) => key in obj ? __defProp$j(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$j = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$j.call(b2, prop))
      __defNormalProp$j(a, prop, b2[prop]);
  if (__getOwnPropSymbols$j)
    for (var prop of __getOwnPropSymbols$j(b2)) {
      if (__propIsEnum$j.call(b2, prop))
        __defNormalProp$j(a, prop, b2[prop]);
    }
  return a;
};
const getDocumentSize = () => {
  const {
    body
  } = document;
  const html = document.documentElement;
  let topBody;
  try {
    const topWindow = window.top || window.self || window;
    topBody = topWindow.document.body;
  } catch {
  }
  const size2 = {
    height: Math.max(body.scrollHeight, body.offsetHeight, html.clientHeight, html.scrollHeight, html.offsetHeight, (topBody == null ? void 0 : topBody.scrollHeight) || 0, (topBody == null ? void 0 : topBody.clientHeight) || 0),
    width: Math.max(body.scrollWidth, body.offsetWidth, html.clientWidth, html.scrollWidth, html.offsetWidth, (topBody == null ? void 0 : topBody.scrollWidth) || 0, (topBody == null ? void 0 : topBody.clientWidth) || 0)
  };
  return size2;
};
const getViewPortSize = () => {
  const {
    height,
    width
  } = getDocumentSize();
  return {
    width: Math.min(width, window.innerWidth),
    height: Math.min(height, window.innerHeight)
  };
};
const getElementScrollRect = (element, containerRect) => {
  var _a2, _b2;
  const rect = element.getBoundingClientRect();
  return {
    top: rect.top,
    bottom: rect.bottom,
    left: rect.left,
    right: rect.right,
    scrollTop: rect.top - containerRect.top,
    scrollBottom: rect.bottom - containerRect.top,
    scrollLeft: rect.left - containerRect.left,
    scrollRight: rect.right - containerRect.left,
    width: (_a2 = element.offsetWidth) != null ? _a2 : element.clientWidth,
    height: (_b2 = element.offsetHeight) != null ? _b2 : element.clientHeight
  };
};
const getBoundaryPosition = (position) => {
  switch (position) {
    case "top":
    case "tl":
    case "tr":
      return "top";
    case "bottom":
    case "bl":
    case "br":
      return "bottom";
    case "left":
    case "lt":
    case "lb":
      return "left";
    case "right":
    case "rt":
    case "rb":
      return "right";
    default:
      return "top";
  }
};
const changePosition = (position, direction) => {
  switch (direction) {
    case "top":
      switch (position) {
        case "bottom":
          return "top";
        case "bl":
          return "tl";
        case "br":
          return "tr";
        default:
          return position;
      }
    case "bottom":
      switch (position) {
        case "top":
          return "bottom";
        case "tl":
          return "bl";
        case "tr":
          return "br";
        default:
          return position;
      }
    case "left":
      switch (position) {
        case "right":
          return "left";
        case "rt":
          return "lt";
        case "rb":
          return "lb";
        default:
          return position;
      }
    case "right":
      switch (position) {
        case "left":
          return "right";
        case "lt":
          return "rt";
        case "lb":
          return "rb";
        default:
          return position;
      }
    default:
      return position;
  }
};
const getFitPosition = (position, popupPosition, {
  containerRect,
  triggerRect,
  popupRect,
  offset,
  translate: translate2
}) => {
  const direction = getBoundaryPosition(position);
  const viewPortSize = getViewPortSize();
  const viewPortBoundary = {
    top: containerRect.top + popupPosition.top,
    bottom: viewPortSize.height - (containerRect.top + popupPosition.top + popupRect.height),
    left: containerRect.left + popupPosition.left,
    right: viewPortSize.width - (containerRect.left + popupPosition.left + popupRect.width)
  };
  let finalPosition = position;
  if (direction === "top" && viewPortBoundary.top < 0) {
    if (triggerRect.top > popupRect.height) {
      popupPosition.top = -containerRect.top;
    } else {
      const fitPosition = getPopupOffset("bottom", triggerRect, popupRect, {
        offset,
        translate: translate2
      });
      if (viewPortSize.height - (containerRect.top + fitPosition.top + popupRect.height) > 0) {
        finalPosition = changePosition(position, "bottom");
        popupPosition.top = fitPosition.top;
      }
    }
  }
  if (direction === "bottom" && viewPortBoundary.bottom < 0) {
    if (viewPortSize.height - triggerRect.bottom > popupRect.height) {
      popupPosition.top = -containerRect.top + (viewPortSize.height - popupRect.height);
    } else {
      const fitPosition = getPopupOffset("top", triggerRect, popupRect, {
        offset,
        translate: translate2
      });
      if (containerRect.top + fitPosition.top > 0) {
        finalPosition = changePosition(position, "top");
        popupPosition.top = fitPosition.top;
      }
    }
  }
  if (direction === "left" && viewPortBoundary.left < 0) {
    if (triggerRect.left > popupRect.width) {
      popupPosition.left = -containerRect.left;
    } else {
      const fitPosition = getPopupOffset("right", triggerRect, popupRect, {
        offset,
        translate: translate2
      });
      if (viewPortSize.width - (containerRect.left + fitPosition.left + popupRect.width) > 0) {
        finalPosition = changePosition(position, "right");
        popupPosition.left = fitPosition.left;
      }
    }
  }
  if (direction === "right" && viewPortBoundary.right < 0) {
    if (viewPortSize.width - triggerRect.right > popupRect.width) {
      popupPosition.left = -containerRect.left + (viewPortSize.width - popupRect.width);
    } else {
      const fitPosition = getPopupOffset("left", triggerRect, popupRect, {
        offset,
        translate: translate2
      });
      if (containerRect.left + fitPosition.left > 0) {
        finalPosition = changePosition(position, "left");
        popupPosition.left = fitPosition.left;
      }
    }
  }
  if (direction === "top" || direction === "bottom") {
    if (viewPortBoundary.left < 0) {
      popupPosition.left = -containerRect.left;
    } else if (viewPortBoundary.right < 0) {
      popupPosition.left = -containerRect.left + (viewPortSize.width - popupRect.width);
    }
  }
  if (direction === "left" || direction === "right") {
    if (viewPortBoundary.top < 0) {
      popupPosition.top = -containerRect.top;
    } else if (viewPortBoundary.bottom < 0) {
      popupPosition.top = -containerRect.top + (viewPortSize.height - popupRect.height);
    }
  }
  return {
    popupPosition,
    position: finalPosition
  };
};
const getPopupOffset = (position, triggerRect, popupRect, {
  offset = 0,
  translate: translate2 = [0, 0]
} = {}) => {
  var _a2;
  const _translate = (_a2 = isArray$4(translate2) ? translate2 : translate2[position]) != null ? _a2 : [0, 0];
  switch (position) {
    case "top":
      return {
        left: triggerRect.scrollLeft + Math.round(triggerRect.width / 2) - Math.round(popupRect.width / 2) + _translate[0],
        top: triggerRect.scrollTop - popupRect.height - offset + _translate[1]
      };
    case "tl":
      return {
        left: triggerRect.scrollLeft + _translate[0],
        top: triggerRect.scrollTop - popupRect.height - offset + _translate[1]
      };
    case "tr":
      return {
        left: triggerRect.scrollRight - popupRect.width + _translate[0],
        top: triggerRect.scrollTop - popupRect.height - offset + _translate[1]
      };
    case "bottom":
      return {
        left: triggerRect.scrollLeft + Math.round(triggerRect.width / 2) - Math.round(popupRect.width / 2) + _translate[0],
        top: triggerRect.scrollBottom + offset + _translate[1]
      };
    case "bl":
      return {
        left: triggerRect.scrollLeft + _translate[0],
        top: triggerRect.scrollBottom + offset + _translate[1]
      };
    case "br":
      return {
        left: triggerRect.scrollRight - popupRect.width + _translate[0],
        top: triggerRect.scrollBottom + offset + _translate[1]
      };
    case "left":
      return {
        left: triggerRect.scrollLeft - popupRect.width - offset + _translate[0],
        top: triggerRect.scrollTop + Math.round(triggerRect.height / 2) - Math.round(popupRect.height / 2) + _translate[1]
      };
    case "lt":
      return {
        left: triggerRect.scrollLeft - popupRect.width - offset + _translate[0],
        top: triggerRect.scrollTop + _translate[1]
      };
    case "lb":
      return {
        left: triggerRect.scrollLeft - popupRect.width - offset + _translate[0],
        top: triggerRect.scrollBottom - popupRect.height + _translate[1]
      };
    case "right":
      return {
        left: triggerRect.scrollRight + offset + _translate[0],
        top: triggerRect.scrollTop + Math.round(triggerRect.height / 2) - Math.round(popupRect.height / 2) + _translate[1]
      };
    case "rt":
      return {
        left: triggerRect.scrollRight + offset + _translate[0],
        top: triggerRect.scrollTop + _translate[1]
      };
    case "rb":
      return {
        left: triggerRect.scrollRight + offset + _translate[0],
        top: triggerRect.scrollBottom - popupRect.height + _translate[1]
      };
    default:
      return {
        left: 0,
        top: 0
      };
  }
};
const getTransformOrigin = (position) => {
  let originX = "0";
  if (["top", "bottom"].includes(position)) {
    originX = "50%";
  } else if (["left", "lt", "lb", "tr", "br"].includes(position)) {
    originX = "100%";
  }
  let originY = "0";
  if (["left", "right"].includes(position)) {
    originY = "50%";
  } else if (["top", "tl", "tr", "lt", "rt"].includes(position)) {
    originY = "100%";
  }
  return `${originX} ${originY}`;
};
const getPopupStyle = (position, containerRect, triggerRect, popupRect, {
  offset = 0,
  translate: translate2 = [0, 0],
  customStyle = {},
  autoFitPosition = false
} = {}) => {
  let finalPosition = position;
  let popupPosition = getPopupOffset(position, triggerRect, popupRect, {
    offset,
    translate: translate2
  });
  if (autoFitPosition) {
    const result = getFitPosition(position, popupPosition, {
      containerRect,
      popupRect,
      triggerRect,
      offset,
      translate: translate2
    });
    popupPosition = result.popupPosition;
    finalPosition = result.position;
  }
  const style2 = __spreadValues$j({
    left: `${popupPosition.left}px`,
    top: `${popupPosition.top}px`
  }, customStyle);
  return {
    style: style2,
    position: finalPosition
  };
};
const getArrowStyle = (position, triggerRect, popupRect, {
  customStyle = {}
}) => {
  if (["top", "tl", "tr", "bottom", "bl", "br"].includes(position)) {
    let offsetLeft = Math.abs(triggerRect.scrollLeft + triggerRect.width / 2 - popupRect.scrollLeft);
    if (offsetLeft > popupRect.width - 8) {
      if (triggerRect.width > popupRect.width) {
        offsetLeft = popupRect.width / 2;
      } else {
        offsetLeft = popupRect.width - 8;
      }
    }
    if (["top", "tl", "tr"].includes(position)) {
      return __spreadValues$j({
        left: `${offsetLeft}px`,
        bottom: "0",
        transform: "translate(-50%,50%) rotate(45deg)"
      }, customStyle);
    }
    return __spreadValues$j({
      left: `${offsetLeft}px`,
      top: "0",
      transform: "translate(-50%,-50%) rotate(45deg)"
    }, customStyle);
  }
  let offsetTop = Math.abs(triggerRect.scrollTop + triggerRect.height / 2 - popupRect.scrollTop);
  if (offsetTop > popupRect.height - 8) {
    if (triggerRect.height > popupRect.height) {
      offsetTop = popupRect.height / 2;
    } else {
      offsetTop = popupRect.height - 8;
    }
  }
  if (["left", "lt", "lb"].includes(position)) {
    return __spreadValues$j({
      top: `${offsetTop}px`,
      right: "0",
      transform: "translate(50%,-50%) rotate(45deg)"
    }, customStyle);
  }
  return __spreadValues$j({
    top: `${offsetTop}px`,
    left: "0",
    transform: "translate(-50%,-50%) rotate(45deg)"
  }, customStyle);
};
const isScrollElement = (element) => {
  return element.scrollHeight > element.offsetHeight || element.scrollWidth > element.offsetWidth;
};
const getScrollElements = (container) => {
  var _a2;
  const scrollElements = [];
  let element = container;
  while (element && element !== document.documentElement) {
    if (isScrollElement(element)) {
      scrollElements.push(element);
    }
    element = (_a2 = element.parentElement) != null ? _a2 : void 0;
  }
  return scrollElements;
};
const useFirstElement = () => {
  const children = {};
  const firstElement = ref();
  const getFirstElement = () => {
    const element = getFirstElementFromChildren(children.value);
    if (element !== firstElement.value) {
      firstElement.value = element;
    }
  };
  onMounted(() => getFirstElement());
  onUpdated(() => getFirstElement());
  return {
    children,
    firstElement
  };
};
var ResizeObserver$1 = defineComponent({
  name: "ResizeObserver",
  props: {
    watchOnUpdated: Boolean
  },
  emits: ["resize"],
  setup(props, {
    emit: emit2,
    slots
  }) {
    const {
      children,
      firstElement
    } = useFirstElement();
    let resizeObserver;
    const createResizeObserver = (target2) => {
      if (!target2)
        return;
      resizeObserver = new index$t((entries) => {
        const entry = entries[0];
        emit2("resize", entry);
      });
      resizeObserver.observe(target2);
    };
    const destroyResizeObserver = () => {
      if (resizeObserver) {
        resizeObserver.disconnect();
        resizeObserver = null;
      }
    };
    watch(firstElement, (element) => {
      if (resizeObserver)
        destroyResizeObserver();
      if (element) {
        createResizeObserver(element);
      }
    });
    onBeforeUnmount(() => {
      if (resizeObserver)
        destroyResizeObserver();
    });
    return () => {
      var _a2;
      children.value = (_a2 = slots.default) == null ? void 0 : _a2.call(slots);
      return children.value;
    };
  }
});
function usePickSlots(slots, slotName) {
  const slot = ref(slots[slotName]);
  onUpdated(() => {
    const newSlot = slots[slotName];
    if (slot.value !== newSlot) {
      slot.value = newSlot;
    }
  });
  return slot;
}
const triggerInjectionKey = Symbol("ArcoTrigger");
const POPUP_BASE_Z_INDEX = 1e3;
const MESSAGE_BASE_Z_INDEX = 5e3;
const Z_INDEX_STEP = 1;
class PopupManager {
  constructor() {
    this.popupStack = {
      popup: /* @__PURE__ */ new Set(),
      dialog: /* @__PURE__ */ new Set(),
      message: /* @__PURE__ */ new Set()
    };
    this.getNextZIndex = (type) => {
      const current = type === "message" ? Array.from(this.popupStack.message).pop() || MESSAGE_BASE_Z_INDEX : Array.from(this.popupStack.popup).pop() || POPUP_BASE_Z_INDEX;
      return current + Z_INDEX_STEP;
    };
    this.add = (type) => {
      const zIndex = this.getNextZIndex(type);
      this.popupStack[type].add(zIndex);
      if (type === "dialog") {
        this.popupStack.popup.add(zIndex);
      }
      return zIndex;
    };
    this.delete = (zIndex, type) => {
      this.popupStack[type].delete(zIndex);
      if (type === "dialog") {
        this.popupStack.popup.delete(zIndex);
      }
    };
    this.isLastDialog = (zIndex) => {
      if (this.popupStack.dialog.size > 1) {
        return zIndex === Array.from(this.popupStack.dialog).pop();
      }
      return true;
    };
  }
}
const popupManager = new PopupManager();
function usePopupManager(type, {
  visible,
  runOnMounted
} = {}) {
  const zIndex = ref(0);
  const open = () => {
    zIndex.value = popupManager.add(type);
  };
  const close = () => {
    popupManager.delete(zIndex.value, type);
  };
  const isLastDialog = () => {
    if (type === "dialog") {
      return popupManager.isLastDialog(zIndex.value);
    }
    return false;
  };
  watch(() => visible == null ? void 0 : visible.value, (visible2) => {
    if (visible2) {
      open();
    } else {
      close();
    }
  }, {
    immediate: true
  });
  if (runOnMounted) {
    onMounted(() => {
      open();
    });
    onBeforeUnmount(() => {
      close();
    });
  }
  return {
    zIndex: readonly(zIndex),
    open,
    close,
    isLastDialog
  };
}
const useResizeObserver = ({
  elementRef,
  onResize
}) => {
  let resizeObserver;
  const createResizeObserver = () => {
    if (!elementRef.value)
      return;
    resizeObserver = new index$t((entries) => {
      const entry = entries[0];
      isFunction$3(onResize) && onResize(entry);
    });
    resizeObserver.observe(elementRef.value);
  };
  const destroyResizeObserver = () => {
    if (resizeObserver) {
      resizeObserver.disconnect();
      resizeObserver = null;
    }
  };
  return {
    createResizeObserver,
    destroyResizeObserver
  };
};
var ClientOnly = defineComponent({
  name: "ClientOnly",
  setup(_2, {
    slots
  }) {
    const mounted = ref(false);
    onMounted(() => mounted.value = true);
    return () => {
      var _a2;
      if (mounted.value) {
        return (_a2 = slots.default) == null ? void 0 : _a2.call(slots);
      }
      return null;
    };
  }
});
const useTeleportContainer = ({
  popupContainer,
  visible,
  defaultContainer = "body",
  documentContainer
}) => {
  const teleportContainer = ref(popupContainer.value);
  const containerRef = ref();
  const getContainer = () => {
    const element = getElement(popupContainer.value);
    const _teleportContainer = element ? popupContainer.value : defaultContainer;
    const _containerElement = element != null ? element : documentContainer ? document.documentElement : getElement(defaultContainer);
    if (_teleportContainer !== teleportContainer.value) {
      teleportContainer.value = _teleportContainer;
    }
    if (_containerElement !== containerRef.value) {
      containerRef.value = _containerElement;
    }
  };
  onMounted(() => getContainer());
  watch(visible, (visible2) => {
    if (teleportContainer.value !== popupContainer.value && visible2) {
      getContainer();
    }
  });
  return {
    teleportContainer,
    containerRef
  };
};
var __defProp$i = Object.defineProperty;
var __defProps$9 = Object.defineProperties;
var __getOwnPropDescs$9 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$i = Object.getOwnPropertySymbols;
var __hasOwnProp$i = Object.prototype.hasOwnProperty;
var __propIsEnum$i = Object.prototype.propertyIsEnumerable;
var __defNormalProp$i = (obj, key, value) => key in obj ? __defProp$i(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$i = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$i.call(b2, prop))
      __defNormalProp$i(a, prop, b2[prop]);
  if (__getOwnPropSymbols$i)
    for (var prop of __getOwnPropSymbols$i(b2)) {
      if (__propIsEnum$i.call(b2, prop))
        __defNormalProp$i(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$9 = (a, b2) => __defProps$9(a, __getOwnPropDescs$9(b2));
const TRIGGER_EVENTS = ["onClick", "onMouseenter", "onMouseleave", "onFocusin", "onFocusout", "onContextmenu"];
var _Trigger = defineComponent({
  name: "Trigger",
  inheritAttrs: false,
  props: {
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    trigger: {
      type: [String, Array],
      default: "hover"
    },
    position: {
      type: String,
      default: "bottom"
    },
    disabled: {
      type: Boolean,
      default: false
    },
    popupOffset: {
      type: Number,
      default: 0
    },
    popupTranslate: {
      type: [Array, Object]
    },
    showArrow: {
      type: Boolean,
      default: false
    },
    alignPoint: {
      type: Boolean,
      default: false
    },
    popupHoverStay: {
      type: Boolean,
      default: true
    },
    blurToClose: {
      type: Boolean,
      default: true
    },
    clickToClose: {
      type: Boolean,
      default: true
    },
    clickOutsideToClose: {
      type: Boolean,
      default: true
    },
    unmountOnClose: {
      type: Boolean,
      default: true
    },
    contentClass: {
      type: [String, Array, Object]
    },
    contentStyle: {
      type: Object
    },
    arrowClass: {
      type: [String, Array, Object]
    },
    arrowStyle: {
      type: Object
    },
    popupStyle: {
      type: Object
    },
    animationName: {
      type: String,
      default: "fade-in"
    },
    duration: {
      type: [Number, Object]
    },
    mouseEnterDelay: {
      type: Number,
      default: 100
    },
    mouseLeaveDelay: {
      type: Number,
      default: 100
    },
    focusDelay: {
      type: Number,
      default: 0
    },
    autoFitPopupWidth: {
      type: Boolean,
      default: false
    },
    autoFitPopupMinWidth: {
      type: Boolean,
      default: false
    },
    autoFixPosition: {
      type: Boolean,
      default: true
    },
    popupContainer: {
      type: [String, Object]
    },
    updateAtScroll: {
      type: Boolean,
      default: false
    },
    autoFitTransformOrigin: {
      type: Boolean,
      default: false
    },
    hideEmpty: {
      type: Boolean,
      default: false
    },
    openedClass: {
      type: [String, Array, Object]
    },
    autoFitPosition: {
      type: Boolean,
      default: true
    },
    renderToBody: {
      type: Boolean,
      default: true
    },
    preventFocus: {
      type: Boolean,
      default: false
    },
    scrollToClose: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true,
    "show": () => true,
    "hide": () => true,
    "resize": () => true
  },
  setup(props, {
    emit: emit2,
    slots,
    attrs
  }) {
    const {
      popupContainer
    } = toRefs(props);
    const prefixCls = getPrefixCls("trigger");
    const popupAttrs = computed(() => omit(attrs, TRIGGER_EVENTS));
    const configCtx = inject(configProviderInjectionKey, void 0);
    const triggerMethods = computed(() => [].concat(props.trigger));
    const childrenRefs = /* @__PURE__ */ new Set();
    const triggerCtx = inject(triggerInjectionKey, void 0);
    const {
      children,
      firstElement
    } = useFirstElement();
    const popupRef = ref();
    const popupVisible = ref(props.defaultPopupVisible);
    const popupPosition = ref(props.position);
    const popupStyle = ref({});
    const transformStyle = ref({});
    const arrowStyle = ref({});
    const arrowRef = ref();
    const mousePosition = ref({
      top: 0,
      left: 0
    });
    const computedVisible = computed(() => {
      var _a2;
      return (_a2 = props.popupVisible) != null ? _a2 : popupVisible.value;
    });
    const {
      teleportContainer,
      containerRef
    } = useTeleportContainer({
      popupContainer,
      visible: computedVisible,
      documentContainer: true
    });
    const {
      zIndex
    } = usePopupManager("popup", {
      visible: computedVisible
    });
    let delayTimer = 0;
    let outsideListener = false;
    let windowListener = false;
    const cleanDelayTimer = () => {
      if (delayTimer) {
        window.clearTimeout(delayTimer);
        delayTimer = 0;
      }
    };
    const updateMousePosition = (e2) => {
      if (props.alignPoint) {
        const {
          pageX,
          pageY
        } = e2;
        mousePosition.value = {
          top: pageY,
          left: pageX
        };
      }
    };
    const updatePopupStyle = () => {
      if (!firstElement.value || !popupRef.value || !containerRef.value) {
        return;
      }
      const containerRect = containerRef.value.getBoundingClientRect();
      const triggerRect = props.alignPoint ? {
        top: mousePosition.value.top,
        bottom: mousePosition.value.top,
        left: mousePosition.value.left,
        right: mousePosition.value.left,
        scrollTop: mousePosition.value.top,
        scrollBottom: mousePosition.value.top,
        scrollLeft: mousePosition.value.left,
        scrollRight: mousePosition.value.left,
        width: 0,
        height: 0
      } : getElementScrollRect(firstElement.value, containerRect);
      const getPopupRect = () => getElementScrollRect(popupRef.value, containerRect);
      const popupRect = getPopupRect();
      const {
        style: style2,
        position
      } = getPopupStyle(props.position, containerRect, triggerRect, popupRect, {
        offset: props.popupOffset,
        translate: props.popupTranslate,
        customStyle: props.popupStyle,
        autoFitPosition: props.autoFitPosition
      });
      if (props.autoFitTransformOrigin) {
        transformStyle.value = {
          transformOrigin: getTransformOrigin(position)
        };
      }
      if (props.autoFitPopupMinWidth) {
        style2.minWidth = `${triggerRect.width}px`;
      } else if (props.autoFitPopupWidth) {
        style2.width = `${triggerRect.width}px`;
      }
      if (popupPosition.value !== position) {
        popupPosition.value = position;
      }
      popupStyle.value = style2;
      if (props.showArrow) {
        nextTick(() => {
          arrowStyle.value = getArrowStyle(position, triggerRect, getPopupRect(), {
            customStyle: props.arrowStyle
          });
        });
      }
    };
    const changeVisible = (visible, delay) => {
      if (visible === computedVisible.value && delayTimer === 0) {
        return;
      }
      const update = () => {
        popupVisible.value = visible;
        emit2("update:popupVisible", visible);
        emit2("popupVisibleChange", visible);
        if (visible) {
          nextTick(() => {
            updatePopupStyle();
          });
        }
      };
      if (delay) {
        cleanDelayTimer();
        if (visible !== computedVisible.value) {
          delayTimer = window.setTimeout(update, delay);
        }
      } else {
        update();
      }
    };
    const handleClick = (e2) => {
      var _a2;
      (_a2 = attrs.onClick) == null ? void 0 : _a2.call(attrs, e2);
      if (props.disabled || computedVisible.value && !props.clickToClose) {
        return;
      }
      if (triggerMethods.value.includes("click")) {
        updateMousePosition(e2);
        changeVisible(!computedVisible.value);
      } else if (triggerMethods.value.includes("contextMenu") && computedVisible.value) {
        changeVisible(false);
      }
    };
    const handleMouseEnter = (e2) => {
      var _a2;
      (_a2 = attrs.onMouseenter) == null ? void 0 : _a2.call(attrs, e2);
      if (props.disabled || !triggerMethods.value.includes("hover")) {
        return;
      }
      updateMousePosition(e2);
      changeVisible(true, props.mouseEnterDelay);
    };
    const handleMouseEnterWithContext = (e2) => {
      triggerCtx == null ? void 0 : triggerCtx.onMouseenter(e2);
      handleMouseEnter(e2);
    };
    const handleMouseLeave = (e2) => {
      var _a2;
      (_a2 = attrs.onMouseleave) == null ? void 0 : _a2.call(attrs, e2);
      if (props.disabled || !triggerMethods.value.includes("hover")) {
        return;
      }
      changeVisible(false, props.mouseLeaveDelay);
    };
    const handleMouseLeaveWithContext = (e2) => {
      triggerCtx == null ? void 0 : triggerCtx.onMouseleave(e2);
      handleMouseLeave(e2);
    };
    const handleFocusin = (e2) => {
      var _a2;
      (_a2 = attrs.onFocusin) == null ? void 0 : _a2.call(attrs, e2);
      if (props.disabled || !triggerMethods.value.includes("focus")) {
        return;
      }
      changeVisible(true, props.focusDelay);
    };
    const handleFocusout = (e2) => {
      var _a2;
      (_a2 = attrs.onFocusout) == null ? void 0 : _a2.call(attrs, e2);
      if (props.disabled || !triggerMethods.value.includes("focus")) {
        return;
      }
      if (!props.blurToClose) {
        return;
      }
      changeVisible(false);
    };
    const handleContextmenu = (e2) => {
      var _a2;
      (_a2 = attrs.onContextmenu) == null ? void 0 : _a2.call(attrs, e2);
      if (props.disabled || !triggerMethods.value.includes("contextMenu") || computedVisible.value && !props.clickToClose) {
        return;
      }
      updateMousePosition(e2);
      changeVisible(!computedVisible.value);
      e2.preventDefault();
    };
    const addChildRef = (ref2) => {
      childrenRefs.add(ref2);
      triggerCtx == null ? void 0 : triggerCtx.addChildRef(ref2);
    };
    const removeChildRef = (ref2) => {
      childrenRefs.delete(ref2);
      triggerCtx == null ? void 0 : triggerCtx.removeChildRef(ref2);
    };
    provide(triggerInjectionKey, reactive({
      onMouseenter: handleMouseEnterWithContext,
      onMouseleave: handleMouseLeaveWithContext,
      addChildRef,
      removeChildRef
    }));
    const removeOutsideListener = () => {
      off(document.documentElement, "mousedown", handleOutsideClick);
      outsideListener = false;
    };
    const contentSlot = usePickSlots(slots, "content");
    const hidePopup = computed(() => {
      var _a2;
      return props.hideEmpty && isEmptyChildren((_a2 = contentSlot.value) == null ? void 0 : _a2.call(contentSlot));
    });
    const handleOutsideClick = (e2) => {
      var _a2, _b2, _c2;
      if (((_a2 = firstElement.value) == null ? void 0 : _a2.contains(e2.target)) || ((_b2 = popupRef.value) == null ? void 0 : _b2.contains(e2.target))) {
        return;
      }
      for (const item of childrenRefs) {
        if ((_c2 = item.value) == null ? void 0 : _c2.contains(e2.target)) {
          return;
        }
      }
      removeOutsideListener();
      changeVisible(false);
    };
    const handleScroll2 = throttleByRaf(() => {
      if (computedVisible.value) {
        if (props.scrollToClose || (configCtx == null ? void 0 : configCtx.scrollToClose)) {
          changeVisible(false);
        } else {
          updatePopupStyle();
        }
      }
    });
    const removeWindowScroll = () => {
      off(window, "scroll", onWindowScroll);
      windowListener = false;
    };
    const onWindowScroll = throttleByRaf(() => {
      changeVisible(false);
      removeWindowScroll();
    });
    const handleResize = () => {
      if (computedVisible.value) {
        updatePopupStyle();
      }
    };
    const onTargetResize = () => {
      handleResize();
      emit2("resize");
    };
    const handlePopupMouseDown = (e2) => {
      if (props.preventFocus) {
        e2.preventDefault();
      }
    };
    triggerCtx == null ? void 0 : triggerCtx.addChildRef(popupRef);
    const triggerCls = computed(() => {
      return computedVisible.value ? props.openedClass : void 0;
    });
    let scrollElements;
    watch(computedVisible, (value) => {
      if (props.clickOutsideToClose) {
        if (!value && outsideListener) {
          removeOutsideListener();
        } else if (value && !outsideListener) {
          on(document.documentElement, "mousedown", handleOutsideClick);
          outsideListener = true;
        }
      }
      if (props.scrollToClose || (configCtx == null ? void 0 : configCtx.scrollToClose)) {
        on(window, "scroll", onWindowScroll);
        windowListener = true;
      }
      if (props.updateAtScroll || (configCtx == null ? void 0 : configCtx.updateAtScroll)) {
        if (value) {
          scrollElements = getScrollElements(firstElement.value);
          for (const item of scrollElements) {
            item.addEventListener("scroll", handleScroll2);
          }
        } else if (scrollElements) {
          for (const item of scrollElements) {
            item.removeEventListener("scroll", handleScroll2);
          }
          scrollElements = void 0;
        }
      }
      if (value) {
        mounted.value = true;
      }
    });
    watch(() => [props.autoFitPopupWidth, props.autoFitPopupMinWidth], () => {
      if (computedVisible.value) {
        updatePopupStyle();
      }
    });
    const {
      createResizeObserver,
      destroyResizeObserver
    } = useResizeObserver({
      elementRef: containerRef,
      onResize: handleResize
    });
    onMounted(() => {
      createResizeObserver();
      if (computedVisible.value) {
        updatePopupStyle();
        if (props.clickOutsideToClose && !outsideListener) {
          on(document.documentElement, "mousedown", handleOutsideClick);
          outsideListener = true;
        }
        if (props.updateAtScroll || (configCtx == null ? void 0 : configCtx.updateAtScroll)) {
          scrollElements = getScrollElements(firstElement.value);
          for (const item of scrollElements) {
            item.addEventListener("scroll", handleScroll2);
          }
        }
      }
    });
    onUpdated(() => {
      if (computedVisible.value) {
        updatePopupStyle();
      }
    });
    onDeactivated(() => {
      changeVisible(false);
    });
    onBeforeUnmount(() => {
      triggerCtx == null ? void 0 : triggerCtx.removeChildRef(popupRef);
      destroyResizeObserver();
      if (outsideListener) {
        removeOutsideListener();
      }
      if (windowListener) {
        removeWindowScroll();
      }
      if (scrollElements) {
        for (const item of scrollElements) {
          item.removeEventListener("scroll", handleScroll2);
        }
        scrollElements = void 0;
      }
    });
    const mounted = ref(computedVisible.value);
    const isAnimation = ref(false);
    const onAnimationStart = () => {
      isAnimation.value = true;
    };
    const handleShow = () => {
      isAnimation.value = false;
      if (computedVisible.value) {
        emit2("show");
      }
    };
    const handleHide = () => {
      isAnimation.value = false;
      if (!computedVisible.value) {
        mounted.value = false;
        emit2("hide");
      }
    };
    return () => {
      var _a2, _b2;
      children.value = (_b2 = (_a2 = slots.default) == null ? void 0 : _a2.call(slots)) != null ? _b2 : [];
      mergeFirstChild(children.value, {
        class: triggerCls.value,
        onClick: handleClick,
        onMouseenter: handleMouseEnter,
        onMouseleave: handleMouseLeave,
        onFocusin: handleFocusin,
        onFocusout: handleFocusout,
        onContextmenu: handleContextmenu
      });
      return createVNode(Fragment, null, [props.autoFixPosition ? createVNode(ResizeObserver$1, {
        "onResize": onTargetResize
      }, {
        default: () => [children.value]
      }) : children.value, createVNode(ClientOnly, null, {
        default: () => [createVNode(Teleport, {
          "to": teleportContainer.value,
          "disabled": !props.renderToBody
        }, {
          default: () => [(!props.unmountOnClose || computedVisible.value || mounted.value) && !hidePopup.value && createVNode(ResizeObserver$1, {
            "onResize": handleResize
          }, {
            default: () => [createVNode("div", mergeProps({
              "ref": popupRef,
              "class": [`${prefixCls}-popup`, `${prefixCls}-position-${popupPosition.value}`],
              "style": __spreadProps$9(__spreadValues$i({}, popupStyle.value), {
                zIndex: zIndex.value,
                pointerEvents: isAnimation.value ? "none" : "auto"
              }),
              "trigger-placement": popupPosition.value,
              "onMouseenter": handleMouseEnterWithContext,
              "onMouseleave": handleMouseLeaveWithContext,
              "onMousedown": handlePopupMouseDown
            }, popupAttrs.value), [createVNode(Transition, {
              "name": props.animationName,
              "duration": props.duration,
              "appear": true,
              "onBeforeEnter": onAnimationStart,
              "onAfterEnter": handleShow,
              "onBeforeLeave": onAnimationStart,
              "onAfterLeave": handleHide
            }, {
              default: () => {
                var _a22;
                return [withDirectives(createVNode("div", {
                  "class": `${prefixCls}-popup-wrapper`,
                  "style": transformStyle.value
                }, [createVNode("div", {
                  "class": [`${prefixCls}-content`, props.contentClass],
                  "style": props.contentStyle
                }, [(_a22 = slots.content) == null ? void 0 : _a22.call(slots)]), props.showArrow && createVNode("div", {
                  "ref": arrowRef,
                  "class": [`${prefixCls}-arrow`, props.arrowClass],
                  "style": arrowStyle.value
                }, null)]), [[vShow, computedVisible.value]])];
              }
            })])]
          })]
        })]
      })]);
    };
  }
});
const Trigger = Object.assign(_Trigger, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Trigger.name, _Trigger);
  }
});
const _sfc_main$15 = defineComponent({
  name: "IconEmpty",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-empty`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$p = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$n = /* @__PURE__ */ createBaseVNode("path", {
  d: "M24 5v6m7 1 4-4m-18 4-4-4m28.5 22H28s-1 3-4 3-4-3-4-3H6.5M40 41H8a2 2 0 0 1-2-2v-8.46a2 2 0 0 1 .272-1.007l6.15-10.54A2 2 0 0 1 14.148 18H33.85a2 2 0 0 1 1.728.992l6.149 10.541A2 2 0 0 1 42 30.541V39a2 2 0 0 1-2 2Z"
}, null, -1);
const _hoisted_3$l = [_hoisted_2$n];
function _sfc_render$Z(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$l, 14, _hoisted_1$p);
}
var _IconEmpty = /* @__PURE__ */ _export_sfc$1(_sfc_main$15, [["render", _sfc_render$Z]]);
const IconEmpty = Object.assign(_IconEmpty, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconEmpty.name, _IconEmpty);
  }
});
var Empty$1 = defineComponent({
  name: "Empty",
  props: {
    description: String,
    imgSrc: String
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("empty");
    const {
      t: t2
    } = useI18n$1();
    const configCtx = inject(configProviderInjectionKey, void 0);
    return () => {
      var _a2, _b2, _c2, _d;
      if ((configCtx == null ? void 0 : configCtx.slots.empty) && !(slots.image || props.imgSrc)) {
        return configCtx.slots.empty();
      }
      return createVNode("div", {
        "class": prefixCls
      }, [createVNode("div", {
        "class": `${prefixCls}-image`
      }, [(_b2 = (_a2 = slots.image) == null ? void 0 : _a2.call(slots)) != null ? _b2 : props.imgSrc ? createVNode("img", {
        "src": props.imgSrc,
        "alt": props.description || "empty"
      }, null) : createVNode(IconEmpty, null, null)]), createVNode("div", {
        "class": `${prefixCls}-description`
      }, [(_d = (_c2 = slots.default) == null ? void 0 : _c2.call(slots)) != null ? _d : props.description || t2("empty.description")])]);
    };
  }
});
const Empty = Object.assign(Empty$1, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + Empty$1.name, Empty$1);
  }
});
const DOT_NUMBER = 5;
var DotLoading = defineComponent({
  name: "DotLoading",
  props: {
    size: {
      type: Number
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("dot-loading");
    return () => {
      const style2 = props.size ? {
        width: `${props.size}px`,
        height: `${props.size}px`
      } : {};
      return createVNode("div", {
        "class": prefixCls,
        "style": {
          width: props.size ? `${props.size * 7}px` : void 0,
          height: props.size ? `${props.size}px` : void 0
        }
      }, [Array(DOT_NUMBER).fill(1).map((_2, index2) => createVNode("div", {
        "class": `${prefixCls}-item`,
        "key": index2,
        "style": style2
      }, null))]);
    };
  }
});
var _Spin = defineComponent({
  name: "Spin",
  props: {
    size: {
      type: Number
    },
    loading: Boolean,
    dot: Boolean,
    tip: String
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("spin");
    const configCtx = inject(configProviderInjectionKey, void 0);
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-loading`]: props.loading,
      [`${prefixCls}-with-tip`]: props.tip && !slots.default
    }]);
    const renderIcon = () => {
      if (slots.icon) {
        const iconVNode = getFirstComponent(slots.icon());
        if (iconVNode) {
          return cloneVNode(iconVNode, {
            spin: true
          });
        }
      }
      if (slots.element) {
        return slots.element();
      }
      if (props.dot) {
        return createVNode(DotLoading, {
          "size": props.size
        }, null);
      }
      if (configCtx == null ? void 0 : configCtx.slots.loading) {
        return configCtx.slots.loading();
      }
      return createVNode(IconLoading, {
        "spin": true,
        "size": props.size
      }, null);
    };
    const renderSpinIcon = () => {
      const style2 = props.size ? {
        fontSize: `${props.size}px`
      } : void 0;
      return createVNode(Fragment, null, [createVNode("div", {
        "class": `${prefixCls}-icon`,
        "style": style2
      }, [renderIcon()]), props.tip && createVNode("div", {
        "class": `${prefixCls}-tip`
      }, [props.tip])]);
    };
    return () => createVNode("div", {
      "class": cls.value
    }, [slots.default ? createVNode(Fragment, null, [slots.default(), props.loading && createVNode("div", {
      "class": `${prefixCls}-mask`
    }, [createVNode("div", {
      "class": `${prefixCls}-mask-icon`
    }, [renderSpinIcon()])])]) : renderSpinIcon()]);
  }
});
const Spin = Object.assign(_Spin, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Spin.name, _Spin);
  }
});
const _sfc_main$14 = defineComponent({
  name: "Thumb",
  props: {
    data: {
      type: Object
    },
    direction: {
      type: String,
      default: "horizontal"
    },
    alwaysShow: {
      type: Boolean,
      default: false
    },
    both: {
      type: Boolean,
      default: false
    }
  },
  emits: ["scroll"],
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("scrollbar");
    const visible = ref(false);
    const trackRef = ref();
    const thumbRef = ref();
    const thumbMap = computed(() => {
      if (props.direction === "horizontal") {
        return {
          size: "width",
          direction: "left",
          offset: "offsetWidth",
          client: "clientX"
        };
      }
      return {
        size: "height",
        direction: "top",
        offset: "offsetHeight",
        client: "clientY"
      };
    });
    const offset = ref(0);
    const isDragging = ref(false);
    const mouseOffset = ref(0);
    const thumbStyle = computed(() => {
      var _a2, _b2;
      return {
        [thumbMap.value.size]: `${(_b2 = (_a2 = props.data) == null ? void 0 : _a2.thumbSize) != null ? _b2 : 0}px`,
        [thumbMap.value.direction]: `${offset.value}px`
      };
    });
    const handleThumbMouseDown = (ev) => {
      ev.preventDefault();
      if (thumbRef.value) {
        mouseOffset.value = ev[thumbMap.value.client] - thumbRef.value.getBoundingClientRect()[thumbMap.value.direction];
        isDragging.value = true;
        on(window, "mousemove", handleMouseMove);
        on(window, "mouseup", handleMouseUp);
        on(window, "contextmenu", handleMouseUp);
      }
    };
    const handleTrackClick = (ev) => {
      var _a2, _b2, _c2, _d;
      ev.preventDefault();
      if (thumbRef.value) {
        const _offset = getLegalOffset(ev[thumbMap.value.client] > thumbRef.value.getBoundingClientRect()[thumbMap.value.direction] ? offset.value + ((_b2 = (_a2 = props.data) == null ? void 0 : _a2.thumbSize) != null ? _b2 : 0) : offset.value - ((_d = (_c2 = props.data) == null ? void 0 : _c2.thumbSize) != null ? _d : 0));
        if (_offset !== offset.value) {
          offset.value = _offset;
          emit2("scroll", _offset);
        }
      }
    };
    const getLegalOffset = (offset2) => {
      if (offset2 < 0) {
        return 0;
      }
      if (props.data && offset2 > props.data.max) {
        return props.data.max;
      }
      return offset2;
    };
    const handleMouseMove = (ev) => {
      if (trackRef.value && thumbRef.value) {
        const _offset = getLegalOffset(ev[thumbMap.value.client] - trackRef.value.getBoundingClientRect()[thumbMap.value.direction] - mouseOffset.value);
        if (_offset !== offset.value) {
          offset.value = _offset;
          emit2("scroll", _offset);
        }
      }
    };
    const handleMouseUp = () => {
      isDragging.value = false;
      off(window, "mousemove", handleMouseMove);
      off(window, "mouseup", handleMouseUp);
    };
    const setOffset = (_offset) => {
      if (!isDragging.value) {
        _offset = getLegalOffset(_offset);
        if (_offset !== offset.value) {
          offset.value = _offset;
        }
      }
    };
    const thumbCls = computed(() => [`${prefixCls}-thumb`, `${prefixCls}-thumb-direction-${props.direction}`, {
      [`${prefixCls}-thumb-dragging`]: isDragging.value
    }]);
    return {
      visible,
      trackRef,
      thumbRef,
      prefixCls,
      thumbCls,
      thumbStyle,
      handleThumbMouseDown,
      handleTrackClick,
      setOffset
    };
  }
});
function _sfc_render$Y(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(Transition, null, {
    default: withCtx(() => [createBaseVNode("div", {
      ref: "trackRef",
      class: normalizeClass([`${_ctx.prefixCls}-track`, `${_ctx.prefixCls}-track-direction-${_ctx.direction}`]),
      onMousedown: _cache[1] || (_cache[1] = withModifiers((...args) => _ctx.handleTrackClick && _ctx.handleTrackClick(...args), ["self"]))
    }, [createBaseVNode("div", {
      ref: "thumbRef",
      class: normalizeClass(_ctx.thumbCls),
      style: normalizeStyle$1(_ctx.thumbStyle),
      onMousedown: _cache[0] || (_cache[0] = (...args) => _ctx.handleThumbMouseDown && _ctx.handleThumbMouseDown(...args))
    }, [createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-thumb-bar`)
    }, null, 2)], 38)], 34)]),
    _: 1
  });
}
var Thumb = /* @__PURE__ */ _export_sfc$1(_sfc_main$14, [["render", _sfc_render$Y]]);
const THUMB_MIN_SIZE = 20;
const TRACK_SIZE = 15;
const _sfc_main$13 = defineComponent({
  name: "Scrollbar",
  components: {
    ResizeObserver: ResizeObserver$1,
    Thumb
  },
  inheritAttrs: false,
  props: {
    type: {
      type: String,
      default: "embed"
    },
    outerClass: [String, Object, Array],
    outerStyle: {
      type: [String, Object, Array]
    },
    hide: {
      type: Boolean,
      default: false
    },
    disableHorizontal: {
      type: Boolean,
      default: false
    },
    disableVertical: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    scroll: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("scrollbar");
    const containerRef = ref();
    const horizontalData = ref();
    const verticalData = ref();
    const horizontalThumbRef = ref();
    const verticalThumbRef = ref();
    const _hasHorizontalScrollbar = ref(false);
    const _hasVerticalScrollbar = ref(false);
    const hasHorizontalScrollbar = computed(() => _hasHorizontalScrollbar.value && !props.disableHorizontal);
    const hasVerticalScrollbar = computed(() => _hasVerticalScrollbar.value && !props.disableVertical);
    const isBoth = ref(false);
    const getContainerSize = () => {
      var _a2, _b2, _c2, _d, _e, _f;
      if (containerRef.value) {
        const {
          clientWidth,
          clientHeight,
          offsetWidth,
          offsetHeight,
          scrollWidth,
          scrollHeight,
          scrollTop,
          scrollLeft
        } = containerRef.value;
        _hasHorizontalScrollbar.value = scrollWidth > clientWidth;
        _hasVerticalScrollbar.value = scrollHeight > clientHeight;
        isBoth.value = hasHorizontalScrollbar.value && hasVerticalScrollbar.value;
        const horizontalTrackWidth = props.type === "embed" && isBoth.value ? offsetWidth - TRACK_SIZE : offsetWidth;
        const verticalTrackHeight = props.type === "embed" && isBoth.value ? offsetHeight - TRACK_SIZE : offsetHeight;
        const horizontalThumbWidth = Math.round(horizontalTrackWidth / Math.min(scrollWidth / clientWidth, horizontalTrackWidth / THUMB_MIN_SIZE));
        const maxHorizontalOffset = horizontalTrackWidth - horizontalThumbWidth;
        const horizontalRatio = (scrollWidth - clientWidth) / maxHorizontalOffset;
        const verticalThumbHeight = Math.round(verticalTrackHeight / Math.min(scrollHeight / clientHeight, verticalTrackHeight / THUMB_MIN_SIZE));
        const maxVerticalOffset = verticalTrackHeight - verticalThumbHeight;
        const verticalRatio = (scrollHeight - clientHeight) / maxVerticalOffset;
        horizontalData.value = {
          ratio: horizontalRatio,
          thumbSize: horizontalThumbWidth,
          max: maxHorizontalOffset
        };
        verticalData.value = {
          ratio: verticalRatio,
          thumbSize: verticalThumbHeight,
          max: maxVerticalOffset
        };
        if (scrollTop > 0) {
          const verticalOffset = Math.round(scrollTop / ((_b2 = (_a2 = verticalData.value) == null ? void 0 : _a2.ratio) != null ? _b2 : 1));
          (_c2 = verticalThumbRef.value) == null ? void 0 : _c2.setOffset(verticalOffset);
        }
        if (scrollLeft > 0) {
          const horizontalOffset = Math.round(scrollLeft / ((_e = (_d = verticalData.value) == null ? void 0 : _d.ratio) != null ? _e : 1));
          (_f = horizontalThumbRef.value) == null ? void 0 : _f.setOffset(horizontalOffset);
        }
      }
    };
    onMounted(() => {
      getContainerSize();
    });
    const handleResize = () => {
      getContainerSize();
    };
    const handleScroll2 = (ev) => {
      var _a2, _b2, _c2, _d, _e, _f;
      if (containerRef.value) {
        if (hasHorizontalScrollbar.value && !props.disableHorizontal) {
          const horizontalOffset = Math.round(containerRef.value.scrollLeft / ((_b2 = (_a2 = horizontalData.value) == null ? void 0 : _a2.ratio) != null ? _b2 : 1));
          (_c2 = horizontalThumbRef.value) == null ? void 0 : _c2.setOffset(horizontalOffset);
        }
        if (hasVerticalScrollbar.value && !props.disableVertical) {
          const verticalOffset = Math.round(containerRef.value.scrollTop / ((_e = (_d = verticalData.value) == null ? void 0 : _d.ratio) != null ? _e : 1));
          (_f = verticalThumbRef.value) == null ? void 0 : _f.setOffset(verticalOffset);
        }
      }
      emit2("scroll", ev);
    };
    const handleHorizontalScroll = (offset) => {
      var _a2, _b2;
      if (containerRef.value) {
        containerRef.value.scrollTo({
          left: offset * ((_b2 = (_a2 = horizontalData.value) == null ? void 0 : _a2.ratio) != null ? _b2 : 1)
        });
      }
    };
    const handleVerticalScroll = (offset) => {
      var _a2, _b2;
      if (containerRef.value) {
        containerRef.value.scrollTo({
          top: offset * ((_b2 = (_a2 = verticalData.value) == null ? void 0 : _a2.ratio) != null ? _b2 : 1)
        });
      }
    };
    const style2 = computed(() => {
      const style22 = {};
      if (props.type === "track") {
        if (hasHorizontalScrollbar.value) {
          style22.paddingBottom = `${TRACK_SIZE}px`;
        }
        if (hasVerticalScrollbar.value) {
          style22.paddingRight = `${TRACK_SIZE}px`;
        }
      }
      return [style22, props.outerStyle];
    });
    const cls = computed(() => [`${prefixCls}`, `${prefixCls}-type-${props.type}`, {
      [`${prefixCls}-both`]: isBoth.value
    }, props.outerClass]);
    return {
      prefixCls,
      cls,
      style: style2,
      containerRef,
      horizontalThumbRef,
      verticalThumbRef,
      horizontalData,
      verticalData,
      isBoth,
      hasHorizontalScrollbar,
      hasVerticalScrollbar,
      handleResize,
      handleScroll: handleScroll2,
      handleHorizontalScroll,
      handleVerticalScroll
    };
  },
  methods: {
    scrollTo(options, y2) {
      var _a2, _b2;
      if (isObject$5(options)) {
        (_a2 = this.$refs.containerRef) == null ? void 0 : _a2.scrollTo(options);
      } else if (options || y2) {
        (_b2 = this.$refs.containerRef) == null ? void 0 : _b2.scrollTo(options, y2);
      }
    },
    scrollTop(top) {
      var _a2;
      (_a2 = this.$refs.containerRef) == null ? void 0 : _a2.scrollTo({
        top
      });
    },
    scrollLeft(left) {
      var _a2;
      (_a2 = this.$refs.containerRef) == null ? void 0 : _a2.scrollTo({
        left
      });
    }
  }
});
function _sfc_render$X(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ResizeObserver = resolveComponent("ResizeObserver");
  const _component_thumb = resolveComponent("thumb");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.style)
  }, [createVNode(_component_ResizeObserver, {
    onResize: _ctx.handleResize
  }, {
    default: withCtx(() => [createBaseVNode("div", mergeProps({
      ref: "containerRef",
      class: `${_ctx.prefixCls}-container`
    }, _ctx.$attrs, {
      onScroll: _cache[0] || (_cache[0] = (...args) => _ctx.handleScroll && _ctx.handleScroll(...args))
    }), [createVNode(_component_ResizeObserver, {
      onResize: _ctx.handleResize
    }, {
      default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
      _: 3
    }, 8, ["onResize"])], 16)]),
    _: 3
  }, 8, ["onResize"]), !_ctx.hide && _ctx.hasHorizontalScrollbar ? (openBlock(), createBlock(_component_thumb, {
    key: 0,
    ref: "horizontalThumbRef",
    data: _ctx.horizontalData,
    direction: "horizontal",
    both: _ctx.isBoth,
    onScroll: _ctx.handleHorizontalScroll
  }, null, 8, ["data", "both", "onScroll"])) : createCommentVNode("v-if", true), !_ctx.hide && _ctx.hasVerticalScrollbar ? (openBlock(), createBlock(_component_thumb, {
    key: 1,
    ref: "verticalThumbRef",
    data: _ctx.verticalData,
    direction: "vertical",
    both: _ctx.isBoth,
    onScroll: _ctx.handleVerticalScroll
  }, null, 8, ["data", "both", "onScroll"])) : createCommentVNode("v-if", true)], 6);
}
var _Scrollbar = /* @__PURE__ */ _export_sfc$1(_sfc_main$13, [["render", _sfc_render$X]]);
const Scrollbar = Object.assign(_Scrollbar, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Scrollbar.name, _Scrollbar);
  }
});
const useComponentRef = (name) => {
  const componentRef = ref();
  const getElement2 = () => {
    if (isComponentInstance(componentRef.value)) {
      return componentRef.value.$refs[name];
    }
    return componentRef.value;
  };
  const elementRef = ref();
  onMounted(() => {
    elementRef.value = getElement2();
  });
  watch([componentRef], () => {
    elementRef.value = getElement2();
  });
  return {
    componentRef,
    elementRef
  };
};
var __defProp$h = Object.defineProperty;
var __getOwnPropSymbols$h = Object.getOwnPropertySymbols;
var __hasOwnProp$h = Object.prototype.hasOwnProperty;
var __propIsEnum$h = Object.prototype.propertyIsEnumerable;
var __defNormalProp$h = (obj, key, value) => key in obj ? __defProp$h(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$h = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$h.call(b2, prop))
      __defNormalProp$h(a, prop, b2[prop]);
  if (__getOwnPropSymbols$h)
    for (var prop of __getOwnPropSymbols$h(b2)) {
      if (__propIsEnum$h.call(b2, prop))
        __defNormalProp$h(a, prop, b2[prop]);
    }
  return a;
};
const useScrollbar = (scrollbar) => {
  const displayScrollbar = computed(() => Boolean(scrollbar.value));
  const scrollbarProps = computed(() => {
    if (!scrollbar.value)
      return void 0;
    return __spreadValues$h({
      type: "embed"
    }, isBoolean$1(scrollbar.value) ? void 0 : scrollbar.value);
  });
  return {
    displayScrollbar,
    scrollbarProps
  };
};
const _sfc_main$12 = defineComponent({
  name: "SelectDropdown",
  components: {
    ScrollbarComponent: Scrollbar,
    Empty,
    Spin
  },
  props: {
    loading: Boolean,
    empty: Boolean,
    virtualList: Boolean,
    bottomOffset: {
      type: Number,
      default: 0
    },
    scrollbar: {
      type: [Boolean, Object],
      default: true
    },
    onScroll: {
      type: [Function, Array]
    },
    onReachBottom: {
      type: [Function, Array]
    }
  },
  emits: ["scroll", "reachBottom"],
  setup(props, {
    emit: emit2,
    slots
  }) {
    const {
      scrollbar
    } = toRefs(props);
    const prefixCls = getPrefixCls("select-dropdown");
    const {
      componentRef: wrapperComRef,
      elementRef: wrapperRef
    } = useComponentRef("containerRef");
    const {
      displayScrollbar,
      scrollbarProps
    } = useScrollbar(scrollbar);
    const handleScroll2 = (e2) => {
      const {
        scrollTop,
        scrollHeight,
        offsetHeight
      } = e2.target;
      const bottom = scrollHeight - (scrollTop + offsetHeight);
      if (bottom <= props.bottomOffset) {
        emit2("reachBottom", e2);
      }
      emit2("scroll", e2);
    };
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-has-header`]: Boolean(slots.header),
      [`${prefixCls}-has-footer`]: Boolean(slots.footer)
    }]);
    return {
      prefixCls,
      cls,
      wrapperRef,
      wrapperComRef,
      handleScroll: handleScroll2,
      displayScrollbar,
      scrollbarProps
    };
  }
});
function _sfc_render$W(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_spin = resolveComponent("spin");
  const _component_empty = resolveComponent("empty");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [_ctx.loading ? (openBlock(), createBlock(_component_spin, {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-loading`)
  }, null, 8, ["class"])) : _ctx.empty ? (openBlock(), createElementBlock("div", {
    key: 1,
    class: normalizeClass(`${_ctx.prefixCls}-empty`)
  }, [renderSlot(_ctx.$slots, "empty", {}, () => [createVNode(_component_empty)])], 2)) : createCommentVNode("v-if", true), _ctx.$slots.header && !_ctx.empty ? (openBlock(), createElementBlock("div", {
    key: 2,
    class: normalizeClass(`${_ctx.prefixCls}-header`)
  }, [renderSlot(_ctx.$slots, "header")], 2)) : createCommentVNode("v-if", true), _ctx.virtualList && !_ctx.loading && !_ctx.empty ? renderSlot(_ctx.$slots, "virtual-list", {
    key: 3
  }) : createCommentVNode("v-if", true), !_ctx.virtualList ? withDirectives((openBlock(), createBlock(resolveDynamicComponent(_ctx.displayScrollbar ? "ScrollbarComponent" : "div"), mergeProps({
    key: 4,
    ref: "wrapperComRef",
    class: `${_ctx.prefixCls}-list-wrapper`
  }, _ctx.scrollbarProps, {
    onScroll: _ctx.handleScroll
  }), {
    default: withCtx(() => [createBaseVNode("ul", {
      class: normalizeClass(`${_ctx.prefixCls}-list`)
    }, [renderSlot(_ctx.$slots, "default")], 2)]),
    _: 3
  }, 16, ["class", "onScroll"])), [[vShow, !_ctx.loading && !_ctx.empty]]) : createCommentVNode("v-if", true), _ctx.$slots.footer && !_ctx.empty ? (openBlock(), createElementBlock("div", {
    key: 5,
    class: normalizeClass(`${_ctx.prefixCls}-footer`)
  }, [renderSlot(_ctx.$slots, "footer")], 2)) : createCommentVNode("v-if", true)], 2);
}
var SelectDropdown = /* @__PURE__ */ _export_sfc$1(_sfc_main$12, [["render", _sfc_render$W]]);
var IconCheck$1 = defineComponent({
  name: "IconCheck",
  render() {
    return createVNode("svg", {
      "aria-hidden": "true",
      "focusable": "false",
      "viewBox": "0 0 1024 1024",
      "width": "200",
      "height": "200",
      "fill": "currentColor"
    }, [createVNode("path", {
      "d": "M877.44815445 206.10060629a64.72691371 64.72691371 0 0 0-95.14856334 4.01306852L380.73381888 685.46812814 235.22771741 533.48933518a64.72691371 64.72691371 0 0 0-92.43003222-1.03563036l-45.82665557 45.82665443a64.72691371 64.72691371 0 0 0-0.90617629 90.61767965l239.61903446 250.10479331a64.72691371 64.72691371 0 0 0 71.19960405 15.14609778 64.33855261 64.33855261 0 0 0 35.08198741-21.23042702l36.24707186-42.71976334 40.5190474-40.77795556-3.36579926-3.49525333 411.40426297-486.74638962a64.72691371 64.72691371 0 0 0-3.88361443-87.64024149l-45.3088404-45.43829334z",
      "p-id": "840"
    }, null)]);
  }
});
const checkboxGroupKey = Symbol("ArcoCheckboxGroup");
var _Checkbox = defineComponent({
  name: "Checkbox",
  components: {
    IconCheck: IconCheck$1,
    IconHover
  },
  props: {
    modelValue: {
      type: [Boolean, Array],
      default: void 0
    },
    defaultChecked: {
      type: Boolean,
      default: false
    },
    value: {
      type: [String, Number, Boolean]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    indeterminate: {
      type: Boolean,
      default: false
    },
    uninjectGroupContext: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value, ev) => true
  },
  setup(props, {
    emit: emit2,
    slots
  }) {
    const {
      disabled,
      modelValue
    } = toRefs(props);
    const prefixCls = getPrefixCls("checkbox");
    const checkboxRef = ref();
    const checkboxGroupCtx = !props.uninjectGroupContext ? inject(checkboxGroupKey, void 0) : void 0;
    const isGroup = (checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.name) === "ArcoCheckboxGroup";
    const {
      mergedDisabled: _mergedDisabled,
      eventHandlers
    } = useFormItem({
      disabled
    });
    const _checked = ref(props.defaultChecked);
    const computedValue = computed(() => {
      var _a2;
      return isGroup ? checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.computedValue : (_a2 = props.modelValue) != null ? _a2 : _checked.value;
    });
    const computedChecked = computed(() => {
      var _a2;
      return isArray$4(computedValue.value) ? computedValue.value.includes((_a2 = props.value) != null ? _a2 : true) : computedValue.value;
    });
    const mergedDisabled = computed(() => (checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.disabled) || (_mergedDisabled == null ? void 0 : _mergedDisabled.value) || !computedChecked.value && (checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.isMaxed));
    const handleClick = (ev) => {
      ev.stopPropagation();
    };
    const handleChange = (e2) => {
      var _a2, _b2, _c2, _d;
      const {
        checked
      } = e2.target;
      let newValue = checked;
      if (isArray$4(computedValue.value)) {
        const set2 = new Set(computedValue.value);
        if (checked) {
          set2.add((_a2 = props.value) != null ? _a2 : true);
        } else {
          set2.delete((_b2 = props.value) != null ? _b2 : true);
        }
        newValue = Array.from(set2);
      }
      _checked.value = checked;
      if (isGroup && isArray$4(newValue)) {
        checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.handleChange(newValue, e2);
      } else {
        emit2("update:modelValue", newValue);
        emit2("change", newValue, e2);
        (_d = (_c2 = eventHandlers.value) == null ? void 0 : _c2.onChange) == null ? void 0 : _d.call(_c2, e2);
      }
      nextTick(() => {
        if (checkboxRef.value && checkboxRef.value.checked !== computedChecked.value) {
          checkboxRef.value.checked = computedChecked.value;
        }
      });
    };
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-checked`]: computedChecked.value,
      [`${prefixCls}-indeterminate`]: props.indeterminate,
      [`${prefixCls}-disabled`]: mergedDisabled.value
    }]);
    const handleFocus = (ev) => {
      var _a2, _b2;
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onFocus) == null ? void 0 : _b2.call(_a2, ev);
    };
    const handleBlur = (ev) => {
      var _a2, _b2;
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onBlur) == null ? void 0 : _b2.call(_a2, ev);
    };
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _checked.value = false;
      }
    });
    watch(computedValue, (value) => {
      var _a2;
      let checked;
      if (isArray$4(value)) {
        checked = value.includes((_a2 = props.value) != null ? _a2 : true);
      } else {
        checked = value;
      }
      if (_checked.value !== checked) {
        _checked.value = checked;
      }
      if (checkboxRef.value && checkboxRef.value.checked !== checked) {
        checkboxRef.value.checked = checked;
      }
    });
    return () => {
      var _a2, _b2, _c2, _d;
      return createVNode("label", {
        "aria-disabled": mergedDisabled.value,
        "class": cls.value
      }, [createVNode("input", {
        "ref": checkboxRef,
        "type": "checkbox",
        "checked": computedChecked.value,
        "value": props.value,
        "class": `${prefixCls}-target`,
        "disabled": mergedDisabled.value,
        "onClick": handleClick,
        "onChange": handleChange,
        "onFocus": handleFocus,
        "onBlur": handleBlur
      }, null), (_d = (_c2 = (_b2 = slots.checkbox) != null ? _b2 : (_a2 = checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.slots) == null ? void 0 : _a2.checkbox) == null ? void 0 : _c2({
        checked: computedChecked.value,
        disabled: mergedDisabled.value
      })) != null ? _d : createVNode(IconHover, {
        "class": `${prefixCls}-icon-hover`,
        "disabled": mergedDisabled.value || computedChecked.value
      }, {
        default: () => [createVNode("div", {
          "class": `${prefixCls}-icon`
        }, [computedChecked.value && createVNode(IconCheck$1, {
          "class": `${prefixCls}-icon-check`
        }, null)])]
      }), slots.default && createVNode("span", {
        "class": `${prefixCls}-label`
      }, [slots.default()])]);
    };
  }
});
var CheckboxGroup = defineComponent({
  name: "CheckboxGroup",
  props: {
    modelValue: {
      type: Array,
      default: void 0
    },
    defaultValue: {
      type: Array,
      default: () => []
    },
    max: {
      type: Number
    },
    options: {
      type: Array
    },
    direction: {
      type: String,
      default: "horizontal"
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value, ev) => true
  },
  setup(props, {
    emit: emit2,
    slots
  }) {
    const {
      disabled
    } = toRefs(props);
    const prefixCls = getPrefixCls("checkbox-group");
    const {
      mergedDisabled,
      eventHandlers
    } = useFormItem({
      disabled
    });
    const _value = ref(props.defaultValue);
    const computedValue = computed(() => isArray$4(props.modelValue) ? props.modelValue : _value.value);
    const isMaxed = computed(() => props.max === void 0 ? false : computedValue.value.length >= props.max);
    const options = computed(() => {
      var _a2;
      return ((_a2 = props.options) != null ? _a2 : []).map((option) => {
        if (isString$3(option) || isNumber$2(option)) {
          return {
            label: option,
            value: option
          };
        }
        return option;
      });
    });
    const handleChange = (value, e2) => {
      var _a2, _b2;
      _value.value = value;
      emit2("update:modelValue", value);
      emit2("change", value, e2);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onChange) == null ? void 0 : _b2.call(_a2, e2);
    };
    provide(checkboxGroupKey, reactive({
      name: "ArcoCheckboxGroup",
      computedValue,
      disabled: mergedDisabled,
      isMaxed,
      slots,
      handleChange
    }));
    const cls = computed(() => [prefixCls, `${prefixCls}-direction-${props.direction}`]);
    watch(() => props.modelValue, (curValue) => {
      if (isArray$4(curValue)) {
        _value.value = [...curValue];
      } else {
        _value.value = [];
      }
    });
    const renderOptions = () => {
      return options.value.map((option) => {
        const checked = computedValue.value.includes(option.value);
        return createVNode(_Checkbox, {
          "key": option.value,
          "value": option.value,
          "disabled": option.disabled || !checked && isMaxed.value,
          "indeterminate": option.indeterminate,
          "modelValue": checked
        }, {
          default: () => [slots.label ? slots.label({
            data: option
          }) : isFunction$3(option.label) ? option.label() : option.label]
        });
      });
    };
    return () => {
      var _a2;
      return createVNode("span", {
        "class": cls.value
      }, [options.value.length > 0 ? renderOptions() : (_a2 = slots.default) == null ? void 0 : _a2.call(slots)]);
    };
  }
});
const Checkbox = Object.assign(_Checkbox, {
  Group: CheckboxGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Checkbox.name, _Checkbox);
    app.component(componentPrefix + CheckboxGroup.name, CheckboxGroup);
  }
});
const selectInjectionKey = Symbol("ArcoSelectContext");
var __defProp$g = Object.defineProperty;
var __defProps$8 = Object.defineProperties;
var __getOwnPropDescs$8 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$g = Object.getOwnPropertySymbols;
var __hasOwnProp$g = Object.prototype.hasOwnProperty;
var __propIsEnum$g = Object.prototype.propertyIsEnumerable;
var __defNormalProp$g = (obj, key, value) => key in obj ? __defProp$g(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$g = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$g.call(b2, prop))
      __defNormalProp$g(a, prop, b2[prop]);
  if (__getOwnPropSymbols$g)
    for (var prop of __getOwnPropSymbols$g(b2)) {
      if (__propIsEnum$g.call(b2, prop))
        __defNormalProp$g(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$8 = (a, b2) => __defProps$8(a, __getOwnPropDescs$8(b2));
const isGroupOption = (option) => {
  return isObject$5(option) && "isGroup" in option;
};
const isGroupOptionInfo = (option) => {
  return isObject$5(option) && "isGroup" in option;
};
const getValueString = (value, valueKey = "value") => String(isObject$5(value) ? value[valueKey] : value);
const getKeyFromValue = (value, valueKey = "value") => {
  if (isObject$5(value)) {
    return `__arco__option__object__${value[valueKey]}`;
  }
  if (value || isNumber$2(value) || isString$3(value)) {
    return `__arco__option__${typeof value}-${value}`;
  }
  return "";
};
const hasEmptyStringKey = (optionInfoMap) => {
  return optionInfoMap.has(`__arco__option__string-`);
};
const createOptionInfo = (option, {
  valueKey,
  fieldNames,
  origin,
  index: index2 = -1
}) => {
  var _a2;
  if (isObject$5(option)) {
    const value = option[fieldNames.value];
    return {
      raw: option,
      index: index2,
      key: getKeyFromValue(value, valueKey),
      origin,
      value,
      label: (_a2 = option[fieldNames.label]) != null ? _a2 : getValueString(value, valueKey),
      render: option[fieldNames.render],
      disabled: Boolean(option[fieldNames.disabled]),
      tagProps: option[fieldNames.tagProps]
    };
  }
  const raw = {
    value: option,
    label: String(option),
    disabled: false
  };
  return __spreadValues$g({
    raw,
    index: index2,
    key: getKeyFromValue(option, valueKey),
    origin
  }, raw);
};
const getOptionInfos = (options, {
  valueKey,
  fieldNames,
  origin,
  optionInfoMap
}) => {
  var _a2;
  const infos = [];
  for (const item of options) {
    if (isGroupOption(item)) {
      const options2 = getOptionInfos((_a2 = item.options) != null ? _a2 : [], {
        valueKey,
        fieldNames,
        origin,
        optionInfoMap
      });
      if (options2.length > 0) {
        infos.push(__spreadProps$8(__spreadValues$g({}, item), {
          key: `__arco__group__${item.label}`,
          options: options2
        }));
      }
    } else {
      const optionInfo = createOptionInfo(item, {
        valueKey,
        fieldNames,
        origin
      });
      infos.push(optionInfo);
      if (!optionInfoMap.get(optionInfo.key)) {
        optionInfoMap.set(optionInfo.key, optionInfo);
      }
    }
  }
  return infos;
};
const getValidOptions = (optionInfos, {
  inputValue,
  filterOption
}) => {
  const travel = (optionInfos2) => {
    var _a2;
    const options = [];
    for (const item of optionInfos2) {
      if (isGroupOptionInfo(item)) {
        const _options = travel((_a2 = item.options) != null ? _a2 : []);
        if (_options.length > 0) {
          options.push(__spreadProps$8(__spreadValues$g({}, item), {
            options: _options
          }));
        }
      } else if (isValidOption(item, {
        inputValue,
        filterOption
      })) {
        options.push(item);
      }
    }
    return options;
  };
  return travel(optionInfos);
};
const isValidOption = (optionInfo, {
  inputValue,
  filterOption
}) => {
  if (isFunction$3(filterOption)) {
    return !inputValue || filterOption(inputValue, optionInfo.raw);
  }
  if (filterOption) {
    return optionInfo.label.toLowerCase().includes((inputValue != null ? inputValue : "").toLowerCase());
  }
  return true;
};
const isEqualObject = (obj, other) => {
  if (!obj || !other) {
    return false;
  }
  if (obj.length !== other.length) {
    return false;
  }
  for (const key of Object.keys(obj)) {
    const result = isEqual(obj[key], other[key]);
    if (!result)
      return false;
  }
  return true;
};
const isEqualArray = (arr, other) => {
  if (!arr || !other) {
    return false;
  }
  const {
    length
  } = arr;
  if (length !== other.length) {
    return false;
  }
  for (let i2 = 0; i2 < length; i2++) {
    const result = isEqual(arr[i2], other[i2]);
    if (!result)
      return false;
  }
  return true;
};
const isEqual = (a, b2) => {
  const type = Object.prototype.toString.call(a);
  if (type !== Object.prototype.toString.call(b2)) {
    return false;
  }
  if (type === "[object Object]") {
    return isEqualObject(a, b2);
  }
  if (type === "[object Array]") {
    return isEqualArray(a, b2);
  }
  if (type === "[object Function]") {
    if (a === b2) {
      return true;
    }
    return a.toString() === b2.toString();
  }
  return a === b2;
};
const _sfc_main$11 = defineComponent({
  name: "Option",
  components: {
    Checkbox
  },
  props: {
    value: [String, Number, Object],
    label: String,
    disabled: Boolean,
    tagProps: {
      type: Object
    },
    extra: {
      type: Object
    },
    index: {
      type: Number
    },
    internal: Boolean
  },
  setup(props) {
    const {
      disabled,
      tagProps: _tagProps,
      index: index2
    } = toRefs(props);
    const prefixCls = getPrefixCls("select-option");
    const selectCtx = inject(selectInjectionKey, void 0);
    const instance = getCurrentInstance();
    const itemRef = ref();
    const tagProps = ref(_tagProps.value);
    watch(_tagProps, (cur, pre) => {
      if (!isEqual(cur, pre)) {
        tagProps.value = cur;
      }
    });
    const textContent = ref("");
    const value = computed(() => {
      var _a2, _b2;
      return (_b2 = (_a2 = props.value) != null ? _a2 : props.label) != null ? _b2 : textContent.value;
    });
    const label = computed(() => {
      var _a2;
      return (_a2 = props.label) != null ? _a2 : textContent.value;
    });
    const key = computed(() => getKeyFromValue(value.value, selectCtx == null ? void 0 : selectCtx.valueKey));
    const component = computed(() => {
      var _a2;
      return (_a2 = selectCtx == null ? void 0 : selectCtx.component) != null ? _a2 : "li";
    });
    const setTextContent = () => {
      var _a2;
      if (!props.label && itemRef.value) {
        const text = (_a2 = itemRef.value.textContent) != null ? _a2 : "";
        if (textContent.value !== text) {
          textContent.value = text;
        }
      }
    };
    onMounted(() => setTextContent());
    onUpdated(() => setTextContent());
    const isSelected = computed(() => {
      var _a2;
      return (_a2 = selectCtx == null ? void 0 : selectCtx.valueKeys.includes(key.value)) != null ? _a2 : false;
    });
    const isActive = computed(() => (selectCtx == null ? void 0 : selectCtx.activeKey) === key.value);
    let isValid = ref(true);
    if (!props.internal) {
      const optionInfo = reactive({
        raw: {
          value,
          label,
          disabled,
          tagProps
        },
        ref: itemRef,
        index: index2,
        key,
        origin: "slot",
        value,
        label,
        disabled,
        tagProps
      });
      isValid = computed(() => isValidOption(optionInfo, {
        inputValue: selectCtx == null ? void 0 : selectCtx.inputValue,
        filterOption: selectCtx == null ? void 0 : selectCtx.filterOption
      }));
      if (instance) {
        selectCtx == null ? void 0 : selectCtx.addSlotOptionInfo(instance.uid, optionInfo);
      }
      onBeforeUnmount(() => {
        if (instance) {
          selectCtx == null ? void 0 : selectCtx.removeSlotOptionInfo(instance.uid);
        }
      });
    }
    const handleClick = (ev) => {
      if (!props.disabled) {
        selectCtx == null ? void 0 : selectCtx.onSelect(key.value, ev);
      }
    };
    const handleMouseEnter = () => {
      if (!props.disabled) {
        selectCtx == null ? void 0 : selectCtx.setActiveKey(key.value);
      }
    };
    const handleMouseLeave = () => {
      if (!props.disabled) {
        selectCtx == null ? void 0 : selectCtx.setActiveKey();
      }
    };
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-disabled`]: props.disabled,
      [`${prefixCls}-active`]: isActive.value,
      [`${prefixCls}-multiple`]: selectCtx == null ? void 0 : selectCtx.multiple
    }]);
    return {
      prefixCls,
      cls,
      selectCtx,
      itemRef,
      component,
      isSelected,
      isValid,
      handleClick,
      handleMouseEnter,
      handleMouseLeave
    };
  }
});
function _sfc_render$V(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_checkbox = resolveComponent("checkbox");
  return withDirectives((openBlock(), createBlock(resolveDynamicComponent(_ctx.component), {
    ref: "itemRef",
    class: normalizeClass([_ctx.cls, {
      [`${_ctx.prefixCls}-has-suffix`]: Boolean(_ctx.$slots.suffix)
    }]),
    onClick: _ctx.handleClick,
    onMouseenter: _ctx.handleMouseEnter,
    onMouseleave: _ctx.handleMouseLeave
  }, {
    default: withCtx(() => [_ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [renderSlot(_ctx.$slots, "icon")], 2)) : createCommentVNode("v-if", true), _ctx.selectCtx && _ctx.selectCtx.multiple ? (openBlock(), createBlock(_component_checkbox, {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-checkbox`),
      "model-value": _ctx.isSelected,
      disabled: _ctx.disabled,
      "uninject-group-context": ""
    }, {
      default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [createTextVNode(toDisplayString$1(_ctx.label), 1)])]),
      _: 3
    }, 8, ["class", "model-value", "disabled"])) : (openBlock(), createElementBlock("span", {
      key: 2,
      class: normalizeClass(`${_ctx.prefixCls}-content`)
    }, [renderSlot(_ctx.$slots, "default", {}, () => [createTextVNode(toDisplayString$1(_ctx.label), 1)])], 2)), _ctx.$slots.suffix ? (openBlock(), createElementBlock("span", {
      key: 3,
      class: normalizeClass(`${_ctx.prefixCls}-suffix`)
    }, [renderSlot(_ctx.$slots, "suffix")], 2)) : createCommentVNode("v-if", true)]),
    _: 3
  }, 8, ["class", "onClick", "onMouseenter", "onMouseleave"])), [[vShow, _ctx.isValid]]);
}
var Option = /* @__PURE__ */ _export_sfc$1(_sfc_main$11, [["render", _sfc_render$V]]);
var __defProp$f = Object.defineProperty;
var __defProps$7 = Object.defineProperties;
var __getOwnPropDescs$7 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$f = Object.getOwnPropertySymbols;
var __hasOwnProp$f = Object.prototype.hasOwnProperty;
var __propIsEnum$f = Object.prototype.propertyIsEnumerable;
var __defNormalProp$f = (obj, key, value) => key in obj ? __defProp$f(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$f = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$f.call(b2, prop))
      __defNormalProp$f(a, prop, b2[prop]);
  if (__getOwnPropSymbols$f)
    for (var prop of __getOwnPropSymbols$f(b2)) {
      if (__propIsEnum$f.call(b2, prop))
        __defNormalProp$f(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$7 = (a, b2) => __defProps$7(a, __getOwnPropDescs$7(b2));
const DEFAULT_FIELD_NAMES$2 = {
  value: "value",
  label: "label",
  disabled: "disabled",
  tagProps: "tagProps",
  render: "render"
};
const useOptions = ({
  options,
  extraOptions,
  inputValue,
  filterOption,
  showExtraOptions,
  valueKey,
  fieldNames
}) => {
  const mergedFieldNames = computed(() => __spreadValues$f(__spreadValues$f({}, DEFAULT_FIELD_NAMES$2), fieldNames == null ? void 0 : fieldNames.value));
  const slotOptionInfoMap = reactive(/* @__PURE__ */ new Map());
  const sortedSlotOptionInfos = computed(() => Array.from(slotOptionInfoMap.values()).sort((a, b2) => {
    if (isNumber$2(a.index) && isNumber$2(b2.index)) {
      return a.index - b2.index;
    }
    return 0;
  }));
  const propOptionData = computed(() => {
    var _a2, _b2;
    const optionInfoMap2 = /* @__PURE__ */ new Map();
    const optionInfos = getOptionInfos((_a2 = options == null ? void 0 : options.value) != null ? _a2 : [], {
      valueKey: (_b2 = valueKey == null ? void 0 : valueKey.value) != null ? _b2 : "value",
      fieldNames: mergedFieldNames.value,
      origin: "options",
      optionInfoMap: optionInfoMap2
    });
    return {
      optionInfos,
      optionInfoMap: optionInfoMap2
    };
  });
  const extraOptionData = computed(() => {
    var _a2, _b2;
    const optionInfoMap2 = /* @__PURE__ */ new Map();
    const optionInfos = getOptionInfos((_a2 = extraOptions == null ? void 0 : extraOptions.value) != null ? _a2 : [], {
      valueKey: (_b2 = valueKey == null ? void 0 : valueKey.value) != null ? _b2 : "value",
      fieldNames: mergedFieldNames.value,
      origin: "extraOptions",
      optionInfoMap: optionInfoMap2
    });
    return {
      optionInfos,
      optionInfoMap: optionInfoMap2
    };
  });
  const optionInfoMap = reactive(/* @__PURE__ */ new Map());
  watch([sortedSlotOptionInfos, options != null ? options : ref([]), extraOptions != null ? extraOptions : ref([]), valueKey != null ? valueKey : ref("value")], () => {
    optionInfoMap.clear();
    sortedSlotOptionInfos.value.forEach((info, index2) => {
      optionInfoMap.set(info.key, __spreadProps$7(__spreadValues$f({}, info), {
        index: index2
      }));
    });
    propOptionData.value.optionInfoMap.forEach((info) => {
      if (!optionInfoMap.has(info.key)) {
        info.index = optionInfoMap.size;
        optionInfoMap.set(info.key, info);
      }
    });
    extraOptionData.value.optionInfoMap.forEach((info) => {
      if (!optionInfoMap.has(info.key)) {
        info.index = optionInfoMap.size;
        optionInfoMap.set(info.key, info);
      }
    });
  }, {
    immediate: true,
    deep: true
  });
  const validOptions = computed(() => {
    var _a2;
    const options2 = getValidOptions(propOptionData.value.optionInfos, {
      inputValue: inputValue == null ? void 0 : inputValue.value,
      filterOption: filterOption == null ? void 0 : filterOption.value
    });
    if ((_a2 = showExtraOptions == null ? void 0 : showExtraOptions.value) != null ? _a2 : true) {
      options2.push(...getValidOptions(extraOptionData.value.optionInfos, {
        inputValue: inputValue == null ? void 0 : inputValue.value,
        filterOption: filterOption == null ? void 0 : filterOption.value
      }));
    }
    return options2;
  });
  const validOptionInfos = computed(() => Array.from(optionInfoMap.values()).filter((optionInfo) => {
    if (optionInfo.origin === "extraOptions" && (showExtraOptions == null ? void 0 : showExtraOptions.value) === false) {
      return false;
    }
    return isValidOption(optionInfo, {
      inputValue: inputValue == null ? void 0 : inputValue.value,
      filterOption: filterOption == null ? void 0 : filterOption.value
    });
  }));
  const enabledOptionKeys = computed(() => validOptionInfos.value.filter((optionInfo) => !optionInfo.disabled).map((info) => info.key));
  const getNextSlotOptionIndex = () => slotOptionInfoMap.size;
  const addSlotOptionInfo = (id, optionInfo) => {
    slotOptionInfoMap.set(id, optionInfo);
  };
  const removeSlotOptionInfo = (id) => {
    slotOptionInfoMap.delete(id);
  };
  return {
    validOptions,
    optionInfoMap,
    validOptionInfos,
    enabledOptionKeys,
    getNextSlotOptionIndex,
    addSlotOptionInfo,
    removeSlotOptionInfo
  };
};
const KEYBOARD_KEY = {
  ENTER: "Enter",
  ESC: "Escape",
  BACKSPACE: "Backspace",
  TAB: "Tab",
  SPACE: " ",
  ARROW_UP: "ArrowUp",
  ARROW_DOWN: "ArrowDown",
  ARROW_LEFT: "ArrowLeft",
  ARROW_RIGHT: "ArrowRight"
};
const stringifyCodeKey = (k) => {
  return JSON.stringify({
    key: k.key,
    ctrl: Boolean(k.ctrl),
    shift: Boolean(k.shift),
    alt: Boolean(k.alt),
    meta: Boolean(k.meta)
  });
};
const getKeyDownHandler = (codeKeyMap) => {
  const map2 = {};
  codeKeyMap.forEach((callback, codeKey) => {
    const _codeKey = isString$3(codeKey) ? {
      key: codeKey
    } : codeKey;
    map2[stringifyCodeKey(_codeKey)] = callback;
  });
  return (event) => {
    const key = stringifyCodeKey({
      key: event.key,
      ctrl: event.ctrlKey,
      shift: event.shiftKey,
      alt: event.altKey,
      meta: event.metaKey
    });
    const callback = map2[key];
    if (callback) {
      event.stopPropagation();
      callback(event);
    }
  };
};
const useSelect = ({
  multiple,
  options,
  extraOptions,
  inputValue,
  filterOption,
  showExtraOptions,
  component,
  valueKey,
  fieldNames,
  loading,
  popupVisible,
  valueKeys,
  dropdownRef,
  optionRefs,
  virtualListRef,
  onSelect,
  onPopupVisibleChange,
  enterToOpen = true,
  defaultActiveFirstOption
}) => {
  const {
    validOptions,
    optionInfoMap,
    validOptionInfos,
    enabledOptionKeys,
    getNextSlotOptionIndex,
    addSlotOptionInfo,
    removeSlotOptionInfo
  } = useOptions({
    options,
    extraOptions,
    inputValue,
    filterOption,
    showExtraOptions,
    valueKey,
    fieldNames
  });
  const activeKey = ref();
  watch(enabledOptionKeys, (enabledKeys) => {
    if (!activeKey.value || !enabledKeys.includes(activeKey.value)) {
      activeKey.value = enabledKeys[0];
    }
  });
  const setActiveKey = (key) => {
    activeKey.value = key;
  };
  const getNextActiveKey = (direction) => {
    const _length = enabledOptionKeys.value.length;
    if (_length === 0) {
      return void 0;
    }
    if (!activeKey.value) {
      if (direction === "down") {
        return enabledOptionKeys.value[0];
      }
      return enabledOptionKeys.value[_length - 1];
    }
    const activeIndex = enabledOptionKeys.value.indexOf(activeKey.value);
    const nextIndex = (_length + activeIndex + (direction === "up" ? -1 : 1)) % _length;
    return enabledOptionKeys.value[nextIndex];
  };
  const scrollIntoView2 = (key) => {
    var _a2, _b2;
    if (virtualListRef == null ? void 0 : virtualListRef.value) {
      virtualListRef.value.scrollTo({
        key
      });
    }
    const optionInfo = optionInfoMap.get(key);
    const wrapperEle = (_a2 = dropdownRef == null ? void 0 : dropdownRef.value) == null ? void 0 : _a2.wrapperRef;
    const optionEle = (_b2 = optionRefs == null ? void 0 : optionRefs.value[key]) != null ? _b2 : optionInfo == null ? void 0 : optionInfo.ref;
    if (!wrapperEle || !optionEle) {
      return;
    }
    if (wrapperEle.scrollHeight === wrapperEle.offsetHeight) {
      return;
    }
    const optionRect = getRelativeRect(optionEle, wrapperEle);
    const wrapperScrollTop = wrapperEle.scrollTop;
    if (optionRect.top < 0) {
      wrapperEle.scrollTo(0, wrapperScrollTop + optionRect.top);
    } else if (optionRect.bottom < 0) {
      wrapperEle.scrollTo(0, wrapperScrollTop - optionRect.bottom);
    }
  };
  watch(popupVisible, (visible) => {
    var _a2;
    if (visible) {
      const current = valueKeys.value[valueKeys.value.length - 1];
      let _activeKey = ((_a2 = defaultActiveFirstOption == null ? void 0 : defaultActiveFirstOption.value) != null ? _a2 : true) ? enabledOptionKeys.value[0] : void 0;
      if (enabledOptionKeys.value.includes(current)) {
        _activeKey = current;
      }
      if (_activeKey !== activeKey.value) {
        activeKey.value = _activeKey;
      }
      nextTick(() => {
        if (activeKey.value) {
          scrollIntoView2(activeKey.value);
        }
      });
    }
  });
  const handleKeyDown = getKeyDownHandler(/* @__PURE__ */ new Map([[KEYBOARD_KEY.ENTER, (e2) => {
    if (!(loading == null ? void 0 : loading.value) && !e2.isComposing) {
      if (popupVisible.value) {
        if (activeKey.value) {
          onSelect(activeKey.value, e2);
          e2.preventDefault();
        }
      } else if (enterToOpen) {
        onPopupVisibleChange(true);
        e2.preventDefault();
      }
    }
  }], [KEYBOARD_KEY.ESC, (e2) => {
    if (popupVisible.value) {
      onPopupVisibleChange(false);
      e2.preventDefault();
    }
  }], [KEYBOARD_KEY.ARROW_DOWN, (e2) => {
    if (popupVisible.value) {
      const next = getNextActiveKey("down");
      if (next) {
        activeKey.value = next;
        scrollIntoView2(next);
      }
      e2.preventDefault();
    }
  }], [KEYBOARD_KEY.ARROW_UP, (e2) => {
    if (popupVisible.value) {
      const next = getNextActiveKey("up");
      if (next) {
        activeKey.value = next;
        scrollIntoView2(next);
      }
      e2.preventDefault();
    }
  }]]));
  provide(selectInjectionKey, reactive({
    multiple,
    valueKey,
    inputValue,
    filterOption,
    component,
    valueKeys,
    activeKey,
    setActiveKey,
    onSelect,
    getNextSlotOptionIndex,
    addSlotOptionInfo,
    removeSlotOptionInfo
  }));
  return {
    validOptions,
    optionInfoMap,
    validOptionInfos,
    enabledOptionKeys,
    activeKey,
    setActiveKey,
    addSlotOptionInfo,
    removeSlotOptionInfo,
    getNextActiveKey,
    scrollIntoView: scrollIntoView2,
    handleKeyDown
  };
};
const useIndex = ({
  itemRef,
  selector,
  index: index2,
  parentClassName
}) => {
  const _index = ref(-1);
  const computedIndex = computed(() => {
    var _a2;
    return (_a2 = index2 == null ? void 0 : index2.value) != null ? _a2 : _index.value;
  });
  const parent = ref();
  const getParent = () => {
    var _a2, _b2, _c2;
    let parent2 = (_b2 = (_a2 = itemRef.value) == null ? void 0 : _a2.parentElement) != null ? _b2 : void 0;
    if (parentClassName) {
      while (parent2 && !parent2.className.includes(parentClassName)) {
        parent2 = (_c2 = parent2.parentElement) != null ? _c2 : void 0;
      }
    }
    return parent2;
  };
  const getIndex = () => {
    if (isUndefined(index2 == null ? void 0 : index2.value) && parent.value && itemRef.value) {
      const index22 = Array.from(parent.value.querySelectorAll(selector)).indexOf(itemRef.value);
      if (index22 !== _index.value) {
        _index.value = index22;
      }
    }
  };
  watch(itemRef, () => {
    if (itemRef.value && !parent.value) {
      parent.value = getParent();
    }
  });
  onMounted(() => {
    if (itemRef.value) {
      parent.value = getParent();
    }
    getIndex();
  });
  onUpdated(() => getIndex());
  return {
    computedIndex
  };
};
const _sfc_main$10 = defineComponent({
  name: "IconMore",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-more`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$o = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$m = /* @__PURE__ */ createBaseVNode("path", {
  d: "M38 25v-2h2v2h-2ZM23 25v-2h2v2h-2ZM8 25v-2h2v2H8Z",
  fill: "currentColor",
  stroke: "none"
}, null, -1);
const _hoisted_3$k = /* @__PURE__ */ createBaseVNode("path", {
  d: "M38 25v-2h2v2h-2ZM23 25v-2h2v2h-2ZM8 25v-2h2v2H8Z"
}, null, -1);
const _hoisted_4$7 = [_hoisted_2$m, _hoisted_3$k];
function _sfc_render$U(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_4$7, 14, _hoisted_1$o);
}
var _IconMore = /* @__PURE__ */ _export_sfc$1(_sfc_main$10, [["render", _sfc_render$U]]);
const IconMore = Object.assign(_IconMore, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconMore.name, _IconMore);
  }
});
const _sfc_main$$ = defineComponent({
  name: "IconDown",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-down`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$n = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$l = /* @__PURE__ */ createBaseVNode("path", {
  d: "M39.6 17.443 24.043 33 8.487 17.443"
}, null, -1);
const _hoisted_3$j = [_hoisted_2$l];
function _sfc_render$T(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$j, 14, _hoisted_1$n);
}
var _IconDown = /* @__PURE__ */ _export_sfc$1(_sfc_main$$, [["render", _sfc_render$T]]);
const IconDown = Object.assign(_IconDown, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconDown.name, _IconDown);
  }
});
const useTrigger = ({
  popupVisible,
  defaultPopupVisible,
  emit: emit2
}) => {
  var _a2;
  const _popupVisible = ref((_a2 = defaultPopupVisible == null ? void 0 : defaultPopupVisible.value) != null ? _a2 : false);
  const computedPopupVisible = computed(() => {
    var _a22;
    return (_a22 = popupVisible == null ? void 0 : popupVisible.value) != null ? _a22 : _popupVisible.value;
  });
  const handlePopupVisibleChange = (visible) => {
    if (visible !== computedPopupVisible.value) {
      _popupVisible.value = visible;
      emit2("update:popupVisible", visible);
      emit2("popupVisibleChange", visible);
    }
  };
  watch(computedPopupVisible, (visible) => {
    if (_popupVisible.value !== visible) {
      _popupVisible.value = visible;
    }
  });
  return {
    computedPopupVisible,
    handlePopupVisibleChange
  };
};
const _sfc_main$_ = defineComponent({
  name: "IconRight",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-right`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$m = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$k = /* @__PURE__ */ createBaseVNode("path", {
  d: "m16 39.513 15.556-15.557L16 8.4"
}, null, -1);
const _hoisted_3$i = [_hoisted_2$k];
function _sfc_render$S(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$i, 14, _hoisted_1$m);
}
var _IconRight = /* @__PURE__ */ _export_sfc$1(_sfc_main$_, [["render", _sfc_render$S]]);
const IconRight = Object.assign(_IconRight, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconRight.name, _IconRight);
  }
});
const useInput = ({
  defaultValue,
  modelValue,
  emit: emit2,
  eventName = "input",
  updateEventName = "update:modelValue",
  eventHandlers
}) => {
  var _a2;
  const inputRef = ref();
  const _value = ref((_a2 = defaultValue == null ? void 0 : defaultValue.value) != null ? _a2 : "");
  const _focused = ref(false);
  const isComposition = ref(false);
  const compositionValue = ref("");
  let initialValue;
  const computedValue = computed(() => {
    var _a22;
    return (_a22 = modelValue == null ? void 0 : modelValue.value) != null ? _a22 : _value.value;
  });
  const updateValue = (value, ev) => {
    _value.value = value;
    emit2(updateEventName, value);
    emit2(eventName, value, ev);
  };
  const handleInput = (ev) => {
    const {
      value
    } = ev.target;
    if (!isComposition.value) {
      updateValue(value, ev);
      nextTick(() => {
        if (inputRef.value && computedValue.value !== inputRef.value.value) {
          inputRef.value.value = computedValue.value;
        }
      });
    }
  };
  const handleChange = (ev) => {
    if (eventName === "input" && computedValue.value !== initialValue) {
      initialValue = computedValue.value;
      emit2("change", computedValue.value, ev);
    }
  };
  const handleComposition = (ev) => {
    var _a22;
    const {
      value
    } = ev.target;
    if (ev.type === "compositionend") {
      isComposition.value = false;
      compositionValue.value = "";
      updateValue(value, ev);
      nextTick(() => {
        if (inputRef.value && computedValue.value !== inputRef.value.value) {
          inputRef.value.value = computedValue.value;
        }
      });
    } else {
      isComposition.value = true;
      compositionValue.value = computedValue.value + ((_a22 = ev.data) != null ? _a22 : "");
    }
  };
  const handleFocus = (ev) => {
    var _a22, _b2;
    _focused.value = true;
    initialValue = computedValue.value;
    emit2("focus", ev);
    (_b2 = (_a22 = eventHandlers == null ? void 0 : eventHandlers.value) == null ? void 0 : _a22.onFocus) == null ? void 0 : _b2.call(_a22, ev);
  };
  const handleBlur = (ev) => {
    var _a22, _b2;
    _focused.value = false;
    emit2("blur", ev);
    (_b2 = (_a22 = eventHandlers == null ? void 0 : eventHandlers.value) == null ? void 0 : _a22.onBlur) == null ? void 0 : _b2.call(_a22, ev);
    handleChange(ev);
  };
  const handleKeyDown = (ev) => {
    const keyCode = ev.key || ev.code;
    if (!isComposition.value && keyCode === Enter.key) {
      emit2("pressEnter", ev);
      handleChange(ev);
    }
  };
  const handleMousedown = (ev) => {
    if (inputRef.value && ev.target !== inputRef.value) {
      ev.preventDefault();
      inputRef.value.focus();
    }
  };
  watch(computedValue, (value) => {
    if (inputRef.value && value !== inputRef.value.value) {
      inputRef.value.value = value;
    }
  });
  return {
    inputRef,
    _value,
    _focused,
    isComposition,
    compositionValue,
    computedValue,
    handleInput,
    handleComposition,
    handleFocus,
    handleBlur,
    handleKeyDown,
    handleMousedown
  };
};
var InputLabel = defineComponent({
  name: "InputLabel",
  inheritAttrs: false,
  props: {
    modelValue: Object,
    inputValue: {
      type: String,
      default: ""
    },
    enabledInput: Boolean,
    formatLabel: Function,
    placeholder: String,
    retainInputValue: Boolean,
    disabled: Boolean,
    baseCls: String,
    size: String,
    error: Boolean,
    focused: Boolean,
    uninjectFormItemContext: Boolean
  },
  emits: ["update:inputValue", "inputValueChange", "focus", "blur"],
  setup(props, {
    attrs,
    emit: emit2,
    slots
  }) {
    var _a2;
    const {
      size: size2,
      disabled,
      error,
      inputValue,
      uninjectFormItemContext
    } = toRefs(props);
    const prefixCls = (_a2 = props.baseCls) != null ? _a2 : getPrefixCls("input-label");
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      mergedError,
      eventHandlers
    } = useFormItem({
      size: size2,
      disabled,
      error,
      uninject: uninjectFormItemContext == null ? void 0 : uninjectFormItemContext.value
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const {
      inputRef,
      _focused,
      computedValue: computedInputValue,
      handleInput,
      handleComposition,
      handleFocus,
      handleBlur,
      handleMousedown
    } = useInput({
      modelValue: inputValue,
      emit: emit2,
      eventName: "inputValueChange",
      updateEventName: "update:inputValue",
      eventHandlers
    });
    const mergedFocused = computed(() => {
      var _a22;
      return (_a22 = props.focused) != null ? _a22 : _focused.value;
    });
    const showInput = computed(() => props.enabledInput && _focused.value || !props.modelValue);
    const formatLabel2 = () => {
      var _a22, _b2;
      if (props.modelValue) {
        return (_b2 = (_a22 = props.formatLabel) == null ? void 0 : _a22.call(props, props.modelValue)) != null ? _b2 : props.modelValue.label;
      }
      return "";
    };
    const mergedPlaceholder = computed(() => {
      if (props.enabledInput && props.modelValue) {
        return formatLabel2();
      }
      return props.placeholder;
    });
    const renderLabel = () => {
      var _a22, _b2;
      if (props.modelValue) {
        return (_b2 = (_a22 = slots.default) == null ? void 0 : _a22.call(slots, {
          data: props.modelValue
        })) != null ? _b2 : formatLabel2();
      }
      return null;
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-search`]: props.enabledInput,
      [`${prefixCls}-focus`]: mergedFocused.value,
      [`${prefixCls}-disabled`]: mergedDisabled.value,
      [`${prefixCls}-error`]: mergedError.value
    }]);
    const wrapperAttrs = computed(() => omit(attrs, INPUT_EVENTS));
    const inputAttrs = computed(() => pick(attrs, INPUT_EVENTS));
    const render2 = () => createVNode("span", mergeProps(wrapperAttrs.value, {
      "class": cls.value,
      "title": formatLabel2(),
      "onMousedown": handleMousedown
    }), [slots.prefix && createVNode("span", {
      "class": `${prefixCls}-prefix`
    }, [slots.prefix()]), createVNode("input", mergeProps(inputAttrs.value, {
      "ref": inputRef,
      "class": [`${prefixCls}-input`, {
        [`${prefixCls}-input-hidden`]: !showInput.value
      }],
      "value": computedInputValue.value,
      "readonly": !props.enabledInput,
      "placeholder": mergedPlaceholder.value,
      "disabled": mergedDisabled.value,
      "onInput": handleInput,
      "onFocus": handleFocus,
      "onBlur": handleBlur,
      "onCompositionstart": handleComposition,
      "onCompositionupdate": handleComposition,
      "onCompositionend": handleComposition
    }), null), createVNode("span", {
      "class": [`${prefixCls}-value`, {
        [`${prefixCls}-value-hidden`]: showInput.value
      }]
    }, [renderLabel()]), slots.suffix && createVNode("span", {
      "class": `${prefixCls}-suffix`
    }, [slots.suffix()])]);
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.focus();
    },
    blur() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.blur();
    }
  },
  render() {
    return this.render();
  }
});
var __defProp$e = Object.defineProperty;
var __getOwnPropSymbols$e = Object.getOwnPropertySymbols;
var __hasOwnProp$e = Object.prototype.hasOwnProperty;
var __propIsEnum$e = Object.prototype.propertyIsEnumerable;
var __defNormalProp$e = (obj, key, value) => key in obj ? __defProp$e(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$e = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$e.call(b2, prop))
      __defNormalProp$e(a, prop, b2[prop]);
  if (__getOwnPropSymbols$e)
    for (var prop of __getOwnPropSymbols$e(b2)) {
      if (__propIsEnum$e.call(b2, prop))
        __defNormalProp$e(a, prop, b2[prop]);
    }
  return a;
};
const getValueData = (value, fieldNames) => {
  const result = [];
  for (const item of value) {
    if (isObject$5(item)) {
      result.push({
        raw: item,
        value: item[fieldNames.value],
        label: item[fieldNames.label],
        closable: item[fieldNames.closable],
        tagProps: item[fieldNames.tagProps]
      });
    } else if (value || isNumber$2(value)) {
      const raw = {
        value: item,
        label: String(item),
        closable: true
      };
      result.push(__spreadValues$e({
        raw
      }, raw));
    }
  }
  return result;
};
const TAG_COLORS = ["red", "orangered", "orange", "gold", "lime", "green", "cyan", "blue", "arcoblue", "purple", "pinkpurple", "magenta", "gray"];
const _sfc_main$Z = defineComponent({
  name: "Tag",
  components: {
    IconHover,
    IconClose,
    IconLoading
  },
  props: {
    color: {
      type: String
    },
    size: {
      type: String
    },
    bordered: {
      type: Boolean,
      default: false
    },
    visible: {
      type: Boolean,
      default: void 0
    },
    defaultVisible: {
      type: Boolean,
      default: true
    },
    loading: {
      type: Boolean,
      default: false
    },
    closable: {
      type: Boolean,
      default: false
    },
    checkable: {
      type: Boolean,
      default: false
    },
    checked: {
      type: Boolean,
      default: void 0
    },
    defaultChecked: {
      type: Boolean,
      default: true
    }
  },
  emits: {
    "update:visible": (visible) => true,
    "update:checked": (checked) => true,
    "close": (ev) => true,
    "check": (checked, ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const {
      size: size2
    } = toRefs(props);
    const prefixCls = getPrefixCls("tag");
    const isBuiltInColor = computed(() => props.color && TAG_COLORS.includes(props.color));
    const isCustomColor = computed(() => props.color && !TAG_COLORS.includes(props.color));
    const _visible = ref(props.defaultVisible);
    const _checked = ref(props.defaultChecked);
    const computedVisible = computed(() => {
      var _a2;
      return (_a2 = props.visible) != null ? _a2 : _visible.value;
    });
    const computedChecked = computed(() => {
      var _a2;
      return props.checkable ? (_a2 = props.checked) != null ? _a2 : _checked.value : true;
    });
    const {
      mergedSize: _mergedSize
    } = useSize$1(size2);
    const mergedSize = computed(() => {
      if (_mergedSize.value === "mini") {
        return "small";
      }
      return _mergedSize.value;
    });
    const handleClose = (ev) => {
      _visible.value = false;
      emit2("update:visible", false);
      emit2("close", ev);
    };
    const handleClick = (ev) => {
      if (props.checkable) {
        const newChecked = !computedChecked.value;
        _checked.value = newChecked;
        emit2("update:checked", newChecked);
        emit2("check", newChecked, ev);
      }
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-loading`]: props.loading,
      [`${prefixCls}-hide`]: !computedVisible.value,
      [`${prefixCls}-${props.color}`]: isBuiltInColor.value,
      [`${prefixCls}-bordered`]: props.bordered,
      [`${prefixCls}-checkable`]: props.checkable,
      [`${prefixCls}-checked`]: computedChecked.value,
      [`${prefixCls}-custom-color`]: isCustomColor.value
    }]);
    const style2 = computed(() => {
      if (isCustomColor.value) {
        return {
          backgroundColor: props.color
        };
      }
      return void 0;
    });
    return {
      prefixCls,
      cls,
      style: style2,
      computedVisible,
      computedChecked,
      handleClick,
      handleClose
    };
  }
});
function _sfc_render$R(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_close = resolveComponent("icon-close");
  const _component_icon_hover = resolveComponent("icon-hover");
  const _component_icon_loading = resolveComponent("icon-loading");
  return _ctx.computedVisible ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.style),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [_ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-icon`)
  }, [renderSlot(_ctx.$slots, "icon")], 2)) : createCommentVNode("v-if", true), renderSlot(_ctx.$slots, "default"), _ctx.closable ? (openBlock(), createBlock(_component_icon_hover, {
    key: 1,
    role: "button",
    "aria-label": "Close",
    prefix: _ctx.prefixCls,
    class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
    onClick: withModifiers(_ctx.handleClose, ["stop"])
  }, {
    default: withCtx(() => [renderSlot(_ctx.$slots, "close-icon", {}, () => [createVNode(_component_icon_close)])]),
    _: 3
  }, 8, ["prefix", "class", "onClick"])) : createCommentVNode("v-if", true), _ctx.loading ? (openBlock(), createElementBlock("span", {
    key: 2,
    class: normalizeClass(`${_ctx.prefixCls}-loading-icon`)
  }, [createVNode(_component_icon_loading)], 2)) : createCommentVNode("v-if", true)], 6)) : createCommentVNode("v-if", true);
}
var _Tag = /* @__PURE__ */ _export_sfc$1(_sfc_main$Z, [["render", _sfc_render$R]]);
const Tag = Object.assign(_Tag, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Tag.name, _Tag);
  }
});
var __defProp$d = Object.defineProperty;
var __getOwnPropSymbols$d = Object.getOwnPropertySymbols;
var __hasOwnProp$d = Object.prototype.hasOwnProperty;
var __propIsEnum$d = Object.prototype.propertyIsEnumerable;
var __defNormalProp$d = (obj, key, value) => key in obj ? __defProp$d(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$d = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$d.call(b2, prop))
      __defNormalProp$d(a, prop, b2[prop]);
  if (__getOwnPropSymbols$d)
    for (var prop of __getOwnPropSymbols$d(b2)) {
      if (__propIsEnum$d.call(b2, prop))
        __defNormalProp$d(a, prop, b2[prop]);
    }
  return a;
};
const DEFAULT_FIELD_NAMES$1 = {
  value: "value",
  label: "label",
  closable: "closable",
  tagProps: "tagProps"
};
var _InputTag = defineComponent({
  name: "InputTag",
  inheritAttrs: false,
  props: {
    modelValue: {
      type: Array
    },
    defaultValue: {
      type: Array,
      default: () => []
    },
    inputValue: String,
    defaultInputValue: {
      type: String,
      default: ""
    },
    placeholder: String,
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    maxTagCount: {
      type: Number,
      default: 0
    },
    retainInputValue: {
      type: [Boolean, Object],
      default: false
    },
    formatTag: {
      type: Function
    },
    uniqueValue: {
      type: Boolean,
      default: false
    },
    fieldNames: {
      type: Object
    },
    baseCls: String,
    focused: Boolean,
    disabledInput: Boolean,
    uninjectFormItemContext: Boolean
  },
  emits: {
    "update:modelValue": (value) => true,
    "update:inputValue": (inputValue) => true,
    "change": (value, ev) => true,
    "inputValueChange": (inputValue, ev) => true,
    "pressEnter": (inputValue, ev) => true,
    "remove": (removed, ev) => true,
    "clear": (ev) => true,
    "focus": (ev) => true,
    "blur": (ev) => true
  },
  setup(props, {
    emit: emit2,
    slots,
    attrs
  }) {
    const {
      size: size2,
      disabled,
      error,
      uninjectFormItemContext,
      modelValue
    } = toRefs(props);
    const prefixCls = props.baseCls || getPrefixCls("input-tag");
    const inputRef = ref();
    const mirrorRef = ref();
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      mergedError,
      feedback,
      eventHandlers
    } = useFormItem({
      size: size2,
      disabled,
      error,
      uninject: uninjectFormItemContext == null ? void 0 : uninjectFormItemContext.value
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const mergedFieldNames = computed(() => __spreadValues$d(__spreadValues$d({}, DEFAULT_FIELD_NAMES$1), props.fieldNames));
    const _focused = ref(false);
    const _value = ref(props.defaultValue);
    const _inputValue = ref(props.defaultInputValue);
    const isComposition = ref(false);
    const compositionValue = ref("");
    const retainInputValue = computed(() => {
      if (isObject$5(props.retainInputValue)) {
        return __spreadValues$d({
          create: false,
          blur: false
        }, props.retainInputValue);
      }
      return {
        create: props.retainInputValue,
        blur: props.retainInputValue
      };
    });
    const inputStyle = reactive({
      width: "12px"
    });
    const mergedFocused = computed(() => props.focused || _focused.value);
    const updateInputValue = (value, ev) => {
      _inputValue.value = value;
      emit2("update:inputValue", value);
      emit2("inputValueChange", value, ev);
    };
    const handleComposition = (ev) => {
      var _a2;
      const {
        value
      } = ev.target;
      if (ev.type === "compositionend") {
        isComposition.value = false;
        compositionValue.value = "";
        updateInputValue(value, ev);
        nextTick(() => {
          if (inputRef.value && computedInputValue.value !== inputRef.value.value) {
            inputRef.value.value = computedInputValue.value;
          }
        });
      } else {
        isComposition.value = true;
        compositionValue.value = computedInputValue.value + ((_a2 = ev.data) != null ? _a2 : "");
      }
    };
    const computedValue = computed(() => {
      var _a2;
      return (_a2 = props.modelValue) != null ? _a2 : _value.value;
    });
    const computedInputValue = computed(() => {
      var _a2;
      return (_a2 = props.inputValue) != null ? _a2 : _inputValue.value;
    });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = [];
      }
    });
    const handleMousedown = (e2) => {
      if (inputRef.value && e2.target !== inputRef.value) {
        e2.preventDefault();
        inputRef.value.focus();
      }
    };
    const handleInput = (ev) => {
      const {
        value
      } = ev.target;
      if (!isComposition.value) {
        updateInputValue(value, ev);
        nextTick(() => {
          if (inputRef.value && computedInputValue.value !== inputRef.value.value) {
            inputRef.value.value = computedInputValue.value;
          }
        });
      }
    };
    const valueData = computed(() => getValueData(computedValue.value, mergedFieldNames.value));
    const tags = computed(() => {
      if (props.maxTagCount > 0) {
        const invisibleTags = valueData.value.length - props.maxTagCount;
        if (invisibleTags > 0) {
          const result = valueData.value.slice(0, props.maxTagCount);
          const raw = {
            value: "__arco__more",
            label: `+${invisibleTags}...`,
            closable: false
          };
          result.push(__spreadValues$d({
            raw
          }, raw));
          return result;
        }
      }
      return valueData.value;
    });
    const updateValue = (value, ev) => {
      var _a2, _b2;
      _value.value = value;
      emit2("update:modelValue", value);
      emit2("change", value, ev);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onChange) == null ? void 0 : _b2.call(_a2, ev);
    };
    const handleRemove = (value, index2, e2) => {
      var _a2;
      const newValue = (_a2 = computedValue.value) == null ? void 0 : _a2.filter((_2, i2) => i2 !== index2);
      updateValue(newValue, e2);
      emit2("remove", value, e2);
    };
    const handleClear = (e2) => {
      const newValue = [];
      updateValue(newValue, e2);
      emit2("clear", e2);
    };
    const showClearBtn = computed(() => !mergedDisabled.value && !props.readonly && props.allowClear && Boolean(computedValue.value.length));
    const handlePressEnter = (e2) => {
      var _a2;
      if (computedInputValue.value) {
        e2.preventDefault();
        if (props.uniqueValue && ((_a2 = computedValue.value) == null ? void 0 : _a2.includes(computedInputValue.value))) {
          emit2("pressEnter", computedInputValue.value, e2);
          return;
        }
        const newValue = computedValue.value.concat(computedInputValue.value);
        updateValue(newValue, e2);
        emit2("pressEnter", computedInputValue.value, e2);
        if (!retainInputValue.value.create) {
          updateInputValue("", e2);
        }
      }
    };
    const handleFocus = (ev) => {
      var _a2, _b2;
      _focused.value = true;
      emit2("focus", ev);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onFocus) == null ? void 0 : _b2.call(_a2, ev);
    };
    const handleBlur = (ev) => {
      var _a2, _b2;
      _focused.value = false;
      if (!retainInputValue.value.blur && computedInputValue.value) {
        updateInputValue("", ev);
      }
      emit2("blur", ev);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onBlur) == null ? void 0 : _b2.call(_a2, ev);
    };
    const getLastClosableIndex = () => {
      for (let i2 = valueData.value.length - 1; i2 >= 0; i2--) {
        if (valueData.value[i2].closable) {
          return i2;
        }
      }
      return -1;
    };
    const handleKeyDown = (e2) => {
      const keyCode = e2.key || e2.code;
      if (!isComposition.value && computedInputValue.value && keyCode === Enter.key) {
        handlePressEnter(e2);
      }
      if (!isComposition.value && tags.value.length > 0 && !computedInputValue.value && keyCode === Backspace.key) {
        const lastIndex = getLastClosableIndex();
        if (lastIndex >= 0) {
          handleRemove(valueData.value[lastIndex].value, lastIndex, e2);
        }
      }
    };
    const setInputWidth = (width) => {
      if (width > 12) {
        inputStyle.width = `${width}px`;
      } else {
        inputStyle.width = "12px";
      }
    };
    onMounted(() => {
      if (mirrorRef.value) {
        setInputWidth(mirrorRef.value.offsetWidth);
      }
    });
    const handleResize = () => {
      if (mirrorRef.value) {
        setInputWidth(mirrorRef.value.offsetWidth);
      }
    };
    watch(computedInputValue, (value) => {
      if (inputRef.value && !isComposition.value && value !== inputRef.value.value) {
        inputRef.value.value = value;
      }
    });
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-disabled`]: mergedDisabled.value,
      [`${prefixCls}-disabled-input`]: props.disabledInput,
      [`${prefixCls}-error`]: mergedError.value,
      [`${prefixCls}-focus`]: mergedFocused.value,
      [`${prefixCls}-readonly`]: props.readonly,
      [`${prefixCls}-has-tag`]: tags.value.length > 0,
      [`${prefixCls}-has-prefix`]: Boolean(slots.prefix),
      [`${prefixCls}-has-suffix`]: Boolean(slots.suffix) || showClearBtn.value || feedback.value,
      [`${prefixCls}-has-placeholder`]: !computedValue.value.length
    }]);
    const wrapperAttrs = computed(() => omit(attrs, INPUT_EVENTS));
    const inputAttrs = computed(() => pick(attrs, INPUT_EVENTS));
    const render2 = () => {
      var _a2;
      return createVNode("span", mergeProps({
        "class": cls.value,
        "onMousedown": handleMousedown
      }, wrapperAttrs.value), [createVNode(ResizeObserver$2, {
        "onResize": handleResize
      }, {
        default: () => [createVNode("span", {
          "ref": mirrorRef,
          "class": `${prefixCls}-mirror`
        }, [tags.value.length > 0 ? compositionValue.value || computedInputValue.value : compositionValue.value || computedInputValue.value || props.placeholder])]
      }), slots.prefix && createVNode("span", {
        "class": `${prefixCls}-prefix`
      }, [slots.prefix()]), createVNode(TransitionGroup, {
        "tag": "span",
        "name": "input-tag-zoom",
        "class": `${prefixCls}-inner`
      }, {
        default: () => [tags.value.map((item, index2) => createVNode(Tag, mergeProps({
          "key": `tag-${item.value}`,
          "class": `${prefixCls}-tag`,
          "closable": !mergedDisabled.value && !props.readonly && item.closable,
          "visible": true
        }, item.tagProps, {
          "onClose": (ev) => handleRemove(item.value, index2, ev)
        }), {
          default: () => {
            var _a22, _b2, _c2, _d;
            return [(_d = (_c2 = (_a22 = slots.tag) == null ? void 0 : _a22.call(slots, {
              data: item.raw
            })) != null ? _c2 : (_b2 = props.formatTag) == null ? void 0 : _b2.call(props, item.raw)) != null ? _d : item.label];
          }
        })), createVNode("input", mergeProps(inputAttrs.value, {
          "ref": inputRef,
          "key": "input-tag-input",
          "class": `${prefixCls}-input`,
          "style": inputStyle,
          "placeholder": tags.value.length === 0 ? props.placeholder : void 0,
          "disabled": mergedDisabled.value,
          "readonly": props.readonly || props.disabledInput,
          "onInput": handleInput,
          "onKeydown": handleKeyDown,
          "onFocus": handleFocus,
          "onBlur": handleBlur,
          "onCompositionstart": handleComposition,
          "onCompositionupdate": handleComposition,
          "onCompositionend": handleComposition
        }), null)]
      }), showClearBtn.value && createVNode(IconHover, {
        "class": `${prefixCls}-clear-btn`,
        "onClick": handleClear,
        "onMousedown": (e2) => e2.stopPropagation()
      }, {
        default: () => [createVNode(IconClose, null, null)]
      }), (slots.suffix || Boolean(feedback.value)) && createVNode("span", {
        "class": `${prefixCls}-suffix`
      }, [(_a2 = slots.suffix) == null ? void 0 : _a2.call(slots), Boolean(feedback.value) && createVNode(FeedbackIcon, {
        "type": feedback.value
      }, null)])]);
    };
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.focus();
    },
    blur() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.blur();
    }
  },
  render() {
    return this.render();
  }
});
const InputTag = Object.assign(_InputTag, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _InputTag.name, _InputTag);
  }
});
var SelectView = defineComponent({
  name: "SelectView",
  props: {
    modelValue: {
      type: Array,
      required: true
    },
    inputValue: String,
    placeholder: String,
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    opened: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    bordered: {
      type: Boolean,
      default: true
    },
    multiple: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    allowCreate: {
      type: Boolean,
      default: false
    },
    allowSearch: {
      type: Boolean,
      default: (props) => isArray$4(props.modelValue)
    },
    maxTagCount: {
      type: Number,
      default: 0
    },
    retainInputValue: {
      type: Boolean,
      default: false
    }
  },
  emits: ["remove", "clear", "focus", "blur"],
  setup(props, {
    emit: emit2,
    slots
  }) {
    const {
      size: size2,
      disabled,
      error
    } = toRefs(props);
    const prefixCls = getPrefixCls("select-view");
    const {
      feedback,
      eventHandlers,
      mergedDisabled,
      mergedSize: _mergedSize,
      mergedError
    } = useFormItem({
      size: size2,
      disabled,
      error
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const {
      opened
    } = toRefs(props);
    const componentRef = ref();
    const inputRef = computed(() => {
      var _a2;
      return (_a2 = componentRef.value) == null ? void 0 : _a2.inputRef;
    });
    const isEmptyValue2 = computed(() => props.modelValue.length === 0);
    const enabledInput = computed(() => props.allowSearch || props.allowCreate);
    const showClearBtn = computed(() => props.allowClear && !props.disabled && !isEmptyValue2.value);
    const handleFocus = (ev) => {
      var _a2, _b2;
      emit2("focus", ev);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onFocus) == null ? void 0 : _b2.call(_a2, ev);
    };
    const handleBlur = (ev) => {
      var _a2, _b2;
      emit2("blur", ev);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onBlur) == null ? void 0 : _b2.call(_a2, ev);
    };
    const handleRemove = (tag) => {
      emit2("remove", tag);
    };
    const handleClear = (ev) => {
      emit2("clear", ev);
    };
    const renderIcon = () => {
      var _a2, _b2, _c2, _d;
      if (props.loading) {
        return (_b2 = (_a2 = slots["loading-icon"]) == null ? void 0 : _a2.call(slots)) != null ? _b2 : createVNode(IconLoading, null, null);
      }
      if (props.allowSearch && props.opened) {
        return (_d = (_c2 = slots["search-icon"]) == null ? void 0 : _c2.call(slots)) != null ? _d : createVNode(IconSearch, null, null);
      }
      if (slots["arrow-icon"]) {
        return slots["arrow-icon"]();
      }
      return createVNode(IconDown, {
        "class": `${prefixCls}-arrow-icon`
      }, null);
    };
    const renderSuffix = () => createVNode(Fragment, null, [showClearBtn.value && createVNode(IconHover, {
      "class": `${prefixCls}-clear-btn`,
      "onClick": handleClear,
      "onMousedown": (ev) => ev.stopPropagation()
    }, {
      default: () => [createVNode(IconClose, null, null)]
    }), createVNode("span", {
      "class": `${prefixCls}-icon`
    }, [renderIcon()]), Boolean(feedback.value) && createVNode(FeedbackIcon, {
      "type": feedback.value
    }, null)]);
    watch(opened, (opened2) => {
      if (!opened2 && inputRef.value && inputRef.value.isSameNode(document.activeElement)) {
        inputRef.value.blur();
      }
    });
    const cls = computed(() => [`${prefixCls}-${props.multiple ? "multiple" : "single"}`, {
      [`${prefixCls}-opened`]: props.opened,
      [`${prefixCls}-borderless`]: !props.bordered
    }]);
    const render2 = () => {
      if (props.multiple) {
        return createVNode(InputTag, {
          "ref": componentRef,
          "baseCls": prefixCls,
          "class": cls.value,
          "modelValue": props.modelValue,
          "inputValue": props.inputValue,
          "focused": props.opened,
          "placeholder": props.placeholder,
          "disabled": mergedDisabled.value,
          "size": mergedSize.value,
          "error": mergedError.value,
          "maxTagCount": props.maxTagCount,
          "disabledInput": !props.allowSearch && !props.allowCreate,
          "retainInputValue": true,
          "uninjectFormItemContext": true,
          "onRemove": handleRemove,
          "onFocus": handleFocus,
          "onBlur": handleBlur
        }, {
          prefix: slots.prefix,
          suffix: renderSuffix,
          tag: slots.label
        });
      }
      return createVNode(InputLabel, {
        "ref": componentRef,
        "baseCls": prefixCls,
        "class": cls.value,
        "modelValue": props.modelValue[0],
        "inputValue": props.inputValue,
        "focused": props.opened,
        "placeholder": props.placeholder,
        "disabled": mergedDisabled.value,
        "size": mergedSize.value,
        "error": mergedError.value,
        "enabledInput": enabledInput.value,
        "uninjectFormItemContext": true,
        "onFocus": handleFocus,
        "onBlur": handleBlur
      }, {
        default: slots.label,
        prefix: slots.prefix,
        suffix: renderSuffix
      });
    };
    return {
      inputRef,
      handleFocus,
      handleBlur,
      render: render2
    };
  },
  methods: {
    focus() {
      if (this.inputRef) {
        this.inputRef.focus();
      }
    },
    blur() {
      if (this.inputRef) {
        this.inputRef.blur();
      }
    }
  },
  render() {
    return this.render();
  }
});
const _sfc_main$Y = defineComponent({
  name: "Optgroup",
  props: {
    label: {
      type: String
    }
  },
  setup() {
    const prefixCls = getPrefixCls("select-group");
    return {
      prefixCls
    };
  }
});
function _sfc_render$Q(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock(Fragment, null, [createBaseVNode("li", {
    class: normalizeClass(`${_ctx.prefixCls}-title`)
  }, [renderSlot(_ctx.$slots, "label", {}, () => [createTextVNode(toDisplayString$1(_ctx.label), 1)])], 2), renderSlot(_ctx.$slots, "default")], 64);
}
var Optgroup = /* @__PURE__ */ _export_sfc$1(_sfc_main$Y, [["render", _sfc_render$Q]]);
const useSize = ({
  dataKeys,
  contentRef,
  fixedSize,
  estimatedSize,
  buffer
}) => {
  const firstRangeAverageSize = ref(0);
  const sizeMap = /* @__PURE__ */ new Map();
  const total2 = computed(() => dataKeys.value.length);
  const start2 = ref(0);
  const end2 = computed(() => {
    const _end = start2.value + buffer.value * 3;
    if (_end > total2.value)
      return total2.value;
    return _end;
  });
  const maxStart = computed(() => {
    const max3 = total2.value - buffer.value * 3;
    if (max3 < 0)
      return 0;
    return max3;
  });
  const setStart = (index2) => {
    if (index2 < 0) {
      start2.value = 0;
    } else if (index2 > maxStart.value) {
      start2.value = maxStart.value;
    } else {
      start2.value = index2;
    }
  };
  const isFixed = ref(fixedSize.value);
  const _estimatedSize = computed(() => {
    if (estimatedSize.value !== 30) {
      return estimatedSize.value;
    }
    return firstRangeAverageSize.value || estimatedSize.value;
  });
  const setItemSize = (key, size2) => {
    sizeMap.set(key, size2);
  };
  const getItemSize = (index2) => {
    var _a2;
    if (isFixed.value) {
      return _estimatedSize.value;
    }
    const _key = dataKeys.value[index2];
    return (_a2 = sizeMap.get(_key)) != null ? _a2 : _estimatedSize.value;
  };
  const hasItemSize = (key) => {
    return sizeMap.has(key);
  };
  onMounted(() => {
    const firstRangeTotalSize = Array.from(sizeMap.values()).reduce((pre, value) => pre + value, 0);
    if (firstRangeTotalSize > 0) {
      firstRangeAverageSize.value = firstRangeTotalSize / sizeMap.size;
    }
  });
  const getScrollOffset = (index2) => {
    if (isFixed.value) {
      return _estimatedSize.value * index2;
    }
    return getOffset(0, index2);
  };
  const getOffset = (start22, end22) => {
    let offset = 0;
    for (let i2 = start22; i2 < end22; i2++) {
      offset += getItemSize(i2);
    }
    return offset;
  };
  const frontPadding = computed(() => {
    if (isFixed.value) {
      return _estimatedSize.value * start2.value;
    }
    return getOffset(0, start2.value);
  });
  const getOffsetIndex = (scrollOffset) => {
    const isForward = scrollOffset >= frontPadding.value;
    let offset = Math.abs(scrollOffset - frontPadding.value);
    const _start = isForward ? start2.value : start2.value - 1;
    let offsetIndex = 0;
    while (offset > 0) {
      offset -= getItemSize(_start + offsetIndex);
      isForward ? offsetIndex++ : offsetIndex--;
    }
    return offsetIndex;
  };
  const getStartByScroll = (scrollOffset) => {
    const offsetIndex = getOffsetIndex(scrollOffset);
    const _start = start2.value + offsetIndex - buffer.value;
    if (_start < 0)
      return 0;
    if (_start > maxStart.value)
      return maxStart.value;
    return _start;
  };
  const behindPadding = computed(() => {
    if (isFixed.value) {
      return _estimatedSize.value * (total2.value - end2.value);
    }
    return getOffset(end2.value, total2.value);
  });
  return {
    frontPadding,
    behindPadding,
    start: start2,
    end: end2,
    getStartByScroll,
    setItemSize,
    hasItemSize,
    setStart,
    getScrollOffset
  };
};
var VirtualListItem = defineComponent({
  name: "VirtualListItem",
  props: {
    hasItemSize: {
      type: Function,
      required: true
    },
    setItemSize: {
      type: Function,
      required: true
    }
  },
  setup(props, {
    slots
  }) {
    var _a2;
    const key = (_a2 = getCurrentInstance()) == null ? void 0 : _a2.vnode.key;
    const itemRef = ref();
    const setItemSize = () => {
      var _a22, _b2, _c2, _d;
      const ele = (_b2 = (_a22 = itemRef.value) == null ? void 0 : _a22.$el) != null ? _b2 : itemRef.value;
      const height = (_d = (_c2 = ele == null ? void 0 : ele.getBoundingClientRect) == null ? void 0 : _c2.call(ele).height) != null ? _d : ele == null ? void 0 : ele.offsetHeight;
      if (height) {
        props.setItemSize(key, height);
      }
    };
    onMounted(() => setItemSize());
    onBeforeUnmount(() => setItemSize());
    return () => {
      var _a22;
      const child = getFirstComponent((_a22 = slots.default) == null ? void 0 : _a22.call(slots));
      if (child) {
        return cloneVNode(child, {
          ref: itemRef
        }, true);
      }
      return null;
    };
  }
});
var __defProp$c = Object.defineProperty;
var __getOwnPropSymbols$c = Object.getOwnPropertySymbols;
var __hasOwnProp$c = Object.prototype.hasOwnProperty;
var __propIsEnum$c = Object.prototype.propertyIsEnumerable;
var __defNormalProp$c = (obj, key, value) => key in obj ? __defProp$c(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$c = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$c.call(b2, prop))
      __defNormalProp$c(a, prop, b2[prop]);
  if (__getOwnPropSymbols$c)
    for (var prop of __getOwnPropSymbols$c(b2)) {
      if (__propIsEnum$c.call(b2, prop))
        __defNormalProp$c(a, prop, b2[prop]);
    }
  return a;
};
const _sfc_main$X = defineComponent({
  name: "VirtualList",
  components: {
    VirtualListItem
  },
  props: {
    height: {
      type: [Number, String],
      default: 200
    },
    data: {
      type: Array,
      default: () => []
    },
    threshold: {
      type: Number,
      default: 0
    },
    itemKey: {
      type: String,
      default: "key"
    },
    fixedSize: {
      type: Boolean,
      default: false
    },
    estimatedSize: {
      type: Number,
      default: 30
    },
    buffer: {
      type: Number,
      default: 10
    },
    component: {
      type: [String, Object],
      default: "div"
    },
    listAttrs: {
      type: Object
    },
    contentAttrs: {
      type: Object
    },
    paddingPosition: {
      type: String,
      default: "content"
    }
  },
  emits: {
    scroll: (ev) => true,
    reachBottom: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const {
      data,
      itemKey,
      fixedSize,
      estimatedSize,
      buffer,
      height
    } = toRefs(props);
    const prefixCls = getPrefixCls("virtual-list");
    const mergedComponent = computed(() => {
      if (isObject$5(props.component)) {
        return __spreadValues$c({
          container: "div",
          list: "div",
          content: "div"
        }, props.component);
      }
      return {
        container: props.component,
        list: "div",
        content: "div"
      };
    });
    const containerRef = ref();
    const contentRef = ref();
    const style2 = computed(() => {
      return {
        height: isNumber$2(height.value) ? `${height.value}px` : height.value,
        overflow: "auto"
      };
    });
    const dataKeys = computed(() => data.value.map((item, index2) => {
      var _a2;
      return (_a2 = item[itemKey.value]) != null ? _a2 : index2;
    }));
    const {
      frontPadding,
      behindPadding,
      start: start2,
      end: end2,
      getStartByScroll,
      setItemSize,
      hasItemSize,
      setStart,
      getScrollOffset
    } = useSize({
      dataKeys,
      contentRef,
      fixedSize,
      estimatedSize,
      buffer
    });
    const currentList = computed(() => {
      if (props.threshold && data.value.length <= props.threshold) {
        return data.value;
      }
      return data.value.slice(start2.value, end2.value);
    });
    const onScroll = (ev) => {
      const {
        scrollTop,
        scrollHeight,
        offsetHeight
      } = ev.target;
      const _start = getStartByScroll(scrollTop);
      if (_start !== start2.value) {
        setStart(_start);
      }
      emit2("scroll", ev);
      const bottom = Math.floor(scrollHeight - (scrollTop + offsetHeight));
      if (bottom <= 0) {
        emit2("reachBottom", ev);
      }
    };
    const scrollTo = (options) => {
      var _a2, _b2;
      if (containerRef.value) {
        if (isNumber$2(options)) {
          containerRef.value.scrollTop = options;
        } else {
          const _index = (_b2 = options.index) != null ? _b2 : dataKeys.value.indexOf((_a2 = options.key) != null ? _a2 : "");
          setStart(_index - buffer.value);
          containerRef.value.scrollTop = getScrollOffset(_index);
          nextTick(() => {
            if (containerRef.value) {
              const _scrollTop = getScrollOffset(_index);
              if (_scrollTop !== containerRef.value.scrollTop) {
                containerRef.value.scrollTop = _scrollTop;
              }
            }
          });
        }
      }
    };
    return {
      prefixCls,
      containerRef,
      contentRef,
      frontPadding,
      currentList,
      behindPadding,
      onScroll,
      setItemSize,
      hasItemSize,
      start: start2,
      scrollTo,
      style: style2,
      mergedComponent
    };
  }
});
function _sfc_render$P(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_VirtualListItem = resolveComponent("VirtualListItem");
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.mergedComponent.container), {
    ref: "containerRef",
    class: normalizeClass(_ctx.prefixCls),
    style: normalizeStyle$1(_ctx.style),
    onScroll: _ctx.onScroll
  }, {
    default: withCtx(() => [(openBlock(), createBlock(resolveDynamicComponent(_ctx.mergedComponent.list), mergeProps(_ctx.listAttrs, {
      style: _ctx.paddingPosition === "list" ? {
        paddingTop: `${_ctx.frontPadding}px`,
        paddingBottom: `${_ctx.behindPadding}px`
      } : {}
    }), {
      default: withCtx(() => [(openBlock(), createBlock(resolveDynamicComponent(_ctx.mergedComponent.content), mergeProps({
        ref: "contentRef"
      }, _ctx.contentAttrs, {
        style: _ctx.paddingPosition === "content" ? {
          paddingTop: `${_ctx.frontPadding}px`,
          paddingBottom: `${_ctx.behindPadding}px`
        } : {}
      }), {
        default: withCtx(() => [(openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.currentList, (item, index2) => {
          var _a2;
          return openBlock(), createBlock(_component_VirtualListItem, {
            key: (_a2 = item[_ctx.itemKey]) != null ? _a2 : _ctx.start + index2,
            "has-item-size": _ctx.hasItemSize,
            "set-item-size": _ctx.setItemSize
          }, {
            default: withCtx(() => [renderSlot(_ctx.$slots, "item", {
              item,
              index: _ctx.start + index2
            })]),
            _: 2
          }, 1032, ["has-item-size", "set-item-size"]);
        }), 128))]),
        _: 3
      }, 16, ["style"]))]),
      _: 3
    }, 16, ["style"]))]),
    _: 3
  }, 8, ["class", "style", "onScroll"]);
}
var VirtualList = /* @__PURE__ */ _export_sfc$1(_sfc_main$X, [["render", _sfc_render$P]]);
const target = typeof window === "undefined" ? global : window;
function debounce(callback, delay) {
  let timer = 0;
  return (...args) => {
    if (timer) {
      target.clearTimeout(timer);
    }
    timer = target.setTimeout(() => {
      timer = 0;
      callback(...args);
    }, delay);
  };
}
var __defProp$b = Object.defineProperty;
var __defProps$6 = Object.defineProperties;
var __getOwnPropDescs$6 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$b = Object.getOwnPropertySymbols;
var __hasOwnProp$b = Object.prototype.hasOwnProperty;
var __propIsEnum$b = Object.prototype.propertyIsEnumerable;
var __defNormalProp$b = (obj, key, value) => key in obj ? __defProp$b(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$b = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$b.call(b2, prop))
      __defNormalProp$b(a, prop, b2[prop]);
  if (__getOwnPropSymbols$b)
    for (var prop of __getOwnPropSymbols$b(b2)) {
      if (__propIsEnum$b.call(b2, prop))
        __defNormalProp$b(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$6 = (a, b2) => __defProps$6(a, __getOwnPropDescs$6(b2));
function _isSlot$3(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode$1(s);
}
const DEFAULT_FIELD_NAMES = {
  value: "value",
  label: "label",
  disabled: "disabled",
  tagProps: "tagProps",
  render: "render"
};
var _Select = defineComponent({
  name: "Select",
  components: {
    Trigger,
    SelectView
  },
  inheritAttrs: false,
  props: {
    multiple: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: [String, Number, Object, Array]
    },
    defaultValue: {
      type: [String, Number, Object, Array],
      default: (props) => isUndefined(props.multiple) ? "" : []
    },
    inputValue: {
      type: String
    },
    defaultInputValue: {
      type: String,
      default: ""
    },
    size: {
      type: String
    },
    placeholder: String,
    loading: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    allowSearch: {
      type: [Boolean, Object],
      default: (props) => Boolean(props.multiple)
    },
    allowCreate: {
      type: Boolean,
      default: false
    },
    maxTagCount: {
      type: Number,
      default: 0
    },
    popupContainer: {
      type: [String, Object]
    },
    bordered: {
      type: Boolean,
      default: true
    },
    defaultActiveFirstOption: {
      type: Boolean,
      default: true
    },
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    unmountOnClose: {
      type: Boolean,
      default: false
    },
    filterOption: {
      type: [Boolean, Function],
      default: true
    },
    options: {
      type: Array,
      default: () => []
    },
    virtualListProps: {
      type: Object
    },
    triggerProps: {
      type: Object
    },
    formatLabel: {
      type: Function
    },
    fallbackOption: {
      type: [Boolean, Function],
      default: true
    },
    showExtraOptions: {
      type: Boolean,
      default: true
    },
    valueKey: {
      type: String,
      default: "value"
    },
    searchDelay: {
      type: Number,
      default: 500
    },
    limit: {
      type: Number,
      default: 0
    },
    fieldNames: {
      type: Object
    },
    scrollbar: {
      type: [Boolean, Object],
      default: true
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "update:inputValue": (inputValue) => true,
    "update:popupVisible": (visible) => true,
    "change": (value) => true,
    "inputValueChange": (inputValue) => true,
    "popupVisibleChange": (visible) => true,
    "clear": (ev) => true,
    "remove": (removed) => true,
    "search": (inputValue) => true,
    "dropdownScroll": (ev) => true,
    "dropdownReachBottom": (ev) => true,
    "exceedLimit": (value, ev) => true
  },
  setup(props, {
    slots,
    emit: emit2,
    attrs
  }) {
    const {
      size: size2,
      disabled,
      error,
      options,
      filterOption,
      valueKey,
      multiple,
      popupVisible,
      showExtraOptions,
      modelValue,
      fieldNames,
      loading,
      defaultActiveFirstOption
    } = toRefs(props);
    const prefixCls = getPrefixCls("select");
    const {
      mergedSize,
      mergedDisabled,
      mergedError,
      eventHandlers
    } = useFormItem({
      size: size2,
      disabled,
      error
    });
    const component = computed(() => props.virtualListProps ? "div" : "li");
    const retainInputValue = computed(() => isObject$5(props.allowSearch) && Boolean(props.allowSearch.retainInputValue));
    computed(() => {
      if (isFunction$3(props.formatLabel)) {
        return (data) => {
          const optionInfo = optionInfoMap.get(data.value);
          return props.formatLabel(optionInfo);
        };
      }
      return void 0;
    });
    const dropdownRef = ref();
    const optionRefs = ref({});
    const virtualListRef = ref();
    const {
      computedPopupVisible,
      handlePopupVisibleChange
    } = useTrigger({
      popupVisible,
      emit: emit2
    });
    const _value = ref(props.defaultValue);
    const computedValueObjects = computed(() => {
      var _a2;
      const mergedValue = (_a2 = props.modelValue) != null ? _a2 : _value.value;
      const valueArray = isArray$4(mergedValue) ? mergedValue : mergedValue || isNumber$2(mergedValue) || isString$3(mergedValue) ? [mergedValue] : [];
      return valueArray.map((value) => ({
        value,
        key: getKeyFromValue(value, props.valueKey)
      }));
    });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = multiple.value ? [] : value;
      }
    });
    const computedValueKeys = computed(() => computedValueObjects.value.map((obj) => obj.key));
    const mergedFieldNames = computed(() => __spreadValues$b(__spreadValues$b({}, DEFAULT_FIELD_NAMES), fieldNames == null ? void 0 : fieldNames.value));
    const _selectedOption = ref();
    const getRawOptionFromValueKeys = (valueKeys) => {
      const optionMap = {};
      valueKeys.forEach((key) => {
        optionMap[key] = optionInfoMap.get(key);
      });
      return optionMap;
    };
    const updateSelectedOption = (valueKeys) => {
      _selectedOption.value = getRawOptionFromValueKeys(valueKeys);
    };
    const getFallBackOption = (value) => {
      if (isFunction$3(props.fallbackOption)) {
        return props.fallbackOption(value);
      }
      return {
        [mergedFieldNames.value.value]: value,
        [mergedFieldNames.value.label]: String(isObject$5(value) ? value[valueKey == null ? void 0 : valueKey.value] : value)
      };
    };
    const getExtraValueData = () => {
      const valueArray = [];
      const keyArray = [];
      if (props.allowCreate || props.fallbackOption) {
        for (const item of computedValueObjects.value) {
          if (!keyArray.includes(item.key) && item.value !== "") {
            const optionInfo = optionInfoMap.get(item.key);
            if (!optionInfo || optionInfo.origin === "extraOptions") {
              valueArray.push(item);
              keyArray.push(item.key);
            }
          }
        }
      }
      if (props.allowCreate && computedInputValue.value) {
        const key = getKeyFromValue(computedInputValue.value);
        if (!keyArray.includes(key)) {
          const optionInfo = optionInfoMap.get(key);
          if (!optionInfo || optionInfo.origin === "extraOptions") {
            valueArray.push({
              value: computedInputValue.value,
              key
            });
          }
        }
      }
      return valueArray;
    };
    const extraValueObjects = ref([]);
    const extraOptions = computed(() => extraValueObjects.value.map((obj) => {
      var _a2;
      let optionInfo = getFallBackOption(obj.value);
      const extraOptionRawInfo = (_a2 = _selectedOption.value) == null ? void 0 : _a2[obj.key];
      if (!isUndefined(extraOptionRawInfo) && !isEmptyObject$1(extraOptionRawInfo)) {
        optionInfo = __spreadValues$b(__spreadValues$b({}, optionInfo), extraOptionRawInfo);
      }
      return optionInfo;
    }));
    nextTick(() => {
      watchEffect(() => {
        var _a2;
        const valueData = getExtraValueData();
        if (valueData.length !== extraValueObjects.value.length) {
          extraValueObjects.value = valueData;
        } else if (valueData.length > 0) {
          for (let i2 = 0; i2 < valueData.length; i2++) {
            if (valueData[i2].key !== ((_a2 = extraValueObjects.value[i2]) == null ? void 0 : _a2.key)) {
              extraValueObjects.value = valueData;
              break;
            }
          }
        }
      });
    });
    const _inputValue = ref("");
    const computedInputValue = computed(() => {
      var _a2;
      return (_a2 = props.inputValue) != null ? _a2 : _inputValue.value;
    });
    watch(computedPopupVisible, (visible) => {
      if (!visible && !retainInputValue.value && computedInputValue.value) {
        updateInputValue("");
      }
    });
    const getValueFromValueKeys = (valueKeys) => {
      var _a2, _b2;
      if (!props.multiple) {
        return (_b2 = (_a2 = optionInfoMap.get(valueKeys[0])) == null ? void 0 : _a2.value) != null ? _b2 : hasEmptyStringKey(optionInfoMap) ? void 0 : "";
      }
      return valueKeys.map((key) => {
        var _a22, _b22;
        return (_b22 = (_a22 = optionInfoMap.get(key)) == null ? void 0 : _a22.value) != null ? _b22 : "";
      });
    };
    const updateValue = (valueKeys) => {
      var _a2, _b2;
      const value = getValueFromValueKeys(valueKeys);
      _value.value = value;
      emit2("update:modelValue", value);
      emit2("change", value);
      (_b2 = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onChange) == null ? void 0 : _b2.call(_a2);
      updateSelectedOption(valueKeys);
    };
    const updateInputValue = (inputValue) => {
      _inputValue.value = inputValue;
      emit2("update:inputValue", inputValue);
      emit2("inputValueChange", inputValue);
    };
    const handleSelect = (key, ev) => {
      if (props.multiple) {
        if (!computedValueKeys.value.includes(key)) {
          if (enabledOptionKeys.value.includes(key)) {
            if (props.limit > 0 && computedValueKeys.value.length >= props.limit) {
              const info = optionInfoMap.get(key);
              emit2("exceedLimit", info == null ? void 0 : info.value, ev);
            } else {
              const valueKeys = computedValueKeys.value.concat(key);
              updateValue(valueKeys);
            }
          }
        } else {
          const valueKeys = computedValueKeys.value.filter((_key) => _key !== key);
          updateValue(valueKeys);
        }
        if (!retainInputValue.value) {
          updateInputValue("");
        }
      } else {
        if (key !== computedValueKeys.value[0]) {
          updateValue([key]);
        }
        if (retainInputValue.value) {
          const optionInfo = optionInfoMap.get(key);
          if (optionInfo) {
            updateInputValue(optionInfo.label);
          }
        }
        handlePopupVisibleChange(false);
      }
    };
    const handleSearch = debounce((value) => {
      emit2("search", value);
    }, props.searchDelay);
    const handleInputValueChange = (inputValue) => {
      if (inputValue !== computedInputValue.value) {
        if (!computedPopupVisible.value) {
          handlePopupVisibleChange(true);
        }
        updateInputValue(inputValue);
        if (props.allowSearch) {
          handleSearch(inputValue);
        }
      }
    };
    const handleRemove = (key) => {
      const optionInfo = optionInfoMap.get(key);
      const newKeys = computedValueKeys.value.filter((_key) => _key !== key);
      updateValue(newKeys);
      emit2("remove", optionInfo == null ? void 0 : optionInfo.value);
    };
    const handleClear = (e2) => {
      e2 == null ? void 0 : e2.stopPropagation();
      const newKeys = computedValueKeys.value.filter((key) => {
        var _a2;
        return (_a2 = optionInfoMap.get(key)) == null ? void 0 : _a2.disabled;
      });
      updateValue(newKeys);
      updateInputValue("");
      emit2("clear", e2);
    };
    const handleDropdownScroll = (e2) => {
      emit2("dropdownScroll", e2);
    };
    const handleDropdownReachBottom = (e2) => {
      emit2("dropdownReachBottom", e2);
    };
    const {
      validOptions,
      optionInfoMap,
      validOptionInfos,
      enabledOptionKeys,
      handleKeyDown
    } = useSelect({
      multiple,
      options,
      extraOptions,
      inputValue: computedInputValue,
      filterOption,
      showExtraOptions,
      component,
      valueKey,
      fieldNames,
      loading,
      popupVisible: computedPopupVisible,
      valueKeys: computedValueKeys,
      dropdownRef,
      optionRefs,
      virtualListRef,
      defaultActiveFirstOption,
      onSelect: handleSelect,
      onPopupVisibleChange: handlePopupVisibleChange
    });
    const selectViewValue = computed(() => {
      var _a2;
      const result = [];
      for (const item of computedValueObjects.value) {
        const optionInfo = optionInfoMap.get(item.key);
        if (optionInfo) {
          result.push(__spreadProps$6(__spreadValues$b({}, optionInfo), {
            value: item.key,
            label: (_a2 = optionInfo == null ? void 0 : optionInfo.label) != null ? _a2 : String(isObject$5(item.value) ? item.value[valueKey == null ? void 0 : valueKey.value] : item.value),
            closable: !(optionInfo == null ? void 0 : optionInfo.disabled),
            tagProps: optionInfo == null ? void 0 : optionInfo.tagProps
          }));
        }
      }
      return result;
    });
    const getOptionContentFunc = (optionInfo) => {
      if (isFunction$3(slots.option)) {
        const optionSlot = slots.option;
        return () => optionSlot({
          data: optionInfo.raw
        });
      }
      if (isFunction$3(optionInfo.render)) {
        return optionInfo.render;
      }
      return () => optionInfo.label;
    };
    const renderOption = (optionInfo) => {
      if (isGroupOptionInfo(optionInfo)) {
        let _slot;
        return createVNode(Optgroup, {
          "key": optionInfo.key,
          "label": optionInfo.label
        }, _isSlot$3(_slot = optionInfo.options.map((child) => renderOption(child))) ? _slot : {
          default: () => [_slot]
        });
      }
      if (!isValidOption(optionInfo, {
        inputValue: computedInputValue.value,
        filterOption: filterOption == null ? void 0 : filterOption.value
      })) {
        return null;
      }
      return createVNode(Option, {
        "ref": (ref2) => {
          if (ref2 == null ? void 0 : ref2.$el) {
            optionRefs.value[optionInfo.key] = ref2.$el;
          }
        },
        "key": optionInfo.key,
        "value": optionInfo.value,
        "label": optionInfo.label,
        "disabled": optionInfo.disabled,
        "internal": true
      }, {
        default: getOptionContentFunc(optionInfo)
      });
    };
    const renderDropDown = () => {
      return createVNode(SelectDropdown, {
        "ref": dropdownRef,
        "loading": props.loading,
        "empty": validOptionInfos.value.length === 0,
        "virtualList": Boolean(props.virtualListProps),
        "scrollbar": props.scrollbar,
        "onScroll": handleDropdownScroll,
        "onReachBottom": handleDropdownReachBottom
      }, {
        "default": () => {
          var _a2, _b2;
          return [...(_b2 = (_a2 = slots.default) == null ? void 0 : _a2.call(slots)) != null ? _b2 : [], ...validOptions.value.map(renderOption)];
        },
        "virtual-list": () => createVNode(VirtualList, mergeProps(props.virtualListProps, {
          "ref": virtualListRef,
          "data": validOptions.value
        }), {
          item: ({
            item
          }) => renderOption(item)
        }),
        "empty": slots.empty,
        "header": slots.header,
        "footer": slots.footer
      });
    };
    const renderLabel = ({
      data
    }) => {
      var _a2, _b2, _c2, _d;
      if ((slots.label || isFunction$3(props.formatLabel)) && data) {
        const optionInfo = optionInfoMap.get(data.value);
        if (optionInfo == null ? void 0 : optionInfo.raw) {
          return (_c2 = (_a2 = slots.label) == null ? void 0 : _a2.call(slots, {
            data: optionInfo.raw
          })) != null ? _c2 : (_b2 = props.formatLabel) == null ? void 0 : _b2.call(props, optionInfo.raw);
        }
      }
      return (_d = data == null ? void 0 : data.label) != null ? _d : "";
    };
    return () => createVNode(Trigger, mergeProps({
      "trigger": "click",
      "position": "bl",
      "popupOffset": 4,
      "animationName": "slide-dynamic-origin",
      "hideEmpty": true,
      "preventFocus": true,
      "autoFitPopupWidth": true,
      "autoFitTransformOrigin": true,
      "disabled": mergedDisabled.value,
      "popupVisible": computedPopupVisible.value,
      "unmountOnClose": props.unmountOnClose,
      "clickToClose": !(props.allowSearch || props.allowCreate),
      "popupContainer": props.popupContainer,
      "onPopupVisibleChange": handlePopupVisibleChange
    }, props.triggerProps), {
      default: () => {
        var _a2, _b2;
        return [(_b2 = (_a2 = slots.trigger) == null ? void 0 : _a2.call(slots)) != null ? _b2 : createVNode(SelectView, mergeProps({
          "class": prefixCls,
          "modelValue": selectViewValue.value,
          "inputValue": computedInputValue.value,
          "multiple": props.multiple,
          "disabled": mergedDisabled.value,
          "error": mergedError.value,
          "loading": props.loading,
          "allowClear": props.allowClear,
          "allowCreate": props.allowCreate,
          "allowSearch": Boolean(props.allowSearch),
          "opened": computedPopupVisible.value,
          "maxTagCount": props.maxTagCount,
          "placeholder": props.placeholder,
          "bordered": props.bordered,
          "size": mergedSize.value,
          "onInputValueChange": handleInputValueChange,
          "onRemove": handleRemove,
          "onClear": handleClear,
          "onKeydown": handleKeyDown
        }, attrs), {
          "label": renderLabel,
          "prefix": slots.prefix,
          "arrow-icon": slots["arrow-icon"],
          "loading-icon": slots["loading-icon"],
          "search-icon": slots["search-icon"]
        })];
      },
      content: renderDropDown
    });
  }
});
const Select = Object.assign(_Select, {
  Option,
  OptGroup: Optgroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Select.name, _Select);
    app.component(componentPrefix + Option.name, Option);
    app.component(componentPrefix + Optgroup.name, Optgroup);
  }
});
const _sfc_main$W = defineComponent({
  name: "IconLeft",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-left`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$l = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$j = /* @__PURE__ */ createBaseVNode("path", {
  d: "M32 8.4 16.444 23.956 32 39.513"
}, null, -1);
const _hoisted_3$h = [_hoisted_2$j];
function _sfc_render$O(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$h, 14, _hoisted_1$l);
}
var _IconLeft = /* @__PURE__ */ _export_sfc$1(_sfc_main$W, [["render", _sfc_render$O]]);
const IconLeft = Object.assign(_IconLeft, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconLeft.name, _IconLeft);
  }
});
const cardInjectionKey = Symbol("ArcoCard");
var _Card = defineComponent({
  name: "Card",
  components: {
    Spin
  },
  props: {
    bordered: {
      type: Boolean,
      default: true
    },
    loading: {
      type: Boolean,
      default: false
    },
    hoverable: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    headerStyle: {
      type: Object,
      default: () => ({})
    },
    bodyStyle: {
      type: Object,
      default: () => ({})
    },
    title: {
      type: String
    },
    extra: {
      type: String
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("card");
    const {
      size: size2
    } = toRefs(props);
    const {
      mergedSize: _mergedSize
    } = useSize$1(size2);
    const mergedSize = computed(() => {
      if (_mergedSize.value === "small" || _mergedSize.value === "mini") {
        return "small";
      }
      return "medium";
    });
    const renderActions = (vns) => {
      const actions2 = getAllElements(vns);
      return createVNode("div", {
        "class": `${prefixCls}-actions`
      }, [createVNode("div", {
        "class": `${prefixCls}-actions-right`
      }, [actions2.map((action, index2) => createVNode("span", {
        "key": `action-${index2}`,
        "class": `${prefixCls}-actions-item`
      }, [action]))])]);
    };
    const cardContext = reactive({
      hasMeta: false,
      hasGrid: false,
      slots,
      renderActions
    });
    provide(cardInjectionKey, cardContext);
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-loading`]: props.loading,
      [`${prefixCls}-bordered`]: props.bordered,
      [`${prefixCls}-hoverable`]: props.hoverable,
      [`${prefixCls}-contain-grid`]: cardContext.hasGrid
    }]);
    return () => {
      var _a2, _b2, _c2, _d, _e, _f, _g;
      const hasTitle = Boolean((_a2 = slots.title) != null ? _a2 : props.title);
      const hasExtra = Boolean((_b2 = slots.extra) != null ? _b2 : props.extra);
      return createVNode("div", {
        "class": cls.value
      }, [(hasTitle || hasExtra) && createVNode("div", {
        "class": [`${prefixCls}-header`, {
          [`${prefixCls}-header-no-title`]: !hasTitle
        }],
        "style": props.headerStyle
      }, [hasTitle && createVNode("div", {
        "class": `${prefixCls}-header-title`
      }, [(_d = (_c2 = slots.title) == null ? void 0 : _c2.call(slots)) != null ? _d : props.title]), hasExtra && createVNode("div", {
        "class": `${prefixCls}-header-extra`
      }, [(_f = (_e = slots.extra) == null ? void 0 : _e.call(slots)) != null ? _f : props.extra])]), slots.cover && createVNode("div", {
        "class": `${prefixCls}-cover`
      }, [slots.cover()]), createVNode("div", {
        "class": `${prefixCls}-body`,
        "style": props.bodyStyle
      }, [props.loading ? createVNode(Spin, null, null) : (_g = slots.default) == null ? void 0 : _g.call(slots), slots.actions && !cardContext.hasMeta && renderActions(slots.actions())])]);
    };
  }
});
var CardMeta = defineComponent({
  name: "CardMeta",
  props: {
    title: {
      type: String
    },
    description: {
      type: String
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("card-meta");
    const context = inject(cardInjectionKey);
    onMounted(() => {
      if (context) {
        context.hasMeta = true;
      }
    });
    return () => {
      var _a2, _b2, _c2, _d, _e, _f;
      const hasTitle = Boolean((_a2 = slots.title) != null ? _a2 : props.title);
      const hasDesc = Boolean((_b2 = slots.description) != null ? _b2 : props.description);
      return createVNode("div", {
        "class": prefixCls
      }, [(hasTitle || hasDesc) && createVNode("div", {
        "class": `${prefixCls}-content`
      }, [hasTitle && createVNode("div", {
        "class": `${prefixCls}-title`
      }, [(_d = (_c2 = slots.title) == null ? void 0 : _c2.call(slots)) != null ? _d : props.title]), hasDesc && createVNode("div", {
        "class": `${prefixCls}-description`
      }, [(_f = (_e = slots.description) == null ? void 0 : _e.call(slots)) != null ? _f : props.description])]), (slots.avatar || (context == null ? void 0 : context.slots.actions)) && createVNode("div", {
        "class": [`${prefixCls}-footer `, {
          [`${prefixCls}-footer-only-actions`]: !slots.avatar
        }]
      }, [slots.avatar && createVNode("div", {
        "class": `${prefixCls}-avatar`
      }, [slots.avatar()]), context && context.slots.actions && context.renderActions(context.slots.actions())])]);
    };
  }
});
const _sfc_main$V = defineComponent({
  name: "CardGrid",
  props: {
    hoverable: {
      type: Boolean,
      default: false
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("card-grid");
    const context = inject(cardInjectionKey);
    onMounted(() => {
      if (context) {
        context.hasGrid = true;
      }
    });
    const cls = computed(() => {
      return [prefixCls, {
        [`${prefixCls}-hoverable`]: props.hoverable
      }];
    });
    return {
      cls
    };
  }
});
function _sfc_render$N(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [renderSlot(_ctx.$slots, "default")], 2);
}
var CardGrid = /* @__PURE__ */ _export_sfc$1(_sfc_main$V, [["render", _sfc_render$N]]);
const Card = Object.assign(_Card, {
  Meta: CardMeta,
  Grid: CardGrid,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Card.name, _Card);
    app.component(componentPrefix + CardMeta.name, CardMeta);
    app.component(componentPrefix + CardGrid.name, CardGrid);
  }
});
const _sfc_main$U = defineComponent({
  name: "IconUp",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-up`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$k = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$i = /* @__PURE__ */ createBaseVNode("path", {
  d: "M39.6 30.557 24.043 15 8.487 30.557"
}, null, -1);
const _hoisted_3$g = [_hoisted_2$i];
function _sfc_render$M(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$g, 14, _hoisted_1$k);
}
var _IconUp = /* @__PURE__ */ _export_sfc$1(_sfc_main$U, [["render", _sfc_render$M]]);
const IconUp = Object.assign(_IconUp, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconUp.name, _IconUp);
  }
});
function hasPropOrSlot(props, slots, propName) {
  return computed(() => Boolean(props[propName] || slots[propName]));
}
const _sfc_main$T = defineComponent({
  name: "ConfigProvider",
  props: {
    prefixCls: {
      type: String,
      default: "arco"
    },
    locale: {
      type: Object
    },
    size: {
      type: String
    },
    global: {
      type: Boolean,
      default: false
    },
    updateAtScroll: {
      type: Boolean,
      default: false
    },
    scrollToClose: {
      type: Boolean,
      default: false
    }
  },
  setup(props, {
    slots
  }) {
    const {
      prefixCls,
      locale: locale2,
      size: size2,
      updateAtScroll,
      scrollToClose
    } = toRefs(props);
    const config = reactive({
      slots,
      prefixCls,
      locale: locale2,
      size: size2,
      updateAtScroll,
      scrollToClose
    });
    if (props.global) {
      const instance = getCurrentInstance();
      if (instance) {
        instance.appContext.app.provide(configProviderInjectionKey, config);
      }
    } else {
      provide(configProviderInjectionKey, config);
    }
  }
});
function _sfc_render$L(_ctx, _cache, $props, $setup, $data, $options) {
  return renderSlot(_ctx.$slots, "default");
}
var _ConfigProvider = /* @__PURE__ */ _export_sfc$1(_sfc_main$T, [["render", _sfc_render$L]]);
const ConfigProvider = Object.assign(_ConfigProvider, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _ConfigProvider.name, _ConfigProvider);
  }
});
function useState(defaultValue) {
  const value = ref(defaultValue);
  const setValue = (newValue) => {
    value.value = newValue;
  };
  return [value, setValue];
}
var RenderFunction = defineComponent({
  name: "RenderFunction",
  props: {
    renderFunc: {
      type: Function,
      required: true
    }
  },
  render() {
    return this.renderFunc(this.$attrs);
  }
});
function useMergeState(defaultValue, props) {
  const {
    value
  } = toRefs(props);
  const [localValue, setLocalValue] = useState(!isUndefined(value.value) ? value.value : defaultValue);
  watch(value, (newVal) => {
    isUndefined(newVal) && setLocalValue(void 0);
  });
  const mergeValue = computed(() => !isUndefined(value.value) ? value.value : localValue.value);
  return [mergeValue, setLocalValue, localValue];
}
const _sfc_main$S = defineComponent({
  name: "IconLink",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-link`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$j = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$h = /* @__PURE__ */ createBaseVNode("path", {
  d: "m14.1 25.414-4.95 4.95a6 6 0 0 0 8.486 8.485l8.485-8.485a6 6 0 0 0 0-8.485m7.779.707 4.95-4.95a6 6 0 1 0-8.486-8.485l-8.485 8.485a6 6 0 0 0 0 8.485"
}, null, -1);
const _hoisted_3$f = [_hoisted_2$h];
function _sfc_render$K(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$f, 14, _hoisted_1$j);
}
var _IconLink = /* @__PURE__ */ _export_sfc$1(_sfc_main$S, [["render", _sfc_render$K]]);
const IconLink = Object.assign(_IconLink, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconLink.name, _IconLink);
  }
});
const _sfc_main$R = defineComponent({
  name: "Link",
  components: {
    IconLink,
    IconLoading
  },
  props: {
    href: String,
    status: {
      type: String,
      default: "normal"
    },
    hoverable: {
      type: Boolean,
      default: true
    },
    icon: Boolean,
    loading: Boolean,
    disabled: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    slots,
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("link");
    const showIcon = hasPropOrSlot(props, slots, "icon");
    const handleClick = (ev) => {
      if (props.disabled || props.loading) {
        ev.preventDefault();
        return;
      }
      emit2("click", ev);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-status-${props.status}`, {
      [`${prefixCls}-disabled`]: props.disabled,
      [`${prefixCls}-loading`]: props.loading,
      [`${prefixCls}-hoverless`]: !props.hoverable,
      [`${prefixCls}-with-icon`]: props.loading || showIcon.value
    }]);
    return {
      cls,
      prefixCls,
      showIcon,
      handleClick
    };
  }
});
const _hoisted_1$i = ["href"];
function _sfc_render$J(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_loading = resolveComponent("icon-loading");
  const _component_icon_link = resolveComponent("icon-link");
  return openBlock(), createElementBlock("a", {
    href: _ctx.disabled ? void 0 : _ctx.href,
    class: normalizeClass(_ctx.cls),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [_ctx.loading || _ctx.showIcon ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-icon`)
  }, [_ctx.loading ? (openBlock(), createBlock(_component_icon_loading, {
    key: 0
  })) : renderSlot(_ctx.$slots, "icon", {
    key: 1
  }, () => [createVNode(_component_icon_link)])], 2)) : createCommentVNode("v-if", true), renderSlot(_ctx.$slots, "default")], 10, _hoisted_1$i);
}
var _Link = /* @__PURE__ */ _export_sfc$1(_sfc_main$R, [["render", _sfc_render$J]]);
const Link = Object.assign(_Link, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Link.name, _Link);
  }
});
const descriptionsInjectionKey = Symbol("ArcoDescriptions");
var __defProp$a = Object.defineProperty;
var __defProps$5 = Object.defineProperties;
var __getOwnPropDescs$5 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$a = Object.getOwnPropertySymbols;
var __hasOwnProp$a = Object.prototype.hasOwnProperty;
var __propIsEnum$a = Object.prototype.propertyIsEnumerable;
var __defNormalProp$a = (obj, key, value) => key in obj ? __defProp$a(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$a = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$a.call(b2, prop))
      __defNormalProp$a(a, prop, b2[prop]);
  if (__getOwnPropSymbols$a)
    for (var prop of __getOwnPropSymbols$a(b2)) {
      if (__propIsEnum$a.call(b2, prop))
        __defNormalProp$a(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$5 = (a, b2) => __defProps$5(a, __getOwnPropDescs$5(b2));
const responsiveArray = ["xxl", "xl", "lg", "md", "sm", "xs"];
const responsiveMap = {
  xs: "(max-width: 575px)",
  sm: "(min-width: 576px)",
  md: "(min-width: 768px)",
  lg: "(min-width: 992px)",
  xl: "(min-width: 1200px)",
  xxl: "(min-width: 1600px)"
};
let subscribers = [];
let subUid = -1;
let screens = {};
const responsiveObserve = {
  matchHandlers: {},
  dispatch(pointMap, breakpointChecked) {
    screens = pointMap;
    if (subscribers.length < 1) {
      return false;
    }
    subscribers.forEach((item) => {
      item.func(screens, breakpointChecked);
    });
    return true;
  },
  subscribe(func) {
    if (subscribers.length === 0) {
      this.register();
    }
    const token = (++subUid).toString();
    subscribers.push({
      token,
      func
    });
    func(screens, null);
    return token;
  },
  unsubscribe(token) {
    subscribers = subscribers.filter((item) => item.token !== token);
    if (subscribers.length === 0) {
      this.unregister();
    }
  },
  unregister() {
    Object.keys(responsiveMap).forEach((screen) => {
      const matchMediaQuery = responsiveMap[screen];
      if (!matchMediaQuery)
        return;
      const handler = this.matchHandlers[matchMediaQuery];
      if (handler && handler.mql && handler.listener) {
        if (handler.mql.removeEventListener) {
          handler.mql.removeEventListener("change", handler.listener);
        } else {
          handler.mql.removeListener(handler.listener);
        }
      }
    });
  },
  register() {
    Object.keys(responsiveMap).forEach((screen) => {
      const matchMediaQuery = responsiveMap[screen];
      if (!matchMediaQuery)
        return;
      const listener = ({
        matches
      }) => {
        this.dispatch(__spreadProps$5(__spreadValues$a({}, screens), {
          [screen]: matches
        }), screen);
      };
      const mql = window.matchMedia(matchMediaQuery);
      if (mql.addEventListener) {
        mql.addEventListener("change", listener);
      } else {
        mql.addListener(listener);
      }
      this.matchHandlers[matchMediaQuery] = {
        mql,
        listener
      };
      listener(mql);
    });
  }
};
function isResponsiveValue(val) {
  return isObject$5(val);
}
function useResponsiveState(val, defaultVal, fallbackToXs = false) {
  const screens2 = ref({
    xs: true,
    sm: true,
    md: true,
    lg: true,
    xl: true,
    xxl: true
  });
  const result = computed(() => {
    let res = defaultVal;
    if (isResponsiveValue(val.value)) {
      for (let i2 = 0; i2 < responsiveArray.length; i2++) {
        const breakpoint = responsiveArray[i2];
        if ((screens2.value[breakpoint] || breakpoint === "xs" && fallbackToXs) && val.value[breakpoint] !== void 0) {
          res = val.value[breakpoint];
          break;
        }
      }
    } else {
      res = val.value;
    }
    return res;
  });
  let subscribeToken = "";
  onMounted(() => {
    subscribeToken = responsiveObserve.subscribe((screensVal) => {
      if (isResponsiveValue(val.value)) {
        screens2.value = screensVal;
      }
    });
  });
  onUnmounted(() => {
    if (subscribeToken) {
      responsiveObserve.unsubscribe(subscribeToken);
    }
  });
  return result;
}
var __defProp$9 = Object.defineProperty;
var __getOwnPropSymbols$9 = Object.getOwnPropertySymbols;
var __hasOwnProp$9 = Object.prototype.hasOwnProperty;
var __propIsEnum$9 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$9 = (obj, key, value) => key in obj ? __defProp$9(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$9 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$9.call(b2, prop))
      __defNormalProp$9(a, prop, b2[prop]);
  if (__getOwnPropSymbols$9)
    for (var prop of __getOwnPropSymbols$9(b2)) {
      if (__propIsEnum$9.call(b2, prop))
        __defNormalProp$9(a, prop, b2[prop]);
    }
  return a;
};
const getTotalSpan = (renderData) => {
  return renderData ? renderData.reduce((total2, data) => total2 + data.span, 0) : 0;
};
var _Descriptions = defineComponent({
  name: "Descriptions",
  props: {
    data: {
      type: Array,
      default: () => []
    },
    column: {
      type: [Number, Object],
      default: 3
    },
    title: String,
    layout: {
      type: String,
      default: "horizontal"
    },
    align: {
      type: [String, Object],
      default: "left"
    },
    size: {
      type: String
    },
    bordered: {
      type: Boolean,
      default: false
    },
    labelStyle: {
      type: Object
    },
    valueStyle: {
      type: Object
    },
    tableLayout: {
      type: String,
      default: "auto"
    }
  },
  setup(props, {
    slots
  }) {
    const {
      column,
      size: size2
    } = toRefs(props);
    const prefixCls = getPrefixCls("descriptions");
    const {
      mergedSize
    } = useSize$1(size2);
    const computedColumn = useResponsiveState(column, 3, true);
    const labelAlign = computed(() => {
      var _a2;
      return (_a2 = isObject$5(props.align) ? props.align.label : props.align) != null ? _a2 : "left";
    });
    const valueAlign = computed(() => {
      var _a2;
      return (_a2 = isObject$5(props.align) ? props.align.value : props.align) != null ? _a2 : "left";
    });
    const labelStyle = computed(() => __spreadValues$9({
      textAlign: labelAlign.value
    }, props.labelStyle));
    const valueStyle = computed(() => __spreadValues$9({
      textAlign: valueAlign.value
    }, props.valueStyle));
    const descItemMap = reactive(/* @__PURE__ */ new Map());
    const sortedSpans = computed(() => Array.from(descItemMap.values()).sort((a, b2) => a.index - b2.index).map((data) => data.span));
    const addItem = (id, data) => {
      descItemMap.set(id, data);
    };
    const removeItem = (id) => {
      descItemMap.delete(id);
    };
    provide(descriptionsInjectionKey, reactive({
      addItem,
      removeItem
    }));
    const getGroupedData = (data) => {
      const groupedData2 = [];
      data.forEach((item, index2) => {
        var _a2;
        const itemSpan = Math.min((_a2 = isVNode$1(item) ? sortedSpans.value[index2] : item.span) != null ? _a2 : 1, computedColumn.value);
        const lastData = groupedData2[groupedData2.length - 1];
        const lastDataTotalSpan = getTotalSpan(lastData);
        if (lastDataTotalSpan === 0 || lastDataTotalSpan >= computedColumn.value) {
          groupedData2.push([{
            data: item,
            span: itemSpan
          }]);
        } else {
          lastData.push({
            data: item,
            span: itemSpan + lastDataTotalSpan > computedColumn.value ? computedColumn.value - lastDataTotalSpan : itemSpan
          });
        }
      });
      if (groupedData2.length) {
        const lastData = groupedData2[groupedData2.length - 1];
        const lastDataTotalSpan = getTotalSpan(lastData);
        if (lastDataTotalSpan < computedColumn.value) {
          lastData[lastData.length - 1].span += computedColumn.value - lastDataTotalSpan;
        }
      }
      return groupedData2;
    };
    const groupedData = computed(() => {
      var _a2;
      return getGroupedData((_a2 = props.data) != null ? _a2 : []);
    });
    const renderLabel = (item, index2) => {
      var _a2, _b2, _c2, _d, _e;
      if (isVNode$1(item)) {
        return isSlotsChildren(item, item.children) && ((_b2 = (_a2 = item.children).label) == null ? void 0 : _b2.call(_a2)) || ((_c2 = item.props) == null ? void 0 : _c2.label);
      }
      return (_e = (_d = slots.label) == null ? void 0 : _d.call(slots, {
        label: item.label,
        index: index2,
        data: item
      })) != null ? _e : isFunction$3(item.label) ? item.label() : item.label;
    };
    const renderValue = (item, index2) => {
      var _a2, _b2;
      if (isVNode$1(item)) {
        return item;
      }
      return (_b2 = (_a2 = slots.value) == null ? void 0 : _a2.call(slots, {
        value: item.value,
        index: index2,
        data: item
      })) != null ? _b2 : isFunction$3(item.value) ? item.value() : item.value;
    };
    const renderVerticalItems = (data) => createVNode(Fragment, null, [createVNode("tr", {
      "class": `${prefixCls}-row`
    }, [data.map((item, index2) => createVNode("td", {
      "key": `label-${index2}`,
      "class": [`${prefixCls}-item-label`, `${prefixCls}-item-label-block`],
      "style": labelStyle.value,
      "colspan": item.span
    }, [renderLabel(item.data, index2)]))]), createVNode("tr", {
      "class": `${prefixCls}-row`
    }, [data.map((item, index2) => createVNode("td", {
      "key": `value-${index2}`,
      "class": [`${prefixCls}-item-value`, `${prefixCls}-item-value-block`],
      "style": valueStyle.value,
      "colspan": item.span
    }, [renderValue(item.data, index2)]))])]);
    const renderHorizontalItems = (data, index2) => createVNode("tr", {
      "class": `${prefixCls}-row`,
      "key": `tr-${index2}`
    }, [data.map((item) => createVNode(Fragment, null, [createVNode("td", {
      "class": [`${prefixCls}-item-label`, `${prefixCls}-item-label-block`],
      "style": labelStyle.value
    }, [renderLabel(item.data, index2)]), createVNode("td", {
      "class": [`${prefixCls}-item-value`, `${prefixCls}-item-value-block`],
      "style": valueStyle.value,
      "colspan": item.span * 2 - 1
    }, [renderValue(item.data, index2)])]))]);
    const renderInlineItems = (data, index2) => createVNode("tr", {
      "class": `${prefixCls}-row`,
      "key": `inline-${index2}`
    }, [data.map((item, index22) => createVNode("td", {
      "key": `item-${index22}`,
      "class": `${prefixCls}-item`,
      "colspan": item.span
    }, [createVNode("div", {
      "class": [`${prefixCls}-item-label`, `${prefixCls}-item-label-inline`],
      "style": labelStyle.value
    }, [renderLabel(item.data, index22)]), createVNode("div", {
      "class": [`${prefixCls}-item-value`, `${prefixCls}-item-value-inline`],
      "style": valueStyle.value
    }, [renderValue(item.data, index22)])]))]);
    const renderItems = (data, index2) => {
      if (["inline-horizontal", "inline-vertical"].includes(props.layout)) {
        return renderInlineItems(data, index2);
      }
      if (props.layout === "vertical") {
        return renderVerticalItems(data);
      }
      return renderHorizontalItems(data, index2);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-layout-${props.layout}`, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-border`]: props.bordered
    }, {
      [`${prefixCls}-table-layout-fixed`]: props.tableLayout === "fixed"
    }]);
    const renderTitle = () => {
      var _a2, _b2;
      const title = (_b2 = (_a2 = slots.title) == null ? void 0 : _a2.call(slots)) != null ? _b2 : props.title;
      if (title) {
        return createVNode("div", {
          "class": `${prefixCls}-title`
        }, [title]);
      }
      return null;
    };
    return () => {
      const _groupedData = slots.default ? getGroupedData(getAllElements(slots.default())) : groupedData.value;
      return createVNode("div", {
        "class": cls.value
      }, [renderTitle(), createVNode("div", {
        "class": `${prefixCls}-body`
      }, [createVNode("table", {
        "class": `${prefixCls}-table`
      }, [createVNode("tbody", null, [_groupedData.map((data, index2) => renderItems(data, index2))])])])]);
    };
  }
});
const _sfc_main$Q = defineComponent({
  name: "DescriptionsItem",
  props: {
    span: {
      type: Number,
      default: 1
    },
    label: String
  },
  setup(props) {
    var _a2;
    const {
      span
    } = toRefs(props);
    const prefixCls = getPrefixCls("descriptions");
    const descCtx = inject(descriptionsInjectionKey, {});
    const instance = getCurrentInstance();
    const itemRef = ref();
    const {
      computedIndex
    } = useIndex({
      itemRef,
      selector: `.${prefixCls}-item-value`,
      parentClassName: `${prefixCls}-table`
    });
    const itemData = reactive({
      index: computedIndex,
      span
    });
    if (instance == null ? void 0 : instance.uid) {
      (_a2 = descCtx.addItem) == null ? void 0 : _a2.call(descCtx, instance.uid, itemData);
    }
    const getItemRef = () => {
      var _a22;
      const itemEle = ((_a22 = instance == null ? void 0 : instance.proxy) == null ? void 0 : _a22.$el).parentElement;
      if (itemEle && itemEle !== itemRef.value) {
        itemRef.value = itemEle;
      }
    };
    onMounted(() => getItemRef());
    onUpdated(() => getItemRef());
    onBeforeUnmount(() => {
      var _a22;
      if (instance == null ? void 0 : instance.uid) {
        (_a22 = descCtx.removeItem) == null ? void 0 : _a22.call(descCtx, instance.uid);
      }
    });
    return {
      prefixCls
    };
  }
});
function _sfc_render$I(_ctx, _cache, $props, $setup, $data, $options) {
  return renderSlot(_ctx.$slots, "default");
}
var DescriptionsItem = /* @__PURE__ */ _export_sfc$1(_sfc_main$Q, [["render", _sfc_render$I]]);
const Descriptions = Object.assign(_Descriptions, {
  DescriptionsItem,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Descriptions.name, _Descriptions);
    app.component(componentPrefix + DescriptionsItem.name, DescriptionsItem);
  }
});
var opt = Object.prototype.toString;
function isArray$3(obj) {
  return opt.call(obj) === "[object Array]";
}
function isObject$4(obj) {
  return opt.call(obj) === "[object Object]";
}
function isString$2(obj) {
  return opt.call(obj) === "[object String]";
}
function isFunction$2(obj) {
  return opt.call(obj) === "[object Function]";
}
function isEmptyValue(obj) {
  return obj === void 0 || obj === null || obj === "";
}
function isEmptyArray(obj) {
  return isArray$3(obj) && !obj.length;
}
var mergeTemplate = function(defaultValidateMessages, validateMessages2) {
  var result = {};
  Object.keys(defaultValidateMessages).forEach(function(key) {
    var defaultValue = defaultValidateMessages[key];
    var propsValue = validateMessages2 && validateMessages2[key];
    result[key] = isObject$4(defaultValue) ? Object.assign(Object.assign({}, defaultValue), propsValue) : propsValue || defaultValue;
  });
  return result;
};
var getTemplate = function(validateMessages2, keyPath) {
  var keys2 = keyPath.split(".");
  var result = validateMessages2;
  for (var i2 = 0; i2 < keys2.length; i2++) {
    result = result && result[keys2[i2]];
    if (result === void 0) {
      return result;
    }
  }
  return result;
};
var defaultTypeTemplate = "#{field} is not a #{type} type";
var validateMessages = {
  required: "#{field} is required",
  type: {
    ip: defaultTypeTemplate,
    email: defaultTypeTemplate,
    url: defaultTypeTemplate,
    string: defaultTypeTemplate,
    number: defaultTypeTemplate,
    array: defaultTypeTemplate,
    object: defaultTypeTemplate,
    boolean: defaultTypeTemplate
  },
  number: {
    min: "`#{value}` is not greater than `#{min}`",
    max: "`#{value}` is not less than `#{max}`",
    equal: "`#{value}` is not equal to `#{equal}`",
    range: "`#{value}` is not in range `#{min} ~ #{max}`",
    positive: "`#{value}` is not a positive number",
    negative: "`#{value}` is not a negative number"
  },
  string: {
    maxLength: "#{field} cannot be longer than #{maxLength} characters",
    minLength: "#{field} must be at least #{minLength} characters",
    length: "#{field} must be exactly #{length} characters",
    match: "`#{value}` does not match pattern #{pattern}",
    uppercase: "`#{value}` must be all uppercase",
    lowercase: "`#{value}` must be all lowercased"
  },
  array: {
    length: "#{field} must be exactly #{length} in length",
    minLength: "#{field} cannot be less than #{minLength} in length",
    maxLength: "#{field} cannot be greater than #{maxLength} in length",
    includes: "#{field} is not includes #{includes}",
    deepEqual: "#{field} is not deep equal with #{deepEqual}",
    empty: "#{field} is not an empty array"
  },
  object: {
    deepEqual: "#{field} is not deep equal to expected value",
    hasKeys: "#{field} does not contain required fields",
    empty: "`#{field} is not an empty object"
  },
  boolean: {
    true: "Expect true but got `#{value}`",
    false: "Expect false but got `#{value}`"
  }
};
var Base = function Base2(obj, options) {
  var this$1$1 = this;
  this.getValidateMsg = function(keyPath, info) {
    if (info === void 0)
      info = {};
    var data = Object.assign(Object.assign({}, info), {
      value: this$1$1.obj,
      field: this$1$1.field,
      type: this$1$1.type
    });
    var template = getTemplate(this$1$1.validateMessages, keyPath);
    if (isFunction$2(template)) {
      return template(data);
    }
    if (isString$2(template)) {
      return template.replace(/\#\{.+?\}/g, function(variable) {
        var key = variable.slice(2, -1);
        if (key in data) {
          if (isObject$4(data[key]) || isArray$3(data[key])) {
            try {
              return JSON.stringify(data[key]);
            } catch (_2) {
              return data[key];
            }
          }
          return String(data[key]);
        }
        return variable;
      });
    }
    return template;
  };
  if (isObject$4(options) && isString$2(obj) && options.trim) {
    this.obj = obj.trim();
  } else if (isObject$4(options) && options.ignoreEmptyString && obj === "") {
    this.obj = void 0;
  } else {
    this.obj = obj;
  }
  this.message = options.message;
  this.type = options.type;
  this.error = null;
  this.field = options.field || options.type;
  this.validateMessages = mergeTemplate(validateMessages, options.validateMessages);
};
var prototypeAccessors = {
  not: {
    configurable: true
  },
  isRequired: {
    configurable: true
  },
  end: {
    configurable: true
  }
};
prototypeAccessors.not.get = function() {
  this._not = !this._not;
  return this;
};
prototypeAccessors.isRequired.get = function() {
  if (isEmptyValue(this.obj) || isEmptyArray(this.obj)) {
    var message2 = this.getValidateMsg("required");
    this.error = {
      value: this.obj,
      type: this.type,
      requiredError: true,
      message: this.message || (isObject$4(message2) ? message2 : (this._not ? "[NOT MODE]:" : "") + message2)
    };
  }
  return this;
};
prototypeAccessors.end.get = function() {
  return this.error;
};
Base.prototype.addError = function addError(message2) {
  if (!this.error && message2) {
    this.error = {
      value: this.obj,
      type: this.type,
      message: this.message || (isObject$4(message2) ? message2 : (this._not ? "[NOT MODE]:" : "") + message2)
    };
  }
};
Base.prototype.validate = function validate(expression, errorMessage) {
  var _expression = this._not ? expression : !expression;
  if (_expression) {
    this.addError(errorMessage);
  }
  return this;
};
Base.prototype.collect = function collect(callback) {
  callback && callback(this.error);
};
Object.defineProperties(Base.prototype, prototypeAccessors);
const RowContextInjectionKey = Symbol("RowContextInjectionKey");
const GridContextInjectionKey = Symbol("GridContextInjectionKey");
const GridDataCollectorInjectionKey = Symbol("GridDataCollectorInjectionKey");
const _sfc_main$P = defineComponent({
  name: "Row",
  props: {
    gutter: {
      type: [Number, Object, Array],
      default: 0
    },
    justify: {
      type: String,
      default: "start"
    },
    align: {
      type: String,
      default: "start"
    },
    div: {
      type: Boolean
    },
    wrap: {
      type: Boolean,
      default: true
    }
  },
  setup(props) {
    const {
      gutter,
      align,
      justify,
      div,
      wrap
    } = toRefs(props);
    const prefixCls = getPrefixCls("row");
    const classNames = computed(() => {
      return {
        [`${prefixCls}`]: !div.value,
        [`${prefixCls}-nowrap`]: !wrap.value,
        [`${prefixCls}-align-${align.value}`]: align.value,
        [`${prefixCls}-justify-${justify.value}`]: justify.value
      };
    });
    const propGutterHorizontal = computed(() => Array.isArray(gutter.value) ? gutter.value[0] : gutter.value);
    const propGutterVertical = computed(() => Array.isArray(gutter.value) ? gutter.value[1] : 0);
    const gutterHorizontal = useResponsiveState(propGutterHorizontal, 0);
    const gutterVertical = useResponsiveState(propGutterVertical, 0);
    const styles = computed(() => {
      const result = {};
      if ((gutterHorizontal.value || gutterVertical.value) && !div.value) {
        const marginHorizontal = -gutterHorizontal.value / 2;
        const marginVertical = -gutterVertical.value / 2;
        if (marginHorizontal) {
          result.marginLeft = `${marginHorizontal}px`;
          result.marginRight = `${marginHorizontal}px`;
        }
        if (marginVertical) {
          result.marginTop = `${marginVertical}px`;
          result.marginBottom = `${marginVertical}px`;
        }
      }
      return result;
    });
    const resultGutter = computed(() => [gutterHorizontal.value, gutterVertical.value]);
    provide(RowContextInjectionKey, reactive({
      gutter: resultGutter,
      div
    }));
    return {
      classNames,
      styles
    };
  }
});
function _sfc_render$H(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames),
    style: normalizeStyle$1(_ctx.styles)
  }, [renderSlot(_ctx.$slots, "default")], 6);
}
var Row = /* @__PURE__ */ _export_sfc$1(_sfc_main$P, [["render", _sfc_render$H]]);
function useResponsiveValue(props) {
  const value = computed(() => {
    const {
      val,
      key,
      xs,
      sm,
      md,
      lg,
      xl,
      xxl
    } = props.value;
    if (!xs && !sm && !md && !lg && !xl && !xxl) {
      return val;
    }
    const result = {};
    responsiveArray.forEach((breakpoint) => {
      const config = props.value[breakpoint];
      if (isNumber$2(config)) {
        result[breakpoint] = config;
      } else if (isObject$5(config) && isNumber$2(config[key])) {
        result[breakpoint] = config[key];
      }
    });
    return result;
  });
  return value;
}
var __defProp$8 = Object.defineProperty;
var __getOwnPropSymbols$8 = Object.getOwnPropertySymbols;
var __hasOwnProp$8 = Object.prototype.hasOwnProperty;
var __propIsEnum$8 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$8 = (obj, key, value) => key in obj ? __defProp$8(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$8 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$8.call(b2, prop))
      __defNormalProp$8(a, prop, b2[prop]);
  if (__getOwnPropSymbols$8)
    for (var prop of __getOwnPropSymbols$8(b2)) {
      if (__propIsEnum$8.call(b2, prop))
        __defNormalProp$8(a, prop, b2[prop]);
    }
  return a;
};
function getAllowableFlexValue(flexValue) {
  if (isString$3(flexValue) && (["initial", "auto", "none"].includes(flexValue) || /^\d+$/.test(flexValue)) || isNumber$2(flexValue)) {
    return flexValue;
  }
  if (isString$3(flexValue) && /^\d+(px|em|rem|%)$/.test(flexValue)) {
    return `0 0 ${flexValue}`;
  }
  return void 0;
}
const _sfc_main$O = defineComponent({
  name: "Col",
  props: {
    span: {
      type: Number,
      default: 24
    },
    offset: {
      type: Number
    },
    order: {
      type: Number
    },
    xs: {
      type: [Number, Object]
    },
    sm: {
      type: [Number, Object]
    },
    md: {
      type: [Number, Object]
    },
    lg: {
      type: [Number, Object]
    },
    xl: {
      type: [Number, Object]
    },
    xxl: {
      type: [Number, Object]
    },
    flex: {
      type: [Number, String]
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("col");
    const rowContext = inject(RowContextInjectionKey, {});
    const flexValue = computed(() => getAllowableFlexValue(props.flex));
    const mergeClassName = computed(() => {
      const {
        div
      } = rowContext;
      const {
        span: span2,
        offset,
        order,
        xs,
        sm,
        md,
        lg,
        xl,
        xxl
      } = props;
      const result = {
        [`${prefixCls}`]: !div,
        [`${prefixCls}-order-${order}`]: order,
        [`${prefixCls}-${span2}`]: !div && !xs && !sm && !md && !lg && !xl && !xxl,
        [`${prefixCls}-offset-${offset}`]: offset && offset > 0
      };
      const screenList = {
        xs,
        sm,
        md,
        lg,
        xl,
        xxl
      };
      Object.keys(screenList).forEach((screen) => {
        const screenValue = screenList[screen];
        if (screenValue && isNumber$2(screenValue)) {
          result[`${prefixCls}-${screen}-${screenValue}`] = true;
        } else if (screenValue && isObject$5(screenValue)) {
          result[`${prefixCls}-${screen}-${screenValue.span}`] = screenValue.span;
          result[`${prefixCls}-${screen}-offset-${screenValue.offset}`] = screenValue.offset;
          result[`${prefixCls}-${screen}-order-${screenValue.order}`] = screenValue.order;
        }
      });
      return result;
    });
    const classNames = computed(() => {
      return flexValue.value ? prefixCls : mergeClassName.value;
    });
    const paddingStyles = computed(() => {
      const {
        gutter,
        div
      } = rowContext;
      const result = {};
      if (Array.isArray(gutter) && !div) {
        const paddingHorizontal = gutter[0] && gutter[0] / 2 || 0;
        const paddingVertical = gutter[1] && gutter[1] / 2 || 0;
        if (paddingHorizontal) {
          result.paddingLeft = `${paddingHorizontal}px`;
          result.paddingRight = `${paddingHorizontal}px`;
        }
        if (paddingVertical) {
          result.paddingTop = `${paddingVertical}px`;
          result.paddingBottom = `${paddingVertical}px`;
        }
      }
      return result;
    });
    const flexStyles = computed(() => flexValue.value ? {
      flex: flexValue.value
    } : {});
    const responsiveConfig = computed(() => pick(props, responsiveArray));
    const propSpan = useResponsiveValue(computed(() => __spreadValues$8({
      val: props.span,
      key: "span"
    }, responsiveConfig.value)));
    const span = useResponsiveState(propSpan, 24, true);
    return {
      visible: computed(() => !!span.value),
      classNames,
      styles: computed(() => __spreadValues$8(__spreadValues$8({}, paddingStyles.value), flexStyles.value))
    };
  }
});
function _sfc_render$G(_ctx, _cache, $props, $setup, $data, $options) {
  return _ctx.visible ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass(_ctx.classNames),
    style: normalizeStyle$1(_ctx.styles)
  }, [renderSlot(_ctx.$slots, "default")], 6)) : createCommentVNode("v-if", true);
}
var Col = /* @__PURE__ */ _export_sfc$1(_sfc_main$O, [["render", _sfc_render$G]]);
function resolveItemData(cols, props) {
  var _a2, _b2;
  const originSpan = (_a2 = props.span) != null ? _a2 : 1;
  const originOffset = (_b2 = props.offset) != null ? _b2 : 0;
  const offset = Math.min(originOffset, cols);
  const span = Math.min(offset > 0 ? originSpan + originOffset : originSpan, cols);
  return {
    span,
    offset,
    suffix: "suffix" in props ? props.suffix !== false : false
  };
}
function setItemVisible({
  cols,
  collapsed,
  collapsedRows,
  itemDataList
}) {
  let overflow = false;
  let displayIndexList = [];
  function isOverflow(span) {
    return Math.ceil(span / cols) > collapsedRows;
  }
  if (collapsed) {
    let spanSum = 0;
    for (let i2 = 0; i2 < itemDataList.length; i2++) {
      if (itemDataList[i2].suffix) {
        spanSum += itemDataList[i2].span;
        displayIndexList.push(i2);
      }
    }
    if (!isOverflow(spanSum)) {
      let current = 0;
      while (current < itemDataList.length) {
        const item = itemDataList[current];
        if (!item.suffix) {
          spanSum += item.span;
          if (isOverflow(spanSum)) {
            break;
          }
          displayIndexList.push(current);
        }
        current++;
      }
    }
    overflow = itemDataList.some((item, index2) => !item.suffix && !displayIndexList.includes(index2));
  } else {
    displayIndexList = itemDataList.map((_2, index2) => index2);
  }
  return {
    overflow,
    displayIndexList
  };
}
const _sfc_main$N = defineComponent({
  name: "Grid",
  props: {
    cols: {
      type: [Number, Object],
      default: 24
    },
    rowGap: {
      type: [Number, Object],
      default: 0
    },
    colGap: {
      type: [Number, Object],
      default: 0
    },
    collapsed: {
      type: Boolean,
      default: false
    },
    collapsedRows: {
      type: Number,
      default: 1
    }
  },
  setup(props) {
    const {
      cols: propCols,
      rowGap: propRowGap,
      colGap: propColGap,
      collapsedRows,
      collapsed
    } = toRefs(props);
    const cols = useResponsiveState(propCols, 24);
    const colGap = useResponsiveState(propColGap, 0);
    const rowGap = useResponsiveState(propRowGap, 0);
    const prefixCls = getPrefixCls("grid");
    const classNames = computed(() => [prefixCls]);
    const style2 = computed(() => [{
      "gap": `${rowGap.value}px ${colGap.value}px`,
      "grid-template-columns": `repeat(${cols.value}, minmax(0px, 1fr))`
    }]);
    const itemDataMap = reactive(/* @__PURE__ */ new Map());
    const itemDataList = computed(() => {
      const list = [];
      for (const [index2, itemData] of itemDataMap.entries()) {
        list[index2] = itemData;
      }
      return list;
    });
    const gridContext = reactive({
      overflow: false,
      displayIndexList: [],
      cols: cols.value,
      colGap: colGap.value
    });
    watchEffect(() => {
      gridContext.cols = cols.value;
      gridContext.colGap = colGap.value;
    });
    watchEffect(() => {
      const displayInfo = setItemVisible({
        cols: cols.value,
        collapsed: collapsed.value,
        collapsedRows: collapsedRows.value,
        itemDataList: itemDataList.value
      });
      gridContext.overflow = displayInfo.overflow;
      gridContext.displayIndexList = displayInfo.displayIndexList;
    });
    provide(GridContextInjectionKey, gridContext);
    provide(GridDataCollectorInjectionKey, {
      collectItemData(index2, itemData) {
        itemDataMap.set(index2, itemData);
      },
      removeItemData(index2) {
        itemDataMap.delete(index2);
      }
    });
    return {
      classNames,
      style: style2
    };
  }
});
function _sfc_render$F(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames),
    style: normalizeStyle$1(_ctx.style)
  }, [renderSlot(_ctx.$slots, "default")], 6);
}
var _Grid = /* @__PURE__ */ _export_sfc$1(_sfc_main$N, [["render", _sfc_render$F]]);
var __defProp$7 = Object.defineProperty;
var __defProps$4 = Object.defineProperties;
var __getOwnPropDescs$4 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$7 = Object.getOwnPropertySymbols;
var __hasOwnProp$7 = Object.prototype.hasOwnProperty;
var __propIsEnum$7 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$7 = (obj, key, value) => key in obj ? __defProp$7(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$7 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$7.call(b2, prop))
      __defNormalProp$7(a, prop, b2[prop]);
  if (__getOwnPropSymbols$7)
    for (var prop of __getOwnPropSymbols$7(b2)) {
      if (__propIsEnum$7.call(b2, prop))
        __defNormalProp$7(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$4 = (a, b2) => __defProps$4(a, __getOwnPropDescs$4(b2));
const _sfc_main$M = defineComponent({
  name: "GridItem",
  props: {
    span: {
      type: [Number, Object],
      default: 1
    },
    offset: {
      type: [Number, Object],
      default: 0
    },
    suffix: {
      type: Boolean,
      default: false
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("grid-item");
    const domRef = ref();
    const {
      computedIndex
    } = useIndex({
      itemRef: domRef,
      selector: `.${prefixCls}`
    });
    const gridContext = inject(GridContextInjectionKey, {
      overflow: false,
      displayIndexList: [],
      cols: 24,
      colGap: 0
    });
    const gridDataCollector = inject(GridDataCollectorInjectionKey);
    const visible = computed(() => {
      var _a2;
      return (_a2 = gridContext == null ? void 0 : gridContext.displayIndexList) == null ? void 0 : _a2.includes(computedIndex.value);
    });
    const {
      span: propSpan,
      offset: propOffset
    } = toRefs(props);
    const rSpan = useResponsiveState(propSpan, 1);
    const rOffset = useResponsiveState(propOffset, 0);
    const itemData = computed(() => resolveItemData(gridContext.cols, __spreadProps$4(__spreadValues$7({}, props), {
      span: rSpan.value,
      offset: rOffset.value
    })));
    const classNames = computed(() => [prefixCls]);
    const offsetStyle = computed(() => {
      const {
        offset,
        span
      } = itemData.value;
      const {
        colGap
      } = gridContext;
      if (offset > 0) {
        const oneSpan = `(100% - ${colGap * (span - 1)}px) / ${span}`;
        return {
          "margin-left": `calc((${oneSpan} * ${offset}) + ${colGap * offset}px)`
        };
      }
      return {};
    });
    const columnStart = computed(() => {
      const {
        suffix,
        span
      } = itemData.value;
      const {
        cols
      } = gridContext;
      if (suffix) {
        return `${cols - span + 1}`;
      }
      return `span ${span}`;
    });
    const style2 = computed(() => {
      const {
        span
      } = itemData.value;
      return [{
        "grid-column": `${columnStart.value} / span ${span}`
      }, offsetStyle.value, !visible.value || span === 0 ? {
        display: "none"
      } : {}];
    });
    watchEffect(() => {
      if (computedIndex.value !== -1) {
        gridDataCollector == null ? void 0 : gridDataCollector.collectItemData(computedIndex.value, itemData.value);
      }
    });
    onUnmounted(() => {
      if (computedIndex.value !== -1) {
        gridDataCollector == null ? void 0 : gridDataCollector.removeItemData(computedIndex.value);
      }
    });
    return {
      classNames,
      style: style2,
      domRef,
      overflow: computed(() => gridContext.overflow)
    };
  }
});
function _sfc_render$E(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    ref: "domRef",
    class: normalizeClass(_ctx.classNames),
    style: normalizeStyle$1(_ctx.style)
  }, [renderSlot(_ctx.$slots, "default", {
    overflow: _ctx.overflow
  })], 6);
}
var GridItem = /* @__PURE__ */ _export_sfc$1(_sfc_main$M, [["render", _sfc_render$E]]);
const Grid$2 = Object.assign(_Grid, {
  Row,
  Col,
  Item: GridItem,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + Row.name, Row);
    app.component(componentPrefix + Col.name, Col);
    app.component(componentPrefix + _Grid.name, _Grid);
    app.component(componentPrefix + GridItem.name, GridItem);
  }
});
var __defProp$6 = Object.defineProperty;
var __getOwnPropSymbols$6 = Object.getOwnPropertySymbols;
var __hasOwnProp$6 = Object.prototype.hasOwnProperty;
var __propIsEnum$6 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$6 = (obj, key, value) => key in obj ? __defProp$6(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$6 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$6.call(b2, prop))
      __defNormalProp$6(a, prop, b2[prop]);
  if (__getOwnPropSymbols$6)
    for (var prop of __getOwnPropSymbols$6(b2)) {
      if (__propIsEnum$6.call(b2, prop))
        __defNormalProp$6(a, prop, b2[prop]);
    }
  return a;
};
const _sfc_main$L = defineComponent({
  name: "Tooltip",
  components: {
    Trigger
  },
  props: {
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    content: String,
    position: {
      type: String,
      default: "top"
    },
    mini: {
      type: Boolean,
      default: false
    },
    backgroundColor: {
      type: String
    },
    contentClass: {
      type: [String, Array, Object]
    },
    contentStyle: {
      type: Object
    },
    arrowClass: {
      type: [String, Array, Object]
    },
    arrowStyle: {
      type: Object
    },
    popupContainer: {
      type: [String, Object]
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("tooltip");
    const _popupVisible = ref(props.defaultPopupVisible);
    const computedPopupVisible = computed(() => {
      var _a2;
      return (_a2 = props.popupVisible) != null ? _a2 : _popupVisible.value;
    });
    const handlePopupVisibleChange = (visible) => {
      _popupVisible.value = visible;
      emit2("update:popupVisible", visible);
      emit2("popupVisibleChange", visible);
    };
    const contentCls = computed(() => [`${prefixCls}-content`, props.contentClass, {
      [`${prefixCls}-mini`]: props.mini
    }]);
    const computedContentStyle = computed(() => {
      if (props.backgroundColor || props.contentStyle) {
        return __spreadValues$6({
          backgroundColor: props.backgroundColor
        }, props.contentStyle);
      }
      return void 0;
    });
    const arrowCls = computed(() => [`${prefixCls}-popup-arrow`, props.arrowClass]);
    const computedArrowStyle = computed(() => {
      if (props.backgroundColor || props.arrowStyle) {
        return __spreadValues$6({
          backgroundColor: props.backgroundColor
        }, props.arrowStyle);
      }
      return void 0;
    });
    return {
      prefixCls,
      computedPopupVisible,
      contentCls,
      computedContentStyle,
      arrowCls,
      computedArrowStyle,
      handlePopupVisibleChange
    };
  }
});
function _sfc_render$D(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Trigger = resolveComponent("Trigger");
  return openBlock(), createBlock(_component_Trigger, {
    class: normalizeClass(_ctx.prefixCls),
    trigger: "hover",
    position: _ctx.position,
    "popup-visible": _ctx.computedPopupVisible,
    "popup-offset": 10,
    "show-arrow": "",
    "content-class": _ctx.contentCls,
    "content-style": _ctx.computedContentStyle,
    "arrow-class": _ctx.arrowCls,
    "arrow-style": _ctx.computedArrowStyle,
    "popup-container": _ctx.popupContainer,
    "animation-name": "zoom-in-fade-out",
    "auto-fit-transform-origin": "",
    role: "tooltip",
    onPopupVisibleChange: _ctx.handlePopupVisibleChange
  }, {
    content: withCtx(() => [renderSlot(_ctx.$slots, "content", {}, () => [createTextVNode(toDisplayString$1(_ctx.content), 1)])]),
    default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
    _: 3
  }, 8, ["class", "position", "popup-visible", "content-class", "content-style", "arrow-class", "arrow-style", "popup-container", "onPopupVisibleChange"]);
}
var _Tooltip = /* @__PURE__ */ _export_sfc$1(_sfc_main$L, [["render", _sfc_render$D]]);
const Tooltip = Object.assign(_Tooltip, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Tooltip.name, _Tooltip);
  }
});
function strip(num, precision) {
  if (precision === void 0) {
    precision = 15;
  }
  return +parseFloat(Number(num).toPrecision(precision));
}
function digitLength(num) {
  var eSplit = num.toString().split(/[eE]/);
  var len2 = (eSplit[0].split(".")[1] || "").length - +(eSplit[1] || 0);
  return len2 > 0 ? len2 : 0;
}
function float2Fixed(num) {
  if (num.toString().indexOf("e") === -1) {
    return Number(num.toString().replace(".", ""));
  }
  var dLen = digitLength(num);
  return dLen > 0 ? strip(Number(num) * Math.pow(10, dLen)) : Number(num);
}
function checkBoundary(num) {
  if (_boundaryCheckingState) {
    if (num > Number.MAX_SAFE_INTEGER || num < Number.MIN_SAFE_INTEGER) {
      console.warn(num + " is beyond boundary when transfer to integer, the results may not be accurate");
    }
  }
}
function createOperation(operation) {
  return function() {
    var nums = [];
    for (var _i = 0; _i < arguments.length; _i++) {
      nums[_i] = arguments[_i];
    }
    var first = nums[0], others = nums.slice(1);
    return others.reduce(function(prev, next) {
      return operation(prev, next);
    }, first);
  };
}
var times = createOperation(function(num1, num2) {
  var num1Changed = float2Fixed(num1);
  var num2Changed = float2Fixed(num2);
  var baseNum = digitLength(num1) + digitLength(num2);
  var leftValue = num1Changed * num2Changed;
  checkBoundary(leftValue);
  return leftValue / Math.pow(10, baseNum);
});
var plus = createOperation(function(num1, num2) {
  var baseNum = Math.pow(10, Math.max(digitLength(num1), digitLength(num2)));
  return (times(num1, baseNum) + times(num2, baseNum)) / baseNum;
});
var minus = createOperation(function(num1, num2) {
  var baseNum = Math.pow(10, Math.max(digitLength(num1), digitLength(num2)));
  return (times(num1, baseNum) - times(num2, baseNum)) / baseNum;
});
var divide = createOperation(function(num1, num2) {
  var num1Changed = float2Fixed(num1);
  var num2Changed = float2Fixed(num2);
  checkBoundary(num1Changed);
  checkBoundary(num2Changed);
  return times(num1Changed / num2Changed, strip(Math.pow(10, digitLength(num2) - digitLength(num1))));
});
function round$2(num, decimal) {
  var base2 = Math.pow(10, decimal);
  var result = divide(Math.round(Math.abs(times(num, base2))), base2);
  if (num < 0 && result !== 0) {
    result = times(result, -1);
  }
  return result;
}
var _boundaryCheckingState = true;
function enableBoundaryChecking(flag) {
  if (flag === void 0) {
    flag = true;
  }
  _boundaryCheckingState = flag;
}
var index$s = {
  strip,
  plus,
  minus,
  times,
  divide,
  round: round$2,
  digitLength,
  float2Fixed,
  enableBoundaryChecking
};
const _sfc_main$K = defineComponent({
  name: "IconPlus",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-plus`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$h = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$g = /* @__PURE__ */ createBaseVNode("path", {
  d: "M5 24h38M24 5v38"
}, null, -1);
const _hoisted_3$e = [_hoisted_2$g];
function _sfc_render$C(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$e, 14, _hoisted_1$h);
}
var _IconPlus = /* @__PURE__ */ _export_sfc$1(_sfc_main$K, [["render", _sfc_render$C]]);
const IconPlus = Object.assign(_IconPlus, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconPlus.name, _IconPlus);
  }
});
const _sfc_main$J = defineComponent({
  name: "IconMinus",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-minus`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$g = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$f = /* @__PURE__ */ createBaseVNode("path", {
  d: "M5 24h38"
}, null, -1);
const _hoisted_3$d = [_hoisted_2$f];
function _sfc_render$B(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$d, 14, _hoisted_1$g);
}
var _IconMinus = /* @__PURE__ */ _export_sfc$1(_sfc_main$J, [["render", _sfc_render$B]]);
const IconMinus = Object.assign(_IconMinus, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconMinus.name, _IconMinus);
  }
});
const SPEED = 150;
index$s.enableBoundaryChecking(false);
var _InputNumber = defineComponent({
  name: "InputNumber",
  props: {
    modelValue: Number,
    defaultValue: Number,
    mode: {
      type: String,
      default: "embed"
    },
    precision: Number,
    step: {
      type: Number,
      default: 1
    },
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    max: {
      type: Number,
      default: Infinity
    },
    min: {
      type: Number,
      default: -Infinity
    },
    formatter: {
      type: Function
    },
    parser: {
      type: Function
    },
    placeholder: String,
    hideButton: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    modelEvent: {
      type: String,
      default: "change"
    },
    readOnly: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value, ev) => true,
    "focus": (ev) => true,
    "blur": (ev) => true,
    "clear": (ev) => true,
    "input": (value, inputValue, ev) => true
  },
  setup(props, {
    emit: emit2,
    slots
  }) {
    var _a2;
    const {
      size: size2,
      disabled
    } = toRefs(props);
    const prefixCls = getPrefixCls("input-number");
    const inputRef = ref();
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      eventHandlers
    } = useFormItem({
      size: size2,
      disabled
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const mergedPrecision = computed(() => {
      if (isNumber$2(props.precision)) {
        const decimal = `${props.step}`.split(".")[1];
        const stepPrecision = decimal && decimal.length || 0;
        return Math.max(stepPrecision, props.precision);
      }
      return void 0;
    });
    const getStringValue = (number2) => {
      var _a22, _b2;
      if (!isNumber$2(number2)) {
        return "";
      }
      const numString = mergedPrecision.value ? number2.toFixed(mergedPrecision.value) : String(number2);
      return (_b2 = (_a22 = props.formatter) == null ? void 0 : _a22.call(props, numString)) != null ? _b2 : numString;
    };
    const _value = ref(getStringValue((_a2 = props.modelValue) != null ? _a2 : props.defaultValue));
    const valueNumber = computed(() => {
      var _a22, _b2;
      if (!_value.value) {
        return void 0;
      }
      const number2 = Number((_b2 = (_a22 = props.parser) == null ? void 0 : _a22.call(props, _value.value)) != null ? _b2 : _value.value);
      return Number.isNaN(number2) ? void 0 : number2;
    });
    const isMin = ref(isNumber$2(valueNumber.value) && valueNumber.value <= props.min);
    const isMax = ref(isNumber$2(valueNumber.value) && valueNumber.value >= props.max);
    let repeatTimer = 0;
    const clearRepeatTimer = () => {
      if (repeatTimer) {
        window.clearTimeout(repeatTimer);
        repeatTimer = 0;
      }
    };
    const getLegalValue = (value) => {
      if (isUndefined(value)) {
        return void 0;
      }
      if (isNumber$2(props.min) && value < props.min) {
        value = props.min;
      }
      if (isNumber$2(props.max) && value > props.max) {
        value = props.max;
      }
      return isNumber$2(mergedPrecision.value) ? index$s.round(value, mergedPrecision.value) : value;
    };
    const updateNumberStatus = (number2) => {
      let _isMin = false;
      let _isMax = false;
      if (isNumber$2(number2)) {
        if (number2 <= props.min) {
          _isMin = true;
        }
        if (number2 >= props.max) {
          _isMax = true;
        }
      }
      if (isMax.value !== _isMax) {
        isMax.value = _isMax;
      }
      if (isMin.value !== _isMin) {
        isMin.value = _isMin;
      }
    };
    const handleExceedRange = () => {
      const finalValue = getLegalValue(valueNumber.value);
      const stringValue = getStringValue(finalValue);
      if (finalValue !== valueNumber.value || _value.value !== stringValue) {
        _value.value = stringValue;
      }
      emit2("update:modelValue", finalValue);
    };
    watch(() => props.min, (newVal) => {
      const _isMin = isNumber$2(valueNumber.value) && valueNumber.value <= newVal;
      if (isMin.value !== _isMin) {
        isMin.value = _isMin;
      }
      const isExceedMinValue = isNumber$2(valueNumber.value) && valueNumber.value < newVal;
      if (isExceedMinValue) {
        handleExceedRange();
      }
    });
    watch(() => props.max, (newVal) => {
      const _isMax = isNumber$2(valueNumber.value) && valueNumber.value >= newVal;
      if (isMax.value !== _isMax) {
        isMax.value = _isMax;
      }
      const isExceedMaxValue = isNumber$2(valueNumber.value) && valueNumber.value > newVal;
      if (isExceedMaxValue) {
        handleExceedRange();
      }
    });
    const nextStep = (method, event) => {
      if (mergedDisabled.value || method === "plus" && isMax.value || method === "minus" && isMin.value) {
        return;
      }
      let nextValue;
      if (isNumber$2(valueNumber.value)) {
        nextValue = getLegalValue(index$s[method](valueNumber.value, props.step));
      } else {
        nextValue = props.min === -Infinity ? 0 : props.min;
      }
      _value.value = getStringValue(nextValue);
      updateNumberStatus(nextValue);
      emit2("update:modelValue", nextValue);
      emit2("change", nextValue, event);
    };
    const handleStepButton = (event, method, needRepeat = false) => {
      var _a22;
      event.preventDefault();
      (_a22 = inputRef.value) == null ? void 0 : _a22.focus();
      nextStep(method, event);
      if (needRepeat) {
        repeatTimer = window.setTimeout(() => event.target.dispatchEvent(event), SPEED);
      }
    };
    const handleInput = (value, ev) => {
      var _a22, _b2, _c2, _d;
      value = value.trim().replace(/。/g, ".");
      value = (_b2 = (_a22 = props.parser) == null ? void 0 : _a22.call(props, value)) != null ? _b2 : value;
      if (isNumber$2(Number(value)) || /^(\.|-)$/.test(value)) {
        _value.value = (_d = (_c2 = props.formatter) == null ? void 0 : _c2.call(props, value)) != null ? _d : value;
        updateNumberStatus(valueNumber.value);
        if (props.modelEvent === "input") {
          emit2("update:modelValue", valueNumber.value);
        }
        emit2("input", valueNumber.value, _value.value, ev);
      }
    };
    const handleFocus = (ev) => {
      emit2("focus", ev);
    };
    const handleChange = (value, ev) => {
      const finalValue = getLegalValue(valueNumber.value);
      const stringValue = getStringValue(finalValue);
      if (finalValue !== valueNumber.value || _value.value !== stringValue) {
        _value.value = stringValue;
        updateNumberStatus(finalValue);
      }
      nextTick(() => {
        if (isNumber$2(props.modelValue) && props.modelValue !== finalValue) {
          _value.value = getStringValue(props.modelValue);
          updateNumberStatus(props.modelValue);
        }
      });
      emit2("update:modelValue", finalValue);
      emit2("change", finalValue, ev);
    };
    const handleBlur = (ev) => {
      emit2("blur", ev);
    };
    const handleClear = (ev) => {
      var _a22, _b2;
      _value.value = "";
      emit2("update:modelValue", void 0);
      emit2("change", void 0, ev);
      (_b2 = (_a22 = eventHandlers.value) == null ? void 0 : _a22.onChange) == null ? void 0 : _b2.call(_a22, ev);
      emit2("clear", ev);
    };
    const onKeyDown = getKeyDownHandler(/* @__PURE__ */ new Map([[KEYBOARD_KEY.ARROW_UP, (ev) => {
      ev.preventDefault();
      !props.readOnly && nextStep("plus", ev);
    }], [KEYBOARD_KEY.ARROW_DOWN, (ev) => {
      ev.preventDefault();
      !props.readOnly && nextStep("minus", ev);
    }]]));
    watch(() => props.modelValue, (value) => {
      if (value !== valueNumber.value) {
        _value.value = getStringValue(value);
        updateNumberStatus(value);
      }
    });
    const renderSuffix = () => {
      var _a22;
      if (props.readOnly) {
        return null;
      }
      return createVNode(Fragment, null, [(_a22 = slots.suffix) == null ? void 0 : _a22.call(slots), createVNode("div", {
        "class": `${prefixCls}-step`
      }, [createVNode("button", {
        "class": [`${prefixCls}-step-button`, {
          [`${prefixCls}-step-button-disabled`]: mergedDisabled.value || isMax.value
        }],
        "type": "button",
        "tabindex": "-1",
        "disabled": mergedDisabled.value || isMax.value,
        "onMousedown": (e2) => handleStepButton(e2, "plus", true),
        "onMouseup": clearRepeatTimer,
        "onMouseleave": clearRepeatTimer
      }, [createVNode(IconUp, null, null)]), createVNode("button", {
        "class": [`${prefixCls}-step-button`, {
          [`${prefixCls}-step-button-disabled`]: mergedDisabled.value || isMin.value
        }],
        "type": "button",
        "tabindex": "-1",
        "disabled": mergedDisabled.value || isMin.value,
        "onMousedown": (e2) => handleStepButton(e2, "minus", true),
        "onMouseup": clearRepeatTimer,
        "onMouseleave": clearRepeatTimer
      }, [createVNode(IconDown, null, null)])])]);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-mode-${props.mode}`, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-readonly`]: props.readOnly
    }]);
    const renderPrependButton = () => {
      return createVNode(Button, {
        "size": mergedSize.value,
        "tabindex": "-1",
        "class": `${prefixCls}-step-button`,
        "disabled": mergedDisabled.value || isMin.value,
        "onMousedown": (ev) => handleStepButton(ev, "minus", true),
        "onMouseup": clearRepeatTimer,
        "onMouseleave": clearRepeatTimer
      }, {
        icon: () => createVNode(IconMinus, null, null)
      });
    };
    const renderAppendButton = () => {
      return createVNode(Button, {
        "size": mergedSize.value,
        "tabindex": "-1",
        "class": `${prefixCls}-step-button`,
        "disabled": mergedDisabled.value || isMax.value,
        "onMousedown": (ev) => handleStepButton(ev, "plus", true),
        "onMouseup": clearRepeatTimer,
        "onMouseleave": clearRepeatTimer
      }, {
        icon: () => createVNode(IconPlus, null, null)
      });
    };
    const render2 = () => {
      const _slots = props.mode === "embed" ? {
        prepend: slots.prepend,
        prefix: slots.prefix,
        suffix: props.hideButton ? slots.suffix : renderSuffix,
        append: slots.append
      } : {
        prepend: renderPrependButton,
        prefix: slots.prefix,
        suffix: slots.suffix,
        append: renderAppendButton
      };
      return createVNode(Input, {
        "key": `__arco__${props.mode}`,
        "ref": inputRef,
        "class": cls.value,
        "type": "text",
        "allowClear": props.allowClear,
        "size": mergedSize.value,
        "modelValue": _value.value,
        "placeholder": props.placeholder,
        "disabled": mergedDisabled.value,
        "readonly": props.readOnly,
        "error": props.error,
        "inputAttrs": {
          "role": "spinbutton",
          "aria-valuemax": props.max,
          "aria-valuemin": props.min,
          "aria-valuenow": _value.value
        },
        "onInput": handleInput,
        "onFocus": handleFocus,
        "onBlur": handleBlur,
        "onClear": handleClear,
        "onChange": handleChange,
        "onKeydown": onKeyDown
      }, _slots);
    };
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.focus();
    },
    blur() {
      var _a2;
      (_a2 = this.inputRef) == null ? void 0 : _a2.blur();
    }
  },
  render() {
    return this.render();
  }
});
const InputNumber = Object.assign(_InputNumber, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _InputNumber.name, _InputNumber);
  }
});
const LayoutSiderInjectionKey = Symbol("LayoutSiderInjectionKey");
const SiderInjectionKey = Symbol("SiderInjectionKey");
var _sfc_main$I = defineComponent({
  name: "Layout",
  props: {
    hasSider: {
      type: Boolean
    }
  },
  setup(props) {
    const siderIds = ref([]);
    const prefixCls = getPrefixCls("layout");
    const classNames = computed(() => [prefixCls, {
      [`${prefixCls}-has-sider`]: props.hasSider || siderIds.value.length
    }]);
    provide(LayoutSiderInjectionKey, {
      onSiderMount: (id) => siderIds.value.push(id),
      onSiderUnMount: (id) => {
        siderIds.value = siderIds.value.filter((_id) => _id !== id);
      }
    });
    return {
      classNames
    };
  }
});
function _sfc_render$A(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("section", {
    class: normalizeClass(_ctx.classNames)
  }, [renderSlot(_ctx.$slots, "default")], 2);
}
var _Layout = /* @__PURE__ */ _export_sfc$1(_sfc_main$I, [["render", _sfc_render$A]]);
const _sfc_main$H = defineComponent({
  name: "LayoutHeader",
  setup() {
    const prefixCls = getPrefixCls("layout-header");
    const classNames = [prefixCls];
    return {
      classNames
    };
  }
});
function _sfc_render$z(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("header", {
    class: normalizeClass(_ctx.classNames)
  }, [renderSlot(_ctx.$slots, "default")], 2);
}
var LayoutHeader = /* @__PURE__ */ _export_sfc$1(_sfc_main$H, [["render", _sfc_render$z]]);
const _sfc_main$G = defineComponent({
  name: "LayoutContent",
  setup() {
    const prefixCls = getPrefixCls("layout-content");
    const classNames = [prefixCls];
    return {
      classNames
    };
  }
});
function _sfc_render$y(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("main", {
    class: normalizeClass(_ctx.classNames)
  }, [renderSlot(_ctx.$slots, "default")], 2);
}
var LayoutContent = /* @__PURE__ */ _export_sfc$1(_sfc_main$G, [["render", _sfc_render$y]]);
const _sfc_main$F = defineComponent({
  name: "LayoutFooter",
  setup() {
    const prefixCls = getPrefixCls("layout-footer");
    const classNames = [prefixCls];
    return {
      classNames
    };
  }
});
function _sfc_render$x(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("footer", {
    class: normalizeClass(_ctx.classNames)
  }, [renderSlot(_ctx.$slots, "default")], 2);
}
var LayoutFooter = /* @__PURE__ */ _export_sfc$1(_sfc_main$F, [["render", _sfc_render$x]]);
const _sfc_main$E = defineComponent({
  name: "IconDragDot",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-drag-dot`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$f = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$e = /* @__PURE__ */ createBaseVNode("path", {
  d: "M40 17v2h-2v-2h2ZM25 17v2h-2v-2h2ZM10 17v2H8v-2h2ZM40 29v2h-2v-2h2ZM25 29v2h-2v-2h2ZM10 29v2H8v-2h2Z",
  fill: "currentColor",
  stroke: "none"
}, null, -1);
const _hoisted_3$c = /* @__PURE__ */ createBaseVNode("path", {
  d: "M40 17v2h-2v-2h2ZM25 17v2h-2v-2h2ZM10 17v2H8v-2h2ZM40 29v2h-2v-2h2ZM25 29v2h-2v-2h2ZM10 29v2H8v-2h2Z"
}, null, -1);
const _hoisted_4$6 = [_hoisted_2$e, _hoisted_3$c];
function _sfc_render$w(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_4$6, 14, _hoisted_1$f);
}
var _IconDragDot = /* @__PURE__ */ _export_sfc$1(_sfc_main$E, [["render", _sfc_render$w]]);
const IconDragDot = Object.assign(_IconDragDot, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconDragDot.name, _IconDragDot);
  }
});
const _sfc_main$D = defineComponent({
  name: "IconDragDotVertical",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-drag-dot-vertical`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$e = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$d = /* @__PURE__ */ createBaseVNode("path", {
  d: "M17 8h2v2h-2V8ZM17 23h2v2h-2v-2ZM17 38h2v2h-2v-2ZM29 8h2v2h-2V8ZM29 23h2v2h-2v-2ZM29 38h2v2h-2v-2Z",
  fill: "currentColor",
  stroke: "none"
}, null, -1);
const _hoisted_3$b = /* @__PURE__ */ createBaseVNode("path", {
  d: "M17 8h2v2h-2V8ZM17 23h2v2h-2v-2ZM17 38h2v2h-2v-2ZM29 8h2v2h-2V8ZM29 23h2v2h-2v-2ZM29 38h2v2h-2v-2Z"
}, null, -1);
const _hoisted_4$5 = [_hoisted_2$d, _hoisted_3$b];
function _sfc_render$v(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_4$5, 14, _hoisted_1$e);
}
var _IconDragDotVertical = /* @__PURE__ */ _export_sfc$1(_sfc_main$D, [["render", _sfc_render$v]]);
const IconDragDotVertical = Object.assign(_IconDragDotVertical, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconDragDotVertical.name, _IconDragDotVertical);
  }
});
var _sfc_main$C = defineComponent({
  name: "ResizeTrigger",
  components: {
    ResizeObserver: ResizeObserver$2,
    IconDragDot,
    IconDragDotVertical
  },
  props: {
    prefixCls: {
      type: String,
      required: true
    },
    direction: {
      type: String,
      default: "horizontal"
    }
  },
  emits: ["resize"],
  setup(props, {
    emit: emit2
  }) {
    const {
      direction,
      prefixCls
    } = toRefs(props);
    const isHorizontal2 = computed(() => (direction == null ? void 0 : direction.value) === "horizontal");
    const classNames = computed(() => [prefixCls.value, {
      [`${prefixCls.value}-horizontal`]: isHorizontal2.value,
      [`${prefixCls.value}-vertical`]: !isHorizontal2.value
    }]);
    const onResize = (entry) => {
      emit2("resize", entry);
    };
    return {
      classNames,
      onResize,
      isHorizontal: isHorizontal2
    };
  }
});
function _sfc_render$u(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconDragDot = resolveComponent("IconDragDot");
  const _component_IconDragDotVertical = resolveComponent("IconDragDotVertical");
  const _component_ResizeObserver = resolveComponent("ResizeObserver");
  return openBlock(), createBlock(_component_ResizeObserver, {
    onResize: _ctx.onResize
  }, {
    default: withCtx(() => [createBaseVNode("div", {
      class: normalizeClass(_ctx.classNames)
    }, [createCommentVNode(" @slot 自定义内容 "), renderSlot(_ctx.$slots, "default", {}, () => [createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-icon-wrapper`)
    }, [createCommentVNode(" @slot 自定义 icon "), renderSlot(_ctx.$slots, "icon", {}, () => [_ctx.isHorizontal ? (openBlock(), createBlock(_component_IconDragDot, {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, null, 8, ["class"])) : (openBlock(), createBlock(_component_IconDragDotVertical, {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, null, 8, ["class"]))])], 2)])], 2)]),
    _: 3
  }, 8, ["onResize"]);
}
var ResizeTrigger = /* @__PURE__ */ _export_sfc$1(_sfc_main$C, [["render", _sfc_render$u]]);
var __defProp$5 = Object.defineProperty;
var __getOwnPropSymbols$5 = Object.getOwnPropertySymbols;
var __hasOwnProp$5 = Object.prototype.hasOwnProperty;
var __propIsEnum$5 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$5 = (obj, key, value) => key in obj ? __defProp$5(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$5 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$5.call(b2, prop))
      __defNormalProp$5(a, prop, b2[prop]);
  if (__getOwnPropSymbols$5)
    for (var prop of __getOwnPropSymbols$5(b2)) {
      if (__propIsEnum$5.call(b2, prop))
        __defNormalProp$5(a, prop, b2[prop]);
    }
  return a;
};
const DIRECTION_LEFT = "left";
const DIRECTION_RIGHT = "right";
const DIRECTION_TOP = "top";
const DIRECTION_BOTTOM = "bottom";
const allDirections = [DIRECTION_LEFT, DIRECTION_RIGHT, DIRECTION_TOP, DIRECTION_BOTTOM];
function getRealSize(pageSize, padding) {
  if (pageSize === 0)
    return 0;
  const res = pageSize - padding;
  return res <= 0 ? 0 : res;
}
function isHorizontal(direction) {
  return [DIRECTION_TOP, DIRECTION_BOTTOM].indexOf(direction) > -1;
}
const _sfc_main$B = defineComponent({
  name: "ResizeBox",
  components: {
    ResizeTrigger
  },
  inheritAttrs: false,
  props: {
    width: {
      type: Number
    },
    height: {
      type: Number
    },
    component: {
      type: String,
      default: "div"
    },
    directions: {
      type: Array,
      default: () => ["right"]
    }
  },
  emits: {
    "update:width": (width) => true,
    "update:height": (height) => true,
    "movingStart": (ev) => true,
    "moving": (size2, ev) => true,
    "movingEnd": (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const {
      height: propHeight,
      width: propWidth,
      directions
    } = toRefs(props);
    const [width, setWidth] = useMergeState(null, reactive({
      value: propWidth
    }));
    const [height, setHeight] = useMergeState(null, reactive({
      value: propHeight
    }));
    const wrapperRef = ref();
    const paddingStyles = reactive({});
    const prefixCls = getPrefixCls("resizebox");
    const classNames = computed(() => [prefixCls]);
    const styles = computed(() => {
      return __spreadValues$5(__spreadValues$5(__spreadValues$5({}, isNumber$2(width.value) ? {
        width: `${width.value}px`
      } : {}), isNumber$2(height.value) ? {
        height: `${height.value}px`
      } : {}), paddingStyles);
    });
    const allowDirections = computed(() => directions.value.filter((direction) => allDirections.includes(direction)));
    const record = {
      direction: "",
      startPageX: 0,
      startPageY: 0,
      startWidth: 0,
      startHeight: 0,
      moving: false,
      padding: {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0
      }
    };
    function onMoving(e2) {
      if (!record.moving)
        return;
      const {
        startPageX,
        startPageY,
        startWidth,
        startHeight,
        direction
      } = record;
      let newWidth = startWidth;
      let newHeight = startHeight;
      const offsetX = e2.pageX - startPageX;
      const offsetY = e2.pageY - startPageY;
      switch (direction) {
        case DIRECTION_LEFT:
          newWidth = startWidth - offsetX;
          setWidth(newWidth);
          emit2("update:width", newWidth);
          break;
        case DIRECTION_RIGHT:
          newWidth = startWidth + offsetX;
          setWidth(newWidth);
          emit2("update:width", newWidth);
          break;
        case DIRECTION_TOP:
          newHeight = startHeight - offsetY;
          setHeight(newHeight);
          emit2("update:height", newHeight);
          break;
        case DIRECTION_BOTTOM:
          newHeight = startHeight + offsetY;
          setHeight(newHeight);
          emit2("update:height", newHeight);
          break;
      }
      emit2("moving", {
        width: newWidth,
        height: newHeight
      }, e2);
    }
    function onMoveEnd(e2) {
      record.moving = false;
      off(window, "mousemove", onMoving);
      off(window, "mouseup", onMoveEnd);
      off(window, "contextmenu", onMoveEnd);
      document.body.style.cursor = "default";
      emit2("movingEnd", e2);
    }
    function onMoveStart(direction, e2) {
      var _a2, _b2;
      emit2("movingStart", e2);
      record.moving = true;
      record.startPageX = e2.pageX;
      record.startPageY = e2.pageY;
      record.direction = direction;
      const {
        top,
        left,
        right,
        bottom
      } = record.padding;
      record.startWidth = getRealSize(((_a2 = wrapperRef.value) == null ? void 0 : _a2.clientWidth) || 0, left + right);
      record.startHeight = getRealSize(((_b2 = wrapperRef.value) == null ? void 0 : _b2.clientHeight) || 0, top + bottom);
      on(window, "mousemove", onMoving);
      on(window, "mouseup", onMoveEnd);
      on(window, "contextmenu", onMoveEnd);
      document.body.style.cursor = isHorizontal(direction) ? "row-resize" : "col-resize";
    }
    function onTiggerResize(direction, entry) {
      const {
        width: width2,
        height: height2
      } = entry.contentRect;
      const size2 = isHorizontal(direction) ? height2 : width2;
      record.padding[direction] = size2;
      paddingStyles[`padding-${direction}`] = `${size2}px`;
    }
    return {
      prefixCls,
      classNames,
      styles,
      wrapperRef,
      onMoveStart,
      isHorizontal,
      allowDirections,
      onTiggerResize
    };
  }
});
function _sfc_render$t(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ResizeTrigger = resolveComponent("ResizeTrigger");
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.component), mergeProps({
    ref: "wrapperRef",
    class: _ctx.classNames
  }, _ctx.$attrs, {
    style: _ctx.styles
  }), {
    default: withCtx(() => [renderSlot(_ctx.$slots, "default"), (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.allowDirections, (direction) => {
      return openBlock(), createBlock(_component_ResizeTrigger, {
        key: direction,
        "prefix-cls": `${_ctx.prefixCls}-trigger`,
        class: normalizeClass(`${_ctx.prefixCls}-direction-${direction}`),
        direction: _ctx.isHorizontal(direction) ? "horizontal" : "vertical",
        onMousedown: (e2) => {
          _ctx.onMoveStart(direction, e2);
        },
        onResize: (entry) => {
          _ctx.onTiggerResize(direction, entry);
        }
      }, createSlots({
        default: withCtx(() => [_ctx.$slots["resize-trigger"] ? renderSlot(_ctx.$slots, "resize-trigger", {
          key: 0,
          direction
        }) : createCommentVNode("v-if", true)]),
        _: 2
      }, [_ctx.$slots["resize-trigger-icon"] ? {
        name: "icon",
        fn: withCtx(() => [renderSlot(_ctx.$slots, "resize-trigger-icon", {
          direction
        })])
      } : void 0]), 1032, ["prefix-cls", "class", "direction", "onMousedown", "onResize"]);
    }), 128))]),
    _: 3
  }, 16, ["class", "style"]);
}
var _ResizeBox = /* @__PURE__ */ _export_sfc$1(_sfc_main$B, [["render", _sfc_render$t]]);
const ResizeBox = Object.assign(_ResizeBox, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _ResizeBox.name, _ResizeBox);
  }
});
function useResponsive(breakpoint, callback) {
  const resultBreakpoint = computed(() => isRef(breakpoint) ? breakpoint.value : breakpoint);
  let subscribeToken = "";
  onMounted(() => {
    subscribeToken = responsiveObserve.subscribe((screens2, breakpointChecked) => {
      if (!resultBreakpoint.value)
        return;
      if (!breakpointChecked || breakpointChecked === resultBreakpoint.value) {
        callback(!!screens2[resultBreakpoint.value]);
      }
    });
  });
  onUnmounted(() => {
    if (subscribeToken) {
      responsiveObserve.unsubscribe(subscribeToken);
    }
  });
}
const generateId$1 = (() => {
  let i2 = 0;
  return (prefix = "") => {
    i2 += 1;
    return `${prefix}${i2}`;
  };
})();
var _sfc_main$A = defineComponent({
  name: "LayoutSider",
  components: {
    IconLeft,
    IconRight,
    ResizeBox
  },
  props: {
    theme: {
      type: String,
      default: "light"
    },
    collapsed: {
      type: Boolean,
      default: void 0
    },
    defaultCollapsed: {
      type: Boolean
    },
    collapsible: {
      type: Boolean
    },
    width: {
      type: Number,
      default: 200
    },
    collapsedWidth: {
      type: Number,
      default: 48
    },
    reverseArrow: {
      type: Boolean
    },
    breakpoint: {
      type: String
    },
    resizeDirections: {
      type: Array,
      default: void 0
    },
    hideTrigger: {
      type: Boolean
    }
  },
  emits: ["collapse", "update:collapsed", "breakpoint"],
  setup(props, {
    emit: emit2
  }) {
    const {
      theme: theme2,
      collapsed,
      defaultCollapsed,
      collapsible,
      hideTrigger,
      breakpoint,
      collapsedWidth,
      resizeDirections
    } = toRefs(props);
    const [localCollapsed, setLocalCollapsed] = useMergeState(defaultCollapsed.value, reactive({
      value: collapsed
    }));
    const componentTag = computed(() => resizeDirections.value ? "ResizeBox" : "div");
    const showTrigger = computed(() => collapsible.value && !hideTrigger.value);
    const prefixCls = getPrefixCls("layout-sider");
    const classNames = computed(() => [prefixCls, {
      [`${prefixCls}-light`]: theme2.value === "light",
      [`${prefixCls}-has-trigger`]: showTrigger.value,
      [`${prefixCls}-collapsed`]: collapsed.value
    }]);
    const siderWidth = computed(() => {
      const {
        width,
        collapsedWidth: collapsedWidth2
      } = props;
      const rawWidth = localCollapsed.value ? collapsedWidth2 : width;
      return isNumber$2(rawWidth) ? `${rawWidth}px` : String(rawWidth);
    });
    const triggerClassNames = computed(() => [`${prefixCls}-trigger`, {
      [`${prefixCls}-trigger-light`]: theme2.value === "light"
    }]);
    const toggleTrigger = () => {
      const newCollapsed = !localCollapsed.value;
      setLocalCollapsed(newCollapsed);
      emit2("update:collapsed", newCollapsed);
      emit2("collapse", newCollapsed, "clickTrigger");
    };
    useResponsive(breakpoint, (checked) => {
      const newCollapsed = !checked;
      if (newCollapsed !== localCollapsed.value) {
        setLocalCollapsed(newCollapsed);
        emit2("update:collapsed", newCollapsed);
        emit2("collapse", newCollapsed, "responsive");
        emit2("breakpoint", newCollapsed);
      }
    });
    const uniqueId = generateId$1("__arco_layout_sider");
    const siderHook = inject(LayoutSiderInjectionKey, void 0);
    onMounted(() => {
      var _a2;
      (_a2 = siderHook == null ? void 0 : siderHook.onSiderMount) == null ? void 0 : _a2.call(siderHook, uniqueId);
    });
    onUnmounted(() => {
      var _a2;
      (_a2 = siderHook == null ? void 0 : siderHook.onSiderUnMount) == null ? void 0 : _a2.call(siderHook, uniqueId);
    });
    provide(SiderInjectionKey, reactive({
      theme: theme2,
      collapsed: localCollapsed,
      collapsedWidth
    }));
    return {
      componentTag,
      prefixCls,
      classNames,
      triggerClassNames,
      localCollapsed,
      siderWidth,
      showTrigger,
      toggleTrigger
    };
  }
});
const _hoisted_1$d = {
  key: 0
};
const _hoisted_2$c = {
  key: 1
};
function _sfc_render$s(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconLeft = resolveComponent("IconLeft");
  const _component_IconRight = resolveComponent("IconRight");
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.componentTag), mergeProps({
    class: _ctx.classNames,
    style: {
      width: _ctx.siderWidth
    }
  }, _ctx.resizeDirections ? {
    directions: _ctx.resizeDirections
  } : {}), {
    default: withCtx(() => [createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-children`)
    }, [renderSlot(_ctx.$slots, "default")], 2), _ctx.showTrigger ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(_ctx.triggerClassNames),
      style: normalizeStyle$1({
        width: _ctx.siderWidth
      }),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.toggleTrigger && _ctx.toggleTrigger(...args))
    }, [renderSlot(_ctx.$slots, "trigger", {
      collapsed: _ctx.localCollapsed
    }, () => [!_ctx.reverseArrow ? (openBlock(), createElementBlock("div", _hoisted_1$d, [!_ctx.localCollapsed ? (openBlock(), createBlock(_component_IconLeft, {
      key: 0
    })) : (openBlock(), createBlock(_component_IconRight, {
      key: 1
    }))])) : (openBlock(), createElementBlock("div", _hoisted_2$c, [_ctx.localCollapsed ? (openBlock(), createBlock(_component_IconLeft, {
      key: 0
    })) : (openBlock(), createBlock(_component_IconRight, {
      key: 1
    }))]))])], 6)) : createCommentVNode("v-if", true)]),
    _: 3
  }, 16, ["class", "style"]);
}
var LayoutSider = /* @__PURE__ */ _export_sfc$1(_sfc_main$A, [["render", _sfc_render$s]]);
const Layout = Object.assign(_Layout, {
  Header: LayoutHeader,
  Content: LayoutContent,
  Footer: LayoutFooter,
  Sider: LayoutSider,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Layout.name, _Layout);
    app.component(componentPrefix + LayoutHeader.name, LayoutHeader);
    app.component(componentPrefix + LayoutContent.name, LayoutContent);
    app.component(componentPrefix + LayoutFooter.name, LayoutFooter);
    app.component(componentPrefix + LayoutSider.name, LayoutSider);
  }
});
const _sfc_main$z = defineComponent({
  name: "Pager",
  props: {
    pageNumber: {
      type: Number
    },
    current: {
      type: Number
    },
    disabled: {
      type: Boolean,
      default: false
    },
    style: {
      type: Object
    },
    activeStyle: {
      type: Object
    }
  },
  emits: ["click"],
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("pagination-item");
    const isActive = computed(() => props.current === props.pageNumber);
    const handleClick = (e2) => {
      if (!props.disabled) {
        emit2("click", props.pageNumber, e2);
      }
    };
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-active`]: isActive.value
    }]);
    const mergedStyle = computed(() => {
      return isActive.value ? props.activeStyle : props.style;
    });
    return {
      prefixCls,
      cls,
      mergedStyle,
      handleClick
    };
  }
});
function _sfc_render$r(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("li", {
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.mergedStyle),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [renderSlot(_ctx.$slots, "default", {
    page: _ctx.pageNumber
  }, () => [createTextVNode(toDisplayString$1(_ctx.pageNumber), 1)])], 6);
}
var Pager = /* @__PURE__ */ _export_sfc$1(_sfc_main$z, [["render", _sfc_render$r]]);
const getLegalPage = (page, {
  min: min3,
  max: max3
}) => {
  if (page < min3) {
    return min3;
  }
  if (page > max3) {
    return max3;
  }
  return page;
};
const _sfc_main$y = defineComponent({
  name: "StepPager",
  components: {
    IconLeft,
    IconRight
  },
  props: {
    pages: {
      type: Number,
      required: true
    },
    current: {
      type: Number,
      required: true
    },
    type: {
      type: String,
      required: true
    },
    disabled: {
      type: Boolean,
      default: false
    },
    simple: {
      type: Boolean,
      default: false
    }
  },
  emits: ["click"],
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("pagination-item");
    const isNext = props.type === "next";
    const mergedDisabled = computed(() => {
      if (props.disabled) {
        return props.disabled;
      }
      if (!props.pages) {
        return true;
      }
      if (isNext && props.current === props.pages) {
        return true;
      }
      return !isNext && props.current <= 1;
    });
    const nextPage = computed(() => getLegalPage(props.current + (isNext ? 1 : -1), {
      min: 1,
      max: props.pages
    }));
    const handleClick = (e2) => {
      if (!mergedDisabled.value) {
        emit2("click", nextPage.value);
      }
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-${props.type}`, {
      [`${prefixCls}-disabled`]: mergedDisabled.value
    }]);
    return {
      prefixCls,
      cls,
      isNext,
      handleClick
    };
  }
});
function _sfc_render$q(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_right = resolveComponent("icon-right");
  const _component_icon_left = resolveComponent("icon-left");
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.simple ? "span" : "li"), {
    class: normalizeClass(_ctx.cls),
    onClick: _ctx.handleClick
  }, {
    default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
      type: _ctx.isNext ? "next" : "previous"
    }, () => [_ctx.isNext ? (openBlock(), createBlock(_component_icon_right, {
      key: 0
    })) : (openBlock(), createBlock(_component_icon_left, {
      key: 1
    }))])]),
    _: 3
  }, 8, ["class", "onClick"]);
}
var StepPager = /* @__PURE__ */ _export_sfc$1(_sfc_main$y, [["render", _sfc_render$q]]);
const _sfc_main$x = defineComponent({
  name: "EllipsisPager",
  components: {
    IconMore
  },
  props: {
    current: {
      type: Number,
      required: true
    },
    step: {
      type: Number,
      default: 5
    },
    pages: {
      type: Number,
      required: true
    }
  },
  emits: ["click"],
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("pagination-item");
    const nextPage = computed(() => getLegalPage(props.current + props.step, {
      min: 1,
      max: props.pages
    }));
    const handleClick = (e2) => {
      emit2("click", nextPage.value);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-ellipsis`]);
    return {
      prefixCls,
      cls,
      handleClick
    };
  }
});
function _sfc_render$p(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_more = resolveComponent("icon-more");
  return openBlock(), createElementBlock("li", {
    class: normalizeClass(_ctx.cls),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [renderSlot(_ctx.$slots, "default", {}, () => [createVNode(_component_icon_more)])], 2);
}
var EllipsisPager = /* @__PURE__ */ _export_sfc$1(_sfc_main$x, [["render", _sfc_render$p]]);
const _sfc_main$w = defineComponent({
  name: "PageJumper",
  components: {
    InputNumber
  },
  props: {
    current: {
      type: Number,
      required: true
    },
    simple: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    pages: {
      type: Number,
      required: true
    },
    size: {
      type: String
    },
    onChange: {
      type: Function
    }
  },
  emits: ["change"],
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("pagination-jumper");
    const {
      t: t2
    } = useI18n$1();
    const inputValue = ref(props.simple ? props.current : void 0);
    const handleFormatter = (value) => {
      const parseIntVal = parseInt(value.toString(), 10);
      return Number.isNaN(parseIntVal) ? void 0 : String(parseIntVal);
    };
    const handleChange = (value) => {
      emit2("change", inputValue.value);
      nextTick(() => {
        if (!props.simple) {
          inputValue.value = void 0;
        }
      });
    };
    watch(() => props.current, (value) => {
      if (props.simple && value !== inputValue.value) {
        inputValue.value = value;
      }
    });
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-simple`]: props.simple
    }]);
    return {
      prefixCls,
      cls,
      t: t2,
      inputValue,
      handleChange,
      handleFormatter
    };
  }
});
function _sfc_render$o(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_input_number = resolveComponent("input-number");
  return openBlock(), createElementBlock("span", {
    class: normalizeClass(_ctx.cls)
  }, [!_ctx.simple ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass([`${_ctx.prefixCls}-prepend`, `${_ctx.prefixCls}-text-goto`])
  }, [renderSlot(_ctx.$slots, "jumper-prepend", {}, () => [createTextVNode(toDisplayString$1(_ctx.t("pagination.goto")), 1)])], 2)) : createCommentVNode("v-if", true), createVNode(_component_input_number, {
    modelValue: _ctx.inputValue,
    "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.inputValue = $event),
    class: normalizeClass(`${_ctx.prefixCls}-input`),
    min: 1,
    max: _ctx.pages,
    size: _ctx.size,
    disabled: _ctx.disabled,
    "hide-button": "",
    formatter: _ctx.handleFormatter,
    onChange: _ctx.handleChange
  }, null, 8, ["modelValue", "class", "max", "size", "disabled", "formatter", "onChange"]), _ctx.$slots["jumper-append"] ? (openBlock(), createElementBlock("span", {
    key: 1,
    class: normalizeClass(`${_ctx.prefixCls}-append`)
  }, [renderSlot(_ctx.$slots, "jumper-append")], 2)) : createCommentVNode("v-if", true), _ctx.simple ? (openBlock(), createElementBlock(Fragment, {
    key: 2
  }, [createBaseVNode("span", {
    class: normalizeClass(`${_ctx.prefixCls}-separator`)
  }, "/", 2), createBaseVNode("span", {
    class: normalizeClass(`${_ctx.prefixCls}-total-page`)
  }, toDisplayString$1(_ctx.pages), 3)], 64)) : createCommentVNode("v-if", true)], 2);
}
var PageJumper = /* @__PURE__ */ _export_sfc$1(_sfc_main$w, [["render", _sfc_render$o]]);
const _sfc_main$v = defineComponent({
  name: "PageOptions",
  components: {
    ArcoSelect: Select
  },
  props: {
    sizeOptions: {
      type: Array,
      required: true
    },
    pageSize: Number,
    disabled: Boolean,
    size: {
      type: String
    },
    onChange: {
      type: Function
    },
    selectProps: {
      type: Object
    }
  },
  emits: ["change"],
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("pagination-options");
    const {
      t: t2
    } = useI18n$1();
    const options = computed(() => props.sizeOptions.map((value) => ({
      value,
      label: `${value} ${t2("pagination.countPerPage")}`
    })));
    const handleChange = (value) => {
      emit2("change", value);
    };
    return {
      prefixCls,
      options,
      handleChange
    };
  }
});
function _sfc_render$n(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_arco_select = resolveComponent("arco-select");
  return openBlock(), createElementBlock("span", {
    class: normalizeClass(_ctx.prefixCls)
  }, [createVNode(_component_arco_select, mergeProps({
    "model-value": _ctx.pageSize,
    options: _ctx.options,
    size: _ctx.size,
    disabled: _ctx.disabled
  }, _ctx.selectProps, {
    onChange: _ctx.handleChange
  }), null, 16, ["model-value", "options", "size", "disabled", "onChange"])], 2);
}
var PageOptions = /* @__PURE__ */ _export_sfc$1(_sfc_main$v, [["render", _sfc_render$n]]);
var _Pagination = defineComponent({
  name: "Pagination",
  props: {
    total: {
      type: Number,
      required: true
    },
    current: Number,
    defaultCurrent: {
      type: Number,
      default: 1
    },
    pageSize: Number,
    defaultPageSize: {
      type: Number,
      default: 10
    },
    disabled: {
      type: Boolean,
      default: false
    },
    hideOnSinglePage: {
      type: Boolean,
      default: false
    },
    simple: {
      type: Boolean,
      default: false
    },
    showTotal: {
      type: Boolean,
      default: false
    },
    showMore: {
      type: Boolean,
      default: false
    },
    showJumper: {
      type: Boolean,
      default: false
    },
    showPageSize: {
      type: Boolean,
      default: false
    },
    pageSizeOptions: {
      type: Array,
      default: () => [10, 20, 30, 40, 50]
    },
    pageSizeProps: {
      type: Object
    },
    size: {
      type: String
    },
    pageItemStyle: {
      type: Object
    },
    activePageItemStyle: {
      type: Object
    },
    baseSize: {
      type: Number,
      default: 6
    },
    bufferSize: {
      type: Number,
      default: 2
    },
    autoAdjust: {
      type: Boolean,
      default: true
    }
  },
  emits: {
    "update:current": (current) => true,
    "update:pageSize": (pageSize) => true,
    "change": (current) => true,
    "pageSizeChange": (pageSize) => true
  },
  setup(props, {
    emit: emit2,
    slots
  }) {
    const prefixCls = getPrefixCls("pagination");
    const {
      t: t2
    } = useI18n$1();
    const {
      disabled,
      pageItemStyle,
      activePageItemStyle,
      size: size2
    } = toRefs(props);
    const {
      mergedSize
    } = useSize$1(size2);
    const _current = ref(props.defaultCurrent);
    const _pageSize = ref(props.defaultPageSize);
    const computedCurrent = computed(() => {
      var _a2;
      return (_a2 = props.current) != null ? _a2 : _current.value;
    });
    const computedPageSize = computed(() => {
      var _a2;
      return (_a2 = props.pageSize) != null ? _a2 : _pageSize.value;
    });
    const pages = computed(() => Math.ceil(props.total / computedPageSize.value));
    const handleClick = (page) => {
      if (page !== computedCurrent.value && isNumber$2(page) && !props.disabled) {
        _current.value = page;
        emit2("update:current", page);
        emit2("change", page);
      }
    };
    const handlePageSizeChange = (pageSize) => {
      _pageSize.value = pageSize;
      emit2("update:pageSize", pageSize);
      emit2("pageSizeChange", pageSize);
    };
    const pagerProps = reactive({
      current: computedCurrent,
      pages,
      disabled,
      style: pageItemStyle,
      activeStyle: activePageItemStyle,
      onClick: handleClick
    });
    const getPageItemElement = (type, props2 = {}) => {
      if (type === "more") {
        return createVNode(EllipsisPager, mergeProps(props2, pagerProps), {
          default: slots["page-item-ellipsis"]
        });
      }
      if (type === "previous") {
        return createVNode(StepPager, mergeProps({
          "type": "previous"
        }, props2, pagerProps), {
          default: slots["page-item-step"]
        });
      }
      if (type === "next") {
        return createVNode(StepPager, mergeProps({
          "type": "next"
        }, props2, pagerProps), {
          default: slots["page-item-step"]
        });
      }
      return createVNode(Pager, mergeProps(props2, pagerProps), {
        default: slots["page-item"]
      });
    };
    const pageList = computed(() => {
      const pageList2 = [];
      if (pages.value < props.baseSize + props.bufferSize * 2) {
        for (let i2 = 1; i2 <= pages.value; i2++) {
          pageList2.push(getPageItemElement("page", {
            key: i2,
            pageNumber: i2
          }));
        }
      } else {
        let left = 1;
        let right = pages.value;
        let hasLeftEllipsis = false;
        let hasRightEllipsis = false;
        if (computedCurrent.value > 2 + props.bufferSize) {
          hasLeftEllipsis = true;
          left = Math.min(computedCurrent.value - props.bufferSize, pages.value - 2 * props.bufferSize);
        }
        if (computedCurrent.value < pages.value - (props.bufferSize + 1)) {
          hasRightEllipsis = true;
          right = Math.max(computedCurrent.value + props.bufferSize, 2 * props.bufferSize + 1);
        }
        if (hasLeftEllipsis) {
          pageList2.push(getPageItemElement("page", {
            key: 1,
            pageNumber: 1
          }));
          pageList2.push(getPageItemElement("more", {
            key: "left-ellipsis-pager",
            step: -(props.bufferSize * 2 + 1)
          }));
        }
        for (let i2 = left; i2 <= right; i2++) {
          pageList2.push(getPageItemElement("page", {
            key: i2,
            pageNumber: i2
          }));
        }
        if (hasRightEllipsis) {
          pageList2.push(getPageItemElement("more", {
            key: "right-ellipsis-pager",
            step: props.bufferSize * 2 + 1
          }));
          pageList2.push(getPageItemElement("page", {
            key: pages.value,
            pageNumber: pages.value
          }));
        }
      }
      return pageList2;
    });
    const renderPager = () => {
      if (props.simple) {
        return createVNode("span", {
          "class": `${prefixCls}-simple`
        }, [getPageItemElement("previous", {
          simple: true
        }), createVNode(PageJumper, {
          "disabled": props.disabled,
          "current": computedCurrent.value,
          "size": mergedSize.value,
          "pages": pages.value,
          "simple": true,
          "onChange": handleClick
        }, null), getPageItemElement("next", {
          simple: true
        })]);
      }
      return createVNode("ul", {
        "class": `${prefixCls}-list`
      }, [getPageItemElement("previous", {
        simple: true
      }), pageList.value, props.showMore && getPageItemElement("more", {
        key: "more",
        step: props.bufferSize * 2 + 1
      }), getPageItemElement("next", {
        simple: true
      })]);
    };
    watch(computedPageSize, (curPageSize, prePageSize) => {
      if (props.autoAdjust && curPageSize !== prePageSize && computedCurrent.value > 1) {
        const index2 = prePageSize * (computedCurrent.value - 1) + 1;
        const newPage = Math.ceil(index2 / curPageSize);
        if (newPage !== computedCurrent.value) {
          _current.value = newPage;
          emit2("update:current", newPage);
          emit2("change", newPage);
        }
      }
    });
    watch(pages, (curPages, prePages) => {
      if (props.autoAdjust && curPages !== prePages && computedCurrent.value > 1 && computedCurrent.value > curPages) {
        _current.value = curPages;
        emit2("update:current", curPages);
        emit2("change", curPages);
      }
    });
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-simple`]: props.simple,
      [`${prefixCls}-disabled`]: props.disabled
    }]);
    return () => {
      var _a2, _b2;
      if (props.hideOnSinglePage && pages.value <= 1) {
        return null;
      }
      return createVNode("div", {
        "class": cls.value
      }, [props.showTotal && createVNode("span", {
        "class": `${prefixCls}-total`
      }, [(_b2 = (_a2 = slots.total) == null ? void 0 : _a2.call(slots, {
        total: props.total
      })) != null ? _b2 : t2("pagination.total", props.total)]), renderPager(), props.showPageSize && createVNode(PageOptions, {
        "disabled": props.disabled,
        "sizeOptions": props.pageSizeOptions,
        "pageSize": computedPageSize.value,
        "size": mergedSize.value,
        "onChange": handlePageSizeChange,
        "selectProps": props.pageSizeProps
      }, null), !props.simple && props.showJumper && createVNode(PageJumper, {
        "disabled": props.disabled,
        "current": computedCurrent.value,
        "pages": pages.value,
        "size": mergedSize.value,
        "onChange": handleClick
      }, {
        "jumper-prepend": slots["jumper-prepend"],
        "jumper-append": slots["jumper-append"]
      })]);
    };
  }
});
const Pagination = Object.assign(_Pagination, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Pagination.name, _Pagination);
  }
});
const usePagination = (props, {
  emit: emit2
}) => {
  var _a2, _b2;
  const _current = ref(isObject$5(props.paginationProps) ? (_a2 = props.paginationProps.defaultCurrent) != null ? _a2 : 1 : 1);
  const _pageSize = ref(isObject$5(props.paginationProps) ? (_b2 = props.paginationProps.defaultPageSize) != null ? _b2 : 10 : 10);
  const current = computed(() => {
    var _a22;
    return isObject$5(props.paginationProps) ? (_a22 = props.paginationProps.current) != null ? _a22 : _current.value : _current.value;
  });
  const pageSize = computed(() => {
    var _a22;
    return isObject$5(props.paginationProps) ? (_a22 = props.paginationProps.pageSize) != null ? _a22 : _pageSize.value : _pageSize.value;
  });
  const handlePageChange = (page) => {
    _current.value = page;
    emit2("pageChange", page);
  };
  const handlePageSizeChange = (pageSize2) => {
    _pageSize.value = pageSize2;
    emit2("pageSizeChange", pageSize2);
  };
  return {
    current,
    pageSize,
    handlePageChange,
    handlePageSizeChange
  };
};
function _isSlot$2(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode$1(s);
}
var _List = defineComponent({
  name: "List",
  props: {
    data: {
      type: Array
    },
    size: {
      type: String,
      default: "medium"
    },
    bordered: {
      type: Boolean,
      default: true
    },
    split: {
      type: Boolean,
      default: true
    },
    loading: {
      type: Boolean,
      default: false
    },
    hoverable: {
      type: Boolean,
      default: false
    },
    paginationProps: {
      type: Object
    },
    gridProps: {
      type: Object
    },
    maxHeight: {
      type: Number,
      default: 0
    },
    bottomOffset: {
      type: Number,
      default: 0
    },
    virtualListProps: {
      type: Object
    },
    scrollbar: {
      type: [Object, Boolean],
      default: true
    }
  },
  emits: {
    scroll: () => true,
    reachBottom: () => true,
    pageChange: (page) => true,
    pageSizeChange: (pageSize) => true
  },
  setup(props, {
    emit: emit2,
    slots
  }) {
    const {
      scrollbar
    } = toRefs(props);
    const prefixCls = getPrefixCls("list");
    const {
      componentRef,
      elementRef: listRef
    } = useComponentRef("containerRef");
    const isVirtualList = computed(() => props.virtualListProps);
    const {
      displayScrollbar,
      scrollbarProps
    } = useScrollbar(scrollbar);
    let preScrollTop = 0;
    const handleScroll2 = (e2) => {
      const {
        scrollTop,
        scrollHeight,
        offsetHeight
      } = e2.target;
      const bottom = Math.floor(scrollHeight - (scrollTop + offsetHeight));
      if (scrollTop > preScrollTop && bottom <= props.bottomOffset) {
        emit2("reachBottom");
      }
      emit2("scroll");
      preScrollTop = scrollTop;
    };
    onMounted(() => {
      if (listRef.value) {
        const {
          scrollTop,
          scrollHeight,
          offsetHeight
        } = listRef.value;
        if (scrollHeight <= scrollTop + offsetHeight) {
          emit2("reachBottom");
        }
      }
    });
    const {
      current,
      pageSize,
      handlePageChange,
      handlePageSizeChange
    } = usePagination(props, {
      emit: emit2
    });
    const getCurrentPageItems = (data) => {
      if (!props.paginationProps) {
        return data;
      }
      if (props.paginationProps && data.length > pageSize.value) {
        const startIndex = (current.value - 1) * pageSize.value;
        return data.slice(startIndex, startIndex + pageSize.value);
      }
      return data;
    };
    const renderGridItems = (data) => {
      let _slot2;
      if (!props.gridProps) {
        return null;
      }
      const currentPageItems = getCurrentPageItems(data);
      if (props.gridProps.span) {
        const items = [];
        const rowSize = 24 / props.gridProps.span;
        for (let i2 = 0; i2 < currentPageItems.length; i2 += rowSize) {
          let _slot;
          const nextIndex = i2 + rowSize;
          const rowIndex = Math.floor(i2 / rowSize);
          items.push(createVNode(Grid$2.Row, {
            "key": rowIndex,
            "class": `${prefixCls}-row`,
            "gutter": props.gridProps.gutter
          }, _isSlot$2(_slot = currentPageItems.slice(i2, nextIndex).map((item, index2) => {
            var _a2;
            return createVNode(Grid$2.Col, {
              "key": `${rowIndex}-${index2}`,
              "class": `${prefixCls}-col`,
              "span": (_a2 = props.gridProps) == null ? void 0 : _a2.span
            }, {
              default: () => {
                var _a22;
                return [isVNode$1(item) ? item : (_a22 = slots.item) == null ? void 0 : _a22.call(slots, {
                  item,
                  index: index2
                })];
              }
            });
          })) ? _slot : {
            default: () => [_slot]
          }));
        }
        return items;
      }
      return createVNode(Grid$2.Row, {
        "class": `${prefixCls}-row`,
        "gutter": props.gridProps.gutter
      }, _isSlot$2(_slot2 = currentPageItems.map((item, index2) => createVNode(Grid$2.Col, mergeProps({
        "key": index2,
        "class": `${prefixCls}-col`
      }, omit(props.gridProps, ["gutter"])), {
        default: () => {
          var _a2;
          return [isVNode$1(item) ? item : (_a2 = slots.item) == null ? void 0 : _a2.call(slots, {
            item,
            index: index2
          })];
        }
      }))) ? _slot2 : {
        default: () => [_slot2]
      });
    };
    const renderListItems = (data) => {
      const currentPageItems = getCurrentPageItems(data);
      return currentPageItems.map((item, index2) => {
        var _a2;
        return isVNode$1(item) ? item : (_a2 = slots.item) == null ? void 0 : _a2.call(slots, {
          item,
          index: index2
        });
      });
    };
    const renderItems = () => {
      const data = slots.default ? getAllElements(slots.default()) : props.data;
      if (data && data.length > 0) {
        return props.gridProps ? renderGridItems(data) : renderListItems(data);
      }
      return renderEmpty();
    };
    const renderPagination = () => {
      if (!props.paginationProps) {
        return null;
      }
      const paginationProps = omit(props.paginationProps, ["current", "pageSize", "defaultCurrent", "defaultPageSize"]);
      return createVNode(Pagination, mergeProps({
        "class": `${prefixCls}-pagination`
      }, paginationProps, {
        "current": current.value,
        "pageSize": pageSize.value,
        "onChange": handlePageChange,
        "onPageSizeChange": handlePageSizeChange
      }), null);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-${props.size}`, {
      [`${prefixCls}-bordered`]: props.bordered,
      [`${prefixCls}-split`]: props.split,
      [`${prefixCls}-hover`]: props.hoverable
    }]);
    const contentStyle = computed(() => {
      if (props.maxHeight > 0) {
        return {
          maxHeight: `${props.maxHeight}px`,
          overflowY: "auto"
        };
      }
      return void 0;
    });
    const contentCls = computed(() => [`${prefixCls}-content`, {
      [`${prefixCls}-virtual`]: isVirtualList.value
    }]);
    const virtualListRef = ref();
    const renderVirtualList = () => {
      var _a2;
      const currentPageItems = getCurrentPageItems((_a2 = props.data) != null ? _a2 : []);
      return currentPageItems.length ? createVNode(VirtualList, mergeProps({
        "ref": virtualListRef,
        "class": contentCls.value,
        "data": currentPageItems
      }, props.virtualListProps, {
        "onScroll": handleScroll2
      }), {
        item: ({
          item,
          index: index2
        }) => {
          var _a22;
          return (_a22 = slots.item) == null ? void 0 : _a22.call(slots, {
            item,
            index: index2
          });
        }
      }) : renderEmpty();
    };
    const renderScrollLoading = () => {
      if (slots["scroll-loading"]) {
        return createVNode("div", {
          "class": [`${prefixCls}-item`, `${prefixCls}-scroll-loading`]
        }, [slots["scroll-loading"]()]);
      }
      return null;
    };
    const renderEmpty = () => {
      var _a2, _b2;
      if (slots["scroll-loading"]) {
        return null;
      }
      return (_b2 = (_a2 = slots.empty) == null ? void 0 : _a2.call(slots)) != null ? _b2 : createVNode(Empty, null, null);
    };
    const render2 = () => {
      const Component = displayScrollbar.value ? Scrollbar : "div";
      return createVNode("div", {
        "class": `${prefixCls}-wrapper`
      }, [createVNode(Spin, {
        "class": `${prefixCls}-spin`,
        "loading": props.loading
      }, {
        default: () => [createVNode(Component, mergeProps({
          "ref": componentRef,
          "class": cls.value,
          "style": contentStyle.value
        }, scrollbarProps.value, {
          "onScroll": handleScroll2
        }), {
          default: () => [createVNode("div", {
            "class": `${prefixCls}-content-wrapper`
          }, [slots.header && createVNode("div", {
            "class": `${prefixCls}-header`
          }, [slots.header()]), isVirtualList.value && !props.gridProps ? createVNode(Fragment, null, [renderVirtualList(), renderScrollLoading()]) : createVNode("div", {
            "role": "list",
            "class": contentCls.value
          }, [renderItems(), renderScrollLoading()]), slots.footer && createVNode("div", {
            "class": `${prefixCls}-footer`
          }, [slots.footer()])])]
        }), renderPagination()]
      })]);
    };
    return {
      virtualListRef,
      render: render2
    };
  },
  methods: {
    scrollIntoView(options) {
      if (this.virtualListRef) {
        this.virtualListRef.scrollTo(options);
      }
    }
  },
  render() {
    return this.render();
  }
});
var ListItem = defineComponent({
  name: "ListItem",
  props: {
    actionLayout: {
      type: String,
      default: "horizontal"
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("list-item");
    const renderAction = () => {
      var _a2;
      const actions2 = (_a2 = slots.actions) == null ? void 0 : _a2.call(slots);
      if (!actions2 || !actions2.length) {
        return null;
      }
      return createVNode("ul", {
        "class": `${prefixCls}-action`
      }, [actions2.map((item, index2) => createVNode("li", {
        "key": `${prefixCls}-action-${index2}`
      }, [item]))]);
    };
    return () => {
      var _a2, _b2;
      return createVNode("div", {
        "role": "listitem",
        "class": prefixCls
      }, [createVNode("div", {
        "class": `${prefixCls}-main`
      }, [(_a2 = slots.meta) == null ? void 0 : _a2.call(slots), createVNode("div", {
        "class": `${prefixCls}-content`
      }, [(_b2 = slots.default) == null ? void 0 : _b2.call(slots)]), props.actionLayout === "vertical" && renderAction()]), props.actionLayout === "horizontal" && renderAction(), slots.extra && createVNode("div", {
        "class": `${prefixCls}-extra`
      }, [slots.extra()])]);
    };
  }
});
const _sfc_main$u = defineComponent({
  name: "ListItemMeta",
  props: {
    title: String,
    description: String
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("list-item-meta");
    const hasContent = Boolean(props.title || props.description || slots.title || slots.description);
    return {
      prefixCls,
      hasContent
    };
  }
});
function _sfc_render$m(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [_ctx.$slots.avatar ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-avatar`)
  }, [renderSlot(_ctx.$slots, "avatar")], 2)) : createCommentVNode("v-if", true), _ctx.hasContent ? (openBlock(), createElementBlock("div", {
    key: 1,
    class: normalizeClass(`${_ctx.prefixCls}-content`)
  }, [_ctx.$slots.title || _ctx.title ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-title`)
  }, [renderSlot(_ctx.$slots, "title", {}, () => [createTextVNode(toDisplayString$1(_ctx.title), 1)])], 2)) : createCommentVNode("v-if", true), _ctx.$slots.description || _ctx.description ? (openBlock(), createElementBlock("div", {
    key: 1,
    class: normalizeClass(`${_ctx.prefixCls}-description`)
  }, [renderSlot(_ctx.$slots, "description", {}, () => [createTextVNode(toDisplayString$1(_ctx.description), 1)])], 2)) : createCommentVNode("v-if", true)], 2)) : createCommentVNode("v-if", true)], 2);
}
var ListItemMeta = /* @__PURE__ */ _export_sfc$1(_sfc_main$u, [["render", _sfc_render$m]]);
const List = Object.assign(_List, {
  Item: Object.assign(ListItem, {
    Meta: ListItemMeta
  }),
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _List.name, _List);
    app.component(componentPrefix + ListItem.name, ListItem);
    app.component(componentPrefix + ListItemMeta.name, ListItemMeta);
  }
});
const MenuInjectionKey = Symbol("MenuInjectionKey");
const LevelInjectionKey = Symbol("LevelInjectionKey");
const DataCollectorInjectionKey = Symbol("DataCollectorInjectionKey");
const _sfc_main$t = defineComponent({
  name: "IconMenuFold",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-menu-fold`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$c = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$b = /* @__PURE__ */ createBaseVNode("path", {
  d: "M42 11H6M42 24H22M42 37H6M13.66 26.912l-4.82-3.118 4.82-3.118v6.236Z"
}, null, -1);
const _hoisted_3$a = [_hoisted_2$b];
function _sfc_render$l(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$a, 14, _hoisted_1$c);
}
var _IconMenuFold = /* @__PURE__ */ _export_sfc$1(_sfc_main$t, [["render", _sfc_render$l]]);
const IconMenuFold = Object.assign(_IconMenuFold, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconMenuFold.name, _IconMenuFold);
  }
});
const _sfc_main$s = defineComponent({
  name: "IconMenuUnfold",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-menu-unfold`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$b = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$a = /* @__PURE__ */ createBaseVNode("path", {
  d: "M6 11h36M22 24h20M6 37h36M8 20.882 12.819 24 8 27.118v-6.236Z"
}, null, -1);
const _hoisted_3$9 = [_hoisted_2$a];
function _sfc_render$k(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$9, 14, _hoisted_1$b);
}
var _IconMenuUnfold = /* @__PURE__ */ _export_sfc$1(_sfc_main$s, [["render", _sfc_render$k]]);
const IconMenuUnfold = Object.assign(_IconMenuUnfold, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconMenuUnfold.name, _IconMenuUnfold);
  }
});
function provideLevel(level) {
  const computedLevel = computed(() => isRef(level) ? level.value : level);
  provide(LevelInjectionKey, reactive({
    level: computedLevel
  }));
}
function useLevel(props) {
  const {
    provideNextLevel
  } = props || {};
  const levelContext = inject(LevelInjectionKey);
  const level = computed(() => (levelContext == null ? void 0 : levelContext.level) || 1);
  if (provideNextLevel) {
    const nextLevel = computed(() => level.value + 1);
    provideLevel(nextLevel);
  }
  return {
    level
  };
}
function getKeys(data, condition) {
  const keys2 = [];
  const loop = (list) => {
    list.forEach((item) => {
      if (condition(item)) {
        keys2.push(item.key);
      }
      if (item.children) {
        loop(item.children);
      }
    });
  };
  loop(data);
  return keys2;
}
function useMenuDataCollectorContext(isRoot = false) {
  const menuContext = isRoot ? void 0 : inject(DataCollectorInjectionKey);
  return menuContext;
}
function useMenuDataCollector(props) {
  const {
    key,
    type
  } = props;
  const data = ref([]);
  const menuContext = useMenuDataCollectorContext(type === "menu");
  const provideContext = {
    collectSubMenu(key2, children, isReport = false) {
      const item = {
        key: key2,
        children
      };
      if (isReport) {
        const oldOne = data.value.find((i2) => i2.key === key2);
        if (oldOne) {
          oldOne.children = children;
        } else {
          data.value.push(item);
        }
      } else {
        data.value = [...data.value, item];
      }
      if (isReport) {
        if (type === "popupMenu") {
          menuContext == null ? void 0 : menuContext.reportMenuData(data.value);
        } else if (type === "subMenu" && !isUndefined(key2)) {
          menuContext == null ? void 0 : menuContext.collectSubMenu(key2, data.value, true);
        }
      }
    },
    removeSubMenu(key2) {
      data.value = data.value.filter((item) => item.key !== key2);
    },
    collectMenuItem(key2) {
      data.value.push({
        key: key2
      });
    },
    removeMenuItem(key2) {
      data.value = data.value.filter((item) => item.key !== key2);
    },
    reportMenuData(reportData) {
      data.value = reportData;
      if (type === "subMenu" && !isUndefined(key)) {
        menuContext == null ? void 0 : menuContext.collectSubMenu(key, data.value, true);
      }
    }
  };
  provide(DataCollectorInjectionKey, provideContext);
  if (type === "subMenu" && !isUndefined(key)) {
    onMounted(() => {
      menuContext == null ? void 0 : menuContext.collectSubMenu(key, data.value);
    });
    onUnmounted(() => {
      menuContext == null ? void 0 : menuContext.removeSubMenu(key);
    });
  } else if (type === "popupMenu") {
    onMounted(() => {
      menuContext == null ? void 0 : menuContext.reportMenuData(data.value);
    });
  }
  return {
    menuData: data,
    subMenuKeys: computed(() => getKeys(data.value, (item) => !!item.children)),
    menuItemKeys: computed(() => getKeys(data.value, (item) => !item.children))
  };
}
function getPath(data, key) {
  const path = [];
  const loop = (list) => {
    for (let i2 = 0; i2 < list.length; i2++) {
      const item = list[i2];
      if (item.key === key) {
        return true;
      }
      if (item.children) {
        path.push(item.key);
        const matched = loop(item.children);
        if (matched) {
          return true;
        }
        path.pop();
      }
    }
    return false;
  };
  loop(data);
  return path;
}
function isSameKeys(keys1, keys2) {
  if (keys1.length !== keys2.length)
    return false;
  return keys1.toString() === keys2.toString();
}
function useMenuOpenState(props) {
  const {
    modelValue,
    defaultValue,
    autoOpen,
    autoOpenSelected,
    subMenuKeys,
    selectedKeys,
    menuData,
    accordion
  } = toRefs(props);
  const localValue = ref(!isUndefined(modelValue.value) ? modelValue.value : !isUndefined(defaultValue.value) ? defaultValue.value : []);
  const setLocalValue = (val) => {
    localValue.value = val;
  };
  watch(modelValue, () => {
    if (isUndefined(modelValue.value)) {
      setLocalValue([]);
    }
  });
  let mountedSubMenuKeys = [];
  onMounted(() => {
    mountedSubMenuKeys = [...subMenuKeys.value];
    let newOpenKeys = [];
    if (autoOpen.value) {
      newOpenKeys = accordion.value ? subMenuKeys.value.slice(0, 1) : [...subMenuKeys.value];
    }
    if (autoOpenSelected.value) {
      const pathList = selectedKeys.value.map((key) => getPath(menuData.value, key));
      if (pathList.length && (!autoOpen.value || accordion.value)) {
        newOpenKeys = accordion.value ? pathList[0] : [...new Set([].concat(...pathList))];
      }
    }
    if (newOpenKeys.length) {
      setLocalValue(newOpenKeys);
    }
  });
  let hasTriggered = false;
  watch(subMenuKeys, (currentKeys, prevKeys = []) => {
    if (hasTriggered || !isSameKeys(currentKeys, mountedSubMenuKeys)) {
      const newOpenKeys = openKeys.value.filter((key) => currentKeys.includes(key));
      if (autoOpen.value) {
        const keysAdded = currentKeys.filter((key) => !prevKeys.includes(key));
        newOpenKeys.push(...keysAdded);
      }
      setLocalValue(accordion.value ? newOpenKeys.slice(0, 1) : newOpenKeys);
    }
    hasTriggered = true;
  });
  const openKeys = computed(() => modelValue.value || localValue.value);
  return {
    openKeys,
    localOpenKeys: localValue,
    setOpenKeys: setLocalValue,
    open(key, level) {
      let newOpenKeys = [];
      if (openKeys.value.indexOf(key) > -1) {
        if (accordion.value && level === 1) {
          newOpenKeys = [];
        } else {
          newOpenKeys = openKeys.value.filter((i2) => i2 !== key);
        }
      } else if (accordion.value && level === 1) {
        newOpenKeys = [key];
      } else {
        newOpenKeys = openKeys.value.concat([key]);
      }
      setLocalValue(newOpenKeys);
      return newOpenKeys;
    }
  };
}
const _sfc_main$r = defineComponent({
  name: "BaseMenu",
  components: {
    IconMenuFold,
    IconMenuUnfold
  },
  inheritAttrs: false,
  props: {
    style: {
      type: Object
    },
    theme: {
      type: String,
      default: "light"
    },
    mode: {
      type: String,
      default: "vertical"
    },
    levelIndent: {
      type: Number
    },
    autoOpen: {
      type: Boolean
    },
    collapsed: {
      type: Boolean,
      default: void 0
    },
    defaultCollapsed: {
      type: Boolean
    },
    collapsedWidth: {
      type: Number
    },
    accordion: {
      type: Boolean
    },
    autoScrollIntoView: {
      type: Boolean
    },
    showCollapseButton: {
      type: Boolean
    },
    selectedKeys: {
      type: Array
    },
    defaultSelectedKeys: {
      type: Array,
      default: () => []
    },
    openKeys: {
      type: Array
    },
    defaultOpenKeys: {
      type: Array,
      default: () => []
    },
    scrollConfig: {
      type: Object
    },
    triggerProps: {
      type: Object
    },
    tooltipProps: {
      type: Object
    },
    autoOpenSelected: {
      type: Boolean
    },
    breakpoint: {
      type: String
    },
    popupMaxHeight: {
      type: [Boolean, Number],
      default: true
    },
    prefixCls: {
      type: String
    },
    inTrigger: {
      type: Boolean
    },
    siderCollapsed: {
      type: Boolean
    },
    isRoot: {
      type: Boolean
    }
  },
  emits: ["update:collapsed", "update:selectedKeys", "update:openKeys", "collapse", "menu-item-click", "sub-menu-click"],
  setup(props, {
    emit: emit2,
    slots
  }) {
    const {
      style: style2,
      mode,
      theme: theme2,
      levelIndent,
      accordion,
      showCollapseButton,
      scrollConfig,
      autoScrollIntoView,
      collapsedWidth,
      autoOpen,
      collapsed: propCollapsed,
      defaultCollapsed,
      selectedKeys: propSelectedKeys,
      defaultSelectedKeys,
      openKeys: propOpenKeys,
      defaultOpenKeys,
      triggerProps,
      tooltipProps,
      autoOpenSelected,
      breakpoint,
      popupMaxHeight,
      prefixCls,
      inTrigger,
      siderCollapsed,
      isRoot
    } = toRefs(props);
    const {
      subMenuKeys,
      menuData
    } = useMenuDataCollector({
      type: isRoot.value ? "menu" : "popupMenu"
    });
    const [selectedKeys, setSelectedKeys] = useMergeState(defaultSelectedKeys.value, reactive({
      value: propSelectedKeys
    }));
    const {
      openKeys,
      setOpenKeys,
      open
    } = useMenuOpenState(reactive({
      modelValue: propOpenKeys,
      defaultValue: defaultOpenKeys,
      autoOpen,
      autoOpenSelected,
      selectedKeys,
      subMenuKeys,
      menuData,
      accordion
    }));
    const [collapsed, setCollapsed] = useMergeState(defaultCollapsed.value, reactive({
      value: propCollapsed
    }));
    const computedCollapsed = computed(() => siderCollapsed.value || collapsed.value || mode.value === "popButton");
    const computedHasCollapseButton = computed(() => ["horizontal", "popButton"].indexOf(mode.value) < 0 && !inTrigger.value && showCollapseButton.value);
    const changeCollapsed = (newVal, type) => {
      if (newVal === collapsed.value)
        return;
      setCollapsed(newVal);
      emit2("update:collapsed", newVal);
      emit2("collapse", newVal, type);
    };
    const onCollapseBtnClick = () => {
      changeCollapsed(!collapsed.value, "clickTrigger");
    };
    useResponsive(breakpoint, (checked) => {
      changeCollapsed(!checked, "responsive");
    });
    const computedPrefixCls = computed(() => (prefixCls == null ? void 0 : prefixCls.value) || getPrefixCls("menu"));
    const classNames = computed(() => [computedPrefixCls.value, `${computedPrefixCls.value}-${theme2 == null ? void 0 : theme2.value}`, {
      [`${computedPrefixCls.value}-horizontal`]: mode.value === "horizontal",
      [`${computedPrefixCls.value}-vertical`]: mode.value !== "horizontal",
      [`${computedPrefixCls.value}-collapsed`]: computedCollapsed.value,
      [`${computedPrefixCls.value}-pop`]: mode.value === "pop" || computedCollapsed.value,
      [`${computedPrefixCls.value}-pop-button`]: mode.value === "popButton"
    }]);
    const computedStyle = computed(() => {
      const pxCollapsedWidth = isNumber$2(collapsedWidth.value) ? `${collapsedWidth.value}px` : void 0;
      const objectStyle = isObject$5(style2.value) ? style2.value : void 0;
      const width = computedCollapsed.value ? pxCollapsedWidth : objectStyle == null ? void 0 : objectStyle.width;
      return [objectStyle ? omit(objectStyle, ["width"]) : style2.value, {
        width
      }];
    });
    const expandIconDown = usePickSlots(slots, "expand-icon-down");
    const expandIconRight = usePickSlots(slots, "expand-icon-right");
    const menuContext = reactive({
      theme: theme2,
      mode,
      levelIndent,
      autoScrollIntoView,
      selectedKeys,
      openKeys,
      prefixCls: computedPrefixCls,
      scrollConfig,
      inTrigger,
      collapsed: computedCollapsed,
      triggerProps,
      tooltipProps,
      popupMaxHeight,
      expandIconDown,
      expandIconRight,
      onMenuItemClick: (key) => {
        setSelectedKeys([key]);
        emit2("update:selectedKeys", [key]);
        emit2("menu-item-click", key);
      },
      onSubMenuClick: (key, level) => {
        const newOpenKeys = open(key, level);
        setOpenKeys(newOpenKeys);
        emit2("update:openKeys", newOpenKeys);
        emit2("sub-menu-click", key, newOpenKeys);
      }
    });
    provide(MenuInjectionKey, menuContext);
    provideLevel(1);
    return {
      computedPrefixCls,
      classNames,
      computedStyle,
      computedCollapsed,
      computedHasCollapseButton,
      onCollapseBtnClick
    };
  }
});
function _sfc_render$j(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconMenuUnfold = resolveComponent("IconMenuUnfold");
  const _component_IconMenuFold = resolveComponent("IconMenuFold");
  return openBlock(), createElementBlock("div", mergeProps({
    class: _ctx.classNames
  }, _ctx.$attrs, {
    style: _ctx.computedStyle
  }), [createBaseVNode("div", {
    class: normalizeClass(`${_ctx.computedPrefixCls}-inner`)
  }, [renderSlot(_ctx.$slots, "default")], 2), _ctx.computedHasCollapseButton ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass(`${_ctx.computedPrefixCls}-collapse-button`),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onCollapseBtnClick && _ctx.onCollapseBtnClick(...args))
  }, [renderSlot(_ctx.$slots, "collapse-icon", {
    collapsed: _ctx.computedCollapsed
  }, () => [_ctx.computedCollapsed ? (openBlock(), createBlock(_component_IconMenuUnfold, {
    key: 0
  })) : (openBlock(), createBlock(_component_IconMenuFold, {
    key: 1
  }))])], 2)) : createCommentVNode("v-if", true)], 16);
}
var BaseMenu = /* @__PURE__ */ _export_sfc$1(_sfc_main$r, [["render", _sfc_render$j]]);
function getStyle$1(element, prop) {
  if (!element || !prop)
    return null;
  let styleName = prop;
  if (styleName === "float") {
    styleName = "cssFloat";
  }
  try {
    if (document.defaultView) {
      const computed2 = document.defaultView.getComputedStyle(element, "");
      return element.style[styleName] || computed2 ? computed2[styleName] : "";
    }
  } catch (e2) {
    return element.style[styleName];
  }
  return null;
}
function useMenuContext() {
  const menuContext = inject(MenuInjectionKey);
  return menuContext || {};
}
const generateId = (() => {
  let i2 = 0;
  return (prefix = "") => {
    i2 += 1;
    return `${prefix}${i2}`;
  };
})();
function useMenu() {
  const instance = getCurrentInstance();
  const key = computed(() => (instance == null ? void 0 : instance.vnode.key) || generateId("__arco_menu"));
  return {
    key
  };
}
const _sfc_main$q = defineComponent({
  name: "MenuIndent",
  props: {
    level: {
      type: Number,
      default: 1
    }
  },
  setup() {
    const prefixCls = getPrefixCls("menu");
    const menuContext = useMenuContext();
    return {
      prefixCls,
      levelIndent: toRef(menuContext, "levelIndent")
    };
  }
});
function _sfc_render$i(_ctx, _cache, $props, $setup, $data, $options) {
  return _ctx.level > 1 ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-indent-list`)
  }, [(openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.level - 1, (index2) => {
    return openBlock(), createElementBlock("span", {
      key: index2,
      class: normalizeClass(`${_ctx.prefixCls}-indent`),
      style: normalizeStyle$1(`width: ${_ctx.levelIndent}px`)
    }, null, 6);
  }), 128))], 2)) : createCommentVNode("v-if", true);
}
var MenuIndent = /* @__PURE__ */ _export_sfc$1(_sfc_main$q, [["render", _sfc_render$i]]);
const _sfc_main$p = defineComponent({
  name: "ExpandTransition",
  setup() {
    return {
      onBeforeEnter(el) {
        el.style.height = "0";
      },
      onEnter(el) {
        el.style.height = `${el.scrollHeight}px`;
      },
      onAfterEnter(el) {
        el.style.height = "";
      },
      onBeforeLeave(el) {
        el.style.height = `${el.scrollHeight}px`;
      },
      onLeave(el) {
        el.style.height = `0`;
      },
      onAfterLeave(el) {
        el.style.height = ``;
      }
    };
  }
});
function _sfc_render$h(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(Transition, {
    onBeforeEnter: _ctx.onBeforeEnter,
    onEnter: _ctx.onEnter,
    onAfterEnter: _ctx.onAfterEnter,
    onBeforeLeave: _ctx.onBeforeLeave,
    onLeave: _ctx.onLeave,
    onAfterLeave: _ctx.onAfterLeave
  }, {
    default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
    _: 3
  }, 8, ["onBeforeEnter", "onEnter", "onAfterEnter", "onBeforeLeave", "onLeave", "onAfterLeave"]);
}
var ExpandTransition = /* @__PURE__ */ _export_sfc$1(_sfc_main$p, [["render", _sfc_render$h]]);
const _sfc_main$o = defineComponent({
  name: "SubMenuInline",
  components: {
    MenuIndent,
    ExpandTransition
  },
  props: {
    title: {
      type: String
    },
    isChildrenSelected: {
      type: Boolean
    }
  },
  setup(props) {
    const {
      key
    } = useMenu();
    const {
      level
    } = useLevel({
      provideNextLevel: true
    });
    const menuContext = useMenuContext();
    const menuPrefixCls = computed(() => menuContext.prefixCls);
    const prefixCls = computed(() => `${menuPrefixCls.value}-inline`);
    const classNames = computed(() => [prefixCls.value]);
    const isSelected = computed(() => props.isChildrenSelected);
    const isOpen = computed(() => (menuContext.openKeys || []).indexOf(key.value) > -1);
    return {
      prefixCls,
      menuPrefixCls,
      classNames,
      level,
      isSelected,
      isOpen,
      onHeaderClick: () => {
        menuContext.onSubMenuClick && menuContext.onSubMenuClick(key.value, level.value);
      }
    };
  }
});
function _sfc_render$g(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_MenuIndent = resolveComponent("MenuIndent");
  const _component_ExpandTransition = resolveComponent("ExpandTransition");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [createBaseVNode("div", {
    class: normalizeClass([`${_ctx.prefixCls}-header`, {
      [`${_ctx.menuPrefixCls}-selected`]: _ctx.isSelected,
      [`${_ctx.menuPrefixCls}-has-icon`]: _ctx.$slots.icon
    }]),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onHeaderClick && _ctx.onHeaderClick(...args))
  }, [createVNode(_component_MenuIndent, {
    level: _ctx.level
  }, null, 8, ["level"]), _ctx.$slots.icon ? (openBlock(), createElementBlock(Fragment, {
    key: 0
  }, [createBaseVNode("span", {
    class: normalizeClass(`${_ctx.menuPrefixCls}-icon`)
  }, [renderSlot(_ctx.$slots, "icon")], 2), createBaseVNode("span", {
    class: normalizeClass(`${_ctx.menuPrefixCls}-title`)
  }, [renderSlot(_ctx.$slots, "title", {}, () => [createTextVNode(toDisplayString$1(_ctx.title), 1)])], 2)], 64)) : renderSlot(_ctx.$slots, "title", {
    key: 1
  }, () => [createTextVNode(toDisplayString$1(_ctx.title), 1)]), createBaseVNode("span", {
    class: normalizeClass([`${_ctx.menuPrefixCls}-icon-suffix`, {
      [`is-open`]: _ctx.isOpen
    }])
  }, [renderSlot(_ctx.$slots, "expand-icon-down")], 2)], 2), createVNode(_component_ExpandTransition, null, {
    default: withCtx(() => [withDirectives(createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-content`)
    }, [renderSlot(_ctx.$slots, "default")], 2), [[vShow, _ctx.isOpen]])]),
    _: 3
  })], 2);
}
var SubMenuInline = /* @__PURE__ */ _export_sfc$1(_sfc_main$o, [["render", _sfc_render$g]]);
const _sfc_main$n = defineComponent({
  name: "SubMenuPop",
  components: {
    Menu: BaseMenu,
    Trigger,
    MenuIndent,
    RenderFunction
  },
  inheritAttrs: false,
  props: {
    title: {
      type: String
    },
    selectable: {
      type: Boolean
    },
    isChildrenSelected: {
      type: Boolean
    },
    popupMaxHeight: {
      type: [Boolean, Number],
      default: void 0
    }
  },
  setup(props) {
    const {
      key
    } = useMenu();
    const {
      level
    } = useLevel();
    const {
      selectable,
      isChildrenSelected,
      popupMaxHeight
    } = toRefs(props);
    const menuContext = useMenuContext();
    const {
      onSubMenuClick,
      onMenuItemClick
    } = menuContext;
    const menuPrefixCls = computed(() => menuContext.prefixCls);
    const mode = computed(() => menuContext.mode);
    const selectedKeys = computed(() => menuContext.selectedKeys || []);
    const prefixCls = computed(() => `${menuPrefixCls.value}-pop`);
    const isSelected = computed(() => selectable.value && selectedKeys.value.includes(key.value) || isChildrenSelected.value);
    const classNames = computed(() => [`${prefixCls.value}`, `${prefixCls.value}-header`, {
      [`${menuPrefixCls.value}-selected`]: isSelected.value
    }]);
    const needPopOnBottom = computed(() => mode.value === "horizontal" && !menuContext.inTrigger);
    const popVisible = ref(false);
    const setPopVisible = (val) => {
      popVisible.value = val;
    };
    const triggerPrefixCls = getPrefixCls("trigger");
    const triggerClassNames = computed(() => {
      var _a2;
      return [`${prefixCls.value}-trigger`, {
        [`${prefixCls.value}-trigger-dark`]: menuContext.theme === "dark"
      }, (_a2 = menuContext.triggerProps) == null ? void 0 : _a2.class];
    });
    const triggerProps = computed(() => omit(menuContext.triggerProps || {}, ["class"]));
    return {
      menuPrefixCls,
      mode,
      level,
      classNames,
      isSelected,
      selectedKeys,
      needPopOnBottom,
      popVisible,
      triggerPrefixCls,
      triggerClassNames,
      triggerProps,
      menuContext,
      popupMenuStyles: computed(() => {
        var _a2;
        const maxHeight = (_a2 = popupMaxHeight.value) != null ? _a2 : menuContext.popupMaxHeight;
        if (isNumber$2(maxHeight))
          return {
            maxHeight: `${maxHeight}px`
          };
        return maxHeight ? {} : {
          maxHeight: "unset"
        };
      }),
      onClick: () => {
        onSubMenuClick && onSubMenuClick(key.value, level.value);
        selectable.value && onMenuItemClick && onMenuItemClick(key.value);
      },
      onMenuItemClick: (key2) => {
        onMenuItemClick && onMenuItemClick(key2);
        setPopVisible(false);
      },
      onVisibleChange: (visible) => {
        setPopVisible(visible);
      }
    };
  }
});
function _sfc_render$f(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_MenuIndent = resolveComponent("MenuIndent");
  const _component_RenderFunction = resolveComponent("RenderFunction");
  const _component_Menu = resolveComponent("Menu");
  const _component_Trigger = resolveComponent("Trigger");
  return openBlock(), createBlock(_component_Trigger, mergeProps({
    trigger: "hover",
    class: _ctx.triggerClassNames,
    position: _ctx.needPopOnBottom ? "bl" : "rt",
    "show-arrow": "",
    "animation-class": "fade-in",
    "mouse-enter-delay": 50,
    "mouse-leave-delay": 50,
    "popup-offset": 4,
    "auto-fit-popup-min-width": true,
    duration: 100
  }, _ctx.triggerProps, {
    "unmount-on-close": false,
    "popup-visible": _ctx.popVisible,
    onPopupVisibleChange: _ctx.onVisibleChange
  }), {
    content: withCtx(() => [createVNode(_component_Menu, {
      "in-trigger": "",
      "prefix-cls": `${_ctx.triggerPrefixCls}-menu`,
      "selected-keys": _ctx.selectedKeys,
      theme: _ctx.menuContext.theme,
      "trigger-props": _ctx.menuContext.triggerProps,
      style: normalizeStyle$1(_ctx.popupMenuStyles),
      onMenuItemClick: _ctx.onMenuItemClick
    }, createSlots({
      default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
      _: 2
    }, [_ctx.menuContext.expandIconDown ? {
      name: "expand-icon-down",
      fn: withCtx(() => [createVNode(_component_RenderFunction, {
        "render-func": _ctx.menuContext.expandIconDown
      }, null, 8, ["render-func"])])
    } : void 0, _ctx.menuContext.expandIconRight ? {
      name: "expand-icon-right",
      fn: withCtx(() => [createVNode(_component_RenderFunction, {
        "render-func": _ctx.menuContext.expandIconRight
      }, null, 8, ["render-func"])])
    } : void 0]), 1032, ["prefix-cls", "selected-keys", "theme", "trigger-props", "style", "onMenuItemClick"])]),
    default: withCtx(() => [createBaseVNode("div", mergeProps({
      class: [_ctx.classNames, {
        [`${_ctx.menuPrefixCls}-has-icon`]: _ctx.$slots.icon
      }],
      "aria-haspopup": "true"
    }, _ctx.$attrs, {
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
    }), [createCommentVNode(" header "), createVNode(_component_MenuIndent, {
      level: _ctx.level
    }, null, 8, ["level"]), _ctx.$slots.icon ? (openBlock(), createElementBlock(Fragment, {
      key: 0
    }, [createBaseVNode("span", {
      class: normalizeClass(`${_ctx.menuPrefixCls}-icon`)
    }, [renderSlot(_ctx.$slots, "icon")], 2), createBaseVNode("span", {
      class: normalizeClass(`${_ctx.menuPrefixCls}-title`)
    }, [renderSlot(_ctx.$slots, "title", {}, () => [createTextVNode(toDisplayString$1(_ctx.title), 1)])], 2)], 64)) : renderSlot(_ctx.$slots, "title", {
      key: 1
    }, () => [createTextVNode(toDisplayString$1(_ctx.title), 1)]), createCommentVNode(" suffix "), createBaseVNode("span", {
      class: normalizeClass(`${_ctx.menuPrefixCls}-icon-suffix`)
    }, [_ctx.needPopOnBottom ? renderSlot(_ctx.$slots, "expand-icon-down", {
      key: 0
    }) : renderSlot(_ctx.$slots, "expand-icon-right", {
      key: 1
    })], 2), _ctx.isSelected && _ctx.mode === "horizontal" ? (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass(`${_ctx.menuPrefixCls}-selected-label`)
    }, null, 2)) : createCommentVNode("v-if", true)], 16)]),
    _: 3
  }, 16, ["class", "position", "popup-visible", "onPopupVisibleChange"]);
}
var SubMenuPop = /* @__PURE__ */ _export_sfc$1(_sfc_main$n, [["render", _sfc_render$f]]);
var __defProp$4 = Object.defineProperty;
var __defProps$3 = Object.defineProperties;
var __getOwnPropDescs$3 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$4 = Object.getOwnPropertySymbols;
var __hasOwnProp$4 = Object.prototype.hasOwnProperty;
var __propIsEnum$4 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$4 = (obj, key, value) => key in obj ? __defProp$4(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$4 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$4.call(b2, prop))
      __defNormalProp$4(a, prop, b2[prop]);
  if (__getOwnPropSymbols$4)
    for (var prop of __getOwnPropSymbols$4(b2)) {
      if (__propIsEnum$4.call(b2, prop))
        __defNormalProp$4(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$3 = (a, b2) => __defProps$3(a, __getOwnPropDescs$3(b2));
var SubMenu = defineComponent({
  name: "SubMenu",
  props: {
    key: {
      type: String
    },
    title: {
      type: String
    },
    selectable: {
      type: Boolean
    },
    popup: {
      type: [Boolean, Function],
      default: false
    },
    popupMaxHeight: {
      type: [Boolean, Number],
      default: void 0
    }
  },
  setup(props, {
    attrs
  }) {
    const {
      key
    } = useMenu();
    const {
      level
    } = useLevel();
    const {
      popup
    } = toRefs(props);
    const menuContext = useMenuContext();
    const computedPopup = computed(() => {
      const {
        mode,
        collapsed,
        inTrigger
      } = menuContext;
      const forcePopup = !!(typeof popup.value === "function" ? popup.value(level.value) : popup.value);
      return forcePopup || collapsed || inTrigger || mode !== "vertical";
    });
    const {
      subMenuKeys,
      menuItemKeys
    } = useMenuDataCollector({
      key: key.value,
      type: "subMenu"
    });
    const isChildrenSelected = computed(() => {
      const selectedKeys = menuContext.selectedKeys || [];
      const checkSelected = (menuKeys) => {
        for (let i2 = 0; i2 < selectedKeys.length; i2++) {
          const selectedKey = selectedKeys[i2];
          if (menuKeys.includes(selectedKey)) {
            return true;
          }
        }
        return false;
      };
      return checkSelected(subMenuKeys.value) || checkSelected(menuItemKeys.value);
    });
    return {
      subMenuKeys,
      menuItemKeys,
      isChildrenSelected,
      props,
      attrs,
      computedKey: key,
      computedPopup,
      expandIconDown: toRef(menuContext, "expandIconDown"),
      expandIconRight: toRef(menuContext, "expandIconRight")
    };
  },
  render() {
    const {
      props,
      attrs,
      computedKey,
      computedPopup,
      expandIconDown,
      expandIconRight,
      isChildrenSelected
    } = this;
    const _slots = __spreadProps$3(__spreadValues$4({}, this.$slots), {
      "expand-icon-down": this.$slots["expand-icon-down"] || expandIconDown || (() => [createVNode(IconDown, null, null)]),
      "expand-icon-right": this.$slots["expand-icon-right"] || expandIconRight || (() => [createVNode(IconRight, null, null)])
    });
    return computedPopup ? createVNode(SubMenuPop, mergeProps({
      "key": computedKey,
      "title": props.title,
      "selectable": props.selectable,
      "isChildrenSelected": isChildrenSelected,
      "popupMaxHeight": props.popupMaxHeight
    }, attrs), _slots) : createVNode(SubMenuInline, mergeProps({
      "key": computedKey,
      "title": props.title,
      "isChildrenSelected": isChildrenSelected
    }, attrs), _slots);
  }
});
const OVERFLOW_THRESHOLD = 10;
function getNodeWidth(el) {
  return el && +el.getBoundingClientRect().width.toFixed(2);
}
function translatePxToNumber(str) {
  const result = Number(str.replace("px", ""));
  return Number.isNaN(result) ? 0 : result;
}
var OverflowWrap = defineComponent({
  name: "MenuOverflowWrap",
  setup(_2, {
    slots
  }) {
    const menuContext = useMenuContext();
    const overflowPrefixCls = `${menuContext.prefixCls}-overflow`;
    const overflowSubMenuClass = `${overflowPrefixCls}-sub-menu`;
    const overflowMenuItemClass = `${overflowPrefixCls}-hidden-menu-item`;
    const overflowSubMenuMirrorClass = `${overflowPrefixCls}-sub-menu-mirror`;
    const refWrapper = ref();
    const lastVisibleIndex = ref(null);
    const refResizeObserver = ref();
    function computeLastVisibleIndex() {
      const wrapperElement = refWrapper.value;
      const wrapperWidth = getNodeWidth(wrapperElement);
      const childNodeList = [].slice.call(wrapperElement.children);
      let menuItemIndex = 0;
      let currentRightWidth = 0;
      let overflowSubMenuWidth = 0;
      for (let i2 = 0; i2 < childNodeList.length; i2++) {
        const node = childNodeList[i2];
        const classNames = node.className.split(" ");
        const isOverflowSubMenu = classNames.indexOf(overflowSubMenuClass) > -1;
        const isOverflowSubMenuMirror = classNames.indexOf(overflowSubMenuMirrorClass) > -1;
        if (isOverflowSubMenu) {
          continue;
        }
        const nodeWidth = getNodeWidth(node) + translatePxToNumber(getStyle$1(node, "marginLeft")) + translatePxToNumber(getStyle$1(node, "marginRight"));
        if (isOverflowSubMenuMirror) {
          overflowSubMenuWidth = nodeWidth;
          continue;
        }
        currentRightWidth += nodeWidth;
        if (currentRightWidth + overflowSubMenuWidth + OVERFLOW_THRESHOLD > wrapperWidth) {
          lastVisibleIndex.value = menuItemIndex - 1;
          return;
        }
        menuItemIndex++;
      }
      lastVisibleIndex.value = null;
    }
    onMounted(() => {
      computeLastVisibleIndex();
      refResizeObserver.value = new index$t((entries) => {
        entries.forEach(computeLastVisibleIndex);
      });
      if (refWrapper.value) {
        refResizeObserver.value.observe(refWrapper.value);
      }
    });
    onUnmounted(() => {
      refResizeObserver.value && refResizeObserver.value.disconnect();
    });
    return () => {
      const renderSubMenu = (children, options) => {
        const {
          isMirror = false,
          props = {}
        } = options || {};
        return createVNode(SubMenu, mergeProps({
          "key": `__arco-menu-overflow-sub-menu${isMirror ? "-mirror" : ""}`,
          "class": isMirror ? overflowSubMenuMirrorClass : overflowSubMenuClass
        }, props), {
          title: () => createVNode("span", null, [createTextVNode("...")]),
          default: () => children
        });
      };
      const renderChildren = () => {
        var _a2;
        const originChildren = ((_a2 = slots.default) == null ? void 0 : _a2.call(slots)) || [];
        const children = unFragment(originChildren);
        let overflowSubMenu = null;
        const overflowSubMenuMirror = renderSubMenu(null, {
          isMirror: true
        });
        const menuItems = children.map((child, index2) => {
          const item = cloneVNode(child, lastVisibleIndex.value !== null && index2 > lastVisibleIndex.value ? {
            class: overflowMenuItemClass
          } : {
            class: ""
          });
          if (lastVisibleIndex.value !== null && index2 === lastVisibleIndex.value + 1) {
            const overflowMenuItems = children.slice(index2).map((child2) => cloneVNode(child2));
            overflowSubMenu = renderSubMenu(overflowMenuItems);
          }
          return item;
        });
        return [overflowSubMenuMirror, ...menuItems, overflowSubMenu];
      };
      return createVNode("div", {
        "class": `${overflowPrefixCls}-wrap`,
        "ref": refWrapper
      }, [renderChildren()]);
    };
  }
});
var __defProp$3 = Object.defineProperty;
var __defProps$2 = Object.defineProperties;
var __getOwnPropDescs$2 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$3 = Object.getOwnPropertySymbols;
var __hasOwnProp$3 = Object.prototype.hasOwnProperty;
var __propIsEnum$3 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$3 = (obj, key, value) => key in obj ? __defProp$3(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$3 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$3.call(b2, prop))
      __defNormalProp$3(a, prop, b2[prop]);
  if (__getOwnPropSymbols$3)
    for (var prop of __getOwnPropSymbols$3(b2)) {
      if (__propIsEnum$3.call(b2, prop))
        __defNormalProp$3(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$2 = (a, b2) => __defProps$2(a, __getOwnPropDescs$2(b2));
var _Menu = defineComponent({
  name: "Menu",
  components: {
    BaseMenu
  },
  inheritAttrs: false,
  props: {
    theme: {
      type: String
    },
    mode: {
      type: String,
      default: "vertical"
    }
  },
  setup(props, {
    attrs,
    slots
  }) {
    const {
      theme: propTheme,
      mode
    } = toRefs(props);
    const siderContext = inject(SiderInjectionKey, void 0);
    const siderCollapsed = computed(() => (siderContext == null ? void 0 : siderContext.collapsed) || false);
    const theme2 = computed(() => (propTheme == null ? void 0 : propTheme.value) || (siderContext == null ? void 0 : siderContext.theme) || "light");
    provide(MenuInjectionKey, void 0);
    provide(LevelInjectionKey, void 0);
    return () => createVNode(BaseMenu, mergeProps(props, attrs, {
      "theme": theme2.value,
      "inTrigger": false,
      "siderCollapsed": siderCollapsed.value,
      "isRoot": true
    }), __spreadProps$2(__spreadValues$3({}, slots), {
      default: mode.value === "horizontal" && slots.default ? () => createVNode(OverflowWrap, null, {
        default: () => {
          var _a2;
          return [(_a2 = slots.default) == null ? void 0 : _a2.call(slots)];
        }
      }) : slots.default
    }));
  }
});
function isOptionsObject(options) {
  return options === Object(options) && Object.keys(options).length !== 0;
}
function defaultBehavior(actions2, behavior) {
  if (behavior === void 0) {
    behavior = "auto";
  }
  var canSmoothScroll = "scrollBehavior" in document.body.style;
  actions2.forEach(function(_ref) {
    var el = _ref.el, top = _ref.top, left = _ref.left;
    if (el.scroll && canSmoothScroll) {
      el.scroll({
        top,
        left,
        behavior
      });
    } else {
      el.scrollTop = top;
      el.scrollLeft = left;
    }
  });
}
function getOptions(options) {
  if (options === false) {
    return {
      block: "end",
      inline: "nearest"
    };
  }
  if (isOptionsObject(options)) {
    return options;
  }
  return {
    block: "start",
    inline: "nearest"
  };
}
function scrollIntoView(target2, options) {
  var isTargetAttached = target2.isConnected || target2.ownerDocument.documentElement.contains(target2);
  if (isOptionsObject(options) && typeof options.behavior === "function") {
    return options.behavior(isTargetAttached ? i(target2, options) : []);
  }
  if (!isTargetAttached) {
    return;
  }
  var computeOptions = getOptions(options);
  return defaultBehavior(i(target2, computeOptions), computeOptions.behavior);
}
var __defProp$2 = Object.defineProperty;
var __getOwnPropSymbols$2 = Object.getOwnPropertySymbols;
var __hasOwnProp$2 = Object.prototype.hasOwnProperty;
var __propIsEnum$2 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2 = (obj, key, value) => key in obj ? __defProp$2(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$2 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$2.call(b2, prop))
      __defNormalProp$2(a, prop, b2[prop]);
  if (__getOwnPropSymbols$2)
    for (var prop of __getOwnPropSymbols$2(b2)) {
      if (__propIsEnum$2.call(b2, prop))
        __defNormalProp$2(a, prop, b2[prop]);
    }
  return a;
};
var MenuItem = defineComponent({
  name: "MenuItem",
  inheritAttrs: false,
  props: {
    key: {
      type: String
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  emits: ["click"],
  setup(props, {
    emit: emit2
  }) {
    const {
      key
    } = useMenu();
    const {
      level
    } = useLevel();
    const menuContext = useMenuContext();
    const refItemElement = ref();
    const isSelected = computed(() => (menuContext.selectedKeys || []).indexOf(key.value) > -1);
    const menuDataCollector = useMenuDataCollectorContext();
    onMounted(() => {
      menuDataCollector == null ? void 0 : menuDataCollector.collectMenuItem(key.value);
    });
    onUnmounted(() => {
      menuDataCollector == null ? void 0 : menuDataCollector.removeMenuItem(key.value);
    });
    function scrollTo() {
      if (menuContext.autoScrollIntoView && refItemElement.value && isSelected.value) {
        scrollIntoView(refItemElement.value, __spreadValues$2({
          behavior: "smooth",
          block: "nearest",
          scrollMode: "if-needed",
          boundary: document.documentElement
        }, menuContext.scrollConfig || {}));
      }
    }
    let timer;
    onMounted(() => {
      timer = setTimeout(() => {
        scrollTo();
      }, 500);
    });
    onUnmounted(() => {
      clearTimeout(timer);
    });
    watch([isSelected], () => {
      scrollTo();
    });
    return {
      menuContext,
      level,
      isSelected,
      refItemElement,
      onClick(e2) {
        if (props.disabled)
          return;
        menuContext.onMenuItemClick && menuContext.onMenuItemClick(key.value);
        emit2("click", e2);
      }
    };
  },
  render() {
    var _a2, _b2;
    const {
      level,
      menuContext,
      disabled,
      isSelected,
      onClick
    } = this;
    const {
      prefixCls,
      collapsed,
      inTrigger,
      mode,
      tooltipProps
    } = menuContext;
    const needTooltip = collapsed && !inTrigger && level === 1;
    const needTextIndent = mode === "vertical" && level > 1;
    const children = ((_b2 = (_a2 = this.$slots).default) == null ? void 0 : _b2.call(_a2)) || [];
    const showIndent = needTextIndent && !inTrigger && !collapsed;
    const iconElement = this.$slots.icon && this.$slots.icon();
    const content = [showIndent && createVNode(MenuIndent, {
      "level": level
    }, null), iconElement && createVNode("span", {
      "class": `${prefixCls}-icon`
    }, [iconElement]), showIndent || iconElement ? createVNode("span", {
      "class": [`${prefixCls}-item-inner`, {
        [`${prefixCls}-title`]: iconElement
      }]
    }, [children]) : children].filter(Boolean);
    const itemElement = createVNode("div", mergeProps({
      "ref": "refItemElement",
      "class": [`${prefixCls}-item`, {
        [`${prefixCls}-disabled`]: disabled,
        [`${prefixCls}-selected`]: isSelected,
        [`${prefixCls}-has-icon`]: iconElement
      }]
    }, this.$attrs, {
      "onClick": onClick
    }), [content, isSelected && mode === "horizontal" && createVNode("div", {
      "class": `${prefixCls}-selected-label`
    }, null)]);
    if (needTooltip) {
      const tooltipClassNames = [`${prefixCls}-item-tooltip`, tooltipProps == null ? void 0 : tooltipProps.class];
      return createVNode(Tooltip, mergeProps({
        "trigger": "hover",
        "position": "right",
        "class": tooltipClassNames
      }, omit(tooltipProps || {}, ["class"])), {
        default: () => itemElement,
        content: () => children
      });
    }
    return itemElement;
  }
});
const _sfc_main$m = defineComponent({
  name: "MenuItemGroup",
  components: {
    MenuIndent
  },
  props: {
    title: {
      type: String
    }
  },
  setup() {
    const {
      level
    } = useLevel();
    const nextLevel = computed(() => level.value === 1 ? level.value + 1 : level.value);
    provideLevel(nextLevel);
    const menuContext = useMenuContext();
    const prefixCls = computed(() => menuContext.prefixCls);
    const classNames = computed(() => [`${prefixCls.value}-group`]);
    return {
      prefixCls,
      classNames,
      level
    };
  }
});
function _sfc_render$e(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_MenuIndent = resolveComponent("MenuIndent");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [createBaseVNode("div", {
    class: normalizeClass(`${_ctx.prefixCls}-group-title`)
  }, [createVNode(_component_MenuIndent, {
    level: _ctx.level
  }, null, 8, ["level"]), renderSlot(_ctx.$slots, "title", {}, () => [createTextVNode(toDisplayString$1(_ctx.title), 1)])], 2), renderSlot(_ctx.$slots, "default")], 2);
}
var MenuItemGroup = /* @__PURE__ */ _export_sfc$1(_sfc_main$m, [["render", _sfc_render$e]]);
const Menu = Object.assign(_Menu, {
  Item: MenuItem,
  ItemGroup: MenuItemGroup,
  SubMenu,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Menu.name, _Menu);
    app.component(componentPrefix + MenuItem.name, MenuItem);
    app.component(componentPrefix + MenuItemGroup.name, MenuItemGroup);
    app.component(componentPrefix + SubMenu.name, SubMenu);
  }
});
const _sfc_main$l = defineComponent({
  name: "Message",
  components: {
    AIconHover: IconHover,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill,
    IconClose,
    IconLoading
  },
  props: {
    type: {
      type: String,
      default: "info"
    },
    closable: {
      type: Boolean,
      default: false
    },
    showIcon: {
      type: Boolean,
      default: true
    },
    duration: {
      type: Number,
      default: 3e3
    },
    resetOnUpdate: {
      type: Boolean,
      default: false
    },
    resetOnHover: {
      type: Boolean,
      default: false
    }
  },
  emits: ["close"],
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("message");
    let timer = 0;
    const handleClose = () => {
      emit2("close");
    };
    const startTimer = () => {
      if (props.duration > 0) {
        timer = window.setTimeout(handleClose, props.duration);
      }
    };
    const clearTimer = () => {
      if (timer) {
        window.clearTimeout(timer);
        timer = 0;
      }
    };
    onMounted(() => {
      startTimer();
    });
    onUpdated(() => {
      if (props.resetOnUpdate) {
        clearTimer();
        startTimer();
      }
    });
    onUnmounted(() => {
      clearTimer();
    });
    const handleMouseEnter = () => {
      if (props.resetOnHover) {
        clearTimer();
      }
    };
    const handleMouseLeave = () => {
      if (props.resetOnHover) {
        startTimer();
      }
    };
    return {
      handleMouseEnter,
      handleMouseLeave,
      prefixCls,
      handleClose
    };
  }
});
function _sfc_render$d(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_icon_loading = resolveComponent("icon-loading");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_a_icon_hover = resolveComponent("a-icon-hover");
  return openBlock(), createElementBlock("li", {
    role: "alert",
    class: normalizeClass([_ctx.prefixCls, `${_ctx.prefixCls}-${_ctx.type}`, {
      [`${_ctx.prefixCls}-closable`]: _ctx.closable
    }]),
    onMouseenter: _cache[1] || (_cache[1] = (...args) => _ctx.handleMouseEnter && _ctx.handleMouseEnter(...args)),
    onMouseleave: _cache[2] || (_cache[2] = (...args) => _ctx.handleMouseLeave && _ctx.handleMouseLeave(...args))
  }, [_ctx.showIcon && !(_ctx.type === "normal" && !_ctx.$slots.icon) ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-icon`)
  }, [renderSlot(_ctx.$slots, "icon", {}, () => [_ctx.type === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, {
    key: 0
  })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, {
    key: 1
  })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, {
    key: 2
  })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, {
    key: 3
  })) : _ctx.type === "loading" ? (openBlock(), createBlock(_component_icon_loading, {
    key: 4
  })) : createCommentVNode("v-if", true)])], 2)) : createCommentVNode("v-if", true), createBaseVNode("span", {
    class: normalizeClass(`${_ctx.prefixCls}-content`)
  }, [renderSlot(_ctx.$slots, "default")], 2), _ctx.closable ? (openBlock(), createElementBlock("span", {
    key: 1,
    class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClose && _ctx.handleClose(...args))
  }, [createVNode(_component_a_icon_hover, null, {
    default: withCtx(() => [createVNode(_component_icon_close)]),
    _: 1
  })], 2)) : createCommentVNode("v-if", true)], 34);
}
var Message$1 = /* @__PURE__ */ _export_sfc$1(_sfc_main$l, [["render", _sfc_render$d]]);
function _isSlot$1(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode$1(s);
}
var MessageList = defineComponent({
  name: "MessageList",
  props: {
    messages: {
      type: Array,
      default: () => []
    },
    position: {
      type: String,
      default: "top"
    }
  },
  emits: ["close", "afterClose"],
  setup(props, context) {
    const prefixCls = getPrefixCls("message-list");
    const {
      zIndex
    } = usePopupManager("message", {
      runOnMounted: true
    });
    return () => {
      let _slot;
      return createVNode(TransitionGroup, {
        "class": [prefixCls, `${prefixCls}-${props.position}`],
        "name": "fade-message",
        "tag": "ul",
        "style": {
          zIndex: zIndex.value
        },
        "onAfterLeave": () => context.emit("afterClose")
      }, _isSlot$1(_slot = props.messages.map((item) => {
        const slots = {
          default: getSlotFunction(item.content),
          icon: getSlotFunction(item.icon)
        };
        return createVNode(Message$1, {
          "key": item.id,
          "type": item.type,
          "duration": item.duration,
          "closable": item.closable,
          "resetOnUpdate": item.resetOnUpdate,
          "resetOnHover": item.resetOnHover,
          "onClose": () => context.emit("close", item.id)
        }, slots);
      })) ? _slot : {
        default: () => [_slot]
      });
    };
  }
});
var __defProp$1 = Object.defineProperty;
var __defProps$1 = Object.defineProperties;
var __getOwnPropDescs$1 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1 = Object.getOwnPropertySymbols;
var __hasOwnProp$1 = Object.prototype.hasOwnProperty;
var __propIsEnum$1 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1 = (obj, key, value) => key in obj ? __defProp$1(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues$1 = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp$1.call(b2, prop))
      __defNormalProp$1(a, prop, b2[prop]);
  if (__getOwnPropSymbols$1)
    for (var prop of __getOwnPropSymbols$1(b2)) {
      if (__propIsEnum$1.call(b2, prop))
        __defNormalProp$1(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps$1 = (a, b2) => __defProps$1(a, __getOwnPropDescs$1(b2));
class MessageManger {
  constructor(config, appContext) {
    this.messageCount = 0;
    this.add = (config2) => {
      var _a2;
      this.messageCount++;
      const id = (_a2 = config2.id) != null ? _a2 : `__arco_message_${this.messageCount}`;
      if (this.messageIds.has(id)) {
        return this.update(id, config2);
      }
      const message2 = reactive(__spreadValues$1({
        id
      }, config2));
      this.messages.value.push(message2);
      this.messageIds.add(id);
      return {
        close: () => this.remove(id)
      };
    };
    this.update = (id, config2) => {
      for (let i2 = 0; i2 < this.messages.value.length; i2++) {
        if (this.messages.value[i2].id === id) {
          const resetOnUpdate = !isUndefined(config2.duration);
          Object.assign(this.messages.value[i2], __spreadProps$1(__spreadValues$1({}, config2), {
            id,
            resetOnUpdate
          }));
          break;
        }
      }
      return {
        close: () => this.remove(id)
      };
    };
    this.remove = (id) => {
      for (let i2 = 0; i2 < this.messages.value.length; i2++) {
        const item = this.messages.value[i2];
        if (item.id === id) {
          if (isFunction$3(item.onClose)) {
            item.onClose(id);
          }
          this.messages.value.splice(i2, 1);
          this.messageIds.delete(id);
          break;
        }
      }
    };
    this.clear = () => {
      this.messages.value.splice(0);
    };
    this.destroy = () => {
      if (this.messages.value.length === 0 && this.container) {
        render$1(null, this.container);
        document.body.removeChild(this.container);
        this.container = null;
        messageInstance[this.position] = void 0;
      }
    };
    const {
      position = "top"
    } = config;
    this.container = getOverlay("message");
    this.messageIds = /* @__PURE__ */ new Set();
    this.messages = ref([]);
    this.position = position;
    const vm = createVNode(MessageList, {
      messages: this.messages.value,
      position,
      onClose: this.remove,
      onAfterClose: this.destroy
    });
    if (appContext != null ? appContext : Message._context) {
      vm.appContext = appContext != null ? appContext : Message._context;
    }
    render$1(vm, this.container);
    document.body.appendChild(this.container);
  }
}
const messageInstance = {};
const types = [...MESSAGE_TYPES, "loading", "normal"];
const message = types.reduce((pre, value) => {
  pre[value] = (config, appContext) => {
    if (isString$3(config)) {
      config = {
        content: config
      };
    }
    const _config = __spreadValues$1({
      type: value
    }, config);
    const {
      position = "top"
    } = _config;
    if (!messageInstance[position]) {
      messageInstance[position] = new MessageManger(_config, appContext);
    }
    return messageInstance[position].add(_config);
  };
  return pre;
}, {});
message.clear = (position) => {
  var _a2;
  if (position) {
    (_a2 = messageInstance[position]) == null ? void 0 : _a2.clear();
  } else {
    Object.values(messageInstance).forEach((item) => item == null ? void 0 : item.clear());
  }
};
const Message = __spreadProps$1(__spreadValues$1({}, message), {
  install: (app) => {
    const _message = {
      clear: message.clear
    };
    for (const key of types) {
      _message[key] = (config, appContext = app._context) => message[key](config, appContext);
    }
    app.config.globalProperties.$message = _message;
  },
  _context: null
});
const toKebabCase = (string) => {
  return string.replace(/\B([A-Z])/g, "-$1").toLowerCase();
};
const _sfc_main$k = defineComponent({
  name: "Notification",
  components: {
    AIconHover: IconHover,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill,
    IconClose
  },
  props: {
    type: {
      type: String,
      default: "info"
    },
    showIcon: {
      type: Boolean,
      default: true
    },
    closable: {
      type: Boolean,
      default: false
    },
    duration: {
      type: Number,
      default: 3e3
    },
    resetOnUpdate: {
      type: Boolean,
      default: false
    }
  },
  emits: ["close"],
  setup(props, context) {
    const prefixCls = getPrefixCls("notification");
    let timer = 0;
    const handleClose = () => {
      context.emit("close");
    };
    onMounted(() => {
      if (props.duration > 0) {
        timer = window.setTimeout(handleClose, props.duration);
      }
    });
    onUpdated(() => {
      if (props.resetOnUpdate) {
        if (timer) {
          window.clearTimeout(timer);
          timer = 0;
        }
        if (props.duration > 0) {
          timer = window.setTimeout(handleClose, props.duration);
        }
      }
    });
    onUnmounted(() => {
      if (timer) {
        window.clearTimeout(timer);
      }
    });
    return {
      prefixCls,
      handleClose
    };
  }
});
function _sfc_render$c(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_a_icon_hover = resolveComponent("a-icon-hover");
  return openBlock(), createElementBlock("li", {
    role: "alert",
    class: normalizeClass([_ctx.prefixCls, `${_ctx.prefixCls}-${_ctx.type}`, {
      [`${_ctx.prefixCls}-closable`]: _ctx.closable
    }])
  }, [_ctx.showIcon ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-left`)
  }, [createBaseVNode("div", {
    class: normalizeClass(`${_ctx.prefixCls}-icon`)
  }, [renderSlot(_ctx.$slots, "icon", {}, () => [_ctx.type === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, {
    key: 0
  })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, {
    key: 1
  })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, {
    key: 2
  })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, {
    key: 3
  })) : createCommentVNode("v-if", true)])], 2)], 2)) : createCommentVNode("v-if", true), createBaseVNode("div", {
    class: normalizeClass(`${_ctx.prefixCls}-right`)
  }, [_ctx.$slots.default ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-title`)
  }, [renderSlot(_ctx.$slots, "default")], 2)) : createCommentVNode("v-if", true), _ctx.$slots.content ? (openBlock(), createElementBlock("div", {
    key: 1,
    class: normalizeClass(`${_ctx.prefixCls}-content`)
  }, [renderSlot(_ctx.$slots, "content")], 2)) : createCommentVNode("v-if", true), _ctx.$slots.footer ? (openBlock(), createElementBlock("div", {
    key: 2,
    class: normalizeClass(`${_ctx.prefixCls}-footer`)
  }, [renderSlot(_ctx.$slots, "footer")], 2)) : createCommentVNode("v-if", true)], 2), _ctx.closable ? (openBlock(), createElementBlock("div", {
    key: 1,
    class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClose && _ctx.handleClose(...args))
  }, [renderSlot(_ctx.$slots, "closeIconElement", {}, () => [createVNode(_component_a_icon_hover, null, {
    default: withCtx(() => [renderSlot(_ctx.$slots, "closeIcon", {}, () => [createVNode(_component_icon_close)])]),
    _: 3
  })])], 2)) : createCommentVNode("v-if", true)], 2);
}
var Notification$1 = /* @__PURE__ */ _export_sfc$1(_sfc_main$k, [["render", _sfc_render$c]]);
const NOTIFICATION_POSITION = ["topLeft", "topRight", "bottomLeft", "bottomRight"];
function _isSlot(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode$1(s);
}
var NotificationList = defineComponent({
  name: "NotificationList",
  props: {
    notifications: {
      type: Array,
      default: () => []
    },
    position: {
      type: String,
      default: "topRight",
      validator: (value) => {
        return NOTIFICATION_POSITION.includes(value);
      }
    }
  },
  emits: ["close", "afterClose"],
  setup(props, context) {
    const prefixCls = getPrefixCls("notification-list");
    const kebabPosition = toKebabCase(props.position);
    const {
      zIndex
    } = usePopupManager("message", {
      runOnMounted: true
    });
    const isRight = props.position.includes("Right");
    return () => {
      let _slot;
      return createVNode(TransitionGroup, {
        "class": [prefixCls, `${prefixCls}-${kebabPosition}`],
        "style": {
          zIndex: zIndex.value
        },
        "name": `slide-${isRight ? "right" : "left"}-notification`,
        "onAfterLeave": () => context.emit("afterClose"),
        "tag": "ul"
      }, _isSlot(_slot = props.notifications.map((item) => {
        const slots = {
          default: getSlotFunction(item.title),
          content: getSlotFunction(item.content),
          icon: getSlotFunction(item.icon),
          footer: getSlotFunction(item.footer),
          closeIcon: getSlotFunction(item.closeIcon),
          closeIconElement: getSlotFunction(item.closeIconElement)
        };
        return createVNode(Notification$1, {
          "key": item.id,
          "type": item.type,
          "style": item.style,
          "class": item.class,
          "duration": item.duration,
          "closable": item.closable,
          "showIcon": item.showIcon,
          "resetOnUpdate": item.resetOnUpdate,
          "onClose": () => context.emit("close", item.id)
        }, slots);
      })) ? _slot : {
        default: () => [_slot]
      });
    };
  }
});
var __defProp2 = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp2 = (obj, key, value) => key in obj ? __defProp2(obj, key, {
  enumerable: true,
  configurable: true,
  writable: true,
  value
}) : obj[key] = value;
var __spreadValues = (a, b2) => {
  for (var prop in b2 || (b2 = {}))
    if (__hasOwnProp.call(b2, prop))
      __defNormalProp2(a, prop, b2[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b2)) {
      if (__propIsEnum.call(b2, prop))
        __defNormalProp2(a, prop, b2[prop]);
    }
  return a;
};
var __spreadProps = (a, b2) => __defProps(a, __getOwnPropDescs(b2));
class NotificationManger {
  constructor(config, appContext) {
    this.notificationCount = 0;
    this.add = (config2) => {
      var _a2;
      this.notificationCount++;
      const id = (_a2 = config2.id) != null ? _a2 : `__arco_notification_${this.notificationCount}`;
      if (this.notificationIds.has(id)) {
        return this.update(id, config2);
      }
      const notification2 = reactive(__spreadValues({
        id
      }, config2));
      this.notifications.value.push(notification2);
      this.notificationIds.add(id);
      return {
        close: () => this.remove(id)
      };
    };
    this.update = (id, config2) => {
      for (let i2 = 0; i2 < this.notifications.value.length; i2++) {
        if (this.notifications.value[i2].id === id) {
          const resetOnUpdate = !isUndefined(config2.duration);
          Object.assign(this.notifications.value[i2], __spreadProps(__spreadValues({}, config2), {
            id,
            resetOnUpdate
          }));
          break;
        }
      }
      return {
        close: () => this.remove(id)
      };
    };
    this.remove = (id) => {
      for (let i2 = 0; i2 < this.notifications.value.length; i2++) {
        const item = this.notifications.value[i2];
        if (item.id === id) {
          if (isFunction$3(item.onClose)) {
            item.onClose(id);
          }
          this.notifications.value.splice(i2, 1);
          this.notificationIds.delete(id);
          break;
        }
      }
    };
    this.clear = () => {
      this.notifications.value.splice(0);
    };
    this.destroy = () => {
      if (this.notifications.value.length === 0 && this.container) {
        render$1(null, this.container);
        document.body.removeChild(this.container);
        this.container = null;
        notificationInstance[this.position] = void 0;
      }
    };
    const {
      position = "topRight"
    } = config;
    this.container = getOverlay("notification");
    this.notificationIds = /* @__PURE__ */ new Set();
    this.notifications = ref([]);
    this.position = position;
    const vm = createVNode(NotificationList, {
      notifications: this.notifications.value,
      position,
      onClose: this.remove,
      onAfterClose: this.destroy
    });
    if (appContext != null ? appContext : Notification._context) {
      vm.appContext = appContext != null ? appContext : Notification._context;
    }
    render$1(vm, this.container);
    document.body.appendChild(this.container);
  }
}
const notificationInstance = {};
const notification = MESSAGE_TYPES.reduce((pre, value) => {
  pre[value] = (config, appContext) => {
    if (isString$3(config)) {
      config = {
        content: config
      };
    }
    const _config = __spreadValues({
      type: value
    }, config);
    const {
      position = "topRight"
    } = _config;
    if (!notificationInstance[position]) {
      notificationInstance[position] = new NotificationManger(_config, appContext);
    }
    return notificationInstance[position].add(_config);
  };
  return pre;
}, {});
notification.remove = (id) => {
  if (id) {
    Object.values(notificationInstance).forEach((item) => item == null ? void 0 : item.remove(id));
  }
};
notification.clear = (position) => {
  var _a2;
  if (position) {
    (_a2 = notificationInstance[position]) == null ? void 0 : _a2.clear();
  } else {
    Object.values(notificationInstance).forEach((item) => item == null ? void 0 : item.clear());
  }
};
const Notification = __spreadProps(__spreadValues({}, notification), {
  install: (app) => {
    const _notification = {
      clear: notification.clear
    };
    for (const key of MESSAGE_TYPES) {
      _notification[key] = (config, appContext = app._context) => notification[key](config, appContext);
    }
    app.config.globalProperties.$notification = _notification;
  },
  _context: null
});
const _sfc_main$j = defineComponent({
  name: "Popconfirm",
  components: {
    ArcoButton: Button,
    Trigger,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill
  },
  props: {
    content: String,
    position: {
      type: String,
      default: "top"
    },
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    type: {
      type: String,
      default: "info"
    },
    okText: String,
    cancelText: String,
    okLoading: {
      type: Boolean,
      default: false
    },
    okButtonProps: {
      type: Object
    },
    cancelButtonProps: {
      type: Object
    },
    contentClass: {
      type: [String, Array, Object]
    },
    contentStyle: {
      type: Object
    },
    arrowClass: {
      type: [String, Array, Object]
    },
    arrowStyle: {
      type: Object
    },
    popupContainer: {
      type: [String, Object]
    },
    onBeforeOk: {
      type: Function
    },
    onBeforeCancel: {
      type: Function
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true,
    "ok": () => true,
    "cancel": () => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("popconfirm");
    const {
      t: t2
    } = useI18n$1();
    const _popupVisible = ref(props.defaultPopupVisible);
    const computedPopupVisible = computed(() => {
      var _a2;
      return (_a2 = props.popupVisible) != null ? _a2 : _popupVisible.value;
    });
    const _okLoading = ref(false);
    const mergedOkLoading = computed(() => props.okLoading || _okLoading.value);
    let promiseNumber = 0;
    const close = () => {
      promiseNumber++;
      if (_okLoading.value) {
        _okLoading.value = false;
      }
      _popupVisible.value = false;
      emit2("update:popupVisible", false);
      emit2("popupVisibleChange", false);
    };
    const handlePopupVisibleChange = (visible) => {
      if (!visible) {
        close();
      } else {
        _popupVisible.value = visible;
        emit2("update:popupVisible", visible);
        emit2("popupVisibleChange", visible);
      }
    };
    const handleOk = async () => {
      const currentPromiseNumber = promiseNumber;
      const closed = await new Promise(async (resolve2) => {
        var _a2;
        if (isFunction$3(props.onBeforeOk)) {
          let result = props.onBeforeOk((closed2 = true) => resolve2(closed2));
          if (isPromise(result) || !isBoolean$1(result)) {
            _okLoading.value = true;
          }
          if (isPromise(result)) {
            try {
              result = (_a2 = await result) != null ? _a2 : true;
            } catch (error) {
              result = false;
            }
          }
          if (isBoolean$1(result)) {
            resolve2(result);
          }
        } else {
          resolve2(true);
        }
      });
      if (currentPromiseNumber === promiseNumber) {
        if (closed) {
          emit2("ok");
          close();
        } else if (_okLoading.value) {
          _okLoading.value = false;
        }
      }
    };
    const handleCancel = () => {
      var _a2;
      let result = true;
      if (isFunction$3(props.onBeforeCancel)) {
        result = (_a2 = props.onBeforeCancel()) != null ? _a2 : false;
      }
      if (result) {
        emit2("cancel");
        close();
      }
    };
    const contentCls = computed(() => [`${prefixCls}-popup-content`, props.contentClass]);
    const arrowCls = computed(() => [`${prefixCls}-popup-arrow`, props.arrowClass]);
    return {
      prefixCls,
      contentCls,
      arrowCls,
      computedPopupVisible,
      mergedOkLoading,
      handlePopupVisibleChange,
      handleOk,
      handleCancel,
      t: t2
    };
  }
});
function _sfc_render$b(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_arco_button = resolveComponent("arco-button");
  const _component_trigger = resolveComponent("trigger");
  return openBlock(), createBlock(_component_trigger, {
    class: normalizeClass(_ctx.prefixCls),
    trigger: "click",
    position: _ctx.position,
    "show-arrow": "",
    "popup-visible": _ctx.computedPopupVisible,
    "popup-offset": 10,
    "popup-container": _ctx.popupContainer,
    "content-class": _ctx.contentCls,
    "content-style": _ctx.contentStyle,
    "arrow-class": _ctx.arrowCls,
    "arrow-style": _ctx.arrowStyle,
    "animation-name": "zoom-in-fade-out",
    "auto-fit-transform-origin": "",
    onPopupVisibleChange: _ctx.handlePopupVisibleChange
  }, {
    content: withCtx(() => [createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-body`)
    }, [createBaseVNode("span", {
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [renderSlot(_ctx.$slots, "icon", {}, () => [_ctx.type === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, {
      key: 0
    })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, {
      key: 1
    })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, {
      key: 2
    })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, {
      key: 3
    })) : createCommentVNode("v-if", true)])], 2), createBaseVNode("span", {
      class: normalizeClass(`${_ctx.prefixCls}-content`)
    }, [renderSlot(_ctx.$slots, "content", {}, () => [createTextVNode(toDisplayString$1(_ctx.content), 1)])], 2)], 2), createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-footer`)
    }, [createVNode(_component_arco_button, mergeProps({
      size: "mini"
    }, _ctx.cancelButtonProps, {
      onClick: _ctx.handleCancel
    }), {
      default: withCtx(() => [createTextVNode(toDisplayString$1(_ctx.cancelText || _ctx.t("popconfirm.cancelText")), 1)]),
      _: 1
    }, 16, ["onClick"]), createVNode(_component_arco_button, mergeProps({
      type: "primary",
      size: "mini"
    }, _ctx.okButtonProps, {
      loading: _ctx.mergedOkLoading,
      onClick: _ctx.handleOk
    }), {
      default: withCtx(() => [createTextVNode(toDisplayString$1(_ctx.okText || _ctx.t("popconfirm.okText")), 1)]),
      _: 1
    }, 16, ["loading", "onClick"])], 2)]),
    default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
    _: 3
  }, 8, ["class", "position", "popup-visible", "popup-container", "content-class", "content-style", "arrow-class", "arrow-style", "onPopupVisibleChange"]);
}
var _Popconfirm = /* @__PURE__ */ _export_sfc$1(_sfc_main$j, [["render", _sfc_render$b]]);
const Popconfirm = Object.assign(_Popconfirm, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Popconfirm.name, _Popconfirm);
  }
});
const _sfc_main$i = defineComponent({
  name: "IconExclamation",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-exclamation`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$a = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$9 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M23 9h2v21h-2z"
}, null, -1);
const _hoisted_3$8 = /* @__PURE__ */ createBaseVNode("path", {
  fill: "currentColor",
  stroke: "none",
  d: "M23 9h2v21h-2z"
}, null, -1);
const _hoisted_4$4 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M23 37h2v2h-2z"
}, null, -1);
const _hoisted_5$4 = /* @__PURE__ */ createBaseVNode("path", {
  fill: "currentColor",
  stroke: "none",
  d: "M23 37h2v2h-2z"
}, null, -1);
const _hoisted_6$4 = [_hoisted_2$9, _hoisted_3$8, _hoisted_4$4, _hoisted_5$4];
function _sfc_render$a(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_6$4, 14, _hoisted_1$a);
}
var _IconExclamation = /* @__PURE__ */ _export_sfc$1(_sfc_main$i, [["render", _sfc_render$a]]);
const IconExclamation = Object.assign(_IconExclamation, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconExclamation.name, _IconExclamation);
  }
});
const _sfc_main$h = defineComponent({
  name: "IconCheck",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-check`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$9 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$8 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M41.678 11.05 19.05 33.678 6.322 20.95"
}, null, -1);
const _hoisted_3$7 = [_hoisted_2$8];
function _sfc_render$9(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$7, 14, _hoisted_1$9);
}
var _IconCheck = /* @__PURE__ */ _export_sfc$1(_sfc_main$h, [["render", _sfc_render$9]]);
const IconCheck = Object.assign(_IconCheck, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconCheck.name, _IconCheck);
  }
});
const _sfc_main$g = defineComponent({
  name: "IconInfo",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-info`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$8 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$7 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M25 39h-2V18h2z"
}, null, -1);
const _hoisted_3$6 = /* @__PURE__ */ createBaseVNode("path", {
  fill: "currentColor",
  stroke: "none",
  d: "M25 39h-2V18h2z"
}, null, -1);
const _hoisted_4$3 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M25 11h-2V9h2z"
}, null, -1);
const _hoisted_5$3 = /* @__PURE__ */ createBaseVNode("path", {
  fill: "currentColor",
  stroke: "none",
  d: "M25 11h-2V9h2z"
}, null, -1);
const _hoisted_6$3 = [_hoisted_2$7, _hoisted_3$6, _hoisted_4$3, _hoisted_5$3];
function _sfc_render$8(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_6$3, 14, _hoisted_1$8);
}
var _IconInfo = /* @__PURE__ */ _export_sfc$1(_sfc_main$g, [["render", _sfc_render$8]]);
const IconInfo = Object.assign(_IconInfo, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconInfo.name, _IconInfo);
  }
});
var ResultForbidden = defineComponent({
  name: "ResultForbidden",
  render() {
    return createVNode("svg", {
      "viewBox": "0 0 213 213",
      "height": "100%",
      "width": "100%",
      "style": {
        fillRule: "evenodd",
        clipRule: "evenodd",
        strokeLinejoin: "round",
        strokeMiterlimit: 2
      }
    }, [createVNode("g", {
      "transform": "matrix(1,0,0,1,-871.485,-445.62)"
    }, [createVNode("g", null, [createVNode("g", {
      "transform": "matrix(1,0,0,1,-75.2684,-87.3801)"
    }, [createVNode("circle", {
      "cx": "1053.23",
      "cy": "639.477",
      "r": "106.477",
      "style": {
        fill: "rgb(235, 238, 246)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1,0,0,1,246.523,295.575)"
    }, [createVNode("g", {
      "transform": "matrix(0.316667,0,0,0.316667,277.545,71.0298)"
    }, [createVNode("g", {
      "transform": "matrix(0.989011,-0.571006,1.14201,0.659341,-335.171,81.4498)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(253, 243, 228)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.164835,-0.0951676,1.14201,0.659341,116.224,-179.163)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(202, 174, 136)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.978261,-0.564799,1.26804e-16,1.30435,-337.046,42.0327)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.267591,-0.154493,3.46856e-17,0.356787,992.686,475.823)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(102, 102, 102)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.28257,-0.740494,1.23317e-16,1.7101,1501.14,624.071)"
    }, [createVNode("g", {
      "transform": "matrix(1,0,0,1,-6,-6)"
    }, [createVNode("path", {
      "d": "M2.25,10.5C2.25,10.5 1.5,10.5 1.5,9.75C1.5,9 2.25,6.75 6,6.75C9.75,6.75 10.5,9 10.5,9.75C10.5,10.5 9.75,10.5 9.75,10.5L2.25,10.5ZM6,6C7.234,6 8.25,4.984 8.25,3.75C8.25,2.516 7.234,1.5 6,1.5C4.766,1.5 3.75,2.516 3.75,3.75C3.75,4.984 4.766,6 6,6Z",
      "style": {
        fill: "white"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.725806,0.419045,1.75755e-17,1.01444,155.314,212.138)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.58977,-0.917857,1.15976e-16,2.2425,-1270.46,-614.379)"
    }, [createVNode("rect", {
      "x": "1748.87",
      "y": "1226.67",
      "width": "10.895",
      "height": "13.378",
      "style": {
        fill: "rgb(132, 97, 0)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.182997,0.105653,-0.494902,0.285732,814.161,66.3087)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fillOpacity: 0.1
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.316667,0,0,0.316667,237.301,94.2647)"
    }, [createVNode("g", {
      "transform": "matrix(0.989011,-0.571006,1.14201,0.659341,-335.171,81.4498)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(253, 243, 228)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.164835,-0.0951676,1.14201,0.659341,116.224,-179.163)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(202, 174, 136)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.978261,-0.564799,1.26804e-16,1.30435,-337.046,42.0327)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.267591,-0.154493,3.46856e-17,0.356787,992.686,475.823)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(102, 102, 102)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.28257,-0.740494,1.23317e-16,1.7101,1501.14,624.071)"
    }, [createVNode("g", {
      "transform": "matrix(1,0,0,1,-6,-6)"
    }, [createVNode("path", {
      "d": "M2.25,10.5C2.25,10.5 1.5,10.5 1.5,9.75C1.5,9 2.25,6.75 6,6.75C9.75,6.75 10.5,9 10.5,9.75C10.5,10.5 9.75,10.5 9.75,10.5L2.25,10.5ZM6,6C7.234,6 8.25,4.984 8.25,3.75C8.25,2.516 7.234,1.5 6,1.5C4.766,1.5 3.75,2.516 3.75,3.75C3.75,4.984 4.766,6 6,6Z",
      "style": {
        fill: "white"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.725806,0.419045,1.75755e-17,1.01444,155.314,212.138)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.58977,-0.917857,1.15976e-16,2.2425,-1270.46,-614.379)"
    }, [createVNode("rect", {
      "x": "1748.87",
      "y": "1226.67",
      "width": "10.895",
      "height": "13.378",
      "style": {
        fill: "rgb(132, 97, 0)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.474953,0,0,0.474953,538.938,8.95289)"
    }, [createVNode("g", {
      "transform": "matrix(0.180615,0.104278,-0.973879,0.562269,790.347,286.159)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fillOpacity: 0.1
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.473356,0,0,0.473356,294.481,129.741)"
    }, [createVNode("g", null, [createVNode("g", {
      "transform": "matrix(0.1761,-0.101671,1.73518e-16,1.22207,442.564,7.31508)"
    }, [createVNode("rect", {
      "x": "202.62",
      "y": "575.419",
      "width": "124.002",
      "height": "259.402",
      "style": {
        fill: "rgb(235, 235, 235)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0922781,0.0532768,2.03964e-16,2.20569,405.236,-248.842)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(34, 34, 34)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.147541,-0.0851831,1.52371e-16,1.23446,454.294,-3.8127)"
    }, [createVNode("rect", {
      "x": "202.62",
      "y": "575.419",
      "width": "124.002",
      "height": "259.402",
      "style": {
        fill: "rgb(51, 51, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0921286,0.0531905,-0.126106,0.0728076,474.688,603.724)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(102, 102, 102)"
      }
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.473356,0,0,0.473356,192.621,188.549)"
    }, [createVNode("g", null, [createVNode("g", {
      "transform": "matrix(0.1761,-0.101671,1.73518e-16,1.22207,442.564,7.31508)"
    }, [createVNode("rect", {
      "x": "202.62",
      "y": "575.419",
      "width": "124.002",
      "height": "259.402",
      "style": {
        fill: "rgb(235, 235, 235)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0922781,0.0532768,2.03964e-16,2.20569,405.236,-248.842)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(34, 34, 34)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.147541,-0.0851831,1.52371e-16,1.23446,454.294,-3.8127)"
    }, [createVNode("rect", {
      "x": "202.62",
      "y": "575.419",
      "width": "124.002",
      "height": "259.402",
      "style": {
        fill: "rgb(51, 51, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0921286,0.0531905,-0.126106,0.0728076,474.688,603.724)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(102, 102, 102)"
      }
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.668111,0,0,0.668111,-123.979,-49.2109)"
    }, [createVNode("g", {
      "transform": "matrix(0.0349225,0.0201625,1.81598e-17,0.220789,974.758,729.412)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(235, 235, 235)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.1164,-0.644557,0,0.220789,42.5091,1294.14)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(235, 235, 235)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0349225,0.0201625,-1.52814,0.882275,1593.11,461.746)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(102, 102, 102)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.1164,-0.644557,0,0.220789,49.4442,1298.14)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(51, 51, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0349225,0.0201625,1.81598e-17,0.220789,753.056,857.412)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(34, 34, 34)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,898.874,529.479)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,930.12,511.44)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,961.365,493.4)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(248, 248, 248)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,992.61,475.361)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(248, 248, 248)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,1023.86,457.321)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(248, 248, 248)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,1056.25,438.617)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,1085.74,421.589)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.668111,0,0,0.668111,-123.979,-91.97)"
    }, [createVNode("g", {
      "transform": "matrix(0.0349225,0.0201625,1.81598e-17,0.220789,974.758,729.412)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(235, 235, 235)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.1164,-0.644557,0,0.220789,42.5091,1294.14)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(235, 235, 235)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0349225,0.0201625,-1.52814,0.882275,1593.11,461.746)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(102, 102, 102)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.1164,-0.644557,0,0.220789,49.4442,1298.14)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(51, 51, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0349225,0.0201625,1.81598e-17,0.220789,753.056,857.412)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fill: "rgb(34, 34, 34)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,898.874,529.479)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,930.12,511.44)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,961.365,493.4)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(248, 248, 248)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,992.61,475.361)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(248, 248, 248)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,1023.86,457.321)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(248, 248, 248)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,1056.25,438.617)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.142968,-0.0825428,-0.207261,0.478709,1085.74,421.589)"
    }, [createVNode("rect", {
      "x": "831",
      "y": "1023.79",
      "width": "89.214",
      "height": "89.214",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.701585,5.16096e-35,-5.16096e-35,0.701585,-546.219,-21.3487)"
    }, [createVNode("g", {
      "transform": "matrix(0.558202,-0.322278,0,0.882275,1033.27,615.815)"
    }, [createVNode("path", {
      "d": "M855.598,410.446C855.598,407.244 852.515,404.643 848.718,404.643L663.891,404.643C660.094,404.643 657.012,407.244 657.012,410.446L657.012,543.92C657.012,547.123 660.094,549.723 663.891,549.723L848.718,549.723C852.515,549.723 855.598,547.123 855.598,543.92L855.598,410.446Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.558202,-0.322278,0,0.882275,1035.25,616.977)"
    }, [createVNode("path", {
      "d": "M855.598,410.446C855.598,407.244 852.515,404.643 848.718,404.643L663.891,404.643C660.094,404.643 657.012,407.244 657.012,410.446L657.012,543.92C657.012,547.123 660.094,549.723 663.891,549.723L848.718,549.723C852.515,549.723 855.598,547.123 855.598,543.92L855.598,410.446Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1,0,0,1,418.673,507.243)"
    }, [createVNode("path", {
      "d": "M1088.34,192.063C1089.79,191.209 1090.78,191.821 1090.78,191.821L1092.71,192.944C1092.71,192.944 1092.29,192.721 1091.7,192.763C1090.99,192.813 1090.34,193.215 1090.34,193.215C1090.34,193.215 1088.85,192.362 1088.34,192.063Z",
      "style": {
        fill: "rgb(248, 248, 248)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1,0,0,1,235.984,-39.1315)"
    }, [createVNode("path", {
      "d": "M1164.02,805.247C1164.05,802.517 1165.64,799.379 1167.67,798.118L1169.67,799.272C1167.58,800.648 1166.09,803.702 1166.02,806.402L1164.02,805.247Z",
      "style": {
        fill: "url(#_Linear1)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.396683,0,0,0.396683,1000.22,516.921)"
    }, [createVNode("path", {
      "d": "M1011.2,933.14C1009.31,932.075 1008.05,929.696 1007.83,926.324L1012.87,929.235C1012.87,929.235 1012.96,930.191 1013.04,930.698C1013.16,931.427 1013.42,932.344 1013.62,932.845C1013.79,933.255 1014.59,935.155 1016.22,936.046C1015.83,935.781 1011.19,933.139 1011.19,933.139L1011.2,933.14Z",
      "style": {
        fill: "rgb(238, 238, 238)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.253614,-0.146424,4.87691e-17,0.338152,1209.98,830.02)"
    }, [createVNode("circle", {
      "cx": "975.681",
      "cy": "316.681",
      "r": "113.681",
      "style": {
        fill: "rgb(245, 63, 63)"
      }
    }, null), createVNode("g", {
      "transform": "matrix(1.08844,0,0,0.61677,-99.9184,125.436)"
    }, [createVNode("path", {
      "d": "M1062,297.556C1062,296.697 1061.61,296 1061.12,296L915.882,296C915.395,296 915,296.697 915,297.556L915,333.356C915,334.215 915.395,334.912 915.882,334.912L1061.12,334.912C1061.61,334.912 1062,334.215 1062,333.356L1062,297.556Z",
      "style": {
        fill: "white"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(5.57947,-3.22131,0.306277,0.176829,-6260.71,4938.32)"
    }, [createVNode("rect", {
      "x": "1335.54",
      "y": "694.688",
      "width": "18.525",
      "height": "6.511",
      "style": {
        fill: "rgb(248, 248, 248)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.10726,0.0619268,-1.83335e-14,18.1609,1256.76,-11932.8)"
    }, [createVNode("rect", {
      "x": "1335.54",
      "y": "694.688",
      "width": "18.525",
      "height": "6.511",
      "style": {
        fill: "rgb(238, 238, 238)"
      }
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.316667,0,0,0.316667,269.139,37.8829)"
    }, [createVNode("g", {
      "transform": "matrix(0.989011,-0.571006,1.14201,0.659341,-335.171,81.4498)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(253, 243, 228)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.164835,-0.0951676,1.14201,0.659341,116.224,-179.163)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(202, 174, 136)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.978261,-0.564799,1.26804e-16,1.30435,-337.046,42.0327)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.267591,-0.154493,3.46856e-17,0.356787,992.686,475.823)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(102, 102, 102)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.28257,-0.740494,1.23317e-16,1.7101,1501.14,624.071)"
    }, [createVNode("g", {
      "transform": "matrix(1,0,0,1,-6,-6)"
    }, [createVNode("path", {
      "d": "M2.25,10.5C2.25,10.5 1.5,10.5 1.5,9.75C1.5,9 2.25,6.75 6,6.75C9.75,6.75 10.5,9 10.5,9.75C10.5,10.5 9.75,10.5 9.75,10.5L2.25,10.5ZM6,6C7.234,6 8.25,4.984 8.25,3.75C8.25,2.516 7.234,1.5 6,1.5C4.766,1.5 3.75,2.516 3.75,3.75C3.75,4.984 4.766,6 6,6Z",
      "style": {
        fill: "white"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.725806,0.419045,1.75755e-17,1.01444,155.314,212.138)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.58977,-0.917857,1.15976e-16,2.2425,-1270.46,-614.379)"
    }, [createVNode("rect", {
      "x": "1748.87",
      "y": "1226.67",
      "width": "10.895",
      "height": "13.378",
      "style": {
        fill: "rgb(132, 97, 0)"
      }
    }, null)])])])])]), createVNode("defs", null, [createVNode("linearGradient", {
      "id": "_Linear1",
      "x1": "0",
      "y1": "0",
      "x2": "1",
      "y2": "0",
      "gradientUnits": "userSpaceOnUse",
      "gradientTransform": "matrix(-2.64571,4.04098,-4.04098,-2.64571,1167.67,799.269)"
    }, [createVNode("stop", {
      "offset": "0",
      "style": {
        stopColor: "rgb(248, 248, 248)",
        stopOpacity: 1
      }
    }, null), createVNode("stop", {
      "offset": "1",
      "style": {
        stopColor: "rgb(248, 248, 248)",
        stopOpacity: 1
      }
    }, null)])])]);
  }
});
var ResultNotFound = defineComponent({
  name: "ResultNotFound",
  render() {
    return createVNode("svg", {
      "width": "100%",
      "height": "100%",
      "viewBox": "0 0 213 213",
      "style": {
        fillRule: "evenodd",
        clipRule: "evenodd",
        strokeLinejoin: "round",
        strokeMiterlimit: 2
      }
    }, [createVNode("g", {
      "transform": "matrix(1,0,0,1,-1241.95,-445.62)"
    }, [createVNode("g", null, [createVNode("g", {
      "transform": "matrix(1,0,0,1,295.2,-87.3801)"
    }, [createVNode("circle", {
      "cx": "1053.23",
      "cy": "639.477",
      "r": "106.477",
      "style": {
        fill: "rgb(235, 238, 246)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.38223,0,0,0.38223,1126.12,238.549)"
    }, [createVNode("g", {
      "transform": "matrix(0.566536,0.327089,-1.28774,0.74348,763.4,317.171)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fillOpacity: 0.1
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.29595,0.170867,-0.91077,0.525833,873.797,588.624)"
    }, [createVNode("rect", {
      "x": "657.012",
      "y": "404.643",
      "width": "198.586",
      "height": "145.08",
      "style": {
        fillOpacity: 0.1
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1,0,0,1,275,-15)"
    }, [createVNode("path", {
      "d": "M262.077,959.012L276.923,959.012L273.388,1004.01C273.388,1004.59 273.009,1005.16 272.25,1005.6C270.732,1006.48 268.268,1006.48 266.75,1005.6C265.991,1005.16 265.612,1004.59 265.612,1004.01L262.077,959.012Z",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null), createVNode("g", {
      "transform": "matrix(0.866025,-0.5,1,0.57735,0,-45)"
    }, [createVNode("ellipse", {
      "cx": "-848.416",
      "cy": "1004.25",
      "rx": "6.062",
      "ry": "5.25",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(1,0,0,1,183.952,-67.5665)"
    }, [createVNode("path", {
      "d": "M262.077,959.012L276.923,959.012L273.388,1004.01C273.388,1004.59 273.009,1005.16 272.25,1005.6C270.732,1006.48 268.268,1006.48 266.75,1005.6C265.991,1005.16 265.612,1004.59 265.612,1004.01L262.077,959.012Z",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null), createVNode("g", {
      "transform": "matrix(0.866025,-0.5,1,0.57735,0,-45)"
    }, [createVNode("ellipse", {
      "cx": "-848.416",
      "cy": "1004.25",
      "rx": "6.062",
      "ry": "5.25",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(1,0,0,1,414,-95.2517)"
    }, [createVNode("path", {
      "d": "M262.077,959.012L276.923,959.012L273.388,1004.01C273.388,1004.59 273.009,1005.16 272.25,1005.6C270.732,1006.48 268.268,1006.48 266.75,1005.6C265.991,1005.16 265.612,1004.59 265.612,1004.01L262.077,959.012Z",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null), createVNode("g", {
      "transform": "matrix(0.866025,-0.5,1,0.57735,0,-45)"
    }, [createVNode("ellipse", {
      "cx": "-848.416",
      "cy": "1004.25",
      "rx": "6.062",
      "ry": "5.25",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(1,0,0,1,322.952,-147.818)"
    }, [createVNode("path", {
      "d": "M262.077,959.012L276.923,959.012L273.388,1004.01C273.388,1004.59 273.009,1005.16 272.25,1005.6C270.732,1006.48 268.268,1006.48 266.75,1005.6C265.991,1005.16 265.612,1004.59 265.612,1004.01L262.077,959.012Z",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null), createVNode("g", {
      "transform": "matrix(0.866025,-0.5,1,0.57735,0,-45)"
    }, [createVNode("ellipse", {
      "cx": "-848.416",
      "cy": "1004.25",
      "rx": "6.062",
      "ry": "5.25",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)])]), createVNode("g", null, [createVNode("g", {
      "transform": "matrix(1.42334,-0.821763,1.11271,0.642426,-1439.64,459.621)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(253, 243, 228)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.40786,-0.812831,6.60237e-16,1.99081,-2052.17,-84.7286)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.26159,-0.728382,5.91642e-16,1.78397,-1774.67,11.2303)"
    }, [createVNode("path", {
      "d": "M1950.29,1194.38C1950.29,1193.37 1949.41,1192.54 1948.34,1192.54L1846.01,1192.54C1844.93,1192.54 1844.06,1193.37 1844.06,1194.38L1844.06,1282.7C1844.06,1283.72 1844.93,1284.54 1846.01,1284.54L1948.34,1284.54C1949.41,1284.54 1950.29,1283.72 1950.29,1282.7L1950.29,1194.38Z",
      "style": {
        fill: "rgb(132, 97, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.2198,-0.704254,5.72043e-16,1.72488,-1697.6,37.2103)"
    }, [createVNode("path", {
      "d": "M1950.29,1194.38C1950.29,1193.37 1949.41,1192.54 1948.34,1192.54L1846.01,1192.54C1844.93,1192.54 1844.06,1193.37 1844.06,1194.38L1844.06,1282.7C1844.06,1283.72 1844.93,1284.54 1846.01,1284.54L1948.34,1284.54C1949.41,1284.54 1950.29,1283.72 1950.29,1282.7L1950.29,1194.38Z",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.707187,0.408295,9.06119e-17,1.54833,-733.949,683.612)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.64553,-0.950049,1.17482,0.678285,-1632.45,473.879)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(253, 243, 228)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.74666,0.431085,2.3583e-17,0.135259,-816.63,57.1397)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.64553,-0.950049,1.17482,0.678285,-1632.45,473.879)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(253, 243, 228)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.750082,0,0,0.750082,163.491,354.191)"
    }, [createVNode("g", {
      "transform": "matrix(1.75943,-1.01581,1.75879e-16,0.632893,-2721.54,1876.43)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.290956,-0.167984,2.90849e-17,0.104661,69.4195,919.311)"
    }, [createVNode("path", {
      "d": "M1950.29,1238.54C1950.29,1213.15 1944.73,1192.54 1937.88,1192.54L1856.47,1192.54C1849.62,1192.54 1844.06,1213.15 1844.06,1238.54C1844.06,1263.93 1849.62,1284.54 1856.47,1284.54L1937.88,1284.54C1944.73,1284.54 1950.29,1263.93 1950.29,1238.54Z",
      "style": {
        fill: "rgb(132, 97, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.262716,-0.151679,8.27418e-18,0.0364999,121.496,970.53)"
    }, [createVNode("path", {
      "d": "M1950.29,1238.54C1950.29,1213.15 1948.14,1192.54 1945.5,1192.54L1848.85,1192.54C1846.2,1192.54 1844.06,1213.15 1844.06,1238.54C1844.06,1263.93 1846.2,1284.54 1848.85,1284.54L1945.5,1284.54C1948.14,1284.54 1950.29,1263.93 1950.29,1238.54Z",
      "style": {
        fill: "rgb(246, 220, 185)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.77877,-1.02697,0.0581765,0.0335882,-425.293,1228.27)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0369741,0.021347,4.72735e-17,0.492225,456.143,919.985)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.750082,0,0,0.750082,163.491,309.191)"
    }, [createVNode("g", {
      "transform": "matrix(1.75943,-1.01581,1.75879e-16,0.632893,-2721.54,1876.43)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.290956,-0.167984,2.90849e-17,0.104661,69.4195,919.311)"
    }, [createVNode("path", {
      "d": "M1950.29,1238.54C1950.29,1213.15 1944.73,1192.54 1937.88,1192.54L1856.47,1192.54C1849.62,1192.54 1844.06,1213.15 1844.06,1238.54C1844.06,1263.93 1849.62,1284.54 1856.47,1284.54L1937.88,1284.54C1944.73,1284.54 1950.29,1263.93 1950.29,1238.54Z",
      "style": {
        fill: "rgb(132, 97, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.262716,-0.151679,8.27418e-18,0.0364999,121.496,970.53)"
    }, [createVNode("path", {
      "d": "M1950.29,1238.54C1950.29,1213.15 1948.14,1192.54 1945.5,1192.54L1848.85,1192.54C1846.2,1192.54 1844.06,1213.15 1844.06,1238.54C1844.06,1263.93 1846.2,1284.54 1848.85,1284.54L1945.5,1284.54C1948.14,1284.54 1950.29,1263.93 1950.29,1238.54Z",
      "style": {
        fill: "rgb(246, 220, 185)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.77877,-1.02697,0.0581765,0.0335882,-425.293,1228.27)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0369741,0.021347,4.72735e-17,0.492225,456.143,919.985)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)])]), createVNode("g", {
      "transform": "matrix(0.750082,0,0,0.750082,163.491,263.931)"
    }, [createVNode("g", {
      "transform": "matrix(1.75943,-1.01581,1.75879e-16,0.632893,-2721.54,1876.43)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.290956,-0.167984,2.90849e-17,0.104661,69.4195,919.311)"
    }, [createVNode("path", {
      "d": "M1950.29,1238.54C1950.29,1213.15 1944.73,1192.54 1937.88,1192.54L1856.47,1192.54C1849.62,1192.54 1844.06,1213.15 1844.06,1238.54C1844.06,1263.93 1849.62,1284.54 1856.47,1284.54L1937.88,1284.54C1944.73,1284.54 1950.29,1263.93 1950.29,1238.54Z",
      "style": {
        fill: "rgb(132, 97, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.262716,-0.151679,8.27418e-18,0.0364999,121.496,970.53)"
    }, [createVNode("path", {
      "d": "M1950.29,1238.54C1950.29,1213.15 1948.14,1192.54 1945.5,1192.54L1848.85,1192.54C1846.2,1192.54 1844.06,1213.15 1844.06,1238.54C1844.06,1263.93 1846.2,1284.54 1848.85,1284.54L1945.5,1284.54C1948.14,1284.54 1950.29,1263.93 1950.29,1238.54Z",
      "style": {
        fill: "rgb(246, 220, 185)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.77877,-1.02697,0.0581765,0.0335882,-425.293,1228.27)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0369741,0.021347,4.72735e-17,0.492225,456.143,919.985)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)])]), createVNode("path", {
      "d": "M555.753,832.474L555.753,921.408L630.693,878.141L630.693,789.207L555.753,832.474Z",
      "style": {
        fillOpacity: 0.1
      }
    }, null), createVNode("g", {
      "transform": "matrix(0.750082,0,0,0.750082,236.431,272.852)"
    }, [createVNode("g", {
      "transform": "matrix(1.64553,-0.950049,1.14552,0.661368,-1606.78,467.933)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(253, 243, 228)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.54477,-0.891873,1.05847,0.611108,-1456.84,490.734)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(132, 97, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.27607,-0.736739,0.751435,0.433841,-970.952,617.519)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.62765,-0.939723,1.42156e-16,0.5,-2476.81,1893.62)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.62765,-0.939723,1.42156e-16,0.5,-2476.81,1893.62)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.728038,0.420333,3.52595e-17,0.377589,-790.978,151.274)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.75943,-1.01581,1.75879e-16,0.632893,-2726.83,1873.38)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", null, [createVNode("g", {
      "transform": "matrix(1.75943,-1.01581,1.75879e-16,0.632893,-2721.54,1876.43)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.290956,-0.167984,2.90849e-17,0.104661,69.4195,919.311)"
    }, [createVNode("path", {
      "d": "M1950.29,1238.54C1950.29,1213.15 1944.73,1192.54 1937.88,1192.54L1856.47,1192.54C1849.62,1192.54 1844.06,1213.15 1844.06,1238.54C1844.06,1263.93 1849.62,1284.54 1856.47,1284.54L1937.88,1284.54C1944.73,1284.54 1950.29,1263.93 1950.29,1238.54Z",
      "style": {
        fill: "rgb(132, 97, 51)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.262716,-0.151679,8.27418e-18,0.0364999,121.496,970.53)"
    }, [createVNode("path", {
      "d": "M1950.29,1238.54C1950.29,1213.15 1948.14,1192.54 1945.5,1192.54L1848.85,1192.54C1846.2,1192.54 1844.06,1213.15 1844.06,1238.54C1844.06,1263.93 1846.2,1284.54 1848.85,1284.54L1945.5,1284.54C1948.14,1284.54 1950.29,1263.93 1950.29,1238.54Z",
      "style": {
        fill: "rgb(246, 220, 185)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(1.77877,-1.02697,0.0581765,0.0335882,-425.293,1228.27)"
    }, [createVNode("rect", {
      "x": "495.52",
      "y": "1057.87",
      "width": "105.078",
      "height": "91",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.0369741,0.021347,4.72735e-17,0.492225,456.143,919.985)"
    }, [createVNode("rect", {
      "x": "1663.92",
      "y": "-407.511",
      "width": "143.183",
      "height": "118.292",
      "style": {
        fill: "rgb(240, 218, 183)"
      }
    }, null)])])]), createVNode("g", {
      "transform": "matrix(1.62765,-0.939723,4.80984e-17,0.173913,-2468.81,2307.87)"
    }, [createVNode("rect", {
      "x": "1844.06",
      "y": "1192.54",
      "width": "106.232",
      "height": "92",
      "style": {
        fill: "rgb(196, 173, 142)"
      }
    }, null)])]), createVNode("g", null, [createVNode("g", {
      "transform": "matrix(0.479077,0.276595,-0.564376,0.325843,598.357,-129.986)"
    }, [createVNode("path", {
      "d": "M1776.14,1326C1776.14,1321.19 1772.15,1317.28 1767.24,1317.28L1684.37,1317.28C1679.46,1317.28 1675.47,1321.19 1675.47,1326L1675.47,1395.75C1675.47,1400.56 1679.46,1404.46 1684.37,1404.46L1767.24,1404.46C1772.15,1404.46 1776.14,1400.56 1776.14,1395.75L1776.14,1326Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(2.61622,0,0,2.61622,-2305.73,162.161)"
    }, [createVNode("g", {
      "transform": "matrix(1.09915,-0.634597,1.26919,0.73277,-299.167,-62.4615)"
    }, [createVNode("ellipse", {
      "cx": "412.719",
      "cy": "770.575",
      "rx": "6.303",
      "ry": "5.459",
      "style": {
        fill: "rgb(255, 125, 0)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.238212,-0.137532,0.178659,0.103149,875.064,207.93)"
    }, [createVNode("text", {
      "x": "413.474px",
      "y": "892.067px",
      "style": {
        fontFamily: "NunitoSans-Bold, Nunito Sans",
        fontWeight: 700,
        fontSize: 41.569,
        fill: "white"
      }
    }, [createTextVNode("?")])])])])])])])]);
  }
});
var ResultServerError = defineComponent({
  name: "ResultServerError",
  render() {
    return createVNode("svg", {
      "width": "100%",
      "height": "100%",
      "viewBox": "0 0 213 213",
      "style": {
        fillRule: "evenodd",
        clipRule: "evenodd",
        strokeLinejoin: "round",
        strokeMiterlimit: 2
      }
    }, [createVNode("g", {
      "transform": "matrix(1,0,0,1,-483.054,-445.448)"
    }, [createVNode("g", null, [createVNode("g", {
      "transform": "matrix(1,0,0,1,-463.699,-87.5516)"
    }, [createVNode("circle", {
      "cx": "1053.23",
      "cy": "639.477",
      "r": "106.477",
      "style": {
        fill: "rgb(235, 238, 246)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.384532,-0.222009,0.444019,0.256354,-0.569781,260.021)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fillOpacity: 0.1
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.384532,-0.222009,0.444019,0.256354,-0.569781,218.845)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.361496,-0.20871,0.41742,0.240997,34.7805,238.807)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fill: "rgb(0, 85, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.341853,-0.197369,0.394738,0.227902,64.9247,257.804)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fill: "rgb(29, 105, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.428916,0,0,0.428916,19.0588,329.956)"
    }, [createVNode("clipPath", {
      "id": "_clip1"
    }, [createVNode("path", {
      "d": "M1461.07,528.445C1461.07,530.876 1459.6,533.196 1456.6,534.928L1342.04,601.072C1335.41,604.896 1323.83,604.415 1316.18,600L1205.33,536C1201.14,533.585 1199,530.489 1199,527.555L1199,559.555C1199,562.489 1201.14,565.585 1205.33,568L1316.18,632C1323.83,636.415 1335.41,636.896 1342.04,633.072L1456.6,566.928C1459.6,565.196 1461.07,562.876 1461.07,560.445L1461.07,528.445Z"
    }, null)]), createVNode("g", {
      "clipPath": "url(#_clip1)"
    }, [createVNode("g", {
      "transform": "matrix(2.33146,-0,-0,2.33146,1081.79,269.266)"
    }, [createVNode("use", {
      "href": "#_Image2",
      "x": "50.54",
      "y": "112.301",
      "width": "112.406px",
      "height": "46.365px",
      "transform": "matrix(0.99474,0,0,0.98649,0,0)"
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,265.448)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,268.45)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,271.452)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.360289,-0.208013,-4.39887e-18,0.576941,37.5847,124.262)"
    }, [createVNode("rect", {
      "x": "1621.2",
      "y": "1370.57",
      "width": "57.735",
      "height": "5.947",
      "style": {
        fill: "rgb(106, 161, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,307.505,420.796)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,310.507,419.062)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,313.509,417.329)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,316.512,415.595)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,319.514,413.862)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.384532,-0.222009,0.444019,0.256354,-0.569781,196.542)"
    }, [createVNode("clipPath", {
      "id": "_clip3"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z"
    }, null)]), createVNode("g", {
      "clipPath": "url(#_clip3)"
    }, [createVNode("g", {
      "transform": "matrix(1.30028,1.12608,-2.25216,1.95042,68.2716,1030.07)"
    }, [createVNode("use", {
      "href": "#_Image4",
      "x": "50.54",
      "y": "56.312",
      "width": "112.406px",
      "height": "64.897px",
      "transform": "matrix(0.99474,0,0,0.998422,0,0)"
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.361496,-0.20871,0.41742,0.240997,34.7805,216.764)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fill: "rgb(0, 85, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.341853,-0.197369,0.394738,0.227902,64.9247,235.762)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fill: "rgb(29, 105, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.428916,0,0,0.428916,19.0588,307.652)"
    }, [createVNode("clipPath", {
      "id": "_clip5"
    }, [createVNode("path", {
      "d": "M1461.07,528.445C1461.07,530.876 1459.6,533.196 1456.6,534.928L1342.04,601.072C1335.41,604.896 1323.83,604.415 1316.18,600L1205.33,536C1201.14,533.585 1199,530.489 1199,527.555L1199,559.555C1199,562.489 1201.14,565.585 1205.33,568L1316.18,632C1323.83,636.415 1335.41,636.896 1342.04,633.072L1456.6,566.928C1459.6,565.196 1461.07,562.876 1461.07,560.445L1461.07,528.445Z"
    }, null)]), createVNode("g", {
      "clipPath": "url(#_clip5)"
    }, [createVNode("g", {
      "transform": "matrix(2.33146,-0,-0,2.33146,1081.79,321.266)"
    }, [createVNode("use", {
      "href": "#_Image2",
      "x": "50.54",
      "y": "89.692",
      "width": "112.406px",
      "height": "46.365px",
      "transform": "matrix(0.99474,0,0,0.98649,0,0)"
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,243.144)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,246.146)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,249.149)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.360289,-0.208013,-4.39887e-18,0.576941,37.5847,101.958)"
    }, [createVNode("rect", {
      "x": "1621.2",
      "y": "1370.57",
      "width": "57.735",
      "height": "5.947",
      "style": {
        fill: "rgb(106, 161, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,307.505,398.492)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,310.507,396.759)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,313.509,395.025)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,316.512,393.292)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,319.514,391.558)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.384532,-0.222009,0.444019,0.256354,-0.569781,171.832)"
    }, [createVNode("clipPath", {
      "id": "_clip6"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z"
    }, null)]), createVNode("g", {
      "clipPath": "url(#_clip6)"
    }, [createVNode("g", {
      "transform": "matrix(1.30028,1.12608,-2.25216,1.95042,12.6215,1078.27)"
    }, [createVNode("use", {
      "href": "#_Image7",
      "x": "50.54",
      "y": "31.563",
      "width": "112.406px",
      "height": "64.897px",
      "transform": "matrix(0.99474,0,0,0.998422,0,0)"
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.361496,-0.20871,0.41742,0.240997,34.7805,192.055)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fill: "rgb(0, 85, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.341853,-0.197369,0.394738,0.227902,64.9247,211.052)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fill: "rgb(29, 105, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.428916,0,0,0.428916,19.0588,282.943)"
    }, [createVNode("clipPath", {
      "id": "_clip8"
    }, [createVNode("path", {
      "d": "M1461.07,528.445C1461.07,530.876 1459.6,533.196 1456.6,534.928L1342.04,601.072C1335.41,604.896 1323.83,604.415 1316.18,600L1205.33,536C1201.14,533.585 1199,530.489 1199,527.555L1199,559.555C1199,562.489 1201.14,565.585 1205.33,568L1316.18,632C1323.83,636.415 1335.41,636.896 1342.04,633.072L1456.6,566.928C1459.6,565.196 1461.07,562.876 1461.07,560.445L1461.07,528.445Z"
    }, null)]), createVNode("g", {
      "clipPath": "url(#_clip8)"
    }, [createVNode("g", {
      "transform": "matrix(2.33146,-0,-0,2.33146,1081.79,378.876)"
    }, [createVNode("use", {
      "href": "#_Image2",
      "x": "50.54",
      "y": "64.644",
      "width": "112.406px",
      "height": "46.365px",
      "transform": "matrix(0.99474,0,0,0.98649,0,0)"
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,218.434)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,221.437)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.347769,0.200785,3.44852e-18,0.545466,52.0929,224.439)"
    }, [createVNode("path", {
      "d": "M1480.33,34.813C1480.33,34.162 1479.7,33.634 1478.94,33.634L1396.27,33.634C1395.5,33.634 1394.88,34.162 1394.88,34.813C1394.88,35.464 1395.5,35.993 1396.27,35.993L1478.94,35.993C1479.7,35.993 1480.33,35.464 1480.33,34.813Z",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.360289,-0.208013,-4.39887e-18,0.576941,37.5847,77.2484)"
    }, [createVNode("rect", {
      "x": "1621.2",
      "y": "1370.57",
      "width": "57.735",
      "height": "5.947",
      "style": {
        fill: "rgb(106, 161, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,307.505,373.782)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "white"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,310.507,372.049)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,313.509,370.316)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,316.512,368.582)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.185726,-0.107229,-1.84168e-18,0.247635,319.514,366.849)"
    }, [createVNode("ellipse", {
      "cx": "1566.31",
      "cy": "1372.3",
      "rx": "4",
      "ry": "3.464",
      "style": {
        fill: "rgb(64, 128, 255)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.365442,-0.210988,0.421976,0.243628,28.7259,185.45)"
    }, [createVNode("clipPath", {
      "id": "_clip9"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z"
    }, null)]), createVNode("g", {
      "clipPath": "url(#_clip9)"
    }, [createVNode("g", {
      "transform": "matrix(1.36821,1.1849,-2.36981,2.05231,5.46929,1071.93)"
    }, [createVNode("use", {
      "href": "#_Image10",
      "x": "53.151",
      "y": "30.14",
      "width": "106.825px",
      "height": "61.676px",
      "transform": "matrix(0.998367,0,0,0.994768,0,0)"
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.365442,-0.210988,0.421976,0.243628,28.7259,183.729)"
    }, [createVNode("path", {
      "d": "M84.299,1269.38C84.299,1261.99 78.301,1256 70.913,1256L-56.874,1256C-64.261,1256 -70.259,1261.99 -70.259,1269.38L-70.259,1376.46C-70.259,1383.85 -64.261,1389.85 -56.874,1389.85L70.913,1389.85C78.301,1389.85 84.299,1383.85 84.299,1376.46L84.299,1269.38Z",
      "style": {
        fill: "url(#_Linear11)"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.407622,0,0,0.407622,47.38,278)"
    }, [createVNode("clipPath", {
      "id": "_clip12"
    }, [createVNode("path", {
      "d": "M1461.07,554.317C1461.07,556.747 1459.6,559.067 1456.6,560.8L1342.04,626.943C1335.41,630.767 1323.83,630.287 1316.18,625.871L1205.33,561.871C1201.14,559.456 1199,556.361 1199,553.426L1199,559.555C1199,562.489 1201.14,565.585 1205.33,568L1316.18,632C1323.83,636.415 1335.41,636.896 1342.04,633.072L1456.6,566.928C1459.6,565.196 1461.07,562.876 1461.07,560.445L1461.07,554.317Z"
    }, null)]), createVNode("g", {
      "clipPath": "url(#_clip12)"
    }, [createVNode("g", {
      "transform": "matrix(2.45325,-0,-0,2.45325,1068.82,410.793)"
    }, [createVNode("use", {
      "href": "#_Image13",
      "x": "53.151",
      "y": "58.978",
      "width": "106.825px",
      "height": "33.517px",
      "transform": "matrix(0.998367,0,0,0.985808,0,0)"
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.371452,-0.214458,2.38096e-17,0.495269,-19.3677,248.256)"
    }, [createVNode("clipPath", {
      "id": "_clip14"
    }, [createVNode("path", {
      "d": "M1776.14,1326C1776.14,1321.19 1772.23,1317.28 1767.42,1317.28L1684.19,1317.28C1679.38,1317.28 1675.47,1321.19 1675.47,1326L1675.47,1395.75C1675.47,1400.56 1679.38,1404.46 1684.19,1404.46L1767.42,1404.46C1772.23,1404.46 1776.14,1400.56 1776.14,1395.75L1776.14,1326Z"
    }, null)]), createVNode("g", {
      "clipPath": "url(#_clip14)"
    }, [createVNode("g", {
      "transform": "matrix(2.69214,1.16573,-1.29422e-16,2.0191,1352.59,983.841)"
    }, [createVNode("use", {
      "href": "#_Image15",
      "x": "121.882",
      "y": "76.034",
      "width": "37.393px",
      "height": "61.803px",
      "transform": "matrix(0.984021,0,0,0.996825,0,0)"
    }, null)])])]), createVNode("g", {
      "transform": "matrix(0.371452,-0.214458,2.38096e-17,0.495269,-15.0786,249.972)"
    }, [createVNode("path", {
      "d": "M1776.14,1326C1776.14,1321.19 1772.23,1317.28 1767.42,1317.28L1684.19,1317.28C1679.38,1317.28 1675.47,1321.19 1675.47,1326L1675.47,1395.75C1675.47,1400.56 1679.38,1404.46 1684.19,1404.46L1767.42,1404.46C1772.23,1404.46 1776.14,1400.56 1776.14,1395.75L1776.14,1326Z",
      "style": {
        fill: "white",
        stopOpacity: 0.9
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.220199,-0.127132,1.41145e-17,0.293599,339.708,327.53)"
    }, [createVNode("path", {
      "d": "M1306.5,1286.73C1307.09,1285.72 1308.6,1285.48 1310.36,1286.12C1312.13,1286.76 1313.84,1288.16 1314.73,1289.7C1326.44,1309.98 1355.4,1360.15 1363.73,1374.57C1364.33,1375.61 1364.49,1376.61 1364.18,1377.35C1363.87,1378.09 1363.11,1378.5 1362.07,1378.5C1346.41,1378.5 1288.17,1378.5 1264.07,1378.5C1262.42,1378.5 1260.37,1377.48 1258.9,1375.94C1257.44,1374.41 1256.88,1372.67 1257.5,1371.6C1268.1,1353.25 1296.8,1303.53 1306.5,1286.73Z",
      "style": {
        fill: "rgb(245, 63, 63) ;fill-opacity:0.9"
      }
    }, null)]), createVNode("g", {
      "transform": "matrix(0.254264,-0.1468,1.22235e-17,0.254264,329.57,364.144)"
    }, [createVNode("text", {
      "x": "1170.88px",
      "y": "1451.42px",
      "style": {
        fontFamily: "NunitoSans-Bold, Nunito Sans",
        fontWeight: 700,
        fontSize: 41.569,
        fill: "white",
        fillOpacity: 0.9
      }
    }, [createTextVNode("!")])])])]), createVNode("defs", null, [createVNode("image", {
      "id": "_Image2",
      "width": "113px",
      "height": "47px",
      "href": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHEAAAAvCAYAAADU+iVXAAAACXBIWXMAAA7EAAAOxAGVKw4bAAABVUlEQVR4nO2aQRKCMAxFxUN4O+9/DNw4CoiTliZN8vPfQlm00ykvP3aQ5fFc11sjy/L+/nx8r3ffm7Fn845jz+aJa23XOJvfs9Zh7NBawv3YrSGtdbj+x10egkFzpRrNt+SSxMgbqkiZJCJDiQDoSmSfdYFJ3JD18GMmcXhDTHUzNZIIXhA1JIJDib0MptqiKbhKzHqQiAaT6IlSFVIiAJQIACUGpLfLhpfIw49Ml8T2v4/JTPySyIJQI3w7JTIYEp2fong3FXWJ3huqCEYSNUlYhZRoyaSCoEQAKHESlqF0kZj9NBgNJhEASgSAEgNx9WfCTmLxpygzYRIBmCORsTIlXxJZED/kk0h+KC1x9E2FKG86qEkMsh8/HG9A6SSGYqAIKDEinUIpUSDDYXiqxAw3JCNMIgDXJTIWYdBJIvukK2ynARit4XASUZ6izCScRFWKCH0BfLM84oTw1Z8AAAAASUVORK5CYII="
    }, null), createVNode("image", {
      "id": "_Image4",
      "width": "113px",
      "height": "65px",
      "href": "data:image/png;base64,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"
    }, null), createVNode("image", {
      "id": "_Image7",
      "width": "113px",
      "height": "65px",
      "href": "data:image/png;base64,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"
    }, null), createVNode("image", {
      "id": "_Image10",
      "width": "107px",
      "height": "62px",
      "href": "data:image/png;base64,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"
    }, null), createVNode("linearGradient", {
      "id": "_Linear11",
      "x1": "0",
      "y1": "0",
      "x2": "1",
      "y2": "0",
      "gradientUnits": "userSpaceOnUse",
      "gradientTransform": "matrix(-118.47,-106.79,210.785,-180.125,69.2121,1372.7)"
    }, [createVNode("stop", {
      "offset": "0",
      "style": {
        stopColor: "rgb(64, 128, 255)",
        stopOpacity: 1
      }
    }, null), createVNode("stop", {
      "offset": "1",
      "style": {
        stopColor: "rgb(64, 128, 255)",
        stopOpacity: 1
      }
    }, null)]), createVNode("image", {
      "id": "_Image13",
      "width": "107px",
      "height": "34px",
      "href": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGsAAAAiCAYAAABY6CeoAAAACXBIWXMAAA7EAAAOxAGVKw4bAAABFElEQVRoge2aQRKDMAhFmx6it/P+x7Ab64xOmaAG8vnwFnWhiOGFOG3TPsu6vpS0djpuH61zXoz5F3s6r4rRxipiftddeUbp3t18QozEu3/JfdSzgCy5VWpTWcVYSlaPqcvDEUpZQPUdCqUsSAbMoJIViJIVCBNZrO+MHtbjrs4KRMkKBJUs9uXXTxZ7JR2g6ix27sly6BIxReIOHdpZWevoNe68y2DAmTVXFmDBAB9pJ29nBYRCln5jgkVyv1QUsrIAJyvtvg1F7iGykF/KlniPG66zKDCyWLI2IqwOJSsQz2URbqZEpTorEDCypn6xnciVYT+SlbS+08Zt01lJfv7xBmYZLPpgy6p/pA9gyxIArKMLXxexLNiBCThLAAAAAElFTkSuQmCC"
    }, null), createVNode("image", {
      "id": "_Image15",
      "width": "38px",
      "height": "62px",
      "href": "data:image/png;base64,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"
    }, null)])]);
  }
});
const RESULT_STATUS = ["info", "success", "warning", "error", "403", "404", "500", null];
const _sfc_main$f = defineComponent({
  name: "Result",
  components: {
    IconInfo,
    IconCheck,
    IconExclamation,
    IconClose,
    ResultForbidden,
    ResultNotFound,
    ResultServerError
  },
  props: {
    status: {
      type: String,
      default: "info",
      validator: (value) => {
        return RESULT_STATUS.includes(value);
      }
    },
    title: String,
    subtitle: String
  },
  setup() {
    const prefixCls = getPrefixCls("result");
    return {
      prefixCls
    };
  }
});
function _sfc_render$7(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info = resolveComponent("icon-info");
  const _component_icon_check = resolveComponent("icon-check");
  const _component_icon_exclamation = resolveComponent("icon-exclamation");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_result_forbidden = resolveComponent("result-forbidden");
  const _component_result_not_found = resolveComponent("result-not-found");
  const _component_result_server_error = resolveComponent("result-server-error");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [createBaseVNode("div", {
    class: normalizeClass([`${_ctx.prefixCls}-icon`, {
      [`${_ctx.prefixCls}-icon-${_ctx.status}`]: _ctx.status,
      [`${_ctx.prefixCls}-icon-custom`]: _ctx.status === null
    }])
  }, [createBaseVNode("div", {
    class: normalizeClass(`${_ctx.prefixCls}-icon-tip`)
  }, [renderSlot(_ctx.$slots, "icon", {}, () => [_ctx.status === "info" ? (openBlock(), createBlock(_component_icon_info, {
    key: 0
  })) : _ctx.status === "success" ? (openBlock(), createBlock(_component_icon_check, {
    key: 1
  })) : _ctx.status === "warning" ? (openBlock(), createBlock(_component_icon_exclamation, {
    key: 2
  })) : _ctx.status === "error" ? (openBlock(), createBlock(_component_icon_close, {
    key: 3
  })) : _ctx.status === "403" ? (openBlock(), createBlock(_component_result_forbidden, {
    key: 4
  })) : _ctx.status === "404" ? (openBlock(), createBlock(_component_result_not_found, {
    key: 5
  })) : _ctx.status === "500" ? (openBlock(), createBlock(_component_result_server_error, {
    key: 6
  })) : createCommentVNode("v-if", true)])], 2)], 2), _ctx.title || _ctx.$slots.title ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-title`)
  }, [renderSlot(_ctx.$slots, "title", {}, () => [createTextVNode(toDisplayString$1(_ctx.title), 1)])], 2)) : createCommentVNode("v-if", true), _ctx.subtitle || _ctx.$slots.subtitle ? (openBlock(), createElementBlock("div", {
    key: 1,
    class: normalizeClass(`${_ctx.prefixCls}-subtitle`)
  }, [renderSlot(_ctx.$slots, "subtitle", {}, () => [createTextVNode(toDisplayString$1(_ctx.subtitle), 1)])], 2)) : createCommentVNode("v-if", true), _ctx.$slots.extra ? (openBlock(), createElementBlock("div", {
    key: 2,
    class: normalizeClass(`${_ctx.prefixCls}-extra`)
  }, [renderSlot(_ctx.$slots, "extra")], 2)) : createCommentVNode("v-if", true), _ctx.$slots.default ? (openBlock(), createElementBlock("div", {
    key: 3,
    class: normalizeClass(`${_ctx.prefixCls}-content`)
  }, [renderSlot(_ctx.$slots, "default")], 2)) : createCommentVNode("v-if", true)], 2);
}
var _Result = /* @__PURE__ */ _export_sfc$1(_sfc_main$f, [["render", _sfc_render$7]]);
const Result = Object.assign(_Result, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Result.name, _Result);
  }
});
const _sfc_main$e = defineComponent({
  name: "Skeleton",
  props: {
    loading: {
      type: Boolean,
      default: true
    },
    animation: {
      type: Boolean,
      default: false
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("skeleton");
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-animation`]: props.animation
    }]);
    return {
      prefixCls,
      cls
    };
  }
});
function _sfc_render$6(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [_ctx.loading ? renderSlot(_ctx.$slots, "default", {
    key: 0
  }) : renderSlot(_ctx.$slots, "content", {
    key: 1
  })], 2);
}
var _Skeleton = /* @__PURE__ */ _export_sfc$1(_sfc_main$e, [["render", _sfc_render$6]]);
const _sfc_main$d = defineComponent({
  name: "SkeletonLine",
  props: {
    rows: {
      type: Number,
      default: 1
    },
    widths: {
      type: Array,
      default: () => []
    },
    lineHeight: {
      type: Number,
      default: 20
    },
    lineSpacing: {
      type: Number,
      default: 15
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("skeleton-line");
    const lines = [];
    for (let i2 = 0; i2 < props.rows; i2++) {
      const style2 = {};
      if (isNumber$2(props.widths[i2])) {
        style2.width = `${props.widths[i2]}px`;
      } else if (isString$3(props.widths[i2])) {
        style2.width = String(props.widths[i2]);
      }
      style2.height = `${props.lineHeight}px`;
      if (i2 > 0) {
        style2.marginTop = `${props.lineSpacing}px`;
      }
      lines.push(style2);
    }
    return {
      prefixCls,
      lines
    };
  }
});
function _sfc_render$5(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.lines, (style2, index2) => {
    return openBlock(), createElementBlock("ul", {
      key: index2,
      class: normalizeClass(_ctx.prefixCls)
    }, [createBaseVNode("li", {
      class: normalizeClass(`${_ctx.prefixCls}-row`),
      style: normalizeStyle$1(style2)
    }, null, 6)], 2);
  }), 128);
}
var SkeletonLine = /* @__PURE__ */ _export_sfc$1(_sfc_main$d, [["render", _sfc_render$5]]);
const _sfc_main$c = defineComponent({
  name: "SkeletonShape",
  props: {
    shape: {
      type: String,
      default: "square"
    },
    size: {
      type: String,
      default: "medium"
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("skeleton-shape");
    const cls = computed(() => [prefixCls, `${prefixCls}-${props.shape}`, `${prefixCls}-${props.size}`]);
    return {
      prefixCls,
      cls
    };
  }
});
function _sfc_render$4(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, null, 2);
}
var SkeletonShape = /* @__PURE__ */ _export_sfc$1(_sfc_main$c, [["render", _sfc_render$4]]);
const Skeleton = Object.assign(_Skeleton, {
  Line: SkeletonLine,
  Shape: SkeletonShape,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Skeleton.name, _Skeleton);
    app.component(componentPrefix + SkeletonLine.name, SkeletonLine);
    app.component(componentPrefix + SkeletonShape.name, SkeletonShape);
  }
});
var _Space = defineComponent({
  name: "Space",
  props: {
    align: {
      type: String
    },
    direction: {
      type: String,
      default: "horizontal"
    },
    size: {
      type: [Number, String, Array],
      default: "small"
    },
    wrap: {
      type: Boolean
    },
    fill: {
      type: Boolean
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("space");
    const mergedAlign = computed(() => {
      var _a2;
      return (_a2 = props.align) != null ? _a2 : props.direction === "horizontal" ? "center" : "";
    });
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-${props.direction}`]: props.direction,
      [`${prefixCls}-align-${mergedAlign.value}`]: mergedAlign.value,
      [`${prefixCls}-wrap`]: props.wrap,
      [`${prefixCls}-fill`]: props.fill
    }]);
    function getMargin(size2) {
      if (isNumber$2(size2)) {
        return size2;
      }
      switch (size2) {
        case "mini":
          return 4;
        case "small":
          return 8;
        case "medium":
          return 16;
        case "large":
          return 24;
        default:
          return 8;
      }
    }
    const getMarginStyle = (isLast) => {
      const style2 = {};
      const marginRight = `${getMargin(isArray$4(props.size) ? props.size[0] : props.size)}px`;
      const marginBottom = `${getMargin(isArray$4(props.size) ? props.size[1] : props.size)}px`;
      if (isLast) {
        return props.wrap ? {
          marginBottom
        } : {};
      }
      if (props.direction === "horizontal") {
        style2.marginRight = marginRight;
      }
      if (props.direction === "vertical" || props.wrap) {
        style2.marginBottom = marginBottom;
      }
      return style2;
    };
    return () => {
      var _a2;
      const children = getAllElements((_a2 = slots.default) == null ? void 0 : _a2.call(slots), true).filter((item) => item.type !== Comment);
      return createVNode("div", {
        "class": cls.value
      }, [children.map((child, index2) => {
        var _a22, _b2;
        const shouldRenderSplit = slots.split && index2 > 0;
        return createVNode(Fragment, {
          "key": (_a22 = child.key) != null ? _a22 : `item-${index2}`
        }, [shouldRenderSplit && createVNode("div", {
          "class": `${prefixCls}-item-split`,
          "style": getMarginStyle(false)
        }, [(_b2 = slots.split) == null ? void 0 : _b2.call(slots)]), createVNode("div", {
          "class": `${prefixCls}-item`,
          "style": getMarginStyle(index2 === children.length - 1)
        }, [child])]);
      })]);
    };
  }
});
const Space = Object.assign(_Space, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Space.name, _Space);
  }
});
const _sfc_main$b = defineComponent({
  name: "IconDelete",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-delete`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$7 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$6 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M5 11h5.5m0 0v29a1 1 0 0 0 1 1h25a1 1 0 0 0 1-1V11m-27 0H16m21.5 0H43m-5.5 0H32m-16 0V7h16v4m-16 0h16M20 18v15m8-15v15"
}, null, -1);
const _hoisted_3$5 = [_hoisted_2$6];
function _sfc_render$3(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$5, 14, _hoisted_1$7);
}
var _IconDelete = /* @__PURE__ */ _export_sfc$1(_sfc_main$b, [["render", _sfc_render$3]]);
const IconDelete = Object.assign(_IconDelete, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconDelete.name, _IconDelete);
  }
});
const index$r = "";
const index$q = "";
const index$p = "";
const index$o = "";
const index$n = "";
const index$m = "";
const icon = "" + new URL("icon-d93af2f8.png", import.meta.url).href;
/*!
  * vue-router v4.2.0
  * (c) 2023 Eduardo San Martin Morote
  * @license MIT
  */
const isBrowser = typeof window !== "undefined";
function isESModule(obj) {
  return obj.__esModule || obj[Symbol.toStringTag] === "Module";
}
const assign$1 = Object.assign;
function applyToParams(fn, params) {
  const newParams = {};
  for (const key in params) {
    const value = params[key];
    newParams[key] = isArray$2(value) ? value.map(fn) : fn(value);
  }
  return newParams;
}
const noop$1 = () => {
};
const isArray$2 = Array.isArray;
const TRAILING_SLASH_RE = /\/$/;
const removeTrailingSlash = (path) => path.replace(TRAILING_SLASH_RE, "");
function parseURL(parseQuery2, location2, currentLocation = "/") {
  let path, query = {}, searchString = "", hash = "";
  const hashPos = location2.indexOf("#");
  let searchPos = location2.indexOf("?");
  if (hashPos < searchPos && hashPos >= 0) {
    searchPos = -1;
  }
  if (searchPos > -1) {
    path = location2.slice(0, searchPos);
    searchString = location2.slice(searchPos + 1, hashPos > -1 ? hashPos : location2.length);
    query = parseQuery2(searchString);
  }
  if (hashPos > -1) {
    path = path || location2.slice(0, hashPos);
    hash = location2.slice(hashPos, location2.length);
  }
  path = resolveRelativePath(path != null ? path : location2, currentLocation);
  return {
    fullPath: path + (searchString && "?") + searchString + hash,
    path,
    query,
    hash
  };
}
function stringifyURL(stringifyQuery2, location2) {
  const query = location2.query ? stringifyQuery2(location2.query) : "";
  return location2.path + (query && "?") + query + (location2.hash || "");
}
function stripBase(pathname, base2) {
  if (!base2 || !pathname.toLowerCase().startsWith(base2.toLowerCase()))
    return pathname;
  return pathname.slice(base2.length) || "/";
}
function isSameRouteLocation(stringifyQuery2, a, b2) {
  const aLastIndex = a.matched.length - 1;
  const bLastIndex = b2.matched.length - 1;
  return aLastIndex > -1 && aLastIndex === bLastIndex && isSameRouteRecord(a.matched[aLastIndex], b2.matched[bLastIndex]) && isSameRouteLocationParams(a.params, b2.params) && stringifyQuery2(a.query) === stringifyQuery2(b2.query) && a.hash === b2.hash;
}
function isSameRouteRecord(a, b2) {
  return (a.aliasOf || a) === (b2.aliasOf || b2);
}
function isSameRouteLocationParams(a, b2) {
  if (Object.keys(a).length !== Object.keys(b2).length)
    return false;
  for (const key in a) {
    if (!isSameRouteLocationParamsValue(a[key], b2[key]))
      return false;
  }
  return true;
}
function isSameRouteLocationParamsValue(a, b2) {
  return isArray$2(a) ? isEquivalentArray(a, b2) : isArray$2(b2) ? isEquivalentArray(b2, a) : a === b2;
}
function isEquivalentArray(a, b2) {
  return isArray$2(b2) ? a.length === b2.length && a.every((value, i2) => value === b2[i2]) : a.length === 1 && a[0] === b2;
}
function resolveRelativePath(to, from) {
  if (to.startsWith("/"))
    return to;
  if (!to)
    return from;
  const fromSegments = from.split("/");
  const toSegments = to.split("/");
  const lastToSegment = toSegments[toSegments.length - 1];
  if (lastToSegment === ".." || lastToSegment === ".") {
    toSegments.push("");
  }
  let position = fromSegments.length - 1;
  let toPosition;
  let segment;
  for (toPosition = 0; toPosition < toSegments.length; toPosition++) {
    segment = toSegments[toPosition];
    if (segment === ".")
      continue;
    if (segment === "..") {
      if (position > 1)
        position--;
    } else
      break;
  }
  return fromSegments.slice(0, position).join("/") + "/" + toSegments.slice(toPosition - (toPosition === toSegments.length ? 1 : 0)).join("/");
}
var NavigationType;
(function(NavigationType2) {
  NavigationType2["pop"] = "pop";
  NavigationType2["push"] = "push";
})(NavigationType || (NavigationType = {}));
var NavigationDirection;
(function(NavigationDirection2) {
  NavigationDirection2["back"] = "back";
  NavigationDirection2["forward"] = "forward";
  NavigationDirection2["unknown"] = "";
})(NavigationDirection || (NavigationDirection = {}));
function normalizeBase(base2) {
  if (!base2) {
    if (isBrowser) {
      const baseEl = document.querySelector("base");
      base2 = baseEl && baseEl.getAttribute("href") || "/";
      base2 = base2.replace(/^\w+:\/\/[^\/]+/, "");
    } else {
      base2 = "/";
    }
  }
  if (base2[0] !== "/" && base2[0] !== "#")
    base2 = "/" + base2;
  return removeTrailingSlash(base2);
}
const BEFORE_HASH_RE = /^[^#]+#/;
function createHref(base2, location2) {
  return base2.replace(BEFORE_HASH_RE, "#") + location2;
}
function getElementPosition(el, offset) {
  const docRect = document.documentElement.getBoundingClientRect();
  const elRect = el.getBoundingClientRect();
  return {
    behavior: offset.behavior,
    left: elRect.left - docRect.left - (offset.left || 0),
    top: elRect.top - docRect.top - (offset.top || 0)
  };
}
const computeScrollPosition = () => ({
  left: window.pageXOffset,
  top: window.pageYOffset
});
function scrollToPosition(position) {
  let scrollToOptions;
  if ("el" in position) {
    const positionEl = position.el;
    const isIdSelector = typeof positionEl === "string" && positionEl.startsWith("#");
    const el = typeof positionEl === "string" ? isIdSelector ? document.getElementById(positionEl.slice(1)) : document.querySelector(positionEl) : positionEl;
    if (!el) {
      return;
    }
    scrollToOptions = getElementPosition(el, position);
  } else {
    scrollToOptions = position;
  }
  if ("scrollBehavior" in document.documentElement.style)
    window.scrollTo(scrollToOptions);
  else {
    window.scrollTo(scrollToOptions.left != null ? scrollToOptions.left : window.pageXOffset, scrollToOptions.top != null ? scrollToOptions.top : window.pageYOffset);
  }
}
function getScrollKey(path, delta) {
  const position = history.state ? history.state.position - delta : -1;
  return position + path;
}
const scrollPositions = /* @__PURE__ */ new Map();
function saveScrollPosition(key, scrollPosition) {
  scrollPositions.set(key, scrollPosition);
}
function getSavedScrollPosition(key) {
  const scroll = scrollPositions.get(key);
  scrollPositions.delete(key);
  return scroll;
}
let createBaseLocation = () => location.protocol + "//" + location.host;
function createCurrentLocation(base2, location2) {
  const { pathname, search, hash } = location2;
  const hashPos = base2.indexOf("#");
  if (hashPos > -1) {
    let slicePos = hash.includes(base2.slice(hashPos)) ? base2.slice(hashPos).length : 1;
    let pathFromHash = hash.slice(slicePos);
    if (pathFromHash[0] !== "/")
      pathFromHash = "/" + pathFromHash;
    return stripBase(pathFromHash, "");
  }
  const path = stripBase(pathname, base2);
  return path + search + hash;
}
function useHistoryListeners(base2, historyState, currentLocation, replace) {
  let listeners = [];
  let teardowns = [];
  let pauseState = null;
  const popStateHandler = ({ state }) => {
    const to = createCurrentLocation(base2, location);
    const from = currentLocation.value;
    const fromState = historyState.value;
    let delta = 0;
    if (state) {
      currentLocation.value = to;
      historyState.value = state;
      if (pauseState && pauseState === from) {
        pauseState = null;
        return;
      }
      delta = fromState ? state.position - fromState.position : 0;
    } else {
      replace(to);
    }
    listeners.forEach((listener) => {
      listener(currentLocation.value, from, {
        delta,
        type: NavigationType.pop,
        direction: delta ? delta > 0 ? NavigationDirection.forward : NavigationDirection.back : NavigationDirection.unknown
      });
    });
  };
  function pauseListeners() {
    pauseState = currentLocation.value;
  }
  function listen(callback) {
    listeners.push(callback);
    const teardown = () => {
      const index2 = listeners.indexOf(callback);
      if (index2 > -1)
        listeners.splice(index2, 1);
    };
    teardowns.push(teardown);
    return teardown;
  }
  function beforeUnloadListener() {
    const { history: history2 } = window;
    if (!history2.state)
      return;
    history2.replaceState(assign$1({}, history2.state, { scroll: computeScrollPosition() }), "");
  }
  function destroy() {
    for (const teardown of teardowns)
      teardown();
    teardowns = [];
    window.removeEventListener("popstate", popStateHandler);
    window.removeEventListener("beforeunload", beforeUnloadListener);
  }
  window.addEventListener("popstate", popStateHandler);
  window.addEventListener("beforeunload", beforeUnloadListener, {
    passive: true
  });
  return {
    pauseListeners,
    listen,
    destroy
  };
}
function buildState(back, current, forward, replaced = false, computeScroll = false) {
  return {
    back,
    current,
    forward,
    replaced,
    position: window.history.length,
    scroll: computeScroll ? computeScrollPosition() : null
  };
}
function useHistoryStateNavigation(base2) {
  const { history: history2, location: location2 } = window;
  const currentLocation = {
    value: createCurrentLocation(base2, location2)
  };
  const historyState = { value: history2.state };
  if (!historyState.value) {
    changeLocation(currentLocation.value, {
      back: null,
      current: currentLocation.value,
      forward: null,
      // the length is off by one, we need to decrease it
      position: history2.length - 1,
      replaced: true,
      // don't add a scroll as the user may have an anchor, and we want
      // scrollBehavior to be triggered without a saved position
      scroll: null
    }, true);
  }
  function changeLocation(to, state, replace2) {
    const hashIndex = base2.indexOf("#");
    const url = hashIndex > -1 ? (location2.host && document.querySelector("base") ? base2 : base2.slice(hashIndex)) + to : createBaseLocation() + base2 + to;
    try {
      history2[replace2 ? "replaceState" : "pushState"](state, "", url);
      historyState.value = state;
    } catch (err) {
      {
        console.error(err);
      }
      location2[replace2 ? "replace" : "assign"](url);
    }
  }
  function replace(to, data) {
    const state = assign$1({}, history2.state, buildState(
      historyState.value.back,
      // keep back and forward entries but override current position
      to,
      historyState.value.forward,
      true
    ), data, { position: historyState.value.position });
    changeLocation(to, state, true);
    currentLocation.value = to;
  }
  function push(to, data) {
    const currentState = assign$1(
      {},
      // use current history state to gracefully handle a wrong call to
      // history.replaceState
      // https://github.com/vuejs/router/issues/366
      historyState.value,
      history2.state,
      {
        forward: to,
        scroll: computeScrollPosition()
      }
    );
    changeLocation(currentState.current, currentState, true);
    const state = assign$1({}, buildState(currentLocation.value, to, null), { position: currentState.position + 1 }, data);
    changeLocation(to, state, false);
    currentLocation.value = to;
  }
  return {
    location: currentLocation,
    state: historyState,
    push,
    replace
  };
}
function createWebHistory(base2) {
  base2 = normalizeBase(base2);
  const historyNavigation = useHistoryStateNavigation(base2);
  const historyListeners = useHistoryListeners(base2, historyNavigation.state, historyNavigation.location, historyNavigation.replace);
  function go(delta, triggerListeners = true) {
    if (!triggerListeners)
      historyListeners.pauseListeners();
    history.go(delta);
  }
  const routerHistory = assign$1({
    // it's overridden right after
    location: "",
    base: base2,
    go,
    createHref: createHref.bind(null, base2)
  }, historyNavigation, historyListeners);
  Object.defineProperty(routerHistory, "location", {
    enumerable: true,
    get: () => historyNavigation.location.value
  });
  Object.defineProperty(routerHistory, "state", {
    enumerable: true,
    get: () => historyNavigation.state.value
  });
  return routerHistory;
}
function createWebHashHistory(base2) {
  base2 = location.host ? base2 || location.pathname + location.search : "";
  if (!base2.includes("#"))
    base2 += "#";
  return createWebHistory(base2);
}
function isRouteLocation(route) {
  return typeof route === "string" || route && typeof route === "object";
}
function isRouteName(name) {
  return typeof name === "string" || typeof name === "symbol";
}
const START_LOCATION_NORMALIZED = {
  path: "/",
  name: void 0,
  params: {},
  query: {},
  hash: "",
  fullPath: "/",
  matched: [],
  meta: {},
  redirectedFrom: void 0
};
const NavigationFailureSymbol = Symbol("");
var NavigationFailureType;
(function(NavigationFailureType2) {
  NavigationFailureType2[NavigationFailureType2["aborted"] = 4] = "aborted";
  NavigationFailureType2[NavigationFailureType2["cancelled"] = 8] = "cancelled";
  NavigationFailureType2[NavigationFailureType2["duplicated"] = 16] = "duplicated";
})(NavigationFailureType || (NavigationFailureType = {}));
function createRouterError(type, params) {
  {
    return assign$1(new Error(), {
      type,
      [NavigationFailureSymbol]: true
    }, params);
  }
}
function isNavigationFailure(error, type) {
  return error instanceof Error && NavigationFailureSymbol in error && (type == null || !!(error.type & type));
}
const BASE_PARAM_PATTERN = "[^/]+?";
const BASE_PATH_PARSER_OPTIONS = {
  sensitive: false,
  strict: false,
  start: true,
  end: true
};
const REGEX_CHARS_RE = /[.+*?^${}()[\]/\\]/g;
function tokensToParser(segments, extraOptions) {
  const options = assign$1({}, BASE_PATH_PARSER_OPTIONS, extraOptions);
  const score = [];
  let pattern = options.start ? "^" : "";
  const keys2 = [];
  for (const segment of segments) {
    const segmentScores = segment.length ? [] : [
      90
      /* PathScore.Root */
    ];
    if (options.strict && !segment.length)
      pattern += "/";
    for (let tokenIndex = 0; tokenIndex < segment.length; tokenIndex++) {
      const token = segment[tokenIndex];
      let subSegmentScore = 40 + (options.sensitive ? 0.25 : 0);
      if (token.type === 0) {
        if (!tokenIndex)
          pattern += "/";
        pattern += token.value.replace(REGEX_CHARS_RE, "\\$&");
        subSegmentScore += 40;
      } else if (token.type === 1) {
        const { value, repeatable, optional, regexp: regexp2 } = token;
        keys2.push({
          name: value,
          repeatable,
          optional
        });
        const re2 = regexp2 ? regexp2 : BASE_PARAM_PATTERN;
        if (re2 !== BASE_PARAM_PATTERN) {
          subSegmentScore += 10;
          try {
            new RegExp(`(${re2})`);
          } catch (err) {
            throw new Error(`Invalid custom RegExp for param "${value}" (${re2}): ` + err.message);
          }
        }
        let subPattern = repeatable ? `((?:${re2})(?:/(?:${re2}))*)` : `(${re2})`;
        if (!tokenIndex)
          subPattern = // avoid an optional / if there are more segments e.g. /:p?-static
          // or /:p?-:p2
          optional && segment.length < 2 ? `(?:/${subPattern})` : "/" + subPattern;
        if (optional)
          subPattern += "?";
        pattern += subPattern;
        subSegmentScore += 20;
        if (optional)
          subSegmentScore += -8;
        if (repeatable)
          subSegmentScore += -20;
        if (re2 === ".*")
          subSegmentScore += -50;
      }
      segmentScores.push(subSegmentScore);
    }
    score.push(segmentScores);
  }
  if (options.strict && options.end) {
    const i2 = score.length - 1;
    score[i2][score[i2].length - 1] += 0.7000000000000001;
  }
  if (!options.strict)
    pattern += "/?";
  if (options.end)
    pattern += "$";
  else if (options.strict)
    pattern += "(?:/|$)";
  const re = new RegExp(pattern, options.sensitive ? "" : "i");
  function parse2(path) {
    const match = path.match(re);
    const params = {};
    if (!match)
      return null;
    for (let i2 = 1; i2 < match.length; i2++) {
      const value = match[i2] || "";
      const key = keys2[i2 - 1];
      params[key.name] = value && key.repeatable ? value.split("/") : value;
    }
    return params;
  }
  function stringify2(params) {
    let path = "";
    let avoidDuplicatedSlash = false;
    for (const segment of segments) {
      if (!avoidDuplicatedSlash || !path.endsWith("/"))
        path += "/";
      avoidDuplicatedSlash = false;
      for (const token of segment) {
        if (token.type === 0) {
          path += token.value;
        } else if (token.type === 1) {
          const { value, repeatable, optional } = token;
          const param = value in params ? params[value] : "";
          if (isArray$2(param) && !repeatable) {
            throw new Error(`Provided param "${value}" is an array but it is not repeatable (* or + modifiers)`);
          }
          const text = isArray$2(param) ? param.join("/") : param;
          if (!text) {
            if (optional) {
              if (segment.length < 2) {
                if (path.endsWith("/"))
                  path = path.slice(0, -1);
                else
                  avoidDuplicatedSlash = true;
              }
            } else
              throw new Error(`Missing required param "${value}"`);
          }
          path += text;
        }
      }
    }
    return path || "/";
  }
  return {
    re,
    score,
    keys: keys2,
    parse: parse2,
    stringify: stringify2
  };
}
function compareScoreArray(a, b2) {
  let i2 = 0;
  while (i2 < a.length && i2 < b2.length) {
    const diff = b2[i2] - a[i2];
    if (diff)
      return diff;
    i2++;
  }
  if (a.length < b2.length) {
    return a.length === 1 && a[0] === 40 + 40 ? -1 : 1;
  } else if (a.length > b2.length) {
    return b2.length === 1 && b2[0] === 40 + 40 ? 1 : -1;
  }
  return 0;
}
function comparePathParserScore(a, b2) {
  let i2 = 0;
  const aScore = a.score;
  const bScore = b2.score;
  while (i2 < aScore.length && i2 < bScore.length) {
    const comp = compareScoreArray(aScore[i2], bScore[i2]);
    if (comp)
      return comp;
    i2++;
  }
  if (Math.abs(bScore.length - aScore.length) === 1) {
    if (isLastScoreNegative(aScore))
      return 1;
    if (isLastScoreNegative(bScore))
      return -1;
  }
  return bScore.length - aScore.length;
}
function isLastScoreNegative(score) {
  const last = score[score.length - 1];
  return score.length > 0 && last[last.length - 1] < 0;
}
const ROOT_TOKEN = {
  type: 0,
  value: ""
};
const VALID_PARAM_RE = /[a-zA-Z0-9_]/;
function tokenizePath(path) {
  if (!path)
    return [[]];
  if (path === "/")
    return [[ROOT_TOKEN]];
  if (!path.startsWith("/")) {
    throw new Error(`Invalid path "${path}"`);
  }
  function crash(message2) {
    throw new Error(`ERR (${state})/"${buffer}": ${message2}`);
  }
  let state = 0;
  let previousState = state;
  const tokens = [];
  let segment;
  function finalizeSegment() {
    if (segment)
      tokens.push(segment);
    segment = [];
  }
  let i2 = 0;
  let char;
  let buffer = "";
  let customRe = "";
  function consumeBuffer() {
    if (!buffer)
      return;
    if (state === 0) {
      segment.push({
        type: 0,
        value: buffer
      });
    } else if (state === 1 || state === 2 || state === 3) {
      if (segment.length > 1 && (char === "*" || char === "+"))
        crash(`A repeatable param (${buffer}) must be alone in its segment. eg: '/:ids+.`);
      segment.push({
        type: 1,
        value: buffer,
        regexp: customRe,
        repeatable: char === "*" || char === "+",
        optional: char === "*" || char === "?"
      });
    } else {
      crash("Invalid state to consume buffer");
    }
    buffer = "";
  }
  function addCharToBuffer() {
    buffer += char;
  }
  while (i2 < path.length) {
    char = path[i2++];
    if (char === "\\" && state !== 2) {
      previousState = state;
      state = 4;
      continue;
    }
    switch (state) {
      case 0:
        if (char === "/") {
          if (buffer) {
            consumeBuffer();
          }
          finalizeSegment();
        } else if (char === ":") {
          consumeBuffer();
          state = 1;
        } else {
          addCharToBuffer();
        }
        break;
      case 4:
        addCharToBuffer();
        state = previousState;
        break;
      case 1:
        if (char === "(") {
          state = 2;
        } else if (VALID_PARAM_RE.test(char)) {
          addCharToBuffer();
        } else {
          consumeBuffer();
          state = 0;
          if (char !== "*" && char !== "?" && char !== "+")
            i2--;
        }
        break;
      case 2:
        if (char === ")") {
          if (customRe[customRe.length - 1] == "\\")
            customRe = customRe.slice(0, -1) + char;
          else
            state = 3;
        } else {
          customRe += char;
        }
        break;
      case 3:
        consumeBuffer();
        state = 0;
        if (char !== "*" && char !== "?" && char !== "+")
          i2--;
        customRe = "";
        break;
      default:
        crash("Unknown state");
        break;
    }
  }
  if (state === 2)
    crash(`Unfinished custom RegExp for param "${buffer}"`);
  consumeBuffer();
  finalizeSegment();
  return tokens;
}
function createRouteRecordMatcher(record, parent, options) {
  const parser = tokensToParser(tokenizePath(record.path), options);
  const matcher = assign$1(parser, {
    record,
    parent,
    // these needs to be populated by the parent
    children: [],
    alias: []
  });
  if (parent) {
    if (!matcher.record.aliasOf === !parent.record.aliasOf)
      parent.children.push(matcher);
  }
  return matcher;
}
function createRouterMatcher(routes2, globalOptions) {
  const matchers = [];
  const matcherMap = /* @__PURE__ */ new Map();
  globalOptions = mergeOptions({ strict: false, end: true, sensitive: false }, globalOptions);
  function getRecordMatcher(name) {
    return matcherMap.get(name);
  }
  function addRoute(record, parent, originalRecord) {
    const isRootAdd = !originalRecord;
    const mainNormalizedRecord = normalizeRouteRecord(record);
    mainNormalizedRecord.aliasOf = originalRecord && originalRecord.record;
    const options = mergeOptions(globalOptions, record);
    const normalizedRecords = [
      mainNormalizedRecord
    ];
    if ("alias" in record) {
      const aliases = typeof record.alias === "string" ? [record.alias] : record.alias;
      for (const alias of aliases) {
        normalizedRecords.push(assign$1({}, mainNormalizedRecord, {
          // this allows us to hold a copy of the `components` option
          // so that async components cache is hold on the original record
          components: originalRecord ? originalRecord.record.components : mainNormalizedRecord.components,
          path: alias,
          // we might be the child of an alias
          aliasOf: originalRecord ? originalRecord.record : mainNormalizedRecord
          // the aliases are always of the same kind as the original since they
          // are defined on the same record
        }));
      }
    }
    let matcher;
    let originalMatcher;
    for (const normalizedRecord of normalizedRecords) {
      const { path } = normalizedRecord;
      if (parent && path[0] !== "/") {
        const parentPath = parent.record.path;
        const connectingSlash = parentPath[parentPath.length - 1] === "/" ? "" : "/";
        normalizedRecord.path = parent.record.path + (path && connectingSlash + path);
      }
      matcher = createRouteRecordMatcher(normalizedRecord, parent, options);
      if (originalRecord) {
        originalRecord.alias.push(matcher);
      } else {
        originalMatcher = originalMatcher || matcher;
        if (originalMatcher !== matcher)
          originalMatcher.alias.push(matcher);
        if (isRootAdd && record.name && !isAliasRecord(matcher))
          removeRoute(record.name);
      }
      if (mainNormalizedRecord.children) {
        const children = mainNormalizedRecord.children;
        for (let i2 = 0; i2 < children.length; i2++) {
          addRoute(children[i2], matcher, originalRecord && originalRecord.children[i2]);
        }
      }
      originalRecord = originalRecord || matcher;
      if (matcher.record.components && Object.keys(matcher.record.components).length || matcher.record.name || matcher.record.redirect) {
        insertMatcher(matcher);
      }
    }
    return originalMatcher ? () => {
      removeRoute(originalMatcher);
    } : noop$1;
  }
  function removeRoute(matcherRef) {
    if (isRouteName(matcherRef)) {
      const matcher = matcherMap.get(matcherRef);
      if (matcher) {
        matcherMap.delete(matcherRef);
        matchers.splice(matchers.indexOf(matcher), 1);
        matcher.children.forEach(removeRoute);
        matcher.alias.forEach(removeRoute);
      }
    } else {
      const index2 = matchers.indexOf(matcherRef);
      if (index2 > -1) {
        matchers.splice(index2, 1);
        if (matcherRef.record.name)
          matcherMap.delete(matcherRef.record.name);
        matcherRef.children.forEach(removeRoute);
        matcherRef.alias.forEach(removeRoute);
      }
    }
  }
  function getRoutes() {
    return matchers;
  }
  function insertMatcher(matcher) {
    let i2 = 0;
    while (i2 < matchers.length && comparePathParserScore(matcher, matchers[i2]) >= 0 && // Adding children with empty path should still appear before the parent
    // https://github.com/vuejs/router/issues/1124
    (matcher.record.path !== matchers[i2].record.path || !isRecordChildOf(matcher, matchers[i2])))
      i2++;
    matchers.splice(i2, 0, matcher);
    if (matcher.record.name && !isAliasRecord(matcher))
      matcherMap.set(matcher.record.name, matcher);
  }
  function resolve2(location2, currentLocation) {
    let matcher;
    let params = {};
    let path;
    let name;
    if ("name" in location2 && location2.name) {
      matcher = matcherMap.get(location2.name);
      if (!matcher)
        throw createRouterError(1, {
          location: location2
        });
      name = matcher.record.name;
      params = assign$1(
        // paramsFromLocation is a new object
        paramsFromLocation(
          currentLocation.params,
          // only keep params that exist in the resolved location
          // TODO: only keep optional params coming from a parent record
          matcher.keys.filter((k) => !k.optional).map((k) => k.name)
        ),
        // discard any existing params in the current location that do not exist here
        // #1497 this ensures better active/exact matching
        location2.params && paramsFromLocation(location2.params, matcher.keys.map((k) => k.name))
      );
      path = matcher.stringify(params);
    } else if ("path" in location2) {
      path = location2.path;
      matcher = matchers.find((m2) => m2.re.test(path));
      if (matcher) {
        params = matcher.parse(path);
        name = matcher.record.name;
      }
    } else {
      matcher = currentLocation.name ? matcherMap.get(currentLocation.name) : matchers.find((m2) => m2.re.test(currentLocation.path));
      if (!matcher)
        throw createRouterError(1, {
          location: location2,
          currentLocation
        });
      name = matcher.record.name;
      params = assign$1({}, currentLocation.params, location2.params);
      path = matcher.stringify(params);
    }
    const matched = [];
    let parentMatcher = matcher;
    while (parentMatcher) {
      matched.unshift(parentMatcher.record);
      parentMatcher = parentMatcher.parent;
    }
    return {
      name,
      path,
      params,
      matched,
      meta: mergeMetaFields(matched)
    };
  }
  routes2.forEach((route) => addRoute(route));
  return { addRoute, resolve: resolve2, removeRoute, getRoutes, getRecordMatcher };
}
function paramsFromLocation(params, keys2) {
  const newParams = {};
  for (const key of keys2) {
    if (key in params)
      newParams[key] = params[key];
  }
  return newParams;
}
function normalizeRouteRecord(record) {
  return {
    path: record.path,
    redirect: record.redirect,
    name: record.name,
    meta: record.meta || {},
    aliasOf: void 0,
    beforeEnter: record.beforeEnter,
    props: normalizeRecordProps(record),
    children: record.children || [],
    instances: {},
    leaveGuards: /* @__PURE__ */ new Set(),
    updateGuards: /* @__PURE__ */ new Set(),
    enterCallbacks: {},
    components: "components" in record ? record.components || null : record.component && { default: record.component }
  };
}
function normalizeRecordProps(record) {
  const propsObject = {};
  const props = record.props || false;
  if ("component" in record) {
    propsObject.default = props;
  } else {
    for (const name in record.components)
      propsObject[name] = typeof props === "boolean" ? props : props[name];
  }
  return propsObject;
}
function isAliasRecord(record) {
  while (record) {
    if (record.record.aliasOf)
      return true;
    record = record.parent;
  }
  return false;
}
function mergeMetaFields(matched) {
  return matched.reduce((meta, record) => assign$1(meta, record.meta), {});
}
function mergeOptions(defaults2, partialOptions) {
  const options = {};
  for (const key in defaults2) {
    options[key] = key in partialOptions ? partialOptions[key] : defaults2[key];
  }
  return options;
}
function isRecordChildOf(record, parent) {
  return parent.children.some((child) => child === record || isRecordChildOf(record, child));
}
const HASH_RE = /#/g;
const AMPERSAND_RE = /&/g;
const SLASH_RE = /\//g;
const EQUAL_RE = /=/g;
const IM_RE = /\?/g;
const PLUS_RE = /\+/g;
const ENC_BRACKET_OPEN_RE = /%5B/g;
const ENC_BRACKET_CLOSE_RE = /%5D/g;
const ENC_CARET_RE = /%5E/g;
const ENC_BACKTICK_RE = /%60/g;
const ENC_CURLY_OPEN_RE = /%7B/g;
const ENC_PIPE_RE = /%7C/g;
const ENC_CURLY_CLOSE_RE = /%7D/g;
const ENC_SPACE_RE = /%20/g;
function commonEncode(text) {
  return encodeURI("" + text).replace(ENC_PIPE_RE, "|").replace(ENC_BRACKET_OPEN_RE, "[").replace(ENC_BRACKET_CLOSE_RE, "]");
}
function encodeHash(text) {
  return commonEncode(text).replace(ENC_CURLY_OPEN_RE, "{").replace(ENC_CURLY_CLOSE_RE, "}").replace(ENC_CARET_RE, "^");
}
function encodeQueryValue(text) {
  return commonEncode(text).replace(PLUS_RE, "%2B").replace(ENC_SPACE_RE, "+").replace(HASH_RE, "%23").replace(AMPERSAND_RE, "%26").replace(ENC_BACKTICK_RE, "`").replace(ENC_CURLY_OPEN_RE, "{").replace(ENC_CURLY_CLOSE_RE, "}").replace(ENC_CARET_RE, "^");
}
function encodeQueryKey(text) {
  return encodeQueryValue(text).replace(EQUAL_RE, "%3D");
}
function encodePath(text) {
  return commonEncode(text).replace(HASH_RE, "%23").replace(IM_RE, "%3F");
}
function encodeParam(text) {
  return text == null ? "" : encodePath(text).replace(SLASH_RE, "%2F");
}
function decode(text) {
  try {
    return decodeURIComponent("" + text);
  } catch (err) {
  }
  return "" + text;
}
function parseQuery(search) {
  const query = {};
  if (search === "" || search === "?")
    return query;
  const hasLeadingIM = search[0] === "?";
  const searchParams = (hasLeadingIM ? search.slice(1) : search).split("&");
  for (let i2 = 0; i2 < searchParams.length; ++i2) {
    const searchParam = searchParams[i2].replace(PLUS_RE, " ");
    const eqPos = searchParam.indexOf("=");
    const key = decode(eqPos < 0 ? searchParam : searchParam.slice(0, eqPos));
    const value = eqPos < 0 ? null : decode(searchParam.slice(eqPos + 1));
    if (key in query) {
      let currentValue = query[key];
      if (!isArray$2(currentValue)) {
        currentValue = query[key] = [currentValue];
      }
      currentValue.push(value);
    } else {
      query[key] = value;
    }
  }
  return query;
}
function stringifyQuery(query) {
  let search = "";
  for (let key in query) {
    const value = query[key];
    key = encodeQueryKey(key);
    if (value == null) {
      if (value !== void 0) {
        search += (search.length ? "&" : "") + key;
      }
      continue;
    }
    const values = isArray$2(value) ? value.map((v) => v && encodeQueryValue(v)) : [value && encodeQueryValue(value)];
    values.forEach((value2) => {
      if (value2 !== void 0) {
        search += (search.length ? "&" : "") + key;
        if (value2 != null)
          search += "=" + value2;
      }
    });
  }
  return search;
}
function normalizeQuery(query) {
  const normalizedQuery = {};
  for (const key in query) {
    const value = query[key];
    if (value !== void 0) {
      normalizedQuery[key] = isArray$2(value) ? value.map((v) => v == null ? null : "" + v) : value == null ? value : "" + value;
    }
  }
  return normalizedQuery;
}
const matchedRouteKey = Symbol("");
const viewDepthKey = Symbol("");
const routerKey = Symbol("");
const routeLocationKey = Symbol("");
const routerViewLocationKey = Symbol("");
function useCallbacks() {
  let handlers = [];
  function add2(handler) {
    handlers.push(handler);
    return () => {
      const i2 = handlers.indexOf(handler);
      if (i2 > -1)
        handlers.splice(i2, 1);
    };
  }
  function reset() {
    handlers = [];
  }
  return {
    add: add2,
    list: () => handlers,
    reset
  };
}
function guardToPromiseFn(guard, to, from, record, name) {
  const enterCallbackArray = record && // name is defined if record is because of the function overload
  (record.enterCallbacks[name] = record.enterCallbacks[name] || []);
  return () => new Promise((resolve2, reject) => {
    const next = (valid) => {
      if (valid === false) {
        reject(createRouterError(4, {
          from,
          to
        }));
      } else if (valid instanceof Error) {
        reject(valid);
      } else if (isRouteLocation(valid)) {
        reject(createRouterError(2, {
          from: to,
          to: valid
        }));
      } else {
        if (enterCallbackArray && // since enterCallbackArray is truthy, both record and name also are
        record.enterCallbacks[name] === enterCallbackArray && typeof valid === "function") {
          enterCallbackArray.push(valid);
        }
        resolve2();
      }
    };
    const guardReturn = guard.call(record && record.instances[name], to, from, next);
    let guardCall = Promise.resolve(guardReturn);
    if (guard.length < 3)
      guardCall = guardCall.then(next);
    guardCall.catch((err) => reject(err));
  });
}
function extractComponentsGuards(matched, guardType, to, from) {
  const guards = [];
  for (const record of matched) {
    for (const name in record.components) {
      let rawComponent = record.components[name];
      if (guardType !== "beforeRouteEnter" && !record.instances[name])
        continue;
      if (isRouteComponent(rawComponent)) {
        const options = rawComponent.__vccOpts || rawComponent;
        const guard = options[guardType];
        guard && guards.push(guardToPromiseFn(guard, to, from, record, name));
      } else {
        let componentPromise = rawComponent();
        guards.push(() => componentPromise.then((resolved) => {
          if (!resolved)
            return Promise.reject(new Error(`Couldn't resolve component "${name}" at "${record.path}"`));
          const resolvedComponent = isESModule(resolved) ? resolved.default : resolved;
          record.components[name] = resolvedComponent;
          const options = resolvedComponent.__vccOpts || resolvedComponent;
          const guard = options[guardType];
          return guard && guardToPromiseFn(guard, to, from, record, name)();
        }));
      }
    }
  }
  return guards;
}
function isRouteComponent(component) {
  return typeof component === "object" || "displayName" in component || "props" in component || "__vccOpts" in component;
}
function useLink(props) {
  const router2 = inject(routerKey);
  const currentRoute = inject(routeLocationKey);
  const route = computed(() => router2.resolve(unref(props.to)));
  const activeRecordIndex = computed(() => {
    const { matched } = route.value;
    const { length } = matched;
    const routeMatched = matched[length - 1];
    const currentMatched = currentRoute.matched;
    if (!routeMatched || !currentMatched.length)
      return -1;
    const index2 = currentMatched.findIndex(isSameRouteRecord.bind(null, routeMatched));
    if (index2 > -1)
      return index2;
    const parentRecordPath = getOriginalPath(matched[length - 2]);
    return (
      // we are dealing with nested routes
      length > 1 && // if the parent and matched route have the same path, this link is
      // referring to the empty child. Or we currently are on a different
      // child of the same parent
      getOriginalPath(routeMatched) === parentRecordPath && // avoid comparing the child with its parent
      currentMatched[currentMatched.length - 1].path !== parentRecordPath ? currentMatched.findIndex(isSameRouteRecord.bind(null, matched[length - 2])) : index2
    );
  });
  const isActive = computed(() => activeRecordIndex.value > -1 && includesParams(currentRoute.params, route.value.params));
  const isExactActive = computed(() => activeRecordIndex.value > -1 && activeRecordIndex.value === currentRoute.matched.length - 1 && isSameRouteLocationParams(currentRoute.params, route.value.params));
  function navigate(e2 = {}) {
    if (guardEvent(e2)) {
      return router2[unref(props.replace) ? "replace" : "push"](
        unref(props.to)
        // avoid uncaught errors are they are logged anyway
      ).catch(noop$1);
    }
    return Promise.resolve();
  }
  return {
    route,
    href: computed(() => route.value.href),
    isActive,
    isExactActive,
    navigate
  };
}
const RouterLinkImpl = /* @__PURE__ */ defineComponent({
  name: "RouterLink",
  compatConfig: { MODE: 3 },
  props: {
    to: {
      type: [String, Object],
      required: true
    },
    replace: Boolean,
    activeClass: String,
    // inactiveClass: String,
    exactActiveClass: String,
    custom: Boolean,
    ariaCurrentValue: {
      type: String,
      default: "page"
    }
  },
  useLink,
  setup(props, { slots }) {
    const link = reactive(useLink(props));
    const { options } = inject(routerKey);
    const elClass = computed(() => ({
      [getLinkClass(props.activeClass, options.linkActiveClass, "router-link-active")]: link.isActive,
      // [getLinkClass(
      //   props.inactiveClass,
      //   options.linkInactiveClass,
      //   'router-link-inactive'
      // )]: !link.isExactActive,
      [getLinkClass(props.exactActiveClass, options.linkExactActiveClass, "router-link-exact-active")]: link.isExactActive
    }));
    return () => {
      const children = slots.default && slots.default(link);
      return props.custom ? children : h("a", {
        "aria-current": link.isExactActive ? props.ariaCurrentValue : null,
        href: link.href,
        // this would override user added attrs but Vue will still add
        // the listener, so we end up triggering both
        onClick: link.navigate,
        class: elClass.value
      }, children);
    };
  }
});
const RouterLink = RouterLinkImpl;
function guardEvent(e2) {
  if (e2.metaKey || e2.altKey || e2.ctrlKey || e2.shiftKey)
    return;
  if (e2.defaultPrevented)
    return;
  if (e2.button !== void 0 && e2.button !== 0)
    return;
  if (e2.currentTarget && e2.currentTarget.getAttribute) {
    const target2 = e2.currentTarget.getAttribute("target");
    if (/\b_blank\b/i.test(target2))
      return;
  }
  if (e2.preventDefault)
    e2.preventDefault();
  return true;
}
function includesParams(outer, inner2) {
  for (const key in inner2) {
    const innerValue = inner2[key];
    const outerValue = outer[key];
    if (typeof innerValue === "string") {
      if (innerValue !== outerValue)
        return false;
    } else {
      if (!isArray$2(outerValue) || outerValue.length !== innerValue.length || innerValue.some((value, i2) => value !== outerValue[i2]))
        return false;
    }
  }
  return true;
}
function getOriginalPath(record) {
  return record ? record.aliasOf ? record.aliasOf.path : record.path : "";
}
const getLinkClass = (propClass, globalClass, defaultClass) => propClass != null ? propClass : globalClass != null ? globalClass : defaultClass;
const RouterViewImpl = /* @__PURE__ */ defineComponent({
  name: "RouterView",
  // #674 we manually inherit them
  inheritAttrs: false,
  props: {
    name: {
      type: String,
      default: "default"
    },
    route: Object
  },
  // Better compat for @vue/compat users
  // https://github.com/vuejs/router/issues/1315
  compatConfig: { MODE: 3 },
  setup(props, { attrs, slots }) {
    const injectedRoute = inject(routerViewLocationKey);
    const routeToDisplay = computed(() => props.route || injectedRoute.value);
    const injectedDepth = inject(viewDepthKey, 0);
    const depth = computed(() => {
      let initialDepth = unref(injectedDepth);
      const { matched } = routeToDisplay.value;
      let matchedRoute;
      while ((matchedRoute = matched[initialDepth]) && !matchedRoute.components) {
        initialDepth++;
      }
      return initialDepth;
    });
    const matchedRouteRef = computed(() => routeToDisplay.value.matched[depth.value]);
    provide(viewDepthKey, computed(() => depth.value + 1));
    provide(matchedRouteKey, matchedRouteRef);
    provide(routerViewLocationKey, routeToDisplay);
    const viewRef = ref();
    watch(() => [viewRef.value, matchedRouteRef.value, props.name], ([instance, to, name], [oldInstance, from, oldName]) => {
      if (to) {
        to.instances[name] = instance;
        if (from && from !== to && instance && instance === oldInstance) {
          if (!to.leaveGuards.size) {
            to.leaveGuards = from.leaveGuards;
          }
          if (!to.updateGuards.size) {
            to.updateGuards = from.updateGuards;
          }
        }
      }
      if (instance && to && // if there is no instance but to and from are the same this might be
      // the first visit
      (!from || !isSameRouteRecord(to, from) || !oldInstance)) {
        (to.enterCallbacks[name] || []).forEach((callback) => callback(instance));
      }
    }, { flush: "post" });
    return () => {
      const route = routeToDisplay.value;
      const currentName = props.name;
      const matchedRoute = matchedRouteRef.value;
      const ViewComponent = matchedRoute && matchedRoute.components[currentName];
      if (!ViewComponent) {
        return normalizeSlot(slots.default, { Component: ViewComponent, route });
      }
      const routePropsOption = matchedRoute.props[currentName];
      const routeProps = routePropsOption ? routePropsOption === true ? route.params : typeof routePropsOption === "function" ? routePropsOption(route) : routePropsOption : null;
      const onVnodeUnmounted = (vnode) => {
        if (vnode.component.isUnmounted) {
          matchedRoute.instances[currentName] = null;
        }
      };
      const component = h(ViewComponent, assign$1({}, routeProps, attrs, {
        onVnodeUnmounted,
        ref: viewRef
      }));
      return (
        // pass the vnode to the slot as a prop.
        // h and <component :is="..."> both accept vnodes
        normalizeSlot(slots.default, { Component: component, route }) || component
      );
    };
  }
});
function normalizeSlot(slot, data) {
  if (!slot)
    return null;
  const slotContent = slot(data);
  return slotContent.length === 1 ? slotContent[0] : slotContent;
}
const RouterView = RouterViewImpl;
function createRouter(options) {
  const matcher = createRouterMatcher(options.routes, options);
  const parseQuery$1 = options.parseQuery || parseQuery;
  const stringifyQuery$1 = options.stringifyQuery || stringifyQuery;
  const routerHistory = options.history;
  const beforeGuards = useCallbacks();
  const beforeResolveGuards = useCallbacks();
  const afterGuards = useCallbacks();
  const currentRoute = shallowRef(START_LOCATION_NORMALIZED);
  let pendingLocation = START_LOCATION_NORMALIZED;
  if (isBrowser && options.scrollBehavior && "scrollRestoration" in history) {
    history.scrollRestoration = "manual";
  }
  const normalizeParams = applyToParams.bind(null, (paramValue) => "" + paramValue);
  const encodeParams = applyToParams.bind(null, encodeParam);
  const decodeParams = (
    // @ts-expect-error: intentionally avoid the type check
    applyToParams.bind(null, decode)
  );
  function addRoute(parentOrRoute, route) {
    let parent;
    let record;
    if (isRouteName(parentOrRoute)) {
      parent = matcher.getRecordMatcher(parentOrRoute);
      record = route;
    } else {
      record = parentOrRoute;
    }
    return matcher.addRoute(record, parent);
  }
  function removeRoute(name) {
    const recordMatcher = matcher.getRecordMatcher(name);
    if (recordMatcher) {
      matcher.removeRoute(recordMatcher);
    }
  }
  function getRoutes() {
    return matcher.getRoutes().map((routeMatcher) => routeMatcher.record);
  }
  function hasRoute(name) {
    return !!matcher.getRecordMatcher(name);
  }
  function resolve2(rawLocation, currentLocation) {
    currentLocation = assign$1({}, currentLocation || currentRoute.value);
    if (typeof rawLocation === "string") {
      const locationNormalized = parseURL(parseQuery$1, rawLocation, currentLocation.path);
      const matchedRoute2 = matcher.resolve({ path: locationNormalized.path }, currentLocation);
      const href2 = routerHistory.createHref(locationNormalized.fullPath);
      return assign$1(locationNormalized, matchedRoute2, {
        params: decodeParams(matchedRoute2.params),
        hash: decode(locationNormalized.hash),
        redirectedFrom: void 0,
        href: href2
      });
    }
    let matcherLocation;
    if ("path" in rawLocation) {
      matcherLocation = assign$1({}, rawLocation, {
        path: parseURL(parseQuery$1, rawLocation.path, currentLocation.path).path
      });
    } else {
      const targetParams = assign$1({}, rawLocation.params);
      for (const key in targetParams) {
        if (targetParams[key] == null) {
          delete targetParams[key];
        }
      }
      matcherLocation = assign$1({}, rawLocation, {
        params: encodeParams(targetParams)
      });
      currentLocation.params = encodeParams(currentLocation.params);
    }
    const matchedRoute = matcher.resolve(matcherLocation, currentLocation);
    const hash = rawLocation.hash || "";
    matchedRoute.params = normalizeParams(decodeParams(matchedRoute.params));
    const fullPath = stringifyURL(stringifyQuery$1, assign$1({}, rawLocation, {
      hash: encodeHash(hash),
      path: matchedRoute.path
    }));
    const href = routerHistory.createHref(fullPath);
    return assign$1({
      fullPath,
      // keep the hash encoded so fullPath is effectively path + encodedQuery +
      // hash
      hash,
      query: (
        // if the user is using a custom query lib like qs, we might have
        // nested objects, so we keep the query as is, meaning it can contain
        // numbers at `$route.query`, but at the point, the user will have to
        // use their own type anyway.
        // https://github.com/vuejs/router/issues/328#issuecomment-649481567
        stringifyQuery$1 === stringifyQuery ? normalizeQuery(rawLocation.query) : rawLocation.query || {}
      )
    }, matchedRoute, {
      redirectedFrom: void 0,
      href
    });
  }
  function locationAsObject(to) {
    return typeof to === "string" ? parseURL(parseQuery$1, to, currentRoute.value.path) : assign$1({}, to);
  }
  function checkCanceledNavigation(to, from) {
    if (pendingLocation !== to) {
      return createRouterError(8, {
        from,
        to
      });
    }
  }
  function push(to) {
    return pushWithRedirect(to);
  }
  function replace(to) {
    return push(assign$1(locationAsObject(to), { replace: true }));
  }
  function handleRedirectRecord(to) {
    const lastMatched = to.matched[to.matched.length - 1];
    if (lastMatched && lastMatched.redirect) {
      const { redirect } = lastMatched;
      let newTargetLocation = typeof redirect === "function" ? redirect(to) : redirect;
      if (typeof newTargetLocation === "string") {
        newTargetLocation = newTargetLocation.includes("?") || newTargetLocation.includes("#") ? newTargetLocation = locationAsObject(newTargetLocation) : (
          // force empty params
          { path: newTargetLocation }
        );
        newTargetLocation.params = {};
      }
      return assign$1({
        query: to.query,
        hash: to.hash,
        // avoid transferring params if the redirect has a path
        params: "path" in newTargetLocation ? {} : to.params
      }, newTargetLocation);
    }
  }
  function pushWithRedirect(to, redirectedFrom) {
    const targetLocation = pendingLocation = resolve2(to);
    const from = currentRoute.value;
    const data = to.state;
    const force = to.force;
    const replace2 = to.replace === true;
    const shouldRedirect = handleRedirectRecord(targetLocation);
    if (shouldRedirect)
      return pushWithRedirect(
        assign$1(locationAsObject(shouldRedirect), {
          state: typeof shouldRedirect === "object" ? assign$1({}, data, shouldRedirect.state) : data,
          force,
          replace: replace2
        }),
        // keep original redirectedFrom if it exists
        redirectedFrom || targetLocation
      );
    const toLocation = targetLocation;
    toLocation.redirectedFrom = redirectedFrom;
    let failure;
    if (!force && isSameRouteLocation(stringifyQuery$1, from, targetLocation)) {
      failure = createRouterError(16, { to: toLocation, from });
      handleScroll2(
        from,
        from,
        // this is a push, the only way for it to be triggered from a
        // history.listen is with a redirect, which makes it become a push
        true,
        // This cannot be the first navigation because the initial location
        // cannot be manually navigated to
        false
      );
    }
    return (failure ? Promise.resolve(failure) : navigate(toLocation, from)).catch((error) => isNavigationFailure(error) ? (
      // navigation redirects still mark the router as ready
      isNavigationFailure(
        error,
        2
        /* ErrorTypes.NAVIGATION_GUARD_REDIRECT */
      ) ? error : markAsReady(error)
    ) : (
      // reject any unknown error
      triggerError(error, toLocation, from)
    )).then((failure2) => {
      if (failure2) {
        if (isNavigationFailure(
          failure2,
          2
          /* ErrorTypes.NAVIGATION_GUARD_REDIRECT */
        )) {
          return pushWithRedirect(
            // keep options
            assign$1({
              // preserve an existing replacement but allow the redirect to override it
              replace: replace2
            }, locationAsObject(failure2.to), {
              state: typeof failure2.to === "object" ? assign$1({}, data, failure2.to.state) : data,
              force
            }),
            // preserve the original redirectedFrom if any
            redirectedFrom || toLocation
          );
        }
      } else {
        failure2 = finalizeNavigation(toLocation, from, true, replace2, data);
      }
      triggerAfterEach(toLocation, from, failure2);
      return failure2;
    });
  }
  function checkCanceledNavigationAndReject(to, from) {
    const error = checkCanceledNavigation(to, from);
    return error ? Promise.reject(error) : Promise.resolve();
  }
  function runWithContext(fn) {
    const app = installedApps.values().next().value;
    return app && typeof app.runWithContext === "function" ? app.runWithContext(fn) : fn();
  }
  function navigate(to, from) {
    let guards;
    const [leavingRecords, updatingRecords, enteringRecords] = extractChangingRecords(to, from);
    guards = extractComponentsGuards(leavingRecords.reverse(), "beforeRouteLeave", to, from);
    for (const record of leavingRecords) {
      record.leaveGuards.forEach((guard) => {
        guards.push(guardToPromiseFn(guard, to, from));
      });
    }
    const canceledNavigationCheck = checkCanceledNavigationAndReject.bind(null, to, from);
    guards.push(canceledNavigationCheck);
    return runGuardQueue(guards).then(() => {
      guards = [];
      for (const guard of beforeGuards.list()) {
        guards.push(guardToPromiseFn(guard, to, from));
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = extractComponentsGuards(updatingRecords, "beforeRouteUpdate", to, from);
      for (const record of updatingRecords) {
        record.updateGuards.forEach((guard) => {
          guards.push(guardToPromiseFn(guard, to, from));
        });
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = [];
      for (const record of to.matched) {
        if (record.beforeEnter && !from.matched.includes(record)) {
          if (isArray$2(record.beforeEnter)) {
            for (const beforeEnter of record.beforeEnter)
              guards.push(guardToPromiseFn(beforeEnter, to, from));
          } else {
            guards.push(guardToPromiseFn(record.beforeEnter, to, from));
          }
        }
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      to.matched.forEach((record) => record.enterCallbacks = {});
      guards = extractComponentsGuards(enteringRecords, "beforeRouteEnter", to, from);
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = [];
      for (const guard of beforeResolveGuards.list()) {
        guards.push(guardToPromiseFn(guard, to, from));
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).catch((err) => isNavigationFailure(
      err,
      8
      /* ErrorTypes.NAVIGATION_CANCELLED */
    ) ? err : Promise.reject(err));
  }
  function triggerAfterEach(to, from, failure) {
    for (const guard of afterGuards.list()) {
      runWithContext(() => guard(to, from, failure));
    }
  }
  function finalizeNavigation(toLocation, from, isPush, replace2, data) {
    const error = checkCanceledNavigation(toLocation, from);
    if (error)
      return error;
    const isFirstNavigation = from === START_LOCATION_NORMALIZED;
    const state = !isBrowser ? {} : history.state;
    if (isPush) {
      if (replace2 || isFirstNavigation)
        routerHistory.replace(toLocation.fullPath, assign$1({
          scroll: isFirstNavigation && state && state.scroll
        }, data));
      else
        routerHistory.push(toLocation.fullPath, data);
    }
    currentRoute.value = toLocation;
    handleScroll2(toLocation, from, isPush, isFirstNavigation);
    markAsReady();
  }
  let removeHistoryListener;
  function setupListeners() {
    if (removeHistoryListener)
      return;
    removeHistoryListener = routerHistory.listen((to, _from, info) => {
      if (!router2.listening)
        return;
      const toLocation = resolve2(to);
      const shouldRedirect = handleRedirectRecord(toLocation);
      if (shouldRedirect) {
        pushWithRedirect(assign$1(shouldRedirect, { replace: true }), toLocation).catch(noop$1);
        return;
      }
      pendingLocation = toLocation;
      const from = currentRoute.value;
      if (isBrowser) {
        saveScrollPosition(getScrollKey(from.fullPath, info.delta), computeScrollPosition());
      }
      navigate(toLocation, from).catch((error) => {
        if (isNavigationFailure(
          error,
          4 | 8
          /* ErrorTypes.NAVIGATION_CANCELLED */
        )) {
          return error;
        }
        if (isNavigationFailure(
          error,
          2
          /* ErrorTypes.NAVIGATION_GUARD_REDIRECT */
        )) {
          pushWithRedirect(
            error.to,
            toLocation
            // avoid an uncaught rejection, let push call triggerError
          ).then((failure) => {
            if (isNavigationFailure(
              failure,
              4 | 16
              /* ErrorTypes.NAVIGATION_DUPLICATED */
            ) && !info.delta && info.type === NavigationType.pop) {
              routerHistory.go(-1, false);
            }
          }).catch(noop$1);
          return Promise.reject();
        }
        if (info.delta) {
          routerHistory.go(-info.delta, false);
        }
        return triggerError(error, toLocation, from);
      }).then((failure) => {
        failure = failure || finalizeNavigation(
          // after navigation, all matched components are resolved
          toLocation,
          from,
          false
        );
        if (failure) {
          if (info.delta && // a new navigation has been triggered, so we do not want to revert, that will change the current history
          // entry while a different route is displayed
          !isNavigationFailure(
            failure,
            8
            /* ErrorTypes.NAVIGATION_CANCELLED */
          )) {
            routerHistory.go(-info.delta, false);
          } else if (info.type === NavigationType.pop && isNavigationFailure(
            failure,
            4 | 16
            /* ErrorTypes.NAVIGATION_DUPLICATED */
          )) {
            routerHistory.go(-1, false);
          }
        }
        triggerAfterEach(toLocation, from, failure);
      }).catch(noop$1);
    });
  }
  let readyHandlers = useCallbacks();
  let errorHandlers = useCallbacks();
  let ready;
  function triggerError(error, to, from) {
    markAsReady(error);
    const list = errorHandlers.list();
    if (list.length) {
      list.forEach((handler) => handler(error, to, from));
    } else {
      console.error(error);
    }
    return Promise.reject(error);
  }
  function isReady() {
    if (ready && currentRoute.value !== START_LOCATION_NORMALIZED)
      return Promise.resolve();
    return new Promise((resolve3, reject) => {
      readyHandlers.add([resolve3, reject]);
    });
  }
  function markAsReady(err) {
    if (!ready) {
      ready = !err;
      setupListeners();
      readyHandlers.list().forEach(([resolve3, reject]) => err ? reject(err) : resolve3());
      readyHandlers.reset();
    }
    return err;
  }
  function handleScroll2(to, from, isPush, isFirstNavigation) {
    const { scrollBehavior } = options;
    if (!isBrowser || !scrollBehavior)
      return Promise.resolve();
    const scrollPosition = !isPush && getSavedScrollPosition(getScrollKey(to.fullPath, 0)) || (isFirstNavigation || !isPush) && history.state && history.state.scroll || null;
    return nextTick().then(() => scrollBehavior(to, from, scrollPosition)).then((position) => position && scrollToPosition(position)).catch((err) => triggerError(err, to, from));
  }
  const go = (delta) => routerHistory.go(delta);
  let started;
  const installedApps = /* @__PURE__ */ new Set();
  const router2 = {
    currentRoute,
    listening: true,
    addRoute,
    removeRoute,
    hasRoute,
    getRoutes,
    resolve: resolve2,
    options,
    push,
    replace,
    go,
    back: () => go(-1),
    forward: () => go(1),
    beforeEach: beforeGuards.add,
    beforeResolve: beforeResolveGuards.add,
    afterEach: afterGuards.add,
    onError: errorHandlers.add,
    isReady,
    install(app) {
      const router3 = this;
      app.component("RouterLink", RouterLink);
      app.component("RouterView", RouterView);
      app.config.globalProperties.$router = router3;
      Object.defineProperty(app.config.globalProperties, "$route", {
        enumerable: true,
        get: () => unref(currentRoute)
      });
      if (isBrowser && // used for the initial navigation client side to avoid pushing
      // multiple times when the router is used in multiple apps
      !started && currentRoute.value === START_LOCATION_NORMALIZED) {
        started = true;
        push(routerHistory.location).catch((err) => {
        });
      }
      const reactiveRoute = {};
      for (const key in START_LOCATION_NORMALIZED) {
        reactiveRoute[key] = computed(() => currentRoute.value[key]);
      }
      app.provide(routerKey, router3);
      app.provide(routeLocationKey, reactive(reactiveRoute));
      app.provide(routerViewLocationKey, currentRoute);
      const unmountApp = app.unmount;
      installedApps.add(app);
      app.unmount = function() {
        installedApps.delete(app);
        if (installedApps.size < 1) {
          pendingLocation = START_LOCATION_NORMALIZED;
          removeHistoryListener && removeHistoryListener();
          removeHistoryListener = null;
          currentRoute.value = START_LOCATION_NORMALIZED;
          started = false;
          ready = false;
        }
        unmountApp();
      };
    }
  };
  function runGuardQueue(guards) {
    return guards.reduce((promise, guard) => promise.then(() => runWithContext(guard)), Promise.resolve());
  }
  return router2;
}
function extractChangingRecords(to, from) {
  const leavingRecords = [];
  const updatingRecords = [];
  const enteringRecords = [];
  const len2 = Math.max(from.matched.length, to.matched.length);
  for (let i2 = 0; i2 < len2; i2++) {
    const recordFrom = from.matched[i2];
    if (recordFrom) {
      if (to.matched.find((record) => isSameRouteRecord(record, recordFrom)))
        updatingRecords.push(recordFrom);
      else
        leavingRecords.push(recordFrom);
    }
    const recordTo = to.matched[i2];
    if (recordTo) {
      if (!from.matched.find((record) => isSameRouteRecord(record, recordTo))) {
        enteringRecords.push(recordTo);
      }
    }
  }
  return [leavingRecords, updatingRecords, enteringRecords];
}
function useRouter() {
  return inject(routerKey);
}
function useRoute() {
  return inject(routeLocationKey);
}
const index$l = "";
/*!
  * shared v9.2.2
  * (c) 2022 kazuya kawaguchi
  * Released under the MIT License.
  */
const inBrowser = typeof window !== "undefined";
const hasSymbol = typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol";
const makeSymbol = (name) => hasSymbol ? Symbol(name) : name;
const generateFormatCacheKey = (locale2, key, source) => friendlyJSONstringify({
  l: locale2,
  k: key,
  s: source
});
const friendlyJSONstringify = (json) => JSON.stringify(json).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029").replace(/\u0027/g, "\\u0027");
const isNumber$1 = (val) => typeof val === "number" && isFinite(val);
const isDate = (val) => toTypeString(val) === "[object Date]";
const isRegExp = (val) => toTypeString(val) === "[object RegExp]";
const isEmptyObject = (val) => isPlainObject(val) && Object.keys(val).length === 0;
function warn(msg, err) {
  if (typeof console !== "undefined") {
    console.warn(`[intlify] ` + msg);
    if (err) {
      console.warn(err.stack);
    }
  }
}
const assign = Object.assign;
function escapeHtml(rawText) {
  return rawText.replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;");
}
const hasOwnProperty = Object.prototype.hasOwnProperty;
function hasOwn$1(obj, key) {
  return hasOwnProperty.call(obj, key);
}
const isArray$1 = Array.isArray;
const isFunction$1 = (val) => typeof val === "function";
const isString$1 = (val) => typeof val === "string";
const isBoolean = (val) => typeof val === "boolean";
const isObject$3 = (val) => (
  // eslint-disable-line
  val !== null && typeof val === "object"
);
const objectToString = Object.prototype.toString;
const toTypeString = (value) => objectToString.call(value);
const isPlainObject = (val) => toTypeString(val) === "[object Object]";
const toDisplayString = (val) => {
  return val == null ? "" : isArray$1(val) || isPlainObject(val) && val.toString === objectToString ? JSON.stringify(val, null, 2) : String(val);
};
/*!
  * message-compiler v9.2.2
  * (c) 2022 kazuya kawaguchi
  * Released under the MIT License.
  */
const CompileErrorCodes = {
  // tokenizer error codes
  EXPECTED_TOKEN: 1,
  INVALID_TOKEN_IN_PLACEHOLDER: 2,
  UNTERMINATED_SINGLE_QUOTE_IN_PLACEHOLDER: 3,
  UNKNOWN_ESCAPE_SEQUENCE: 4,
  INVALID_UNICODE_ESCAPE_SEQUENCE: 5,
  UNBALANCED_CLOSING_BRACE: 6,
  UNTERMINATED_CLOSING_BRACE: 7,
  EMPTY_PLACEHOLDER: 8,
  NOT_ALLOW_NEST_PLACEHOLDER: 9,
  INVALID_LINKED_FORMAT: 10,
  // parser error codes
  MUST_HAVE_MESSAGES_IN_PLURAL: 11,
  UNEXPECTED_EMPTY_LINKED_MODIFIER: 12,
  UNEXPECTED_EMPTY_LINKED_KEY: 13,
  UNEXPECTED_LEXICAL_ANALYSIS: 14,
  // Special value for higher-order compilers to pick up the last code
  // to avoid collision of error codes. This should always be kept as the last
  // item.
  __EXTEND_POINT__: 15
};
function createCompileError(code2, loc, options = {}) {
  const {
    domain,
    messages,
    args
  } = options;
  const msg = code2;
  const error = new SyntaxError(String(msg));
  error.code = code2;
  if (loc) {
    error.location = loc;
  }
  error.domain = domain;
  return error;
}
function defaultOnError(error) {
  throw error;
}
function createPosition(line, column, offset) {
  return {
    line,
    column,
    offset
  };
}
function createLocation(start2, end2, source) {
  const loc = {
    start: start2,
    end: end2
  };
  if (source != null) {
    loc.source = source;
  }
  return loc;
}
const CHAR_SP = " ";
const CHAR_CR = "\r";
const CHAR_LF = "\n";
const CHAR_LS = String.fromCharCode(8232);
const CHAR_PS = String.fromCharCode(8233);
function createScanner(str) {
  const _buf = str;
  let _index = 0;
  let _line = 1;
  let _column = 1;
  let _peekOffset = 0;
  const isCRLF = (index3) => _buf[index3] === CHAR_CR && _buf[index3 + 1] === CHAR_LF;
  const isLF = (index3) => _buf[index3] === CHAR_LF;
  const isPS = (index3) => _buf[index3] === CHAR_PS;
  const isLS = (index3) => _buf[index3] === CHAR_LS;
  const isLineEnd = (index3) => isCRLF(index3) || isLF(index3) || isPS(index3) || isLS(index3);
  const index2 = () => _index;
  const line = () => _line;
  const column = () => _column;
  const peekOffset = () => _peekOffset;
  const charAt = (offset) => isCRLF(offset) || isPS(offset) || isLS(offset) ? CHAR_LF : _buf[offset];
  const currentChar = () => charAt(_index);
  const currentPeek = () => charAt(_index + _peekOffset);
  function next() {
    _peekOffset = 0;
    if (isLineEnd(_index)) {
      _line++;
      _column = 0;
    }
    if (isCRLF(_index)) {
      _index++;
    }
    _index++;
    _column++;
    return _buf[_index];
  }
  function peek() {
    if (isCRLF(_index + _peekOffset)) {
      _peekOffset++;
    }
    _peekOffset++;
    return _buf[_index + _peekOffset];
  }
  function reset() {
    _index = 0;
    _line = 1;
    _column = 1;
    _peekOffset = 0;
  }
  function resetPeek(offset = 0) {
    _peekOffset = offset;
  }
  function skipToPeek() {
    const target2 = _index + _peekOffset;
    while (target2 !== _index) {
      next();
    }
    _peekOffset = 0;
  }
  return {
    index: index2,
    line,
    column,
    peekOffset,
    charAt,
    currentChar,
    currentPeek,
    next,
    peek,
    reset,
    resetPeek,
    skipToPeek
  };
}
const EOF = void 0;
const LITERAL_DELIMITER = "'";
const ERROR_DOMAIN$1 = "tokenizer";
function createTokenizer(source, options = {}) {
  const location2 = options.location !== false;
  const _scnr = createScanner(source);
  const currentOffset = () => _scnr.index();
  const currentPosition = () => createPosition(_scnr.line(), _scnr.column(), _scnr.index());
  const _initLoc = currentPosition();
  const _initOffset = currentOffset();
  const _context = {
    currentType: 14,
    offset: _initOffset,
    startLoc: _initLoc,
    endLoc: _initLoc,
    lastType: 14,
    lastOffset: _initOffset,
    lastStartLoc: _initLoc,
    lastEndLoc: _initLoc,
    braceNest: 0,
    inLinked: false,
    text: ""
  };
  const context = () => _context;
  const {
    onError
  } = options;
  function emitError(code2, pos, offset, ...args) {
    const ctx = context();
    pos.column += offset;
    pos.offset += offset;
    if (onError) {
      const loc = createLocation(ctx.startLoc, pos);
      const err = createCompileError(code2, loc, {
        domain: ERROR_DOMAIN$1,
        args
      });
      onError(err);
    }
  }
  function getToken(context2, type, value) {
    context2.endLoc = currentPosition();
    context2.currentType = type;
    const token = {
      type
    };
    if (location2) {
      token.loc = createLocation(context2.startLoc, context2.endLoc);
    }
    if (value != null) {
      token.value = value;
    }
    return token;
  }
  const getEndToken = (context2) => getToken(
    context2,
    14
    /* EOF */
  );
  function eat(scnr, ch) {
    if (scnr.currentChar() === ch) {
      scnr.next();
      return ch;
    } else {
      emitError(CompileErrorCodes.EXPECTED_TOKEN, currentPosition(), 0, ch);
      return "";
    }
  }
  function peekSpaces(scnr) {
    let buf = "";
    while (scnr.currentPeek() === CHAR_SP || scnr.currentPeek() === CHAR_LF) {
      buf += scnr.currentPeek();
      scnr.peek();
    }
    return buf;
  }
  function skipSpaces(scnr) {
    const buf = peekSpaces(scnr);
    scnr.skipToPeek();
    return buf;
  }
  function isIdentifierStart(ch) {
    if (ch === EOF) {
      return false;
    }
    const cc = ch.charCodeAt(0);
    return cc >= 97 && cc <= 122 || // a-z
    cc >= 65 && cc <= 90 || // A-Z
    cc === 95;
  }
  function isNumberStart(ch) {
    if (ch === EOF) {
      return false;
    }
    const cc = ch.charCodeAt(0);
    return cc >= 48 && cc <= 57;
  }
  function isNamedIdentifierStart(scnr, context2) {
    const {
      currentType
    } = context2;
    if (currentType !== 2) {
      return false;
    }
    peekSpaces(scnr);
    const ret = isIdentifierStart(scnr.currentPeek());
    scnr.resetPeek();
    return ret;
  }
  function isListIdentifierStart(scnr, context2) {
    const {
      currentType
    } = context2;
    if (currentType !== 2) {
      return false;
    }
    peekSpaces(scnr);
    const ch = scnr.currentPeek() === "-" ? scnr.peek() : scnr.currentPeek();
    const ret = isNumberStart(ch);
    scnr.resetPeek();
    return ret;
  }
  function isLiteralStart(scnr, context2) {
    const {
      currentType
    } = context2;
    if (currentType !== 2) {
      return false;
    }
    peekSpaces(scnr);
    const ret = scnr.currentPeek() === LITERAL_DELIMITER;
    scnr.resetPeek();
    return ret;
  }
  function isLinkedDotStart(scnr, context2) {
    const {
      currentType
    } = context2;
    if (currentType !== 8) {
      return false;
    }
    peekSpaces(scnr);
    const ret = scnr.currentPeek() === ".";
    scnr.resetPeek();
    return ret;
  }
  function isLinkedModifierStart(scnr, context2) {
    const {
      currentType
    } = context2;
    if (currentType !== 9) {
      return false;
    }
    peekSpaces(scnr);
    const ret = isIdentifierStart(scnr.currentPeek());
    scnr.resetPeek();
    return ret;
  }
  function isLinkedDelimiterStart(scnr, context2) {
    const {
      currentType
    } = context2;
    if (!(currentType === 8 || currentType === 12)) {
      return false;
    }
    peekSpaces(scnr);
    const ret = scnr.currentPeek() === ":";
    scnr.resetPeek();
    return ret;
  }
  function isLinkedReferStart(scnr, context2) {
    const {
      currentType
    } = context2;
    if (currentType !== 10) {
      return false;
    }
    const fn = () => {
      const ch = scnr.currentPeek();
      if (ch === "{") {
        return isIdentifierStart(scnr.peek());
      } else if (ch === "@" || ch === "%" || ch === "|" || ch === ":" || ch === "." || ch === CHAR_SP || !ch) {
        return false;
      } else if (ch === CHAR_LF) {
        scnr.peek();
        return fn();
      } else {
        return isIdentifierStart(ch);
      }
    };
    const ret = fn();
    scnr.resetPeek();
    return ret;
  }
  function isPluralStart(scnr) {
    peekSpaces(scnr);
    const ret = scnr.currentPeek() === "|";
    scnr.resetPeek();
    return ret;
  }
  function detectModuloStart(scnr) {
    const spaces = peekSpaces(scnr);
    const ret = scnr.currentPeek() === "%" && scnr.peek() === "{";
    scnr.resetPeek();
    return {
      isModulo: ret,
      hasSpace: spaces.length > 0
    };
  }
  function isTextStart(scnr, reset = true) {
    const fn = (hasSpace = false, prev = "", detectModulo = false) => {
      const ch = scnr.currentPeek();
      if (ch === "{") {
        return prev === "%" ? false : hasSpace;
      } else if (ch === "@" || !ch) {
        return prev === "%" ? true : hasSpace;
      } else if (ch === "%") {
        scnr.peek();
        return fn(hasSpace, "%", true);
      } else if (ch === "|") {
        return prev === "%" || detectModulo ? true : !(prev === CHAR_SP || prev === CHAR_LF);
      } else if (ch === CHAR_SP) {
        scnr.peek();
        return fn(true, CHAR_SP, detectModulo);
      } else if (ch === CHAR_LF) {
        scnr.peek();
        return fn(true, CHAR_LF, detectModulo);
      } else {
        return true;
      }
    };
    const ret = fn();
    reset && scnr.resetPeek();
    return ret;
  }
  function takeChar(scnr, fn) {
    const ch = scnr.currentChar();
    if (ch === EOF) {
      return EOF;
    }
    if (fn(ch)) {
      scnr.next();
      return ch;
    }
    return null;
  }
  function takeIdentifierChar(scnr) {
    const closure = (ch) => {
      const cc = ch.charCodeAt(0);
      return cc >= 97 && cc <= 122 || // a-z
      cc >= 65 && cc <= 90 || // A-Z
      cc >= 48 && cc <= 57 || // 0-9
      cc === 95 || // _
      cc === 36;
    };
    return takeChar(scnr, closure);
  }
  function takeDigit(scnr) {
    const closure = (ch) => {
      const cc = ch.charCodeAt(0);
      return cc >= 48 && cc <= 57;
    };
    return takeChar(scnr, closure);
  }
  function takeHexDigit(scnr) {
    const closure = (ch) => {
      const cc = ch.charCodeAt(0);
      return cc >= 48 && cc <= 57 || // 0-9
      cc >= 65 && cc <= 70 || // A-F
      cc >= 97 && cc <= 102;
    };
    return takeChar(scnr, closure);
  }
  function getDigits(scnr) {
    let ch = "";
    let num = "";
    while (ch = takeDigit(scnr)) {
      num += ch;
    }
    return num;
  }
  function readModulo(scnr) {
    skipSpaces(scnr);
    const ch = scnr.currentChar();
    if (ch !== "%") {
      emitError(CompileErrorCodes.EXPECTED_TOKEN, currentPosition(), 0, ch);
    }
    scnr.next();
    return "%";
  }
  function readText(scnr) {
    let buf = "";
    while (true) {
      const ch = scnr.currentChar();
      if (ch === "{" || ch === "}" || ch === "@" || ch === "|" || !ch) {
        break;
      } else if (ch === "%") {
        if (isTextStart(scnr)) {
          buf += ch;
          scnr.next();
        } else {
          break;
        }
      } else if (ch === CHAR_SP || ch === CHAR_LF) {
        if (isTextStart(scnr)) {
          buf += ch;
          scnr.next();
        } else if (isPluralStart(scnr)) {
          break;
        } else {
          buf += ch;
          scnr.next();
        }
      } else {
        buf += ch;
        scnr.next();
      }
    }
    return buf;
  }
  function readNamedIdentifier(scnr) {
    skipSpaces(scnr);
    let ch = "";
    let name = "";
    while (ch = takeIdentifierChar(scnr)) {
      name += ch;
    }
    if (scnr.currentChar() === EOF) {
      emitError(CompileErrorCodes.UNTERMINATED_CLOSING_BRACE, currentPosition(), 0);
    }
    return name;
  }
  function readListIdentifier(scnr) {
    skipSpaces(scnr);
    let value = "";
    if (scnr.currentChar() === "-") {
      scnr.next();
      value += `-${getDigits(scnr)}`;
    } else {
      value += getDigits(scnr);
    }
    if (scnr.currentChar() === EOF) {
      emitError(CompileErrorCodes.UNTERMINATED_CLOSING_BRACE, currentPosition(), 0);
    }
    return value;
  }
  function readLiteral(scnr) {
    skipSpaces(scnr);
    eat(scnr, `'`);
    let ch = "";
    let literal = "";
    const fn = (x2) => x2 !== LITERAL_DELIMITER && x2 !== CHAR_LF;
    while (ch = takeChar(scnr, fn)) {
      if (ch === "\\") {
        literal += readEscapeSequence(scnr);
      } else {
        literal += ch;
      }
    }
    const current = scnr.currentChar();
    if (current === CHAR_LF || current === EOF) {
      emitError(CompileErrorCodes.UNTERMINATED_SINGLE_QUOTE_IN_PLACEHOLDER, currentPosition(), 0);
      if (current === CHAR_LF) {
        scnr.next();
        eat(scnr, `'`);
      }
      return literal;
    }
    eat(scnr, `'`);
    return literal;
  }
  function readEscapeSequence(scnr) {
    const ch = scnr.currentChar();
    switch (ch) {
      case "\\":
      case `'`:
        scnr.next();
        return `\\${ch}`;
      case "u":
        return readUnicodeEscapeSequence(scnr, ch, 4);
      case "U":
        return readUnicodeEscapeSequence(scnr, ch, 6);
      default:
        emitError(CompileErrorCodes.UNKNOWN_ESCAPE_SEQUENCE, currentPosition(), 0, ch);
        return "";
    }
  }
  function readUnicodeEscapeSequence(scnr, unicode, digits) {
    eat(scnr, unicode);
    let sequence = "";
    for (let i2 = 0; i2 < digits; i2++) {
      const ch = takeHexDigit(scnr);
      if (!ch) {
        emitError(CompileErrorCodes.INVALID_UNICODE_ESCAPE_SEQUENCE, currentPosition(), 0, `\\${unicode}${sequence}${scnr.currentChar()}`);
        break;
      }
      sequence += ch;
    }
    return `\\${unicode}${sequence}`;
  }
  function readInvalidIdentifier(scnr) {
    skipSpaces(scnr);
    let ch = "";
    let identifiers = "";
    const closure = (ch2) => ch2 !== "{" && ch2 !== "}" && ch2 !== CHAR_SP && ch2 !== CHAR_LF;
    while (ch = takeChar(scnr, closure)) {
      identifiers += ch;
    }
    return identifiers;
  }
  function readLinkedModifier(scnr) {
    let ch = "";
    let name = "";
    while (ch = takeIdentifierChar(scnr)) {
      name += ch;
    }
    return name;
  }
  function readLinkedRefer(scnr) {
    const fn = (detect2 = false, buf) => {
      const ch = scnr.currentChar();
      if (ch === "{" || ch === "%" || ch === "@" || ch === "|" || !ch) {
        return buf;
      } else if (ch === CHAR_SP) {
        return buf;
      } else if (ch === CHAR_LF) {
        buf += ch;
        scnr.next();
        return fn(detect2, buf);
      } else {
        buf += ch;
        scnr.next();
        return fn(true, buf);
      }
    };
    return fn(false, "");
  }
  function readPlural(scnr) {
    skipSpaces(scnr);
    const plural = eat(
      scnr,
      "|"
      /* Pipe */
    );
    skipSpaces(scnr);
    return plural;
  }
  function readTokenInPlaceholder(scnr, context2) {
    let token = null;
    const ch = scnr.currentChar();
    switch (ch) {
      case "{":
        if (context2.braceNest >= 1) {
          emitError(CompileErrorCodes.NOT_ALLOW_NEST_PLACEHOLDER, currentPosition(), 0);
        }
        scnr.next();
        token = getToken(
          context2,
          2,
          "{"
          /* BraceLeft */
        );
        skipSpaces(scnr);
        context2.braceNest++;
        return token;
      case "}":
        if (context2.braceNest > 0 && context2.currentType === 2) {
          emitError(CompileErrorCodes.EMPTY_PLACEHOLDER, currentPosition(), 0);
        }
        scnr.next();
        token = getToken(
          context2,
          3,
          "}"
          /* BraceRight */
        );
        context2.braceNest--;
        context2.braceNest > 0 && skipSpaces(scnr);
        if (context2.inLinked && context2.braceNest === 0) {
          context2.inLinked = false;
        }
        return token;
      case "@":
        if (context2.braceNest > 0) {
          emitError(CompileErrorCodes.UNTERMINATED_CLOSING_BRACE, currentPosition(), 0);
        }
        token = readTokenInLinked(scnr, context2) || getEndToken(context2);
        context2.braceNest = 0;
        return token;
      default:
        let validNamedIdentifier = true;
        let validListIdentifier = true;
        let validLiteral = true;
        if (isPluralStart(scnr)) {
          if (context2.braceNest > 0) {
            emitError(CompileErrorCodes.UNTERMINATED_CLOSING_BRACE, currentPosition(), 0);
          }
          token = getToken(context2, 1, readPlural(scnr));
          context2.braceNest = 0;
          context2.inLinked = false;
          return token;
        }
        if (context2.braceNest > 0 && (context2.currentType === 5 || context2.currentType === 6 || context2.currentType === 7)) {
          emitError(CompileErrorCodes.UNTERMINATED_CLOSING_BRACE, currentPosition(), 0);
          context2.braceNest = 0;
          return readToken(scnr, context2);
        }
        if (validNamedIdentifier = isNamedIdentifierStart(scnr, context2)) {
          token = getToken(context2, 5, readNamedIdentifier(scnr));
          skipSpaces(scnr);
          return token;
        }
        if (validListIdentifier = isListIdentifierStart(scnr, context2)) {
          token = getToken(context2, 6, readListIdentifier(scnr));
          skipSpaces(scnr);
          return token;
        }
        if (validLiteral = isLiteralStart(scnr, context2)) {
          token = getToken(context2, 7, readLiteral(scnr));
          skipSpaces(scnr);
          return token;
        }
        if (!validNamedIdentifier && !validListIdentifier && !validLiteral) {
          token = getToken(context2, 13, readInvalidIdentifier(scnr));
          emitError(CompileErrorCodes.INVALID_TOKEN_IN_PLACEHOLDER, currentPosition(), 0, token.value);
          skipSpaces(scnr);
          return token;
        }
        break;
    }
    return token;
  }
  function readTokenInLinked(scnr, context2) {
    const {
      currentType
    } = context2;
    let token = null;
    const ch = scnr.currentChar();
    if ((currentType === 8 || currentType === 9 || currentType === 12 || currentType === 10) && (ch === CHAR_LF || ch === CHAR_SP)) {
      emitError(CompileErrorCodes.INVALID_LINKED_FORMAT, currentPosition(), 0);
    }
    switch (ch) {
      case "@":
        scnr.next();
        token = getToken(
          context2,
          8,
          "@"
          /* LinkedAlias */
        );
        context2.inLinked = true;
        return token;
      case ".":
        skipSpaces(scnr);
        scnr.next();
        return getToken(
          context2,
          9,
          "."
          /* LinkedDot */
        );
      case ":":
        skipSpaces(scnr);
        scnr.next();
        return getToken(
          context2,
          10,
          ":"
          /* LinkedDelimiter */
        );
      default:
        if (isPluralStart(scnr)) {
          token = getToken(context2, 1, readPlural(scnr));
          context2.braceNest = 0;
          context2.inLinked = false;
          return token;
        }
        if (isLinkedDotStart(scnr, context2) || isLinkedDelimiterStart(scnr, context2)) {
          skipSpaces(scnr);
          return readTokenInLinked(scnr, context2);
        }
        if (isLinkedModifierStart(scnr, context2)) {
          skipSpaces(scnr);
          return getToken(context2, 12, readLinkedModifier(scnr));
        }
        if (isLinkedReferStart(scnr, context2)) {
          skipSpaces(scnr);
          if (ch === "{") {
            return readTokenInPlaceholder(scnr, context2) || token;
          } else {
            return getToken(context2, 11, readLinkedRefer(scnr));
          }
        }
        if (currentType === 8) {
          emitError(CompileErrorCodes.INVALID_LINKED_FORMAT, currentPosition(), 0);
        }
        context2.braceNest = 0;
        context2.inLinked = false;
        return readToken(scnr, context2);
    }
  }
  function readToken(scnr, context2) {
    let token = {
      type: 14
      /* EOF */
    };
    if (context2.braceNest > 0) {
      return readTokenInPlaceholder(scnr, context2) || getEndToken(context2);
    }
    if (context2.inLinked) {
      return readTokenInLinked(scnr, context2) || getEndToken(context2);
    }
    const ch = scnr.currentChar();
    switch (ch) {
      case "{":
        return readTokenInPlaceholder(scnr, context2) || getEndToken(context2);
      case "}":
        emitError(CompileErrorCodes.UNBALANCED_CLOSING_BRACE, currentPosition(), 0);
        scnr.next();
        return getToken(
          context2,
          3,
          "}"
          /* BraceRight */
        );
      case "@":
        return readTokenInLinked(scnr, context2) || getEndToken(context2);
      default:
        if (isPluralStart(scnr)) {
          token = getToken(context2, 1, readPlural(scnr));
          context2.braceNest = 0;
          context2.inLinked = false;
          return token;
        }
        const {
          isModulo,
          hasSpace
        } = detectModuloStart(scnr);
        if (isModulo) {
          return hasSpace ? getToken(context2, 0, readText(scnr)) : getToken(context2, 4, readModulo(scnr));
        }
        if (isTextStart(scnr)) {
          return getToken(context2, 0, readText(scnr));
        }
        break;
    }
    return token;
  }
  function nextToken() {
    const {
      currentType,
      offset,
      startLoc,
      endLoc
    } = _context;
    _context.lastType = currentType;
    _context.lastOffset = offset;
    _context.lastStartLoc = startLoc;
    _context.lastEndLoc = endLoc;
    _context.offset = currentOffset();
    _context.startLoc = currentPosition();
    if (_scnr.currentChar() === EOF) {
      return getToken(
        _context,
        14
        /* EOF */
      );
    }
    return readToken(_scnr, _context);
  }
  return {
    nextToken,
    currentOffset,
    currentPosition,
    context
  };
}
const ERROR_DOMAIN = "parser";
const KNOWN_ESCAPES = /(?:\\\\|\\'|\\u([0-9a-fA-F]{4})|\\U([0-9a-fA-F]{6}))/g;
function fromEscapeSequence(match, codePoint4, codePoint6) {
  switch (match) {
    case `\\\\`:
      return `\\`;
    case `\\'`:
      return `'`;
    default: {
      const codePoint = parseInt(codePoint4 || codePoint6, 16);
      if (codePoint <= 55295 || codePoint >= 57344) {
        return String.fromCodePoint(codePoint);
      }
      return "�";
    }
  }
}
function createParser(options = {}) {
  const location2 = options.location !== false;
  const {
    onError
  } = options;
  function emitError(tokenzer, code2, start2, offset, ...args) {
    const end2 = tokenzer.currentPosition();
    end2.offset += offset;
    end2.column += offset;
    if (onError) {
      const loc = createLocation(start2, end2);
      const err = createCompileError(code2, loc, {
        domain: ERROR_DOMAIN,
        args
      });
      onError(err);
    }
  }
  function startNode(type, offset, loc) {
    const node = {
      type,
      start: offset,
      end: offset
    };
    if (location2) {
      node.loc = {
        start: loc,
        end: loc
      };
    }
    return node;
  }
  function endNode(node, offset, pos, type) {
    node.end = offset;
    if (type) {
      node.type = type;
    }
    if (location2 && node.loc) {
      node.loc.end = pos;
    }
  }
  function parseText(tokenizer, value) {
    const context = tokenizer.context();
    const node = startNode(3, context.offset, context.startLoc);
    node.value = value;
    endNode(node, tokenizer.currentOffset(), tokenizer.currentPosition());
    return node;
  }
  function parseList(tokenizer, index2) {
    const context = tokenizer.context();
    const {
      lastOffset: offset,
      lastStartLoc: loc
    } = context;
    const node = startNode(5, offset, loc);
    node.index = parseInt(index2, 10);
    tokenizer.nextToken();
    endNode(node, tokenizer.currentOffset(), tokenizer.currentPosition());
    return node;
  }
  function parseNamed(tokenizer, key) {
    const context = tokenizer.context();
    const {
      lastOffset: offset,
      lastStartLoc: loc
    } = context;
    const node = startNode(4, offset, loc);
    node.key = key;
    tokenizer.nextToken();
    endNode(node, tokenizer.currentOffset(), tokenizer.currentPosition());
    return node;
  }
  function parseLiteral(tokenizer, value) {
    const context = tokenizer.context();
    const {
      lastOffset: offset,
      lastStartLoc: loc
    } = context;
    const node = startNode(9, offset, loc);
    node.value = value.replace(KNOWN_ESCAPES, fromEscapeSequence);
    tokenizer.nextToken();
    endNode(node, tokenizer.currentOffset(), tokenizer.currentPosition());
    return node;
  }
  function parseLinkedModifier(tokenizer) {
    const token = tokenizer.nextToken();
    const context = tokenizer.context();
    const {
      lastOffset: offset,
      lastStartLoc: loc
    } = context;
    const node = startNode(8, offset, loc);
    if (token.type !== 12) {
      emitError(tokenizer, CompileErrorCodes.UNEXPECTED_EMPTY_LINKED_MODIFIER, context.lastStartLoc, 0);
      node.value = "";
      endNode(node, offset, loc);
      return {
        nextConsumeToken: token,
        node
      };
    }
    if (token.value == null) {
      emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
    }
    node.value = token.value || "";
    endNode(node, tokenizer.currentOffset(), tokenizer.currentPosition());
    return {
      node
    };
  }
  function parseLinkedKey(tokenizer, value) {
    const context = tokenizer.context();
    const node = startNode(7, context.offset, context.startLoc);
    node.value = value;
    endNode(node, tokenizer.currentOffset(), tokenizer.currentPosition());
    return node;
  }
  function parseLinked(tokenizer) {
    const context = tokenizer.context();
    const linkedNode = startNode(6, context.offset, context.startLoc);
    let token = tokenizer.nextToken();
    if (token.type === 9) {
      const parsed = parseLinkedModifier(tokenizer);
      linkedNode.modifier = parsed.node;
      token = parsed.nextConsumeToken || tokenizer.nextToken();
    }
    if (token.type !== 10) {
      emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
    }
    token = tokenizer.nextToken();
    if (token.type === 2) {
      token = tokenizer.nextToken();
    }
    switch (token.type) {
      case 11:
        if (token.value == null) {
          emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
        }
        linkedNode.key = parseLinkedKey(tokenizer, token.value || "");
        break;
      case 5:
        if (token.value == null) {
          emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
        }
        linkedNode.key = parseNamed(tokenizer, token.value || "");
        break;
      case 6:
        if (token.value == null) {
          emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
        }
        linkedNode.key = parseList(tokenizer, token.value || "");
        break;
      case 7:
        if (token.value == null) {
          emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
        }
        linkedNode.key = parseLiteral(tokenizer, token.value || "");
        break;
      default:
        emitError(tokenizer, CompileErrorCodes.UNEXPECTED_EMPTY_LINKED_KEY, context.lastStartLoc, 0);
        const nextContext = tokenizer.context();
        const emptyLinkedKeyNode = startNode(7, nextContext.offset, nextContext.startLoc);
        emptyLinkedKeyNode.value = "";
        endNode(emptyLinkedKeyNode, nextContext.offset, nextContext.startLoc);
        linkedNode.key = emptyLinkedKeyNode;
        endNode(linkedNode, nextContext.offset, nextContext.startLoc);
        return {
          nextConsumeToken: token,
          node: linkedNode
        };
    }
    endNode(linkedNode, tokenizer.currentOffset(), tokenizer.currentPosition());
    return {
      node: linkedNode
    };
  }
  function parseMessage(tokenizer) {
    const context = tokenizer.context();
    const startOffset = context.currentType === 1 ? tokenizer.currentOffset() : context.offset;
    const startLoc = context.currentType === 1 ? context.endLoc : context.startLoc;
    const node = startNode(2, startOffset, startLoc);
    node.items = [];
    let nextToken = null;
    do {
      const token = nextToken || tokenizer.nextToken();
      nextToken = null;
      switch (token.type) {
        case 0:
          if (token.value == null) {
            emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
          }
          node.items.push(parseText(tokenizer, token.value || ""));
          break;
        case 6:
          if (token.value == null) {
            emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
          }
          node.items.push(parseList(tokenizer, token.value || ""));
          break;
        case 5:
          if (token.value == null) {
            emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
          }
          node.items.push(parseNamed(tokenizer, token.value || ""));
          break;
        case 7:
          if (token.value == null) {
            emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, getTokenCaption(token));
          }
          node.items.push(parseLiteral(tokenizer, token.value || ""));
          break;
        case 8:
          const parsed = parseLinked(tokenizer);
          node.items.push(parsed.node);
          nextToken = parsed.nextConsumeToken || null;
          break;
      }
    } while (context.currentType !== 14 && context.currentType !== 1);
    const endOffset = context.currentType === 1 ? context.lastOffset : tokenizer.currentOffset();
    const endLoc = context.currentType === 1 ? context.lastEndLoc : tokenizer.currentPosition();
    endNode(node, endOffset, endLoc);
    return node;
  }
  function parsePlural(tokenizer, offset, loc, msgNode) {
    const context = tokenizer.context();
    let hasEmptyMessage = msgNode.items.length === 0;
    const node = startNode(1, offset, loc);
    node.cases = [];
    node.cases.push(msgNode);
    do {
      const msg = parseMessage(tokenizer);
      if (!hasEmptyMessage) {
        hasEmptyMessage = msg.items.length === 0;
      }
      node.cases.push(msg);
    } while (context.currentType !== 14);
    if (hasEmptyMessage) {
      emitError(tokenizer, CompileErrorCodes.MUST_HAVE_MESSAGES_IN_PLURAL, loc, 0);
    }
    endNode(node, tokenizer.currentOffset(), tokenizer.currentPosition());
    return node;
  }
  function parseResource(tokenizer) {
    const context = tokenizer.context();
    const {
      offset,
      startLoc
    } = context;
    const msgNode = parseMessage(tokenizer);
    if (context.currentType === 14) {
      return msgNode;
    } else {
      return parsePlural(tokenizer, offset, startLoc, msgNode);
    }
  }
  function parse2(source) {
    const tokenizer = createTokenizer(source, assign({}, options));
    const context = tokenizer.context();
    const node = startNode(0, context.offset, context.startLoc);
    if (location2 && node.loc) {
      node.loc.source = source;
    }
    node.body = parseResource(tokenizer);
    if (context.currentType !== 14) {
      emitError(tokenizer, CompileErrorCodes.UNEXPECTED_LEXICAL_ANALYSIS, context.lastStartLoc, 0, source[context.offset] || "");
    }
    endNode(node, tokenizer.currentOffset(), tokenizer.currentPosition());
    return node;
  }
  return {
    parse: parse2
  };
}
function getTokenCaption(token) {
  if (token.type === 14) {
    return "EOF";
  }
  const name = (token.value || "").replace(/\r?\n/gu, "\\n");
  return name.length > 10 ? name.slice(0, 9) + "…" : name;
}
function createTransformer(ast, options = {}) {
  const _context = {
    ast,
    helpers: /* @__PURE__ */ new Set()
  };
  const context = () => _context;
  const helper = (name) => {
    _context.helpers.add(name);
    return name;
  };
  return {
    context,
    helper
  };
}
function traverseNodes(nodes, transformer) {
  for (let i2 = 0; i2 < nodes.length; i2++) {
    traverseNode(nodes[i2], transformer);
  }
}
function traverseNode(node, transformer) {
  switch (node.type) {
    case 1:
      traverseNodes(node.cases, transformer);
      transformer.helper(
        "plural"
        /* PLURAL */
      );
      break;
    case 2:
      traverseNodes(node.items, transformer);
      break;
    case 6:
      const linked = node;
      traverseNode(linked.key, transformer);
      transformer.helper(
        "linked"
        /* LINKED */
      );
      transformer.helper(
        "type"
        /* TYPE */
      );
      break;
    case 5:
      transformer.helper(
        "interpolate"
        /* INTERPOLATE */
      );
      transformer.helper(
        "list"
        /* LIST */
      );
      break;
    case 4:
      transformer.helper(
        "interpolate"
        /* INTERPOLATE */
      );
      transformer.helper(
        "named"
        /* NAMED */
      );
      break;
  }
}
function transform(ast, options = {}) {
  const transformer = createTransformer(ast);
  transformer.helper(
    "normalize"
    /* NORMALIZE */
  );
  ast.body && traverseNode(ast.body, transformer);
  const context = transformer.context();
  ast.helpers = Array.from(context.helpers);
}
function createCodeGenerator(ast, options) {
  const {
    sourceMap,
    filename,
    breakLineCode,
    needIndent: _needIndent
  } = options;
  const _context = {
    source: ast.loc.source,
    filename,
    code: "",
    column: 1,
    line: 1,
    offset: 0,
    map: void 0,
    breakLineCode,
    needIndent: _needIndent,
    indentLevel: 0
  };
  const context = () => _context;
  function push(code2, node) {
    _context.code += code2;
  }
  function _newline(n2, withBreakLine = true) {
    const _breakLineCode = withBreakLine ? breakLineCode : "";
    push(_needIndent ? _breakLineCode + `  `.repeat(n2) : _breakLineCode);
  }
  function indent(withNewLine = true) {
    const level = ++_context.indentLevel;
    withNewLine && _newline(level);
  }
  function deindent(withNewLine = true) {
    const level = --_context.indentLevel;
    withNewLine && _newline(level);
  }
  function newline() {
    _newline(_context.indentLevel);
  }
  const helper = (key) => `_${key}`;
  const needIndent = () => _context.needIndent;
  return {
    context,
    push,
    indent,
    deindent,
    newline,
    helper,
    needIndent
  };
}
function generateLinkedNode(generator, node) {
  const {
    helper
  } = generator;
  generator.push(`${helper(
    "linked"
    /* LINKED */
  )}(`);
  generateNode(generator, node.key);
  if (node.modifier) {
    generator.push(`, `);
    generateNode(generator, node.modifier);
    generator.push(`, _type`);
  } else {
    generator.push(`, undefined, _type`);
  }
  generator.push(`)`);
}
function generateMessageNode(generator, node) {
  const {
    helper,
    needIndent
  } = generator;
  generator.push(`${helper(
    "normalize"
    /* NORMALIZE */
  )}([`);
  generator.indent(needIndent());
  const length = node.items.length;
  for (let i2 = 0; i2 < length; i2++) {
    generateNode(generator, node.items[i2]);
    if (i2 === length - 1) {
      break;
    }
    generator.push(", ");
  }
  generator.deindent(needIndent());
  generator.push("])");
}
function generatePluralNode(generator, node) {
  const {
    helper,
    needIndent
  } = generator;
  if (node.cases.length > 1) {
    generator.push(`${helper(
      "plural"
      /* PLURAL */
    )}([`);
    generator.indent(needIndent());
    const length = node.cases.length;
    for (let i2 = 0; i2 < length; i2++) {
      generateNode(generator, node.cases[i2]);
      if (i2 === length - 1) {
        break;
      }
      generator.push(", ");
    }
    generator.deindent(needIndent());
    generator.push(`])`);
  }
}
function generateResource(generator, node) {
  if (node.body) {
    generateNode(generator, node.body);
  } else {
    generator.push("null");
  }
}
function generateNode(generator, node) {
  const {
    helper
  } = generator;
  switch (node.type) {
    case 0:
      generateResource(generator, node);
      break;
    case 1:
      generatePluralNode(generator, node);
      break;
    case 2:
      generateMessageNode(generator, node);
      break;
    case 6:
      generateLinkedNode(generator, node);
      break;
    case 8:
      generator.push(JSON.stringify(node.value), node);
      break;
    case 7:
      generator.push(JSON.stringify(node.value), node);
      break;
    case 5:
      generator.push(`${helper(
        "interpolate"
        /* INTERPOLATE */
      )}(${helper(
        "list"
        /* LIST */
      )}(${node.index}))`, node);
      break;
    case 4:
      generator.push(`${helper(
        "interpolate"
        /* INTERPOLATE */
      )}(${helper(
        "named"
        /* NAMED */
      )}(${JSON.stringify(node.key)}))`, node);
      break;
    case 9:
      generator.push(JSON.stringify(node.value), node);
      break;
    case 3:
      generator.push(JSON.stringify(node.value), node);
      break;
  }
}
const generate = (ast, options = {}) => {
  const mode = isString$1(options.mode) ? options.mode : "normal";
  const filename = isString$1(options.filename) ? options.filename : "message.intl";
  const sourceMap = !!options.sourceMap;
  const breakLineCode = options.breakLineCode != null ? options.breakLineCode : mode === "arrow" ? ";" : "\n";
  const needIndent = options.needIndent ? options.needIndent : mode !== "arrow";
  const helpers = ast.helpers || [];
  const generator = createCodeGenerator(ast, {
    mode,
    filename,
    sourceMap,
    breakLineCode,
    needIndent
  });
  generator.push(mode === "normal" ? `function __msg__ (ctx) {` : `(ctx) => {`);
  generator.indent(needIndent);
  if (helpers.length > 0) {
    generator.push(`const { ${helpers.map((s) => `${s}: _${s}`).join(", ")} } = ctx`);
    generator.newline();
  }
  generator.push(`return `);
  generateNode(generator, ast);
  generator.deindent(needIndent);
  generator.push(`}`);
  const {
    code: code2,
    map: map2
  } = generator.context();
  return {
    ast,
    code: code2,
    map: map2 ? map2.toJSON() : void 0
    // eslint-disable-line @typescript-eslint/no-explicit-any
  };
};
function baseCompile(source, options = {}) {
  const assignedOptions = assign({}, options);
  const parser = createParser(assignedOptions);
  const ast = parser.parse(source);
  transform(ast, assignedOptions);
  return generate(ast, assignedOptions);
}
/*!
  * core-base v9.2.2
  * (c) 2022 kazuya kawaguchi
  * Released under the MIT License.
  */
const pathStateMachine = [];
pathStateMachine[
  0
  /* BEFORE_PATH */
] = {
  [
    "w"
    /* WORKSPACE */
  ]: [
    0
    /* BEFORE_PATH */
  ],
  [
    "i"
    /* IDENT */
  ]: [
    3,
    0
    /* APPEND */
  ],
  [
    "["
    /* LEFT_BRACKET */
  ]: [
    4
    /* IN_SUB_PATH */
  ],
  [
    "o"
    /* END_OF_FAIL */
  ]: [
    7
    /* AFTER_PATH */
  ]
};
pathStateMachine[
  1
  /* IN_PATH */
] = {
  [
    "w"
    /* WORKSPACE */
  ]: [
    1
    /* IN_PATH */
  ],
  [
    "."
    /* DOT */
  ]: [
    2
    /* BEFORE_IDENT */
  ],
  [
    "["
    /* LEFT_BRACKET */
  ]: [
    4
    /* IN_SUB_PATH */
  ],
  [
    "o"
    /* END_OF_FAIL */
  ]: [
    7
    /* AFTER_PATH */
  ]
};
pathStateMachine[
  2
  /* BEFORE_IDENT */
] = {
  [
    "w"
    /* WORKSPACE */
  ]: [
    2
    /* BEFORE_IDENT */
  ],
  [
    "i"
    /* IDENT */
  ]: [
    3,
    0
    /* APPEND */
  ],
  [
    "0"
    /* ZERO */
  ]: [
    3,
    0
    /* APPEND */
  ]
};
pathStateMachine[
  3
  /* IN_IDENT */
] = {
  [
    "i"
    /* IDENT */
  ]: [
    3,
    0
    /* APPEND */
  ],
  [
    "0"
    /* ZERO */
  ]: [
    3,
    0
    /* APPEND */
  ],
  [
    "w"
    /* WORKSPACE */
  ]: [
    1,
    1
    /* PUSH */
  ],
  [
    "."
    /* DOT */
  ]: [
    2,
    1
    /* PUSH */
  ],
  [
    "["
    /* LEFT_BRACKET */
  ]: [
    4,
    1
    /* PUSH */
  ],
  [
    "o"
    /* END_OF_FAIL */
  ]: [
    7,
    1
    /* PUSH */
  ]
};
pathStateMachine[
  4
  /* IN_SUB_PATH */
] = {
  [
    "'"
    /* SINGLE_QUOTE */
  ]: [
    5,
    0
    /* APPEND */
  ],
  [
    '"'
    /* DOUBLE_QUOTE */
  ]: [
    6,
    0
    /* APPEND */
  ],
  [
    "["
    /* LEFT_BRACKET */
  ]: [
    4,
    2
    /* INC_SUB_PATH_DEPTH */
  ],
  [
    "]"
    /* RIGHT_BRACKET */
  ]: [
    1,
    3
    /* PUSH_SUB_PATH */
  ],
  [
    "o"
    /* END_OF_FAIL */
  ]: 8,
  [
    "l"
    /* ELSE */
  ]: [
    4,
    0
    /* APPEND */
  ]
};
pathStateMachine[
  5
  /* IN_SINGLE_QUOTE */
] = {
  [
    "'"
    /* SINGLE_QUOTE */
  ]: [
    4,
    0
    /* APPEND */
  ],
  [
    "o"
    /* END_OF_FAIL */
  ]: 8,
  [
    "l"
    /* ELSE */
  ]: [
    5,
    0
    /* APPEND */
  ]
};
pathStateMachine[
  6
  /* IN_DOUBLE_QUOTE */
] = {
  [
    '"'
    /* DOUBLE_QUOTE */
  ]: [
    4,
    0
    /* APPEND */
  ],
  [
    "o"
    /* END_OF_FAIL */
  ]: 8,
  [
    "l"
    /* ELSE */
  ]: [
    6,
    0
    /* APPEND */
  ]
};
const literalValueRE = /^\s?(?:true|false|-?[\d.]+|'[^']*'|"[^"]*")\s?$/;
function isLiteral(exp) {
  return literalValueRE.test(exp);
}
function stripQuotes(str) {
  const a = str.charCodeAt(0);
  const b2 = str.charCodeAt(str.length - 1);
  return a === b2 && (a === 34 || a === 39) ? str.slice(1, -1) : str;
}
function getPathCharType(ch) {
  if (ch === void 0 || ch === null) {
    return "o";
  }
  const code2 = ch.charCodeAt(0);
  switch (code2) {
    case 91:
    case 93:
    case 46:
    case 34:
    case 39:
      return ch;
    case 95:
    case 36:
    case 45:
      return "i";
    case 9:
    case 10:
    case 13:
    case 160:
    case 65279:
    case 8232:
    case 8233:
      return "w";
  }
  return "i";
}
function formatSubPath(path) {
  const trimmed = path.trim();
  if (path.charAt(0) === "0" && isNaN(parseInt(path))) {
    return false;
  }
  return isLiteral(trimmed) ? stripQuotes(trimmed) : "*" + trimmed;
}
function parse$1(path) {
  const keys2 = [];
  let index2 = -1;
  let mode = 0;
  let subPathDepth = 0;
  let c;
  let key;
  let newChar;
  let type;
  let transition;
  let action;
  let typeMap;
  const actions2 = [];
  actions2[
    0
    /* APPEND */
  ] = () => {
    if (key === void 0) {
      key = newChar;
    } else {
      key += newChar;
    }
  };
  actions2[
    1
    /* PUSH */
  ] = () => {
    if (key !== void 0) {
      keys2.push(key);
      key = void 0;
    }
  };
  actions2[
    2
    /* INC_SUB_PATH_DEPTH */
  ] = () => {
    actions2[
      0
      /* APPEND */
    ]();
    subPathDepth++;
  };
  actions2[
    3
    /* PUSH_SUB_PATH */
  ] = () => {
    if (subPathDepth > 0) {
      subPathDepth--;
      mode = 4;
      actions2[
        0
        /* APPEND */
      ]();
    } else {
      subPathDepth = 0;
      if (key === void 0) {
        return false;
      }
      key = formatSubPath(key);
      if (key === false) {
        return false;
      } else {
        actions2[
          1
          /* PUSH */
        ]();
      }
    }
  };
  function maybeUnescapeQuote() {
    const nextChar = path[index2 + 1];
    if (mode === 5 && nextChar === "'" || mode === 6 && nextChar === '"') {
      index2++;
      newChar = "\\" + nextChar;
      actions2[
        0
        /* APPEND */
      ]();
      return true;
    }
  }
  while (mode !== null) {
    index2++;
    c = path[index2];
    if (c === "\\" && maybeUnescapeQuote()) {
      continue;
    }
    type = getPathCharType(c);
    typeMap = pathStateMachine[mode];
    transition = typeMap[type] || typeMap[
      "l"
      /* ELSE */
    ] || 8;
    if (transition === 8) {
      return;
    }
    mode = transition[0];
    if (transition[1] !== void 0) {
      action = actions2[transition[1]];
      if (action) {
        newChar = c;
        if (action() === false) {
          return;
        }
      }
    }
    if (mode === 7) {
      return keys2;
    }
  }
}
const cache = /* @__PURE__ */ new Map();
function resolveWithKeyValue(obj, path) {
  return isObject$3(obj) ? obj[path] : null;
}
function resolveValue(obj, path) {
  if (!isObject$3(obj)) {
    return null;
  }
  let hit = cache.get(path);
  if (!hit) {
    hit = parse$1(path);
    if (hit) {
      cache.set(path, hit);
    }
  }
  if (!hit) {
    return null;
  }
  const len2 = hit.length;
  let last = obj;
  let i2 = 0;
  while (i2 < len2) {
    const val = last[hit[i2]];
    if (val === void 0) {
      return null;
    }
    last = val;
    i2++;
  }
  return last;
}
const DEFAULT_MODIFIER = (str) => str;
const DEFAULT_MESSAGE = (ctx) => "";
const DEFAULT_MESSAGE_DATA_TYPE = "text";
const DEFAULT_NORMALIZE = (values) => values.length === 0 ? "" : values.join("");
const DEFAULT_INTERPOLATE = toDisplayString;
function pluralDefault(choice, choicesLength) {
  choice = Math.abs(choice);
  if (choicesLength === 2) {
    return choice ? choice > 1 ? 1 : 0 : 1;
  }
  return choice ? Math.min(choice, 2) : 0;
}
function getPluralIndex(options) {
  const index2 = isNumber$1(options.pluralIndex) ? options.pluralIndex : -1;
  return options.named && (isNumber$1(options.named.count) || isNumber$1(options.named.n)) ? isNumber$1(options.named.count) ? options.named.count : isNumber$1(options.named.n) ? options.named.n : index2 : index2;
}
function normalizeNamed(pluralIndex, props) {
  if (!props.count) {
    props.count = pluralIndex;
  }
  if (!props.n) {
    props.n = pluralIndex;
  }
}
function createMessageContext(options = {}) {
  const locale2 = options.locale;
  const pluralIndex = getPluralIndex(options);
  const pluralRule = isObject$3(options.pluralRules) && isString$1(locale2) && isFunction$1(options.pluralRules[locale2]) ? options.pluralRules[locale2] : pluralDefault;
  const orgPluralRule = isObject$3(options.pluralRules) && isString$1(locale2) && isFunction$1(options.pluralRules[locale2]) ? pluralDefault : void 0;
  const plural = (messages) => {
    return messages[pluralRule(pluralIndex, messages.length, orgPluralRule)];
  };
  const _list = options.list || [];
  const list = (index2) => _list[index2];
  const _named = options.named || {};
  isNumber$1(options.pluralIndex) && normalizeNamed(pluralIndex, _named);
  const named = (key) => _named[key];
  function message2(key) {
    const msg = isFunction$1(options.messages) ? options.messages(key) : isObject$3(options.messages) ? options.messages[key] : false;
    return !msg ? options.parent ? options.parent.message(key) : DEFAULT_MESSAGE : msg;
  }
  const _modifier = (name) => options.modifiers ? options.modifiers[name] : DEFAULT_MODIFIER;
  const normalize2 = isPlainObject(options.processor) && isFunction$1(options.processor.normalize) ? options.processor.normalize : DEFAULT_NORMALIZE;
  const interpolate = isPlainObject(options.processor) && isFunction$1(options.processor.interpolate) ? options.processor.interpolate : DEFAULT_INTERPOLATE;
  const type = isPlainObject(options.processor) && isString$1(options.processor.type) ? options.processor.type : DEFAULT_MESSAGE_DATA_TYPE;
  const linked = (key, ...args) => {
    const [arg1, arg2] = args;
    let type2 = "text";
    let modifier = "";
    if (args.length === 1) {
      if (isObject$3(arg1)) {
        modifier = arg1.modifier || modifier;
        type2 = arg1.type || type2;
      } else if (isString$1(arg1)) {
        modifier = arg1 || modifier;
      }
    } else if (args.length === 2) {
      if (isString$1(arg1)) {
        modifier = arg1 || modifier;
      }
      if (isString$1(arg2)) {
        type2 = arg2 || type2;
      }
    }
    let msg = message2(key)(ctx);
    if (type2 === "vnode" && isArray$1(msg) && modifier) {
      msg = msg[0];
    }
    return modifier ? _modifier(modifier)(msg, type2) : msg;
  };
  const ctx = {
    [
      "list"
      /* LIST */
    ]: list,
    [
      "named"
      /* NAMED */
    ]: named,
    [
      "plural"
      /* PLURAL */
    ]: plural,
    [
      "linked"
      /* LINKED */
    ]: linked,
    [
      "message"
      /* MESSAGE */
    ]: message2,
    [
      "type"
      /* TYPE */
    ]: type,
    [
      "interpolate"
      /* INTERPOLATE */
    ]: interpolate,
    [
      "normalize"
      /* NORMALIZE */
    ]: normalize2
  };
  return ctx;
}
function fallbackWithSimple(ctx, fallback, start2) {
  return [.../* @__PURE__ */ new Set([start2, ...isArray$1(fallback) ? fallback : isObject$3(fallback) ? Object.keys(fallback) : isString$1(fallback) ? [fallback] : [start2]])];
}
function fallbackWithLocaleChain(ctx, fallback, start2) {
  const startLocale = isString$1(start2) ? start2 : DEFAULT_LOCALE$1;
  const context = ctx;
  if (!context.__localeChainCache) {
    context.__localeChainCache = /* @__PURE__ */ new Map();
  }
  let chain = context.__localeChainCache.get(startLocale);
  if (!chain) {
    chain = [];
    let block = [start2];
    while (isArray$1(block)) {
      block = appendBlockToChain(chain, block, fallback);
    }
    const defaults2 = isArray$1(fallback) || !isPlainObject(fallback) ? fallback : fallback["default"] ? fallback["default"] : null;
    block = isString$1(defaults2) ? [defaults2] : defaults2;
    if (isArray$1(block)) {
      appendBlockToChain(chain, block, false);
    }
    context.__localeChainCache.set(startLocale, chain);
  }
  return chain;
}
function appendBlockToChain(chain, block, blocks) {
  let follow = true;
  for (let i2 = 0; i2 < block.length && isBoolean(follow); i2++) {
    const locale2 = block[i2];
    if (isString$1(locale2)) {
      follow = appendLocaleToChain(chain, block[i2], blocks);
    }
  }
  return follow;
}
function appendLocaleToChain(chain, locale2, blocks) {
  let follow;
  const tokens = locale2.split("-");
  do {
    const target2 = tokens.join("-");
    follow = appendItemToChain(chain, target2, blocks);
    tokens.splice(-1, 1);
  } while (tokens.length && follow === true);
  return follow;
}
function appendItemToChain(chain, target2, blocks) {
  let follow = false;
  if (!chain.includes(target2)) {
    follow = true;
    if (target2) {
      follow = target2[target2.length - 1] !== "!";
      const locale2 = target2.replace(/!/g, "");
      chain.push(locale2);
      if ((isArray$1(blocks) || isPlainObject(blocks)) && blocks[locale2]) {
        follow = blocks[locale2];
      }
    }
  }
  return follow;
}
const VERSION$1 = "9.2.2";
const NOT_REOSLVED = -1;
const DEFAULT_LOCALE$1 = "en-US";
const MISSING_RESOLVE_VALUE = "";
const capitalize = (str) => `${str.charAt(0).toLocaleUpperCase()}${str.substr(1)}`;
function getDefaultLinkedModifiers() {
  return {
    upper: (val, type) => {
      return type === "text" && isString$1(val) ? val.toUpperCase() : type === "vnode" && isObject$3(val) && "__v_isVNode" in val ? val.children.toUpperCase() : val;
    },
    lower: (val, type) => {
      return type === "text" && isString$1(val) ? val.toLowerCase() : type === "vnode" && isObject$3(val) && "__v_isVNode" in val ? val.children.toLowerCase() : val;
    },
    capitalize: (val, type) => {
      return type === "text" && isString$1(val) ? capitalize(val) : type === "vnode" && isObject$3(val) && "__v_isVNode" in val ? capitalize(val.children) : val;
    }
  };
}
let _compiler;
function registerMessageCompiler(compiler) {
  _compiler = compiler;
}
let _resolver;
function registerMessageResolver(resolver) {
  _resolver = resolver;
}
let _fallbacker;
function registerLocaleFallbacker(fallbacker) {
  _fallbacker = fallbacker;
}
let _cid = 0;
function createCoreContext(options = {}) {
  const version2 = isString$1(options.version) ? options.version : VERSION$1;
  const locale2 = isString$1(options.locale) ? options.locale : DEFAULT_LOCALE$1;
  const fallbackLocale = isArray$1(options.fallbackLocale) || isPlainObject(options.fallbackLocale) || isString$1(options.fallbackLocale) || options.fallbackLocale === false ? options.fallbackLocale : locale2;
  const messages = isPlainObject(options.messages) ? options.messages : {
    [locale2]: {}
  };
  const datetimeFormats = isPlainObject(options.datetimeFormats) ? options.datetimeFormats : {
    [locale2]: {}
  };
  const numberFormats = isPlainObject(options.numberFormats) ? options.numberFormats : {
    [locale2]: {}
  };
  const modifiers = assign({}, options.modifiers || {}, getDefaultLinkedModifiers());
  const pluralRules = options.pluralRules || {};
  const missing = isFunction$1(options.missing) ? options.missing : null;
  const missingWarn = isBoolean(options.missingWarn) || isRegExp(options.missingWarn) ? options.missingWarn : true;
  const fallbackWarn = isBoolean(options.fallbackWarn) || isRegExp(options.fallbackWarn) ? options.fallbackWarn : true;
  const fallbackFormat = !!options.fallbackFormat;
  const unresolving = !!options.unresolving;
  const postTranslation = isFunction$1(options.postTranslation) ? options.postTranslation : null;
  const processor = isPlainObject(options.processor) ? options.processor : null;
  const warnHtmlMessage = isBoolean(options.warnHtmlMessage) ? options.warnHtmlMessage : true;
  const escapeParameter = !!options.escapeParameter;
  const messageCompiler = isFunction$1(options.messageCompiler) ? options.messageCompiler : _compiler;
  const messageResolver = isFunction$1(options.messageResolver) ? options.messageResolver : _resolver || resolveWithKeyValue;
  const localeFallbacker = isFunction$1(options.localeFallbacker) ? options.localeFallbacker : _fallbacker || fallbackWithSimple;
  const fallbackContext = isObject$3(options.fallbackContext) ? options.fallbackContext : void 0;
  const onWarn = isFunction$1(options.onWarn) ? options.onWarn : warn;
  const internalOptions = options;
  const __datetimeFormatters = isObject$3(internalOptions.__datetimeFormatters) ? internalOptions.__datetimeFormatters : /* @__PURE__ */ new Map();
  const __numberFormatters = isObject$3(internalOptions.__numberFormatters) ? internalOptions.__numberFormatters : /* @__PURE__ */ new Map();
  const __meta = isObject$3(internalOptions.__meta) ? internalOptions.__meta : {};
  _cid++;
  const context = {
    version: version2,
    cid: _cid,
    locale: locale2,
    fallbackLocale,
    messages,
    modifiers,
    pluralRules,
    missing,
    missingWarn,
    fallbackWarn,
    fallbackFormat,
    unresolving,
    postTranslation,
    processor,
    warnHtmlMessage,
    escapeParameter,
    messageCompiler,
    messageResolver,
    localeFallbacker,
    fallbackContext,
    onWarn,
    __meta
  };
  {
    context.datetimeFormats = datetimeFormats;
    context.numberFormats = numberFormats;
    context.__datetimeFormatters = __datetimeFormatters;
    context.__numberFormatters = __numberFormatters;
  }
  return context;
}
function handleMissing(context, key, locale2, missingWarn, type) {
  const {
    missing,
    onWarn
  } = context;
  if (missing !== null) {
    const ret = missing(context, locale2, key, type);
    return isString$1(ret) ? ret : key;
  } else {
    return key;
  }
}
function updateFallbackLocale(ctx, locale2, fallback) {
  const context = ctx;
  context.__localeChainCache = /* @__PURE__ */ new Map();
  ctx.localeFallbacker(ctx, fallback, locale2);
}
const defaultOnCacheKey = (source) => source;
let compileCache = /* @__PURE__ */ Object.create(null);
function compileToFunction(source, options = {}) {
  {
    const onCacheKey = options.onCacheKey || defaultOnCacheKey;
    const key = onCacheKey(source);
    const cached = compileCache[key];
    if (cached) {
      return cached;
    }
    let occurred = false;
    const onError = options.onError || defaultOnError;
    options.onError = (err) => {
      occurred = true;
      onError(err);
    };
    const {
      code: code2
    } = baseCompile(source, options);
    const msg = new Function(`return ${code2}`)();
    return !occurred ? compileCache[key] = msg : msg;
  }
}
let code$1 = CompileErrorCodes.__EXTEND_POINT__;
const inc$1 = () => ++code$1;
const CoreErrorCodes = {
  INVALID_ARGUMENT: code$1,
  INVALID_DATE_ARGUMENT: inc$1(),
  INVALID_ISO_DATE_ARGUMENT: inc$1(),
  __EXTEND_POINT__: inc$1()
  // 18
};
function createCoreError(code2) {
  return createCompileError(code2, null, void 0);
}
const NOOP_MESSAGE_FUNCTION = () => "";
const isMessageFunction = (val) => isFunction$1(val);
function translate$1(context, ...args) {
  const {
    fallbackFormat,
    postTranslation,
    unresolving,
    messageCompiler,
    fallbackLocale,
    messages
  } = context;
  const [key, options] = parseTranslateArgs(...args);
  const missingWarn = isBoolean(options.missingWarn) ? options.missingWarn : context.missingWarn;
  const fallbackWarn = isBoolean(options.fallbackWarn) ? options.fallbackWarn : context.fallbackWarn;
  const escapeParameter = isBoolean(options.escapeParameter) ? options.escapeParameter : context.escapeParameter;
  const resolvedMessage = !!options.resolvedMessage;
  const defaultMsgOrKey = isString$1(options.default) || isBoolean(options.default) ? !isBoolean(options.default) ? options.default : !messageCompiler ? () => key : key : fallbackFormat ? !messageCompiler ? () => key : key : "";
  const enableDefaultMsg = fallbackFormat || defaultMsgOrKey !== "";
  const locale2 = isString$1(options.locale) ? options.locale : context.locale;
  escapeParameter && escapeParams(options);
  let [formatScope, targetLocale, message2] = !resolvedMessage ? resolveMessageFormat(context, key, locale2, fallbackLocale, fallbackWarn, missingWarn) : [key, locale2, messages[locale2] || {}];
  let format2 = formatScope;
  let cacheBaseKey = key;
  if (!resolvedMessage && !(isString$1(format2) || isMessageFunction(format2))) {
    if (enableDefaultMsg) {
      format2 = defaultMsgOrKey;
      cacheBaseKey = format2;
    }
  }
  if (!resolvedMessage && (!(isString$1(format2) || isMessageFunction(format2)) || !isString$1(targetLocale))) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let occurred = false;
  const errorDetector = () => {
    occurred = true;
  };
  const msg = !isMessageFunction(format2) ? compileMessageFormat(context, key, targetLocale, format2, cacheBaseKey, errorDetector) : format2;
  if (occurred) {
    return format2;
  }
  const ctxOptions = getMessageContextOptions(context, targetLocale, message2, options);
  const msgContext = createMessageContext(ctxOptions);
  const messaged = evaluateMessage(context, msg, msgContext);
  const ret = postTranslation ? postTranslation(messaged, key) : messaged;
  return ret;
}
function escapeParams(options) {
  if (isArray$1(options.list)) {
    options.list = options.list.map((item) => isString$1(item) ? escapeHtml(item) : item);
  } else if (isObject$3(options.named)) {
    Object.keys(options.named).forEach((key) => {
      if (isString$1(options.named[key])) {
        options.named[key] = escapeHtml(options.named[key]);
      }
    });
  }
}
function resolveMessageFormat(context, key, locale2, fallbackLocale, fallbackWarn, missingWarn) {
  const {
    messages,
    onWarn,
    messageResolver: resolveValue2,
    localeFallbacker
  } = context;
  const locales = localeFallbacker(context, fallbackLocale, locale2);
  let message2 = {};
  let targetLocale;
  let format2 = null;
  const type = "translate";
  for (let i2 = 0; i2 < locales.length; i2++) {
    targetLocale = locales[i2];
    message2 = messages[targetLocale] || {};
    if ((format2 = resolveValue2(message2, key)) === null) {
      format2 = message2[key];
    }
    if (isString$1(format2) || isFunction$1(format2))
      break;
    const missingRet = handleMissing(
      context,
      // eslint-disable-line @typescript-eslint/no-explicit-any
      key,
      targetLocale,
      missingWarn,
      type
    );
    if (missingRet !== key) {
      format2 = missingRet;
    }
  }
  return [format2, targetLocale, message2];
}
function compileMessageFormat(context, key, targetLocale, format2, cacheBaseKey, errorDetector) {
  const {
    messageCompiler,
    warnHtmlMessage
  } = context;
  if (isMessageFunction(format2)) {
    const msg2 = format2;
    msg2.locale = msg2.locale || targetLocale;
    msg2.key = msg2.key || key;
    return msg2;
  }
  if (messageCompiler == null) {
    const msg2 = () => format2;
    msg2.locale = targetLocale;
    msg2.key = key;
    return msg2;
  }
  const msg = messageCompiler(format2, getCompileOptions(context, targetLocale, cacheBaseKey, format2, warnHtmlMessage, errorDetector));
  msg.locale = targetLocale;
  msg.key = key;
  msg.source = format2;
  return msg;
}
function evaluateMessage(context, msg, msgCtx) {
  const messaged = msg(msgCtx);
  return messaged;
}
function parseTranslateArgs(...args) {
  const [arg1, arg2, arg3] = args;
  const options = {};
  if (!isString$1(arg1) && !isNumber$1(arg1) && !isMessageFunction(arg1)) {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  const key = isNumber$1(arg1) ? String(arg1) : isMessageFunction(arg1) ? arg1 : arg1;
  if (isNumber$1(arg2)) {
    options.plural = arg2;
  } else if (isString$1(arg2)) {
    options.default = arg2;
  } else if (isPlainObject(arg2) && !isEmptyObject(arg2)) {
    options.named = arg2;
  } else if (isArray$1(arg2)) {
    options.list = arg2;
  }
  if (isNumber$1(arg3)) {
    options.plural = arg3;
  } else if (isString$1(arg3)) {
    options.default = arg3;
  } else if (isPlainObject(arg3)) {
    assign(options, arg3);
  }
  return [key, options];
}
function getCompileOptions(context, locale2, key, source, warnHtmlMessage, errorDetector) {
  return {
    warnHtmlMessage,
    onError: (err) => {
      errorDetector && errorDetector(err);
      {
        throw err;
      }
    },
    onCacheKey: (source2) => generateFormatCacheKey(locale2, key, source2)
  };
}
function getMessageContextOptions(context, locale2, message2, options) {
  const {
    modifiers,
    pluralRules,
    messageResolver: resolveValue2,
    fallbackLocale,
    fallbackWarn,
    missingWarn,
    fallbackContext
  } = context;
  const resolveMessage = (key) => {
    let val = resolveValue2(message2, key);
    if (val == null && fallbackContext) {
      const [, , message3] = resolveMessageFormat(fallbackContext, key, locale2, fallbackLocale, fallbackWarn, missingWarn);
      val = resolveValue2(message3, key);
    }
    if (isString$1(val)) {
      let occurred = false;
      const errorDetector = () => {
        occurred = true;
      };
      const msg = compileMessageFormat(context, key, locale2, val, key, errorDetector);
      return !occurred ? msg : NOOP_MESSAGE_FUNCTION;
    } else if (isMessageFunction(val)) {
      return val;
    } else {
      return NOOP_MESSAGE_FUNCTION;
    }
  };
  const ctxOptions = {
    locale: locale2,
    modifiers,
    pluralRules,
    messages: resolveMessage
  };
  if (context.processor) {
    ctxOptions.processor = context.processor;
  }
  if (options.list) {
    ctxOptions.list = options.list;
  }
  if (options.named) {
    ctxOptions.named = options.named;
  }
  if (isNumber$1(options.plural)) {
    ctxOptions.pluralIndex = options.plural;
  }
  return ctxOptions;
}
function datetime(context, ...args) {
  const {
    datetimeFormats,
    unresolving,
    fallbackLocale,
    onWarn,
    localeFallbacker
  } = context;
  const {
    __datetimeFormatters
  } = context;
  const [key, value, options, overrides] = parseDateTimeArgs(...args);
  const missingWarn = isBoolean(options.missingWarn) ? options.missingWarn : context.missingWarn;
  isBoolean(options.fallbackWarn) ? options.fallbackWarn : context.fallbackWarn;
  const part = !!options.part;
  const locale2 = isString$1(options.locale) ? options.locale : context.locale;
  const locales = localeFallbacker(
    context,
    // eslint-disable-line @typescript-eslint/no-explicit-any
    fallbackLocale,
    locale2
  );
  if (!isString$1(key) || key === "") {
    return new Intl.DateTimeFormat(locale2, overrides).format(value);
  }
  let datetimeFormat = {};
  let targetLocale;
  let format2 = null;
  const type = "datetime format";
  for (let i2 = 0; i2 < locales.length; i2++) {
    targetLocale = locales[i2];
    datetimeFormat = datetimeFormats[targetLocale] || {};
    format2 = datetimeFormat[key];
    if (isPlainObject(format2))
      break;
    handleMissing(context, key, targetLocale, missingWarn, type);
  }
  if (!isPlainObject(format2) || !isString$1(targetLocale)) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let id = `${targetLocale}__${key}`;
  if (!isEmptyObject(overrides)) {
    id = `${id}__${JSON.stringify(overrides)}`;
  }
  let formatter = __datetimeFormatters.get(id);
  if (!formatter) {
    formatter = new Intl.DateTimeFormat(targetLocale, assign({}, format2, overrides));
    __datetimeFormatters.set(id, formatter);
  }
  return !part ? formatter.format(value) : formatter.formatToParts(value);
}
const DATETIME_FORMAT_OPTIONS_KEYS = ["localeMatcher", "weekday", "era", "year", "month", "day", "hour", "minute", "second", "timeZoneName", "formatMatcher", "hour12", "timeZone", "dateStyle", "timeStyle", "calendar", "dayPeriod", "numberingSystem", "hourCycle", "fractionalSecondDigits"];
function parseDateTimeArgs(...args) {
  const [arg1, arg2, arg3, arg4] = args;
  const options = {};
  let overrides = {};
  let value;
  if (isString$1(arg1)) {
    const matches = arg1.match(/(\d{4}-\d{2}-\d{2})(T|\s)?(.*)/);
    if (!matches) {
      throw createCoreError(CoreErrorCodes.INVALID_ISO_DATE_ARGUMENT);
    }
    const dateTime = matches[3] ? matches[3].trim().startsWith("T") ? `${matches[1].trim()}${matches[3].trim()}` : `${matches[1].trim()}T${matches[3].trim()}` : matches[1].trim();
    value = new Date(dateTime);
    try {
      value.toISOString();
    } catch (e2) {
      throw createCoreError(CoreErrorCodes.INVALID_ISO_DATE_ARGUMENT);
    }
  } else if (isDate(arg1)) {
    if (isNaN(arg1.getTime())) {
      throw createCoreError(CoreErrorCodes.INVALID_DATE_ARGUMENT);
    }
    value = arg1;
  } else if (isNumber$1(arg1)) {
    value = arg1;
  } else {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  if (isString$1(arg2)) {
    options.key = arg2;
  } else if (isPlainObject(arg2)) {
    Object.keys(arg2).forEach((key) => {
      if (DATETIME_FORMAT_OPTIONS_KEYS.includes(key)) {
        overrides[key] = arg2[key];
      } else {
        options[key] = arg2[key];
      }
    });
  }
  if (isString$1(arg3)) {
    options.locale = arg3;
  } else if (isPlainObject(arg3)) {
    overrides = arg3;
  }
  if (isPlainObject(arg4)) {
    overrides = arg4;
  }
  return [options.key || "", value, options, overrides];
}
function clearDateTimeFormat(ctx, locale2, format2) {
  const context = ctx;
  for (const key in format2) {
    const id = `${locale2}__${key}`;
    if (!context.__datetimeFormatters.has(id)) {
      continue;
    }
    context.__datetimeFormatters.delete(id);
  }
}
function number(context, ...args) {
  const {
    numberFormats,
    unresolving,
    fallbackLocale,
    onWarn,
    localeFallbacker
  } = context;
  const {
    __numberFormatters
  } = context;
  const [key, value, options, overrides] = parseNumberArgs(...args);
  const missingWarn = isBoolean(options.missingWarn) ? options.missingWarn : context.missingWarn;
  isBoolean(options.fallbackWarn) ? options.fallbackWarn : context.fallbackWarn;
  const part = !!options.part;
  const locale2 = isString$1(options.locale) ? options.locale : context.locale;
  const locales = localeFallbacker(
    context,
    // eslint-disable-line @typescript-eslint/no-explicit-any
    fallbackLocale,
    locale2
  );
  if (!isString$1(key) || key === "") {
    return new Intl.NumberFormat(locale2, overrides).format(value);
  }
  let numberFormat = {};
  let targetLocale;
  let format2 = null;
  const type = "number format";
  for (let i2 = 0; i2 < locales.length; i2++) {
    targetLocale = locales[i2];
    numberFormat = numberFormats[targetLocale] || {};
    format2 = numberFormat[key];
    if (isPlainObject(format2))
      break;
    handleMissing(context, key, targetLocale, missingWarn, type);
  }
  if (!isPlainObject(format2) || !isString$1(targetLocale)) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let id = `${targetLocale}__${key}`;
  if (!isEmptyObject(overrides)) {
    id = `${id}__${JSON.stringify(overrides)}`;
  }
  let formatter = __numberFormatters.get(id);
  if (!formatter) {
    formatter = new Intl.NumberFormat(targetLocale, assign({}, format2, overrides));
    __numberFormatters.set(id, formatter);
  }
  return !part ? formatter.format(value) : formatter.formatToParts(value);
}
const NUMBER_FORMAT_OPTIONS_KEYS = ["localeMatcher", "style", "currency", "currencyDisplay", "currencySign", "useGrouping", "minimumIntegerDigits", "minimumFractionDigits", "maximumFractionDigits", "minimumSignificantDigits", "maximumSignificantDigits", "compactDisplay", "notation", "signDisplay", "unit", "unitDisplay", "roundingMode", "roundingPriority", "roundingIncrement", "trailingZeroDisplay"];
function parseNumberArgs(...args) {
  const [arg1, arg2, arg3, arg4] = args;
  const options = {};
  let overrides = {};
  if (!isNumber$1(arg1)) {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  const value = arg1;
  if (isString$1(arg2)) {
    options.key = arg2;
  } else if (isPlainObject(arg2)) {
    Object.keys(arg2).forEach((key) => {
      if (NUMBER_FORMAT_OPTIONS_KEYS.includes(key)) {
        overrides[key] = arg2[key];
      } else {
        options[key] = arg2[key];
      }
    });
  }
  if (isString$1(arg3)) {
    options.locale = arg3;
  } else if (isPlainObject(arg3)) {
    overrides = arg3;
  }
  if (isPlainObject(arg4)) {
    overrides = arg4;
  }
  return [options.key || "", value, options, overrides];
}
function clearNumberFormat(ctx, locale2, format2) {
  const context = ctx;
  for (const key in format2) {
    const id = `${locale2}__${key}`;
    if (!context.__numberFormatters.has(id)) {
      continue;
    }
    context.__numberFormatters.delete(id);
  }
}
/*!
  * vue-i18n v9.2.2
  * (c) 2022 kazuya kawaguchi
  * Released under the MIT License.
  */
const VERSION = "9.2.2";
let code = CompileErrorCodes.__EXTEND_POINT__;
const inc = () => ++code;
const I18nErrorCodes = {
  // composer module errors
  UNEXPECTED_RETURN_TYPE: code,
  // legacy module errors
  INVALID_ARGUMENT: inc(),
  // i18n module errors
  MUST_BE_CALL_SETUP_TOP: inc(),
  NOT_INSLALLED: inc(),
  NOT_AVAILABLE_IN_LEGACY_MODE: inc(),
  // directive module errors
  REQUIRED_VALUE: inc(),
  INVALID_VALUE: inc(),
  // vue-devtools errors
  CANNOT_SETUP_VUE_DEVTOOLS_PLUGIN: inc(),
  NOT_INSLALLED_WITH_PROVIDE: inc(),
  // unexpected error
  UNEXPECTED_ERROR: inc(),
  // not compatible legacy vue-i18n constructor
  NOT_COMPATIBLE_LEGACY_VUE_I18N: inc(),
  // bridge support vue 2.x only
  BRIDGE_SUPPORT_VUE_2_ONLY: inc(),
  // need to define `i18n` option in `allowComposition: true` and `useScope: 'local' at `useI18n``
  MUST_DEFINE_I18N_OPTION_IN_ALLOW_COMPOSITION: inc(),
  // Not available Compostion API in Legacy API mode. Please make sure that the legacy API mode is working properly
  NOT_AVAILABLE_COMPOSITION_IN_LEGACY: inc(),
  // for enhancement
  __EXTEND_POINT__: inc()
  // 29
};
function createI18nError(code2, ...args) {
  return createCompileError(code2, null, void 0);
}
const TransrateVNodeSymbol = /* @__PURE__ */ makeSymbol("__transrateVNode");
const DatetimePartsSymbol = /* @__PURE__ */ makeSymbol("__datetimeParts");
const NumberPartsSymbol = /* @__PURE__ */ makeSymbol("__numberParts");
const SetPluralRulesSymbol = makeSymbol("__setPluralRules");
makeSymbol("__intlifyMeta");
const InejctWithOption = /* @__PURE__ */ makeSymbol("__injectWithOption");
function handleFlatJson(obj) {
  if (!isObject$3(obj)) {
    return obj;
  }
  for (const key in obj) {
    if (!hasOwn$1(obj, key)) {
      continue;
    }
    if (!key.includes(".")) {
      if (isObject$3(obj[key])) {
        handleFlatJson(obj[key]);
      }
    } else {
      const subKeys = key.split(".");
      const lastIndex = subKeys.length - 1;
      let currentObj = obj;
      for (let i2 = 0; i2 < lastIndex; i2++) {
        if (!(subKeys[i2] in currentObj)) {
          currentObj[subKeys[i2]] = {};
        }
        currentObj = currentObj[subKeys[i2]];
      }
      currentObj[subKeys[lastIndex]] = obj[key];
      delete obj[key];
      if (isObject$3(currentObj[subKeys[lastIndex]])) {
        handleFlatJson(currentObj[subKeys[lastIndex]]);
      }
    }
  }
  return obj;
}
function getLocaleMessages(locale2, options) {
  const {
    messages,
    __i18n,
    messageResolver,
    flatJson
  } = options;
  const ret = isPlainObject(messages) ? messages : isArray$1(__i18n) ? {} : {
    [locale2]: {}
  };
  if (isArray$1(__i18n)) {
    __i18n.forEach((custom) => {
      if ("locale" in custom && "resource" in custom) {
        const {
          locale: locale3,
          resource
        } = custom;
        if (locale3) {
          ret[locale3] = ret[locale3] || {};
          deepCopy(resource, ret[locale3]);
        } else {
          deepCopy(resource, ret);
        }
      } else {
        isString$1(custom) && deepCopy(JSON.parse(custom), ret);
      }
    });
  }
  if (messageResolver == null && flatJson) {
    for (const key in ret) {
      if (hasOwn$1(ret, key)) {
        handleFlatJson(ret[key]);
      }
    }
  }
  return ret;
}
const isNotObjectOrIsArray = (val) => !isObject$3(val) || isArray$1(val);
function deepCopy(src, des) {
  if (isNotObjectOrIsArray(src) || isNotObjectOrIsArray(des)) {
    throw createI18nError(I18nErrorCodes.INVALID_VALUE);
  }
  for (const key in src) {
    if (hasOwn$1(src, key)) {
      if (isNotObjectOrIsArray(src[key]) || isNotObjectOrIsArray(des[key])) {
        des[key] = src[key];
      } else {
        deepCopy(src[key], des[key]);
      }
    }
  }
}
function getComponentOptions(instance) {
  return instance.type;
}
function adjustI18nResources(global2, options, componentOptions) {
  let messages = isObject$3(options.messages) ? options.messages : {};
  if ("__i18nGlobal" in componentOptions) {
    messages = getLocaleMessages(global2.locale.value, {
      messages,
      __i18n: componentOptions.__i18nGlobal
    });
  }
  const locales = Object.keys(messages);
  if (locales.length) {
    locales.forEach((locale2) => {
      global2.mergeLocaleMessage(locale2, messages[locale2]);
    });
  }
  {
    if (isObject$3(options.datetimeFormats)) {
      const locales2 = Object.keys(options.datetimeFormats);
      if (locales2.length) {
        locales2.forEach((locale2) => {
          global2.mergeDateTimeFormat(locale2, options.datetimeFormats[locale2]);
        });
      }
    }
    if (isObject$3(options.numberFormats)) {
      const locales2 = Object.keys(options.numberFormats);
      if (locales2.length) {
        locales2.forEach((locale2) => {
          global2.mergeNumberFormat(locale2, options.numberFormats[locale2]);
        });
      }
    }
  }
}
function createTextNode(key) {
  return createVNode(Text, null, key, 0);
}
let composerID = 0;
function defineCoreMissingHandler(missing) {
  return (ctx, locale2, key, type) => {
    return missing(locale2, key, getCurrentInstance() || void 0, type);
  };
}
function createComposer(options = {}, VueI18nLegacy) {
  const {
    __root
  } = options;
  const _isGlobal = __root === void 0;
  let _inheritLocale = isBoolean(options.inheritLocale) ? options.inheritLocale : true;
  const _locale = ref(
    // prettier-ignore
    __root && _inheritLocale ? __root.locale.value : isString$1(options.locale) ? options.locale : DEFAULT_LOCALE$1
  );
  const _fallbackLocale = ref(
    // prettier-ignore
    __root && _inheritLocale ? __root.fallbackLocale.value : isString$1(options.fallbackLocale) || isArray$1(options.fallbackLocale) || isPlainObject(options.fallbackLocale) || options.fallbackLocale === false ? options.fallbackLocale : _locale.value
  );
  const _messages = ref(getLocaleMessages(_locale.value, options));
  const _datetimeFormats = ref(isPlainObject(options.datetimeFormats) ? options.datetimeFormats : {
    [_locale.value]: {}
  });
  const _numberFormats = ref(isPlainObject(options.numberFormats) ? options.numberFormats : {
    [_locale.value]: {}
  });
  let _missingWarn = __root ? __root.missingWarn : isBoolean(options.missingWarn) || isRegExp(options.missingWarn) ? options.missingWarn : true;
  let _fallbackWarn = __root ? __root.fallbackWarn : isBoolean(options.fallbackWarn) || isRegExp(options.fallbackWarn) ? options.fallbackWarn : true;
  let _fallbackRoot = __root ? __root.fallbackRoot : isBoolean(options.fallbackRoot) ? options.fallbackRoot : true;
  let _fallbackFormat = !!options.fallbackFormat;
  let _missing = isFunction$1(options.missing) ? options.missing : null;
  let _runtimeMissing = isFunction$1(options.missing) ? defineCoreMissingHandler(options.missing) : null;
  let _postTranslation = isFunction$1(options.postTranslation) ? options.postTranslation : null;
  let _warnHtmlMessage = __root ? __root.warnHtmlMessage : isBoolean(options.warnHtmlMessage) ? options.warnHtmlMessage : true;
  let _escapeParameter = !!options.escapeParameter;
  const _modifiers = __root ? __root.modifiers : isPlainObject(options.modifiers) ? options.modifiers : {};
  let _pluralRules = options.pluralRules || __root && __root.pluralRules;
  let _context;
  const getCoreContext = () => {
    const ctxOptions = {
      version: VERSION,
      locale: _locale.value,
      fallbackLocale: _fallbackLocale.value,
      messages: _messages.value,
      modifiers: _modifiers,
      pluralRules: _pluralRules,
      missing: _runtimeMissing === null ? void 0 : _runtimeMissing,
      missingWarn: _missingWarn,
      fallbackWarn: _fallbackWarn,
      fallbackFormat: _fallbackFormat,
      unresolving: true,
      postTranslation: _postTranslation === null ? void 0 : _postTranslation,
      warnHtmlMessage: _warnHtmlMessage,
      escapeParameter: _escapeParameter,
      messageResolver: options.messageResolver,
      __meta: {
        framework: "vue"
      }
    };
    {
      ctxOptions.datetimeFormats = _datetimeFormats.value;
      ctxOptions.numberFormats = _numberFormats.value;
      ctxOptions.__datetimeFormatters = isPlainObject(_context) ? _context.__datetimeFormatters : void 0;
      ctxOptions.__numberFormatters = isPlainObject(_context) ? _context.__numberFormatters : void 0;
    }
    const ctx = createCoreContext(ctxOptions);
    return ctx;
  };
  _context = getCoreContext();
  updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
  function trackReactivityValues() {
    return [_locale.value, _fallbackLocale.value, _messages.value, _datetimeFormats.value, _numberFormats.value];
  }
  const locale2 = computed({
    get: () => _locale.value,
    set: (val) => {
      _locale.value = val;
      _context.locale = _locale.value;
    }
  });
  const fallbackLocale = computed({
    get: () => _fallbackLocale.value,
    set: (val) => {
      _fallbackLocale.value = val;
      _context.fallbackLocale = _fallbackLocale.value;
      updateFallbackLocale(_context, _locale.value, val);
    }
  });
  const messages = computed(() => _messages.value);
  const datetimeFormats = /* @__PURE__ */ computed(() => _datetimeFormats.value);
  const numberFormats = /* @__PURE__ */ computed(() => _numberFormats.value);
  function getPostTranslationHandler() {
    return isFunction$1(_postTranslation) ? _postTranslation : null;
  }
  function setPostTranslationHandler(handler) {
    _postTranslation = handler;
    _context.postTranslation = handler;
  }
  function getMissingHandler() {
    return _missing;
  }
  function setMissingHandler(handler) {
    if (handler !== null) {
      _runtimeMissing = defineCoreMissingHandler(handler);
    }
    _missing = handler;
    _context.missing = _runtimeMissing;
  }
  const wrapWithDeps = (fn, argumentParser, warnType, fallbackSuccess, fallbackFail, successCondition) => {
    trackReactivityValues();
    let ret;
    {
      ret = fn(_context);
    }
    if (isNumber$1(ret) && ret === NOT_REOSLVED) {
      const [key, arg2] = argumentParser();
      return __root && _fallbackRoot ? fallbackSuccess(__root) : fallbackFail(key);
    } else if (successCondition(ret)) {
      return ret;
    } else {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_RETURN_TYPE);
    }
  };
  function t2(...args) {
    return wrapWithDeps((context) => Reflect.apply(translate$1, null, [context, ...args]), () => parseTranslateArgs(...args), "translate", (root) => Reflect.apply(root.t, root, [...args]), (key) => key, (val) => isString$1(val));
  }
  function rt2(...args) {
    const [arg1, arg2, arg3] = args;
    if (arg3 && !isObject$3(arg3)) {
      throw createI18nError(I18nErrorCodes.INVALID_ARGUMENT);
    }
    return t2(...[arg1, arg2, assign({
      resolvedMessage: true
    }, arg3 || {})]);
  }
  function d(...args) {
    return wrapWithDeps((context) => Reflect.apply(datetime, null, [context, ...args]), () => parseDateTimeArgs(...args), "datetime format", (root) => Reflect.apply(root.d, root, [...args]), () => MISSING_RESOLVE_VALUE, (val) => isString$1(val));
  }
  function n2(...args) {
    return wrapWithDeps((context) => Reflect.apply(number, null, [context, ...args]), () => parseNumberArgs(...args), "number format", (root) => Reflect.apply(root.n, root, [...args]), () => MISSING_RESOLVE_VALUE, (val) => isString$1(val));
  }
  function normalize2(values) {
    return values.map((val) => isString$1(val) || isNumber$1(val) || isBoolean(val) ? createTextNode(String(val)) : val);
  }
  const interpolate = (val) => val;
  const processor = {
    normalize: normalize2,
    interpolate,
    type: "vnode"
  };
  function transrateVNode(...args) {
    return wrapWithDeps(
      (context) => {
        let ret;
        const _context2 = context;
        try {
          _context2.processor = processor;
          ret = Reflect.apply(translate$1, null, [_context2, ...args]);
        } finally {
          _context2.processor = null;
        }
        return ret;
      },
      () => parseTranslateArgs(...args),
      "translate",
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (root) => root[TransrateVNodeSymbol](...args),
      (key) => [createTextNode(key)],
      (val) => isArray$1(val)
    );
  }
  function numberParts(...args) {
    return wrapWithDeps(
      (context) => Reflect.apply(number, null, [context, ...args]),
      () => parseNumberArgs(...args),
      "number format",
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (root) => root[NumberPartsSymbol](...args),
      () => [],
      (val) => isString$1(val) || isArray$1(val)
    );
  }
  function datetimeParts(...args) {
    return wrapWithDeps(
      (context) => Reflect.apply(datetime, null, [context, ...args]),
      () => parseDateTimeArgs(...args),
      "datetime format",
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (root) => root[DatetimePartsSymbol](...args),
      () => [],
      (val) => isString$1(val) || isArray$1(val)
    );
  }
  function setPluralRules(rules) {
    _pluralRules = rules;
    _context.pluralRules = _pluralRules;
  }
  function te(key, locale3) {
    const targetLocale = isString$1(locale3) ? locale3 : _locale.value;
    const message2 = getLocaleMessage(targetLocale);
    return _context.messageResolver(message2, key) !== null;
  }
  function resolveMessages(key) {
    let messages2 = null;
    const locales = fallbackWithLocaleChain(_context, _fallbackLocale.value, _locale.value);
    for (let i2 = 0; i2 < locales.length; i2++) {
      const targetLocaleMessages = _messages.value[locales[i2]] || {};
      const messageValue = _context.messageResolver(targetLocaleMessages, key);
      if (messageValue != null) {
        messages2 = messageValue;
        break;
      }
    }
    return messages2;
  }
  function tm(key) {
    const messages2 = resolveMessages(key);
    return messages2 != null ? messages2 : __root ? __root.tm(key) || {} : {};
  }
  function getLocaleMessage(locale3) {
    return _messages.value[locale3] || {};
  }
  function setLocaleMessage(locale3, message2) {
    _messages.value[locale3] = message2;
    _context.messages = _messages.value;
  }
  function mergeLocaleMessage(locale3, message2) {
    _messages.value[locale3] = _messages.value[locale3] || {};
    deepCopy(message2, _messages.value[locale3]);
    _context.messages = _messages.value;
  }
  function getDateTimeFormat(locale3) {
    return _datetimeFormats.value[locale3] || {};
  }
  function setDateTimeFormat(locale3, format2) {
    _datetimeFormats.value[locale3] = format2;
    _context.datetimeFormats = _datetimeFormats.value;
    clearDateTimeFormat(_context, locale3, format2);
  }
  function mergeDateTimeFormat(locale3, format2) {
    _datetimeFormats.value[locale3] = assign(_datetimeFormats.value[locale3] || {}, format2);
    _context.datetimeFormats = _datetimeFormats.value;
    clearDateTimeFormat(_context, locale3, format2);
  }
  function getNumberFormat(locale3) {
    return _numberFormats.value[locale3] || {};
  }
  function setNumberFormat(locale3, format2) {
    _numberFormats.value[locale3] = format2;
    _context.numberFormats = _numberFormats.value;
    clearNumberFormat(_context, locale3, format2);
  }
  function mergeNumberFormat(locale3, format2) {
    _numberFormats.value[locale3] = assign(_numberFormats.value[locale3] || {}, format2);
    _context.numberFormats = _numberFormats.value;
    clearNumberFormat(_context, locale3, format2);
  }
  composerID++;
  if (__root && inBrowser) {
    watch(__root.locale, (val) => {
      if (_inheritLocale) {
        _locale.value = val;
        _context.locale = val;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    });
    watch(__root.fallbackLocale, (val) => {
      if (_inheritLocale) {
        _fallbackLocale.value = val;
        _context.fallbackLocale = val;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    });
  }
  const composer = {
    id: composerID,
    locale: locale2,
    fallbackLocale,
    get inheritLocale() {
      return _inheritLocale;
    },
    set inheritLocale(val) {
      _inheritLocale = val;
      if (val && __root) {
        _locale.value = __root.locale.value;
        _fallbackLocale.value = __root.fallbackLocale.value;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    },
    get availableLocales() {
      return Object.keys(_messages.value).sort();
    },
    messages,
    get modifiers() {
      return _modifiers;
    },
    get pluralRules() {
      return _pluralRules || {};
    },
    get isGlobal() {
      return _isGlobal;
    },
    get missingWarn() {
      return _missingWarn;
    },
    set missingWarn(val) {
      _missingWarn = val;
      _context.missingWarn = _missingWarn;
    },
    get fallbackWarn() {
      return _fallbackWarn;
    },
    set fallbackWarn(val) {
      _fallbackWarn = val;
      _context.fallbackWarn = _fallbackWarn;
    },
    get fallbackRoot() {
      return _fallbackRoot;
    },
    set fallbackRoot(val) {
      _fallbackRoot = val;
    },
    get fallbackFormat() {
      return _fallbackFormat;
    },
    set fallbackFormat(val) {
      _fallbackFormat = val;
      _context.fallbackFormat = _fallbackFormat;
    },
    get warnHtmlMessage() {
      return _warnHtmlMessage;
    },
    set warnHtmlMessage(val) {
      _warnHtmlMessage = val;
      _context.warnHtmlMessage = val;
    },
    get escapeParameter() {
      return _escapeParameter;
    },
    set escapeParameter(val) {
      _escapeParameter = val;
      _context.escapeParameter = val;
    },
    t: t2,
    getLocaleMessage,
    setLocaleMessage,
    mergeLocaleMessage,
    getPostTranslationHandler,
    setPostTranslationHandler,
    getMissingHandler,
    setMissingHandler,
    [SetPluralRulesSymbol]: setPluralRules
  };
  {
    composer.datetimeFormats = datetimeFormats;
    composer.numberFormats = numberFormats;
    composer.rt = rt2;
    composer.te = te;
    composer.tm = tm;
    composer.d = d;
    composer.n = n2;
    composer.getDateTimeFormat = getDateTimeFormat;
    composer.setDateTimeFormat = setDateTimeFormat;
    composer.mergeDateTimeFormat = mergeDateTimeFormat;
    composer.getNumberFormat = getNumberFormat;
    composer.setNumberFormat = setNumberFormat;
    composer.mergeNumberFormat = mergeNumberFormat;
    composer[InejctWithOption] = options.__injectWithOption;
    composer[TransrateVNodeSymbol] = transrateVNode;
    composer[DatetimePartsSymbol] = datetimeParts;
    composer[NumberPartsSymbol] = numberParts;
  }
  return composer;
}
const baseFormatProps = {
  tag: {
    type: [String, Object]
  },
  locale: {
    type: String
  },
  scope: {
    type: String,
    // NOTE: avoid https://github.com/microsoft/rushstack/issues/1050
    validator: (val) => val === "parent" || val === "global",
    default: "parent"
    /* ComponetI18nScope */
  },
  i18n: {
    type: Object
  }
};
function getInterpolateArg({
  slots
}, keys2) {
  if (keys2.length === 1 && keys2[0] === "default") {
    const ret = slots.default ? slots.default() : [];
    return ret.reduce((slot, current) => {
      return slot = [...slot, ...isArray$1(current.children) ? current.children : [current]];
    }, []);
  } else {
    return keys2.reduce((arg, key) => {
      const slot = slots[key];
      if (slot) {
        arg[key] = slot();
      }
      return arg;
    }, {});
  }
}
function getFragmentableTag(tag) {
  return Fragment;
}
const Translation = (
  /* defineComponent */
  {
    /* eslint-disable */
    name: "i18n-t",
    props: assign({
      keypath: {
        type: String,
        required: true
      },
      plural: {
        type: [Number, String],
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        validator: (val) => isNumber$1(val) || !isNaN(val)
      }
    }, baseFormatProps),
    /* eslint-enable */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    setup(props, context) {
      const {
        slots,
        attrs
      } = context;
      const i18n2 = props.i18n || useI18n({
        useScope: props.scope,
        __useComponent: true
      });
      return () => {
        const keys2 = Object.keys(slots).filter((key) => key !== "_");
        const options = {};
        if (props.locale) {
          options.locale = props.locale;
        }
        if (props.plural !== void 0) {
          options.plural = isString$1(props.plural) ? +props.plural : props.plural;
        }
        const arg = getInterpolateArg(context, keys2);
        const children = i18n2[TransrateVNodeSymbol](props.keypath, arg, options);
        const assignedAttrs = assign({}, attrs);
        const tag = isString$1(props.tag) || isObject$3(props.tag) ? props.tag : getFragmentableTag();
        return h(tag, assignedAttrs, children);
      };
    }
  }
);
function isVNode(target2) {
  return isArray$1(target2) && !isString$1(target2[0]);
}
function renderFormatter(props, context, slotKeys, partFormatter) {
  const {
    slots,
    attrs
  } = context;
  return () => {
    const options = {
      part: true
    };
    let overrides = {};
    if (props.locale) {
      options.locale = props.locale;
    }
    if (isString$1(props.format)) {
      options.key = props.format;
    } else if (isObject$3(props.format)) {
      if (isString$1(props.format.key)) {
        options.key = props.format.key;
      }
      overrides = Object.keys(props.format).reduce((options2, prop) => {
        return slotKeys.includes(prop) ? assign({}, options2, {
          [prop]: props.format[prop]
        }) : options2;
      }, {});
    }
    const parts = partFormatter(...[props.value, options, overrides]);
    let children = [options.key];
    if (isArray$1(parts)) {
      children = parts.map((part, index2) => {
        const slot = slots[part.type];
        const node = slot ? slot({
          [part.type]: part.value,
          index: index2,
          parts
        }) : [part.value];
        if (isVNode(node)) {
          node[0].key = `${part.type}-${index2}`;
        }
        return node;
      });
    } else if (isString$1(parts)) {
      children = [parts];
    }
    const assignedAttrs = assign({}, attrs);
    const tag = isString$1(props.tag) || isObject$3(props.tag) ? props.tag : getFragmentableTag();
    return h(tag, assignedAttrs, children);
  };
}
const NumberFormat = (
  /* defineComponent */
  {
    /* eslint-disable */
    name: "i18n-n",
    props: assign({
      value: {
        type: Number,
        required: true
      },
      format: {
        type: [String, Object]
      }
    }, baseFormatProps),
    /* eslint-enable */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    setup(props, context) {
      const i18n2 = props.i18n || useI18n({
        useScope: "parent",
        __useComponent: true
      });
      return renderFormatter(props, context, NUMBER_FORMAT_OPTIONS_KEYS, (...args) => (
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        i18n2[NumberPartsSymbol](...args)
      ));
    }
  }
);
const DatetimeFormat = (
  /*defineComponent */
  {
    /* eslint-disable */
    name: "i18n-d",
    props: assign({
      value: {
        type: [Number, Date],
        required: true
      },
      format: {
        type: [String, Object]
      }
    }, baseFormatProps),
    /* eslint-enable */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    setup(props, context) {
      const i18n2 = props.i18n || useI18n({
        useScope: "parent",
        __useComponent: true
      });
      return renderFormatter(props, context, DATETIME_FORMAT_OPTIONS_KEYS, (...args) => (
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        i18n2[DatetimePartsSymbol](...args)
      ));
    }
  }
);
function getComposer$2(i18n2, instance) {
  const i18nInternal = i18n2;
  if (i18n2.mode === "composition") {
    return i18nInternal.__getInstance(instance) || i18n2.global;
  } else {
    const vueI18n = i18nInternal.__getInstance(instance);
    return vueI18n != null ? vueI18n.__composer : i18n2.global.__composer;
  }
}
function vTDirective(i18n2) {
  const _process = (binding) => {
    const {
      instance,
      modifiers,
      value
    } = binding;
    if (!instance || !instance.$) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    const composer = getComposer$2(i18n2, instance.$);
    const parsedValue = parseValue(value);
    return [Reflect.apply(composer.t, composer, [...makeParams(parsedValue)]), composer];
  };
  const register2 = (el, binding) => {
    const [textContent, composer] = _process(binding);
    if (inBrowser && i18n2.global === composer) {
      el.__i18nWatcher = watch(composer.locale, () => {
        binding.instance && binding.instance.$forceUpdate();
      });
    }
    el.__composer = composer;
    el.textContent = textContent;
  };
  const unregister2 = (el) => {
    if (inBrowser && el.__i18nWatcher) {
      el.__i18nWatcher();
      el.__i18nWatcher = void 0;
      delete el.__i18nWatcher;
    }
    if (el.__composer) {
      el.__composer = void 0;
      delete el.__composer;
    }
  };
  const update = (el, {
    value
  }) => {
    if (el.__composer) {
      const composer = el.__composer;
      const parsedValue = parseValue(value);
      el.textContent = Reflect.apply(composer.t, composer, [...makeParams(parsedValue)]);
    }
  };
  const getSSRProps = (binding) => {
    const [textContent] = _process(binding);
    return {
      textContent
    };
  };
  return {
    created: register2,
    unmounted: unregister2,
    beforeUpdate: update,
    getSSRProps
  };
}
function parseValue(value) {
  if (isString$1(value)) {
    return {
      path: value
    };
  } else if (isPlainObject(value)) {
    if (!("path" in value)) {
      throw createI18nError(I18nErrorCodes.REQUIRED_VALUE, "path");
    }
    return value;
  } else {
    throw createI18nError(I18nErrorCodes.INVALID_VALUE);
  }
}
function makeParams(value) {
  const {
    path,
    locale: locale2,
    args,
    choice,
    plural
  } = value;
  const options = {};
  const named = args || {};
  if (isString$1(locale2)) {
    options.locale = locale2;
  }
  if (isNumber$1(choice)) {
    options.plural = choice;
  }
  if (isNumber$1(plural)) {
    options.plural = plural;
  }
  return [path, named, options];
}
function apply(app, i18n2, ...options) {
  const pluginOptions = isPlainObject(options[0]) ? options[0] : {};
  const useI18nComponentName = !!pluginOptions.useI18nComponentName;
  const globalInstall = isBoolean(pluginOptions.globalInstall) ? pluginOptions.globalInstall : true;
  if (globalInstall) {
    app.component(!useI18nComponentName ? Translation.name : "i18n", Translation);
    app.component(NumberFormat.name, NumberFormat);
    app.component(DatetimeFormat.name, DatetimeFormat);
  }
  {
    app.directive("t", vTDirective(i18n2));
  }
}
const I18nInjectionKey = /* @__PURE__ */ makeSymbol("global-vue-i18n");
function createI18n(options = {}, VueI18nLegacy) {
  const __globalInjection = isBoolean(options.globalInjection) ? options.globalInjection : true;
  const __allowComposition = true;
  const __instances = /* @__PURE__ */ new Map();
  const [globalScope, __global] = createGlobal(options);
  const symbol = makeSymbol("");
  function __getInstance(component) {
    return __instances.get(component) || null;
  }
  function __setInstance(component, instance) {
    __instances.set(component, instance);
  }
  function __deleteInstance(component) {
    __instances.delete(component);
  }
  {
    const i18n2 = {
      // mode
      get mode() {
        return "composition";
      },
      // allowComposition
      get allowComposition() {
        return __allowComposition;
      },
      // install plugin
      async install(app, ...options2) {
        app.__VUE_I18N_SYMBOL__ = symbol;
        app.provide(app.__VUE_I18N_SYMBOL__, i18n2);
        if (__globalInjection) {
          injectGlobalFields(app, i18n2.global);
        }
        {
          apply(app, i18n2, ...options2);
        }
        const unmountApp = app.unmount;
        app.unmount = () => {
          i18n2.dispose();
          unmountApp();
        };
      },
      // global accessor
      get global() {
        return __global;
      },
      dispose() {
        globalScope.stop();
      },
      // @internal
      __instances,
      // @internal
      __getInstance,
      // @internal
      __setInstance,
      // @internal
      __deleteInstance
    };
    return i18n2;
  }
}
function useI18n(options = {}) {
  const instance = getCurrentInstance();
  if (instance == null) {
    throw createI18nError(I18nErrorCodes.MUST_BE_CALL_SETUP_TOP);
  }
  if (!instance.isCE && instance.appContext.app != null && !instance.appContext.app.__VUE_I18N_SYMBOL__) {
    throw createI18nError(I18nErrorCodes.NOT_INSLALLED);
  }
  const i18n2 = getI18nInstance(instance);
  const global2 = getGlobalComposer(i18n2);
  const componentOptions = getComponentOptions(instance);
  const scope = getScope(options, componentOptions);
  if (scope === "global") {
    adjustI18nResources(global2, options, componentOptions);
    return global2;
  }
  if (scope === "parent") {
    let composer2 = getComposer(i18n2, instance, options.__useComponent);
    if (composer2 == null) {
      composer2 = global2;
    }
    return composer2;
  }
  const i18nInternal = i18n2;
  let composer = i18nInternal.__getInstance(instance);
  if (composer == null) {
    const composerOptions = assign({}, options);
    if ("__i18n" in componentOptions) {
      composerOptions.__i18n = componentOptions.__i18n;
    }
    if (global2) {
      composerOptions.__root = global2;
    }
    composer = createComposer(composerOptions);
    setupLifeCycle(i18nInternal, instance);
    i18nInternal.__setInstance(instance, composer);
  }
  return composer;
}
function createGlobal(options, legacyMode, VueI18nLegacy) {
  const scope = effectScope();
  {
    const obj = scope.run(() => createComposer(options));
    if (obj == null) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    return [scope, obj];
  }
}
function getI18nInstance(instance) {
  {
    const i18n2 = inject(!instance.isCE ? instance.appContext.app.__VUE_I18N_SYMBOL__ : I18nInjectionKey);
    if (!i18n2) {
      throw createI18nError(!instance.isCE ? I18nErrorCodes.UNEXPECTED_ERROR : I18nErrorCodes.NOT_INSLALLED_WITH_PROVIDE);
    }
    return i18n2;
  }
}
function getScope(options, componentOptions) {
  return isEmptyObject(options) ? "__i18n" in componentOptions ? "local" : "global" : !options.useScope ? "local" : options.useScope;
}
function getGlobalComposer(i18n2) {
  return i18n2.mode === "composition" ? i18n2.global : i18n2.global.__composer;
}
function getComposer(i18n2, target2, useComponent = false) {
  let composer = null;
  const root = target2.root;
  let current = target2.parent;
  while (current != null) {
    const i18nInternal = i18n2;
    if (i18n2.mode === "composition") {
      composer = i18nInternal.__getInstance(current);
    }
    if (composer != null) {
      break;
    }
    if (root === current) {
      break;
    }
    current = current.parent;
  }
  return composer;
}
function setupLifeCycle(i18n2, target2, composer) {
  {
    onMounted(() => {
    }, target2);
    onUnmounted(() => {
      i18n2.__deleteInstance(target2);
    }, target2);
  }
}
const globalExportProps = ["locale", "fallbackLocale", "availableLocales"];
const globalExportMethods = ["t", "rt", "d", "n", "tm"];
function injectGlobalFields(app, composer) {
  const i18n2 = /* @__PURE__ */ Object.create(null);
  globalExportProps.forEach((prop) => {
    const desc = Object.getOwnPropertyDescriptor(composer, prop);
    if (!desc) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    const wrap = isRef(desc.value) ? {
      get() {
        return desc.value.value;
      },
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      set(val) {
        desc.value.value = val;
      }
    } : {
      get() {
        return desc.get && desc.get();
      }
    };
    Object.defineProperty(i18n2, prop, wrap);
  });
  app.config.globalProperties.$i18n = i18n2;
  globalExportMethods.forEach((method) => {
    const desc = Object.getOwnPropertyDescriptor(composer, method);
    if (!desc || !desc.value) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    Object.defineProperty(app.config.globalProperties, `$${method}`, desc);
  });
}
registerMessageCompiler(compileToFunction);
registerMessageResolver(resolveValue);
registerLocaleFallbacker(fallbackWithLocaleChain);
const calendarLang = {
  formatYear: "YYYY",
  formatMonth: "MMM YYYY",
  today: "Today",
  view: {
    month: "Month",
    year: "Year",
    week: "Week",
    day: "Day"
  },
  month: {
    long: {
      January: "January",
      February: "February",
      March: "March",
      April: "April",
      May: "May",
      June: "June",
      July: "July",
      August: "August",
      September: "September",
      October: "October",
      November: "November",
      December: "December"
    },
    short: {
      January: "Jan",
      February: "Feb",
      March: "Mar",
      April: "Apr",
      May: "May",
      June: "Jun",
      July: "Jul",
      August: "Aug",
      September: "Sept",
      October: "Oct",
      November: "Nov",
      December: "Dec"
    }
  },
  week: {
    long: {
      self: "Week",
      monday: "Monday",
      tuesday: "Tuesday",
      wednesday: "Wednesday",
      thursday: "Thursday",
      friday: "Friday",
      saturday: "Saturday",
      sunday: "Sunday"
    },
    short: {
      self: "Week",
      monday: "Mon",
      tuesday: "Tue",
      wednesday: "Wed",
      thursday: "Thu",
      friday: "Fri",
      saturday: "Sat",
      sunday: "Sun"
    }
  }
};
const lang = {
  locale: "en-US",
  empty: {
    description: "No Data"
  },
  drawer: {
    okText: "Ok",
    cancelText: "Cancel"
  },
  popconfirm: {
    okText: "Ok",
    cancelText: "Cancel"
  },
  modal: {
    okText: "Ok",
    cancelText: "Cancel"
  },
  pagination: {
    goto: "Goto",
    page: "Page",
    countPerPage: " / Page",
    total: "Total: {0}"
  },
  table: {
    okText: "Ok",
    resetText: "Reset"
  },
  upload: {
    start: "Start",
    cancel: "Cancel",
    delete: "Delete",
    retry: "Click to retry",
    buttonText: "Upload",
    preview: "Preview",
    drag: "Click or drag file to this area to upload",
    dragHover: "Release to upload",
    error: "Upload Error"
  },
  calendar: calendarLang,
  datePicker: {
    view: calendarLang.view,
    month: calendarLang.month,
    week: calendarLang.week,
    placeholder: {
      date: "Please select date",
      week: "Please select week",
      month: "Please select month",
      year: "Please select year",
      quarter: "Please select quarter",
      time: "Please select time"
    },
    rangePlaceholder: {
      date: ["Start date", "End date"],
      week: ["Start week", "End week"],
      month: ["Start month", "End month"],
      year: ["Start year", "End year"],
      quarter: ["Start quarter", "End quarter"],
      time: ["Start time", "End time"]
    },
    selectTime: "Select time",
    today: "Today",
    now: "Now",
    ok: "Ok"
  },
  image: {
    loading: "loading"
  },
  imagePreview: {
    fullScreen: "Full Screen",
    rotateRight: "Rotate Right",
    rotateLeft: "Rotate Left",
    zoomIn: "Zoom In",
    zoomOut: "Zoom Out",
    originalSize: "Original Size"
  },
  typography: {
    copied: "Copied",
    copy: "Copy",
    expand: "Expand",
    collapse: "Collapse",
    edit: "Edit"
  },
  form: {
    validateMessages
  }
};
function useLocale() {
  const i18n2 = useI18n();
  const allLocales = i18n2.messages;
  const currentLocale = computed(() => {
    const customLocale = allLocales.value[i18n2.locale.value];
    switch (i18n2.locale.value) {
      case "en_US":
        return {
          ...lang,
          ...customLocale
        };
      case "zh_CN":
      default:
        return {
          ...lang$1,
          ...customLocale
        };
    }
  });
  const changeLocale = (value) => {
    if (i18n2.locale.value === value)
      return;
    i18n2.locale.value = value;
    localStorage.setItem("solon-admin-locale", value);
    Message.success(i18n2.t("header.action.locale", {
      language: i18n2.t("language")
    }));
  };
  return {
    currentLocale,
    changeLocale,
    allLocales
  };
}
const _hoisted_1$6 = {
  class: "header"
};
const _hoisted_2$5 = {
  id: "icon"
};
const _hoisted_3$4 = ["src"];
const _sfc_main$a = /* @__PURE__ */ defineComponent({
  __name: "Header",
  setup(__props) {
    const router2 = useRouter();
    const route = useRoute();
    const {
      changeLocale,
      allLocales
    } = useLocale();
    const {
      t: t2
    } = useI18n();
    const selectedKeys = ref();
    const path = computed(() => route.name);
    watch(path, (value) => {
      selectedKeys.value = [value];
    });
    const isHome = computed(() => {
      return path.value === "home";
    });
    function onClickMenuItem(key) {
      if (key.startsWith("_ignore:") || router2.getRoutes().find((r2) => r2.name === key)?.meta?.ignored === true) {
        selectedKeys.value = [path.value];
        return;
      }
      router2.push({
        name: key
      });
    }
    return (_ctx, _cache) => {
      const _component_a_menu_item = MenuItem;
      const _component_a_sub_menu = SubMenu;
      const _component_a_menu = Menu;
      return openBlock(), createElementBlock("div", _hoisted_1$6, [createVNode(_component_a_menu, {
        "selected-keys": selectedKeys.value,
        "onUpdate:selectedKeys": _cache[0] || (_cache[0] = ($event) => selectedKeys.value = $event),
        mode: "horizontal",
        onMenuItemClick: onClickMenuItem
      }, {
        default: withCtx(() => [createVNode(_component_a_menu_item, {
          key: "_ignore:icon",
          disabled: ""
        }, {
          default: withCtx(() => [createBaseVNode("div", _hoisted_2$5, [createBaseVNode("img", {
            src: unref(icon),
            alt: "icon"
          }, null, 8, _hoisted_3$4), createBaseVNode("span", null, toDisplayString$1(unref(t2)("header.title")), 1)])]),
          _: 1
        }), (openBlock(true), createElementBlock(Fragment, null, renderList(unref(router2).getRoutes().filter((it) => it.meta.showInHeader != false).filter((it) => isHome.value ? it.meta.showInHome != false : true).sort((a, b2) => (a.meta.index == void 0 ? 0 : a.meta.index) - (b2.meta.index == void 0 ? 0 : b2.meta.index)), (item) => {
          return openBlock(), createBlock(_component_a_menu_item, {
            key: item.name
          }, {
            default: withCtx(() => [createTextVNode(toDisplayString$1(unref(t2)(`header.item.${String(item.name)}`)), 1)]),
            _: 2
          }, 1024);
        }), 128)), createVNode(_component_a_sub_menu, {
          class: "language-menu"
        }, {
          title: withCtx(() => [createTextVNode(toDisplayString$1(unref(t2)("language")), 1)]),
          default: withCtx(() => [(openBlock(true), createElementBlock(Fragment, null, renderList(Object.keys(unref(allLocales)), (language) => {
            return openBlock(), createBlock(_component_a_menu_item, {
              key: "_ignore:" + language,
              onClick: () => unref(changeLocale)(language)
            }, {
              default: withCtx(() => [createTextVNode(toDisplayString$1(unref(allLocales)[language].language), 1)]),
              _: 2
            }, 1032, ["onClick"]);
          }), 128))]),
          _: 1
        })]),
        _: 1
      }, 8, ["selected-keys"])]);
    };
  }
});
const Header_vue_vue_type_style_index_0_scoped_a7ee54ba_lang = "";
const _export_sfc = (sfc, props) => {
  const target2 = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target2[key] = val;
  }
  return target2;
};
const Header = /* @__PURE__ */ _export_sfc(_sfc_main$a, [["__scopeId", "data-v-a7ee54ba"]]);
const Footer_vue_vue_type_style_index_0_scoped_fda6ff9c_lang = "";
const _sfc_main$9 = {};
const _hoisted_1$5 = {
  class: "footer"
};
function _sfc_render$2(_ctx, _cache) {
  return openBlock(), createElementBlock("div", _hoisted_1$5, " ©Copyright " + toDisplayString$1((/* @__PURE__ */ new Date()).getFullYear()) + " Solon Admin and contributors, licensed under the Apache 2.0 License. ", 1);
}
const Footer = /* @__PURE__ */ _export_sfc(_sfc_main$9, [["render", _sfc_render$2], ["__scopeId", "data-v-fda6ff9c"]]);
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  __name: "index",
  setup(__props) {
    const slots = useSlots();
    const hasSlot = (name) => {
      return !!slots[name];
    };
    return (_ctx, _cache) => {
      const _component_a_layout_header = LayoutHeader;
      const _component_a_layout_sider = LayoutSider;
      const _component_a_layout_content = LayoutContent;
      const _component_a_layout = Layout;
      const _component_a_layout_footer = LayoutFooter;
      return openBlock(), createBlock(_component_a_layout, null, {
        default: withCtx(() => [createVNode(_component_a_layout_header, null, {
          default: withCtx(() => [createVNode(Header)]),
          _: 1
        }), createVNode(_component_a_layout, null, {
          default: withCtx(() => [hasSlot("sidebar") ? (openBlock(), createBlock(_component_a_layout_sider, {
            key: 0,
            collapsible: ""
          }, {
            default: withCtx(() => [renderSlot(_ctx.$slots, "sidebar", {}, void 0, true)]),
            _: 3
          })) : createCommentVNode("", true), hasSlot("default") ? (openBlock(), createBlock(_component_a_layout_content, {
            key: 1
          }, {
            default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, void 0, true)]),
            _: 3
          })) : createCommentVNode("", true)]),
          _: 3
        }), createVNode(_component_a_layout_footer, null, {
          default: withCtx(() => [createVNode(Footer)]),
          _: 1
        })]),
        _: 3
      });
    };
  }
});
const index_vue_vue_type_style_index_0_scoped_58f57895_lang = "";
const GlobalLayout = /* @__PURE__ */ _export_sfc(_sfc_main$8, [["__scopeId", "data-v-58f57895"]]);
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "App",
  setup(__props) {
    const {
      currentLocale
    } = useLocale();
    const route = useRoute();
    return (_ctx, _cache) => {
      const _component_router_view = resolveComponent("router-view");
      const _component_a_config_provider = ConfigProvider;
      return openBlock(), createBlock(_component_a_config_provider, {
        locale: unref(currentLocale)
      }, {
        default: withCtx(() => [createVNode(GlobalLayout, null, createSlots({
          default: withCtx(() => [createVNode(_component_router_view)]),
          _: 2
        }, [unref(route).meta.showSideBar == true ? {
          name: "sidebar",
          fn: withCtx(() => [createVNode(_component_router_view, {
            name: "sidebar"
          })]),
          key: "0"
        } : void 0]), 1024)]),
        _: 1
      }, 8, ["locale"]);
    };
  }
});
const index$k = "";
const index$j = "";
const index$i = "";
const index$h = "";
const index$g = "";
const index$f = "";
const index$e = "";
const index$d = "";
const index$c = "";
const index$b = "";
const index$a = "";
const index$9 = "";
const index$8 = "";
const index$7 = "";
const index$6 = "";
const index$5 = "";
const index$4 = "";
const _sfc_main$6 = defineComponent({
  name: "IconLaunch",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, {
    emit: emit2
  }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-launch`, {
      [`${prefixCls}-spin`]: props.spin
    }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber$2(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit2("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
const _hoisted_2$4 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M41 26v14a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h14M19.822 28.178 39.899 8.1M41 20V7H28"
}, null, -1);
const _hoisted_3$3 = [_hoisted_2$4];
function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    stroke: "currentColor",
    xmlns: "http://www.w3.org/2000/svg",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle$1(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _hoisted_3$3, 14, _hoisted_1$4);
}
var _IconLaunch = /* @__PURE__ */ _export_sfc$1(_sfc_main$6, [["render", _sfc_render$1]]);
const IconLaunch = Object.assign(_IconLaunch, {
  install: (app, options) => {
    var _a2;
    const iconPrefix = (_a2 = options == null ? void 0 : options.iconPrefix) != null ? _a2 : "";
    app.component(iconPrefix + _IconLaunch.name, _IconLaunch);
  }
});
class UniqueApplication {
  constructor(name, baseUrl) {
    __publicField(this, "name");
    __publicField(this, "baseUrl");
    this.name = name;
    this.baseUrl = baseUrl;
  }
  toString() {
    return `${this.name}/${this.baseUrl}`;
  }
}
var ApplicationStatus = /* @__PURE__ */ ((ApplicationStatus2) => {
  ApplicationStatus2[ApplicationStatus2["UP"] = 0] = "UP";
  ApplicationStatus2[ApplicationStatus2["DOWN"] = 1] = "DOWN";
  return ApplicationStatus2;
})(ApplicationStatus || {});
const applications = ref([]);
const isEvaluating = ref(true);
let websocket = void 0;
function useApplications() {
  const i18n2 = useI18n();
  function connect() {
    if (websocket !== void 0)
      return;
    websocket = new WebSocket("ws://" + window.location.host + "/ws/application");
    websocket.addEventListener("message", (event) => {
      const data = JSON.parse(event.data);
      switch (data.type) {
        case "getAllApplication":
          applications.value = reactive(data.data);
          isEvaluating.value = false;
          break;
        case "registerApplication":
          applications.value.push(data.data);
          break;
        case "unregisterApplication":
          applications.value = applications.value.filter((app) => app.name !== data.data.name || app.baseUrl !== data.data.baseUrl);
          break;
        case "updateApplication":
          applications.value = applications.value.map((app) => {
            if (app.name === data.data.name && app.baseUrl === data.data.baseUrl) {
              return data.data;
            }
            return app;
          });
      }
    });
    websocket.addEventListener("open", () => {
      if (websocket === void 0)
        return;
      websocket.send(JSON.stringify({
        type: "getAllApplication"
      }));
    });
    websocket.addEventListener("close", () => {
      websocket = void 0;
      isEvaluating.value = true;
      Notification.error(i18n2.t("websocket.disconnect"));
    });
  }
  connect();
  return {
    applications,
    isEvaluating
  };
}
function useApplication() {
  const applications2 = useApplications().applications;
  const route = useRoute();
  const i18n2 = useI18n();
  const unregisterApplication = async (application) => {
    const isOk = await fetch("/solon-admin/api/application/unregister", {
      method: "DELETE",
      headers: {
        "Content-Type": "application/json"
      },
      body: JSON.stringify(application)
    }).then((res) => res.ok);
    if (!isOk) {
      Message.success(i18n2.t("home.applications.actions.remove.fail"));
      return;
    }
    Message.success(i18n2.t("home.applications.actions.remove.success"));
  };
  const getApplicationRaw = async (name, baseUrl) => {
    return await fetch("/solon-admin/api/application?name=" + encodeURIComponent(name) + "&baseUrl=" + encodeURIComponent(baseUrl)).then((response) => response.json()).then((response) => response);
  };
  const getApplication = (application) => {
    return computed(() => applications2.value.find((app) => app.name === application.value.name && app.baseUrl === application.value.baseUrl));
  };
  function currentApplication() {
    return useApplication().getApplication(computed(() => new UniqueApplication(decodeURIComponent(route.params.name), decodeURIComponent(route.params.baseUrl))));
  }
  return {
    currentApplication,
    getApplication,
    getApplicationRaw,
    unregisterApplication
  };
}
const _hoisted_1$3 = {
  class: "dashboard"
};
const _hoisted_2$3 = {
  class: "summary"
};
const _hoisted_3$2 = {
  key: 0,
  class: "loading"
};
const _hoisted_4$2 = {
  key: 1,
  class: "empty"
};
const _hoisted_5$2 = {
  key: 2,
  class: "abnormal modified"
};
const _hoisted_6$2 = {
  key: 3,
  class: "normal modified"
};
const _hoisted_7$2 = {
  class: "applications"
};
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "Home",
  setup(__props) {
    const router2 = useRouter();
    const {
      t: t2
    } = useI18n();
    const {
      applications: applications2,
      isEvaluating: isLoading
    } = useApplications();
    const {
      unregisterApplication
    } = useApplication();
    const isEmpty = computed(() => applications2.value.length === 0);
    const isAbnormal = computed(() => applications2.value.some((app) => app.status != ApplicationStatus.UP));
    function goToDetails(app) {
      router2.push({
        name: "details",
        params: {
          name: encodeURIComponent(app.name),
          baseUrl: encodeURIComponent(app.baseUrl)
        }
      });
    }
    return (_ctx, _cache) => {
      const _component_a_spin = Spin;
      const _component_icon_info_circle_fill = IconInfoCircleFill;
      const _component_a_empty = Empty;
      const _component_icon_exclamation_circle_fill = IconExclamationCircleFill;
      const _component_icon_check_circle_fill = IconCheckCircleFill;
      const _component_a_skeleton_line = SkeletonLine;
      const _component_a_skeleton_shape = SkeletonShape;
      const _component_a_space = Space;
      const _component_a_skeleton = Skeleton;
      const _component_a_link = Link;
      const _component_a_list_item_meta = ListItemMeta;
      const _component_icon_delete = IconDelete;
      const _component_a_tooltip = Tooltip;
      const _component_a_popconfirm = Popconfirm;
      const _component_icon_launch = IconLaunch;
      const _component_a_list_item = ListItem;
      const _component_a_list = List;
      return openBlock(), createElementBlock("div", _hoisted_1$3, [createBaseVNode("div", _hoisted_2$3, [unref(isLoading) ? (openBlock(), createElementBlock("div", _hoisted_3$2, [createBaseVNode("div", null, [createVNode(_component_a_spin, {
        tip: unref(t2)("loading")
      }, null, 8, ["tip"])])])) : isEmpty.value ? (openBlock(), createElementBlock("div", _hoisted_4$2, [createVNode(_component_a_empty, {
        description: unref(t2)("home.getting-started")
      }, {
        image: withCtx(() => [createVNode(_component_icon_info_circle_fill)]),
        _: 1
      }, 8, ["description"])])) : isAbnormal.value ? (openBlock(), createElementBlock("div", _hoisted_5$2, [createVNode(_component_a_empty, {
        description: unref(t2)("home.summary.abnormal")
      }, {
        image: withCtx(() => [createVNode(_component_icon_exclamation_circle_fill, {
          style: {
            "color": "rgb(var(--red-6))"
          }
        })]),
        _: 1
      }, 8, ["description"])])) : (openBlock(), createElementBlock("div", _hoisted_6$2, [createVNode(_component_a_empty, {
        description: unref(t2)("home.summary.normal")
      }, {
        image: withCtx(() => [createVNode(_component_icon_check_circle_fill, {
          style: {
            "color": "rgb(var(--green-6))"
          }
        })]),
        _: 1
      }, 8, ["description"])]))]), createBaseVNode("div", _hoisted_7$2, [unref(isLoading) ? (openBlock(), createBlock(_component_a_skeleton, {
        key: 0,
        animation: true
      }, {
        default: withCtx(() => [createVNode(_component_a_space, {
          style: {
            width: "100%"
          },
          direction: "vertical",
          size: "large"
        }, {
          default: withCtx(() => [createVNode(_component_a_skeleton_line), createVNode(_component_a_skeleton_shape), createVNode(_component_a_skeleton_line, {
            rows: 10
          })]),
          _: 1
        })]),
        _: 1
      })) : !isEmpty.value ? (openBlock(), createBlock(_component_a_list, {
        key: 1
      }, {
        header: withCtx(() => [createBaseVNode("span", null, toDisplayString$1(unref(t2)("home.applications.title", {
          count: unref(applications2).length
        })), 1)]),
        default: withCtx(() => [(openBlock(true), createElementBlock(Fragment, null, renderList(unref(applications2), (app) => {
          return openBlock(), createBlock(_component_a_list_item, null, {
            actions: withCtx(() => [createBaseVNode("div", null, [createVNode(_component_a_popconfirm, {
              content: unref(t2)("home.applications.actions.remove.ask"),
              type: "warning",
              onOk: ($event) => unref(unregisterApplication)(app)
            }, {
              default: withCtx(() => [createVNode(_component_a_tooltip, {
                content: unref(t2)("home.applications.actions.remove.tooltip")
              }, {
                default: withCtx(() => [createVNode(_component_icon_delete)]),
                _: 1
              }, 8, ["content"])]),
              _: 2
            }, 1032, ["content", "onOk"])]), createBaseVNode("div", null, [createVNode(_component_a_tooltip, {
              content: unref(t2)("home.applications.actions.details.tooltip")
            }, {
              default: withCtx(() => [createVNode(_component_icon_launch, {
                onClick: ($event) => goToDetails(app)
              }, null, 8, ["onClick"])]),
              _: 2
            }, 1032, ["content"])])]),
            default: withCtx(() => [createVNode(_component_a_list_item_meta, {
              title: app.name
            }, {
              avatar: withCtx(() => [app.status == unref(ApplicationStatus).UP ? (openBlock(), createBlock(_component_icon_check_circle_fill, {
                key: 0,
                style: {
                  "color": "rgb(var(--green-6))"
                }
              })) : (openBlock(), createBlock(_component_icon_exclamation_circle_fill, {
                key: 1,
                style: {
                  "color": "rgb(var(--red-6))"
                }
              }))]),
              description: withCtx(() => [createVNode(_component_a_link, {
                href: app.baseUrl,
                icon: ""
              }, {
                default: withCtx(() => [createTextVNode(toDisplayString$1(app.baseUrl), 1)]),
                _: 2
              }, 1032, ["href"])]),
              _: 2
            }, 1032, ["title"])]),
            _: 2
          }, 1024);
        }), 256))]),
        _: 1
      })) : createCommentVNode("", true)])]);
    };
  }
});
const Home_vue_vue_type_style_index_0_scoped_95cc8f5a_lang = "";
const Home = /* @__PURE__ */ _export_sfc(_sfc_main$5, [["__scopeId", "data-v-95cc8f5a"]]);
const index$3 = "";
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "NotFound",
  setup(__props) {
    const {
      t: t2
    } = useI18n();
    const router2 = useRouter();
    function back() {
      router2.back();
    }
    return (_ctx, _cache) => {
      const _component_a_button = Button;
      const _component_a_space = Space;
      const _component_a_result = Result;
      return openBlock(), createBlock(_component_a_result, {
        subtitle: unref(t2)("notfound.subtitle"),
        status: "404"
      }, {
        extra: withCtx(() => [createVNode(_component_a_space, null, {
          default: withCtx(() => [createVNode(_component_a_button, {
            type: "primary",
            onClick: back
          }, {
            default: withCtx(() => [createTextVNode(toDisplayString$1(unref(t2)("notfound.extra.action.back")), 1)]),
            _: 1
          })]),
          _: 1
        })]),
        _: 1
      }, 8, ["subtitle"]);
    };
  }
});
const NotFound_vue_vue_type_style_index_0_scoped_56a0da74_lang = "";
const NotFound = /* @__PURE__ */ _export_sfc(_sfc_main$4, [["__scopeId", "data-v-56a0da74"]]);
const _sfc_main$3 = {};
function _sfc_render(_ctx, _cache) {
  const _component_router_view = resolveComponent("router-view");
  return openBlock(), createBlock(_component_router_view);
}
const Application = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["render", _sfc_render]]);
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
var extendStatics = function(d, b2) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function(d2, b3) {
    d2.__proto__ = b3;
  } || function(d2, b3) {
    for (var p2 in b3)
      if (Object.prototype.hasOwnProperty.call(b3, p2))
        d2[p2] = b3[p2];
  };
  return extendStatics(d, b2);
};
function __extends(d, b2) {
  if (typeof b2 !== "function" && b2 !== null)
    throw new TypeError("Class extends value " + String(b2) + " is not a constructor or null");
  extendStatics(d, b2);
  function __() {
    this.constructor = d;
  }
  d.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
}
var Browser = function() {
  function Browser2() {
    this.firefox = false;
    this.ie = false;
    this.edge = false;
    this.newEdge = false;
    this.weChat = false;
  }
  return Browser2;
}();
var Env = function() {
  function Env2() {
    this.browser = new Browser();
    this.node = false;
    this.wxa = false;
    this.worker = false;
    this.svgSupported = false;
    this.touchEventsSupported = false;
    this.pointerEventsSupported = false;
    this.domSupported = false;
    this.transformSupported = false;
    this.transform3dSupported = false;
    this.hasGlobalWindow = typeof window !== "undefined";
  }
  return Env2;
}();
var env = new Env();
if (typeof wx === "object" && typeof wx.getSystemInfoSync === "function") {
  env.wxa = true;
  env.touchEventsSupported = true;
} else if (typeof document === "undefined" && typeof self !== "undefined") {
  env.worker = true;
} else if (typeof navigator === "undefined") {
  env.node = true;
  env.svgSupported = true;
} else {
  detect(navigator.userAgent, env);
}
function detect(ua, env2) {
  var browser = env2.browser;
  var firefox = ua.match(/Firefox\/([\d.]+)/);
  var ie = ua.match(/MSIE\s([\d.]+)/) || ua.match(/Trident\/.+?rv:(([\d.]+))/);
  var edge = ua.match(/Edge?\/([\d.]+)/);
  var weChat = /micromessenger/i.test(ua);
  if (firefox) {
    browser.firefox = true;
    browser.version = firefox[1];
  }
  if (ie) {
    browser.ie = true;
    browser.version = ie[1];
  }
  if (edge) {
    browser.edge = true;
    browser.version = edge[1];
    browser.newEdge = +edge[1].split(".")[0] > 18;
  }
  if (weChat) {
    browser.weChat = true;
  }
  env2.svgSupported = typeof SVGRect !== "undefined";
  env2.touchEventsSupported = "ontouchstart" in window && !browser.ie && !browser.edge;
  env2.pointerEventsSupported = "onpointerdown" in window && (browser.edge || browser.ie && +browser.version >= 11);
  env2.domSupported = typeof document !== "undefined";
  var style2 = document.documentElement.style;
  env2.transform3dSupported = (browser.ie && "transition" in style2 || browser.edge || "WebKitCSSMatrix" in window && "m11" in new WebKitCSSMatrix() || "MozPerspective" in style2) && !("OTransition" in style2);
  env2.transformSupported = env2.transform3dSupported || browser.ie && +browser.version >= 9;
}
const env$1 = env;
var DEFAULT_FONT_SIZE = 12;
var DEFAULT_FONT_FAMILY = "sans-serif";
var DEFAULT_FONT = DEFAULT_FONT_SIZE + "px " + DEFAULT_FONT_FAMILY;
var OFFSET = 20;
var SCALE = 100;
var defaultWidthMapStr = "007LLmW'55;N0500LLLLLLLLLL00NNNLzWW\\\\WQb\\0FWLg\\bWb\\WQ\\WrWWQ000CL5LLFLL0LL**F*gLLLL5F0LF\\FFF5.5N";
function getTextWidthMap(mapStr) {
  var map2 = {};
  if (typeof JSON === "undefined") {
    return map2;
  }
  for (var i2 = 0; i2 < mapStr.length; i2++) {
    var char = String.fromCharCode(i2 + 32);
    var size2 = (mapStr.charCodeAt(i2) - OFFSET) / SCALE;
    map2[char] = size2;
  }
  return map2;
}
var DEFAULT_TEXT_WIDTH_MAP = getTextWidthMap(defaultWidthMapStr);
var platformApi = {
  createCanvas: function() {
    return typeof document !== "undefined" && document.createElement("canvas");
  },
  measureText: function() {
    var _ctx;
    var _cachedFont;
    return function(text, font) {
      if (!_ctx) {
        var canvas = platformApi.createCanvas();
        _ctx = canvas && canvas.getContext("2d");
      }
      if (_ctx) {
        if (_cachedFont !== font) {
          _cachedFont = _ctx.font = font || DEFAULT_FONT;
        }
        return _ctx.measureText(text);
      } else {
        text = text || "";
        font = font || DEFAULT_FONT;
        var res = /(\d+)px/.exec(font);
        var fontSize = res && +res[1] || DEFAULT_FONT_SIZE;
        var width = 0;
        if (font.indexOf("mono") >= 0) {
          width = fontSize * text.length;
        } else {
          for (var i2 = 0; i2 < text.length; i2++) {
            var preCalcWidth = DEFAULT_TEXT_WIDTH_MAP[text[i2]];
            width += preCalcWidth == null ? fontSize : preCalcWidth * fontSize;
          }
        }
        return {
          width
        };
      }
    };
  }(),
  loadImage: function(src, onload, onerror) {
    var image = new Image();
    image.onload = onload;
    image.onerror = onerror;
    image.src = src;
    return image;
  }
};
var BUILTIN_OBJECT = reduce(["Function", "RegExp", "Date", "Error", "CanvasGradient", "CanvasPattern", "Image", "Canvas"], function(obj, val) {
  obj["[object " + val + "]"] = true;
  return obj;
}, {});
var TYPED_ARRAY = reduce(["Int8", "Uint8", "Uint8Clamped", "Int16", "Uint16", "Int32", "Uint32", "Float32", "Float64"], function(obj, val) {
  obj["[object " + val + "Array]"] = true;
  return obj;
}, {});
var objToString = Object.prototype.toString;
var arrayProto = Array.prototype;
var nativeForEach = arrayProto.forEach;
var nativeFilter = arrayProto.filter;
var nativeSlice = arrayProto.slice;
var nativeMap = arrayProto.map;
var ctorFunction = function() {
}.constructor;
var protoFunction = ctorFunction ? ctorFunction.prototype : null;
var protoKey = "__proto__";
var idStart = 2311;
function guid() {
  return idStart++;
}
function logError() {
  var args = [];
  for (var _i = 0; _i < arguments.length; _i++) {
    args[_i] = arguments[_i];
  }
  if (typeof console !== "undefined") {
    console.error.apply(console, args);
  }
}
function clone$3(source) {
  if (source == null || typeof source !== "object") {
    return source;
  }
  var result = source;
  var typeStr = objToString.call(source);
  if (typeStr === "[object Array]") {
    if (!isPrimitive(source)) {
      result = [];
      for (var i2 = 0, len2 = source.length; i2 < len2; i2++) {
        result[i2] = clone$3(source[i2]);
      }
    }
  } else if (TYPED_ARRAY[typeStr]) {
    if (!isPrimitive(source)) {
      var Ctor = source.constructor;
      if (Ctor.from) {
        result = Ctor.from(source);
      } else {
        result = new Ctor(source.length);
        for (var i2 = 0, len2 = source.length; i2 < len2; i2++) {
          result[i2] = source[i2];
        }
      }
    }
  } else if (!BUILTIN_OBJECT[typeStr] && !isPrimitive(source) && !isDom(source)) {
    result = {};
    for (var key in source) {
      if (source.hasOwnProperty(key) && key !== protoKey) {
        result[key] = clone$3(source[key]);
      }
    }
  }
  return result;
}
function merge(target2, source, overwrite) {
  if (!isObject$2(source) || !isObject$2(target2)) {
    return overwrite ? clone$3(source) : target2;
  }
  for (var key in source) {
    if (source.hasOwnProperty(key) && key !== protoKey) {
      var targetProp = target2[key];
      var sourceProp = source[key];
      if (isObject$2(sourceProp) && isObject$2(targetProp) && !isArray(sourceProp) && !isArray(targetProp) && !isDom(sourceProp) && !isDom(targetProp) && !isBuiltInObject(sourceProp) && !isBuiltInObject(targetProp) && !isPrimitive(sourceProp) && !isPrimitive(targetProp)) {
        merge(targetProp, sourceProp, overwrite);
      } else if (overwrite || !(key in target2)) {
        target2[key] = clone$3(source[key]);
      }
    }
  }
  return target2;
}
function extend(target2, source) {
  if (Object.assign) {
    Object.assign(target2, source);
  } else {
    for (var key in source) {
      if (source.hasOwnProperty(key) && key !== protoKey) {
        target2[key] = source[key];
      }
    }
  }
  return target2;
}
function defaults(target2, source, overlay) {
  var keysArr = keys(source);
  for (var i2 = 0; i2 < keysArr.length; i2++) {
    var key = keysArr[i2];
    if (overlay ? source[key] != null : target2[key] == null) {
      target2[key] = source[key];
    }
  }
  return target2;
}
function indexOf(array, value) {
  if (array) {
    if (array.indexOf) {
      return array.indexOf(value);
    }
    for (var i2 = 0, len2 = array.length; i2 < len2; i2++) {
      if (array[i2] === value) {
        return i2;
      }
    }
  }
  return -1;
}
function inherits(clazz, baseClazz) {
  var clazzPrototype = clazz.prototype;
  function F() {
  }
  F.prototype = baseClazz.prototype;
  clazz.prototype = new F();
  for (var prop in clazzPrototype) {
    if (clazzPrototype.hasOwnProperty(prop)) {
      clazz.prototype[prop] = clazzPrototype[prop];
    }
  }
  clazz.prototype.constructor = clazz;
  clazz.superClass = baseClazz;
}
function mixin(target2, source, override) {
  target2 = "prototype" in target2 ? target2.prototype : target2;
  source = "prototype" in source ? source.prototype : source;
  if (Object.getOwnPropertyNames) {
    var keyList = Object.getOwnPropertyNames(source);
    for (var i2 = 0; i2 < keyList.length; i2++) {
      var key = keyList[i2];
      if (key !== "constructor") {
        if (override ? source[key] != null : target2[key] == null) {
          target2[key] = source[key];
        }
      }
    }
  } else {
    defaults(target2, source, override);
  }
}
function isArrayLike(data) {
  if (!data) {
    return false;
  }
  if (typeof data === "string") {
    return false;
  }
  return typeof data.length === "number";
}
function each$3(arr, cb, context) {
  if (!(arr && cb)) {
    return;
  }
  if (arr.forEach && arr.forEach === nativeForEach) {
    arr.forEach(cb, context);
  } else if (arr.length === +arr.length) {
    for (var i2 = 0, len2 = arr.length; i2 < len2; i2++) {
      cb.call(context, arr[i2], i2, arr);
    }
  } else {
    for (var key in arr) {
      if (arr.hasOwnProperty(key)) {
        cb.call(context, arr[key], key, arr);
      }
    }
  }
}
function map$1(arr, cb, context) {
  if (!arr) {
    return [];
  }
  if (!cb) {
    return slice(arr);
  }
  if (arr.map && arr.map === nativeMap) {
    return arr.map(cb, context);
  } else {
    var result = [];
    for (var i2 = 0, len2 = arr.length; i2 < len2; i2++) {
      result.push(cb.call(context, arr[i2], i2, arr));
    }
    return result;
  }
}
function reduce(arr, cb, memo, context) {
  if (!(arr && cb)) {
    return;
  }
  for (var i2 = 0, len2 = arr.length; i2 < len2; i2++) {
    memo = cb.call(context, memo, arr[i2], i2, arr);
  }
  return memo;
}
function filter(arr, cb, context) {
  if (!arr) {
    return [];
  }
  if (!cb) {
    return slice(arr);
  }
  if (arr.filter && arr.filter === nativeFilter) {
    return arr.filter(cb, context);
  } else {
    var result = [];
    for (var i2 = 0, len2 = arr.length; i2 < len2; i2++) {
      if (cb.call(context, arr[i2], i2, arr)) {
        result.push(arr[i2]);
      }
    }
    return result;
  }
}
function keys(obj) {
  if (!obj) {
    return [];
  }
  if (Object.keys) {
    return Object.keys(obj);
  }
  var keyList = [];
  for (var key in obj) {
    if (obj.hasOwnProperty(key)) {
      keyList.push(key);
    }
  }
  return keyList;
}
function bindPolyfill(func, context) {
  var args = [];
  for (var _i = 2; _i < arguments.length; _i++) {
    args[_i - 2] = arguments[_i];
  }
  return function() {
    return func.apply(context, args.concat(nativeSlice.call(arguments)));
  };
}
var bind$1 = protoFunction && isFunction(protoFunction.bind) ? protoFunction.call.bind(protoFunction.bind) : bindPolyfill;
function curry(func) {
  var args = [];
  for (var _i = 1; _i < arguments.length; _i++) {
    args[_i - 1] = arguments[_i];
  }
  return function() {
    return func.apply(this, args.concat(nativeSlice.call(arguments)));
  };
}
function isArray(value) {
  if (Array.isArray) {
    return Array.isArray(value);
  }
  return objToString.call(value) === "[object Array]";
}
function isFunction(value) {
  return typeof value === "function";
}
function isString(value) {
  return typeof value === "string";
}
function isStringSafe(value) {
  return objToString.call(value) === "[object String]";
}
function isNumber(value) {
  return typeof value === "number";
}
function isObject$2(value) {
  var type = typeof value;
  return type === "function" || !!value && type === "object";
}
function isBuiltInObject(value) {
  return !!BUILTIN_OBJECT[objToString.call(value)];
}
function isTypedArray(value) {
  return !!TYPED_ARRAY[objToString.call(value)];
}
function isDom(value) {
  return typeof value === "object" && typeof value.nodeType === "number" && typeof value.ownerDocument === "object";
}
function isGradientObject(value) {
  return value.colorStops != null;
}
function isImagePatternObject(value) {
  return value.image != null;
}
function eqNaN(value) {
  return value !== value;
}
function retrieve() {
  var args = [];
  for (var _i = 0; _i < arguments.length; _i++) {
    args[_i] = arguments[_i];
  }
  for (var i2 = 0, len2 = args.length; i2 < len2; i2++) {
    if (args[i2] != null) {
      return args[i2];
    }
  }
}
function retrieve2(value0, value1) {
  return value0 != null ? value0 : value1;
}
function retrieve3(value0, value1, value2) {
  return value0 != null ? value0 : value1 != null ? value1 : value2;
}
function slice(arr) {
  var args = [];
  for (var _i = 1; _i < arguments.length; _i++) {
    args[_i - 1] = arguments[_i];
  }
  return nativeSlice.apply(arr, args);
}
function normalizeCssArray$1(val) {
  if (typeof val === "number") {
    return [val, val, val, val];
  }
  var len2 = val.length;
  if (len2 === 2) {
    return [val[0], val[1], val[0], val[1]];
  } else if (len2 === 3) {
    return [val[0], val[1], val[2], val[1]];
  }
  return val;
}
function assert(condition, message2) {
  if (!condition) {
    throw new Error(message2);
  }
}
function trim(str) {
  if (str == null) {
    return null;
  } else if (typeof str.trim === "function") {
    return str.trim();
  } else {
    return str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, "");
  }
}
var primitiveKey = "__ec_primitive__";
function setAsPrimitive(obj) {
  obj[primitiveKey] = true;
}
function isPrimitive(obj) {
  return obj[primitiveKey];
}
var MapPolyfill = function() {
  function MapPolyfill2() {
    this.data = {};
  }
  MapPolyfill2.prototype["delete"] = function(key) {
    var existed = this.has(key);
    if (existed) {
      delete this.data[key];
    }
    return existed;
  };
  MapPolyfill2.prototype.has = function(key) {
    return this.data.hasOwnProperty(key);
  };
  MapPolyfill2.prototype.get = function(key) {
    return this.data[key];
  };
  MapPolyfill2.prototype.set = function(key, value) {
    this.data[key] = value;
    return this;
  };
  MapPolyfill2.prototype.keys = function() {
    return keys(this.data);
  };
  MapPolyfill2.prototype.forEach = function(callback) {
    var data = this.data;
    for (var key in data) {
      if (data.hasOwnProperty(key)) {
        callback(data[key], key);
      }
    }
  };
  return MapPolyfill2;
}();
var isNativeMapSupported = typeof Map === "function";
function maybeNativeMap() {
  return isNativeMapSupported ? /* @__PURE__ */ new Map() : new MapPolyfill();
}
var HashMap = function() {
  function HashMap2(obj) {
    var isArr = isArray(obj);
    this.data = maybeNativeMap();
    var thisMap = this;
    obj instanceof HashMap2 ? obj.each(visit) : obj && each$3(obj, visit);
    function visit(value, key) {
      isArr ? thisMap.set(value, key) : thisMap.set(key, value);
    }
  }
  HashMap2.prototype.hasKey = function(key) {
    return this.data.has(key);
  };
  HashMap2.prototype.get = function(key) {
    return this.data.get(key);
  };
  HashMap2.prototype.set = function(key, value) {
    this.data.set(key, value);
    return value;
  };
  HashMap2.prototype.each = function(cb, context) {
    this.data.forEach(function(value, key) {
      cb.call(context, value, key);
    });
  };
  HashMap2.prototype.keys = function() {
    var keys2 = this.data.keys();
    return isNativeMapSupported ? Array.from(keys2) : keys2;
  };
  HashMap2.prototype.removeKey = function(key) {
    this.data["delete"](key);
  };
  return HashMap2;
}();
function createHashMap(obj) {
  return new HashMap(obj);
}
function concatArray(a, b2) {
  var newArray = new a.constructor(a.length + b2.length);
  for (var i2 = 0; i2 < a.length; i2++) {
    newArray[i2] = a[i2];
  }
  var offset = a.length;
  for (var i2 = 0; i2 < b2.length; i2++) {
    newArray[i2 + offset] = b2[i2];
  }
  return newArray;
}
function createObject(proto2, properties) {
  var obj;
  if (Object.create) {
    obj = Object.create(proto2);
  } else {
    var StyleCtor = function() {
    };
    StyleCtor.prototype = proto2;
    obj = new StyleCtor();
  }
  if (properties) {
    extend(obj, properties);
  }
  return obj;
}
function disableUserSelect(dom) {
  var domStyle = dom.style;
  domStyle.webkitUserSelect = "none";
  domStyle.userSelect = "none";
  domStyle.webkitTapHighlightColor = "rgba(0,0,0,0)";
  domStyle["-webkit-touch-callout"] = "none";
}
function hasOwn(own, prop) {
  return own.hasOwnProperty(prop);
}
function noop() {
}
var RADIAN_TO_DEGREE = 180 / Math.PI;
function create$1(x2, y2) {
  if (x2 == null) {
    x2 = 0;
  }
  if (y2 == null) {
    y2 = 0;
  }
  return [x2, y2];
}
function clone$2(v) {
  return [v[0], v[1]];
}
function add(out2, v1, v2) {
  out2[0] = v1[0] + v2[0];
  out2[1] = v1[1] + v2[1];
  return out2;
}
function sub(out2, v1, v2) {
  out2[0] = v1[0] - v2[0];
  out2[1] = v1[1] - v2[1];
  return out2;
}
function len(v) {
  return Math.sqrt(lenSquare(v));
}
function lenSquare(v) {
  return v[0] * v[0] + v[1] * v[1];
}
function scale$2(out2, v, s) {
  out2[0] = v[0] * s;
  out2[1] = v[1] * s;
  return out2;
}
function normalize$1(out2, v) {
  var d = len(v);
  if (d === 0) {
    out2[0] = 0;
    out2[1] = 0;
  } else {
    out2[0] = v[0] / d;
    out2[1] = v[1] / d;
  }
  return out2;
}
function distance(v1, v2) {
  return Math.sqrt((v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]));
}
var dist$1 = distance;
function distanceSquare(v1, v2) {
  return (v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]);
}
var distSquare = distanceSquare;
function lerp$1(out2, v1, v2, t2) {
  out2[0] = v1[0] + t2 * (v2[0] - v1[0]);
  out2[1] = v1[1] + t2 * (v2[1] - v1[1]);
  return out2;
}
function applyTransform$1(out2, v, m2) {
  var x2 = v[0];
  var y2 = v[1];
  out2[0] = m2[0] * x2 + m2[2] * y2 + m2[4];
  out2[1] = m2[1] * x2 + m2[3] * y2 + m2[5];
  return out2;
}
function min$1(out2, v1, v2) {
  out2[0] = Math.min(v1[0], v2[0]);
  out2[1] = Math.min(v1[1], v2[1]);
  return out2;
}
function max$1(out2, v1, v2) {
  out2[0] = Math.max(v1[0], v2[0]);
  out2[1] = Math.max(v1[1], v2[1]);
  return out2;
}
var Param = function() {
  function Param2(target2, e2) {
    this.target = target2;
    this.topTarget = e2 && e2.topTarget;
  }
  return Param2;
}();
var Draggable = function() {
  function Draggable2(handler) {
    this.handler = handler;
    handler.on("mousedown", this._dragStart, this);
    handler.on("mousemove", this._drag, this);
    handler.on("mouseup", this._dragEnd, this);
  }
  Draggable2.prototype._dragStart = function(e2) {
    var draggingTarget = e2.target;
    while (draggingTarget && !draggingTarget.draggable) {
      draggingTarget = draggingTarget.parent || draggingTarget.__hostTarget;
    }
    if (draggingTarget) {
      this._draggingTarget = draggingTarget;
      draggingTarget.dragging = true;
      this._x = e2.offsetX;
      this._y = e2.offsetY;
      this.handler.dispatchToElement(new Param(draggingTarget, e2), "dragstart", e2.event);
    }
  };
  Draggable2.prototype._drag = function(e2) {
    var draggingTarget = this._draggingTarget;
    if (draggingTarget) {
      var x2 = e2.offsetX;
      var y2 = e2.offsetY;
      var dx = x2 - this._x;
      var dy = y2 - this._y;
      this._x = x2;
      this._y = y2;
      draggingTarget.drift(dx, dy, e2);
      this.handler.dispatchToElement(new Param(draggingTarget, e2), "drag", e2.event);
      var dropTarget = this.handler.findHover(x2, y2, draggingTarget).target;
      var lastDropTarget = this._dropTarget;
      this._dropTarget = dropTarget;
      if (draggingTarget !== dropTarget) {
        if (lastDropTarget && dropTarget !== lastDropTarget) {
          this.handler.dispatchToElement(new Param(lastDropTarget, e2), "dragleave", e2.event);
        }
        if (dropTarget && dropTarget !== lastDropTarget) {
          this.handler.dispatchToElement(new Param(dropTarget, e2), "dragenter", e2.event);
        }
      }
    }
  };
  Draggable2.prototype._dragEnd = function(e2) {
    var draggingTarget = this._draggingTarget;
    if (draggingTarget) {
      draggingTarget.dragging = false;
    }
    this.handler.dispatchToElement(new Param(draggingTarget, e2), "dragend", e2.event);
    if (this._dropTarget) {
      this.handler.dispatchToElement(new Param(this._dropTarget, e2), "drop", e2.event);
    }
    this._draggingTarget = null;
    this._dropTarget = null;
  };
  return Draggable2;
}();
const Draggable$1 = Draggable;
var Eventful = function() {
  function Eventful2(eventProcessors) {
    if (eventProcessors) {
      this._$eventProcessor = eventProcessors;
    }
  }
  Eventful2.prototype.on = function(event, query, handler, context) {
    if (!this._$handlers) {
      this._$handlers = {};
    }
    var _h = this._$handlers;
    if (typeof query === "function") {
      context = handler;
      handler = query;
      query = null;
    }
    if (!handler || !event) {
      return this;
    }
    var eventProcessor = this._$eventProcessor;
    if (query != null && eventProcessor && eventProcessor.normalizeQuery) {
      query = eventProcessor.normalizeQuery(query);
    }
    if (!_h[event]) {
      _h[event] = [];
    }
    for (var i2 = 0; i2 < _h[event].length; i2++) {
      if (_h[event][i2].h === handler) {
        return this;
      }
    }
    var wrap = {
      h: handler,
      query,
      ctx: context || this,
      callAtLast: handler.zrEventfulCallAtLast
    };
    var lastIndex = _h[event].length - 1;
    var lastWrap = _h[event][lastIndex];
    lastWrap && lastWrap.callAtLast ? _h[event].splice(lastIndex, 0, wrap) : _h[event].push(wrap);
    return this;
  };
  Eventful2.prototype.isSilent = function(eventName) {
    var _h = this._$handlers;
    return !_h || !_h[eventName] || !_h[eventName].length;
  };
  Eventful2.prototype.off = function(eventType, handler) {
    var _h = this._$handlers;
    if (!_h) {
      return this;
    }
    if (!eventType) {
      this._$handlers = {};
      return this;
    }
    if (handler) {
      if (_h[eventType]) {
        var newList = [];
        for (var i2 = 0, l = _h[eventType].length; i2 < l; i2++) {
          if (_h[eventType][i2].h !== handler) {
            newList.push(_h[eventType][i2]);
          }
        }
        _h[eventType] = newList;
      }
      if (_h[eventType] && _h[eventType].length === 0) {
        delete _h[eventType];
      }
    } else {
      delete _h[eventType];
    }
    return this;
  };
  Eventful2.prototype.trigger = function(eventType) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
      args[_i - 1] = arguments[_i];
    }
    if (!this._$handlers) {
      return this;
    }
    var _h = this._$handlers[eventType];
    var eventProcessor = this._$eventProcessor;
    if (_h) {
      var argLen = args.length;
      var len2 = _h.length;
      for (var i2 = 0; i2 < len2; i2++) {
        var hItem = _h[i2];
        if (eventProcessor && eventProcessor.filter && hItem.query != null && !eventProcessor.filter(eventType, hItem.query)) {
          continue;
        }
        switch (argLen) {
          case 0:
            hItem.h.call(hItem.ctx);
            break;
          case 1:
            hItem.h.call(hItem.ctx, args[0]);
            break;
          case 2:
            hItem.h.call(hItem.ctx, args[0], args[1]);
            break;
          default:
            hItem.h.apply(hItem.ctx, args);
            break;
        }
      }
    }
    eventProcessor && eventProcessor.afterTrigger && eventProcessor.afterTrigger(eventType);
    return this;
  };
  Eventful2.prototype.triggerWithContext = function(type) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
      args[_i - 1] = arguments[_i];
    }
    if (!this._$handlers) {
      return this;
    }
    var _h = this._$handlers[type];
    var eventProcessor = this._$eventProcessor;
    if (_h) {
      var argLen = args.length;
      var ctx = args[argLen - 1];
      var len2 = _h.length;
      for (var i2 = 0; i2 < len2; i2++) {
        var hItem = _h[i2];
        if (eventProcessor && eventProcessor.filter && hItem.query != null && !eventProcessor.filter(type, hItem.query)) {
          continue;
        }
        switch (argLen) {
          case 0:
            hItem.h.call(ctx);
            break;
          case 1:
            hItem.h.call(ctx, args[0]);
            break;
          case 2:
            hItem.h.call(ctx, args[0], args[1]);
            break;
          default:
            hItem.h.apply(ctx, args.slice(1, argLen - 1));
            break;
        }
      }
    }
    eventProcessor && eventProcessor.afterTrigger && eventProcessor.afterTrigger(type);
    return this;
  };
  return Eventful2;
}();
const Eventful$1 = Eventful;
var LN2 = Math.log(2);
function determinant(rows, rank, rowStart, rowMask, colMask, detCache) {
  var cacheKey = rowMask + "-" + colMask;
  var fullRank = rows.length;
  if (detCache.hasOwnProperty(cacheKey)) {
    return detCache[cacheKey];
  }
  if (rank === 1) {
    var colStart = Math.round(Math.log((1 << fullRank) - 1 & ~colMask) / LN2);
    return rows[rowStart][colStart];
  }
  var subRowMask = rowMask | 1 << rowStart;
  var subRowStart = rowStart + 1;
  while (rowMask & 1 << subRowStart) {
    subRowStart++;
  }
  var sum = 0;
  for (var j2 = 0, colLocalIdx = 0; j2 < fullRank; j2++) {
    var colTag = 1 << j2;
    if (!(colTag & colMask)) {
      sum += (colLocalIdx % 2 ? -1 : 1) * rows[rowStart][j2] * determinant(rows, rank - 1, subRowStart, subRowMask, colMask | colTag, detCache);
      colLocalIdx++;
    }
  }
  detCache[cacheKey] = sum;
  return sum;
}
function buildTransformer(src, dest) {
  var mA = [[src[0], src[1], 1, 0, 0, 0, -dest[0] * src[0], -dest[0] * src[1]], [0, 0, 0, src[0], src[1], 1, -dest[1] * src[0], -dest[1] * src[1]], [src[2], src[3], 1, 0, 0, 0, -dest[2] * src[2], -dest[2] * src[3]], [0, 0, 0, src[2], src[3], 1, -dest[3] * src[2], -dest[3] * src[3]], [src[4], src[5], 1, 0, 0, 0, -dest[4] * src[4], -dest[4] * src[5]], [0, 0, 0, src[4], src[5], 1, -dest[5] * src[4], -dest[5] * src[5]], [src[6], src[7], 1, 0, 0, 0, -dest[6] * src[6], -dest[6] * src[7]], [0, 0, 0, src[6], src[7], 1, -dest[7] * src[6], -dest[7] * src[7]]];
  var detCache = {};
  var det = determinant(mA, 8, 0, 0, 0, detCache);
  if (det === 0) {
    return;
  }
  var vh = [];
  for (var i2 = 0; i2 < 8; i2++) {
    for (var j2 = 0; j2 < 8; j2++) {
      vh[j2] == null && (vh[j2] = 0);
      vh[j2] += ((i2 + j2) % 2 ? -1 : 1) * determinant(mA, 7, i2 === 0 ? 1 : 0, 1 << i2, 1 << j2, detCache) / det * dest[i2];
    }
  }
  return function(out2, srcPointX, srcPointY) {
    var pk = srcPointX * vh[6] + srcPointY * vh[7] + 1;
    out2[0] = (srcPointX * vh[0] + srcPointY * vh[1] + vh[2]) / pk;
    out2[1] = (srcPointX * vh[3] + srcPointY * vh[4] + vh[5]) / pk;
  };
}
var EVENT_SAVED_PROP = "___zrEVENTSAVED";
function transformCoordWithViewport(out2, el, inX, inY, inverse) {
  if (el.getBoundingClientRect && env$1.domSupported && !isCanvasEl(el)) {
    var saved = el[EVENT_SAVED_PROP] || (el[EVENT_SAVED_PROP] = {});
    var markers = prepareCoordMarkers(el, saved);
    var transformer = preparePointerTransformer(markers, saved, inverse);
    if (transformer) {
      transformer(out2, inX, inY);
      return true;
    }
  }
  return false;
}
function prepareCoordMarkers(el, saved) {
  var markers = saved.markers;
  if (markers) {
    return markers;
  }
  markers = saved.markers = [];
  var propLR = ["left", "right"];
  var propTB = ["top", "bottom"];
  for (var i2 = 0; i2 < 4; i2++) {
    var marker = document.createElement("div");
    var stl = marker.style;
    var idxLR = i2 % 2;
    var idxTB = (i2 >> 1) % 2;
    stl.cssText = ["position: absolute", "visibility: hidden", "padding: 0", "margin: 0", "border-width: 0", "user-select: none", "width:0", "height:0", propLR[idxLR] + ":0", propTB[idxTB] + ":0", propLR[1 - idxLR] + ":auto", propTB[1 - idxTB] + ":auto", ""].join("!important;");
    el.appendChild(marker);
    markers.push(marker);
  }
  return markers;
}
function preparePointerTransformer(markers, saved, inverse) {
  var transformerName = inverse ? "invTrans" : "trans";
  var transformer = saved[transformerName];
  var oldSrcCoords = saved.srcCoords;
  var srcCoords = [];
  var destCoords = [];
  var oldCoordTheSame = true;
  for (var i2 = 0; i2 < 4; i2++) {
    var rect = markers[i2].getBoundingClientRect();
    var ii = 2 * i2;
    var x2 = rect.left;
    var y2 = rect.top;
    srcCoords.push(x2, y2);
    oldCoordTheSame = oldCoordTheSame && oldSrcCoords && x2 === oldSrcCoords[ii] && y2 === oldSrcCoords[ii + 1];
    destCoords.push(markers[i2].offsetLeft, markers[i2].offsetTop);
  }
  return oldCoordTheSame && transformer ? transformer : (saved.srcCoords = srcCoords, saved[transformerName] = inverse ? buildTransformer(destCoords, srcCoords) : buildTransformer(srcCoords, destCoords));
}
function isCanvasEl(el) {
  return el.nodeName.toUpperCase() === "CANVAS";
}
var replaceReg = /([&<>"'])/g;
var replaceMap = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  '"': "&quot;",
  "'": "&#39;"
};
function encodeHTML(source) {
  return source == null ? "" : (source + "").replace(replaceReg, function(str, c) {
    return replaceMap[c];
  });
}
var MOUSE_EVENT_REG = /^(?:mouse|pointer|contextmenu|drag|drop)|click/;
var _calcOut = [];
var firefoxNotSupportOffsetXY = env$1.browser.firefox && +env$1.browser.version.split(".")[0] < 39;
function clientToLocal(el, e2, out2, calculate) {
  out2 = out2 || {};
  if (calculate) {
    calculateZrXY(el, e2, out2);
  } else if (firefoxNotSupportOffsetXY && e2.layerX != null && e2.layerX !== e2.offsetX) {
    out2.zrX = e2.layerX;
    out2.zrY = e2.layerY;
  } else if (e2.offsetX != null) {
    out2.zrX = e2.offsetX;
    out2.zrY = e2.offsetY;
  } else {
    calculateZrXY(el, e2, out2);
  }
  return out2;
}
function calculateZrXY(el, e2, out2) {
  if (env$1.domSupported && el.getBoundingClientRect) {
    var ex = e2.clientX;
    var ey = e2.clientY;
    if (isCanvasEl(el)) {
      var box = el.getBoundingClientRect();
      out2.zrX = ex - box.left;
      out2.zrY = ey - box.top;
      return;
    } else {
      if (transformCoordWithViewport(_calcOut, el, ex, ey)) {
        out2.zrX = _calcOut[0];
        out2.zrY = _calcOut[1];
        return;
      }
    }
  }
  out2.zrX = out2.zrY = 0;
}
function getNativeEvent(e2) {
  return e2 || window.event;
}
function normalizeEvent(el, e2, calculate) {
  e2 = getNativeEvent(e2);
  if (e2.zrX != null) {
    return e2;
  }
  var eventType = e2.type;
  var isTouch = eventType && eventType.indexOf("touch") >= 0;
  if (!isTouch) {
    clientToLocal(el, e2, e2, calculate);
    var wheelDelta = getWheelDeltaMayPolyfill(e2);
    e2.zrDelta = wheelDelta ? wheelDelta / 120 : -(e2.detail || 0) / 3;
  } else {
    var touch = eventType !== "touchend" ? e2.targetTouches[0] : e2.changedTouches[0];
    touch && clientToLocal(el, touch, e2, calculate);
  }
  var button = e2.button;
  if (e2.which == null && button !== void 0 && MOUSE_EVENT_REG.test(e2.type)) {
    e2.which = button & 1 ? 1 : button & 2 ? 3 : button & 4 ? 2 : 0;
  }
  return e2;
}
function getWheelDeltaMayPolyfill(e2) {
  var rawWheelDelta = e2.wheelDelta;
  if (rawWheelDelta) {
    return rawWheelDelta;
  }
  var deltaX = e2.deltaX;
  var deltaY = e2.deltaY;
  if (deltaX == null || deltaY == null) {
    return rawWheelDelta;
  }
  var delta = deltaY !== 0 ? Math.abs(deltaY) : Math.abs(deltaX);
  var sign = deltaY > 0 ? -1 : deltaY < 0 ? 1 : deltaX > 0 ? -1 : 1;
  return 3 * delta * sign;
}
function addEventListener(el, name, handler, opt2) {
  el.addEventListener(name, handler, opt2);
}
function removeEventListener(el, name, handler, opt2) {
  el.removeEventListener(name, handler, opt2);
}
var stop = function(e2) {
  e2.preventDefault();
  e2.stopPropagation();
  e2.cancelBubble = true;
};
var GestureMgr = function() {
  function GestureMgr2() {
    this._track = [];
  }
  GestureMgr2.prototype.recognize = function(event, target2, root) {
    this._doTrack(event, target2, root);
    return this._recognize(event);
  };
  GestureMgr2.prototype.clear = function() {
    this._track.length = 0;
    return this;
  };
  GestureMgr2.prototype._doTrack = function(event, target2, root) {
    var touches = event.touches;
    if (!touches) {
      return;
    }
    var trackItem = {
      points: [],
      touches: [],
      target: target2,
      event
    };
    for (var i2 = 0, len2 = touches.length; i2 < len2; i2++) {
      var touch = touches[i2];
      var pos = clientToLocal(root, touch, {});
      trackItem.points.push([pos.zrX, pos.zrY]);
      trackItem.touches.push(touch);
    }
    this._track.push(trackItem);
  };
  GestureMgr2.prototype._recognize = function(event) {
    for (var eventName in recognizers) {
      if (recognizers.hasOwnProperty(eventName)) {
        var gestureInfo = recognizers[eventName](this._track, event);
        if (gestureInfo) {
          return gestureInfo;
        }
      }
    }
  };
  return GestureMgr2;
}();
function dist(pointPair) {
  var dx = pointPair[1][0] - pointPair[0][0];
  var dy = pointPair[1][1] - pointPair[0][1];
  return Math.sqrt(dx * dx + dy * dy);
}
function center(pointPair) {
  return [(pointPair[0][0] + pointPair[1][0]) / 2, (pointPair[0][1] + pointPair[1][1]) / 2];
}
var recognizers = {
  pinch: function(tracks, event) {
    var trackLen = tracks.length;
    if (!trackLen) {
      return;
    }
    var pinchEnd = (tracks[trackLen - 1] || {}).points;
    var pinchPre = (tracks[trackLen - 2] || {}).points || pinchEnd;
    if (pinchPre && pinchPre.length > 1 && pinchEnd && pinchEnd.length > 1) {
      var pinchScale = dist(pinchEnd) / dist(pinchPre);
      !isFinite(pinchScale) && (pinchScale = 1);
      event.pinchScale = pinchScale;
      var pinchCenter = center(pinchEnd);
      event.pinchX = pinchCenter[0];
      event.pinchY = pinchCenter[1];
      return {
        type: "pinch",
        target: tracks[0].target,
        event
      };
    }
  }
};
function create() {
  return [1, 0, 0, 1, 0, 0];
}
function identity(out2) {
  out2[0] = 1;
  out2[1] = 0;
  out2[2] = 0;
  out2[3] = 1;
  out2[4] = 0;
  out2[5] = 0;
  return out2;
}
function copy(out2, m2) {
  out2[0] = m2[0];
  out2[1] = m2[1];
  out2[2] = m2[2];
  out2[3] = m2[3];
  out2[4] = m2[4];
  out2[5] = m2[5];
  return out2;
}
function mul(out2, m1, m2) {
  var out0 = m1[0] * m2[0] + m1[2] * m2[1];
  var out1 = m1[1] * m2[0] + m1[3] * m2[1];
  var out22 = m1[0] * m2[2] + m1[2] * m2[3];
  var out3 = m1[1] * m2[2] + m1[3] * m2[3];
  var out4 = m1[0] * m2[4] + m1[2] * m2[5] + m1[4];
  var out5 = m1[1] * m2[4] + m1[3] * m2[5] + m1[5];
  out2[0] = out0;
  out2[1] = out1;
  out2[2] = out22;
  out2[3] = out3;
  out2[4] = out4;
  out2[5] = out5;
  return out2;
}
function translate(out2, a, v) {
  out2[0] = a[0];
  out2[1] = a[1];
  out2[2] = a[2];
  out2[3] = a[3];
  out2[4] = a[4] + v[0];
  out2[5] = a[5] + v[1];
  return out2;
}
function rotate(out2, a, rad) {
  var aa = a[0];
  var ac = a[2];
  var atx = a[4];
  var ab = a[1];
  var ad = a[3];
  var aty = a[5];
  var st = Math.sin(rad);
  var ct = Math.cos(rad);
  out2[0] = aa * ct + ab * st;
  out2[1] = -aa * st + ab * ct;
  out2[2] = ac * ct + ad * st;
  out2[3] = -ac * st + ct * ad;
  out2[4] = ct * atx + st * aty;
  out2[5] = ct * aty - st * atx;
  return out2;
}
function scale$1(out2, a, v) {
  var vx = v[0];
  var vy = v[1];
  out2[0] = a[0] * vx;
  out2[1] = a[1] * vy;
  out2[2] = a[2] * vx;
  out2[3] = a[3] * vy;
  out2[4] = a[4] * vx;
  out2[5] = a[5] * vy;
  return out2;
}
function invert(out2, a) {
  var aa = a[0];
  var ac = a[2];
  var atx = a[4];
  var ab = a[1];
  var ad = a[3];
  var aty = a[5];
  var det = aa * ad - ab * ac;
  if (!det) {
    return null;
  }
  det = 1 / det;
  out2[0] = ad * det;
  out2[1] = -ab * det;
  out2[2] = -ac * det;
  out2[3] = aa * det;
  out2[4] = (ac * aty - ad * atx) * det;
  out2[5] = (ab * atx - aa * aty) * det;
  return out2;
}
var Point = function() {
  function Point2(x2, y2) {
    this.x = x2 || 0;
    this.y = y2 || 0;
  }
  Point2.prototype.copy = function(other) {
    this.x = other.x;
    this.y = other.y;
    return this;
  };
  Point2.prototype.clone = function() {
    return new Point2(this.x, this.y);
  };
  Point2.prototype.set = function(x2, y2) {
    this.x = x2;
    this.y = y2;
    return this;
  };
  Point2.prototype.equal = function(other) {
    return other.x === this.x && other.y === this.y;
  };
  Point2.prototype.add = function(other) {
    this.x += other.x;
    this.y += other.y;
    return this;
  };
  Point2.prototype.scale = function(scalar) {
    this.x *= scalar;
    this.y *= scalar;
  };
  Point2.prototype.scaleAndAdd = function(other, scalar) {
    this.x += other.x * scalar;
    this.y += other.y * scalar;
  };
  Point2.prototype.sub = function(other) {
    this.x -= other.x;
    this.y -= other.y;
    return this;
  };
  Point2.prototype.dot = function(other) {
    return this.x * other.x + this.y * other.y;
  };
  Point2.prototype.len = function() {
    return Math.sqrt(this.x * this.x + this.y * this.y);
  };
  Point2.prototype.lenSquare = function() {
    return this.x * this.x + this.y * this.y;
  };
  Point2.prototype.normalize = function() {
    var len2 = this.len();
    this.x /= len2;
    this.y /= len2;
    return this;
  };
  Point2.prototype.distance = function(other) {
    var dx = this.x - other.x;
    var dy = this.y - other.y;
    return Math.sqrt(dx * dx + dy * dy);
  };
  Point2.prototype.distanceSquare = function(other) {
    var dx = this.x - other.x;
    var dy = this.y - other.y;
    return dx * dx + dy * dy;
  };
  Point2.prototype.negate = function() {
    this.x = -this.x;
    this.y = -this.y;
    return this;
  };
  Point2.prototype.transform = function(m2) {
    if (!m2) {
      return;
    }
    var x2 = this.x;
    var y2 = this.y;
    this.x = m2[0] * x2 + m2[2] * y2 + m2[4];
    this.y = m2[1] * x2 + m2[3] * y2 + m2[5];
    return this;
  };
  Point2.prototype.toArray = function(out2) {
    out2[0] = this.x;
    out2[1] = this.y;
    return out2;
  };
  Point2.prototype.fromArray = function(input) {
    this.x = input[0];
    this.y = input[1];
  };
  Point2.set = function(p2, x2, y2) {
    p2.x = x2;
    p2.y = y2;
  };
  Point2.copy = function(p2, p22) {
    p2.x = p22.x;
    p2.y = p22.y;
  };
  Point2.len = function(p2) {
    return Math.sqrt(p2.x * p2.x + p2.y * p2.y);
  };
  Point2.lenSquare = function(p2) {
    return p2.x * p2.x + p2.y * p2.y;
  };
  Point2.dot = function(p0, p1) {
    return p0.x * p1.x + p0.y * p1.y;
  };
  Point2.add = function(out2, p0, p1) {
    out2.x = p0.x + p1.x;
    out2.y = p0.y + p1.y;
  };
  Point2.sub = function(out2, p0, p1) {
    out2.x = p0.x - p1.x;
    out2.y = p0.y - p1.y;
  };
  Point2.scale = function(out2, p0, scalar) {
    out2.x = p0.x * scalar;
    out2.y = p0.y * scalar;
  };
  Point2.scaleAndAdd = function(out2, p0, p1, scalar) {
    out2.x = p0.x + p1.x * scalar;
    out2.y = p0.y + p1.y * scalar;
  };
  Point2.lerp = function(out2, p0, p1, t2) {
    var onet = 1 - t2;
    out2.x = onet * p0.x + t2 * p1.x;
    out2.y = onet * p0.y + t2 * p1.y;
  };
  return Point2;
}();
const Point$1 = Point;
var mathMin$5 = Math.min;
var mathMax$5 = Math.max;
var lt = new Point$1();
var rb = new Point$1();
var lb = new Point$1();
var rt = new Point$1();
var minTv$1 = new Point$1();
var maxTv$1 = new Point$1();
var BoundingRect = function() {
  function BoundingRect2(x2, y2, width, height) {
    if (width < 0) {
      x2 = x2 + width;
      width = -width;
    }
    if (height < 0) {
      y2 = y2 + height;
      height = -height;
    }
    this.x = x2;
    this.y = y2;
    this.width = width;
    this.height = height;
  }
  BoundingRect2.prototype.union = function(other) {
    var x2 = mathMin$5(other.x, this.x);
    var y2 = mathMin$5(other.y, this.y);
    if (isFinite(this.x) && isFinite(this.width)) {
      this.width = mathMax$5(other.x + other.width, this.x + this.width) - x2;
    } else {
      this.width = other.width;
    }
    if (isFinite(this.y) && isFinite(this.height)) {
      this.height = mathMax$5(other.y + other.height, this.y + this.height) - y2;
    } else {
      this.height = other.height;
    }
    this.x = x2;
    this.y = y2;
  };
  BoundingRect2.prototype.applyTransform = function(m2) {
    BoundingRect2.applyTransform(this, this, m2);
  };
  BoundingRect2.prototype.calculateTransform = function(b2) {
    var a = this;
    var sx = b2.width / a.width;
    var sy = b2.height / a.height;
    var m2 = create();
    translate(m2, m2, [-a.x, -a.y]);
    scale$1(m2, m2, [sx, sy]);
    translate(m2, m2,