/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.server.config;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.noear.solon.Solon;
import org.noear.solon.admin.server.config.ServerProperties;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration
public class AdminServerBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminServerBootstrapConfiguration.class);

    @Condition(onProperty="${solon.admin.server.enabled:true} = true")
    @Bean
    public MarkedServerEnabled markedServerEnabled(@Inject(value="${solon.admin.server.mode:local}") String mode) {
        return new MarkedServerEnabled(mode);
    }

    @Bean
    public ScheduledThreadPoolExecutor scheduledThreadPoolExecutor(@Inject(required=false) MarkedServerEnabled marker) {
        if (marker == null) {
            return null;
        }
        return new ScheduledThreadPoolExecutor(1);
    }

    @Bean
    public OkHttpClient okHttpClient(@Inject(required=false) MarkedServerEnabled marker) {
        if (marker == null) {
            return null;
        }
        ServerProperties config = (ServerProperties)Solon.context().getBean(ServerProperties.class);
        return new OkHttpClient.Builder().connectTimeout(config.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(config.getReadTimeout(), TimeUnit.MILLISECONDS).build();
    }

    public static final class MarkedServerEnabled {
        private final String mode;

        public MarkedServerEnabled(String mode) {
            this.mode = mode;
            log.info("Solon Admin server has been successfully enabled in {} mode.", (Object)this.mode);
        }

        @Generated
        public String getMode() {
            return this.mode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarkedServerEnabled)) {
                return false;
            }
            MarkedServerEnabled other = (MarkedServerEnabled)o;
            String this$mode = this.getMode();
            String other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdminServerBootstrapConfiguration.MarkedServerEnabled(mode=" + this.getMode() + ")";
        }
    }
}

