/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.server.config;

import org.noear.solon.Utils;
import org.noear.solon.admin.server.config.ServerProperties;
import org.noear.solon.admin.server.utils.BasicAuthUtils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.PathRule;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChain;

public class AuthRouterInterceptor
implements RouterInterceptor {
    private String uiPath;
    private ServerProperties serverProperties;

    public AuthRouterInterceptor(String uiPath, ServerProperties serverProperties) {
        this.uiPath = uiPath;
        this.serverProperties = serverProperties;
    }

    public PathRule pathPatterns() {
        if (Utils.isEmpty((String)this.uiPath)) {
            return null;
        }
        return new PathRule().include(new String[]{this.uiPath});
    }

    public void doIntercept(Context ctx, Handler mainHandler, RouterInterceptorChain chain) throws Throwable {
        if (!BasicAuthUtils.basicAuth(ctx, this.serverProperties)) {
            BasicAuthUtils.response401(ctx);
        } else {
            chain.doIntercept(ctx, mainHandler);
        }
    }
}

