/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.server.config;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.admin.server.annotation.EnableAdminServer;
import org.noear.solon.admin.server.config.AuthRouterInterceptor;
import org.noear.solon.admin.server.config.ServerProperties;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.web.staticfiles.StaticMappings;
import org.noear.solon.web.staticfiles.StaticRepository;
import org.noear.solon.web.staticfiles.repository.ClassPathStaticRepository;

public class XPluginImpl
implements Plugin {
    public void start(AppContext context) {
        if (!Solon.app().source().isAnnotationPresent(EnableAdminServer.class)) {
            return;
        }
        if (!Solon.cfg().getBool("solon.admin.server.enabled", true)) {
            return;
        }
        if (!Solon.cfg().getBool("solon.admin.server.enable", true)) {
            return;
        }
        Solon.app().enableWebSocket(true);
        context.beanScan("org.noear.solon.admin.server");
        String serverUrl = "http://localhost:" + Solon.cfg().serverPort();
        Solon.app().sharedAdd("solon-admin-server-url", (Object)serverUrl);
        ServerProperties serverProperties = (ServerProperties)context.getBean(ServerProperties.class);
        String uiPath = this.buildUiPath(serverProperties);
        StaticMappings.add((String)uiPath, (StaticRepository)new ClassPathStaticRepository("META-INF/solon-admin-server-ui"));
        Solon.app().routerInterceptor((RouterInterceptor)new AuthRouterInterceptor(uiPath, serverProperties));
        Solon.app().get(uiPath, c -> c.forward(uiPath + "index.html"));
        Solon.app().get(uiPath + "index.html", c -> c.redirect(uiPath));
    }

    private String buildUiPath(ServerProperties serverProperties) {
        String uiPath = serverProperties.getUiPath();
        if (Utils.isEmpty((String)uiPath)) {
            uiPath = "/";
        }
        if (!uiPath.startsWith("/")) {
            uiPath = "/" + uiPath;
        }
        if (!uiPath.endsWith("/")) {
            uiPath = uiPath + "/";
        }
        return uiPath;
    }
}

