/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.server.controller;

import java.util.Collection;
import java.util.List;
import org.noear.solon.admin.server.data.Application;
import org.noear.solon.admin.server.data.ApplicationWebsocketTransfer;
import org.noear.solon.admin.server.services.ApplicationService;
import org.noear.solon.admin.server.services.ClientMonitorService;
import org.noear.solon.admin.server.utils.JsonUtils;
import org.noear.solon.annotation.Inject;
import org.noear.solon.net.annotation.ServerEndpoint;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.listener.SimpleWebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/ws/application")
public class ApplicationWebsocketController
extends SimpleWebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(ApplicationWebsocketController.class);
    @Inject
    private ApplicationService applicationService;
    @Inject
    private ClientMonitorService clientMonitorService;
    @Inject(value="applicationWebsocketSessions")
    private List<WebSocket> sessions;

    public void onOpen(WebSocket session) {
        if (log.isDebugEnabled()) {
            log.debug("onOpen...");
        }
        this.sessions.add(session);
    }

    public void onMessage(WebSocket session, String message) {
        ApplicationWebsocketTransfer data;
        if (log.isDebugEnabled()) {
            log.debug("onMessage: " + message);
        }
        if ((data = (ApplicationWebsocketTransfer)JsonUtils.fromJson(message, ApplicationWebsocketTransfer.class)).getType().equals("getAllApplication")) {
            session.send(JsonUtils.toJson(new ApplicationWebsocketTransfer<Collection<Application>>(null, "getAllApplication", this.applicationService.getApplications())));
        }
    }

    public void onClose(WebSocket session) {
        if (log.isDebugEnabled()) {
            log.debug("onClose...");
        }
        this.sessions.remove(session);
    }
}

