/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.openai;

import java.util.ArrayList;
import org.noear.snack.ONode;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.reranking.Reranking;
import org.noear.solon.ai.reranking.RerankingConfig;
import org.noear.solon.ai.reranking.RerankingException;
import org.noear.solon.ai.reranking.RerankingResponse;
import org.noear.solon.ai.reranking.dialect.AbstractRerankingDialect;

public class OpenaiRerankingDialect
extends AbstractRerankingDialect {
    private static OpenaiRerankingDialect instance = new OpenaiRerankingDialect();

    public static OpenaiRerankingDialect getInstance() {
        return instance;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean matched(RerankingConfig config) {
        return false;
    }

    public RerankingResponse parseResponseJson(RerankingConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("error")) {
            return new RerankingResponse(model, new RerankingException(oResp.get("error").getString()), null, null);
        }
        ArrayList<Reranking> results = new ArrayList<Reranking>();
        for (ONode n1 : oResp.get("results").ary()) {
            Reranking r1 = new Reranking(n1.get("index").getInt(), n1.get("document").get("text").getString(), n1.get("relevance_score").getFloat());
            results.add(r1);
        }
        AiUsage usage = null;
        if (oResp.contains("usage")) {
            ONode oUsage = oResp.get("usage");
            usage = new AiUsage((long)oUsage.get("prompt_tokens").getInt(), 0L, (long)oUsage.get("total_tokens").getInt());
        }
        return new RerankingResponse(model, null, results, usage);
    }
}

