/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot.proxy;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.TreeMap;

public class MethodFinder {
    public static boolean allowMethod(Method element) {
        int modifiers = element.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers);
    }

    public static String buildMethodKey(Method method) {
        StringBuilder buf = new StringBuilder();
        buf.append(method.getName());
        buf.append("(");
        for (Parameter pe : method.getParameters()) {
            Class<?> pet = pe.getType();
            buf.append(pet.toString());
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    public static Map<String, Method> findMethodAll(Class<?> type) {
        TreeMap<String, Method> methodAll = new TreeMap<String, Method>();
        MethodFinder.findMethodDo(type, methodAll);
        return methodAll;
    }

    private static void findMethodDo(Class<?> type, Map<String, Method> methodAll) {
        if (type == null || type == Object.class) {
            return;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!MethodFinder.allowMethod(method)) continue;
            String methodKey = MethodFinder.buildMethodKey(method);
            methodAll.putIfAbsent(methodKey, method);
        }
        MethodFinder.findMethodDo(type.getSuperclass(), methodAll);
        for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
            MethodFinder.findMethodDo(genericDeclaration, methodAll);
        }
    }
}

