/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.predicate;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;
import org.noear.solon.core.util.PathMatcher;

public class PathPredicateFactory
implements RoutePredicateFactory {
    @Override
    public String prefix() {
        return "Path";
    }

    @Override
    public ExPredicate create(String config) {
        return new PathPredicate(config);
    }

    public static class PathPredicate
    implements ExPredicate {
        private final List<PathMatcher> rules;
        private int depthMin;

        public PathPredicate(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("PathPredicate config cannot be blank");
            }
            this.rules = new ArrayList<PathMatcher>();
            for (String path : config.split(",")) {
                String trimmedPath = path.trim();
                if (trimmedPath.length() <= 0) continue;
                PathMatcher rule = PathMatcher.get((String)trimmedPath);
                this.rules.add(rule);
                if (this.depthMin != 0 && this.depthMin <= rule.depth()) continue;
                this.depthMin = rule.depth();
            }
        }

        public int depth() {
            return this.depthMin;
        }

        @Override
        public boolean test(ExContext ctx) {
            for (PathMatcher rule : this.rules) {
                if (!rule.matches(ctx.rawPath())) continue;
                return true;
            }
            return false;
        }
    }
}

