/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.http.HttpExtension;
import org.noear.solon.net.http.HttpExtensionManager;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.impl.HttpStream;
import org.noear.solon.net.http.impl.HttpTimeout;
import org.noear.solon.net.http.impl.HttpUploadFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpUtils
implements HttpUtils {
    static final Logger log = LoggerFactory.getLogger(AbstractHttpUtils.class);
    protected boolean _enablePrintln = false;
    protected final String _url;
    protected Charset _charset = StandardCharsets.UTF_8;
    protected MultiMap<String> _headers;
    protected MultiMap<String> _cookies;
    protected MultiMap<String> _params;
    protected MultiMap<HttpUploadFile> _files;
    protected HttpStream _bodyRaw;
    protected boolean _multipart = false;
    protected HttpTimeout _timeout;

    public AbstractHttpUtils(String url) {
        this._url = url;
        if (!url.contains("://")) {
            throw new IllegalArgumentException("No url scheme 'http' or 'https' found: " + url);
        }
        this.initExtension();
    }

    private void initExtension() {
        for (HttpExtension ext : HttpExtensionManager.getExtensions()) {
            ext.onInit(this, this._url);
        }
    }

    @Override
    public HttpUtils enablePrintln(boolean enable) {
        this._enablePrintln = enable;
        return this;
    }

    @Override
    public HttpUtils timeout(int timeoutSeconds) {
        this._timeout = new HttpTimeout(timeoutSeconds);
        return this;
    }

    @Override
    public HttpUtils timeout(int connectTimeoutSeconds, int writeTimeoutSeconds, int readTimeoutSeconds) {
        this._timeout = new HttpTimeout(connectTimeoutSeconds, writeTimeoutSeconds, readTimeoutSeconds);
        return this;
    }

    @Override
    public HttpUtils multipart(boolean multipart) {
        this._multipart = multipart;
        return this;
    }

    @Override
    public HttpUtils userAgent(String ua) {
        this.header("User-Agent", ua);
        return this;
    }

    @Override
    public HttpUtils charset(String charset) {
        this._charset = Charset.forName(charset);
        return this;
    }

    @Override
    public HttpUtils headers(Map headers) {
        if (headers != null) {
            this.tryInitHeaders();
            headers.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._headers.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils headers(Iterable<KeyValues<String>> headers) {
        if (headers != null) {
            this.tryInitHeaders();
            for (KeyValues<String> kv : headers) {
                this._headers.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtils header(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitHeaders().put(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils headerAdd(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitHeaders().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils cookies(Map cookies) {
        if (cookies != null) {
            this.tryInitCookies();
            cookies.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._cookies.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils cookies(Iterable<KeyValues<String>> cookies) {
        if (cookies != null) {
            this.tryInitCookies();
            for (KeyValues<String> kv : cookies) {
                this._cookies.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtils cookie(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitCookies().put(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils cookieAdd(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitCookies().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils data(Map data) {
        if (data != null) {
            this.tryInitParams();
            data.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._params.put(k.toString(), (Object)v.toString());
                }
            });
        }
        return this;
    }

    @Override
    public HttpUtils data(Iterable<KeyValues<String>> data) {
        if (data != null) {
            this.tryInitParams();
            for (KeyValues<String> kv : data) {
                this._params.holder(kv.getKey()).setValues(kv.getValues());
            }
        }
        return this;
    }

    @Override
    public HttpUtils data(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.tryInitParams().add(name, (Object)value);
        return this;
    }

    @Override
    public HttpUtils data(String name, String filename, InputStream inputStream, String contentType) {
        if (name == null || inputStream == null) {
            return this;
        }
        this.multipart(true);
        this.tryInitFiles().add(name, (Object)new HttpUploadFile(filename, new HttpStream(inputStream, contentType)));
        return this;
    }

    @Override
    public HttpUtils bodyTxt(String txt) {
        return this.bodyTxt(txt, "text/plain");
    }

    @Override
    public HttpUtils bodyTxt(String txt, String contentType) {
        if (txt != null) {
            this.bodyRaw(txt.getBytes(this._charset), contentType);
        }
        return this;
    }

    @Override
    public HttpUtils bodyJson(String txt) {
        return this.bodyTxt(txt, "application/json");
    }

    @Override
    public HttpUtils bodyRaw(byte[] bytes) {
        return this.bodyRaw(bytes, null);
    }

    @Override
    public HttpUtils bodyRaw(byte[] bytes, String contentType) {
        if (bytes == null) {
            return this;
        }
        return this.bodyRaw(new ByteArrayInputStream(bytes), contentType);
    }

    @Override
    public HttpUtils bodyRaw(InputStream raw) {
        return this.bodyRaw(raw, null);
    }

    @Override
    public HttpUtils bodyRaw(InputStream raw, String contentType) {
        if (raw != null) {
            this._bodyRaw = new HttpStream(raw, contentType);
        }
        return this;
    }

    @Override
    public String get() throws IOException {
        return this.execAsBody("GET");
    }

    @Override
    public String post() throws IOException {
        return this.execAsBody("POST");
    }

    @Override
    public String put() throws IOException {
        return this.execAsBody("PUT");
    }

    @Override
    public String patch() throws IOException {
        return this.execAsBody("PATCH");
    }

    @Override
    public String delete() throws IOException {
        return this.execAsBody("DELETE");
    }

    @Override
    public String options() throws IOException {
        return this.execAsBody("OPTIONS");
    }

    @Override
    public int head() throws IOException {
        return this.execAsCode("HEAD");
    }

    @Override
    public String execAsBody(String method) throws IOException {
        try (HttpResponse resp = this.exec(method);){
            String text = resp.bodyAsString();
            if (this._enablePrintln) {
                System.out.println(method + " " + this._url + ":: " + text);
            }
            String string = text;
            return string;
        }
    }

    @Override
    public int execAsCode(String method) throws IOException {
        try (HttpResponse resp = this.exec(method);){
            int code = resp.code();
            if (this._enablePrintln) {
                System.out.println(method + " " + this._url + "::code:: " + code);
            }
            int n = code;
            return n;
        }
    }

    @Override
    public HttpResponse exec(String method) throws IOException {
        try {
            return this.execDo(method, null);
        }
        catch (IOException e) {
            throw new IOException(method + " " + this._url + ", request failed", e);
        }
    }

    @Override
    public CompletableFuture<HttpResponse> execAsync(String method) {
        try {
            CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
            this.execDo(method, future);
            return future;
        }
        catch (IOException e) {
            throw new RuntimeException(method + " " + this._url + ", request failed", e);
        }
    }

    protected abstract HttpResponse execDo(String var1, CompletableFuture<HttpResponse> var2) throws IOException;

    protected String getRequestCookieString(MultiMap<String> cookies) {
        StringBuilder sb = new StringBuilder();
        for (KeyValues kv : cookies) {
            for (String val : kv.getValues()) {
                sb.append(kv.getKey()).append('=').append(val).append("; ");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    protected MultiMap<String> tryInitParams() {
        if (this._params == null) {
            this._params = new MultiMap();
        }
        return this._params;
    }

    protected MultiMap<HttpUploadFile> tryInitFiles() {
        if (this._files == null) {
            this._files = new MultiMap();
        }
        return this._files;
    }

    protected MultiMap<String> tryInitCookies() {
        if (this._cookies == null) {
            this._cookies = new MultiMap();
        }
        return this._cookies;
    }

    protected MultiMap<String> tryInitHeaders() {
        if (this._headers == null) {
            this._headers = new MultiMap();
        }
        return this._headers;
    }
}

