/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.aot.hint.ExecutableHint;
import org.noear.solon.aot.hint.ExecutableMode;
import org.noear.solon.aot.hint.JdkProxyHint;
import org.noear.solon.aot.hint.MemberCategory;
import org.noear.solon.aot.hint.ReflectionHints;
import org.noear.solon.aot.hint.ResourceHint;
import org.noear.solon.aot.hint.SerializationHint;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ScanUtil;

public class RuntimeNativeMetadata {
    private final Options jsonOptions = Options.def().add(new Feature[]{Feature.PrettyFormat}).add(new Feature[]{Feature.OrderedField});
    private final Map<String, ReflectionHints> reflection = new LinkedHashMap<String, ReflectionHints>();
    private final Set<String> args = new TreeSet<String>();
    private final List<ResourceHint> includes = new ArrayList<ResourceHint>();
    private final List<ResourceHint> excludes = new ArrayList<ResourceHint>();
    private final Map<String, SerializationHint> serialization = new LinkedHashMap<String, SerializationHint>();
    private final Map<String, JdkProxyHint> jdkProxys = new LinkedHashMap<String, JdkProxyHint>();
    private String applicationClassName;

    public Set<String> getArgs() {
        return this.args;
    }

    public List<ResourceHint> getIncludes() {
        return this.includes;
    }

    public String getApplicationClassName() {
        return this.applicationClassName;
    }

    public void setApplicationClassName(String applicationClassName) {
        this.applicationClassName = applicationClassName;
    }

    public RuntimeNativeMetadata registerArg(String ... args) {
        for (String arg : args) {
            this.args.add(arg);
        }
        return this;
    }

    public RuntimeNativeMetadata registerJdkProxy(Class<?> type) {
        return this.registerJdkProxy(type, null);
    }

    public RuntimeNativeMetadata registerJdkProxy(Class<?> type, String reachableType) {
        if (type.isInterface() && !type.isAnnotation()) {
            this.registerJdkProxyDo(type.getName(), reachableType);
        }
        return this;
    }

    private void registerJdkProxyDo(String typeName, String reachableType) {
        if (!this.jdkProxys.containsKey(typeName)) {
            JdkProxyHint proxyHint = new JdkProxyHint();
            proxyHint.setReachableType(reachableType);
            proxyHint.setInterfaces(Arrays.asList(typeName));
            this.jdkProxys.put(typeName, proxyHint);
        }
    }

    public RuntimeNativeMetadata registerReflection(String className, Consumer<ReflectionHints> typeHint) {
        if (Utils.isNotEmpty((String)className)) {
            ReflectionHints reflectionHints = this.reflection.computeIfAbsent(className, k -> {
                ReflectionHints hints = new ReflectionHints();
                hints.setName(className);
                return hints;
            });
            typeHint.accept(reflectionHints);
        }
        return this;
    }

    public RuntimeNativeMetadata registerReflection(Class<?> type, Consumer<ReflectionHints> typeHint) {
        return this.registerReflection(type.getName(), typeHint);
    }

    public RuntimeNativeMetadata registerReflection(Class<?> type, MemberCategory ... memberCategories) {
        return this.registerReflection(type, (ReflectionHints hints) -> hints.getMemberCategories().addAll(Arrays.asList(memberCategories)));
    }

    public RuntimeNativeMetadata registerReflection(String className, MemberCategory ... memberCategories) {
        return this.registerReflection(className, (ReflectionHints hints) -> hints.getMemberCategories().addAll(Arrays.asList(memberCategories)));
    }

    public RuntimeNativeMetadata registerField(Field field) {
        return this.registerReflection(field.getDeclaringClass(), (ReflectionHints hints) -> hints.getFields().add(field.getName()));
    }

    public RuntimeNativeMetadata registerConstructor(Constructor<?> constructor, ExecutableMode mode) {
        return this.registerReflection(constructor.getDeclaringClass(), (ReflectionHints hints) -> hints.getConstructors().add(new ExecutableHint("<init>", constructor.getParameterTypes(), mode)));
    }

    public RuntimeNativeMetadata registerMethod(Method method, ExecutableMode mode) {
        return this.registerReflection(method.getDeclaringClass(), (ReflectionHints hints) -> hints.getMethods().add(new ExecutableHint(method.getName(), method.getParameterTypes(), mode)));
    }

    public RuntimeNativeMetadata registerDefaultConstructor(Class<?> clazz) {
        return this.registerReflection(clazz, (ReflectionHints hint) -> hint.getConstructors().add(new ExecutableHint("<init>", null, ExecutableMode.INVOKE)));
    }

    public RuntimeNativeMetadata registerDefaultConstructor(String className) {
        return this.registerReflection(className, (ReflectionHints hint) -> hint.getConstructors().add(new ExecutableHint("<init>", null, ExecutableMode.INVOKE)));
    }

    public RuntimeNativeMetadata registerResourceInclude(String pattern) {
        return this.registerResourceInclude(pattern, null);
    }

    public RuntimeNativeMetadata registerResourceInclude(String pattern, String reachableType) {
        ResourceHint resourceHint = new ResourceHint();
        resourceHint.setReachableType(reachableType);
        resourceHint.setPattern(pattern);
        this.includes.add(resourceHint);
        return this;
    }

    public RuntimeNativeMetadata registerResourceExclude(String pattern) {
        return this.registerResourceExclude(pattern, null);
    }

    public RuntimeNativeMetadata registerResourceExclude(String pattern, String reachableType) {
        ResourceHint resourceHint = new ResourceHint();
        resourceHint.setReachableType(reachableType);
        resourceHint.setPattern(pattern);
        this.excludes.add(resourceHint);
        return this;
    }

    public RuntimeNativeMetadata registerSerialization(Package basePackage) {
        String dir = basePackage.getName().replace('.', '/');
        ScanUtil.scan((ClassLoader)JarClassLoader.global(), (String)dir, n -> n.endsWith(".class")).stream().forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            className = className.replace("/", ".");
            Class clz = ClassUtil.loadClass((ClassLoader)JarClassLoader.global(), (String)className);
            if (clz != null) {
                this.registerSerializationDo(clz.getName(), null);
            }
        });
        return this;
    }

    public RuntimeNativeMetadata registerSerialization(Class<?> type) {
        return this.registerSerialization(type, null);
    }

    public RuntimeNativeMetadata registerSerialization(Class<?> type, String reachableType) {
        this.registerSerializationDo(type.getName(), reachableType);
        return this;
    }

    private void registerSerializationDo(String typeName, String reachableType) {
        if (!this.serialization.containsKey(typeName)) {
            SerializationHint serializationHint = new SerializationHint();
            serializationHint.setName(typeName);
            serializationHint.setReachableType(reachableType);
            this.serialization.put(typeName, serializationHint);
        }
    }

    public String toReflectionJson() {
        if (this.reflection.isEmpty()) {
            return "";
        }
        ONode oNode = new ONode(this.jsonOptions).asArray();
        for (ReflectionHints hint : this.reflection.values()) {
            List introspect;
            List collect;
            List invoke;
            ONode item = oNode.addNew();
            item.set("name", (Object)hint.getName());
            if (Utils.isNotEmpty((String)hint.getReachableType())) {
                item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
            }
            if (!(invoke = (collect = Stream.concat(hint.getConstructors().stream(), hint.getMethods().stream()).collect(Collectors.toList())).stream().filter(h -> h.getMode().equals((Object)ExecutableMode.INVOKE)).collect(Collectors.toList())).isEmpty()) {
                ONode methods = item.getOrNew("methods").asArray();
                for (ExecutableHint executableHint : invoke) {
                    methods.addNew().set("name", (Object)executableHint.getName()).getOrNew("parameterTypes").asArray().addAll(executableHint.getParameterTypes());
                }
            }
            if (!(introspect = collect.stream().filter(h -> h.getMode().equals((Object)ExecutableMode.INTROSPECT)).collect(Collectors.toList())).isEmpty()) {
                ONode queriedMethods = item.getOrNew("queriedMethods").asArray();
                for (ExecutableHint executableHint : introspect) {
                    queriedMethods.addNew().set("name", (Object)executableHint.getName()).getOrNew("parameterTypes").asArray().addAll(executableHint.getParameterTypes());
                }
            }
            if (!hint.getFields().isEmpty()) {
                ONode on = item.getOrNew("fields").asArray();
                if (!hint.getFields().isEmpty()) {
                    for (String field : hint.getFields()) {
                        on.addNew().set("name", (Object)field);
                    }
                }
            }
            this.handleCategories(item, hint.getMemberCategories());
        }
        return oNode.toJson();
    }

    public String toResourcesJson() {
        ONode item;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            return "";
        }
        ONode oNode = new ONode(this.jsonOptions);
        ONode resources = oNode.getOrNew("resources");
        if (!this.includes.isEmpty()) {
            ONode includesNode = resources.getOrNew("includes").asArray();
            for (ResourceHint hint : this.includes) {
                item = includesNode.addNew().set("pattern", (Object)hint.getPattern());
                if (!Utils.isNotEmpty((String)hint.getReachableType())) continue;
                item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
            }
        }
        if (!this.excludes.isEmpty()) {
            ONode excludesNode = resources.getOrNew("excludes").asArray();
            for (ResourceHint hint : this.excludes) {
                item = excludesNode.addNew().set("pattern", (Object)hint.getPattern());
                if (!Utils.isNotEmpty((String)hint.getReachableType())) continue;
                item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
            }
        }
        return oNode.toJson();
    }

    public String toSerializationJson() {
        if (this.serialization.isEmpty()) {
            return "";
        }
        ONode oNode = new ONode(this.jsonOptions).asArray();
        for (SerializationHint hint : this.serialization.values()) {
            ONode item = oNode.addNew().set("name", (Object)hint.getName());
            if (!Utils.isNotEmpty((String)hint.getReachableType())) continue;
            item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
        }
        return oNode.toJson();
    }

    public String toJdkProxyJson() {
        if (this.jdkProxys.isEmpty()) {
            return "";
        }
        ONode oNode = new ONode(this.jsonOptions).asArray();
        for (JdkProxyHint hint : this.jdkProxys.values()) {
            if (Utils.isEmpty(hint.getInterfaces())) continue;
            ONode item = oNode.addNew();
            item.set("interfaces", hint.getInterfaces());
            if (!Utils.isNotEmpty((String)hint.getReachableType())) continue;
            item.getOrNew("condition").set("typeReachable", (Object)hint.getReachableType());
        }
        return oNode.toJson();
    }

    private void handleCategories(ONode attributes, Set<MemberCategory> categories) {
        if (categories.isEmpty()) {
            return;
        }
        for (MemberCategory category : categories) {
            switch (category) {
                case PUBLIC_FIELDS: {
                    attributes.set("allPublicFields", (Object)true);
                    break;
                }
                case DECLARED_FIELDS: {
                    attributes.set("allDeclaredFields", (Object)true);
                    break;
                }
                case INTROSPECT_PUBLIC_CONSTRUCTORS: {
                    attributes.set("queryAllPublicConstructors", (Object)true);
                    break;
                }
                case INTROSPECT_DECLARED_CONSTRUCTORS: {
                    attributes.set("queryAllDeclaredConstructors", (Object)true);
                    break;
                }
                case INVOKE_PUBLIC_CONSTRUCTORS: {
                    attributes.set("allPublicConstructors", (Object)true);
                    break;
                }
                case INVOKE_DECLARED_CONSTRUCTORS: {
                    attributes.set("allDeclaredConstructors", (Object)true);
                    break;
                }
                case INTROSPECT_PUBLIC_METHODS: {
                    attributes.set("queryAllPublicMethods", (Object)true);
                    break;
                }
                case INTROSPECT_DECLARED_METHODS: {
                    attributes.set("queryAllDeclaredMethods", (Object)true);
                    break;
                }
                case INVOKE_PUBLIC_METHODS: {
                    attributes.set("allPublicMethods", (Object)true);
                    break;
                }
                case INVOKE_DECLARED_METHODS: {
                    attributes.set("allDeclaredMethods", (Object)true);
                    break;
                }
                case PUBLIC_CLASSES: {
                    attributes.set("allPublicClasses", (Object)true);
                    break;
                }
                case DECLARED_CLASSES: {
                    attributes.set("allDeclaredClasses", (Object)true);
                }
            }
        }
    }
}

