/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot.graalvm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.aot.graalvm.TypeUtil;
import org.noear.solon.aot.hint.ExecutableHint;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ReflectUtil;
import org.noear.solon.core.util.ResourceUtil;

public class GraalvmUtil {
    public static final String NATIVE_IMAGE_DIR = "META-INF/native-image";
    public static final String SOLON_RESOURCE_NAME = "solon-resource.json";
    private static final Set<String> resources = new HashSet<String>();
    private static final Map<String, Set<String>> classFieldNames = new HashMap<String, Set<String>>();
    private static final Map<Class<?>, Set<Field>> classFields = new HashMap();
    private static final Map<String, Set<ExecutableHint>> classExecutable = new HashMap<String, Set<ExecutableHint>>();
    private static final Map<Class<?>, Set<Method>> classMethods = new HashMap();

    public static String getNativeImageDir() {
        String packageName = Solon.cfg().source().getPackage().getName();
        return "META-INF/native-image/" + packageName.replace('.', '/');
    }

    public static String getSolonResourcePath() {
        return GraalvmUtil.getNativeImageDir() + "/" + SOLON_RESOURCE_NAME;
    }

    public static Field[] getDeclaredFields(Class<?> clz) {
        Set<Field> fieldSet = classFields.get(clz);
        if (fieldSet != null) {
            return fieldSet.toArray(new Field[0]);
        }
        Set<String> fieldNames = classFieldNames.get(ReflectUtil.getClassName(clz));
        if (fieldNames == null) {
            return clz.getDeclaredFields();
        }
        Set<Field> fields = fieldNames.stream().map(e -> {
            try {
                return clz.getDeclaredField((String)e);
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toSet());
        classFields.put(clz, fields);
        return fields.toArray(new Field[0]);
    }

    public static Method[] getDeclaredMethods(Class<?> clz) {
        Set<Method> methods = classMethods.get(clz);
        if (methods != null) {
            return methods.toArray(new Method[0]);
        }
        Set<ExecutableHint> executableHints = classExecutable.get(ReflectUtil.getClassName(clz));
        if (executableHints == null) {
            return clz.getDeclaredMethods();
        }
        Set<Method> methodSet = executableHints.stream().filter(e -> !"<init>".equals(e.getName())).map(e -> {
            try {
                List<String> types = e.getParameterTypes();
                if (types == null || types.isEmpty()) {
                    return clz.getDeclaredMethod(e.getName(), new Class[0]);
                }
                Class[] classes = (Class[])types.stream().map(type -> {
                    try {
                        return TypeUtil.forName(type, (ClassLoader)JarClassLoader.global());
                    }
                    catch (Exception ex) {
                        return new RuntimeException(ex);
                    }
                }).toArray(Class[]::new);
                return clz.getDeclaredMethod(e.getName(), classes);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toSet());
        classMethods.put(clz, methodSet);
        return methodSet.toArray(new Method[0]);
    }

    public static void scanResource(String path, Predicate<String> filter, Set<String> urls) {
        for (String f : resources) {
            if (!f.startsWith(path) || !filter.test(f)) continue;
            urls.add(f);
        }
    }

    private static void readNativeReflectConfig() {
        try {
            List loaderList = ExtendLoader.load((String)Solon.cfg().extend(), (boolean)false);
            for (ClassLoader loader : loaderList) {
                Enumeration rs = ResourceUtil.getResources((ClassLoader)loader, (String)(GraalvmUtil.getNativeImageDir() + "/reflect-config.json"));
                while (rs.hasMoreElements()) {
                    String s = GraalvmUtil.readFileByLines((URL)rs.nextElement());
                    ONode o = ONode.loadStr((String)s);
                    o.forEach(on -> {
                        String className = on.get("name").getString();
                        String name = className.replaceAll("\\.", "/") + ".class";
                        resources.add(name);
                        LinkedHashSet fields = new LinkedHashSet();
                        on.get("fields").forEach(f -> {
                            String fieldName = f.get("name").getString();
                            fields.add(fieldName);
                        });
                        classFieldNames.put(className, fields);
                        LinkedHashSet executableHints = new LinkedHashSet();
                        on.get("methods").forEach(f -> {
                            String methodName = f.get("name").getString();
                            ArrayList<String> parameterTypes = new ArrayList<String>();
                            f.get("parameterTypes").asArray().forEach(p -> {
                                String parameterType = p.getString();
                                parameterTypes.add(parameterType);
                            });
                            ExecutableHint executableHint = new ExecutableHint(methodName, parameterTypes);
                            executableHints.add(executableHint);
                        });
                        classExecutable.put(className, executableHints);
                    });
                }
            }
            if (Solon.cfg().isDebugMode()) {
                LogUtil.global().info("reflect-config: load completed: " + resources);
            }
        }
        catch (Exception e) {
            LogUtil.global().warn("reflect-config: read error: " + e.getLocalizedMessage());
            EventBus.pushTry((Object)e);
        }
    }

    private static void readNativeResourceConfig() {
        try {
            List loaderList = ExtendLoader.load((String)Solon.cfg().extend(), (boolean)false);
            String solonResource = GraalvmUtil.getSolonResourcePath();
            for (ClassLoader loader : loaderList) {
                Enumeration rs = ResourceUtil.getResources((ClassLoader)loader, (String)solonResource);
                while (rs.hasMoreElements()) {
                    String s = GraalvmUtil.readFileByLines((URL)rs.nextElement());
                    ONode o = ONode.loadStr((String)s);
                    o.forEach(on -> {
                        String name = on.getString();
                        resources.add(name);
                    });
                }
            }
            if (Solon.cfg().isDebugMode()) {
                LogUtil.global().info(solonResource + ": load completed: " + resources);
            }
        }
        catch (Exception e) {
            LogUtil.global().warn("resource-config: read error: " + e.getLocalizedMessage());
            EventBus.pushTry((Object)e);
        }
    }

    public static String readFileByLines(URL url) {
        StringBuilder buf = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                buf.append(tempString).append("\r\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    static {
        GraalvmUtil.readNativeResourceConfig();
        GraalvmUtil.readNativeReflectConfig();
    }
}

