/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jlhttp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Utils;
import org.noear.solon.boot.jlhttp.HTTPServer;
import org.noear.solon.boot.jlhttp.MultipartUtil;
import org.noear.solon.boot.web.ContextBase;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IgnoreCaseMap;

public class JlHttpContext
extends ContextBase {
    private HTTPServer.Request _request;
    private HTTPServer.Response _response;
    protected Map<String, List<UploadedFile>> _fileMap;
    private boolean _isAsync;
    private long _asyncTimeout = 30000L;
    private CompletableFuture<Object> _asyncFuture;
    private List<ContextAsyncListener> _asyncListeners = new ArrayList<ContextAsyncListener>();
    private boolean _loadMultipartFormData = false;
    private String _ip;
    private URI _uri;
    private String _url;
    private NvMap _paramMap;
    private Map<String, List<String>> _paramsMap;
    private NvMap _cookieMap;
    private NvMap _headerMap;
    private Map<String, List<String>> _headersMap;
    private ByteArrayOutputStream _outputStreamTmp;
    private int _status = 200;
    private boolean _allows_write = true;

    protected boolean innerIsAsync() {
        return this._isAsync;
    }

    public JlHttpContext(HTTPServer.Request request, HTTPServer.Response response) {
        this._request = request;
        this._response = response;
        this._fileMap = new HashMap<String, List<UploadedFile>>();
    }

    private void loadMultipartFormData() throws IOException {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            MultipartUtil.buildParamsAndFiles(this);
        }
    }

    public Object request() {
        return this._request;
    }

    public String ip() {
        if (this._ip == null) {
            this._ip = this.header("X-Forwarded-For");
            if (this._ip == null) {
                this._ip = this._request.getSocket().getInetAddress().getHostAddress();
            }
        }
        return this._ip;
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getVersion();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String url() {
        if (this._url == null) {
            this._url = this._request.getURI().toString();
            if (this._url != null) {
                int idx;
                if (this._url.startsWith("/")) {
                    String host = this.header("Host");
                    if (host == null) {
                        host = this.header(":authority");
                        String scheme = this.header(":scheme");
                        if (host == null) {
                            host = "localhost";
                        }
                        this._url = scheme != null ? "https://" + host + this._url : scheme + "://" + host + this._url;
                    } else {
                        this._url = "http://" + host + this._url;
                    }
                }
                if ((idx = this._url.indexOf("?")) > 0) {
                    this._url = this._url.substring(0, idx);
                }
            }
        }
        return this._url;
    }

    public long contentLength() {
        try {
            return this._request.getBody().available();
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
            return 0L;
        }
    }

    public String queryString() {
        return this._request.getURI().getQuery();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getBody();
    }

    public String[] paramValues(String key) {
        List<String> list = this.paramsMap().get(key);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public String param(String key) {
        return (String)this.paramMap().get((Object)key);
    }

    public NvMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new NvMap();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                this._paramMap.putAll(this._request.getParams());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return this._paramMap;
    }

    public Map<String, List<String>> paramsMap() {
        if (this._paramsMap == null) {
            this._paramsMap = new LinkedHashMap<String, List<String>>();
            try {
                for (String[] kv : this._request.getParamsList()) {
                    List<String> list = this._paramsMap.get(kv[0]);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this._paramsMap.put(kv[0], list);
                    }
                    list.add(kv[1]);
                }
            }
            catch (Exception e) {
                EventBus.pushTry((Object)e);
                return null;
            }
        }
        return this._paramsMap;
    }

    public Map<String, List<UploadedFile>> filesMap() throws IOException {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
            return this._fileMap;
        }
        return Collections.emptyMap();
    }

    public NvMap cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new NvMap(this._request.getHeaders().getParams("Cookie"));
        }
        return this._cookieMap;
    }

    public NvMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new NvMap();
            HTTPServer.Headers headers = this._request.getHeaders();
            if (headers != null) {
                for (HTTPServer.Header h : headers) {
                    this._headerMap.put(h.getName(), (Object)h.getValue());
                }
            }
        }
        return this._headerMap;
    }

    public Map<String, List<String>> headersMap() {
        if (this._headersMap == null) {
            this._headersMap = new IgnoreCaseMap();
            HTTPServer.Headers headers = this._request.getHeaders();
            if (headers != null) {
                for (HTTPServer.Header h : headers) {
                    List<String> values = this._headersMap.get(h.getName());
                    if (values == null) {
                        values = new ArrayList<String>();
                        this._headersMap.put(h.getName(), values);
                    }
                    values.add(h.getValue());
                }
            }
        }
        return this._headersMap;
    }

    public Object response() {
        return this._response;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        if (this._allows_write) {
            return this._response.getBody();
        }
        if (this._outputStreamTmp == null) {
            this._outputStreamTmp = new ByteArrayOutputStream();
        } else {
            this._outputStreamTmp.reset();
        }
        return this._outputStreamTmp;
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            Utils.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.getHeaders().replace(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.getHeaders().add(key, val);
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append("=").append(val).append(";");
        if (Utils.isNotEmpty((String)path)) {
            sb.append("path=").append(path).append(";");
        }
        if (maxAge >= 0) {
            sb.append("max-age=").append(maxAge).append(";");
        }
        if (Utils.isNotEmpty((String)domain)) {
            sb.append("domain=").append(domain.toLowerCase()).append(";");
        }
        this.headerAdd("Set-Cookie", sb.toString());
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream();
            this._response.flush();
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncStart(long timeout, ContextAsyncListener listener) {
        if (!this._isAsync) {
            this._isAsync = true;
            this._asyncFuture = new CompletableFuture();
            if (listener != null) {
                this._asyncListeners.add(listener);
            }
            if (timeout != 0L) {
                this._asyncTimeout = timeout;
            }
        }
    }

    public void asyncComplete() throws IOException {
        if (this._isAsync) {
            try {
                this.innerCommit();
            }
            finally {
                this._asyncFuture.complete((Object)this);
            }
        }
    }

    protected void asyncAwait() throws InterruptedException, ExecutionException, IOException {
        if (this._isAsync) {
            if (this._asyncTimeout > 0L) {
                try {
                    this._asyncFuture.get(this._asyncTimeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    for (ContextAsyncListener listener1 : this._asyncListeners) {
                        listener1.onTimeout((Context)this);
                    }
                }
            } else {
                this._asyncFuture.get();
            }
        }
    }

    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            this.sendHeaders(true);
        } else if (!this._response.headersSent()) {
            this._response.sendError(404);
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._response.headersSent()) {
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            if (isCommit || !this._allows_write) {
                this._response.sendHeaders(this.status(), 0L, -1L, null, null, null);
            } else {
                String tmp = this._response.getHeaders().get("Content-Length");
                if (tmp != null) {
                    this._response.sendHeaders(this.status(), Long.parseLong(tmp), -1L, null, null, null);
                } else {
                    this._response.sendHeaders(this.status(), -1L, -1L, null, null, null);
                }
            }
        }
    }
}

