/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.SocketServerProps;
import org.noear.solon.boot.socketd.netty.NioServerProcessor;
import org.noear.solon.boot.socketd.netty._SessionManagerImpl;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.socketd.SessionManager;
import org.noear.solon.socketd.client.netty.NioChannelInitializer;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    ChannelFuture _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "netty-socketd 4.1.68/" + Solon.version();
    }

    public void start(AopContext context) {
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        if (!Solon.app().enableSocketD()) {
            return;
        }
        context.lifecycle(-99, () -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) {
        ServerProps.init();
        long time_start = System.currentTimeMillis();
        SocketServerProps props = new SocketServerProps(20000);
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        NioEventLoopGroup parentGroup = new NioEventLoopGroup();
        NioEventLoopGroup childGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group((EventLoopGroup)parentGroup, (EventLoopGroup)childGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new NioChannelInitializer(() -> new NioServerProcessor()));
            this._server = Utils.isEmpty((String)_host) ? bootstrap.bind(_port).await() : bootstrap.bind(_host, _port).await();
            String _wrapHost = props.getWrapHost();
            int _wrapPort = props.getWrapPort();
            _signal = new SignalSim(_name, _wrapHost, _wrapPort, "tcp", SignalType.SOCKET);
            app.signalAdd(_signal);
            long time_end = System.currentTimeMillis();
            LogUtil.global().info("Connector:main: netty-socketd: Started ServerConnector@{[Socket]}{0.0.0.0:" + _port + "}");
            LogUtil.global().info("Server:main: netty-socketd: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
        }
        catch (RuntimeException e) {
            parentGroup.shutdownGracefully();
            childGroup.shutdownGracefully();
            throw e;
        }
        catch (Throwable e) {
            parentGroup.shutdownGracefully();
            childGroup.shutdownGracefully();
            throw new IllegalStateException(e);
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.channel().close();
        this._server = null;
        LogUtil.global().info("Server:main: netty-socketd: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
    }
}

