/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.http.HttpPartFile;
import org.noear.solon.boot.io.LimitedInputException;
import org.noear.solon.boot.io.LimitedInputStream;
import org.noear.solon.boot.web.uploadfile.HttpMultipart;
import org.noear.solon.boot.web.uploadfile.HttpMultipartCollection;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.UploadedFile;

public class BodyUtils {
    public static void decodeMultipart(Context ctx, Map<String, List<UploadedFile>> filesMap) {
        try {
            HttpMultipartCollection parts = new HttpMultipartCollection(ctx.contentType(), ctx.bodyAsStream());
            while (parts.hasNext()) {
                HttpMultipart part = parts.next();
                String name = ServerProps.urlDecode(part.getName());
                if (BodyUtils.isFile(part)) {
                    BodyUtils.doBuildFiles(name, filesMap, part);
                    continue;
                }
                ctx.paramSet(name, part.getString());
            }
        }
        catch (Exception e) {
            throw BodyUtils.status4xx(ctx, e);
        }
    }

    private static void doBuildFiles(String name, Map<String, List<UploadedFile>> filesMap, HttpMultipart part) throws IOException {
        List<UploadedFile> list = filesMap.get(name);
        if (list == null) {
            list = new ArrayList<UploadedFile>();
            filesMap.put(name, list);
        }
        String contentType = part.getHeaders().get("Content-Type");
        String filename = part.getFilename();
        String extension = null;
        int idx = filename.lastIndexOf(".");
        if (idx > 0) {
            extension = filename.substring(idx + 1);
        }
        HttpPartFile partFile = new HttpPartFile(filename, new LimitedInputStream(part.getBody(), ServerProps.request_maxFileSize));
        UploadedFile f1 = new UploadedFile(partFile::delete, contentType, partFile.getSize(), partFile.getContent(), filename, extension);
        list.add(f1);
    }

    private static boolean isField(HttpMultipart filePart) {
        return filePart.getFilename() == null;
    }

    private static boolean isFile(HttpMultipart filePart) {
        return !BodyUtils.isField(filePart);
    }

    public static void decodeFormUrlencoded(Context ctx) throws IOException {
        BodyUtils.decodeFormUrlencoded(ctx, true);
    }

    public static void decodeFormUrlencoded(Context ctx, boolean excludePost) throws IOException {
        String[] ss;
        if (excludePost && MethodType.POST.name.equals(ctx.method())) {
            return;
        }
        if (!ctx.isFormUrlencoded()) {
            return;
        }
        if (Utils.isEmpty((String)ctx.bodyNew())) {
            return;
        }
        for (String s1 : ss = ctx.bodyNew().split("&")) {
            int idx = s1.indexOf(61);
            if (idx <= 0) continue;
            String name = ServerProps.urlDecode(s1.substring(0, idx));
            String value = ServerProps.urlDecode(s1.substring(idx + 1));
            ctx.paramSet(name, value);
        }
    }

    public static StatusException status4xx(Context ctx, Exception e) {
        if (e instanceof StatusException) {
            return (StatusException)e;
        }
        if (BodyUtils.isBodyLargerEx(e)) {
            return new StatusException("Request Entity Too Large: " + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 413);
        }
        return new StatusException("Bad Request:" + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 400);
    }

    public static boolean isBodyLargerEx(Throwable e) {
        return BodyUtils.hasLargerStr(e) || BodyUtils.hasLargerStr(e.getCause());
    }

    private static boolean hasLargerStr(Throwable e) {
        return e instanceof LimitedInputException;
    }
}

