/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health.detector.impl;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.noear.solon.health.detector.AbstractDetector;
import org.noear.solon.health.detector.util.SizeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskDetector
extends AbstractDetector {
    static final Logger log = LoggerFactory.getLogger(DiskDetector.class);
    private static final Pattern linuxDiskPattern = Pattern.compile("\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+%)\\s+(/.*)", 42);
    private static final Pattern linuxTotalDistPattern = Pattern.compile("\\s+([\\d]+)\\s+(\\s+)", 42);
    private static final Pattern macDiskPattern = Pattern.compile("\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+%)\\s+\\d+\\s+\\d+\\s+\\d+%\\s+(/.*)", 42);

    @Override
    public String getName() {
        return "disk";
    }

    @Override
    public Map<String, Object> getInfo() {
        LinkedHashMap details = new LinkedHashMap();
        long totals = 0L;
        long totalUsed = 0L;
        boolean isMac = osName.indexOf("mac os") > -1;
        File[] rootFiles = File.listRoots();
        if (isMac) {
            rootFiles = new File("/Volumes").listFiles();
        }
        for (File file : rootFiles) {
            HashMap<String, String> disk = new HashMap<String, String>();
            long total = file.getTotalSpace();
            long free = file.getFreeSpace();
            long used = total - free;
            totals += total;
            totalUsed += used;
            String ratio = (total > 0L ? used * 100L / total : 0L) + "%";
            disk.put("total", SizeUtil.formatByteSize(total));
            disk.put("free", SizeUtil.formatByteSize(free));
            disk.put("used", SizeUtil.formatByteSize(used));
            disk.put("ratio", ratio);
            String path = isMac ? file.getPath().replace("/Volumes/", "") : file.getPath();
            details.put(path, disk);
        }
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put("total", SizeUtil.formatByteSize(totals));
        info.put("used", SizeUtil.formatByteSize(totalUsed));
        info.put("details", details);
        return info;
    }
}

