/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.message;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;

public class ListenerPipeline
implements Listener {
    private List<Listener> chain = new LinkedList<Listener>();

    public ListenerPipeline next(Listener listener) {
        this.chain.add(listener);
        return this;
    }

    public ListenerPipeline prev(Listener listener) {
        this.chain.add(0, listener);
        return this;
    }

    @Override
    public void onOpen(Session session) {
        for (Listener l : this.chain) {
            l.onOpen(session);
        }
    }

    @Override
    public void onMessage(Session session, Message message) throws IOException {
        for (Listener l : this.chain) {
            l.onMessage(session, message);
        }
    }

    @Override
    public void onClose(Session session) {
        for (Listener l : this.chain) {
            l.onClose(session);
        }
    }

    @Override
    public void onError(Session session, Throwable error) {
        for (Listener l : this.chain) {
            l.onError(session, error);
        }
    }
}

