/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.ActionExecuteHandlerDefault;
import org.noear.solon.core.handle.ActionReturnHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.SessionStateEmpty;
import org.noear.solon.core.handle.SessionStateFactory;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChainImpl;
import org.noear.solon.core.route.RouterInterceptorLimiter;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.lang.Nullable;

public class ChainManager {
    private final Set<Class<?>> typeSet = new HashSet();
    private final List<RankEntity<Filter>> filterNodes = new ArrayList<RankEntity<Filter>>();
    private final List<RankEntity<RouterInterceptor>> interceptorNodes = new ArrayList<RankEntity<RouterInterceptor>>();
    private final Map<Class<?>, ActionReturnHandler> returnHandlers = new LinkedHashMap();
    private ActionExecuteHandler executeHandlerDefault = new ActionExecuteHandlerDefault();
    private Map<Class<?>, ActionExecuteHandler> executeHandlers = new LinkedHashMap();
    private static SessionStateFactory _sessionStateFactory = ctx -> new SessionStateEmpty();
    private static boolean _sessionStateUpdated;

    public Collection<Filter> getFilterNodes() {
        ArrayList<Filter> tmp = new ArrayList<Filter>();
        for (RankEntity<Filter> entity : this.filterNodes) {
            tmp.add((Filter)entity.target);
        }
        return tmp;
    }

    public synchronized void addFilter(Filter filter, int index) {
        this.typeSet.add(filter.getClass());
        this.filterNodes.add(new RankEntity<Filter>(filter, index));
        this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public synchronized void addFilterIfAbsent(Filter filter, int index) {
        if (this.typeSet.contains(filter.getClass())) {
            return;
        }
        this.typeSet.add(filter.getClass());
        this.filterNodes.add(new RankEntity<Filter>(filter, index));
        this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public void doFilter(Context x) throws Throwable {
        new FilterChainImpl(this.filterNodes).doFilter(x);
    }

    public Collection<RouterInterceptor> getInterceptorNodes() {
        ArrayList<RouterInterceptor> tmp = new ArrayList<RouterInterceptor>();
        for (RankEntity<RouterInterceptor> entity : this.interceptorNodes) {
            if (entity.target instanceof RouterInterceptorLimiter) {
                tmp.add(((RouterInterceptorLimiter)entity.target).getInterceptor());
                continue;
            }
            tmp.add((RouterInterceptor)entity.target);
        }
        return tmp;
    }

    public synchronized void addInterceptor(RouterInterceptor interceptor, int index) {
        this.typeSet.add(interceptor.getClass());
        interceptor = new RouterInterceptorLimiter(interceptor, interceptor.pathPatterns());
        this.interceptorNodes.add(new RankEntity<RouterInterceptor>(interceptor, index));
        this.interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public synchronized void addInterceptorIfAbsent(RouterInterceptor interceptor, int index) {
        if (this.typeSet.contains(interceptor.getClass())) {
            return;
        }
        this.typeSet.add(interceptor.getClass());
        interceptor = new RouterInterceptorLimiter(interceptor, interceptor.pathPatterns());
        this.interceptorNodes.add(new RankEntity<RouterInterceptor>(interceptor, index));
        this.interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public synchronized <T extends RouterInterceptor> void removeInterceptor(Class<T> clz) {
        this.typeSet.add(clz);
        this.interceptorNodes.removeIf(i -> {
            if (i.target instanceof RouterInterceptorLimiter) {
                return ((RouterInterceptorLimiter)i.target).getInterceptor().getClass() == clz;
            }
            return ((RouterInterceptor)i.target).getClass() == clz;
        });
    }

    public void doIntercept(Context x, @Nullable Handler mainHandler) throws Throwable {
        new RouterInterceptorChainImpl(this.interceptorNodes).doIntercept(x, mainHandler);
    }

    public Object postResult(Context x, @Nullable Object result) throws Throwable {
        for (int i = this.interceptorNodes.size() - 1; i >= 0; --i) {
            RankEntity<RouterInterceptor> e = this.interceptorNodes.get(i);
            result = ((RouterInterceptor)e.target).postResult(x, result);
        }
        return result;
    }

    public void addReturnHandler(ActionReturnHandler e) {
        if (e != null) {
            this.returnHandlers.put(e.getClass(), e);
        }
    }

    public ActionReturnHandler getReturnHandler(Class<?> returnType) {
        for (ActionReturnHandler handler : this.returnHandlers.values()) {
            if (!handler.matched(returnType)) continue;
            return handler;
        }
        return null;
    }

    public void defExecuteHandler(ActionExecuteHandler e) {
        if (e != null) {
            this.executeHandlerDefault = e;
        }
    }

    public void addExecuteHandler(ActionExecuteHandler e) {
        if (e != null) {
            this.executeHandlers.put(e.getClass(), e);
        }
    }

    public void removeExecuteHandler(Class<?> clz) {
        this.executeHandlers.remove(clz);
    }

    public ActionExecuteHandler getExecuteHandler(Context c, int paramSize) {
        String ct = c.contentType();
        if (ct != null && paramSize > 0) {
            for (ActionExecuteHandler me : this.executeHandlers.values()) {
                if (!me.matched(c, ct)) continue;
                return me;
            }
        }
        return this.executeHandlerDefault;
    }

    public ActionExecuteHandler getExecuteHandlerDefault() {
        return this.executeHandlerDefault;
    }

    public static SessionStateFactory getSessionStateFactory() {
        return _sessionStateFactory;
    }

    public static void setSessionStateFactory(SessionStateFactory ssf) {
        if (ssf != null) {
            _sessionStateFactory = ssf;
            if (!_sessionStateUpdated) {
                _sessionStateUpdated = true;
                Solon.app().before("**", MethodType.HTTP, c -> c.sessionState().sessionRefresh());
            }
        }
    }

    public static SessionState getSessionState(Context ctx) {
        return _sessionStateFactory.create(ctx);
    }
}

