/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.exception.InjectionException;

public class InjectGather
implements Runnable {
    private List<VarHolder> vars;
    private int varSize;
    private boolean done;
    private Consumer<Object[]> onDone;
    private boolean requireRun;
    private Class<?> outType;
    public int index;

    public InjectGather(Class<?> outType, boolean requireRun, int varSize, Consumer<Object[]> onDone) {
        this.requireRun = requireRun;
        this.onDone = onDone;
        this.varSize = varSize;
        this.vars = new ArrayList<VarHolder>(varSize);
        this.outType = outType;
    }

    public boolean isDone() {
        return this.done;
    }

    public Class<?> getOutType() {
        return this.outType;
    }

    public List<VarHolder> getVars() {
        return this.vars;
    }

    public void add(VarHolder p) {
        this.vars.add(p);
    }

    @Override
    public synchronized void run() {
        if (this.done) {
            return;
        }
        for (VarHolder p1 : this.vars) {
            if (p1.isDone()) continue;
            return;
        }
        if (this.vars.size() != this.varSize) {
            return;
        }
        this.done = true;
        if (this.onDone != null) {
            ArrayList<Object> args = new ArrayList<Object>(this.vars.size());
            for (VarHolder p1 : this.vars) {
                args.add(p1.getValue());
            }
            this.onDone.accept(args.toArray());
        }
    }

    public synchronized void check() throws Exception {
        if (this.done) {
            return;
        }
        if (this.vars.size() != this.varSize) {
            return;
        }
        for (VarHolder p1 : this.vars) {
            if (p1.isDone() || !p1.required()) continue;
            throw new InjectionException("Required injection failed: " + p1.getFullName());
        }
        if (this.onDone != null && this.requireRun) {
            ArrayList<Object> args = new ArrayList<Object>(this.vars.size());
            for (VarHolder p1 : this.vars) {
                args.add(p1.getValue());
            }
            this.done = true;
            this.onDone.accept(args.toArray());
        }
    }
}

